/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file monster.hpp
 * \brief The base of a monster.
 * \author Sebastien Angibaud
 */
#ifndef __PTB_MONSTER_HPP__
#define __PTB_MONSTER_HPP__

#include <vector>
#include <string>
#include "universe/types.hpp"
#include "universe/collision_info.hpp"
#include "engine/base_item.hpp"

namespace ptb
{
  /**
   * \brief The different type of monster.
   */
  class monster
  {
  public:
     /** \brief The different categories of monster. */
    enum monster_type
      {
        player_1_monster = 0,
        player_2_monster,
        player_3_monster,
        enemy_monster,
        stone_1_monster,
        stone_2_monster,
        stone_3_monster,
        nature_monster
      }; // enum monster_type

    enum attack_type
      {
        normal_attack = 0,
        water_attack,
        fire_attack,
        air_attack,
        indefensible_attack
      }; // enum attack_type

    /** \brief The number of attacks. */
    static const unsigned int s_attack_count;

  public:
    monster();
    virtual ~monster();

    bool receive_an_attack( monster& attacker,
                            const bear::universe::collision_info& info );

    virtual void set_invincible(const bool invincible);
    bool is_invincible() const;
    void set_offensive_phase(const bool offensive_phase);
    bool get_offensive_phase() const;
    void set_defensive_power(const attack_type index, const bool statut);
    bool get_defensive_power(const attack_type index) const;
    void set_offensive_coefficient
    (const attack_type index, const unsigned int coef);

    monster_type get_monster_type() const;
    void set_monster_type(monster_type m);
    double get_energy() const;
    void set_energy(double energy);
    double get_initial_energy() const;
    bool is_injured() const;

    bool is_in_offensive_phase() const;

  protected:
    void to_string( std::string& str ) const;

  private:
    virtual void remove_energy(const monster& attacker, double energy );

  protected:
    bool is_vulnerable
    ( monster& attacker, const bear::universe::collision_info& info ) const;
    virtual void injure(const monster& attacker,
                        const bear::universe::collision_info& info);
    virtual void finish_injure();
    virtual void has_attacked(const monster& other);
    virtual bool get_defensive_power
    ( unsigned int index, const monster& attacker,
      const bear::universe::collision_info& info ) const;
    virtual unsigned int get_offensive_coefficient
    ( unsigned int index,
      const monster& attacker,
      const bear::universe::collision_info& info ) const;

  protected:
    /** \brief Force of attack. */
    unsigned int m_offensive_force;

    /** \brief Remaining energy of the monster. */
    double m_energy;

    /** \brief The initial energy of the monster. */
    double m_initial_energy;

    /** \brief Indicate if the monster is in an offensive phase. */
    bool m_offensive_phase;

    /** \brief The vector of defensive powers. */
    std::vector<bool> m_defensive_powers;

    /** \brief The vector of the offensive coefficients. */
    std::vector<unsigned int> m_offensive_coefficients;

    /** \brief Indicates if the monster is invincible. */
    bool m_invincible;

    /** \brief Which kind of monster am I ? */
    monster_type m_monster_type;

    /** \brief Indicates if the monster is injured. */
    bool m_is_injured;

    /** \brief Indicates the time of the attack. */
    bear::universe::time_type m_injured_time;

  }; // class monster
} // namespace ptb

#endif // __PTB_MONSTER_HPP__
