/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file binary_boolean_expression.cpp
 * \brief Implementation of the bear::expr::binary_boolean_expression class.
 * \author Julien Jorge.
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 */
template<typename F>
bear::expr::binary_boolean_expression<F>::binary_boolean_expression()
{

} // binary_boolean_expression::binary_boolean_expression()

/*----------------------------------------------------------------------------*/
/**
 * \brief Copy contructor.
 */
template<typename F>
bear::expr::binary_boolean_expression<F>::binary_boolean_expression
(const binary_boolean_expression<F>& that)
  : m_left(that.m_left), m_right(that.m_right)
{
} // binary_boolean_expression::binary_boolean_expression()

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 * \param left The left operand.
 * \param right The right operand.
 */
template<typename F>
bear::expr::binary_boolean_expression<F>::binary_boolean_expression
( const boolean_expression& left, const boolean_expression& right )
  : m_left(left), m_right(right)
{

} // binary_boolean_expression::binary_boolean_expression()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the left operand.
 */
template<typename F>
const bear::expr::boolean_expression&
bear::expr::binary_boolean_expression<F>::get_left_operand() const
{
  return m_left;
} // binary_boolean_expression::get_left_operand()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the left operand.
 * \param op The operand.
 */
template<typename F>
void bear::expr::binary_boolean_expression<F>::set_left_operand
( const boolean_expression& op )
{
  m_left = op;
} // binary_boolean_expression::set_left_operand()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the right operand.
 */
template<typename F>
const bear::expr::boolean_expression&
bear::expr::binary_boolean_expression<F>::get_right_operand() const
{
  return m_right;
} // binary_boolean_expression::get_right_operand()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the right operand.
 * \param op The operand.
 */
template<typename F>
void bear::expr::binary_boolean_expression<F>::set_right_operand
( const boolean_expression& op )
{
  m_right = op;
} // binary_boolean_expression::set_right_operand()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create a copy of this expression.
 */
template<typename F>
bear::expr::base_boolean_expression*
bear::expr::binary_boolean_expression<F>::clone() const
{
  return new binary_boolean_expression<F>(*this);
} // binary_boolean_expression::clone()

/*----------------------------------------------------------------------------*/
/**
 * \brief Evaluate the expression.
 */
template<typename F>
bool bear::expr::binary_boolean_expression<F>::evaluate() const
{
  F f;
  return f(get_left_operand().evaluate(), get_right_operand().evaluate());
} // binary_boolean_expression::evaluate()
