/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file message.hpp
 * \brief Base class for message events.
 * \author Julien Jorge
 */
#ifndef __COMMUNICATION_MESSAGE_HPP__
#define __COMMUNICATION_MESSAGE_HPP__

#include "communication/class_export.hpp"

namespace bear
{
  namespace communication
  {
    class messageable;

    /**
     * \brief Base class for message events.
     * \author Julien Jorge
     */
    class COMMUNICATION_EXPORT message
    {
    public:
      virtual ~message();

      virtual bool apply_to( messageable& that ) = 0;

    }; // class message

  } // namespace communication
} // namespace bear

#endif // __COMMUNICATION_MESSAGE_HPP__
