/* handle the list of postponed requests */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <syslog.h>

#include <unistd.h>
#include <time.h>

#include "server.h"

void pkspxy_postponed_append (const char *req)
{
  struct pkspxy_strlist *p, **q;

  q = &PostponedQueries;
  p = PostponedQueries;

  while (p)
  {
    if (!strcmp (p->str, req))
      return;

    q = &p->next;
    p = p->next;
  }

  /* XXX - log an error - or panic? */

  if (!(*q = calloc (1, sizeof (struct pkspxy_strlist))))
  {
    syslog (LOG_ERR, "calloc failed (%m)");
    return;
  }

  if (!((*q)->str = strdup (req)))
  {
    syslog (LOG_ERR, "strdup failed (%m)");
    free (*q);
    *q = NULL;
    return;
  }
}

int pkspxy_is_postponed (const char *req)
{
  struct pkspxy_strlist *p;

  for (p = PostponedQueries; p; p = p->next)
  {
    if (p->str && !strcmp (p->str, req))
      return 1;
  }
  return 0;
}


void pkspxy_handle_postponed_requests (short force)
{
  struct pkspxy_strlist *p, *q;

  if (Online && (force || (time (NULL) - LastPostponedTimestamp) >= PostponedInterval))
  {
    if (PostponedQueries) 
      syslog (LOG_INFO, "Processing postponed requests");
    LastPostponedTimestamp = time (NULL);

    p = PostponedQueries;
    while (p)
    {
      syslog (LOG_INFO, "launching query for request `%s'", p->str);
      if (pkspxy_spawn_request (p->str, 600, NULL) == 0)
      {
	q = p->next;
	free (p->str);
	free (p);
	p = q;
      }
      else
	break;
    }

    PostponedQueries = p;
  }
}
	
void pkspxy_dump_postponed (void)
{
  char dumpfile[_POSIX_PATH_MAX];
  struct pkspxy_strlist *p;
  FILE *fp;
  
  snprintf (dumpfile, sizeof (dumpfile), "%s/pkspxy.postponed",
	    SpoolDir);
  
  if (!(fp = fopen (dumpfile, "w")))
    return;
  
  for (p = PostponedQueries; p; p = p->next)
    fprintf (fp, "%s\n", p->str);

  fclose (fp);
}


void pkspxy_restore_postponed (void)
{
  char dumpfile[_POSIX_PATH_MAX];
  char buff[1024];
  FILE *fp;
  char *s;
  
  snprintf (dumpfile, sizeof (dumpfile), "%s/pkspxy.postponed",
	    SpoolDir);

  if (!(fp = fopen (dumpfile, "r")))
    return;

  while (fgets (buff, sizeof (buff), fp))
  {
    if ((s = strchr (buff, '\n')))
      *s = '\0';
    
    pkspxy_postponed_append (buff);
  }
  
  fclose (fp);
}

  
