/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.XmlResourceParser;
import android.net.Uri;
import android.os.Bundle;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import com.phonegap.AuthenticationToken;
import com.phonegap.CallbackServer;
import com.phonegap.CordovaChromeClient;
import com.phonegap.CordovaWebViewClient;
import com.phonegap.LinearLayoutSoftKeyboardDetect;
import com.phonegap.PreferenceNode;
import com.phonegap.PreferenceSet;
import com.phonegap.api.IPlugin;
import com.phonegap.api.LOG;
import com.phonegap.api.PhonegapActivity;
import com.phonegap.api.PluginManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroidGap
extends PhonegapActivity {
    public static String TAG = "DroidGap";
    protected WebView appView;
    protected WebViewClient webViewClient;
    private ArrayList<Pattern> whiteList = new ArrayList();
    private HashMap<String, Boolean> whiteListCache = new HashMap();
    protected LinearLayout root;
    public boolean bound = false;
    public CallbackServer callbackServer;
    protected PluginManager pluginManager;
    protected boolean cancelLoadUrl = false;
    protected ProgressDialog spinnerDialog = null;
    private String url = null;
    private Stack<String> urls = new Stack();
    private String initUrl = null;
    private static int ACTIVITY_STARTING = 0;
    private static int ACTIVITY_RUNNING = 1;
    private static int ACTIVITY_EXITING = 2;
    private int activityState = 0;
    String baseUrl = null;
    protected IPlugin activityResultCallback = null;
    protected boolean activityResultKeepRunning;
    int loadUrlTimeout = 0;
    private int backgroundColor = -16777216;
    private Hashtable<String, AuthenticationToken> authenticationTokens = new Hashtable();
    protected int splashscreen = 0;
    protected int loadUrlTimeoutValue = 20000;
    protected boolean keepRunning = true;
    protected PreferenceSet preferences;
    private boolean classicRender;

    public void setAuthenticationToken(AuthenticationToken authenticationToken, String host, String realm) {
        if (host == null) {
            host = "";
        }
        if (realm == null) {
            realm = "";
        }
        this.authenticationTokens.put(host.concat(realm), authenticationToken);
    }

    public AuthenticationToken removeAuthenticationToken(String host, String realm) {
        return this.authenticationTokens.remove(host.concat(realm));
    }

    public AuthenticationToken getAuthenticationToken(String host, String realm) {
        AuthenticationToken token = null;
        token = this.authenticationTokens.get(host.concat(realm));
        if (token == null) {
            token = this.authenticationTokens.get(host);
            if (token == null) {
                token = this.authenticationTokens.get(realm);
            }
            if (token == null) {
                token = this.authenticationTokens.get("");
            }
        }
        return token;
    }

    public void clearAuthenticationTokens() {
        this.authenticationTokens.clear();
    }

    public void onCreate(Bundle savedInstanceState) {
        String url;
        this.preferences = new PreferenceSet();
        this.loadConfiguration();
        LOG.d(TAG, "DroidGap.onCreate()");
        super.onCreate(savedInstanceState);
        this.getWindow().requestFeature(1);
        if (this.preferences.prefMatches("fullscreen", "true")) {
            this.getWindow().setFlags(1024, 1024);
        } else {
            this.getWindow().setFlags(2048, 2048);
        }
        Display display = this.getWindowManager().getDefaultDisplay();
        int width = display.getWidth();
        int height = display.getHeight();
        this.root = new LinearLayoutSoftKeyboardDetect((Context)this, width, height);
        this.root.setOrientation(1);
        this.root.setBackgroundColor(this.backgroundColor);
        this.root.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 0.0f));
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null && (url = bundle.getString("url")) != null) {
            this.initUrl = url;
        }
        this.setVolumeControlStream(3);
    }

    public void init() {
        LOG.d(TAG, "DroidGap.init()");
        this.appView = new WebView((Context)this);
        this.appView.setId(100);
        this.appView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        this.appView.setWebChromeClient((WebChromeClient)new CordovaChromeClient((Context)this));
        this.setWebViewClient(this.appView, new CordovaWebViewClient(this));
        this.appView.setInitialScale(0);
        this.appView.setVerticalScrollBarEnabled(false);
        this.appView.requestFocusFromTouch();
        WebSettings settings = this.appView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        settings.setNavDump(true);
        settings.setDatabaseEnabled(true);
        String databasePath = this.getApplicationContext().getDir("database", 0).getPath();
        settings.setDatabasePath(databasePath);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        this.appView.setVisibility(4);
        this.root.addView((View)this.appView);
        this.setContentView((View)this.root);
        this.cancelLoadUrl = false;
    }

    protected void setWebViewClient(WebView appView, WebViewClient client) {
        this.webViewClient = client;
        appView.setWebViewClient(client);
    }

    private void handleActivityParameters() {
        int timeout;
        this.backgroundColor = this.getIntegerProperty("backgroundColor", -16777216);
        this.root.setBackgroundColor(this.backgroundColor);
        this.splashscreen = this.getIntegerProperty("splashscreen", 0);
        if (this.urls.size() == 0 && this.splashscreen != 0) {
            this.root.setBackgroundResource(this.splashscreen);
        }
        if ((timeout = this.getIntegerProperty("loadUrlTimeoutValue", 0)) > 0) {
            this.loadUrlTimeoutValue = timeout;
        }
        this.keepRunning = this.getBooleanProperty("keepRunning", true);
    }

    @Override
    public void loadUrl(String url) {
        if (this.initUrl == null || this.urls.size() > 0) {
            this.loadUrlIntoView(url);
        } else {
            this.loadUrlIntoView(this.initUrl);
        }
    }

    private void loadUrlIntoView(final String url) {
        if (!url.startsWith("javascript:")) {
            LOG.d(TAG, "DroidGap.loadUrl(%s)", url);
        }
        this.url = url;
        if (this.baseUrl == null) {
            int i = url.lastIndexOf(47);
            this.baseUrl = i > 0 ? url.substring(0, i + 1) : this.url + "/";
        }
        if (!url.startsWith("javascript:")) {
            LOG.d(TAG, "DroidGap: url=%s baseUrl=%s", url, this.baseUrl);
        }
        final DroidGap me = this;
        this.runOnUiThread(new Runnable(){

            public void run() {
                if (me.appView == null) {
                    me.init();
                }
                me.handleActivityParameters();
                me.urls.push(url);
                me.appView.clearHistory();
                if (me.callbackServer == null) {
                    me.callbackServer = new CallbackServer();
                    me.callbackServer.init(url);
                } else {
                    me.callbackServer.reinit(url);
                }
                if (me.pluginManager == null) {
                    me.pluginManager = new PluginManager(me.appView, me);
                } else {
                    me.pluginManager.reinit();
                }
                String loading = null;
                loading = me.urls.size() == 1 ? me.getStringProperty("loadingDialog", null) : me.getStringProperty("loadingPageDialog", null);
                if (loading != null) {
                    String title = "";
                    String message = "Loading Application...";
                    if (loading.length() > 0) {
                        int comma = loading.indexOf(44);
                        if (comma > 0) {
                            title = loading.substring(0, comma);
                            message = loading.substring(comma + 1);
                        } else {
                            title = "";
                            message = loading;
                        }
                    }
                    me.spinnerStart(title, message);
                }
                final int currentLoadUrlTimeout = me.loadUrlTimeout;
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(me.loadUrlTimeoutValue);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (me.loadUrlTimeout == currentLoadUrlTimeout) {
                            me.appView.stopLoading();
                            LOG.e(TAG, "DroidGap: TIMEOUT ERROR! - calling webViewClient");
                            me.webViewClient.onReceivedError(me.appView, -6, "The connection to the server was unsuccessful.", url);
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
                me.appView.loadUrl(url);
            }
        });
    }

    public void loadUrl(String url, int time) {
        if (this.initUrl == null || this.urls.size() > 0) {
            this.loadUrlIntoView(url, time);
        } else {
            this.loadUrlIntoView(this.initUrl);
        }
    }

    private void loadUrlIntoView(final String url, final int time) {
        this.cancelLoadUrl = false;
        if (this.urls.size() > 0) {
            this.loadUrlIntoView(url);
        }
        if (!url.startsWith("javascript:")) {
            LOG.d(TAG, "DroidGap.loadUrl(%s, %d)", url, time);
        }
        final DroidGap me = this;
        this.runOnUiThread(new Runnable(){

            public void run() {
                if (me.appView == null) {
                    me.init();
                }
                me.handleActivityParameters();
            }
        });
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait(time);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!me.cancelLoadUrl) {
                    me.loadUrlIntoView(url);
                } else {
                    me.cancelLoadUrl = false;
                    LOG.d(TAG, "Aborting loadUrl(%s): Another URL was loaded before timer expired.", url);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void cancelLoadUrl() {
        this.cancelLoadUrl = true;
    }

    public void clearCache() {
        if (this.appView == null) {
            this.init();
        }
        this.appView.clearCache(true);
    }

    public void clearHistory() {
        this.urls.clear();
        this.appView.clearHistory();
        if (this.url != null) {
            this.urls.push(this.url);
        }
    }

    public boolean backHistory() {
        if (this.appView.canGoBack()) {
            this.appView.goBack();
            return true;
        }
        if (this.urls.size() > 1) {
            this.urls.pop();
            String url = this.urls.pop();
            this.loadUrl(url);
            return true;
        }
        return false;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        Boolean p = (Boolean)bundle.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public int getIntegerProperty(String name, int defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        Integer p = (Integer)bundle.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public String getStringProperty(String name, String defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        String p = bundle.getString(name);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public double getDoubleProperty(String name, double defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        Double p = (Double)bundle.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public void setBooleanProperty(String name, boolean value) {
        this.getIntent().putExtra(name, value);
    }

    public void setIntegerProperty(String name, int value) {
        this.getIntent().putExtra(name, value);
    }

    public void setStringProperty(String name, String value) {
        this.getIntent().putExtra(name, value);
    }

    public void setDoubleProperty(String name, double value) {
        this.getIntent().putExtra(name, value);
    }

    protected void onPause() {
        super.onPause();
        if (this.activityState == ACTIVITY_EXITING) {
            return;
        }
        if (this.appView == null) {
            return;
        }
        this.appView.loadUrl("javascript:try{PhoneGap.fireDocumentEvent('pause');}catch(e){};");
        this.pluginManager.onPause(this.keepRunning);
        if (!this.keepRunning) {
            this.appView.pauseTimers();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.pluginManager.onNewIntent(intent);
    }

    protected void onResume() {
        super.onResume();
        if (this.activityState == ACTIVITY_STARTING) {
            this.activityState = ACTIVITY_RUNNING;
            return;
        }
        if (this.appView == null) {
            return;
        }
        this.appView.loadUrl("javascript:try{PhoneGap.fireDocumentEvent('resume');}catch(e){};");
        this.pluginManager.onResume(this.keepRunning || this.activityResultKeepRunning);
        if (!this.keepRunning || this.activityResultKeepRunning) {
            if (this.activityResultKeepRunning) {
                this.keepRunning = this.activityResultKeepRunning;
                this.activityResultKeepRunning = false;
            }
            this.appView.resumeTimers();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.appView != null) {
            this.appView.loadUrl("javascript:try{PhoneGap.onDestroy.fire();}catch(e){};");
            this.appView.loadUrl("about:blank");
            this.pluginManager.onDestroy();
        } else {
            this.endActivity();
        }
    }

    @Override
    public void postMessage(String id, Object data) {
        this.pluginManager.postMessage(id, data);
    }

    @Override
    @Deprecated
    public void addService(String serviceType, String className) {
        this.pluginManager.addService(serviceType, className);
    }

    @Override
    public void sendJavascript(String statement) {
        this.callbackServer.sendJavascript(statement);
    }

    public void showWebPage(String url, boolean openExternal, boolean clearHistory, HashMap<String, Object> params) {
        LOG.d(TAG, "showWebPage(%s, %b, %b, HashMap", url, openExternal, clearHistory);
        if (clearHistory) {
            this.clearHistory();
        }
        if (!openExternal) {
            if (url.startsWith("file://") || url.indexOf(this.baseUrl) == 0 || this.isUrlWhiteListed(url)) {
                if (clearHistory) {
                    this.urls.clear();
                }
                this.loadUrl(url);
            } else {
                LOG.w(TAG, "showWebPage: Cannot load URL into webview since it is not in white list.  Loading into browser instead. (URL=" + url + ")");
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error loading url " + url, e);
                }
            }
        } else {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                this.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                LOG.e(TAG, "Error loading url " + url, e);
            }
        }
    }

    public void spinnerStart(String title, String message) {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
        final DroidGap me = this;
        this.spinnerDialog = ProgressDialog.show((Context)this, (CharSequence)title, (CharSequence)message, (boolean)true, (boolean)true, (DialogInterface.OnCancelListener)new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                me.spinnerDialog = null;
            }
        });
    }

    public void spinnerStop() {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
    }

    public void endActivity() {
        this.activityState = ACTIVITY_EXITING;
        this.finish();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.appView == null) {
            return super.onKeyDown(keyCode, event);
        }
        if (keyCode == 4) {
            if (this.bound) {
                this.appView.loadUrl("javascript:PhoneGap.fireDocumentEvent('backbutton');");
                return true;
            }
            if (this.backHistory()) {
                return true;
            }
            this.activityState = ACTIVITY_EXITING;
            return super.onKeyDown(keyCode, event);
        }
        if (keyCode == 82) {
            this.appView.loadUrl("javascript:PhoneGap.fireDocumentEvent('menubutton');");
            return super.onKeyDown(keyCode, event);
        }
        if (keyCode == 84) {
            this.appView.loadUrl("javascript:PhoneGap.fireDocumentEvent('searchbutton');");
            return true;
        }
        return false;
    }

    public void startActivityForResult(Intent intent, int requestCode) throws RuntimeException {
        LOG.d(TAG, "DroidGap.startActivityForResult(intent,%d)", requestCode);
        super.startActivityForResult(intent, requestCode);
    }

    @Override
    public void startActivityForResult(IPlugin command, Intent intent, int requestCode) {
        this.activityResultCallback = command;
        this.activityResultKeepRunning = this.keepRunning;
        if (command != null) {
            this.keepRunning = false;
        }
        super.startActivityForResult(intent, requestCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        IPlugin callback = this.activityResultCallback;
        if (callback != null) {
            callback.onActivityResult(requestCode, resultCode, intent);
        }
    }

    @Override
    public void setActivityResultCallback(IPlugin plugin) {
        this.activityResultCallback = plugin;
    }

    public void onReceivedError(int errorCode, final String description, final String failingUrl) {
        final DroidGap me = this;
        final String errorUrl = me.getStringProperty("errorUrl", null);
        if (errorUrl != null && (errorUrl.startsWith("file://") || errorUrl.indexOf(me.baseUrl) == 0 || this.isUrlWhiteListed(errorUrl)) && !failingUrl.equals(errorUrl)) {
            me.runOnUiThread(new Runnable(){

                public void run() {
                    me.showWebPage(errorUrl, false, true, null);
                }
            });
        } else {
            me.runOnUiThread(new Runnable(){

                public void run() {
                    me.appView.setVisibility(8);
                    me.displayError("Application Error", description + " (" + failingUrl + ")", "OK", true);
                }
            });
        }
    }

    public void displayError(final String title, final String message, final String button, final boolean exit) {
        final DroidGap me = this;
        me.runOnUiThread(new Runnable(){

            public void run() {
                AlertDialog.Builder dlg = new AlertDialog.Builder((Context)me);
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(false);
                dlg.setPositiveButton((CharSequence)button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        if (exit) {
                            me.endActivity();
                        }
                    }
                });
                dlg.create();
                dlg.show();
            }
        });
    }

    private void loadConfiguration() {
        int id = this.getResources().getIdentifier("phonegap", "xml", this.getPackageName());
        if (id == 0) {
            LOG.i("PhoneGapLog", "phonegap.xml missing. Ignoring...");
            return;
        }
        XmlResourceParser xml = this.getResources().getXml(id);
        int eventType = -1;
        while (eventType != 1) {
            if (eventType == 2) {
                String strNode = xml.getName();
                if (strNode.equals("access")) {
                    String origin = xml.getAttributeValue(null, "origin");
                    String subdomains = xml.getAttributeValue(null, "subdomains");
                    if (origin != null) {
                        this.addWhiteListEntry(origin, subdomains != null && subdomains.compareToIgnoreCase("true") == 0);
                    }
                } else if (strNode.equals("log")) {
                    String level = xml.getAttributeValue(null, "level");
                    LOG.i("PhoneGapLog", "Found log level %s", level);
                    if (level != null) {
                        LOG.setLogLevel(level);
                    }
                } else if (strNode.equals("preference")) {
                    String name = xml.getAttributeValue(null, "name");
                    String value = xml.getAttributeValue(null, "value");
                    String readonlyString = xml.getAttributeValue(null, "readonly");
                    boolean readonly = readonlyString != null && readonlyString.equals("true");
                    LOG.i("PhoneGapLog", "Found preference for %s", name);
                    this.preferences.add(new PreferenceNode(name, value, readonly));
                }
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addWhiteListEntry(String origin, boolean subdomains) {
        try {
            if (origin.compareTo("*") == 0) {
                LOG.d(TAG, "Unlimited access to network resources");
                this.whiteList.add(Pattern.compile(".*"));
            } else if (subdomains) {
                if (origin.startsWith("http")) {
                    this.whiteList.add(Pattern.compile(origin.replaceFirst("https?://", "^https?://(.*\\.)?")));
                } else {
                    this.whiteList.add(Pattern.compile("^https?://(.*\\.)?" + origin));
                }
                LOG.d(TAG, "Origin to allow with subdomains: %s", origin);
            } else {
                if (origin.startsWith("http")) {
                    this.whiteList.add(Pattern.compile(origin.replaceFirst("https?://", "^https?://")));
                } else {
                    this.whiteList.add(Pattern.compile("^https?://" + origin));
                }
                LOG.d(TAG, "Origin to allow: %s", origin);
            }
        }
        catch (Exception e) {
            LOG.d(TAG, "Failed to add origin %s", origin);
        }
    }

    boolean isUrlWhiteListed(String url) {
        if (this.whiteListCache.get(url) != null) {
            return true;
        }
        for (Pattern p : this.whiteList) {
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            this.whiteListCache.put(url, true);
            return true;
        }
        return false;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        this.postMessage("onCreateOptionsMenu", menu);
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        this.postMessage("onPrepareOptionsMenu", menu);
        return super.onPrepareOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        this.postMessage("onOptionsItemSelected", item);
        return true;
    }
}

