# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-784-1 (imagemagick)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64197);
 script_cve_id("CVE-2009-1882");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Ubuntu USN-784-1 (imagemagick)";
 script_name(name);

 desc = "The remote host is missing an update to imagemagick
announced via advisory USN-784-1.

Details follow:

It was discovered that ImageMagick did not properly verify the dimensions
of TIFF files. If a user or automated system were tricked into opening a
crafted TIFF file, an attacker could cause a denial of service or possibly
execute arbitrary code with the privileges of the user invoking the
program.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libmagick9                      6:6.2.4.5-0.6ubuntu0.9

Ubuntu 8.04 LTS:
  libmagick10                     7:6.3.7.9.dfsg1-2ubuntu1.1

Ubuntu 8.10:
  libmagick10                     7:6.3.7.9.dfsg1-2ubuntu3.1

Ubuntu 9.04:
  libmagickcore1                  7:6.4.5.4.dfsg1-1ubuntu3.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-784-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-784-1 (imagemagick)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imagemagick", ver:"6.2.4.5-0.6ubuntu0.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++9-dev", ver:"6.2.4.5-0.6ubuntu0.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++9c2a", ver:"6.2.4.5-0.6ubuntu0.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick9-dev", ver:"6.2.4.5-0.6ubuntu0.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick9", ver:"6.2.4.5-0.6ubuntu0.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.2.4.5-0.6ubuntu0.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imagemagick", ver:"6.3.7.9.dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++10", ver:"6.3.7.9.dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++9-dev", ver:"6.3.7.9.dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick10", ver:"6.3.7.9.dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick9-dev", ver:"6.3.7.9.dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.3.7.9.dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imagemagick", ver:"6.3.7.9.dfsg1-2ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++10", ver:"6.3.7.9.dfsg1-2ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++9-dev", ver:"6.3.7.9.dfsg1-2ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick10", ver:"6.3.7.9.dfsg1-2ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick9-dev", ver:"6.3.7.9.dfsg1-2ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.3.7.9.dfsg1-2ubuntu3.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imagemagick-doc", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imagemagick-dbg", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imagemagick", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++-dev", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++1", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagickcore-dev", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagickcore1", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagickwand-dev", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagickwand1", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.4.5.4.dfsg1-1ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
