###############################################################################
# OpenVAS Vulnerability Test include file
# $Id$
#
# Description: Check if HP-UX packages are up to date
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

#
# ishpuxpkgvuln is intended to provide a quick way to verify that
# a given package, is installed and is vulnerable or not.
# The function ishpuxpkgvuln returns 0 if it is not installed or
# is installed and up to date, and returns 1 if it is installed
# but vulnerable
#

function ishpuxpkgvuln(pkg, revision, patch_list, rls) {
  local_var kbrls, rpms, pat, matches, rc;

  # Check that we have the data for this release.
  kbrls = get_kb_item("ssh/login/release");
  if(kbrls!=rls) {
    return(0);
  }

  pkgs_rev = get_kb_item("ssh/login/hp_pkgrev");
  inst_rev = eregmatch(pattern:pkg + "(	+)?([a-zA-Z0-9.]+) ",
                       string:chomp(pkgs_rev));
  if(isnull(inst_rev)) {
    return(0);
  }

  if(patch_list != NULL)
  {
    patches = get_kb_item("ssh/login/hp_pkgsupersedes");
      foreach patch (patch_list)
      {
        if(patch >!< patches){
          return(1);
        }
      }
    return(0);
  }

  rc = revcomp(a:inst_rev[2], b:revision);

  if(rc < 0)
  {
    security_note(0, data: "Package " + pkg + " version " +
              inst_rev[2] + " is installed which is known to be vulnerable.");
    return(1);
  }
  return(0);
}
