# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 159-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53730);
 script_cve_id("CVE-2002-1119");
 script_bugtraq_id(5581);
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 159-2 (python)";
 script_name(name);

 desc = "The remote host is missing an update to python
announced via advisory DSA 159-2.

The bugfix we distributed in DSA 159-1 unfortunately caused Python to
sometimes behave improperly when a non-executable file existed earlier
in the path and an executable file of the same name existed later in
the path.  Zack Weinberg fixed this in the Python source.  For
reference, here's the original advisory text:

Zack Weinberg discovered an insecure use of a temporary file in
os._execvpe from os.py. It uses a predictable name which could
lead execution of arbitrary code.

This problem has been fixed in several versions of Python: For the
current stable distribution (woody) it has been fixed in version
1.5.2-23.2 of Python 1.5, in version 2.1.3-3.2 of Python 2.1 and in
version 2.2.1-4.2 of Python 2.2. For the old stable distribution
(potato) this has been fixed in version 1.5.2-10potato13 for Python
1.5. For the unstable distribution (sid) this has been fixed in
version 1.5.2-25 of Python 1.5, in version 2.1.3-9 of Python 2.1 and
in version 2.2.1-11 of Python 2.2. Python 2.3 is not affected by the
original problem.

We recommend that you upgrade your Python packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20159-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 159-2 (python)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-base", ver:"1.5.2-10potato13", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python1.5", ver:"1.5.2-23.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1", ver:"2.1.3-3.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2", ver:"2.2.1-4.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
