/*
 * nzb
 *
 * Copyright (C) 2004-2006 Mattias Nordstrom <matta at ftlight net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * Authors:
 *   Mattias Nordstrom <matta at ftlight net>
 *
 * $Id: downloader.h,v 1.3 2005/10/15 17:45:36 mnordstr Exp $
 *   This file provides the NNTP downloader.
 */


#ifndef DOWNLOADER_H
#define DOWNLOADER_H

#include <QtNetwork>

#include "nzbdata.h"
#include "sslfilter.h"

class Downloader : public QThread
{
	Q_OBJECT
public:
	Downloader(NzbList *nzblist, int thread_id, QMutex *file_lock, QTableWidget *l, QObject *parent = 0);
	void run();

signals:
	void downloadEvent(QString message, int row, int type = 0);
	void processNext();
	
public slots:
	void processFiles();
	void stop();
	
private slots:
	void init();
	void gotData();
	void speedMonitor();
	void gotConnected();
	void ssl_readyRead();
	void ssl_outgoingReady();

private:
	void initialize(QString host, int port);
	void terminate();
	void getArticle(QString msgid);
	bool getNext();
	
	QObject *parent;
	QTcpSocket *usenet;
	NzbList *nzblist;
	QTableWidget *l;
	QMutex *file_lock;
	int thread_id;
	int file, seg;
	QByteArray dldata;
	bool downloading;
	QTime last_time;
	int total_bytes;
	int last_bytes;
	SSLFilter ssl;
	bool use_ssl;
};

#endif
