/* -*-  Mode: C++; c-file-style: "gnu"; indent-tabs-mode:nil; -*- */
/*
* Copyright (c) 2011 SIGNET LAB. Department of Information Engineering (DEI), University of Padua
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation;
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
*
* Original Work Authors:
*      Marco Mezzavilla <mezzavil@dei.unipd.it>
*      Giovanni Tomasi <tomasigv@gmail.com>
* Original Work Acknowldegments:
*      This work was supported by the MEDIEVAL (MultiMEDia transport
*      for mobIlE Video AppLications) project, which is a
*      medium-scale focused research project (STREP) of the 7th
*      Framework Programme (FP7)
*
* Subsequent integration in LENA and extension done by:
*      Marco Miozzo <marco.miozzo@cttc.es>
*/ 


#include <list>
#include <tr1/functional>
#include <vector>
#include <ns3/log.h>
#include <ns3/pointer.h>
#include <stdint.h>
#include <cmath>
#include <stdint.h>
#include "stdlib.h"
#include <ns3/lte-mi-error-model.h>



NS_LOG_COMPONENT_DEFINE ("LteMiErrorModel");

namespace ns3 {
  
  
  int TbsIndex[32] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14, 15, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, -1, -1, -1};
  
  uint16_t cbSizeTable[188] = {   // as K column of table 5.1.3-3 of TS 36,212
    
    40, 48, 56, 64, 72, 80, 88, 96, 104, 112, 120, 128, 136, 144, 152,
    160, 168, 176, 184, 192, 200, 208, 216, 224, 232, 240, 248, 256, 264,
    272, 280, 288, 296, 304, 312, 320, 328, 336, 344, 352, 360, 368, 376,
    384, 392, 400, 408, 416, 424, 432, 440, 448, 456, 464, 472, 480, 488,
    496, 504, 512, 528, 544, 560, 576, 592, 608, 624, 640, 656, 672, 688,
    704, 720, 736, 752, 768, 784, 800, 816, 832, 848, 864, 880, 896, 912,
    928, 944, 960, 976, 992, 1008, 1024, 1056, 1088, 1120, 1152, 1184, 1216,
    1248, 1280, 1312, 1344, 1376, 1408, 1440, 1472, 1504, 1536, 1568, 1600,
    1632, 1664, 1696, 1728, 1760, 1792, 1824, 1856, 1888, 1920, 1952, 1984,
    2016, 2048, 2112, 2176, 2240, 2304, 2368, 2432, 2496, 2560, 2624, 2688,    2752, 2816, 2880, 2944, 3008, 3072, 3136, 3200, 3264, 3328, 3392, 3456,
    3520, 3584, 3648, 3712, 3776, 3840, 3904, 3968, 4032, 4096, 4160, 4224,    4288, 4352, 4416, 4480, 4544, 4608, 4672, 4736, 4800, 4864, 4928, 4992,    5056, 5120, 5184, 5248, 5312, 5376, 5440, 5504, 5568, 5632, 5696, 5760,
    5824, 5888, 5952, 6016, 6080, 6144   
  };
  
  ;
  
uint16_t cbMiSizeTable [9] = {40, 104, 160, 256, 512, 1024, 2560, 4032, 6144};


double MI_map_qpsk[MI_MAP_QPSK_SIZE] = {
  0.0690003489341297,0.0716227274726117,0.0742340978953440,0.0768346104980025,0.0794244103447761,0.0820036374801004,0.0845724271431926,0.0871309099810427,0.0896792122569310,0.0922174560525495,0.0947457594625196,0.0972642367806063,0.0997729986772915,0.102272152368619,0.104761801776403,0.107242047680000,0.109712987859947,0.112174717233782,0.114627327984429,0.117070909681513,0.119505549395992,0.121931331808479,0.124348339311615,0.126756652106854,0.129156348295983,0.131547503967713,0.133930193279620,0.136304488535748,0.138670460260116,0.141028177266400,0.143377706724007,0.145719114220782,0.148052463822533,0.150377818129578,0.152695238330494,0.155004784253224,0.157306514413717,0.159600486062226,0.161886755227418,0.164165376758411,0.166436404364862,0.168699890655220,0.170955887173241,0.173204444432860,0.175445611951529,0.177679438282080,0.179905971043210,0.182125256948655,0.184337341835134,0.186542270689104,0.188740087672416,0.190930836146914,0.193114558698026,0.195291297157414,0.197461092624719,0.199623985488445,0.201780015446038,0.203929221523178,0.206071642092341,0.208207314890659,0.210336277037108,0.212458565049058,0.214574214858220,0.216683261826010,0.218785740758360,0.220881685920000,0.222971131048238,0.225054109366258,0.227130653595954,0.229200795970327,0.231264568245459,0.233322001712082,0.235373127206765,0.237417975122726,0.239456575420291,0.241488957637017,0.243515150897483,0.245535183922773,0.247549085039656,0.249556882189479,0.251558602936785,0.253554274477663,0.255543923647842,0.257527576930545,0.259505260464099,0.261477000049324,0.263442821156701,0.265402748933330,0.267356808209687,0.269305023506185,0.271247419039542,0.273184018728981,0.275114846202242,0.277039924801432,0.278959277588713,0.280872927351831,0.282780896609496,0.284683207616614,0.286579882369384,0.288470942610247,0.290356409832718,0.292236305286078,0.294110649979955,0.295979464688778,0.297842769956116,0.299700586098916,0.301552933211619,0.303399831170183,0.305241299636004,0.307077358059734,0.308908025685008,0.310733321552085,0.312553264501390,0.314367873176978,0.316177166029912,0.317981161321561,0.319779877126821,0.321573331337258,0.323361541664177,0.325144525641625,0.326922300629316,0.328694883815500,0.330462292219754,0.332224542695721,0.333981651933781,0.335733636463664,0.337480512657007,0.339222296729849,0.340959004745076,0.342690652614815,0.344417256102769,0.346138830826504,0.347855392259695,0.349566955734310,0.351273536442761,0.352975149440000,0.354671809645581,0.356363531845667,0.358050330695007,0.359732220718866,0.361409216314917,0.363081331755096,0.364748581187413,0.365760085328701,0.367414435567153,0.369063590345858,0.370707574758377,0.372346413657952,0.373980131661624,0.375608753154257,0.377232302292463,0.378850803008427,0.380464279013651,0.382072753802601,0.383676250656272,0.385274792645668,0.386868402635202,0.388457103286017,0.390040917059232,0.391619866219112,0.393193972836167,0.394763258790181,0.396327745773173,0.397887455292293,0.399442408672650,0.400992627060087,0.402538131423884,0.404078942559405,0.405615081090699,0.407146567473028,0.408673421995349,0.410195664782751,0.411713315798825,0.413226394847994,0.414734921577795,0.416238915481109,0.417738395898345,0.419233382019585,0.420723892886679,0.422209947395301,0.423691564296960,0.425168762200976,0.426641559576410,0.428109974753962,0.429574025927829,0.431033731157521,0.432489108369656,0.433940175359702,0.435386949793697,0.436829449209937,0.438267691020623,0.439701692513483,0.441131470853366,0.442557043083795,0.443978426128502,0.445395636792933,0.446808691765718,0.448217607620120,0.449622400815456,0.451023087698496,0.452419684504825,0.453812207360195,0.455200672281845,0.456585095179796,0.457965491858126,0.459341878016225,0.460714269250023,0.462082681053196,0.463447128818359,0.464807627838230,0.466164193306775,0.467516840320339,0.468865583878754,0.470210438886424,0.471551420153401,0.472888542396436,0.474221820240013,0.475551268217370,0.476876900771498,0.478198732256128,0.479516776936698,0.480831048991307,0.482141562511653,0.483448331503954,0.484751369889858,0.486050691507333,0.487346310111549,0.488638239375742,0.489926492892065,0.491211084172426,0.492492026649314,0.493769333676610,0.495043018530388,0.496313094409703,0.497579574437364,0.498842471660700,0.500101799052307,0.501357569510799,0.502609795861526,0.503858490857300,0.505103667179099,0.506345337436768,0.507583514169703,0.508818209847531,0.510049436870774,0.511277207571509,0.512501534214016,0.513722428995414,0.514939904046294,0.516153971431339,0.517364643149933,0.518571931136767,0.519775847262431,0.520976403334003,0.522173611095627,0.523367482229080,0.524558028354337,0.525745261030125,0.526929191754467,0.528109831965227,0.529287193040638,0.530461286299827,0.531632123003332,0.532799714353619,0.533964071495577,0.535125205517021,0.536283127449183,0.537437848267194,0.538589378890561,0.539737730183644,0.540882912956114,0.542024937963420,0.543163815907238,0.544299557435920,0.545432173144935,0.546561673577308,0.547688069224050,0.548811370524581,0.549931587867153,0.551048731589264,0.552162811978068,0.553273839270780,0.554381823655071,0.555486775269472,0.556588704203755,0.557687620499322,0.558783534149586,0.559876455100345,0.560966393250155,0.562053358450695,0.563137360507132,0.564218409178475,0.565296514177934,0.566371685173266,0.567443931787123,0.568513263597390,0.569579690137527,0.570643220896900,0.571703865321112,0.572761632812328,0.573816532729596,0.574868574389170,0.575917767064821,0.576964119988149,0.578007642348892,0.579048343295230,0.580086231934086,0.581121317331422,0.582153608512535,0.583183114462351,0.584209844125704,0.585233806407631,0.586255010173647,0.587273464250025,0.588289177424073,0.589302158444405,0.590312416021210,0.591319958826520,0.592324795494474,0.593326934621578,0.594326384766964,0.595323154452643,0.596317252163764,0.597308686348855,0.598297465420080,0.599283597753478,0.600267091689206,0.601247955531782,0.602226197550319,0.603201825978762,0.604174849016119,0.605145274826694,0.606113111540312,0.607078367252547,0.608041050024944,0.609001167885238,0.609958728827579,0.610913740812743,0.611866211768347,0.612816149589066,0.613763562136839,0.614708457241078,0.615650842698875,0.616590726275206,0.617528115703136,0.618463018684014,0.619395442887674,0.620325395952633,0.621252885486284,0.622177919065087,0.623100504234766,0.624020648510489,0.624938359377065,0.625853644289121,0.626766510671293,0.627676965918402,0.628585017395639,0.629490672438743,0.630393938354174,0.631294822419294,0.632193331882539,0.633089473963589,0.633983255853542,0.634874684715080,0.635763767682640,0.636650511862579,0.637534924333335,0.638417012145596,0.639296782322459,0.640174241859589,0.641049397725379,0.641922256861109,0.642792826181100,0.643661112572869,0.644527122897282,0.645390863988709,0.646252342655170,0.647111565678489,0.647968539814439,0.648823271792888,0.649675768317950,0.650526036068123,0.651374081696436,0.652219911830588,0.653063533073093,0.653904952001416,0.654744175168111,0.655581209100961,0.656416060303112,0.657248735253208,0.658079240405527,0.658907582190110,0.659733767012895,0.660557801255848,0.661379691277091,0.662199443411030,0.663017063968485,0.663832559236813,0.664645935480037,0.665457198938967,0.666266355831323,0.667073412351863,0.667878374672495,0.668681248942408,0.669482041288181,0.670280757813911,0.671077404601323,0.671871987709891,0.672664513176952,0.673454987017822,0.674243415225909,0.675029803772825,0.675814158608500,0.676596485661295,0.677376790838106,0.678155080024481,0.678931359084725,0.679705633862007,0.680477910178470,0.681248193835337,0.682016490613012,0.682782806271192,0.683547146548964,0.684309517164914,0.685069923817224,0.685828372183780,0.686584867922264,0.687339416670264,0.688092024045367,0.688842695645258,0.689591437047823,0.690338253811239,0.691083151474075,0.691826135555389,0.692567211554818,0.693306384952679,0.694043661210056,0.694779045768899,0.695512544052111,0.696244161463647,0.696973903388596,0.697701775193280,0.698427782225337,0.699151929813817,0.699874223269263,0.700594667883805,0.701313268931245,0.702030031667144,0.702744961328908,0.703458063135872,0.704169342289390,0.704878803972913,0.705586453352076,0.706292295574782,0.706996335771284,0.707698579054265,0.708399030518923,0.709097695243048,0.709794578287106,0.710489684694317,0.711183019490737,0.711874587685330,0.712564394270055,0.713252444219938,0.713938742493152,0.714623294031091,0.715306103758449,0.715987176583295,0.716666517397146,0.717344131075047,0.718020022475638,0.718694196441235,0.719366657797898,0.720037411355506,0.720706461907829,0.721373814232600,0.722039473091587,0.722703443230664,0.723365729379878,0.724026336253524,0.724685268550213,0.725342530952939,0.725998128129151,0.726652064730817,0.727304345394498,0.727954974741409,0.728603957377491,0.729251297893474,0.729897000864946,0.730541070852416,0.731183512401383,0.731824330042397,0.732463528291126,0.733101111648419,0.733737084600371,0.734371451618386,0.735004217159237,0.735635385665134,0.736264961563782,0.736892949268446,0.737519353178008,0.738144177677033,0.738767427135826,0.739389105910496,0.740009218343011,0.740627768761262,0.741244761479122,0.741860200796502,0.742474090999411,0.743086436360017,0.743697241136699,0.744306509574111,0.744914245903234,0.745520454341437,0.746125139092530,0.746728304346822,0.747329954281178,0.747930093059073,0.748528724830645,0.749125853732755,0.749721483889038,0.750315619409959,0.750908264392865,0.751499422922041,0.752089099068763,0.752677296891347,0.753264020435210,0.753849273732912,0.754433060804219,0.755015385656146,0.755596252283013,0.756175664666496,0.756753626775676,0.757330142567093,0.757905215984793,0.758478850960381,0.759051051413067,0.759621821249720,0.760191164364916,0.760759084640984,0.761325585948060,0.761890672144130,0.762454347075082,0.763016614574754,0.763577478464979,0.764136942555635,0.764695010644690,0.765251686518250,0.765806973950608,0.766360876704287,0.766913398530085,0.767464543167128,0.768014314342907,0.768562715773328,0.769109751162760,0.769655424204071,0.770199738578682,0.770742697956607,0.771284305996498,0.771824566345689,0.772363482640238,0.772901058504974,0.773437297553538,0.773972203388427,0.774505779601036,0.775038029771701,0.775568957469741,0.776098566253503,0.776626859670398,0.777153841256950,0.777679514538830,0.778203883030906,0.778726950237274,0.779248719651309,0.779769194755698,0.780288379022484,0.780806275913106,0.781322888878439,0.781838221358831,0.782352276784149,0.782865058573812,0.783376570136834,0.783886814871861,0.784395796167212,0.784903517400915,0.785409981940749,0.785915193144278,0.786419154358893,0.786921868921846,0.787423340160292,0.787923571391323,0.788422565922008,0.788920327049428,0.789416858060713,0.789912162233082,0.790406242833874,0.790899103120589,0.791390746340924,0.791881175732807,0.792370394524432,0.792858405934299,0.793345213171246,0.793830819434485,0.794315227913637,0.794798441788770,0.795280464230428,0.795761298399672,0.796240947448110,0.796719414517932,0.797196702741946,0.797672815243614,0.798147755137077,0.798621525527200,0.799094129509597,0.799565570170669,0.800035850587634,0.800504973828565,0.800972942952416,0.801439761009061,0.801905431039322,0.802369956075006,0.802833339138932,0.803295583244968,0.803756691398058,0.804216666594261,0.804675511820773,0.805133230055969,0.805589824269425,0.806045297421956,0.806499652465644,0.806952892343868,0.807405019991339,0.807856038334126,0.808305950289689,0.808754758766908,0.809202466666116,0.809649076879126,0.810094592289261,0.810539015771388,0.810982350191941,0.811424598408958,0.811865763272103,0.812305847622701,0.812744854293766,0.813182786110026,0.813619645887958,0.814055436435812,0.814490160553643,0.814923821033336,0.815356420658636,0.815787962205180,0.816218448440517,0.816647882124143,0.817076266007528,0.817503602834138,0.817929895339472,0.818355146251079,0.818779358288595,0.819202534163764,0.819624676580468,0.820045788234751,0.820465871814850,0.820884930001221,0.821302965466561,0.821719980875839,0.822135978886325,0.822550962147607,0.822964933301628,0.823377894982703,0.823789849817552,0.824200800425321,0.824610749417610,0.825019699398499,0.825427652964571,0.825834612704941,0.826240581201277,0.826645561027831,0.827049554751458,0.827452564931645,0.827854594120533,0.828255644862944,0.828655719696407,0.829054821151176,0.829452951750264,0.829850114009459,0.830246310437353,0.830641543535362,0.831035815797757,0.831429129711679,0.831821487757172,0.832212892407198,0.832603346127667,0.832992851377459,0.833381410608444,0.833769026265511,0.834155700786586,0.834541436602659,0.834926236137804,0.835310101809205,0.835693036027176,0.836075041195186,0.836456119709880,0.836836273961102,0.837215506331919,0.837593819198639,0.837971214930841,0.838347695891388,0.838723264436456,0.839097922915554,0.839471673671544,0.839844519040665,0.840216461352555,0.840587502930271,0.840957646090311,0.841326893142636,0.841695246390691,0.842062708131428,0.842429280655323,0.842794966246402,0.843159767182260,0.843523685734080,0.843886724166656,0.844248884738415,0.844610169701435,0.844970581301467,0.845330121777955,0.845688793364056,0.846046598286665,0.846403538766425,0.846759617017759,0.847114835248883,0.847469195661827,0.847822700452456,0.848175351810490,0.848527151919523,0.848878102957045,0.849228207094457,0.849577466497095,0.849925883324247,0.850273459729174,0.850620197859128,0.850966099855372,0.851311167853200,0.851655403981954,0.851998810365043,0.852341389119967,0.852683142358329,0.853024072185856,0.853364180702422,0.853703470002060,0.854041942172986,0.854379599297614,0.854716443452576,0.855052476708740,0.855387701131230,0.855722118779441,0.856055731707059,0.856388541962080,0.856720551586826,0.857051762617964,0.857382177086524,0.857711797017917,0.858040624431952,0.858368661342853,0.858695909759279,0.859022371684340
};

double MI_map_qpsk_axis[MI_MAP_QPSK_SIZE] = {
  0.100000000000000,0.104000000000000,0.108000000000000,0.112000000000000,0.116000000000000,0.120000000000000,0.124000000000000,0.128000000000000,0.132000000000000,0.136000000000000,0.140000000000000,0.144000000000000,0.148000000000000,0.152000000000000,0.156000000000000,0.160000000000000,0.164000000000000,0.168000000000000,0.172000000000000,0.176000000000000,0.180000000000000,0.184000000000000,0.188000000000000,0.192000000000000,0.196000000000000,0.200000000000000,0.204000000000000,0.208000000000000,0.212000000000000,0.216000000000000,0.220000000000000,0.224000000000000,0.228000000000000,0.232000000000000,0.236000000000000,0.240000000000000,0.244000000000000,0.248000000000000,0.252000000000000,0.256000000000000,0.260000000000000,0.264000000000000,0.268000000000000,0.272000000000000,0.276000000000000,0.280000000000000,0.284000000000000,0.288000000000000,0.292000000000000,0.296000000000000,0.300000000000000,0.304000000000000,0.308000000000000,0.312000000000000,0.316000000000000,0.320000000000000,0.324000000000000,0.328000000000000,0.332000000000000,0.336000000000000,0.340000000000000,0.344000000000000,0.348000000000000,0.352000000000000,0.356000000000000,0.360000000000000,0.364000000000000,0.368000000000000,0.372000000000000,0.376000000000000,0.380000000000000,0.384000000000000,0.388000000000000,0.392000000000000,0.396000000000000,0.400000000000000,0.404000000000000,0.408000000000000,0.412000000000000,0.416000000000000,0.420000000000000,0.424000000000000,0.428000000000000,0.432000000000000,0.436000000000000,0.440000000000000,0.444000000000000,0.448000000000000,0.452000000000000,0.456000000000000,0.460000000000000,0.464000000000000,0.468000000000000,0.472000000000000,0.476000000000000,0.480000000000000,0.484000000000000,0.488000000000000,0.492000000000000,0.496000000000000,0.500000000000000,0.504000000000000,0.508000000000000,0.512000000000000,0.516000000000000,0.520000000000000,0.524000000000000,0.528000000000000,0.532000000000000,0.536000000000000,0.540000000000000,0.544000000000000,0.548000000000000,0.552000000000000,0.556000000000000,0.560000000000000,0.564000000000000,0.568000000000000,0.572000000000000,0.576000000000000,0.580000000000000,0.584000000000000,0.588000000000000,0.592000000000000,0.596000000000000,0.600000000000000,0.604000000000000,0.608000000000000,0.612000000000000,0.616000000000000,0.620000000000000,0.624000000000000,0.628000000000000,0.632000000000000,0.636000000000000,0.640000000000000,0.644000000000000,0.648000000000000,0.652000000000000,0.656000000000000,0.660000000000000,0.664000000000000,0.668000000000000,0.672000000000000,0.676000000000000,0.680000000000000,0.684000000000000,0.688000000000000,0.692000000000000,0.696000000000000,0.700000000000000,0.704000000000000,0.708000000000000,0.712000000000000,0.716000000000000,0.720000000000000,0.724000000000000,0.728000000000000,0.732000000000000,0.736000000000000,0.740000000000000,0.744000000000000,0.748000000000000,0.752000000000000,0.756000000000000,0.760000000000000,0.764000000000000,0.768000000000000,0.772000000000000,0.776000000000000,0.780000000000000,0.784000000000000,0.788000000000000,0.792000000000000,0.796000000000000,0.800000000000000,0.804000000000000,0.808000000000000,0.812000000000000,0.816000000000000,0.820000000000000,0.824000000000000,0.828000000000000,0.832000000000000,0.836000000000000,0.840000000000000,0.844000000000000,0.848000000000000,0.852000000000000,0.856000000000000,0.860000000000000,0.864000000000000,0.868000000000000,0.872000000000000,0.876000000000000,0.880000000000000,0.884000000000000,0.888000000000000,0.892000000000000,0.896000000000000,0.900000000000000,0.904000000000000,0.908000000000000,0.912000000000000,0.916000000000000,0.920000000000000,0.924000000000000,0.928000000000000,0.932000000000000,0.936000000000000,0.940000000000000,0.944000000000000,0.948000000000000,0.952000000000000,0.956000000000000,0.960000000000000,0.964000000000000,0.968000000000000,0.972000000000000,0.976000000000000,0.980000000000000,0.984000000000000,0.988000000000000,0.992000000000000,0.996000000000000,1,1.00400000000000,1.00800000000000,1.01200000000000,1.01600000000000,1.02000000000000,1.02400000000000,1.02800000000000,1.03200000000000,1.03600000000000,1.04000000000000,1.04400000000000,1.04800000000000,1.05200000000000,1.05600000000000,1.06000000000000,1.06400000000000,1.06800000000000,1.07200000000000,1.07600000000000,1.08000000000000,1.08400000000000,1.08800000000000,1.09200000000000,1.09600000000000,1.10000000000000,1.10400000000000,1.10800000000000,1.11200000000000,1.11600000000000,1.12000000000000,1.12400000000000,1.12800000000000,1.13200000000000,1.13600000000000,1.14000000000000,1.14400000000000,1.14800000000000,1.15200000000000,1.15600000000000,1.16000000000000,1.16400000000000,1.16800000000000,1.17200000000000,1.17600000000000,1.18000000000000,1.18400000000000,1.18800000000000,1.19200000000000,1.19600000000000,1.20000000000000,1.20400000000000,1.20800000000000,1.21200000000000,1.21600000000000,1.22000000000000,1.22400000000000,1.22800000000000,1.23200000000000,1.23600000000000,1.24000000000000,1.24400000000000,1.24800000000000,1.25200000000000,1.25600000000000,1.26000000000000,1.26400000000000,1.26800000000000,1.27200000000000,1.27600000000000,1.28000000000000,1.28400000000000,1.28800000000000,1.29200000000000,1.29600000000000,1.30000000000000,1.30400000000000,1.30800000000000,1.31200000000000,1.31600000000000,1.32000000000000,1.32400000000000,1.32800000000000,1.33200000000000,1.33600000000000,1.34000000000000,1.34400000000000,1.34800000000000,1.35200000000000,1.35600000000000,1.36000000000000,1.36400000000000,1.36800000000000,1.37200000000000,1.37600000000000,1.38000000000000,1.38400000000000,1.38800000000000,1.39200000000000,1.39600000000000,1.40000000000000,1.40400000000000,1.40800000000000,1.41200000000000,1.41600000000000,1.42000000000000,1.42400000000000,1.42800000000000,1.43200000000000,1.43600000000000,1.44000000000000,1.44400000000000,1.44800000000000,1.45200000000000,1.45600000000000,1.46000000000000,1.46400000000000,1.46800000000000,1.47200000000000,1.47600000000000,1.48000000000000,1.48400000000000,1.48800000000000,1.49200000000000,1.49600000000000,1.50000000000000,1.50400000000000,1.50800000000000,1.51200000000000,1.51600000000000,1.52000000000000,1.52400000000000,1.52800000000000,1.53200000000000,1.53600000000000,1.54000000000000,1.54400000000000,1.54800000000000,1.55200000000000,1.55600000000000,1.56000000000000,1.56400000000000,1.56800000000000,1.57200000000000,1.57600000000000,1.58000000000000,1.58400000000000,1.58800000000000,1.59200000000000,1.59600000000000,1.60000000000000,1.60400000000000,1.60800000000000,1.61200000000000,1.61600000000000,1.62000000000000,1.62400000000000,1.62800000000000,1.63200000000000,1.63600000000000,1.64000000000000,1.64400000000000,1.64800000000000,1.65200000000000,1.65600000000000,1.66000000000000,1.66400000000000,1.66800000000000,1.67200000000000,1.67600000000000,1.68000000000000,1.68400000000000,1.68800000000000,1.69200000000000,1.69600000000000,1.70000000000000,1.70400000000000,1.70800000000000,1.71200000000000,1.71600000000000,1.72000000000000,1.72400000000000,1.72800000000000,1.73200000000000,1.73600000000000,1.74000000000000,1.74400000000000,1.74800000000000,1.75200000000000,1.75600000000000,1.76000000000000,1.76400000000000,1.76800000000000,1.77200000000000,1.77600000000000,1.78000000000000,1.78400000000000,1.78800000000000,1.79200000000000,1.79600000000000,1.80000000000000,1.80400000000000,1.80800000000000,1.81200000000000,1.81600000000000,1.82000000000000,1.82400000000000,1.82800000000000,1.83200000000000,1.83600000000000,1.84000000000000,1.84400000000000,1.84800000000000,1.85200000000000,1.85600000000000,1.86000000000000,1.86400000000000,1.86800000000000,1.87200000000000,1.87600000000000,1.88000000000000,1.88400000000000,1.88800000000000,1.89200000000000,1.89600000000000,1.90000000000000,1.90400000000000,1.90800000000000,1.91200000000000,1.91600000000000,1.92000000000000,1.92400000000000,1.92800000000000,1.93200000000000,1.93600000000000,1.94000000000000,1.94400000000000,1.94800000000000,1.95200000000000,1.95600000000000,1.96000000000000,1.96400000000000,1.96800000000000,1.97200000000000,1.97600000000000,1.98000000000000,1.98400000000000,1.98800000000000,1.99200000000000,1.99600000000000,2,2.00400000000000,2.00800000000000,2.01200000000000,2.01600000000000,2.02000000000000,2.02400000000000,2.02800000000000,2.03200000000000,2.03600000000000,2.04000000000000,2.04400000000000,2.04800000000000,2.05200000000000,2.05600000000000,2.06000000000000,2.06400000000000,2.06800000000000,2.07200000000000,2.07600000000000,2.08000000000000,2.08400000000000,2.08800000000000,2.09200000000000,2.09600000000000,2.10000000000000,2.10400000000000,2.10800000000000,2.11200000000000,2.11600000000000,2.12000000000000,2.12400000000000,2.12800000000000,2.13200000000000,2.13600000000000,2.14000000000000,2.14400000000000,2.14800000000000,2.15200000000000,2.15600000000000,2.16000000000000,2.16400000000000,2.16800000000000,2.17200000000000,2.17600000000000,2.18000000000000,2.18400000000000,2.18800000000000,2.19200000000000,2.19600000000000,2.20000000000000,2.20400000000000,2.20800000000000,2.21200000000000,2.21600000000000,2.22000000000000,2.22400000000000,2.22800000000000,2.23200000000000,2.23600000000000,2.24000000000000,2.24400000000000,2.24800000000000,2.25200000000000,2.25600000000000,2.26000000000000,2.26400000000000,2.26800000000000,2.27200000000000,2.27600000000000,2.28000000000000,2.28400000000000,2.28800000000000,2.29200000000000,2.29600000000000,2.30000000000000,2.30400000000000,2.30800000000000,2.31200000000000,2.31600000000000,2.32000000000000,2.32400000000000,2.32800000000000,2.33200000000000,2.33600000000000,2.34000000000000,2.34400000000000,2.34800000000000,2.35200000000000,2.35600000000000,2.36000000000000,2.36400000000000,2.36800000000000,2.37200000000000,2.37600000000000,2.38000000000000,2.38400000000000,2.38800000000000,2.39200000000000,2.39600000000000,2.40000000000000,2.40400000000000,2.40800000000000,2.41200000000000,2.41600000000000,2.42000000000000,2.42400000000000,2.42800000000000,2.43200000000000,2.43600000000000,2.44000000000000,2.44400000000000,2.44800000000000,2.45200000000000,2.45600000000000,2.46000000000000,2.46400000000000,2.46800000000000,2.47200000000000,2.47600000000000,2.48000000000000,2.48400000000000,2.48800000000000,2.49200000000000,2.49600000000000,2.50000000000000,2.50400000000000,2.50800000000000,2.51200000000000,2.51600000000000,2.52000000000000,2.52400000000000,2.52800000000000,2.53200000000000,2.53600000000000,2.54000000000000,2.54400000000000,2.54800000000000,2.55200000000000,2.55600000000000,2.56000000000000,2.56400000000000,2.56800000000000,2.57200000000000,2.57600000000000,2.58000000000000,2.58400000000000,2.58800000000000,2.59200000000000,2.59600000000000,2.60000000000000,2.60400000000000,2.60800000000000,2.61200000000000,2.61600000000000,2.62000000000000,2.62400000000000,2.62800000000000,2.63200000000000,2.63600000000000,2.64000000000000,2.64400000000000,2.64800000000000,2.65200000000000,2.65600000000000,2.66000000000000,2.66400000000000,2.66800000000000,2.67200000000000,2.67600000000000,2.68000000000000,2.68400000000000,2.68800000000000,2.69200000000000,2.69600000000000,2.70000000000000,2.70400000000000,2.70800000000000,2.71200000000000,2.71600000000000,2.72000000000000,2.72400000000000,2.72800000000000,2.73200000000000,2.73600000000000,2.74000000000000,2.74400000000000,2.74800000000000,2.75200000000000,2.75600000000000,2.76000000000000,2.76400000000000,2.76800000000000,2.77200000000000,2.77600000000000,2.78000000000000,2.78400000000000,2.78800000000000,2.79200000000000,2.79600000000000,2.80000000000000,2.80400000000000,2.80800000000000,2.81200000000000,2.81600000000000,2.82000000000000,2.82400000000000,2.82800000000000,2.83200000000000,2.83600000000000,2.84000000000000,2.84400000000000,2.84800000000000,2.85200000000000,2.85600000000000,2.86000000000000,2.86400000000000,2.86800000000000,2.87200000000000,2.87600000000000,2.88000000000000,2.88400000000000,2.88800000000000,2.89200000000000,2.89600000000000,2.90000000000000,2.90400000000000,2.90800000000000,2.91200000000000,2.91600000000000,2.92000000000000,2.92400000000000,2.92800000000000,2.93200000000000,2.93600000000000,2.94000000000000,2.94400000000000,2.94800000000000,2.95200000000000,2.95600000000000,2.96000000000000,2.96400000000000,2.96800000000000,2.97200000000000,2.97600000000000,2.98000000000000,2.98400000000000,2.98800000000000,2.99200000000000,2.99600000000000,3,3.00400000000000,3.00800000000000,3.01200000000000,3.01600000000000,3.02000000000000,3.02400000000000,3.02800000000000,3.03200000000000,3.03600000000000,3.04000000000000,3.04400000000000,3.04800000000000,3.05200000000000,3.05600000000000,3.06000000000000,3.06400000000000,3.06800000000000,3.07200000000000,3.07600000000000,3.08000000000000,3.08400000000000,3.08800000000000,3.09200000000000,3.09600000000000,3.10000000000000,3.10400000000000,3.10800000000000,3.11200000000000,3.11600000000000,3.12000000000000,3.12400000000000,3.12800000000000,3.13200000000000,3.13600000000000,3.14000000000000,3.14400000000000,3.14800000000000,3.15200000000000,3.15600000000000,3.16000000000000 
};


double MI_map_16qam[MI_MAP_16QAM_SIZE] = {
  0.311657658918262,0.312950120539691,0.314237413971671,0.315519576122440,0.316796643531803,0.318068652376208,0.319335638473721,0.320597637288904,0.321854683937597,0.323106813191606,0.324354059483297,0.325596456910107,0.326834039238967,0.328066839910638,0.329294892043971,0.330518228440083,0.331736881586456,0.332950883660966,0.334160266535828,0.335365061781484,0.336565300670404,0.337761014180833,0.338952233000467,0.340138987530061,0.341321307886976,0.342499223908667,0.343672765156109,0.344841960917162,0.346006840209880,0.347167431785766,0.348323764132971,0.349475865479440,0.350623763796002,0.351767486799416,0.352907061955363,0.354042516481386,0.355173877349791,0.356301171290494,0.357424424793826,0.358543664113292,0.359658915268288,0.360770204046774,0.361877556007904,0.362980996484621,0.364080550586204,0.365176243200783,0.366268098997813,0.367356142430507,0.368440397738239,0.369520888948905,0.370597639881256,0.371670674147187,0.372740015154002,0.373805686106636,0.374867710009856,0.375926109670419,0.376980907699207,0.378032126513326,0.379079788338180,0.380123915209511,0.381164528975415,0.382201651298323,0.383235303656960,0.384265507348277,0.385292283489353,0.386315653019272,0.387335636700973,0.388352255123081,0.389365528701704,0.390375477682212,0.391382122140992,0.392385481987174,0.393385576964342,0.394382426652219,0.395376050468322,0.396366467669612,0.397353697354107,0.398337758462481,0.399318669779643,0.400296449936292,0.401271117410453,0.402242690528999,0.403211187469144,0.404176626259925,0.405139024783662,0.406098400777399,0.407054771834328,0.408008155405198,0.408958568799700,0.409906029187841,0.410850553601299,0.411792158934762,0.412730861947246,0.413666679263405,0.414599627374820,0.415529722641272,0.416456981292003,0.417381419426958,0.418303053018017,0.419221897910207,0.420137969822903,0.421051284351017,0.421961856966165,0.422869703017829,0.423774837734502,0.424677276224815,0.425577033478664,0.426474124368308,0.427368563649465,0.428260365962391,0.429149545832951,0.430036117673671,0.430920095784783,0.431801494355260,0.432680327463833,0.433556609080000,0.434430353065026,0.435301573172926,0.436170283051446,0.437036496243021,0.437900226185734,0.438761486214258,0.439620289560789,0.440476649355968,0.441330578629795,0.442182090312532,0.443031197235597,0.443877912132443,0.444722247639439,0.445564216296728,0.446241386800635,0.447078224576877,0.447912700343638,0.448744826834002,0.449574616685344,0.450402082440181,0.451227236547016,0.452050091361174,0.452870659145633,0.453688952071835,0.454504982220502,0.455318761582433,0.456130302059296,0.456939615464412,0.457746713523533,0.458551607875603,0.459354310073525,0.460154831584905,0.460953183792799,0.461749377996449,0.462543425412006,0.463335337173257,0.464125124332333,0.464912797860415,0.465698368648435,0.466481847507761,0.467263245170889,0.468042572292111,0.468819839448194,0.469595057139034,0.470368235788318,0.471139385744175,0.471908517279813,0.472675640594161,0.473440765812498,0.474203902987074,0.474965062097733,0.475724253052520,0.476481485688287,0.477236769771296,0.477990114997806,0.478741530994668,0.479491027319901,0.480238613463271,0.480984298846859,0.481728092825629,0.482470004687985,0.483210043656323,0.483948218887585,0.484684539473797,0.485419014442608,0.486151652757823,0.486882463319931,0.487611454966627,0.488338636473329,0.489064016553688,0.489787603860101,0.490509406984209,0.491229434457395,0.491947694751280,0.492664196278209,0.493378947391734,0.494091956387095,0.494803231501696,0.495512780915570,0.496220612751849,0.496926735077223,0.497631155902401,0.498333883182558,0.499034924817788,0.499734288653544,0.500431982481084,0.501128014037901,0.501822391008160,0.502515121023123,0.503206211661574,0.503895670450239,0.504583504864202,0.505269722327319,0.505954330212623,0.506637335842736,0.507318746490262,0.507998569378189,0.508676811680282,0.509353480521475,0.510028582978256,0.510702126079049,0.511374116804597,0.512044562088338,0.512713468816774,0.513380843829845,0.514046693921296,0.514711025839036,0.515373846285498,0.516035161918000,0.516694979349094,0.517353305146920,0.518010145835549,0.518665507895329,0.519319397763227,0.519971821833164,0.520622786456354,0.521272297941633,0.521920362555787,0.522566986523883,0.523212176029587,0.523855937215487,0.524498276183410,0.525139198994738,0.525778711670719,0.526416820192776,0.527053530502813,0.527688848503523,0.528322780058684,0.528955330993462,0.529586507094702,0.530216314111229,0.530844757754133,0.531471843697058,0.532097577576492,0.532721964992045,0.533345011506736,0.533966722647266,0.534587103904300,0.535206160732734,0.535823898551975,0.536440322746201,0.537055438664637,0.537669251621813,0.538281766897828,0.538892989738615,0.539178067273364,0.539786132274396,0.540392889758560,0.540998345208540,0.541602504072463,0.542205371764164,0.542806953663444,0.543407255116323,0.544006281435298,0.544604037899594,0.545200529755413,0.545795762216181,0.546389740462796,0.546982469643869,0.547573954875970,0.548164201243860,0.548753213800733,0.549340997568455,0.549927557537787,0.550512898668628,0.551097025890235,0.551679944101458,0.552261658170959,0.552842172937442,0.553421493209870,0.553999623767686,0.554576569361034,0.555152334710972,0.555726924509689,0.556300343420714,0.556872596079132,0.557443687091790,0.558013621037505,0.558582402467269,0.559150035904457,0.559716525845022,0.560281876757703,0.560846093084222,0.561409179239477,0.561971139611745,0.562531978562869,0.563091700428456,0.563650309518066,0.564207810115402,0.564764206478494,0.565319502839892,0.565873703406846,0.566426812361491,0.566978833861027,0.567529772037904,0.568079630999995,0.568628414830776,0.569176127589504,0.569722773311388,0.570268356007764,0.570812879666266,0.571356348250997,0.571898765702698,0.572440135938915,0.572980462854166,0.573519750320104,0.574058002185683,0.574595222277320,0.575131414399054,0.575666582332706,0.576200729838040,0.576733860652918,0.577265978493456,0.577797087054178,0.578327190008172,0.578856291007238,0.579384393682044,0.579911501642270,0.580437618476764,0.580962747753680,0.581486893020633,0.582010057804838,0.582532245613257,0.583053459932742,0.583573704230175,0.584092981952606,0.584611296527401,0.585128651362370,0.585645049845912,0.586160495347147,0.586674991216051,0.587188540783595,0.587701147361870,0.588212814244225,0.588723544705397,0.589233342001638,0.589742209370846,0.590250150032694,0.590757167188753,0.591263264022623,0.591768443700053,0.592272709369068,0.592776064160089,0.593278511186061,0.593780053542566,0.594280694307948,0.594780436543432,0.595279283293242,0.595777237584716,0.596274302428425,0.596770480818288,0.597265775731686,0.597760190129576,0.598253726956604,0.598746389141218,0.599238179595775,0.599729101216658,0.600219156884380,0.600708349463695,0.601196681803704,0.601684156737964,0.602170777084593,0.602656545646377,0.603141465210871,0.603625538550505,0.604108768422687,0.604591157569906,0.605072708719830,0.605553424585410,0.606033307864980,0.606512361242351,0.606990587386916,0.607467988953743,0.607944568583673,0.608420328903419,0.608895272525656,0.609369402049119,0.609842720058696,0.610315229125524,0.610786931807076,0.611257830647258,0.611727928176496,0.612197226911830,0.612665729357001,0.613133438002544,0.613600355325870,0.614066483791360,0.614531825850448,0.614996383941710,0.615460160490949,0.615923157911278,0.616385378603209,0.616846824954733,0.617307499341405,0.617767404126425,0.618226541660722,0.618684914283036,0.619142524319995,0.619599374086200,0.620055465884300,0.620510802005075,0.620965384727511,0.621419216318882,0.621872299034823,0.622324635119409,0.622776226805229,0.623227076313467,0.623677185853969,0.624126557625324,0.624575193814935,0.625023096599094,0.625470268143052,0.625916710601093,0.626362426116607,0.626807416822160,0.627251684839564,0.627695232279947,0.628138061243826,0.628580173821171,0.629021572091478,0.629462258123835,0.629902233976989,0.630341501699417,0.630780063329388,0.631217920895030,0.631655076414398,0.632091531895540,0.632527289336557,0.632962350725669,0.633396718041284,0.633830393252054,0.634263378316940,0.634695675185279,0.635127285796839,0.635558212081886,0.635988455961242,0.636418019346346,0.636846904139316,0.637275112233006,0.637702645511069,0.638129505848011,0.638555695109255,0.638981215151193,0.639406067821249,0.639830254957933,0.640253778390900,0.640676639941004,0.641098841420355,0.641520384632376,0.641941271371856,0.642361503425005,0.642781082569512,0.643200010574591,0.643618289201045,0.644035920201310,0.644452905319515,0.644869246291528,0.645284944845014,0.645700002699482,0.646114421566339,0.646528203148942,0.646941349142644,0.647353861234850,0.647765741105063,0.648176990424934,0.648587610858312,0.648997604061295,0.649406971682274,0.649815715361982,0.650223836733548,0.650631337422535,0.651038219046995,0.651444483217509,0.651850131537241,0.652255165601978,0.652659587000179,0.653063397313018,0.653466598114432,0.653869190971165,0.654271177442811,0.654672559081860,0.655073337433740,0.655473514036863,0.655873090422668,0.656272068115661,0.656670448633460,0.657068233486839,0.657465424179768,0.657862022209452,0.658258029066380,0.658653446234359,0.659048275190558,0.659442517405548,0.659836174343345,0.660229247461446,0.660621738210870,0.661013648036199,0.661404978375616,0.661795730660945,0.662185906317689,0.662575506765066,0.662964533416053,0.663352987677419,0.663740870949762,0.664128184627552,0.664514930099163,0.664901108746911,0.665286721947090,0.665671771070013,0.666056257480040,0.666440182535622,0.666823547589330,0.667206353987895,0.667588603072241,0.667970296177519,0.668351434633144,0.668732019762828,0.669112052884615,0.669491535310911,0.669870468348525,0.670248853298696,0.670626691457129,0.671003984114027,0.671380732554126,0.671756938056725,0.672132601895717,0.672507725339626,0.672882309651635,0.673256356089618,0.673629865906174,0.674002840348655,0.674375280659198,0.674747188074758,0.675118563827135,0.675489409143006,0.675859725243957,0.676229513346510,0.676598774662154,0.676967510397375,0.677335721753685,0.677703409927650,0.678070576110922,0.678437221490264,0.678803347247580,0.679168954559946,0.679534044599635,0.679898618534144,0.680262677526226,0.680626222733914,0.680989255310550,0.681351776404812,0.681713787160742,0.682075288717770,0.682436282210744,0.682796768769954,0.683156749521160,0.683516225585618,0.683875198080104,0.684233668116943,0.684591636804033,0.684949105244868,0.685306074538567,0.685662545779900,0.686018520059308,0.686373998462931,0.686728982072633,0.687083471966025,0.687437469216490,0.687790974893207,0.688143990061174,0.688496515781235,0.688848553110099,0.689200103100368,0.689551166800557,0.689901745255117,0.690251839504462,0.690601450584988,0.690950579529097,0.691299227365220,0.691647395117839,0.691995083807507,0.692342294450876,0.692689028060711,0.693035285645921,0.693381068211572,0.693726376758914,0.694071212285399,0.694415575784706,0.694759468246760,0.695102890657750,0.695445844000157,0.695788329252769,0.696130347390701,0.696471899385420,0.696812986204762,0.697153608812953,0.697493768170630,0.697833465234857,0.698172700959150,0.698511476293495,0.698849792184364,0.699187649574739,0.699525049404130,0.699861992608591,0.700198480120743,0.700534512869792,0.700870091781545,0.701205217778434,0.701539891779528,0.701874114700556,0.702207887453923,0.702541210948731,0.702874086090792,0.703206513782652,0.703538494923604,0.703870030409707,0.704201121133804,0.704531767985541,0.704861971851382,0.705191733614625,0.705521054155423,0.705849934350799,0.706178375074663,0.706506377197826,0.706833941588023,0.707161069109924,0.707487760625153,0.707814016992302,0.708139839066952,0.708465227701683,0.708790183746095,0.709114708046822,0.709438801447546,0.709762464789016,0.710085698909062,0.710408504642612,0.710730882821704,0.711052834275504,0.711374359830321,0.711695460309622,0.712016136534047,0.712336389321422,0.712656219486779,0.712975627842363,0.713294615197654,0.713613182359379,0.713931330131523,0.714249059315349,0.714566370709408,0.714883265109557,0.715199743308968,0.715515806098148,0.715831454264947,0.716146688594576,0.716461509869620,0.716775918870051,0.717089916373239,0.717403503153972,0.717716679984462,0.718029447634365,0.718341806870788,0.718653758458309,0.718965303158981,0.719276441732355,0.719587174935486,0.719897503522947,0.720207428246845,0.720516949856830,0.720826069100108,0.721134786721456,0.721443103463231,0.721751020065387,0.722058537265481,0.722365655798690,0.722672376397823,0.722978699793329,0.723284626713314,0.723590157883548,0.723895294027483,0.724200035866257,0.724504384118712,0.724808339501404,0.725111902728611,0.725415074512349,0.725717855562382,0.726020246586232,0.726322248289192,0.726623861374335,0.726925086542528,0.727225924492439,0.727526375920552,0.727826441521177,0.728126121986458,0.728425418006387,0.728724330268813,0.729022859459453,0.729321006261904,0.729618771357650,0.729916155426075,0.730213159144474,0.730509783188062,0.730806028229982,0.731101894941321,0.731397383991114,0.731692496046358,0.731987231772020,0.732281591831049,0.732575576884382,0.732869187590958,0.733162424607725,0.733455288589651,0.733747780189734,0.734039900059010,0.734331648846563,0.734623027199535,0.734914035763136,0.735204675180651,0.735494946093450,0.735784849141002,0.736074384960875,0.736363554188753,0.736652357458442,0.736940795401878,0.737228868649139,0.737516577828450,0.737803923566195,0.738090906486925,0.738377527213364,0.738663786366423,0.738949684565204,0.739235222427010,0.739520400567354,0.739805219599967,0.740089680136806,0.740373782788065,0.740657528162179,0.740940916865834,0.741223949503978,0.741506626679825,0.741788948994865,0.742070917048873,0.742352531439914,0.742633792764357,0.742914701616873,0.743195258590453,0.743475464276410,0.743755319264390,0.744034824142374,0.744313979496694,0.744592785912035,0.744871243971442,0.745149354256332,0.745427117346498,0.745704533820116,0.745981604253757,0.746258329222388,0.746534709299384,0.746810745056534,0.747086437064048,0.747361785890563,0.747636792103153,0.747911456267333,0.748185778947068,0.748459760704780,0.748733402101353,0.749006703696145,0.749279666046988,0.749552289710199,0.749824575240586,0.750096523191456,0.750368134114619,0.750639408560396,0.750910347077629,0.751180950213680,0.751451218514446,0.751721152524359,0.751990752786397,0.752260019842088,0.752528954231515,0.752797556493329,0.753065827164745,0.753333766781560,0.753601375878148,0.753868654987476,0.754135604641103,0.754402225369190,0.754668517700506,0.754934482162430,0.755200119280965,0.755465429580736,0.755730413584999,0.755995071815650,0.756259404793226,0.756523413036913,0.756787097064554,0.757050457392650,0.757313494536370,0.757576209009556,0.757838601324726,0.758100671993084,0.758362421524521,0.758623850427625,0.758884959209684,0.759145748376690,0.759406218433351,0.759666369883087,0.759926203228045,0.760185718969098,0.760444917605852,0.760703799636653,0.760962365558590,0.761220615867503,0.761478551057985,0.761736171623389,0.761993478055836,0.762250470846214,0.762507150484188,0.762763517458204,0.763019572255492,0.763275315362075,0.763530747262772,0.763785868441201,0.764040679379786,0.764295180559764,0.764549372461186,0.764803255562924,0.765056830342675
};


double MI_map_16qam_axis[MI_MAP_16QAM_SIZE] = {
  1.58000000000000,1.59000000000000,1.60000000000000,1.61000000000000,1.62000000000000,1.63000000000000,1.64000000000000,1.65000000000000,1.66000000000000,1.67000000000000,1.68000000000000,1.69000000000000,1.70000000000000,1.71000000000000,1.72000000000000,1.73000000000000,1.74000000000000,1.75000000000000,1.76000000000000,1.77000000000000,1.78000000000000,1.79000000000000,1.80000000000000,1.81000000000000,1.82000000000000,1.83000000000000,1.84000000000000,1.85000000000000,1.86000000000000,1.87000000000000,1.88000000000000,1.89000000000000,1.90000000000000,1.91000000000000,1.92000000000000,1.93000000000000,1.94000000000000,1.95000000000000,1.96000000000000,1.97000000000000,1.98000000000000,1.99000000000000,2,2.01000000000000,2.02000000000000,2.03000000000000,2.04000000000000,2.05000000000000,2.06000000000000,2.07000000000000,2.08000000000000,2.09000000000000,2.10000000000000,2.11000000000000,2.12000000000000,2.13000000000000,2.14000000000000,2.15000000000000,2.16000000000000,2.17000000000000,2.18000000000000,2.19000000000000,2.20000000000000,2.21000000000000,2.22000000000000,2.23000000000000,2.24000000000000,2.25000000000000,2.26000000000000,2.27000000000000,2.28000000000000,2.29000000000000,2.30000000000000,2.31000000000000,2.32000000000000,2.33000000000000,2.34000000000000,2.35000000000000,2.36000000000000,2.37000000000000,2.38000000000000,2.39000000000000,2.40000000000000,2.41000000000000,2.42000000000000,2.43000000000000,2.44000000000000,2.45000000000000,2.46000000000000,2.47000000000000,2.48000000000000,2.49000000000000,2.50000000000000,2.51000000000000,2.52000000000000,2.53000000000000,2.54000000000000,2.55000000000000,2.56000000000000,2.57000000000000,2.58000000000000,2.59000000000000,2.60000000000000,2.61000000000000,2.62000000000000,2.63000000000000,2.64000000000000,2.65000000000000,2.66000000000000,2.67000000000000,2.68000000000000,2.69000000000000,2.70000000000000,2.71000000000000,2.72000000000000,2.73000000000000,2.74000000000000,2.75000000000000,2.76000000000000,2.77000000000000,2.78000000000000,2.79000000000000,2.80000000000000,2.81000000000000,2.82000000000000,2.83000000000000,2.84000000000000,2.85000000000000,2.86000000000000,2.87000000000000,2.88000000000000,2.89000000000000,2.90000000000000,2.91000000000000,2.92000000000000,2.93000000000000,2.94000000000000,2.95000000000000,2.96000000000000,2.97000000000000,2.98000000000000,2.99000000000000,3,3.01000000000000,3.02000000000000,3.03000000000000,3.04000000000000,3.05000000000000,3.06000000000000,3.07000000000000,3.08000000000000,3.09000000000000,3.10000000000000,3.11000000000000,3.12000000000000,3.13000000000000,3.14000000000000,3.15000000000000,3.16000000000000,3.17000000000000,3.18000000000000,3.19000000000000,3.20000000000000,3.21000000000000,3.22000000000000,3.23000000000000,3.24000000000000,3.25000000000000,3.26000000000000,3.27000000000000,3.28000000000000,3.29000000000000,3.30000000000000,3.31000000000000,3.32000000000000,3.33000000000000,3.34000000000000,3.35000000000000,3.36000000000000,3.37000000000000,3.38000000000000,3.39000000000000,3.40000000000000,3.41000000000000,3.42000000000000,3.43000000000000,3.44000000000000,3.45000000000000,3.46000000000000,3.47000000000000,3.48000000000000,3.49000000000000,3.50000000000000,3.51000000000000,3.52000000000000,3.53000000000000,3.54000000000000,3.55000000000000,3.56000000000000,3.57000000000000,3.58000000000000,3.59000000000000,3.60000000000000,3.61000000000000,3.62000000000000,3.63000000000000,3.64000000000000,3.65000000000000,3.66000000000000,3.67000000000000,3.68000000000000,3.69000000000000,3.70000000000000,3.71000000000000,3.72000000000000,3.73000000000000,3.74000000000000,3.75000000000000,3.76000000000000,3.77000000000000,3.78000000000000,3.79000000000000,3.80000000000000,3.81000000000000,3.82000000000000,3.83000000000000,3.84000000000000,3.85000000000000,3.86000000000000,3.87000000000000,3.88000000000000,3.89000000000000,3.90000000000000,3.91000000000000,3.92000000000000,3.93000000000000,3.94000000000000,3.95000000000000,3.96000000000000,3.97000000000000,3.98000000000000,3.99000000000000,4,4.01000000000000,4.02000000000000,4.03000000000000,4.04000000000000,4.05000000000000,4.06000000000000,4.07000000000000,4.08000000000000,4.09000000000000,4.10000000000000,4.11000000000000,4.12000000000000,4.13000000000000,4.14000000000000,4.15000000000000,4.16000000000000,4.17000000000000,4.18000000000000,4.19000000000000,4.20000000000000,4.21000000000000,4.22000000000000,4.23000000000000,4.24000000000000,4.25000000000000,4.26000000000000,4.27000000000000,4.28000000000000,4.29000000000000,4.30000000000000,4.31000000000000,4.32000000000000,4.33000000000000,4.34000000000000,4.35000000000000,4.36000000000000,4.37000000000000,4.38000000000000,4.39000000000000,4.40000000000000,4.41000000000000,4.42000000000000,4.43000000000000,4.44000000000000,4.45000000000000,4.46000000000000,4.47000000000000,4.48000000000000,4.49000000000000,4.50000000000000,4.51000000000000,4.52000000000000,4.53000000000000,4.54000000000000,4.55000000000000,4.56000000000000,4.57000000000000,4.58000000000000,4.59000000000000,4.60000000000000,4.61000000000000,4.62000000000000,4.63000000000000,4.64000000000000,4.65000000000000,4.66000000000000,4.67000000000000,4.68000000000000,4.69000000000000,4.70000000000000,4.71000000000000,4.72000000000000,4.73000000000000,4.74000000000000,4.75000000000000,4.76000000000000,4.77000000000000,4.78000000000000,4.79000000000000,4.80000000000000,4.81000000000000,4.82000000000000,4.83000000000000,4.84000000000000,4.85000000000000,4.86000000000000,4.87000000000000,4.88000000000000,4.89000000000000,4.90000000000000,4.91000000000000,4.92000000000000,4.93000000000000,4.94000000000000,4.95000000000000,4.96000000000000,4.97000000000000,4.98000000000000,4.99000000000000,5,5.01000000000000,5.02000000000000,5.03000000000000,5.04000000000000,5.05000000000000,5.06000000000000,5.07000000000000,5.08000000000000,5.09000000000000,5.10000000000000,5.11000000000000,5.12000000000000,5.13000000000000,5.14000000000000,5.15000000000000,5.16000000000000,5.17000000000000,5.18000000000000,5.19000000000000,5.20000000000000,5.21000000000000,5.22000000000000,5.23000000000000,5.24000000000000,5.25000000000000,5.26000000000000,5.27000000000000,5.28000000000000,5.29000000000000,5.30000000000000,5.31000000000000,5.32000000000000,5.33000000000000,5.34000000000000,5.35000000000000,5.36000000000000,5.37000000000000,5.38000000000000,5.39000000000000,5.40000000000000,5.41000000000000,5.42000000000000,5.43000000000000,5.44000000000000,5.45000000000000,5.46000000000000,5.47000000000000,5.48000000000000,5.49000000000000,5.50000000000000,5.51000000000000,5.52000000000000,5.53000000000000,5.54000000000000,5.55000000000000,5.56000000000000,5.57000000000000,5.58000000000000,5.59000000000000,5.60000000000000,5.61000000000000,5.62000000000000,5.63000000000000,5.64000000000000,5.65000000000000,5.66000000000000,5.67000000000000,5.68000000000000,5.69000000000000,5.70000000000000,5.71000000000000,5.72000000000000,5.73000000000000,5.74000000000000,5.75000000000000,5.76000000000000,5.77000000000000,5.78000000000000,5.79000000000000,5.80000000000000,5.81000000000000,5.82000000000000,5.83000000000000,5.84000000000000,5.85000000000000,5.86000000000000,5.87000000000000,5.88000000000000,5.89000000000000,5.90000000000000,5.91000000000000,5.92000000000000,5.93000000000000,5.94000000000000,5.95000000000000,5.96000000000000,5.97000000000000,5.98000000000000,5.99000000000000,6,6.01000000000000,6.02000000000000,6.03000000000000,6.04000000000000,6.05000000000000,6.06000000000000,6.07000000000000,6.08000000000000,6.09000000000000,6.10000000000000,6.11000000000000,6.12000000000000,6.13000000000000,6.14000000000000,6.15000000000000,6.16000000000000,6.17000000000000,6.18000000000000,6.19000000000000,6.20000000000000,6.21000000000000,6.22000000000000,6.23000000000000,6.24000000000000,6.25000000000000,6.26000000000000,6.27000000000000,6.28000000000000,6.29000000000000,6.30000000000000,6.31000000000000,6.32000000000000,6.33000000000000,6.34000000000000,6.35000000000000,6.36000000000000,6.37000000000000,6.38000000000000,6.39000000000000,6.40000000000000,6.41000000000000,6.42000000000000,6.43000000000000,6.44000000000000,6.45000000000000,6.46000000000000,6.47000000000000,6.48000000000000,6.49000000000000,6.50000000000000,6.51000000000000,6.52000000000000,6.53000000000000,6.54000000000000,6.55000000000000,6.56000000000000,6.57000000000000,6.58000000000000,6.59000000000000,6.60000000000000,6.61000000000000,6.62000000000000,6.63000000000000,6.64000000000000,6.65000000000000,6.66000000000000,6.67000000000000,6.68000000000000,6.69000000000000,6.70000000000000,6.71000000000000,6.72000000000000,6.73000000000000,6.74000000000000,6.75000000000000,6.76000000000000,6.77000000000000,6.78000000000000,6.79000000000000,6.80000000000000,6.81000000000000,6.82000000000000,6.83000000000000,6.84000000000000,6.85000000000000,6.86000000000000,6.87000000000000,6.88000000000000,6.89000000000000,6.90000000000000,6.91000000000000,6.92000000000000,6.93000000000000,6.94000000000000,6.95000000000000,6.96000000000000,6.97000000000000,6.98000000000000,6.99000000000000,7,7.01000000000000,7.02000000000000,7.03000000000000,7.04000000000000,7.05000000000000,7.06000000000000,7.07000000000000,7.08000000000000,7.09000000000000,7.10000000000000,7.11000000000000,7.12000000000000,7.13000000000000,7.14000000000000,7.15000000000000,7.16000000000000,7.17000000000000,7.18000000000000,7.19000000000000,7.20000000000000,7.21000000000000,7.22000000000000,7.23000000000000,7.24000000000000,7.25000000000000,7.26000000000000,7.27000000000000,7.28000000000000,7.29000000000000,7.30000000000000,7.31000000000000,7.32000000000000,7.33000000000000,7.34000000000000,7.35000000000000,7.36000000000000,7.37000000000000,7.38000000000000,7.39000000000000,7.40000000000000,7.41000000000000,7.42000000000000,7.43000000000000,7.44000000000000,7.45000000000000,7.46000000000000,7.47000000000000,7.48000000000000,7.49000000000000,7.50000000000000,7.51000000000000,7.52000000000000,7.53000000000000,7.54000000000000,7.55000000000000,7.56000000000000,7.57000000000000,7.58000000000000,7.59000000000000,7.60000000000000,7.61000000000000,7.62000000000000,7.63000000000000,7.64000000000000,7.65000000000000,7.66000000000000,7.67000000000000,7.68000000000000,7.69000000000000,7.70000000000000,7.71000000000000,7.72000000000000,7.73000000000000,7.74000000000000,7.75000000000000,7.76000000000000,7.77000000000000,7.78000000000000,7.79000000000000,7.80000000000000,7.81000000000000,7.82000000000000,7.83000000000000,7.84000000000000,7.85000000000000,7.86000000000000,7.87000000000000,7.88000000000000,7.89000000000000,7.90000000000000,7.91000000000000,7.92000000000000,7.93000000000000,7.94000000000000,7.95000000000000,7.96000000000000,7.97000000000000,7.98000000000000,7.99000000000000,8,8.01000000000000,8.02000000000000,8.03000000000000,8.04000000000000,8.05000000000000,8.06000000000000,8.07000000000000,8.08000000000000,8.09000000000000,8.10000000000000,8.11000000000000,8.12000000000000,8.13000000000000,8.14000000000000,8.15000000000000,8.16000000000000,8.17000000000000,8.18000000000000,8.19000000000000,8.20000000000000,8.21000000000000,8.22000000000000,8.23000000000000,8.24000000000000,8.25000000000000,8.26000000000000,8.27000000000000,8.28000000000000,8.29000000000000,8.30000000000000,8.31000000000000,8.32000000000000,8.33000000000000,8.34000000000000,8.35000000000000,8.36000000000000,8.37000000000000,8.38000000000000,8.39000000000000,8.40000000000000,8.41000000000000,8.42000000000000,8.43000000000000,8.44000000000000,8.45000000000000,8.46000000000000,8.47000000000000,8.48000000000000,8.49000000000000,8.50000000000000,8.51000000000000,8.52000000000000,8.53000000000000,8.54000000000000,8.55000000000000,8.56000000000000,8.57000000000000,8.58000000000000,8.59000000000000,8.60000000000000,8.61000000000000,8.62000000000000,8.63000000000000,8.64000000000000,8.65000000000000,8.66000000000000,8.67000000000000,8.68000000000000,8.69000000000000,8.70000000000000,8.71000000000000,8.72000000000000,8.73000000000000,8.74000000000000,8.75000000000000,8.76000000000000,8.77000000000000,8.78000000000000,8.79000000000000,8.80000000000000,8.81000000000000,8.82000000000000,8.83000000000000,8.84000000000000,8.85000000000000,8.86000000000000,8.87000000000000,8.88000000000000,8.89000000000000,8.90000000000000,8.91000000000000,8.92000000000000,8.93000000000000,8.94000000000000,8.95000000000000,8.96000000000000,8.97000000000000,8.98000000000000,8.99000000000000,9,9.01000000000000,9.02000000000000,9.03000000000000,9.04000000000000,9.05000000000000,9.06000000000000,9.07000000000000,9.08000000000000,9.09000000000000,9.10000000000000,9.11000000000000,9.12000000000000,9.13000000000000,9.14000000000000,9.15000000000000,9.16000000000000,9.17000000000000,9.18000000000000,9.19000000000000,9.20000000000000,9.21000000000000,9.22000000000000,9.23000000000000,9.24000000000000,9.25000000000000,9.26000000000000,9.27000000000000,9.28000000000000,9.29000000000000,9.30000000000000,9.31000000000000,9.32000000000000,9.33000000000000,9.34000000000000,9.35000000000000,9.36000000000000,9.37000000000000,9.38000000000000,9.39000000000000,9.40000000000000,9.41000000000000,9.42000000000000,9.43000000000000,9.44000000000000,9.45000000000000,9.46000000000000,9.47000000000000,9.48000000000000,9.49000000000000,9.50000000000000,9.51000000000000,9.52000000000000,9.53000000000000,9.54000000000000,9.55000000000000,9.56000000000000,9.57000000000000,9.58000000000000,9.59000000000000,9.60000000000000,9.61000000000000,9.62000000000000,9.63000000000000,9.64000000000000,9.65000000000000,9.66000000000000,9.67000000000000,9.68000000000000,9.69000000000000,9.70000000000000,9.71000000000000,9.72000000000000,9.73000000000000,9.74000000000000,9.75000000000000,9.76000000000000,9.77000000000000,9.78000000000000,9.79000000000000,9.80000000000000,9.81000000000000,9.82000000000000,9.83000000000000,9.84000000000000,9.85000000000000,9.86000000000000,9.87000000000000,9.88000000000000,9.89000000000000,9.90000000000000,9.91000000000000,9.92000000000000,9.93000000000000,9.94000000000000,9.95000000000000,9.96000000000000,9.97000000000000,9.98000000000000,9.99000000000000,10
};


double MI_map_64qam[MI_MAP_64QAM_SIZE] = {
  0.425799529860325,0.432152765542146,0.438303333109796,0.444263205182515,0.450043499926380,0.455654548839940,0.461105958376616,0.466406666073195,0.471564991764758,0.476588684391735,0.481484964841807,0.486260565215892,0.490921764861760,0.495474423479624,0.499924011570203,0.504275638466426,0.508316095962828,0.512480868968701,0.516559604267418,0.520556384497397,0.524475035168484,0.528319142485428,0.532092069836711,0.535796973058398,0.539436814572552,0.543014376490667,0.546532272764480,0.549992960459215,0.553398750217790,0.556751815978591,0.560054204004096,0.563307841272820,0.566514543282682,0.569676021309938,0.572793889164217,0.575869669476956,0.578904799557506,0.581900636848503,0.584858464009598,0.587779493656374,0.590664872779198,0.593515686864887,0.596332963742270,0.599117677171195,0.601870750193001,0.604593058259183,0.607285432153689,0.609948660723186,0.612583493428562,0.615190642729957,0.617770786316747,0.620324569193049,0.622852605628593,0.625355480984068,0.627833753419418,0.630287955492967,0.632718595658690,0.635126159668431,0.637511111885396,0.639873896514816,0.642214938757252,0.644534645889648,0.646833408278874,0.649111600332195,0.651369581388777,0.653607696556073,0.655608484392638,0.657805717412332,0.659983677718680,0.662142681139671,0.664283032363931,0.666405025526737,0.668508944760826,0.670595064714242,0.672663651037313,0.674714960840703,0.676749243126363,0.678766739193092,0.680767683018287,0.682752301617383,0.684720815382362,0.686673438400645,0.688610378755565,0.690531838809586,0.692438015471299,0.694329100447223,0.696205280479322,0.698066737569122,0.699913649189236,0.701746188483077,0.703564524453455,0.705368822140750,0.707159242791271,0.708935944016411,0.710699079943126,0.712448801356279,0.714185255833317,0.715908587871746,0.717618939009822,0.719316447940871,0.721001250621597,0.722673480374747,0.724333267986447,0.725980741798532,0.727616027796153,0.729239249690943,0.730850528999982,0.732449985120826,0.734037735402802,0.735613895214796,0.737178578009731,0.738731895385921,0.740273957145479,0.741804871349938,0.743324744373253,0.744833680952319,0.746331784235150,0.747819155826846,0.749295895833466,0.750762102903929,0.752217874270045,0.753663305784784,0.755098491958862,0.756523525995766,0.757938499825260,0.759343504135493,0.760738628403754,0.762123960925963,0.763499588844953,0.764865598177612,0.766222073840946,0.767569099677114,0.768906758477484,0.770235132005777,0.771554301020318,0.772864345295472,0.774165343642269,0.775457373928296,0.776740513096859,0.778014837185474,0.779280421343709,0.780537339850405,0.781785666130325,0.783025472770225,0.784256831534413,0.785479813379787,0.786694488470398,0.787900926191545,0.789099195163442,0.790289363254448,0.791471497593914,0.792645664584633,0.793811929914931,0.794970358570407,0.796121014845337,0.797263962353755,0.798399264040234,0.799526982190367,0.800647178440967,0.801759913789999,0.802865248606254,0.803963242638769,0.805053955026016,0.806137444304855,0.807213768419270,0.808282984728894,0.809345150017332,0.810400320500280,0.811448551833468,0.812489899120409,0.813524416919983,0.814552159253849,0.815573179613692,0.816587530968313,0.817595265770578,0.818596435964203,0.819591092990417,0.820579287794472,0.821561070832035,0.822536492075441,0.823505601019831,0.824468446689165,0.825425077642123,0.826375541977893,0.827319887341849,0.828258160931124,0.829190409500083,0.830116679365692,0.831037016412797,0.831951466099307,0.832860073461282,0.833762883117939,0.834659939276567,0.835551285737364,0.836436965898189,0.837317022759230,0.838191498927611,0.839060436621904,0.839923877676581,0.840781863546392,0.841634435310673,0.842481633677584,0.843323498988284,0.844160071221040,0.844991389995275,0.845817494575551,0.846638423875496,0.847454216461666,0.848264910557361,0.849070544046372,0.849871154476679,0.850666779064099,0.851457454695876,0.852243217934223,0.853024105019807,0.853800151875197,0.854571394108254,0.855337867015476,0.856099605585298,0.856856644501345,0.857609018145645,0.858356760601792,0.859099905658072,0.859838486810540,0.860572537266066,0.861302089945333,0.862027177485795,0.862747832244604,0.863464086301487,0.864175971461601,0.864883519258332,0.865586760956078,0.866285727552980,0.866980449783629,0.867670958121734,0.868357282782756,0.869039453726513,0.869717500659743,0.870391453038652,0.871061340071411,0.871727190720637,0.872389033705835,0.873046897505813,0.873700810361071,0.874350800276154,0.874996895021982,0.875639122138150,0.876277508935201,0.876912082496870,0.877542869682304,0.878169897128256,0.878793191251247,0.879412778249713,0.880028684106114,0.880640934589032,0.881249555255233,0.881854571451712,0.882456008317711,0.883053890786716,0.883648243588427,0.884239091250713,0.884826458101536,0.885410368270855,0.885990845692519,0.886567914106118,0.887141597058834,0.887711917907260,0.888278899819195,0.888842565775432,0.889402938571516,0.889960040819480,0.890513894949575,0.891064523211966,0.891611947678416,0.892156190243955,0.892697272628524,0.893235216378603,0.893770042868823,0.894301773303559,0.894830428718505,0.895356029982234,0.895878597797741,0.896398152703964,0.896914715077295,0.897428305133075,0.897938942927067,0.898446648356916,0.898951441163598,0.899453340932846,0.899952367096565,0.900448538934234,0.900941875574287,0.901432395995483,0.901920119028266,0.902405063356100,0.902887247516799,0.903366689903843,0.903843408767670,0.904317422216969,0.904788748219949,0.905257404605599,0.905723409064933,0.906186779152225,0.906647532286227,0.907105685751380,0.907561256699007,0.908014262148496,0.908464718988472,0.908912643977957,0.909358053747514,0.909800964800386,0.910241393513615,0.910679356139161,0.911114868804997,0.911547947516201,0.911978608156038,0.912406866487023,0.912832738151982,0.913256238675097,0.913677383462941,0.914096187805506,0.914512666877219,0.914926835737943,0.915338709333977,0.915748302499040,0.916155629955243,0.916560706314060,0.916963546077282,0.917364163637964,0.917762573281363,0.918158789185863,0.918552825423898,0.918944695962863,0.919334414666011,0.919721995293345,0.920107451502508,0.920490796849650,0.920872044790299,0.921251208680219,0.921628301776257,0.922003337237186,0.922376328124537,0.922747287403428,0.923116227943374,0.923483162519103,0.923848103811354,0.924211064407671,0.924572056803190,0.924931093401418,0.925288186515000,0.925643348366488,0.925996591089095,0.926347926727443,0.926697367238308,0.927044924491352,0.927390610269852,0.927734436271422,0.928076414108724,0.928416555310182,0.928754871320675,0.929091373502235,0.929426073134737,0.929758981416575,0.930090109465339,0.930419468318485,0.930747068933993,0.931072922191030,0.931397038890590,0.931719429756146,0.932040105434284,0.932359076495335,0.932676353434002,0.932991946669978,0.933305866548562,0.933618123341268,0.933928727246427,0.934237688389781,0.934545016825084,0.934850722534678,0.935154815430080,0.935457305352558,0.935758202073696,0.936057515295968,0.936355254653287,0.936651429711569,0.936946049969278,0.937239124857973,0.937530663742845,0.937820675923255,0.938109170633261,0.938396157042145,0.938681644254934,0.938965641312914,0.939248157194139,0.939529200813942,0.939808781025436,0.940086906620007,0.940363586327811,0.940638828818259,0.940912642700505,0.941185036523922,0.941456018778579,0.941725597895711,0.941993782248186,0.942260580150969,0.942525999861578,0.942790049580541,0.943052737451843,0.943314071563375,0.943574059947377,0.943832710580874,0.944090031386110,0.944346030230983,0.944600714929465,0.944854093242033,0.945106172876082,0.945356961486342,0.945606466675294,0.945854695993572,0.946101656940372,0.946347356963852,0.946591803461529,0.946835003780675,0.947076965218706,0.947317695023567,0.947557200394124,0.947795488480533,0.948032566384627,0.948268441160285,0.948503119813805,0.948736609304268,0.948968916543906,0.949200048398461,0.949430011687544,0.949658813184989,0.949886459619203,0.950112957673521,0.950338313986543,0.950562535152485,0.950785627721511,0.951007598200077,0.951228453051260,0.951448198695091,0.951666841508883,0.951884387827557,0.952100843943963,0.952316216109200,0.952530510532938,0.952743733383722,0.952955890789296,0.953166988836902,0.953377033573592,0.953586031006531,0.953793987103297,0.954000907792180,0.954206798962479,0.954411666464793,0.954615516111316,0.954818353676125,0.955020184895462,0.955221015468023,0.955420851055236,0.955619697281543,0.955817559734673,0.956014443965919,0.956210355490410,0.956405299787380,0.956599282300436,0.956792308437822,0.956984383572683,0.957175513043328,0.957365702153483,0.957554956172555,0.957743280335878,0.957930679844975,0.958117159867796,0.958302725538980,0.958487381960088,0.958671134199857,0.958853987294433,0.959035946247621,0.959217016031113,0.959397201584732,0.959576507816660,0.959754939603674,0.959932501791373,0.960109199194410,0.960285036596717,0.960460018751725,0.960634150382595,0.960807436182432,0.960979880814507,0.961151488912474,0.961322265080584,0.961492213893903,0.961661339898516,0.961829647611747,0.961997141522358,0.962163826090764,0.962329705749233,0.962494784902090,0.962659067925920,0.962822559169769,0.962985262955340,0.963147183577191,0.963308325302933,0.963468692373418,0.963628289002937,0.963787119379405,0.963945187664557,0.964102497994129,0.964259054478047,0.964414861200612,0.964569922220681,0.964724241571851,0.964877823262637,0.965030671276653,0.965182789572787,0.965334182085377,0.965484852724386,0.965634805375577,0.965784043900681,0.965932572137569,0.966080393900422,0.966227512979896,0.966373933143291,0.966519658134713,0.966664691675240,0.966809037463084,0.966952699173750,0.967095680460197,0.967237984953000,0.967379616260498,0.967520577968961,0.967660873642736,0.967800506824406,0.967939481034939,0.968077799773840,0.968215466519302,0.968352484728355,0.968488857837010,0.968624589260409,0.968759682392970,0.968894140608528,0.969027967260483,0.969161165681936,0.969293739185835,0.969425691065112,0.969557024592820,0.969687743022276,0.969817849587190,0.969947347501806,0.970076239961035,0.970204530140587,0.970332221197102,0.970459316268287,0.970585818473037,0.970711730911575,0.970837056665570,0.970961798798270,0.971085960354628,0.971209544361425,0.971332553827393,0.971454991743346,0.971576861082290,0.971698164799557,0.971818905832916,0.971939087102697,0.972058711511910,0.972177781946360,0.972296301274765,0.972414272348874,0.972531698003577,0.972648581057026,0.972764924310741,0.972880730549728,0.972996002542588,0.973110743041627,0.973224954782968,0.973338640486660,0.973451802856782,0.973564444581555,0.973676568333449,0.973788176769283,0.973899272530336,0.974009858242448,0.974119936516125,0.974229509946639,0.974338581114133,0.974447152583720,0.974555226905582,0.974662806615074,0.974769894232819,0.974876492264805,0.974982603202487,0.975088229522879,0.975193373688653,0.975298038148231,0.975402225335882,0.975505937671815,0.975609177562271,0.975711947399617,0.975814249562435,0.975916086415616,0.976017460310448,0.976118373584707,0.976218828562744,0.976318827555575,0.976418372860967,0.976517466763529,0.976616111534792,0.976714309433298,0.976812062704687,0.976909373581777,0.977006244284652,0.977102677020741,0.977198673984903,0.977294237359509,0.977389369314524,0.977484072007585,0.977578347584082,0.977672198177240,0.977765625908194,0.977858632886072,0.977951221208068,0.978043392959523,0.978135150213998,0.978226495033355,0.978317429467828,0.978407955556099,0.978498075325375,0.978587790791458,0.978677103958823,0.978766016820685,0.978854531359077,0.978942649544919,0.979030373338087,0.979117704687488,0.979204645531130,0.979291197796188,0.979377363399073,0.979463144245509,0.979548542230591,0.979633559238856,0.979718197144355,0.979802457810712,0.979886343091196,0.979969854828785,0.980052994856231,0.980135764996123,0.980218167060957,0.980300202853193,0.980381874165323,0.980463182779933,0.980544130469765,0.980624718997779,0.980704950117214,0.980784825571653,0.980864347095078,0.980943516411935,0.981022335237191,0.981100805276397,0.981178928225740,0.981256705772112,0.981334139593159,0.981411231357343,0.981487982723999,0.981564395343393,0.981640470856775,0.981716210896438,0.981791617085776,0.981866691039334,0.981941434362866,0.982015848653390,0.982089935499241,0.982163696480127,0.982237133167180,0.982310247123007,0.982383039901752,0.982455513049136,0.982527668102518,0.982599506590944,0.982671030035196,0.982742239947848,0.982813137833309,0.982883725187881,0.982954003499805,0.983023974249309,0.983093638908661,0.983162998942216,0.983232055806461,0.983300810950072,0.983369265813951,0.983437421831281,0.983505280427573,0.983572843020706,0.983640111020982,0.983707085831166,0.983773768846536,0.983840161454926,0.983906265036770,0.983972080965153,0.984037610605846,0.984102855317361,0.984167816450986,0.984232495350835,0.984296893353885,0.984361011790027,0.984424851982101,0.984488415245946,0.984551702890434,0.984614716217520,0.984677456522277,0.984739925092941,0.984802123210953,0.984864052150994,0.984925713181035,0.984987107562366,0.985048236549646,0.985109101390936,0.985169703327743,0.985230043595053,0.985290123421378,0.985349944028789,0.985409506632955
};

double MI_map_64qam_axis[MI_MAP_64QAM_SIZE] = {
  6.30000000000000,6.51000000000000,6.72000000000000,6.93000000000000,7.14000000000000,7.35000000000000,7.56000000000000,7.77000000000000,7.98000000000000,8.19000000000000,8.40000000000000,8.61000000000000,8.82000000000000,9.03000000000000,9.24000000000000,9.45000000000000,9.66000000000000,9.87000000000000,10.0800000000000,10.2900000000000,10.5000000000000,10.7100000000000,10.9200000000000,11.1300000000000,11.3400000000000,11.5500000000000,11.7600000000000,11.9700000000000,12.1800000000000,12.3900000000000,12.6000000000000,12.8100000000000,13.0200000000000,13.2300000000000,13.4400000000000,13.6500000000000,13.8600000000000,14.0700000000000,14.2800000000000,14.4900000000000,14.7000000000000,14.9100000000000,15.1200000000000,15.3300000000000,15.5400000000000,15.7500000000000,15.9600000000000,16.1700000000000,16.3800000000000,16.5900000000000,16.8000000000000,17.0100000000000,17.2200000000000,17.4300000000000,17.6400000000000,17.8500000000000,18.0600000000000,18.2700000000000,18.4800000000000,18.6900000000000,18.9000000000000,19.1100000000000,19.3200000000000,19.5300000000000,19.7400000000000,19.9500000000000,20.1600000000000,20.3700000000000,20.5800000000000,20.7900000000000,21,21.2100000000000,21.4200000000000,21.6300000000000,21.8400000000000,22.0500000000000,22.2600000000000,22.4700000000000,22.6800000000000,22.8900000000000,23.1000000000000,23.3100000000000,23.5200000000000,23.7300000000000,23.9400000000000,24.1500000000000,24.3600000000000,24.5700000000000,24.7800000000000,24.9900000000000,25.2000000000000,25.4100000000000,25.6200000000000,25.8300000000000,26.0400000000000,26.2500000000000,26.4600000000000,26.6700000000000,26.8800000000000,27.0900000000000,27.3000000000000,27.5100000000000,27.7200000000000,27.9300000000000,28.1400000000000,28.3500000000000,28.5600000000000,28.7700000000000,28.9800000000000,29.1900000000000,29.4000000000000,29.6100000000000,29.8200000000000,30.0300000000000,30.2400000000000,30.4500000000000,30.6600000000000,30.8700000000000,31.0800000000000,31.2900000000000,31.5000000000000,31.7100000000000,31.9200000000000,32.1300000000000,32.3400000000000,32.5500000000000,32.7600000000000,32.9700000000000,33.1800000000000,33.3900000000000,33.6000000000000,33.8100000000000,34.0200000000000,34.2300000000000,34.4400000000000,34.6500000000000,34.8600000000000,35.0700000000000,35.2800000000000,35.4900000000000,35.7000000000000,35.9100000000000,36.1200000000000,36.3300000000000,36.5400000000000,36.7500000000000,36.9600000000000,37.1700000000000,37.3800000000000,37.5900000000000,37.8000000000000,38.0100000000000,38.2200000000000,38.4300000000000,38.6400000000000,38.8500000000000,39.0600000000000,39.2700000000000,39.4800000000000,39.6900000000000,39.9000000000000,40.1100000000000,40.3200000000000,40.5300000000000,40.7400000000000,40.9500000000000,41.1600000000000,41.3700000000000,41.5800000000000,41.7900000000000,42.0000000000000,42.2100000000000,42.4200000000000,42.6300000000000,42.8400000000000,43.0500000000000,43.2600000000000,43.4700000000000,43.6800000000000,43.8900000000000,44.1000000000000,44.3100000000000,44.5200000000000,44.7300000000000,44.9400000000000,45.1500000000000,45.3600000000000,45.5700000000000,45.7800000000000,45.9900000000000,46.2000000000000,46.4100000000000,46.6200000000000,46.8300000000000,47.0400000000000,47.2500000000000,47.4600000000000,47.6700000000000,47.8800000000000,48.0900000000000,48.3000000000000,48.5100000000000,48.7200000000000,48.9300000000000,49.1400000000000,49.3500000000000,49.5600000000000,49.7700000000000,49.9800000000000,50.1900000000000,50.4000000000000,50.6100000000000,50.8200000000000,51.0300000000000,51.2400000000000,51.4500000000000,51.6600000000000,51.8700000000000,52.0800000000000,52.2900000000000,52.5000000000000,52.7100000000000,52.9200000000000,53.1300000000000,53.3400000000000,53.5500000000000,53.7600000000000,53.9700000000000,54.1800000000000,54.3900000000000,54.6000000000000,54.8100000000000,55.0200000000000,55.2300000000000,55.4400000000000,55.6500000000000,55.8600000000000,56.0700000000000,56.2800000000000,56.4900000000000,56.7000000000000,56.9100000000000,57.1200000000000,57.3300000000000,57.5400000000000,57.7500000000000,57.9600000000000,58.1700000000000,58.3800000000000,58.5900000000000,58.8000000000000,59.0100000000000,59.2200000000000,59.4300000000000,59.6400000000000,59.8500000000000,60.0600000000000,60.2700000000000,60.4800000000000,60.6900000000000,60.9000000000000,61.1100000000000,61.3200000000000,61.5300000000000,61.7400000000000,61.9500000000000,62.1600000000000,62.3700000000000,62.5800000000000,62.7900000000000,63.0000000000000,63.2100000000000,63.4200000000000,63.6300000000000,63.8400000000000,64.0500000000000,64.2600000000000,64.4700000000000,64.6800000000000,64.8900000000000,65.1000000000000,65.3100000000000,65.5200000000000,65.7300000000000,65.9400000000000,66.1500000000000,66.3600000000000,66.5700000000000,66.7800000000000,66.9900000000000,67.2000000000000,67.4100000000000,67.6200000000000,67.8300000000000,68.0400000000000,68.2500000000000,68.4600000000000,68.6700000000000,68.8800000000000,69.0900000000000,69.3000000000000,69.5100000000000,69.7200000000000,69.9300000000000,70.1400000000000,70.3500000000000,70.5600000000000,70.7700000000000,70.9800000000000,71.1900000000000,71.4000000000000,71.6100000000000,71.8200000000000,72.0300000000000,72.2400000000000,72.4500000000000,72.6600000000000,72.8700000000000,73.0800000000000,73.2900000000000,73.5000000000000,73.7100000000000,73.9200000000000,74.1300000000000,74.3400000000000,74.5500000000000,74.7600000000000,74.9700000000000,75.1800000000000,75.3900000000000,75.6000000000000,75.8100000000000,76.0200000000000,76.2300000000000,76.4400000000000,76.6500000000000,76.8600000000000,77.0700000000000,77.2800000000000,77.4900000000000,77.7000000000000,77.9100000000000,78.1200000000000,78.3300000000000,78.5400000000000,78.7500000000000,78.9600000000000,79.1700000000000,79.3800000000000,79.5900000000000,79.8000000000000,80.0100000000000,80.2200000000000,80.4300000000000,80.6400000000000,80.8500000000000,81.0600000000000,81.2700000000000,81.4800000000000,81.6900000000000,81.9000000000000,82.1100000000000,82.3200000000000,82.5300000000000,82.7400000000000,82.9500000000000,83.1600000000000,83.3700000000000,83.5800000000000,83.7900000000000,84,84.2100000000000,84.4200000000000,84.6300000000000,84.8400000000000,85.0500000000000,85.2600000000000,85.4700000000000,85.6800000000000,85.8900000000000,86.1000000000000,86.3100000000000,86.5200000000000,86.7300000000000,86.9400000000000,87.1500000000000,87.3600000000000,87.5700000000000,87.7800000000000,87.9900000000000,88.2000000000000,88.4100000000000,88.6200000000000,88.8300000000000,89.0400000000000,89.2500000000000,89.4600000000000,89.6700000000000,89.8800000000000,90.0900000000000,90.3000000000000,90.5100000000000,90.7200000000000,90.9300000000000,91.1400000000000,91.3500000000000,91.5600000000000,91.7700000000000,91.9800000000000,92.1900000000000,92.4000000000000,92.6100000000000,92.8200000000000,93.0300000000000,93.2400000000000,93.4500000000000,93.6600000000000,93.8700000000000,94.0800000000000,94.2900000000000,94.5000000000000,94.7100000000000,94.9200000000000,95.1300000000000,95.3400000000000,95.5500000000000,95.7600000000000,95.9700000000000,96.1800000000000,96.3900000000000,96.6000000000000,96.8100000000000,97.0200000000000,97.2300000000000,97.4400000000000,97.6500000000000,97.8600000000000,98.0700000000000,98.2800000000000,98.4900000000000,98.7000000000000,98.9100000000000,99.1200000000000,99.3300000000000,99.5400000000000,99.7500000000000,99.9600000000000,100.170000000000,100.380000000000,100.590000000000,100.800000000000,101.010000000000,101.220000000000,101.430000000000,101.640000000000,101.850000000000,102.060000000000,102.270000000000,102.480000000000,102.690000000000,102.900000000000,103.110000000000,103.320000000000,103.530000000000,103.740000000000,103.950000000000,104.160000000000,104.370000000000,104.580000000000,104.790000000000,105,105.210000000000,105.420000000000,105.630000000000,105.840000000000,106.050000000000,106.260000000000,106.470000000000,106.680000000000,106.890000000000,107.100000000000,107.310000000000,107.520000000000,107.730000000000,107.940000000000,108.150000000000,108.360000000000,108.570000000000,108.780000000000,108.990000000000,109.200000000000,109.410000000000,109.620000000000,109.830000000000,110.040000000000,110.250000000000,110.460000000000,110.670000000000,110.880000000000,111.090000000000,111.300000000000,111.510000000000,111.720000000000,111.930000000000,112.140000000000,112.350000000000,112.560000000000,112.770000000000,112.980000000000,113.190000000000,113.400000000000,113.610000000000,113.820000000000,114.030000000000,114.240000000000,114.450000000000,114.660000000000,114.870000000000,115.080000000000,115.290000000000,115.500000000000,115.710000000000,115.920000000000,116.130000000000,116.340000000000,116.550000000000,116.760000000000,116.970000000000,117.180000000000,117.390000000000,117.600000000000,117.810000000000,118.020000000000,118.230000000000,118.440000000000,118.650000000000,118.860000000000,119.070000000000,119.280000000000,119.490000000000,119.700000000000,119.910000000000,120.120000000000,120.330000000000,120.540000000000,120.750000000000,120.960000000000,121.170000000000,121.380000000000,121.590000000000,121.800000000000,122.010000000000,122.220000000000,122.430000000000,122.640000000000,122.850000000000,123.060000000000,123.270000000000,123.480000000000,123.690000000000,123.900000000000,124.110000000000,124.320000000000,124.530000000000,124.740000000000,124.950000000000,125.160000000000,125.370000000000,125.580000000000,125.790000000000,126,126.210000000000,126.420000000000,126.630000000000,126.840000000000,127.050000000000,127.260000000000,127.470000000000,127.680000000000,127.890000000000,128.100000000000,128.310000000000,128.520000000000,128.730000000000,128.940000000000,129.150000000000,129.360000000000,129.570000000000,129.780000000000,129.990000000000,130.200000000000,130.410000000000,130.620000000000,130.830000000000,131.040000000000,131.250000000000,131.460000000000,131.670000000000,131.880000000000,132.090000000000,132.300000000000,132.510000000000,132.720000000000,132.930000000000,133.140000000000,133.350000000000,133.560000000000,133.770000000000,133.980000000000,134.190000000000,134.400000000000,134.610000000000,134.820000000000,135.030000000000,135.240000000000,135.450000000000,135.660000000000,135.870000000000,136.080000000000,136.290000000000,136.500000000000,136.710000000000,136.920000000000,137.130000000000,137.340000000000,137.550000000000,137.760000000000,137.970000000000,138.180000000000,138.390000000000,138.600000000000,138.810000000000,139.020000000000,139.230000000000,139.440000000000,139.650000000000,139.860000000000,140.070000000000,140.280000000000,140.490000000000,140.700000000000,140.910000000000,141.120000000000,141.330000000000,141.540000000000,141.750000000000,141.960000000000,142.170000000000,142.380000000000,142.590000000000,142.800000000000,143.010000000000,143.220000000000,143.430000000000,143.640000000000,143.850000000000,144.060000000000,144.270000000000,144.480000000000,144.690000000000,144.900000000000,145.110000000000,145.320000000000,145.530000000000,145.740000000000,145.950000000000,146.160000000000,146.370000000000,146.580000000000,146.790000000000,147,147.210000000000,147.420000000000,147.630000000000,147.840000000000,148.050000000000,148.260000000000,148.470000000000,148.680000000000,148.890000000000,149.100000000000,149.310000000000,149.520000000000,149.730000000000,149.940000000000,150.150000000000,150.360000000000,150.570000000000,150.780000000000,150.990000000000,151.200000000000,151.410000000000,151.620000000000,151.830000000000,152.040000000000,152.250000000000,152.460000000000,152.670000000000,152.880000000000,153.090000000000,153.300000000000,153.510000000000,153.720000000000,153.930000000000,154.140000000000,154.350000000000,154.560000000000,154.770000000000,154.980000000000,155.190000000000,155.400000000000,155.610000000000,155.820000000000,156.030000000000,156.240000000000,156.450000000000,156.660000000000,156.870000000000,157.080000000000,157.290000000000,157.500000000000,157.710000000000,157.920000000000,158.130000000000,158.340000000000
};




double bEcrTable [9][29] = {
  // CB of 40 bits
  {
    0.1777, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000
  },  
  // CB of 104 bits
  {
    0.1423, 0.1753, 0.1882, 0.2499, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000    
  },
  // CB of 160
  {
    0.1354, 0.1655, 0.1812, 0.2351, 0.2873, 0.3462, -1.000, -1.000, -1.000,
    -1.0000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, 
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000        
  },
  // CB of 256
  {
    0.1304, 0.1584, 0.1735, 0.2265, 0.2782, 0.3340, 0.3927, 0.4785, 0.5566,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, 
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000        
  },
  // CB of 512
  {
    0.1257, 0.1528, 0.1667, 0.2188, 0.2680, 0.3229, 0.3818, 0.4607, 0.5373,
    0.6081, 0.7451, 0.4049, 0.4472, 0.4975, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000        
  },
  // CB of 1024
  {
    0.1224, 0.1497, 0.1638, 0.2139, 0.2636, 0.3195, 0.3768, 0.4520, 0.5269,
    0.5963, 0.7412, 0.3979, 0.4399, 0.4894, 0.6422, 0.6034, 0.6619, 0.7538,
    0.7743, 0.5627, 0.6089, 0.6577, 0.7049, 0.7508, -1.000, -1.000, -1.000,
    -1.000, -1.000            
  },
  // CB of 2560
  {
    0.1211, 0.1480, 0.1615, 0.2119, 0.2611, 0.3157, 0.3735, 0.4458, 0.5205,
    0.5902, 0.7376, 0.3939, 0.4351, 0.4851, 0.6365, 0.5976, 0.6554, 0.7442, 
    0.7701, 0.5619, 0.6056, 0.6521, 0.6982, 0.7441, 0.7874, 0.8315, 0.8735,
    0.9089, 0.9369            
  },
  // CB of 4032
  {
    0.1208, 0.1477, 0.1612, 0.2112, 0.2606, 0.3153, 0.3728, 0.4441, 0.5185,
    0.5882, 0.7349, 0.3921, 0.4338, 0.4871, 0.6535, 0.5940, 0.6527, 0.7430, 
    0.7699, 0.5591, 0.6027, 0.6512, 0.6981, 0.7437, 0.7873, 0.8301, 0.8702,
    0.9082, 0.9339            
  },
  // CB of 6144
  {
    0.1207, 0.1474, 0.1612, 0.2111, 0.2605, 0.3153, 0.3726, 0.4439, 0.5193,
    0.5882, 0.7369, 0.3921, 0.4339, 0.4833, 0.6339, 0.5952, 0.6528, 0.7420, 
    0.7664, 0.5600, 0.6027, 0.6494, 0.6948, 0.7407, 0.7842, 0.8284, 0.8692,
    0.9058, 0.9325            
  },
};
  
  
double cEcrTable [9][29] = {
  // CB of 40 bits
  {
    0.0342, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000            
  },
  // CB of 104 bits
  {
    0.0198, 0.0239, 0.0248, 0.0320, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000            
  },
  // CB of 160 bits
  {
    0.0157, 0.0190, 0.0204, 0.0252, 0.0310, 0.0348, -1.0000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, 
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000            
  },
  // CB of 256 bits
  {
    0.0123, 0.0149, 0.0163, 0.0212, 0.0252, 0.0298, 0.0304, 0.0341, 0.0382,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, 
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000            
  },
  // CB of 512 bits
  {
    0.0085, 0.0106, 0.0109, 0.0140, 0.0178, 0.0217, 0.0219, 0.0249, 0.0270, 
    0.0292, 0.0293, 0.0206, 0.0220, 0.0235, 0.0257, -1.000, -1.000, -1.000,
    -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000, -1.000,
    -1.000, -1.000            
  },
  // CB of 1024 bits
  {
    0.0061, 0.0074, 0.0078, 0.0102, 0.0121, 0.0138, 0.0163, 0.0178, 0.0207,
    0.0198, 0.0203, 0.0137, 0.0154, 0.0164, 0.0183, 0.0188, 0.0188, 0.0220,
    0.0215, 0.0157, 0.0169, 0.0185, 0.0189, 0.0200, -1.000, -1.000, -1.000,
    -1.000, -1.000            
  },
  // CB of 2560 bits
  {
    0.0040, 0.0047, 0.0050, 0.0063, 0.0079, 0.0091, 0.0101, 0.0117, 0.0123,
    0.0129, 0.0123, 0.0091, 0.0095, 0.0102, 0.0116, 0.0114, 0.0119, 0.0116,
    0.0123, 0.0096, 0.0104, 0.0109, 0.0108, 0.0118, 0.0122, 0.0117, 0.0110,
    0.0097, 0.0085            
  },
  // CB of 4032 bits
  {
    0.0032, 0.0038, 0.0039, 0.0051, 0.0063, 0.0072, 0.0079, 0.0084, 0.0100,
    0.0106, 0.0106, 0.0074, 0.0078, 0.0090, 0.0095, 0.0089, 0.0092, 0.0101,
    0.0096, 0.0080, 0.0081, 0.0090, 0.0091, 0.0095, 0.0096, 0.0094, 0.0086,
    0.0078, 0.0071            
  },
  // CB of 6144 bits
  {
    0.0025, 0.0032, 0.0032, 0.0042, 0.0054, 0.0059, 0.0064, 0.0073, 0.0081,
    0.0076, 0.0083, 0.0058, 0.0064, 0.0070, 0.0077, 0.0074, 0.0080, 0.0080,
    0.0080, 0.0061, 0.0066, 0.0069, 0.0080, 0.0081, 0.0080, 0.0077, 0.0068,
    0.0066, 0.0058            
  }
    
};


double 
LteMiErrorModel::Mib (const SpectrumValue& sinr, const std::vector<int>& map, uint8_t mcs)
{
  NS_LOG_FUNCTION (sinr << &map << (uint32_t) mcs);
  
  double MI;
  double MIsum = 0.0;
  
  for (uint32_t i = 0; i < map.size (); i++)
    {
      SpectrumValue sinrCopy = sinr;
      double sinrLin = sinrCopy[map.at (i)];
      if (mcs <= 10) // QPSK
        {
          int tr = 0;
          while ((tr<MI_MAP_QPSK_SIZE)&&(MI_map_qpsk_axis[tr] < sinrLin))
            {
              tr++;
            }
          if (sinrLin > MI_map_qpsk_axis[MI_MAP_QPSK_SIZE-1])
            {
              MI = 1;
            }
          else 
            {
              NS_ASSERT_MSG (tr<MI_MAP_QPSK_SIZE, "MI map out of data");
              MI = MI_map_qpsk[tr];
            }
        }
      else
        {
          if (mcs > 10 && mcs < 20 )	// 16-QAM
            {
              int tr = 0;
              while ((tr<MI_MAP_16QAM_SIZE)&&(MI_map_16qam_axis[tr] < sinrLin))
                {
                  tr++;
                }
              if (sinrLin > MI_map_16qam_axis[MI_MAP_16QAM_SIZE-1])
                {
                  MI = 1;
                }
              else 
                {
                  NS_ASSERT_MSG (tr<MI_MAP_16QAM_SIZE, "MI map out of data");
                  MI = MI_map_16qam[tr];
                }
            }
          else // 64-QAM
            {
              int tr = 0;
              while ((tr<MI_MAP_64QAM_SIZE)&&(MI_map_64qam_axis[tr] < sinrLin))
                {
                  tr++;
                }
              if (sinrLin > MI_map_64qam_axis[MI_MAP_64QAM_SIZE-1])
                {
                  MI = 1;
                }
              else
                {
                  NS_ASSERT_MSG (tr<MI_MAP_64QAM_SIZE, "MI map out of data");
                  MI = MI_map_64qam[tr];
                }
            }
        }
      NS_LOG_LOGIC (" RB " << map.at (i) << "Minimum SNR = " << 10*log10 (sinrLin) << " V, MCS = " << (uint16_t)mcs << ", MI = " << MI);
      MIsum += MI;
    }
  MI = MIsum / map.size ();
  NS_LOG_LOGIC (" MI = " << MI);
  return MI;
}


double 
LteMiErrorModel::MappingMiBler (double mib, uint8_t mcs, uint16_t cbSize)
{
  NS_LOG_FUNCTION (mib << (uint32_t) mcs << (uint32_t) cbSize);
  double b = 0;
  double c = 0;
  NS_ASSERT_MSG (mcs < 29, "MCS out of range [0..28]");
  int cbIndex = 1;
  while ((cbIndex < 9)&&(cbMiSizeTable[cbIndex]<= cbSize))
    {
      cbIndex++;
    }
  cbIndex--;
  NS_LOG_LOGIC (" MCS " << (uint16_t)mcs << " TBS " << TbsIndex[mcs] << " CB size " << cbSize << " CB size curve " << cbMiSizeTable[cbIndex]);

  b = bEcrTable[cbIndex][mcs];
  if (b<0.0)
    {
      //take the lowest CB size including this CB for removing CB size
      //quatization errors
      int i = cbIndex;
      while ((i<9)&&(b<0))
        {
          b = bEcrTable[i++][mcs];
        }
    }
  c = cEcrTable[cbIndex][mcs];
  if (c<0.0)
    {
      //take the lowest CB size including this CB for removing CB size
      //quatization errors
      int i = cbIndex;
      while ((i<9)&&(c<0))
        {
          c = cEcrTable[i++][mcs];
        }
    }
  // see IEEE802.16m EMD formula 55 of section 4.3.2.1
  double bler = 0.5*( 1 - erf((mib-b)/(sqrt(2)*c)) );
  NS_LOG_LOGIC ("MIB: " << mib << " BLER:" << bler << " b:" << b << " c:" << c);
  return bler;
}


double
LteMiErrorModel::GetTbError (const SpectrumValue& sinr, const std::vector<int>& map, uint16_t size, uint8_t mcs)
{
  NS_LOG_FUNCTION (sinr << &map << (uint32_t) size << (uint32_t) mcs);
  
  double MI = Mib(sinr, map, mcs);
  // estimate CB size (according to sec 5.1.2 of TS 36.212)
  uint16_t Z = 6144; // max size of a codeblock (including CRC)
  uint32_t B = size * 8;
//   B = 1234;
  uint32_t L = 0;
  uint32_t C = 0; // no. of codeblocks
  uint32_t Cplus = 0; // no. of codeblocks with size K+
  uint32_t Kplus = 0; // no. of codeblocks with size K+
  uint32_t Cminus = 0; // no. of codeblocks with size K+
  uint32_t Kminus = 0; // no. of codeblocks with size K+
  uint32_t B1 = 0;
  uint32_t deltaK = 0;
  if (B <= Z)
    {
      // only one codeblock
      L = 0;
      C = 1;
      B1 = B;
    }
  else
    {
      L = 24;
      C = ceil ((double)B / ((double)(Z-L)));
      B1 = B + C * L;
    }
  // first segmentation: K+ = minimum K in table such that C * K >= B1
//   uint i = 0;
//   while (B1 > cbSizeTable[i] * C)
//     {
// //       NS_LOG_INFO (" K+ " << cbSizeTable[i] << " means " << cbSizeTable[i] * C);
//       i++;
//     }
//   uint16_t KplusId = i;
//   Kplus = cbSizeTable[i];
  
  // implement a modified binary search
  int min = 0;
  int max = 187;
  int mid = 0;
  do
    {
      mid = (min+max) / 2;
      if (B1 > cbSizeTable[mid]*C)
        {
          if (B1 < cbSizeTable[mid+1]*C)
            {
              break;
            }
          else
            {
              min = mid + 1;
            }
        }
      else
        {
          if (B1 > cbSizeTable[mid-1]*C)
            {
              break;
            }
          else
            {
              max = mid - 1;
            }
        }
  } while ((cbSizeTable[mid]*C != B1) && (min < max));
  // adjust binary search to the largest integer value of K containing B1
  if (B1 > cbSizeTable[mid]*C)
    {
      mid ++;
    }
  
  uint16_t KplusId = mid;
  Kplus = cbSizeTable[mid];
  
  
  if (C==1)
    {
      Cplus = 1;
      Cminus = 0;
      Kminus = 0;
    }
  else
    {
      // second segmentation size: K- = maximum K in table such that K < K+
      Kminus = cbSizeTable[KplusId-1 > 0 ? KplusId-1 : 0];
      deltaK = Kplus - Kminus;
      Cminus = floor ((((double) C * Kplus) - (double)B1) / (double)deltaK);
      Cplus = C - Cminus;
    }
  NS_LOG_INFO ("--------------------LteMiErrorModel: TB size of " << B << " needs of " << B1 << " bits reparted in " << C << " CBs as "<< Cplus << " block(s) of " << Kplus << " and " << Cminus << " of " << Kminus);
  
  double errorRate = 1.0;
  if (C!=1)
    {
      double cbler = MappingMiBler (MI, mcs, Kplus);
      errorRate *= pow (1.0 - cbler, Cplus);
      cbler = MappingMiBler (MI, mcs, Kminus);
      errorRate *= pow (1.0 - cbler, Cminus);
      errorRate = 1.0 - errorRate;
    }
  else
    {
      errorRate = MappingMiBler (MI, mcs, Kplus);
    }
  
  NS_LOG_LOGIC (" Error rate " << errorRate);
  
  return errorRate;
}
  

} // namespace ns3

