
// File: index.xml

// File: structArcCredential_1_1ACACI.xml
%feature("docstring") ArcCredential::ACACI "";

%feature("docstring")  ArcCredential::ACACI::STACK_OF "ArcCredential::ACACI::STACK_OF(GENERAL_NAME)*names ";


// File: structArcCredential_1_1ACATTHOLDER.xml
%feature("docstring") ArcCredential::ACATTHOLDER "";

%feature("docstring")  ArcCredential::ACATTHOLDER::STACK_OF "ArcCredential::ACATTHOLDER::STACK_OF(GENERAL_NAME)*grantor ";

%feature("docstring")  ArcCredential::ACATTHOLDER::STACK_OF "ArcCredential::ACATTHOLDER::STACK_OF(AC_ATTRIBUTE)*attributes ";


// File: structArcCredential_1_1ACATTR.xml
%feature("docstring") ArcCredential::ACATTR "";

%feature("docstring")  ArcCredential::ACATTR::STACK_OF "ArcCredential::ACATTR::STACK_OF(AC_IETFATTR)*ietfattr ";

%feature("docstring")  ArcCredential::ACATTR::STACK_OF "ArcCredential::ACATTR::STACK_OF(AC_FULL_ATTRIBUTES)*fullattributes ";


// File: structArcCredential_1_1ACATTRIBUTE.xml
%feature("docstring") ArcCredential::ACATTRIBUTE "";


// File: structArcCredential_1_1ACC.xml
%feature("docstring") ArcCredential::ACC "";


// File: structArcCredential_1_1ACCERTS.xml
%feature("docstring") ArcCredential::ACCERTS "";

%feature("docstring")  ArcCredential::ACCERTS::STACK_OF "ArcCredential::ACCERTS::STACK_OF(X509)*stackcert ";


// File: structArcCredential_1_1ACDIGEST.xml
%feature("docstring") ArcCredential::ACDIGEST "";


// File: structArcCredential_1_1ACFORM.xml
%feature("docstring") ArcCredential::ACFORM "";

%feature("docstring")  ArcCredential::ACFORM::STACK_OF "ArcCredential::ACFORM::STACK_OF(GENERAL_NAME)*names ";


// File: structArcCredential_1_1ACFULLATTRIBUTES.xml
%feature("docstring") ArcCredential::ACFULLATTRIBUTES "";

%feature("docstring")  ArcCredential::ACFULLATTRIBUTES::STACK_OF "ArcCredential::ACFULLATTRIBUTES::STACK_OF(AC_ATT_HOLDER)*providers ";


// File: structArcCredential_1_1ACHOLDER.xml
%feature("docstring") ArcCredential::ACHOLDER "";

%feature("docstring")  ArcCredential::ACHOLDER::STACK_OF "ArcCredential::ACHOLDER::STACK_OF(GENERAL_NAME)*name ";


// File: structArcCredential_1_1ACIETFATTR.xml
%feature("docstring") ArcCredential::ACIETFATTR "";

%feature("docstring")  ArcCredential::ACIETFATTR::STACK_OF "ArcCredential::ACIETFATTR::STACK_OF(GENERAL_NAME)*names ";

%feature("docstring")  ArcCredential::ACIETFATTR::STACK_OF "ArcCredential::ACIETFATTR::STACK_OF(AC_IETFATTRVAL)*values ";


// File: structArcCredential_1_1ACINFO.xml
%feature("docstring") ArcCredential::ACINFO "";

%feature("docstring")  ArcCredential::ACINFO::STACK_OF "ArcCredential::ACINFO::STACK_OF(AC_ATTR)*attrib ";

%feature("docstring")  ArcCredential::ACINFO::STACK_OF "ArcCredential::ACINFO::STACK_OF(X509_EXTENSION)*exts ";


// File: structArcCredential_1_1ACIS.xml
%feature("docstring") ArcCredential::ACIS "";

%feature("docstring")  ArcCredential::ACIS::STACK_OF "ArcCredential::ACIS::STACK_OF(GENERAL_NAME)*issuer ";


// File: structArcCredential_1_1ACSEQ.xml
%feature("docstring") ArcCredential::ACSEQ "";

%feature("docstring")  ArcCredential::ACSEQ::STACK_OF "ArcCredential::ACSEQ::STACK_OF(AC)*acs ";


// File: structArcCredential_1_1ACTARGET.xml
%feature("docstring") ArcCredential::ACTARGET "";


// File: structArcCredential_1_1ACTARGETS.xml
%feature("docstring") ArcCredential::ACTARGETS "";

%feature("docstring")  ArcCredential::ACTARGETS::STACK_OF "ArcCredential::ACTARGETS::STACK_OF(AC_TARGET)*targets ";


// File: structArcCredential_1_1ACVAL.xml
%feature("docstring") ArcCredential::ACVAL "";


// File: classArc_1_1Adler32Sum.xml
%feature("docstring") Arc::Adler32Sum "

Implementation of Adler32 checksum.

C++ includes: CheckSum.h ";

%feature("docstring")  Arc::Adler32Sum::Adler32Sum "Arc::Adler32Sum::Adler32Sum(void) ";

%feature("docstring")  Arc::Adler32Sum::start "virtual void
Arc::Adler32Sum::start(void) ";

%feature("docstring")  Arc::Adler32Sum::add "virtual void
Arc::Adler32Sum::add(void *buf, unsigned long long int len) ";

%feature("docstring")  Arc::Adler32Sum::end "virtual void
Arc::Adler32Sum::end(void) ";

%feature("docstring")  Arc::Adler32Sum::result "virtual void
Arc::Adler32Sum::result(unsigned char *&res, unsigned int &len) const
";

%feature("docstring")  Arc::Adler32Sum::print "virtual int
Arc::Adler32Sum::print(char *buf, int len) const ";

%feature("docstring")  Arc::Adler32Sum::scan "virtual void
Arc::Adler32Sum::scan(const char *) ";


// File: classArcSec_1_1AlgFactory.xml
%feature("docstring") ArcSec::AlgFactory "

Interface for algorithm factory class.

AlgFactory is in charge of creating CombiningAlg according to the
algorithm type given as argument of method createAlg. This class can
be inherited for implementing a factory class which can create some
specific combining algorithm objects.

C++ includes: AlgFactory.h ";

%feature("docstring")  ArcSec::AlgFactory::AlgFactory "ArcSec::AlgFactory::AlgFactory() ";

%feature("docstring")  ArcSec::AlgFactory::~AlgFactory "virtual
ArcSec::AlgFactory::~AlgFactory() ";

%feature("docstring")  ArcSec::AlgFactory::createAlg "virtual
CombiningAlg* ArcSec::AlgFactory::createAlg(const std::string &type)=0

creat algorithm object based on the type algorithm type

Parameters:
-----------

type:  The type of combining algorithm

The object of CombiningAlg ";


// File: classArcSec_1_1AnyURIAttribute.xml
%feature("docstring") ArcSec::AnyURIAttribute "";

%feature("docstring")  ArcSec::AnyURIAttribute::AnyURIAttribute "ArcSec::AnyURIAttribute::AnyURIAttribute() ";

%feature("docstring")  ArcSec::AnyURIAttribute::AnyURIAttribute "ArcSec::AnyURIAttribute::AnyURIAttribute(const std::string &v, const
std::string &i) ";

%feature("docstring")  ArcSec::AnyURIAttribute::~AnyURIAttribute "virtual ArcSec::AnyURIAttribute::~AnyURIAttribute() ";

%feature("docstring")  ArcSec::AnyURIAttribute::equal "virtual bool
ArcSec::AnyURIAttribute::equal(AttributeValue *other, bool
check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::AnyURIAttribute::encode "virtual
std::string ArcSec::AnyURIAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::AnyURIAttribute::getValue "std::string
ArcSec::AnyURIAttribute::getValue() ";

%feature("docstring")  ArcSec::AnyURIAttribute::getId "std::string
ArcSec::AnyURIAttribute::getId()

Get the AttributeId of the <Attribute> ";

%feature("docstring")  ArcSec::AnyURIAttribute::getType "virtual
std::string ArcSec::AnyURIAttribute::getType()

Get the DataType of the <Attribute> ";


// File: classArc_1_1ApplicationEnvironment.xml
%feature("docstring") Arc::ApplicationEnvironment "

ApplicationEnvironment.

The ApplicationEnviroment is closely related to the definition given
in GLUE2. By extending the Software class the two GLUE2 attributes
AppName and AppVersion are mapped to two private members. However
these can be obtained through the inheriated member methods getName
and getVersion.

GLUE2 description: A description of installed application software or
software environment characteristics available within one or more
Execution Environments.

C++ includes: ExecutionTarget.h ";

%feature("docstring")
Arc::ApplicationEnvironment::ApplicationEnvironment "Arc::ApplicationEnvironment::ApplicationEnvironment() ";

%feature("docstring")
Arc::ApplicationEnvironment::ApplicationEnvironment "Arc::ApplicationEnvironment::ApplicationEnvironment(const std::string
&Name) ";

%feature("docstring")
Arc::ApplicationEnvironment::ApplicationEnvironment "Arc::ApplicationEnvironment::ApplicationEnvironment(const std::string
&Name, const std::string &Version) ";


// File: classArc_1_1ApplicationType.xml
%feature("docstring") Arc::ApplicationType "";

%feature("docstring")  Arc::ApplicationType::ApplicationType "Arc::ApplicationType::ApplicationType() ";


// File: classArc_1_1ArcLocation.xml
%feature("docstring") Arc::ArcLocation "

Determines ARC installation location.

C++ includes: ArcLocation.h ";


// File: structArcSec_1_1ArcPeriod.xml
%feature("docstring") ArcSec::ArcPeriod "";


// File: classArc_1_1ARCPolicyHandlerConfig.xml
%feature("docstring") Arc::ARCPolicyHandlerConfig "";

%feature("docstring")
Arc::ARCPolicyHandlerConfig::ARCPolicyHandlerConfig "Arc::ARCPolicyHandlerConfig::ARCPolicyHandlerConfig(const std::string
&event=\"incoming\") ";

%feature("docstring")
Arc::ARCPolicyHandlerConfig::ARCPolicyHandlerConfig "Arc::ARCPolicyHandlerConfig::ARCPolicyHandlerConfig(XMLNode policy,
const std::string &event=\"incoming\") ";

%feature("docstring")  Arc::ARCPolicyHandlerConfig::AddPolicy "void
Arc::ARCPolicyHandlerConfig::AddPolicy(XMLNode policy) ";

%feature("docstring")  Arc::ARCPolicyHandlerConfig::AddPolicy "void
Arc::ARCPolicyHandlerConfig::AddPolicy(const std::string &policy) ";


// File: structArcSec_1_1Attr.xml
%feature("docstring") ArcSec::Attr "

Attr contains a tuple of attribute type and value.

C++ includes: Request.h ";


// File: classArcSec_1_1AttributeFactory.xml
%feature("docstring") ArcSec::AttributeFactory "

Base attribute factory class

C++ includes: AttributeFactory.h ";

%feature("docstring")  ArcSec::AttributeFactory::AttributeFactory "ArcSec::AttributeFactory::AttributeFactory() ";

%feature("docstring")  ArcSec::AttributeFactory::~AttributeFactory "virtual ArcSec::AttributeFactory::~AttributeFactory() ";

%feature("docstring")  ArcSec::AttributeFactory::createValue "virtual
AttributeValue* ArcSec::AttributeFactory::createValue(const
Arc::XMLNode &node, const std::string &type)=0 ";


// File: classArc_1_1AttributeIterator.xml
%feature("docstring") Arc::AttributeIterator "

A const iterator class for accessing multiple values of an attribute.

This is an iterator class that is used when accessing multiple values
of an attribute. The getAll() method of the MessageAttributes class
returns an AttributeIterator object that can be used to access the
values of the attribute.

Typical usage is:

C++ includes: MessageAttributes.h ";

%feature("docstring")  Arc::AttributeIterator::AttributeIterator "Arc::AttributeIterator::AttributeIterator()

Default constructor.

The default constructor. Does nothing since all attributes are
instances of well-behaving STL classes. ";

%feature("docstring")  Arc::AttributeIterator::key "const
std::string& Arc::AttributeIterator::key(void) const

The key of attribute.

This method returns reference to key of attribute to which iterator
refers. ";

%feature("docstring")  Arc::AttributeIterator::hasMore "bool
Arc::AttributeIterator::hasMore() const

Predicate method for iteration termination.

This method determines whether there are more values for the iterator
to refer to. Returns true if there are more values, otherwise false.
";


// File: classArcSec_1_1AttributeProxy.xml
%feature("docstring") ArcSec::AttributeProxy "

Interface for creating the AttributeValue object, it will be used by
AttributeFactory.

The AttributeProxy object will be insert into AttributeFactoty; and
the getAttribute(node) method will be called inside
AttributeFacroty.createvalue(node), in order to create a specific
AttributeValue

C++ includes: AttributeProxy.h ";

%feature("docstring")  ArcSec::AttributeProxy::AttributeProxy "ArcSec::AttributeProxy::AttributeProxy() ";

%feature("docstring")  ArcSec::AttributeProxy::~AttributeProxy "virtual ArcSec::AttributeProxy::~AttributeProxy() ";

%feature("docstring")  ArcSec::AttributeProxy::getAttribute "virtual
AttributeValue* ArcSec::AttributeProxy::getAttribute(const
Arc::XMLNode &node)=0

Create a AttributeValue object according to the information inside the
XMLNode as parameter. ";


// File: classArcSec_1_1AttributeValue.xml
%feature("docstring") ArcSec::AttributeValue "

Interface for containing different type of <Attribute> node for both
policy and request.

<Attribute> contains different \"Type\" definition; Each type of
<Attribute> needs different approach to compare the value. Any
specific class which is for processing specific \"Type\" shoud inherit
this class. The \"Type\" supported so far is: StringAttribute,
DateAttribute, TimeAttribute, DurationAttribute, PeriodAttribute,
AnyURIAttribute, X500NameAttribute

C++ includes: AttributeValue.h ";

%feature("docstring")  ArcSec::AttributeValue::AttributeValue "ArcSec::AttributeValue::AttributeValue() ";

%feature("docstring")  ArcSec::AttributeValue::~AttributeValue "virtual ArcSec::AttributeValue::~AttributeValue() ";

%feature("docstring")  ArcSec::AttributeValue::equal "virtual bool
ArcSec::AttributeValue::equal(AttributeValue *value, bool
check_id=true)=0

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::AttributeValue::encode "virtual
std::string ArcSec::AttributeValue::encode()=0

encode the value in a string format ";

%feature("docstring")  ArcSec::AttributeValue::getType "virtual
std::string ArcSec::AttributeValue::getType()=0

Get the DataType of the <Attribute> ";

%feature("docstring")  ArcSec::AttributeValue::getId "virtual
std::string ArcSec::AttributeValue::getId()=0

Get the AttributeId of the <Attribute> ";


// File: classArcSec_1_1Attrs.xml
%feature("docstring") ArcSec::Attrs "

Attrs is a container for one or more Attr.

Attrs includes includes methonds for inserting, getting items, and
counting size as well

C++ includes: Request.h ";

%feature("docstring")  ArcSec::Attrs::addItem "void
ArcSec::Attrs::addItem(Attr attr) ";

%feature("docstring")  ArcSec::Attrs::size "int ArcSec::Attrs::size()
";

%feature("docstring")  ArcSec::Attrs::getItem "Attr&
ArcSec::Attrs::getItem(int n) ";


// File: structArcSec_1_1AuthzRequest.xml
%feature("docstring") ArcSec::AuthzRequest "";


// File: structArcSec_1_1AuthzRequestSection.xml
%feature("docstring") ArcSec::AuthzRequestSection "

These structure are based on the request schema for PDP, so far it can
apply to the ArcPDP's request schema, see src/hed/pdc/Request.xsd and
src/hed/pdc/Request.xml. It could also apply to the XACMLPDP's request
schema, since the difference is minor.

Another approach is, the service composes/marshalls the xml structure
directly, then the service should use difference code to compose for
ArcPDP's request schema and XACMLPDP's schema, which is not so good.

C++ includes: PDP.h ";


// File: classArc_1_1AutoPointer.xml
%feature("docstring") Arc::AutoPointer "

Wrapper for pointer with automatic destruction.

If ordinary pointer is wrapped in instance of this class it will be
automatically destroyed when instance is destroyed. This is useful for
maintaing pointers in scope of one function. Only pointers returned by
new() are supported.

C++ includes: Utils.h ";

%feature("docstring")  Arc::AutoPointer::AutoPointer "Arc::AutoPointer< T >::AutoPointer(void)

NULL pointer constructor. ";

%feature("docstring")  Arc::AutoPointer::AutoPointer "Arc::AutoPointer< T >::AutoPointer(T *o)

Constructor which wraps pointer. ";

%feature("docstring")  Arc::AutoPointer::~AutoPointer "Arc::AutoPointer< T >::~AutoPointer(void)

Destructor destroys wrapped object using delete() ";


// File: classArc_1_1CountedPointer_1_1Base.xml


// File: classArc_1_1Base64.xml
%feature("docstring") Arc::Base64 "";

%feature("docstring")  Arc::Base64::Base64 "Arc::Base64::Base64() ";

%feature("docstring")  Arc::Base64::~Base64 "Arc::Base64::~Base64()
";


// File: classArc_1_1BaseConfig.xml
%feature("docstring") Arc::BaseConfig "

Configuration for client interface. It contains information which
can't be expressed in class constructor arguments. Most probably
common things like software installation location, identity of user,
etc.

C++ includes: ArcConfig.h ";

%feature("docstring")  Arc::BaseConfig::BaseConfig "Arc::BaseConfig::BaseConfig() ";

%feature("docstring")  Arc::BaseConfig::~BaseConfig "virtual
Arc::BaseConfig::~BaseConfig() ";

%feature("docstring")  Arc::BaseConfig::AddPluginsPath "void
Arc::BaseConfig::AddPluginsPath(const std::string &path)

Adds non-standard location of plugins ";

%feature("docstring")  Arc::BaseConfig::AddPrivateKey "void
Arc::BaseConfig::AddPrivateKey(const std::string &path)

Add private key ";

%feature("docstring")  Arc::BaseConfig::AddCertificate "void
Arc::BaseConfig::AddCertificate(const std::string &path)

Add certificate ";

%feature("docstring")  Arc::BaseConfig::AddProxy "void
Arc::BaseConfig::AddProxy(const std::string &path)

Add credentials proxy ";

%feature("docstring")  Arc::BaseConfig::AddCAFile "void
Arc::BaseConfig::AddCAFile(const std::string &path)

Add CA file ";

%feature("docstring")  Arc::BaseConfig::AddCADir "void
Arc::BaseConfig::AddCADir(const std::string &path)

Add CA directory ";

%feature("docstring")  Arc::BaseConfig::AddOverlay "void
Arc::BaseConfig::AddOverlay(XMLNode cfg)

Add configuration overlay ";

%feature("docstring")  Arc::BaseConfig::GetOverlay "void
Arc::BaseConfig::GetOverlay(std::string fname)

Read overlay from file ";

%feature("docstring")  Arc::BaseConfig::MakeConfig "virtual XMLNode
Arc::BaseConfig::MakeConfig(XMLNode cfg) const

Adds configuration part corresponding to stored information into
common configuration tree supplied in 'cfg' argument. Returns
reference to XML node representing configuration of ModuleManager ";


// File: classArcSec_1_1BooleanAttribute.xml
%feature("docstring") ArcSec::BooleanAttribute "";

%feature("docstring")  ArcSec::BooleanAttribute::BooleanAttribute "ArcSec::BooleanAttribute::BooleanAttribute() ";

%feature("docstring")  ArcSec::BooleanAttribute::BooleanAttribute "ArcSec::BooleanAttribute::BooleanAttribute(const bool &v, const
std::string &i=std::string()) ";

%feature("docstring")  ArcSec::BooleanAttribute::~BooleanAttribute "virtual ArcSec::BooleanAttribute::~BooleanAttribute() ";

%feature("docstring")  ArcSec::BooleanAttribute::equal "virtual bool
ArcSec::BooleanAttribute::equal(AttributeValue *o, bool check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::BooleanAttribute::encode "virtual
std::string ArcSec::BooleanAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::BooleanAttribute::getValue "bool
ArcSec::BooleanAttribute::getValue() ";

%feature("docstring")  ArcSec::BooleanAttribute::getId "std::string
ArcSec::BooleanAttribute::getId()

Get the AttributeId of the <Attribute> ";

%feature("docstring")  ArcSec::BooleanAttribute::getType "std::string
ArcSec::BooleanAttribute::getType()

Get the DataType of the <Attribute> ";


// File: classArc_1_1Broker.xml
%feature("docstring") Arc::Broker "";

%feature("docstring")  Arc::Broker::GetBestTarget "const
ExecutionTarget* Arc::Broker::GetBestTarget()

Returns next target from the list of ExecutionTarget objects.

When first called this method will sort its list of ExecutionTarget
objects, which have been filled by the PreFilterTargets method, and
then the first target in the list will be returned.

If this is not the first call then the next target in the list is
simply returned.

If there are no targets in the list or the end of the target list have
been reached the NULL pointer is returned.

The pointer to the next ExecutionTarget in the list is returned. ";

%feature("docstring")  Arc::Broker::Sort "void Arc::Broker::Sort() ";

%feature("docstring")  Arc::Broker::EndOfList "bool
Arc::Broker::EndOfList() const ";

%feature("docstring")  Arc::Broker::Advance "void
Arc::Broker::Advance() ";

%feature("docstring")  Arc::Broker::GetReference "const
ExecutionTarget*& Arc::Broker::GetReference() ";

%feature("docstring")  Arc::Broker::PreFilterTargets "void
Arc::Broker::PreFilterTargets(std::list< ExecutionTarget > &targets,
const JobDescription &jobdesc, const std::list< URL >
&rejectTargets=std::list< URL >())

Filter ExecutionTarget objects according to attributes in
JobDescription object.

Each of the ExecutionTarget objects in the passed list will be matched
against attributes in the passed JobDescription object. For a list of
which attributes are considered for matchmaking see appendix B of the
libarcclient technical manual (NORDUGRID- TECH-20). If a
ExecutionTarget object matches the job description, it is added to the
internal list of ExecutionTarget objects. NOTE: The list of
ExecutionTarget objects must be available through out the scope of
this Broker object.

Parameters:
-----------

targets:  A list of ExecutionTarget objects to be considered for
addition to the Broker.

jobdesc:   JobDescription object holding requirements.

rejectTargets:  ";

%feature("docstring")  Arc::Broker::UseAllTargets "void
Arc::Broker::UseAllTargets(std::list< ExecutionTarget > &targets) ";

%feature("docstring")  Arc::Broker::Test "bool
Arc::Broker::Test(std::list< ExecutionTarget > &targets, const int
&testid, Job &job) ";

%feature("docstring")  Arc::Broker::Submit "bool
Arc::Broker::Submit(std::list< ExecutionTarget > &targets, const
JobDescription &jobdesc, Job &job, const std::list< URL >
&rejectTargets=std::list< URL >()) ";

%feature("docstring")  Arc::Broker::RegisterJobsubmission "void
Arc::Broker::RegisterJobsubmission()

Register a job submission to the current target. ";

%feature("docstring")  Arc::Broker::~Broker "virtual
Arc::Broker::~Broker() ";


// File: classArc_1_1BrokerLoader.xml
%feature("docstring") Arc::BrokerLoader "

Class responsible for loading Broker plugins The Broker objects
returned by a BrokerLoader must not be used after the BrokerLoader
goes out of scope.

C++ includes: Broker.h ";

%feature("docstring")  Arc::BrokerLoader::BrokerLoader "Arc::BrokerLoader::BrokerLoader()

Constructor Creates a new BrokerLoader. ";

%feature("docstring")  Arc::BrokerLoader::~BrokerLoader "Arc::BrokerLoader::~BrokerLoader()

Destructor Calling the destructor destroys all Brokers loaded by the
BrokerLoader instance. ";

%feature("docstring")  Arc::BrokerLoader::load "Broker*
Arc::BrokerLoader::load(const std::string &name, const UserConfig
&usercfg)

Load a new Broker

Parameters:
-----------

name:  The name of the Broker to load.

usercfg:  The UserConfig object for the new Broker.

A pointer to the new Broker (NULL on error). ";

%feature("docstring")  Arc::BrokerLoader::GetBrokers "const
std::list<Broker*>& Arc::BrokerLoader::GetBrokers() const

Retrieve the list of loaded Brokers. A reference to the list of
Brokers. ";


// File: classArc_1_1BrokerPluginArgument.xml
%feature("docstring") Arc::BrokerPluginArgument "";

%feature("docstring")  Arc::BrokerPluginArgument::BrokerPluginArgument
"Arc::BrokerPluginArgument::BrokerPluginArgument(const UserConfig
&usercfg) ";

%feature("docstring")
Arc::BrokerPluginArgument::~BrokerPluginArgument "Arc::BrokerPluginArgument::~BrokerPluginArgument() ";


// File: structArc_1_1DataBuffer_1_1buf__desc.xml


// File: classArc_1_1ByteArray.xml
%feature("docstring") Arc::ByteArray "";

%feature("docstring")  Arc::ByteArray::ByteArray "Arc::ByteArray::ByteArray() ";

%feature("docstring")  Arc::ByteArray::ByteArray "Arc::ByteArray::ByteArray(size_t length) ";

%feature("docstring")  Arc::ByteArray::ByteArray "Arc::ByteArray::ByteArray(void *buf, size_t size) ";

%feature("docstring")  Arc::ByteArray::~ByteArray "Arc::ByteArray::~ByteArray() ";

%feature("docstring")  Arc::ByteArray::append "void
Arc::ByteArray::append(const void *buf, size_t size) ";

%feature("docstring")  Arc::ByteArray::append "void
Arc::ByteArray::append(const std::string &str) ";

%feature("docstring")  Arc::ByteArray::append "void
Arc::ByteArray::append(ByteArray &buf) ";

%feature("docstring")  Arc::ByteArray::clean "void
Arc::ByteArray::clean(void) ";

%feature("docstring")  Arc::ByteArray::data "char*
Arc::ByteArray::data(void) ";

%feature("docstring")  Arc::ByteArray::size "size_t
Arc::ByteArray::size(void) ";


// File: structArc_1_1CacheParameters.xml
%feature("docstring") Arc::CacheParameters "

Contains data on the parameters of a cache.

C++ includes: FileCache.h ";


// File: structArcCredential_1_1cert__verify__context.xml
%feature("docstring") ArcCredential::cert_verify_context "";

%feature("docstring")  ArcCredential::cert_verify_context::STACK_OF "ArcCredential::cert_verify_context::STACK_OF(X509)*cert_chain ";


// File: classArc_1_1CertEnvLocker.xml
%feature("docstring") Arc::CertEnvLocker "";

%feature("docstring")  Arc::CertEnvLocker::CertEnvLocker "Arc::CertEnvLocker::CertEnvLocker(const UserConfig &cfg) ";

%feature("docstring")  Arc::CertEnvLocker::~CertEnvLocker "Arc::CertEnvLocker::~CertEnvLocker(void) ";


// File: classArc_1_1ChainContext.xml
%feature("docstring") Arc::ChainContext "

Interface to chain specific functionality.

Object of this class is associated with every MCCLoader object. It is
accessible for MCC and Service components and provides an interface to
manipulate chains stored in Loader. This makes it possible to modify
chains dynamically - like deploying new services on demand.

C++ includes: MCCLoader.h ";


// File: classArc_1_1CheckSum.xml
%feature("docstring") Arc::CheckSum "

Defines interface for variuos checksum manipulations.

This class is used during data transfers through DataBuffer class

C++ includes: CheckSum.h ";

%feature("docstring")  Arc::CheckSum::CheckSum "Arc::CheckSum::CheckSum(void) ";

%feature("docstring")  Arc::CheckSum::~CheckSum "virtual
Arc::CheckSum::~CheckSum(void) ";

%feature("docstring")  Arc::CheckSum::start "virtual void
Arc::CheckSum::start(void)=0 ";

%feature("docstring")  Arc::CheckSum::add "virtual void
Arc::CheckSum::add(void *buf, unsigned long long int len)=0 ";

%feature("docstring")  Arc::CheckSum::end "virtual void
Arc::CheckSum::end(void)=0 ";

%feature("docstring")  Arc::CheckSum::result "virtual void
Arc::CheckSum::result(unsigned char *&res, unsigned int &len) const =0
";

%feature("docstring")  Arc::CheckSum::print "virtual int
Arc::CheckSum::print(char *buf, int len) const ";

%feature("docstring")  Arc::CheckSum::scan "virtual void
Arc::CheckSum::scan(const char *buf)=0 ";


// File: classArc_1_1DataBuffer_1_1checksum__desc.xml


// File: classArc_1_1CheckSumAny.xml
%feature("docstring") Arc::CheckSumAny "

Wraper for CheckSum class.

To be used for manipulation of any supported checksum type in a
transparent way.

C++ includes: CheckSum.h ";

%feature("docstring")  Arc::CheckSumAny::CheckSumAny "Arc::CheckSumAny::CheckSumAny(CheckSum *c=NULL) ";

%feature("docstring")  Arc::CheckSumAny::CheckSumAny "Arc::CheckSumAny::CheckSumAny(type type) ";

%feature("docstring")  Arc::CheckSumAny::CheckSumAny "Arc::CheckSumAny::CheckSumAny(const char *type) ";

%feature("docstring")  Arc::CheckSumAny::~CheckSumAny "virtual
Arc::CheckSumAny::~CheckSumAny(void) ";

%feature("docstring")  Arc::CheckSumAny::start "virtual void
Arc::CheckSumAny::start(void) ";

%feature("docstring")  Arc::CheckSumAny::add "virtual void
Arc::CheckSumAny::add(void *buf, unsigned long long int len) ";

%feature("docstring")  Arc::CheckSumAny::end "virtual void
Arc::CheckSumAny::end(void) ";

%feature("docstring")  Arc::CheckSumAny::result "virtual void
Arc::CheckSumAny::result(unsigned char *&res, unsigned int &len) const
";

%feature("docstring")  Arc::CheckSumAny::print "virtual int
Arc::CheckSumAny::print(char *buf, int len) const ";

%feature("docstring")  Arc::CheckSumAny::scan "virtual void
Arc::CheckSumAny::scan(const char *buf) ";

%feature("docstring")  Arc::CheckSumAny::active "bool
Arc::CheckSumAny::active(void) ";

%feature("docstring")  Arc::CheckSumAny::Type "type
Arc::CheckSumAny::Type(void) const ";


// File: classArc_1_1CIStringValue.xml
%feature("docstring") Arc::CIStringValue "

This class implements case insensitive strings as security attributes.

This is an example of how to inherit SecAttrValue. The class is meant
to implement security attributes that are case insensitive strings.

C++ includes: CIStringValue.h ";

%feature("docstring")  Arc::CIStringValue::CIStringValue "Arc::CIStringValue::CIStringValue()

Default constructor ";

%feature("docstring")  Arc::CIStringValue::CIStringValue "Arc::CIStringValue::CIStringValue(const char *ss)

This is a constructor that takes a string litteral. ";

%feature("docstring")  Arc::CIStringValue::CIStringValue "Arc::CIStringValue::CIStringValue(const std::string &ss)

This is a constructor that takes a string object. ";


// File: classArc_1_1ClassLoader.xml
%feature("docstring") Arc::ClassLoader "";

%feature("docstring")  Arc::ClassLoader::Instance "LoadableClass*
Arc::ClassLoader::Instance(const std::string &classId, XMLNode
*arg=NULL, const std::string &className=\"\") ";

%feature("docstring")  Arc::ClassLoader::Instance "LoadableClass*
Arc::ClassLoader::Instance(XMLNode *arg=NULL, const std::string
&className=\"\") ";

%feature("docstring")  Arc::ClassLoader::~ClassLoader "Arc::ClassLoader::~ClassLoader() ";


// File: classArc_1_1ClassLoaderPluginArgument.xml
%feature("docstring") Arc::ClassLoaderPluginArgument "";

%feature("docstring")
Arc::ClassLoaderPluginArgument::ClassLoaderPluginArgument "Arc::ClassLoaderPluginArgument::ClassLoaderPluginArgument(XMLNode
*xml) ";

%feature("docstring")
Arc::ClassLoaderPluginArgument::~ClassLoaderPluginArgument "virtual
Arc::ClassLoaderPluginArgument::~ClassLoaderPluginArgument(void) ";


// File: classArc_1_1ClientHTTP.xml
%feature("docstring") Arc::ClientHTTP "

Class for setting up a MCC chain for HTTP communication.

The ClientHTTP class inherits from the ClientTCP class and adds an
HTTP MCC to the chain.

C++ includes: ClientInterface.h ";

%feature("docstring")  Arc::ClientHTTP::ClientHTTP "Arc::ClientHTTP::ClientHTTP() ";

%feature("docstring")  Arc::ClientHTTP::ClientHTTP "Arc::ClientHTTP::ClientHTTP(const BaseConfig &cfg, const URL &url, int
timeout=-1, const std::string &proxy_host=\"\", int proxy_port=0) ";

%feature("docstring")  Arc::ClientHTTP::~ClientHTTP "virtual
Arc::ClientHTTP::~ClientHTTP() ";

%feature("docstring")  Arc::ClientHTTP::process "MCC_Status
Arc::ClientHTTP::process(const std::string &method,
PayloadRawInterface *request, HTTPClientInfo *info,
PayloadRawInterface **response) ";

%feature("docstring")  Arc::ClientHTTP::process "MCC_Status
Arc::ClientHTTP::process(const std::string &method, std::multimap<
std::string, std::string > &attributes, PayloadRawInterface *request,
HTTPClientInfo *info, PayloadRawInterface **response) ";

%feature("docstring")  Arc::ClientHTTP::process "MCC_Status
Arc::ClientHTTP::process(const std::string &method, const std::string
&path, PayloadRawInterface *request, HTTPClientInfo *info,
PayloadRawInterface **response) ";

%feature("docstring")  Arc::ClientHTTP::process "MCC_Status
Arc::ClientHTTP::process(const std::string &method, const std::string
&path, std::multimap< std::string, std::string > &attributes,
PayloadRawInterface *request, HTTPClientInfo *info,
PayloadRawInterface **response) ";

%feature("docstring")  Arc::ClientHTTP::process "MCC_Status
Arc::ClientHTTP::process(const std::string &method, const std::string
&path, uint64_t range_start, uint64_t range_end, PayloadRawInterface
*request, HTTPClientInfo *info, PayloadRawInterface **response) ";

%feature("docstring")  Arc::ClientHTTP::process "MCC_Status
Arc::ClientHTTP::process(const std::string &method, const std::string
&path, std::multimap< std::string, std::string > &attributes, uint64_t
range_start, uint64_t range_end, PayloadRawInterface *request,
HTTPClientInfo *info, PayloadRawInterface **response) ";

%feature("docstring")  Arc::ClientHTTP::GetEntry "MCC*
Arc::ClientHTTP::GetEntry() ";

%feature("docstring")  Arc::ClientHTTP::AddSecHandler "void
Arc::ClientHTTP::AddSecHandler(XMLNode handlercfg, const std::string
&libanme=\"\", const std::string &libpath=\"\") ";

%feature("docstring")  Arc::ClientHTTP::Load "virtual bool
Arc::ClientHTTP::Load() ";

%feature("docstring")  Arc::ClientHTTP::RelativeURI "void
Arc::ClientHTTP::RelativeURI(bool val) ";


// File: classArc_1_1ClientHTTPwithSAML2SSO.xml
%feature("docstring") Arc::ClientHTTPwithSAML2SSO "";

%feature("docstring")
Arc::ClientHTTPwithSAML2SSO::ClientHTTPwithSAML2SSO "Arc::ClientHTTPwithSAML2SSO::ClientHTTPwithSAML2SSO()

Constructor creates MCC chain and connects to server. ";

%feature("docstring")
Arc::ClientHTTPwithSAML2SSO::ClientHTTPwithSAML2SSO "Arc::ClientHTTPwithSAML2SSO::ClientHTTPwithSAML2SSO(const BaseConfig
&cfg, const URL &url) ";

%feature("docstring")
Arc::ClientHTTPwithSAML2SSO::~ClientHTTPwithSAML2SSO "virtual
Arc::ClientHTTPwithSAML2SSO::~ClientHTTPwithSAML2SSO() ";

%feature("docstring")  Arc::ClientHTTPwithSAML2SSO::process "MCC_Status Arc::ClientHTTPwithSAML2SSO::process(const std::string
&method, PayloadRawInterface *request, HTTPClientInfo *info,
PayloadRawInterface **response, const std::string &idp_name, const
std::string &username, const std::string &password, const bool
reuse_authn=false)

Send HTTP request and receive response. ";

%feature("docstring")  Arc::ClientHTTPwithSAML2SSO::process "MCC_Status Arc::ClientHTTPwithSAML2SSO::process(const std::string
&method, const std::string &path, PayloadRawInterface *request,
HTTPClientInfo *info, PayloadRawInterface **response, const
std::string &idp_name, const std::string &username, const std::string
&password, const bool reuse_authn=false) ";


// File: classArc_1_1ClientInterface.xml
%feature("docstring") Arc::ClientInterface "

Utility base class for MCC.

The ClientInterface class is a utility base class used for configuring
a client side Message Chain Component ( MCC) chain and loading it into
memory. It has several specializations of increasing complexity of the
MCC chains.

C++ includes: ClientInterface.h ";

%feature("docstring")  Arc::ClientInterface::ClientInterface "Arc::ClientInterface::ClientInterface() ";

%feature("docstring")  Arc::ClientInterface::ClientInterface "Arc::ClientInterface::ClientInterface(const BaseConfig &cfg) ";

%feature("docstring")  Arc::ClientInterface::~ClientInterface "virtual Arc::ClientInterface::~ClientInterface() ";

%feature("docstring")  Arc::ClientInterface::Overlay "void
Arc::ClientInterface::Overlay(XMLNode cfg) ";

%feature("docstring")  Arc::ClientInterface::GetConfig "const Config&
Arc::ClientInterface::GetConfig() const ";

%feature("docstring")  Arc::ClientInterface::GetContext "MessageContext& Arc::ClientInterface::GetContext() ";

%feature("docstring")  Arc::ClientInterface::Load "virtual bool
Arc::ClientInterface::Load() ";


// File: classArc_1_1ClientSOAP.xml
%feature("docstring") Arc::ClientSOAP "

Class with easy interface for sending/receiving SOAP messages over
HTTP(S/G). It takes care of configuring MCC chain and making an entry
point.

C++ includes: ClientInterface.h ";

%feature("docstring")  Arc::ClientSOAP::ClientSOAP "Arc::ClientSOAP::ClientSOAP()

Constructor creates MCC chain and connects to server. ";

%feature("docstring")  Arc::ClientSOAP::ClientSOAP "Arc::ClientSOAP::ClientSOAP(const BaseConfig &cfg, const URL &url, int
timeout=-1) ";

%feature("docstring")  Arc::ClientSOAP::~ClientSOAP "virtual
Arc::ClientSOAP::~ClientSOAP() ";

%feature("docstring")  Arc::ClientSOAP::process "MCC_Status
Arc::ClientSOAP::process(PayloadSOAP *request, PayloadSOAP **response)

Send SOAP request and receive response. ";

%feature("docstring")  Arc::ClientSOAP::process "MCC_Status
Arc::ClientSOAP::process(const std::string &action, PayloadSOAP
*request, PayloadSOAP **response)

Send SOAP request with specified SOAP action and receive response. ";

%feature("docstring")  Arc::ClientSOAP::GetEntry "MCC*
Arc::ClientSOAP::GetEntry()

Returns entry point to SOAP MCC in configured chain. To initialize
entry point Load() method must be called. ";

%feature("docstring")  Arc::ClientSOAP::AddSecHandler "void
Arc::ClientSOAP::AddSecHandler(XMLNode handlercfg, const std::string
&libanme=\"\", const std::string &libpath=\"\")

Adds security handler to configuration of SOAP MCC ";

%feature("docstring")  Arc::ClientSOAP::Load "virtual bool
Arc::ClientSOAP::Load()

Instantiates pluggable elements according to generated configuration
";


// File: classArc_1_1ClientSOAPwithSAML2SSO.xml
%feature("docstring") Arc::ClientSOAPwithSAML2SSO "";

%feature("docstring")
Arc::ClientSOAPwithSAML2SSO::ClientSOAPwithSAML2SSO "Arc::ClientSOAPwithSAML2SSO::ClientSOAPwithSAML2SSO()

Constructor creates MCC chain and connects to server. ";

%feature("docstring")
Arc::ClientSOAPwithSAML2SSO::ClientSOAPwithSAML2SSO "Arc::ClientSOAPwithSAML2SSO::ClientSOAPwithSAML2SSO(const BaseConfig
&cfg, const URL &url) ";

%feature("docstring")
Arc::ClientSOAPwithSAML2SSO::~ClientSOAPwithSAML2SSO "virtual
Arc::ClientSOAPwithSAML2SSO::~ClientSOAPwithSAML2SSO() ";

%feature("docstring")  Arc::ClientSOAPwithSAML2SSO::process "MCC_Status Arc::ClientSOAPwithSAML2SSO::process(PayloadSOAP *request,
PayloadSOAP **response, const std::string &idp_name, const std::string
&username, const std::string &password, const bool reuse_authn=false)

Send SOAP request and receive response. ";

%feature("docstring")  Arc::ClientSOAPwithSAML2SSO::process "MCC_Status Arc::ClientSOAPwithSAML2SSO::process(const std::string
&action, PayloadSOAP *request, PayloadSOAP **response, const
std::string &idp_name, const std::string &username, const std::string
&password, const bool reuse_authn=false)

Send SOAP request with specified SOAP action and receive response. ";


// File: classArc_1_1ClientTCP.xml
%feature("docstring") Arc::ClientTCP "

Class for setting up a MCC chain for TCP communication.

The ClientTCP class is a specialization of the ClientInterface which
sets up a client MCC chain for TCP communication, and optionally with
a security layer on top which can be either TLS, GSI or SSL3.

C++ includes: ClientInterface.h ";

%feature("docstring")  Arc::ClientTCP::ClientTCP "Arc::ClientTCP::ClientTCP() ";

%feature("docstring")  Arc::ClientTCP::ClientTCP "Arc::ClientTCP::ClientTCP(const BaseConfig &cfg, const std::string
&host, int port, SecurityLayer sec, int timeout=-1, bool
no_delay=false) ";

%feature("docstring")  Arc::ClientTCP::~ClientTCP "virtual
Arc::ClientTCP::~ClientTCP() ";

%feature("docstring")  Arc::ClientTCP::process "MCC_Status
Arc::ClientTCP::process(PayloadRawInterface *request,
PayloadStreamInterface **response, bool tls) ";

%feature("docstring")  Arc::ClientTCP::GetEntry "MCC*
Arc::ClientTCP::GetEntry() ";

%feature("docstring")  Arc::ClientTCP::Load "virtual bool
Arc::ClientTCP::Load() ";

%feature("docstring")  Arc::ClientTCP::AddSecHandler "void
Arc::ClientTCP::AddSecHandler(XMLNode handlercfg, SecurityLayer sec,
const std::string &libanme=\"\", const std::string &libpath=\"\") ";


// File: classArc_1_1ClientX509Delegation.xml
%feature("docstring") Arc::ClientX509Delegation "";

%feature("docstring")  Arc::ClientX509Delegation::ClientX509Delegation
"Arc::ClientX509Delegation::ClientX509Delegation()

Constructor creates MCC chain and connects to server. ";

%feature("docstring")  Arc::ClientX509Delegation::ClientX509Delegation
"Arc::ClientX509Delegation::ClientX509Delegation(const BaseConfig
&cfg, const URL &url) ";

%feature("docstring")
Arc::ClientX509Delegation::~ClientX509Delegation "virtual
Arc::ClientX509Delegation::~ClientX509Delegation() ";

%feature("docstring")  Arc::ClientX509Delegation::createDelegation "bool Arc::ClientX509Delegation::createDelegation(DelegationType deleg,
std::string &delegation_id)

Create the delegation credential according to the different remote
delegation service. This method should be called by holder of EEC(end
entity credential) which would delegate its EEC credential, or by
holder of delegated credential(normally, the holder is intermediate
service) which would further delegate the credential (on behalf of the
original EEC's holder) (for instance, the 'n' intermediate service
creates a delegation credential, then the 'n+1' intermediate service
aquires this delegation credential from the delegation service and
also acts on behalf of the EEC's holder by using this delegation
credential).

Parameters:
-----------

deleg:  Delegation type

delegation_id:  For gridsite delegation service, the delegation_id is
supposed to be created by client side, and sent to service side; for
ARC delegation service, the delegation_id is supposed to be created by
service side, and returned back. So for gridsite delegation service,
this parameter is treated as input, while for ARC delegation service,
it is treated as output. ";

%feature("docstring")  Arc::ClientX509Delegation::destroyDelegation "bool Arc::ClientX509Delegation::destroyDelegation(DelegationType) ";

%feature("docstring")  Arc::ClientX509Delegation::acquireDelegation "bool Arc::ClientX509Delegation::acquireDelegation(DelegationType
deleg, std::string &delegation_cred, std::string &delegation_id, const
std::string cred_identity=\"\", const std::string
cred_delegator_ip=\"\", const std::string username=\"\", const
std::string password=\"\")

Acquire delegation credential from delegation service. This method
should be called by intermediate service ('n+1' service as explained
on above) in order to use this delegation credential on behalf of the
EEC's holder.

Parameters:
-----------

deleg:  Delegation type

delegation_id:  delegation ID which is used to look up the credential
by delegation service

cred_identity:  the identity (in case of x509 credential, it is the DN
of EEC credential).

cred_delegator_ip:  the IP address of the credential delegator. Regard
of delegation, an intermediate service should accomplish three tasks:
1. Acquire 'n' level delegation credential (which is delegated by
'n-1' level delegator) from delegation service; 1. Create 'n+1' level
delegation credential to delegation service; 2. Use 'n' level
delegation credential to act on behalf of the EEC's holder. In case of
absense of delegation_id, the 'n-1' level delegator's IP address and
credential's identity are supposed to be used for look up the
delegation credential from delegation service. ";


// File: classArcSec_1_1CombiningAlg.xml
%feature("docstring") ArcSec::CombiningAlg "

Interface for combining algrithm.

This class is used to implement a specific combining algorithm for
combining policies.

C++ includes: CombiningAlg.h ";

%feature("docstring")  ArcSec::CombiningAlg::CombiningAlg "ArcSec::CombiningAlg::CombiningAlg() ";

%feature("docstring")  ArcSec::CombiningAlg::~CombiningAlg "virtual
ArcSec::CombiningAlg::~CombiningAlg() ";

%feature("docstring")  ArcSec::CombiningAlg::combine "virtual Result
ArcSec::CombiningAlg::combine(EvaluationCtx *ctx, std::list< Policy *
> policies)=0

Evaluate request against policy, and if there are more than one
policies, combine the evaluation results according to the combing
algorithm implemented inside in the method combine(ctx, policies)
itself.

Parameters:
-----------

ctx:  The information about request is included

policies:  The \"match\" and \"eval\" method inside each policy will
be called, and then those results from each policy will be combined
according to the combining algorithm inside CombingAlg class. ";

%feature("docstring")  ArcSec::CombiningAlg::getalgId "virtual const
std::string& ArcSec::CombiningAlg::getalgId(void) const =0

Get the identifier of the combining algorithm class The identity of
the algorithm ";


// File: classArc_1_1Config.xml
%feature("docstring") Arc::Config "

Configuration element - represents (sub)tree of ARC configuration.

This class is intended to be used to pass configuration details to
various parts of HED and external modules. Currently it's just a
wrapper over XML tree. But than may change in a future, although
interface should be preserved. Currently it is capable of loading XML
configuration document from file. In future it will be capable of
loading more user-readable format and process it into tree-like
structure convenient for machine processing (XML-like). So far there
are no schema and/or namespaces assigned.

C++ includes: ArcConfig.h ";

%feature("docstring")  Arc::Config::Config "Arc::Config::Config()

Creates empty XML tree ";

%feature("docstring")  Arc::Config::Config "Arc::Config::Config(const
NS &ns) ";

%feature("docstring")  Arc::Config::Config "Arc::Config::Config(const
char *filename)

Loads configuration document from file 'filename' ";

%feature("docstring")  Arc::Config::Config "Arc::Config::Config(const
std::string &xml_str)

Parse configuration document from memory ";

%feature("docstring")  Arc::Config::Config "Arc::Config::Config(XMLNode xml)

Acquire existing XML (sub)tree. Content is not copied. Make sure XML
tree is not destroyed while in use by this object. ";

%feature("docstring")  Arc::Config::Config "Arc::Config::Config(XMLNode xml, const std::string &filename) ";

%feature("docstring")  Arc::Config::~Config "Arc::Config::~Config(void) ";

%feature("docstring")  Arc::Config::Config "Arc::Config::Config(long
cfg_ptr_addr)

Copy constructor used by language bindings ";

%feature("docstring")  Arc::Config::Config "Arc::Config::Config(const
Config &cfg)

Copy constructor used by language bindings ";

%feature("docstring")  Arc::Config::print "void
Arc::Config::print(void)

Print structure of document. For debuging purposes. Printed content is
not an XML document. ";

%feature("docstring")  Arc::Config::parse "void
Arc::Config::parse(const char *filename)

Parse configuration document from file 'filename' ";

%feature("docstring")  Arc::Config::getFileName "const std::string&
Arc::Config::getFileName(void) const

Gives back file name of config file or empty string if it was
generared from the XMLNode subtree ";

%feature("docstring")  Arc::Config::setFileName "void
Arc::Config::setFileName(const std::string &filename)

Set the file name of config file ";

%feature("docstring")  Arc::Config::save "void
Arc::Config::save(const char *filename)

Save to file ";


// File: classArc_1_1ConfusaCertHandler.xml
%feature("docstring") Arc::ConfusaCertHandler "

Wrapper around Credential handling the Confusa specifics.

C++ includes: ConfusaCertHandler.h ";

%feature("docstring")  Arc::ConfusaCertHandler::ConfusaCertHandler "Arc::ConfusaCertHandler::ConfusaCertHandler(int keysize, const
std::string dn)

Create a new ConfusaCertHandler for DN dn and given keysize Basically
Confusa cert handler wraps around Credential ";

%feature("docstring")  Arc::ConfusaCertHandler::~ConfusaCertHandler "virtual Arc::ConfusaCertHandler::~ConfusaCertHandler() ";

%feature("docstring")  Arc::ConfusaCertHandler::getCertRequestB64 "std::string Arc::ConfusaCertHandler::getCertRequestB64()

Get the certificate request managed by this confusa cert handler in
base 64 encoding ";

%feature("docstring")  Arc::ConfusaCertHandler::createAuthURL "std::string Arc::ConfusaCertHandler::createAuthURL() ";

%feature("docstring")  Arc::ConfusaCertHandler::getRequestLocation "std::string Arc::ConfusaCertHandler::getRequestLocation() ";

%feature("docstring")  Arc::ConfusaCertHandler::getKeyLocation "std::string Arc::ConfusaCertHandler::getKeyLocation() ";

%feature("docstring")  Arc::ConfusaCertHandler::getC "std::string
Arc::ConfusaCertHandler::getC() ";

%feature("docstring")  Arc::ConfusaCertHandler::getO "std::string
Arc::ConfusaCertHandler::getO() ";

%feature("docstring")  Arc::ConfusaCertHandler::getOU "std::string
Arc::ConfusaCertHandler::getOU() ";

%feature("docstring")  Arc::ConfusaCertHandler::getCN "std::string
Arc::ConfusaCertHandler::getCN() ";

%feature("docstring")  Arc::ConfusaCertHandler::createCertRequest "bool Arc::ConfusaCertHandler::createCertRequest(std::string
password=\"\", std::string storedir=\"./\")

Create a new end entity certificate, with a private key encrypted with
password password. Private key and certificate will be stored in
directory storedir. ";


// File: classArc_1_1ConfusaParserUtils.xml
%feature("docstring") Arc::ConfusaParserUtils "

Methods often needed in evaluation web pages from the Confusa WebSSO
workflow

C++ includes: ConfusaParserUtils.h ";

%feature("docstring")  Arc::ConfusaParserUtils::ConfusaParserUtils "Arc::ConfusaParserUtils::ConfusaParserUtils() ";

%feature("docstring")  Arc::ConfusaParserUtils::~ConfusaParserUtils "virtual Arc::ConfusaParserUtils::~ConfusaParserUtils() ";


// File: classArc_1_1CountedPointer.xml
%feature("docstring") Arc::CountedPointer "

Wrapper for pointer with automatic destruction and mutiple references.

If ordinary pointer is wrapped in instance of this class it will be
automatically destroyed when all instances refering to it are
destroyed. This is useful for maintaing pointers refered from multiple
structures wihth automatic destruction of original object when last
reference is destroyed. It is similar to Java approach with a
difference that desctruction time is strictly defined. Only pointers
returned by new() are supported. This class is not thread-safe

C++ includes: Utils.h ";

%feature("docstring")  Arc::CountedPointer::CountedPointer "Arc::CountedPointer< T >::CountedPointer(T *p) ";

%feature("docstring")  Arc::CountedPointer::CountedPointer "Arc::CountedPointer< T >::CountedPointer(CountedPointer< T > &p) ";

%feature("docstring")  Arc::CountedPointer::~CountedPointer "Arc::CountedPointer< T >::~CountedPointer(void) ";


// File: classArc_1_1Counter.xml
%feature("docstring") Arc::Counter "

A class defining a common interface for counters.

This class defines a common interface for counters as well as some
common functionality.

The purpose of a counter is to provide housekeeping some resource such
as e.g. disk space, memory or network bandwidth. The counter itself
will not be aware of what kind of resource it limits the use of.
Neither will it be aware of what unit is being used to measure that
resource. Counters are thus very similar to semaphores. Furthermore,
counters are designed to handle concurrent operations from multiple
threads/processes in a consistent manner.

Every counter has a limit, an excess limit and a value. The limit is a
number that specify how many units are available for reservation. The
value is the number of units that are currently available for
reservation, i.e. has not allready been reserved. The excess limit
specify how many extra units can be reserved for high priority needs
even if there are no normal units available for reservation. The
excess limit is similar to the credit limit of e.g. a VISA card.

The users of the resource must thus first call the counter in order to
make a reservation of an appropriate amount of the resource, then
allocate and use the resource and finally call the counter again to
cancel the reservation.

Typical usage is:

There are also alternative ways to make reservations, including self-
expiring reservations, prioritized reservations and reservations that
fail if they cannot be made fast enough.

For self expiring reservations, a duration is provided in the reserve
call: A self-expiring reservation can be cancelled explicitly before
it expires, but if it is not cancelled it will expire automatically
when the duration has passed. The default value for the duration is
ETERNAL, which means that the reservation will not be cancelled
automatically.

Prioritized reservations may use the excess limit and succeed
immediately even if there are no normal units available for
reservation. The value of the counter will in this case become
negative. A prioritized reservation looks like this:

Finally, a time out option can be provided for a reservation. If some
task should be performed within two seconds or not at all, the
reservation can look like this:

C++ includes: Counter.h ";

%feature("docstring")  Arc::Counter::~Counter "virtual
Arc::Counter::~Counter()

The destructor.

This is the destructor of the Counter class. Since the Counter class
has no attributes, nothing needs to be cleaned up and thus the
destructor is empty. ";

%feature("docstring")  Arc::Counter::getLimit "virtual int
Arc::Counter::getLimit()=0

Returns the current limit of the counter.

This method returns the current limit of the counter, i.e. how many
units can be reserved simultaneously by different threads without
claiming high priority. The current limit of the counter. ";

%feature("docstring")  Arc::Counter::setLimit "virtual int
Arc::Counter::setLimit(int newLimit)=0

Sets the limit of the counter.

This method sets a new limit for the counter.

Parameters:
-----------

newLimit:  The new limit, an absolute number.

The new limit. ";

%feature("docstring")  Arc::Counter::changeLimit "virtual int
Arc::Counter::changeLimit(int amount)=0

Changes the limit of the counter.

Changes the limit of the counter by adding a certain amount to the
current limit.

Parameters:
-----------

amount:  The amount by which to change the limit.

The new limit. ";

%feature("docstring")  Arc::Counter::getExcess "virtual int
Arc::Counter::getExcess()=0

Returns the excess limit of the counter.

Returns the excess limit of the counter, i.e. by how much the usual
limit may be exceeded by prioritized reservations. The excess limit.
";

%feature("docstring")  Arc::Counter::setExcess "virtual int
Arc::Counter::setExcess(int newExcess)=0

Sets the excess limit of the counter.

This method sets a new excess limit for the counter.

Parameters:
-----------

newExcess:  The new excess limit, an absolute number.

The new excess limit. ";

%feature("docstring")  Arc::Counter::changeExcess "virtual int
Arc::Counter::changeExcess(int amount)=0

Changes the excess limit of the counter.

Changes the excess limit of the counter by adding a certain amount to
the current excess limit.

Parameters:
-----------

amount:  The amount by which to change the excess limit.

The new excess limit. ";

%feature("docstring")  Arc::Counter::getValue "virtual int
Arc::Counter::getValue()=0

Returns the current value of the counter.

Returns the current value of the counter, i.e. the number of
unreserved units. Initially, the value is equal to the limit of the
counter. When a reservation is made, the the value is decreased.
Normally, the value should never be negative, but this may happen if
there are prioritized reservations. It can also happen if the limit is
decreased after some reservations have been made, since reservations
are never revoked. The current value of the counter. ";

%feature("docstring")  Arc::Counter::reserve "virtual CounterTicket
Arc::Counter::reserve(int amount=1, Glib::TimeVal duration=ETERNAL,
bool prioritized=false, Glib::TimeVal timeOut=ETERNAL)=0

Makes a reservation from the counter.

This method makes a reservation from the counter. If the current value
of the counter is too low to allow for the reservation, the method
blocks until the reservation is possible or times out.

Parameters:
-----------

amount:  The amount to reserve, default value is 1.

duration:  The duration of a self expiring reservation, default is
that it lasts forever.

prioritized:  Whether this reservation is prioritized and thus allowed
to use the excess limit.

timeOut:  The maximum time to block if the value of the counter is too
low, default is to allow \"eternal\" blocking.

A CounterTicket that can be queried about the status of the
reservation as well as for cancellations and extensions. ";


// File: classArc_1_1CounterTicket.xml
%feature("docstring") Arc::CounterTicket "

A class for \"tickets\" that correspond to counter reservations.

This is a class for reservation tickets. When a reservation is made
from a Counter, a ReservationTicket is returned. This ticket can then
be queried about the validity of a reservation. It can also be used
for cancelation and extension of reservations.

Typical usage is:

C++ includes: Counter.h ";

%feature("docstring")  Arc::CounterTicket::CounterTicket "Arc::CounterTicket::CounterTicket()

The default constructor.

This is the default constructor. It creates a CounterTicket that is
not valid. The ticket object that is created can later be assigned a
ticket that is returned by the reserve() method of a Counter. ";

%feature("docstring")  Arc::CounterTicket::isValid "bool
Arc::CounterTicket::isValid()

Returns the validity of a CounterTicket.

This method checks whether a CounterTicket is valid. The ticket was
probably returned earlier by the reserve() method of a Counter but the
corresponding reservation may have expired. The validity of the
ticket. ";

%feature("docstring")  Arc::CounterTicket::extend "void
Arc::CounterTicket::extend(Glib::TimeVal duration)

Extends a reservation.

Extends a self-expiring reservation. In order to succeed the extension
should be made before the previous reservation expires.

Parameters:
-----------

duration:  The time by which to extend the reservation. The new
expiration time is computed based on the current time, NOT the
previous expiration time. ";

%feature("docstring")  Arc::CounterTicket::cancel "void
Arc::CounterTicket::cancel()

Cancels a resrvation.

This method is called to cancel a reservation. It may be called also
for self-expiring reservations, which will then be cancelled before
they were originally planned to expire. ";


// File: classArc_1_1CRC32Sum.xml
%feature("docstring") Arc::CRC32Sum "

Implementation of CRC32 checksum.

C++ includes: CheckSum.h ";

%feature("docstring")  Arc::CRC32Sum::CRC32Sum "Arc::CRC32Sum::CRC32Sum(void) ";

%feature("docstring")  Arc::CRC32Sum::~CRC32Sum "virtual
Arc::CRC32Sum::~CRC32Sum(void) ";

%feature("docstring")  Arc::CRC32Sum::start "virtual void
Arc::CRC32Sum::start(void) ";

%feature("docstring")  Arc::CRC32Sum::add "virtual void
Arc::CRC32Sum::add(void *buf, unsigned long long int len) ";

%feature("docstring")  Arc::CRC32Sum::end "virtual void
Arc::CRC32Sum::end(void) ";

%feature("docstring")  Arc::CRC32Sum::result "virtual void
Arc::CRC32Sum::result(unsigned char *&res, unsigned int &len) const ";

%feature("docstring")  Arc::CRC32Sum::print "virtual int
Arc::CRC32Sum::print(char *buf, int len) const ";

%feature("docstring")  Arc::CRC32Sum::scan "virtual void
Arc::CRC32Sum::scan(const char *buf) ";

%feature("docstring")  Arc::CRC32Sum::crc "uint32_t
Arc::CRC32Sum::crc(void) const ";


// File: classArc_1_1Credential.xml
%feature("docstring") Arc::Credential "";

%feature("docstring")  Arc::Credential::Credential "Arc::Credential::Credential()

Default constructor, only acts as a container for inquiring
certificate request, is meaningless for any other use. ";

%feature("docstring")  Arc::Credential::Credential "Arc::Credential::Credential(int keybits)

Constructor with user-defined keylength. Needed for creation of EE
certs, since some applications will only support keys with a certain
minimum length > 1024 ";

%feature("docstring")  Arc::Credential::~Credential "virtual
Arc::Credential::~Credential() ";

%feature("docstring")  Arc::Credential::Credential "Arc::Credential::Credential(const std::string &CAfile, const
std::string &CAkey, const std::string &CAserial, const std::string
&extfile, const std::string &extsect, const std::string
&passphrase4key)

Constructor, specific constructor for CA certificate is meaningless
for any other use. ";

%feature("docstring")  Arc::Credential::Credential "Arc::Credential::Credential(Time start, Period
lifetime=Period(\"PT12H\"), int keybits=1024, std::string
proxyversion=\"rfc\", std::string policylang=\"inheritAll\",
std::string policy=\"\", int pathlength=-1)

Constructor, specific constructor for proxy certificate, only acts as
a container for constraining certificate signing and/or generating
certificate request(only keybits is useful for creating certificate
request), is meaningless for any other use. The proxyversion and
policylang is for specifying the proxy certificate type and the policy
language inside proxy. The definition of proxyversion and policy
language is based
onhttp://dev.globus.org/wiki/Security/ProxyCertTypes#RFC_3820_Proxy_Certificates
The code is supposed to support proxy version: GSI2(legacy proxy),
GSI3(Proxy draft) and RFC(RFC3820 proxy), and correspoding policy
language. GSI2(GSI2, GSI2_LIMITED) GSI3 and RFC (IMPERSONATION_PROXY--
1.3.6.1.5.5.7.21.1, INDEPENDENT_PROXY--1.3.6.1.5.5.7.21.2,
LIMITED_PROXY--1.3.6.1.4.1.3536.1.1.1.9, RESTRICTED_PROXY--policy
language undefined) In openssl>=098, there are three types of policy
languages: id-ppl-inheritAll--1.3.6.1.5.5.7.21.1, id-ppl-independent--
1.3.6.1.5.5.7.21.2, and id-ppl-anyLanguage-1.3.6.1.5.5.7.21.0

Parameters:
-----------

start:  start:  time of proxy certificate

lifetime:  lifetime:  of proxy certificate

keybits:  modulus:  size for RSA key generation, it should be greater
than 1024 if 'this' class is used for generating X509 request; it
should be '0' if 'this' class is used for constraing certificate
signing. ";

%feature("docstring")  Arc::Credential::Credential "Arc::Credential::Credential(const std::string &cert, const std::string
&key, const std::string &cadir, const std::string &cafile, const
std::string &passphrase4key=\"\", const bool is_file=true)

Constructor, specific constructor for usual certificate, constructing
from credential files. only acts as a container for parsing the
certificate and key files, is meaningless for any other use. this
constructor will parse the credential information, and put them into
\"this\" object

Parameters:
-----------

passphrase4key:  specifies:  the password for descrypting private key
(if needed). If value is empty then password will be asked
interrctively. To avoid askig for password use value provided by
NoPassword() method.

is_file:  specifies:  if the cert/key are from file, otherwise they
are supposed to be from string. default is from file ";

%feature("docstring")  Arc::Credential::Credential "Arc::Credential::Credential(const UserConfig &usercfg, const
std::string &passphrase4key=\"\")

Constructor, specific constructor for usual certificate, constructing
from information in UserConfig object. Only acts as a container for
parsing the certificate and key files, is meaningless for any other
use. this constructor will parse the credential * information, and put
them into \"this\" object

Parameters:
-----------

is_file:  specify:  if the cert/key are from file, otherwise they are
supposed to be from string. default is from file ";

%feature("docstring")  Arc::Credential::AddCertExtObj "void
Arc::Credential::AddCertExtObj(std::string &sn, std::string &oid)

General method for adding a new nid into openssl's global const ";

%feature("docstring")  Arc::Credential::LogError "void
Arc::Credential::LogError(void) const

Log error information related with openssl ";

%feature("docstring")  Arc::Credential::GetVerification "bool
Arc::Credential::GetVerification(void) const

Get the verification result about certificate chain checking ";

%feature("docstring")  Arc::Credential::GetPrivKey "EVP_PKEY*
Arc::Credential::GetPrivKey(void) const

Get the private key attached to this object ";

%feature("docstring")  Arc::Credential::GetPubKey "EVP_PKEY*
Arc::Credential::GetPubKey(void) const

Get the public key attached to this object ";

%feature("docstring")  Arc::Credential::GetCert "X509*
Arc::Credential::GetCert(void) const

Get the certificate attached to this object ";

%feature("docstring")  Arc::Credential::GetCertReq "X509_REQ*
Arc::Credential::GetCertReq(void) const

Get the certificate request, if there is any ";

%feature("docstring")  Arc::Credential::STACK_OF "Arc::Credential::STACK_OF(X509)*GetCertChain(void) const

Get the certificate chain attached to this object ";

%feature("docstring")  Arc::Credential::GetCertNumofChain "int
Arc::Credential::GetCertNumofChain(void) const

Get the number of certificates in the certificate chain attached to
this object ";

%feature("docstring")  Arc::Credential::getFormat "Credformat
Arc::Credential::getFormat(BIO *in, const bool is_file=true) const

Get the certificate format, PEM PKCS12 or DER BIO could be memory or
file, they should be processed differently. ";

%feature("docstring")  Arc::Credential::GetDN "std::string
Arc::Credential::GetDN(void) const

Get the DN of the certificate attached to this object ";

%feature("docstring")  Arc::Credential::GetIdentityName "std::string
Arc::Credential::GetIdentityName(void) const

Get the Identity name of the certificate attached to this object, the
result will not include proxy CN ";

%feature("docstring")  Arc::Credential::GetType "ArcCredential::certType Arc::Credential::GetType(void) const

Get type of the certificate attached to this object ";

%feature("docstring")  Arc::Credential::GetIssuerName "std::string
Arc::Credential::GetIssuerName(void) const

Get issuer of the certificate attached to this object ";

%feature("docstring")  Arc::Credential::GetProxyPolicy "std::string
Arc::Credential::GetProxyPolicy(void) const

Get the proxy policy attached to the \"proxy certificate information\"
extension of the proxy certicate ";

%feature("docstring")  Arc::Credential::SetProxyPolicy "void
Arc::Credential::SetProxyPolicy(const std::string &proxyversion, const
std::string &policylang, const std::string &policy, int pathlength)

Set the proxy policy attached to the \"proxy certificate information\"
extension of the proxy certicate ";

%feature("docstring")  Arc::Credential::OutputPrivatekey "bool
Arc::Credential::OutputPrivatekey(std::string &content, bool
encryption=false, const std::string &passphrase=\"\")

Output the private key into string

Parameters:
-----------

encryption:  whether:  encrypt the output private key or not

passphrase:  the:  passphrase to encrypt the output private key ";

%feature("docstring")  Arc::Credential::OutputPublickey "bool
Arc::Credential::OutputPublickey(std::string &content)

Output the public key into string ";

%feature("docstring")  Arc::Credential::OutputCertificate "bool
Arc::Credential::OutputCertificate(std::string &content, bool
is_der=false)

Output the certificate into string

Parameters:
-----------

is_der:  false for PEM, true for DER ";

%feature("docstring")  Arc::Credential::OutputCertificateChain "bool
Arc::Credential::OutputCertificateChain(std::string &content, bool
is_der=false)

Output the certificate chain into string

Parameters:
-----------

is_der:  false for PEM, true for DER ";

%feature("docstring")  Arc::Credential::GetLifeTime "Period
Arc::Credential::GetLifeTime(void) const

Returns lifetime of certificate or proxy ";

%feature("docstring")  Arc::Credential::GetStartTime "Time
Arc::Credential::GetStartTime() const

Returns validity start time of certificate or proxy ";

%feature("docstring")  Arc::Credential::GetEndTime "Time
Arc::Credential::GetEndTime() const

Returns validity end time of certificate or proxy ";

%feature("docstring")  Arc::Credential::SetLifeTime "void
Arc::Credential::SetLifeTime(const Period &period)

Set lifetime of certificate or proxy ";

%feature("docstring")  Arc::Credential::SetStartTime "void
Arc::Credential::SetStartTime(const Time &start_time)

Set start time of certificate or proxy ";

%feature("docstring")  Arc::Credential::IsValid "bool
Arc::Credential::IsValid(void)

Returns true if credentials are valid ";

%feature("docstring")  Arc::Credential::AddExtension "bool
Arc::Credential::AddExtension(const std::string &name, const
std::string &data, bool crit=false)

Add an extension to the extension part of the certificate

Parameters:
-----------

name:  the:  name of the extension, there OID related with the name
should be registered into openssl firstly

data:  the:  data which will be inserted into certificate extension ";

%feature("docstring")  Arc::Credential::AddExtension "bool
Arc::Credential::AddExtension(const std::string &name, char **binary)

Add an extension to the extension part of the certificate

Parameters:
-----------

binary:  the:  data which will be inserted into certificate extension
part as a specific extension there should be specific methods defined
inside specific X509V3_EXT_METHOD structure to parse the specific
extension format. For example, VOMS attribute certificate is a
specific extension to proxy certificate. There is specific
X509V3_EXT_METHOD defined in VOMSAttribute.h and VOMSAttribute.c for
parsing attribute certificate. In openssl, the specific
X509V3_EXT_METHOD can be got according to the extension name/id, see
X509V3_EXT_get_nid(ext_nid) ";

%feature("docstring")  Arc::Credential::GenerateEECRequest "bool
Arc::Credential::GenerateEECRequest(BIO *reqbio, BIO *keybio, const
std::string &dn=\"\")

Generate an EEC request, based on the keybits and signing algorithm
information inside this object output the certificate request to
output BIO

The user will be asked for a private key password ";

%feature("docstring")  Arc::Credential::GenerateEECRequest "bool
Arc::Credential::GenerateEECRequest(std::string &reqcontent,
std::string &keycontent, const std::string &dn=\"\")

Generate an EEC request, output the certificate request to a string ";

%feature("docstring")  Arc::Credential::GenerateEECRequest "bool
Arc::Credential::GenerateEECRequest(const char *request_filename,
const char *key_filename, const std::string &dn=\"\")

Generate an EEC request, output the certificate request and the key to
a file ";

%feature("docstring")  Arc::Credential::GenerateRequest "bool
Arc::Credential::GenerateRequest(BIO *bio, bool if_der=false)

Generate a proxy request, base on the keybits and signing algorithm
information inside this object output the certificate request to
output BIO ";

%feature("docstring")  Arc::Credential::GenerateRequest "bool
Arc::Credential::GenerateRequest(std::string &content, bool
if_der=false)

Generate a proxy request, output the certificate request to a string
";

%feature("docstring")  Arc::Credential::GenerateRequest "bool
Arc::Credential::GenerateRequest(const char *filename, bool
if_der=false)

Generate a proxy request, output the certificate request to a file ";

%feature("docstring")  Arc::Credential::InquireRequest "bool
Arc::Credential::InquireRequest(BIO *reqbio, bool if_eec=false, bool
if_der=false)

Inquire the certificate request from BIO, and put the request
information to X509_REQ inside this object, and parse the certificate
type from the PROXYCERTINFO of request' extension

Parameters:
-----------

if_der:  false for PEM; true for DER ";

%feature("docstring")  Arc::Credential::InquireRequest "bool
Arc::Credential::InquireRequest(std::string &content, bool
if_eec=false, bool if_der=false)

Inquire the certificate request from a string ";

%feature("docstring")  Arc::Credential::InquireRequest "bool
Arc::Credential::InquireRequest(const char *filename, bool
if_eec=false, bool if_der=false)

Inquire the certificate request from a file ";

%feature("docstring")  Arc::Credential::SignRequest "bool
Arc::Credential::SignRequest(Credential *proxy, BIO *outputbio, bool
if_der=false)

Sign request based on the information inside proxy, and output the
signed certificate to output BIO

Parameters:
-----------

if_der:  false for PEM, true for DER ";

%feature("docstring")  Arc::Credential::SignRequest "bool
Arc::Credential::SignRequest(Credential *proxy, std::string &content,
bool if_der=false)

Sign request and output the signed certificate to a string

Parameters:
-----------

if_der:  false for PEM, true for DER ";

%feature("docstring")  Arc::Credential::SignRequest "bool
Arc::Credential::SignRequest(Credential *proxy, const char *filename,
bool foamat=false)

Sign request and output the signed certificate to a file

Parameters:
-----------

if_der:  false for PEM, true for DER ";

%feature("docstring")  Arc::Credential::SelfSignEECRequest "bool
Arc::Credential::SelfSignEECRequest(const std::string &dn, const char
*filename) ";

%feature("docstring")  Arc::Credential::SignEECRequest "bool
Arc::Credential::SignEECRequest(Credential *eec, const std::string
&dn, BIO *outputbio)

Sign eec request, and output the signed certificate to output BIO ";

%feature("docstring")  Arc::Credential::SignEECRequest "bool
Arc::Credential::SignEECRequest(Credential *eec, const std::string
&dn, std::string &content)

Sign request and output the signed certificate to a string ";

%feature("docstring")  Arc::Credential::SignEECRequest "bool
Arc::Credential::SignEECRequest(Credential *eec, const std::string
&dn, const char *filename)

Sign request and output the signed certificate to a file ";


// File: classArc_1_1CredentialError.xml
%feature("docstring") Arc::CredentialError "

This is an exception class that is used to handle runtime errors
discovered in the Credential class.

C++ includes: Credential.h ";

%feature("docstring")  Arc::CredentialError::CredentialError "Arc::CredentialError::CredentialError(const std::string &what=\"\")

This is the constructor of the CredentialError class.

Parameters:
-----------

what:  An explanation of the error. ";


// File: classArc_1_1CredentialStore.xml
%feature("docstring") Arc::CredentialStore "

This class provides functionality for storing delegated crdentials and
retrieving them from some store services. This is very preliminary
implementation and currently support only one type of credentials -
X.509 proxies, and only one type of store service - MyProxy. Later it
will be extended to support at least following services: ARC
delegation service, VOMS service, local file system.

C++ includes: CredentialStore.h ";

%feature("docstring")  Arc::CredentialStore::CredentialStore "Arc::CredentialStore::CredentialStore(const URL &url) ";

%feature("docstring")  Arc::CredentialStore::CredentialStore "Arc::CredentialStore::CredentialStore(const UserConfig &cfg, const URL
&url) ";

%feature("docstring")  Arc::CredentialStore::~CredentialStore "Arc::CredentialStore::~CredentialStore(void) ";

%feature("docstring")  Arc::CredentialStore::Store "bool
Arc::CredentialStore::Store(const std::map< std::string, std::string >
&options, const std::string &cred=\"\") ";

%feature("docstring")  Arc::CredentialStore::Retrieve "bool
Arc::CredentialStore::Retrieve(const std::map< std::string,
std::string > &options, std::string &cred) ";


// File: classArc_1_1Database.xml
%feature("docstring") Arc::Database "

Interface for calling database client library.

For different types of database client library, different classes
should be implemented by implementing this interface.

C++ includes: DBInterface.h ";

%feature("docstring")  Arc::Database::Database "Arc::Database::Database()

Default constructor ";

%feature("docstring")  Arc::Database::Database "Arc::Database::Database(std::string &server, int port)

Constructor which uses the server's name(or IP address) and port as
parametes ";

%feature("docstring")  Arc::Database::Database "Arc::Database::Database(const Database &other)

Copy constructor ";

%feature("docstring")  Arc::Database::~Database "virtual
Arc::Database::~Database()

Deconstructor ";

%feature("docstring")  Arc::Database::connect "virtual bool
Arc::Database::connect(std::string &dbname, std::string &user,
std::string &password)=0

Do connection with database server

Parameters:
-----------

dbname:  The database name which will be used.

user:  The username which will be used to access database.

password:  The password which will be used to access database. ";

%feature("docstring")  Arc::Database::isconnected "virtual bool
Arc::Database::isconnected() const =0

Get the connection status ";

%feature("docstring")  Arc::Database::close "virtual void
Arc::Database::close()=0

Close the connection with database server ";

%feature("docstring")  Arc::Database::enable_ssl "virtual bool
Arc::Database::enable_ssl(const std::string keyfile=\"\", const
std::string certfile=\"\", const std::string cafile=\"\", const
std::string capath=\"\")=0

Enable ssl communication for the connection

Parameters:
-----------

keyfile:  The location of key file.

certfile:  The location of certificate file.

cafile:  The location of ca file.

capath:  The location of ca directory ";

%feature("docstring")  Arc::Database::shutdown "virtual bool
Arc::Database::shutdown()=0

Ask database server to shutdown ";


// File: classArc_1_1DataBuffer.xml
%feature("docstring") Arc::DataBuffer "

Represents set of buffers.

This class is used used during data transfer using DataPoint classes.

C++ includes: DataBuffer.h ";

%feature("docstring")  Arc::DataBuffer::DataBuffer "Arc::DataBuffer::DataBuffer(unsigned int size=65536, int blocks=3)

Contructor

Parameters:
-----------

size:  size of every buffer in bytes.

blocks:  number of buffers. ";

%feature("docstring")  Arc::DataBuffer::DataBuffer "Arc::DataBuffer::DataBuffer(CheckSum *cksum, unsigned int size=65536,
int blocks=3)

Contructor

Parameters:
-----------

size:  size of every buffer in bytes.

blocks:  number of buffers.

cksum:  object which will compute checksum. Should not be destroyed
till DataBuffer itself. ";

%feature("docstring")  Arc::DataBuffer::~DataBuffer "Arc::DataBuffer::~DataBuffer()

Destructor. ";

%feature("docstring")  Arc::DataBuffer::set "bool
Arc::DataBuffer::set(CheckSum *cksum=NULL, unsigned int size=65536,
int blocks=3)

Reinitialize buffers with different parameters.

Parameters:
-----------

size:  size of every buffer in bytes.

blocks:  number of buffers.

cksum:  object which will compute checksum. Should not be destroyed
till DataBuffer itself. ";

%feature("docstring")  Arc::DataBuffer::add "int
Arc::DataBuffer::add(CheckSum *cksum)

Add a checksum object which will compute checksum of buffer.

Parameters:
-----------

cksum:  object which will compute checksum. Should not be destroyed
till DataBuffer itself.

integer position in the list of checksum objects. ";

%feature("docstring")  Arc::DataBuffer::for_read "bool
Arc::DataBuffer::for_read(int &handle, unsigned int &length, bool
wait)

Request buffer for READING INTO it.

Parameters:
-----------

handle:  returns buffer's number.

length:  returns size of buffer

wait:  if true and there are no free buffers, method will wait for
one.

true on success ";

%feature("docstring")  Arc::DataBuffer::for_read "bool
Arc::DataBuffer::for_read()

Check if there are buffers which can be taken by for_read(). This
function checks only for buffers and does not take eof and error
conditions into account. ";

%feature("docstring")  Arc::DataBuffer::is_read "bool
Arc::DataBuffer::is_read(int handle, unsigned int length, unsigned
long long int offset)

Informs object that data was read into buffer.

Parameters:
-----------

handle:  buffer's number.

length:  amount of data.

offset:  offset in stream, file, etc. ";

%feature("docstring")  Arc::DataBuffer::is_read "bool
Arc::DataBuffer::is_read(char *buf, unsigned int length, unsigned long
long int offset)

Informs object that data was read into buffer.

Parameters:
-----------

buf:  - address of buffer

length:  amount of data.

offset:  offset in stream, file, etc. ";

%feature("docstring")  Arc::DataBuffer::for_write "bool
Arc::DataBuffer::for_write(int &handle, unsigned int &length, unsigned
long long int &offset, bool wait)

Request buffer for WRITING FROM it.

Parameters:
-----------

handle:  returns buffer's number.

length:  returns size of buffer

wait:  if true and there are no free buffers, method will wait for
one. ";

%feature("docstring")  Arc::DataBuffer::for_write "bool
Arc::DataBuffer::for_write()

Check if there are buffers which can be taken by for_write(). This
function checks only for buffers and does not take eof and error
conditions into account. ";

%feature("docstring")  Arc::DataBuffer::is_written "bool
Arc::DataBuffer::is_written(int handle)

Informs object that data was written from buffer.

Parameters:
-----------

handle:  buffer's number. ";

%feature("docstring")  Arc::DataBuffer::is_written "bool
Arc::DataBuffer::is_written(char *buf)

Informs object that data was written from buffer.

Parameters:
-----------

buf:  - address of buffer ";

%feature("docstring")  Arc::DataBuffer::is_notwritten "bool
Arc::DataBuffer::is_notwritten(int handle)

Informs object that data was NOT written from buffer (and releases
buffer).

Parameters:
-----------

handle:  buffer's number. ";

%feature("docstring")  Arc::DataBuffer::is_notwritten "bool
Arc::DataBuffer::is_notwritten(char *buf)

Informs object that data was NOT written from buffer (and releases
buffer).

Parameters:
-----------

buf:  - address of buffer ";

%feature("docstring")  Arc::DataBuffer::eof_read "void
Arc::DataBuffer::eof_read(bool v)

Informs object if there will be no more request for 'read' buffers. v
true if no more requests. ";

%feature("docstring")  Arc::DataBuffer::eof_write "void
Arc::DataBuffer::eof_write(bool v)

Informs object if there will be no more request for 'write' buffers. v
true if no more requests. ";

%feature("docstring")  Arc::DataBuffer::error_read "void
Arc::DataBuffer::error_read(bool v)

Informs object if error accured on 'read' side.

Parameters:
-----------

v:  true if error. ";

%feature("docstring")  Arc::DataBuffer::error_write "void
Arc::DataBuffer::error_write(bool v)

Informs object if error accured on 'write' side.

Parameters:
-----------

v:  true if error. ";

%feature("docstring")  Arc::DataBuffer::eof_read "bool
Arc::DataBuffer::eof_read()

Returns true if object was informed about end of transfer on 'read'
side. ";

%feature("docstring")  Arc::DataBuffer::eof_write "bool
Arc::DataBuffer::eof_write()

Returns true if object was informed about end of transfer on 'write'
side. ";

%feature("docstring")  Arc::DataBuffer::error_read "bool
Arc::DataBuffer::error_read()

Returns true if object was informed about error on 'read' side. ";

%feature("docstring")  Arc::DataBuffer::error_write "bool
Arc::DataBuffer::error_write()

Returns true if object was informed about error on 'write' side. ";

%feature("docstring")  Arc::DataBuffer::error_transfer "bool
Arc::DataBuffer::error_transfer()

Returns true if eror occured inside object. ";

%feature("docstring")  Arc::DataBuffer::error "bool
Arc::DataBuffer::error()

Returns true if object was informed about error or internal error
occured. ";

%feature("docstring")  Arc::DataBuffer::wait_any "bool
Arc::DataBuffer::wait_any()

Wait (max 60 sec.) till any action happens in object. Returns true if
action is eof on any side. ";

%feature("docstring")  Arc::DataBuffer::wait_used "bool
Arc::DataBuffer::wait_used()

Wait till there are no more used buffers left in object. ";

%feature("docstring")  Arc::DataBuffer::checksum_valid "bool
Arc::DataBuffer::checksum_valid() const

Returns true if checksum was successfully computed, returns false if
index is not in list.

Parameters:
-----------

index:  of the checksum in question. ";

%feature("docstring")  Arc::DataBuffer::checksum_valid "bool
Arc::DataBuffer::checksum_valid(int index) const ";

%feature("docstring")  Arc::DataBuffer::checksum_object "const
CheckSum* Arc::DataBuffer::checksum_object() const

Returns CheckSum object specified in constructor, returns NULL if
index is not in list.

Parameters:
-----------

index:  of the checksum in question. ";

%feature("docstring")  Arc::DataBuffer::checksum_object "const
CheckSum* Arc::DataBuffer::checksum_object(int index) const ";

%feature("docstring")  Arc::DataBuffer::wait_eof_read "bool
Arc::DataBuffer::wait_eof_read()

Wait till end of transfer happens on 'read' side. ";

%feature("docstring")  Arc::DataBuffer::wait_read "bool
Arc::DataBuffer::wait_read()

Wait till end of transfer or error happens on 'read' side. ";

%feature("docstring")  Arc::DataBuffer::wait_eof_write "bool
Arc::DataBuffer::wait_eof_write()

Wait till end of transfer happens on 'write' side. ";

%feature("docstring")  Arc::DataBuffer::wait_write "bool
Arc::DataBuffer::wait_write()

Wait till end of transfer or error happens on 'write' side. ";

%feature("docstring")  Arc::DataBuffer::wait_eof "bool
Arc::DataBuffer::wait_eof()

Wait till end of transfer happens on any side. ";

%feature("docstring")  Arc::DataBuffer::eof_position "unsigned long
long int Arc::DataBuffer::eof_position() const

Returns offset following last piece of data transferred. ";

%feature("docstring")  Arc::DataBuffer::buffer_size "unsigned int
Arc::DataBuffer::buffer_size() const

Returns size of buffer in object. If not initialized then this number
represents size of default buffer. ";


// File: classArc_1_1DataCallback.xml
%feature("docstring") Arc::DataCallback "

This class is used by DataHandle to report missing space on local
filesystem. One of 'cb' functions here will be called if operation
initiated by DataHandle::start_reading runs out of disk space.

C++ includes: DataCallback.h ";

%feature("docstring")  Arc::DataCallback::DataCallback "Arc::DataCallback::DataCallback() ";

%feature("docstring")  Arc::DataCallback::~DataCallback "virtual
Arc::DataCallback::~DataCallback() ";

%feature("docstring")  Arc::DataCallback::cb "virtual bool
Arc::DataCallback::cb(int) ";

%feature("docstring")  Arc::DataCallback::cb "virtual bool
Arc::DataCallback::cb(unsigned int) ";

%feature("docstring")  Arc::DataCallback::cb "virtual bool
Arc::DataCallback::cb(long long int) ";

%feature("docstring")  Arc::DataCallback::cb "virtual bool
Arc::DataCallback::cb(unsigned long long int) ";


// File: classArc_1_1DataHandle.xml
%feature("docstring") Arc::DataHandle "

This class is a wrapper around the DataPoint class.

It simplifies the construction, use and destruction of DataPoint
objects.

C++ includes: DataHandle.h ";

%feature("docstring")  Arc::DataHandle::DataHandle "Arc::DataHandle::DataHandle(const URL &url, const UserConfig &usercfg)
";

%feature("docstring")  Arc::DataHandle::~DataHandle "Arc::DataHandle::~DataHandle() ";


// File: classArc_1_1DataMover.xml
%feature("docstring") Arc::DataMover "

A purpose of this class is to provide an interface that moves data
between two locations specified by URLs. It's main action is
represented by methods DataMover::Transfer. Instance represents only
attributes used during transfer.

C++ includes: DataMover.h ";

%feature("docstring")  Arc::DataMover::DataMover "Arc::DataMover::DataMover()

Constructor. ";

%feature("docstring")  Arc::DataMover::~DataMover "Arc::DataMover::~DataMover()

Destructor. ";

%feature("docstring")  Arc::DataMover::Transfer "DataStatus
Arc::DataMover::Transfer(DataPoint &source, DataPoint &destination,
FileCache &cache, const URLMap &map, callback cb=NULL, void *arg=NULL,
const char *prefix=NULL)

Initiates transfer from 'source' to 'destination'.

Parameters:
-----------

source:  source URL.

destination:  destination URL.

cache:  controls caching of downloaded files (if destination url is
\"file://\"). If caching is not needed default constructor FileCache()
can be used.

map:   URL mapping/convertion table (for 'source' URL).

cb:  if not NULL, transfer is done in separate thread and 'cb' is
called after transfer completes/fails.

arg:  passed to 'cb'.

prefix:  if 'verbose' is activated this information will be printed
before each line representing current transfer status. ";

%feature("docstring")  Arc::DataMover::Transfer "DataStatus
Arc::DataMover::Transfer(DataPoint &source, DataPoint &destination,
FileCache &cache, const URLMap &map, unsigned long long int min_speed,
time_t min_speed_time, unsigned long long int min_average_speed,
time_t max_inactivity_time, callback cb=NULL, void *arg=NULL, const
char *prefix=NULL)

Initiates transfer from 'source' to 'destination'.

Parameters:
-----------

min_speed:  minimal allowed current speed.

min_speed_time:  time for which speed should be less than 'min_speed'
before transfer fails.

min_average_speed:  minimal allowed average speed.

max_inactivity_time:  time for which should be no activity before
transfer fails. ";

%feature("docstring")  Arc::DataMover::Delete "DataStatus
Arc::DataMover::Delete(DataPoint &url, bool errcont=false) ";

%feature("docstring")  Arc::DataMover::verbose "bool
Arc::DataMover::verbose()

Check if printing information about transfer status is activated. ";

%feature("docstring")  Arc::DataMover::verbose "void
Arc::DataMover::verbose(bool)

Activate printing information about transfer status. ";

%feature("docstring")  Arc::DataMover::verbose "void
Arc::DataMover::verbose(const std::string &prefix)

Activate printing information about transfer status.

Parameters:
-----------

prefix:  use this string if 'prefix' in DataMover::Transfer is NULL.
";

%feature("docstring")  Arc::DataMover::retry "bool
Arc::DataMover::retry()

Check if transfer will be retried in case of failure. ";

%feature("docstring")  Arc::DataMover::retry "void
Arc::DataMover::retry(bool)

Set if transfer will be retried in case of failure. ";

%feature("docstring")  Arc::DataMover::secure "void
Arc::DataMover::secure(bool)

Set if high level of security (encryption) will be used duirng
transfer if available. ";

%feature("docstring")  Arc::DataMover::passive "void
Arc::DataMover::passive(bool)

Set if passive transfer should be used for FTP-like transfers. ";

%feature("docstring")  Arc::DataMover::force_to_meta "void
Arc::DataMover::force_to_meta(bool)

Set if file should be transferred and registered even if such LFN is
already registered and source is not one of registered locations. ";

%feature("docstring")  Arc::DataMover::checks "bool
Arc::DataMover::checks()

Check if check for existance of remote file is done before initiating
'reading' and 'writing' operations. ";

%feature("docstring")  Arc::DataMover::checks "void
Arc::DataMover::checks(bool v)

Set if to make check for existance of remote file (and probably other
checks too) before initiating 'reading' and 'writing' operations.

Parameters:
-----------

v:  true if allowed (default is true). ";

%feature("docstring")  Arc::DataMover::set_default_min_speed "void
Arc::DataMover::set_default_min_speed(unsigned long long int
min_speed, time_t min_speed_time)

Set minimal allowed transfer speed (default is 0) to 'min_speed'. If
speed drops below for time longer than 'min_speed_time' error is
raised. For more information see description of DataSpeed class. ";

%feature("docstring")  Arc::DataMover::set_default_min_average_speed "void Arc::DataMover::set_default_min_average_speed(unsigned long long
int min_average_speed)

Set minimal allowed average transfer speed (default is 0 averaged over
whole time of transfer. For more information see description of
DataSpeed class. ";

%feature("docstring")  Arc::DataMover::set_default_max_inactivity_time
"void Arc::DataMover::set_default_max_inactivity_time(time_t
max_inactivity_time)

Set maximal allowed time for waiting for any data. For more
information see description of DataSpeed class. ";

%feature("docstring")  Arc::DataMover::set_progress_indicator "void
Arc::DataMover::set_progress_indicator(DataSpeed::show_progress_t
func=NULL) ";

%feature("docstring")  Arc::DataMover::set_preferred_pattern "void
Arc::DataMover::set_preferred_pattern(const std::string &pattern) ";


// File: classArc_1_1DataPoint.xml
%feature("docstring") Arc::DataPoint "

This base class is an abstraction of URL.

Specializations should be provided for different kind of direct access
URLs (file://,ftp://, gsiftp://,http://,https://, httpg://, ...) or
indexing service URLs (rls://, lfc://, ...). DataPoint provides means
to resolve an indexing service URL into multiple URLs and to loop
through them.

C++ includes: DataPoint.h ";

%feature("docstring")  Arc::DataPoint::DataPoint "Arc::DataPoint::DataPoint(const URL &url, const UserConfig &usercfg)

Constructor requires URL to be provided.

Reference to usercfg argument is stored internally and hence
corresponding objects must stay available during whole lifetime of
this instance. TODO: do we really need it? ";

%feature("docstring")  Arc::DataPoint::~DataPoint "virtual
Arc::DataPoint::~DataPoint()

Destructor. ";

%feature("docstring")  Arc::DataPoint::GetURL "virtual const URL&
Arc::DataPoint::GetURL() const

Returns the URL that was passed to the constructor. ";

%feature("docstring")  Arc::DataPoint::GetUserConfig "virtual const
UserConfig& Arc::DataPoint::GetUserConfig() const

Returns the UserConfig that was passed to the constructor. ";

%feature("docstring")  Arc::DataPoint::SetURL "virtual bool
Arc::DataPoint::SetURL(const URL &url)

Assigns new URL. Main purpose of this method is to reuse existing
connection for accessing different object at same server.
Implementation does not have to implement this method. If supplied URL
is not suitable or method is not implemented false is returned. ";

%feature("docstring")  Arc::DataPoint::str "virtual std::string
Arc::DataPoint::str() const

Returns a string representation of the DataPoint. ";

%feature("docstring")  Arc::DataPoint::PrepareReading "virtual
DataStatus Arc::DataPoint::PrepareReading(unsigned int timeout,
unsigned int &wait_time)

Prepare DataPoint for reading.

This method should be implemented by protocols which require
preparation or staging of physical files for reading. It can act
synchronously or asynchronously (if protocol supports it). In the
first case the method will block until the file is prepared or the
specified timeout has passed. In the second case the method can return
with a ReadPrepareWait status before the file is prepared. The caller
should then wait some time (a hint from the remote service may be
given in wait_time) and call PrepareReading() again to poll for the
preparation status, until the file is prepared. In this case it is
also up to the caller to decide when the request has taken too long
and if so cancel it by calling FinishReading(). When file preparation
has finished, the physical file(s) to read from can be found from
TransferLocations().

Parameters:
-----------

timeout:  If non-zero, this method will block until either the file
has been prepared successfully or the timeout has passed. A zero value
means that the caller would like to call and poll for status.

wait_time:  If timeout is zero (caller would like asynchronous
operation) and ReadPrepareWait is returned, a hint for how long to
wait before a subsequent call may be given in wait_time. ";

%feature("docstring")  Arc::DataPoint::PrepareWriting "virtual
DataStatus Arc::DataPoint::PrepareWriting(unsigned int timeout,
unsigned int &wait_time)

Prepare DataPoint for writing.

This method should be implemented by protocols which require
preparation of physical files for writing. It can act synchronously or
asynchronously (if protocol supports it). In the first case the method
will block until the file is prepared or the specified timeout has
passed. In the second case the method can return with a
WritePrepareWait status before the file is prepared. The caller should
then wait some time (a hint from the remote service may be given in
wait_time) and call PrepareWriting() again to poll for the preparation
status, until the file is prepared. In this case it is also up to the
caller to decide when the request has taken too long and if so cancel
or abort it by calling FinishWriting(true). When file preparation has
finished, the physical file(s) to write to can be found from
TransferLocations().

Parameters:
-----------

timeout:  If non-zero, this method will block until either the file
has been prepared successfully or the timeout has passed. A zero value
means that the caller would like to call and poll for status.

wait_time:  If timeout is zero (caller would like asynchronous
operation) and WritePrepareWait is returned, a hint for how long to
wait before a subsequent call may be given in wait_time. ";

%feature("docstring")  Arc::DataPoint::StartReading "virtual
DataStatus Arc::DataPoint::StartReading(DataBuffer &buffer)=0

Start reading data from URL.

Separate thread to transfer data will be created. No other operation
can be performed while reading is in progress.

Parameters:
-----------

buffer:  operation will use this buffer to put information into.
Should not be destroyed before StopReading() was called and returned.
";

%feature("docstring")  Arc::DataPoint::StartWriting "virtual
DataStatus Arc::DataPoint::StartWriting(DataBuffer &buffer,
DataCallback *space_cb=NULL)=0

Start writing data to URL.

Separate thread to transfer data will be created. No other operation
can be performed while writing is in progress.

Parameters:
-----------

buffer:  operation will use this buffer to get information from.
Should not be destroyed before stop_writing was called and returned.

space_cb:  callback which is called if there is not enough space to
store data. May not implemented for all protocols. ";

%feature("docstring")  Arc::DataPoint::StopReading "virtual
DataStatus Arc::DataPoint::StopReading()=0

Stop reading.

Must be called after corresponding start_reading method, either after
all data is transferred or to cancel transfer. Use buffer object to
find out when data is transferred. Must return failure if any happened
during transfer. ";

%feature("docstring")  Arc::DataPoint::StopWriting "virtual
DataStatus Arc::DataPoint::StopWriting()=0

Stop writing.

Must be called after corresponding start_writing method, either after
all data is transferred or to cancel transfer. Use buffer object to
find out when data is transferred. Must return failure if any happened
during transfer. ";

%feature("docstring")  Arc::DataPoint::FinishReading "virtual
DataStatus Arc::DataPoint::FinishReading(bool error=false)

Finish reading from the URL.

Must be called after transfer of physical file has completed and if
PrepareReading() was called, to free resources, release requests that
were made during preparation etc.

Parameters:
-----------

error:  If true then action is taken depending on the error. ";

%feature("docstring")  Arc::DataPoint::FinishWriting "virtual
DataStatus Arc::DataPoint::FinishWriting(bool error=false)

Finish writing to the URL.

Must be called after transfer of physical file has completed and if
PrepareWriting() was called, to free resources, release requests that
were made during preparation etc.

Parameters:
-----------

error:  If true then action is taken depending on the error. ";

%feature("docstring")  Arc::DataPoint::Check "virtual DataStatus
Arc::DataPoint::Check()=0

Query the DataPoint to check if object is accessible.

If possible this method will also try to provide meta information
about the object. It returns positive response if object's content can
be retrieved. ";

%feature("docstring")  Arc::DataPoint::Remove "virtual DataStatus
Arc::DataPoint::Remove()=0

Remove/delete object at URL. ";

%feature("docstring")  Arc::DataPoint::Stat "virtual DataStatus
Arc::DataPoint::Stat(FileInfo &file, DataPointInfoType
verb=INFO_TYPE_ALL)=0

Retrieve information about this object.

If the DataPoint represents a directory or something similar,
information about the object itself and not its contents will be
obtained.

Parameters:
-----------

file:  will contain object name and requested attributes. There may be
more attributes than requested. There may be less if object can't
provide particular information.

verb:  defines attribute types which method must try to retrieve. It
is not a failure if some attributes could not be retrieved due to
limitation of protocol or access control. ";

%feature("docstring")  Arc::DataPoint::List "virtual DataStatus
Arc::DataPoint::List(std::list< FileInfo > &files, DataPointInfoType
verb=INFO_TYPE_ALL)=0

List hierarchical content of this object.

If the DataPoint represents a directory or something similar its
contents will be listed.

Parameters:
-----------

files:  will contain list of file names and requested attributes.
There may be more attributes than requested. There may be less if
object can't provide particular information.

verb:  defines attribute types which method must try to retrieve. It
is not a failure if some attributes could not be retrieved due to
limitation of protocol or access control. ";

%feature("docstring")  Arc::DataPoint::ReadOutOfOrder "virtual void
Arc::DataPoint::ReadOutOfOrder(bool v)=0

Allow/disallow DataPoint to produce scattered data during reading*
operation.

Parameters:
-----------

v:  true if allowed (default is false). ";

%feature("docstring")  Arc::DataPoint::WriteOutOfOrder "virtual bool
Arc::DataPoint::WriteOutOfOrder()=0

Returns true if URL can accept scattered data for *writing* operation.
";

%feature("docstring")  Arc::DataPoint::SetAdditionalChecks "virtual
void Arc::DataPoint::SetAdditionalChecks(bool v)=0

Allow/disallow additional checks.

Check for existence of remote file (and probably other checks too)
before initiating reading and writing operations.

Parameters:
-----------

v:  true if allowed (default is true). ";

%feature("docstring")  Arc::DataPoint::GetAdditionalChecks "virtual
bool Arc::DataPoint::GetAdditionalChecks() const =0

Check if additional checks before will be performed. ";

%feature("docstring")  Arc::DataPoint::SetSecure "virtual void
Arc::DataPoint::SetSecure(bool v)=0

Allow/disallow heavy security during data transfer.

Parameters:
-----------

v:  true if allowed (default depends on protocol). ";

%feature("docstring")  Arc::DataPoint::GetSecure "virtual bool
Arc::DataPoint::GetSecure() const =0

Check if heavy security during data transfer is allowed. ";

%feature("docstring")  Arc::DataPoint::Passive "virtual void
Arc::DataPoint::Passive(bool v)=0

Request passive transfers for FTP-like protocols.

Parameters:
-----------

true:  to request. ";

%feature("docstring")  Arc::DataPoint::GetFailureReason "virtual
DataStatus Arc::DataPoint::GetFailureReason(void) const

Returns reason of transfer failure, as reported by callbacks. This
could be different from the failure returned by the methods
themselves. ";

%feature("docstring")  Arc::DataPoint::Range "virtual void
Arc::DataPoint::Range(unsigned long long int start=0, unsigned long
long int end=0)=0

Set range of bytes to retrieve.

Default values correspond to whole file. ";

%feature("docstring")  Arc::DataPoint::Resolve "virtual DataStatus
Arc::DataPoint::Resolve(bool source)=0

Resolves index service URL into list of ordinary URLs.

Also obtains meta information about the file.

Parameters:
-----------

source:  true if DataPoint object represents source of information. ";

%feature("docstring")  Arc::DataPoint::Registered "virtual bool
Arc::DataPoint::Registered() const =0

Check if file is registered in Indexing Service.

Proper value is obtainable only after Resolve. ";

%feature("docstring")  Arc::DataPoint::PreRegister "virtual
DataStatus Arc::DataPoint::PreRegister(bool replication, bool
force=false)=0

Index service preregistration.

This function registers the physical location of a file into an
indexing service. It should be called *before* the actual transfer to
that location happens.

Parameters:
-----------

replication:  if true, the file is being replicated between two
locations registered in the indexing service under same name.

force:  if true, perform registration of a new file even if it already
exists. Should be used to fix failures in Indexing Service. ";

%feature("docstring")  Arc::DataPoint::PostRegister "virtual
DataStatus Arc::DataPoint::PostRegister(bool replication)=0

Index Service postregistration.

Used for same purpose as PreRegister. Should be called after actual
transfer of file successfully finished.

Parameters:
-----------

replication:  if true, the file is being replicated between two
locations registered in Indexing Service under same name. ";

%feature("docstring")  Arc::DataPoint::PreUnregister "virtual
DataStatus Arc::DataPoint::PreUnregister(bool replication)=0

Index Service preunregistration.

Should be called if file transfer failed. It removes changes made by
PreRegister.

Parameters:
-----------

replication:  if true, the file is being replicated between two
locations registered in Indexing Service under same name. ";

%feature("docstring")  Arc::DataPoint::Unregister "virtual DataStatus
Arc::DataPoint::Unregister(bool all)=0

Index Service unregistration.

Remove information about file registered in Indexing Service.

Parameters:
-----------

all:  if true, information about file itself is (LFN) is removed.
Otherwise only particular physical instance is unregistered. ";

%feature("docstring")  Arc::DataPoint::CheckSize "virtual bool
Arc::DataPoint::CheckSize() const

Check if meta-information 'size' is available. ";

%feature("docstring")  Arc::DataPoint::SetSize "virtual void
Arc::DataPoint::SetSize(const unsigned long long int val)

Set value of meta-information 'size'. ";

%feature("docstring")  Arc::DataPoint::GetSize "virtual unsigned long
long int Arc::DataPoint::GetSize() const

Get value of meta-information 'size'. ";

%feature("docstring")  Arc::DataPoint::CheckCheckSum "virtual bool
Arc::DataPoint::CheckCheckSum() const

Check if meta-information 'checksum' is available. ";

%feature("docstring")  Arc::DataPoint::SetCheckSum "virtual void
Arc::DataPoint::SetCheckSum(const std::string &val)

Set value of meta-information 'checksum'. ";

%feature("docstring")  Arc::DataPoint::GetCheckSum "virtual const
std::string& Arc::DataPoint::GetCheckSum() const

Get value of meta-information 'checksum'. ";

%feature("docstring")  Arc::DataPoint::DefaultCheckSum "virtual const
std::string Arc::DataPoint::DefaultCheckSum() const

Default checksum type. ";

%feature("docstring")  Arc::DataPoint::CheckCreated "virtual bool
Arc::DataPoint::CheckCreated() const

Check if meta-information 'creation/modification time' is available.
";

%feature("docstring")  Arc::DataPoint::SetCreated "virtual void
Arc::DataPoint::SetCreated(const Time &val)

Set value of meta-information 'creation/modification time'. ";

%feature("docstring")  Arc::DataPoint::GetCreated "virtual const
Time& Arc::DataPoint::GetCreated() const

Get value of meta-information 'creation/modification time'. ";

%feature("docstring")  Arc::DataPoint::CheckValid "virtual bool
Arc::DataPoint::CheckValid() const

Check if meta-information 'validity time' is available. ";

%feature("docstring")  Arc::DataPoint::SetValid "virtual void
Arc::DataPoint::SetValid(const Time &val)

Set value of meta-information 'validity time'. ";

%feature("docstring")  Arc::DataPoint::GetValid "virtual const Time&
Arc::DataPoint::GetValid() const

Get value of meta-information 'validity time'. ";

%feature("docstring")  Arc::DataPoint::SetAccessLatency "virtual void
Arc::DataPoint::SetAccessLatency(const DataPointAccessLatency
&latency)

Set value of meta-information 'access latency'. ";

%feature("docstring")  Arc::DataPoint::GetAccessLatency "virtual
DataPointAccessLatency Arc::DataPoint::GetAccessLatency() const

Get value of meta-information 'access latency'. ";

%feature("docstring")  Arc::DataPoint::BufSize "virtual long long int
Arc::DataPoint::BufSize() const =0

Get suggested buffer size for transfers. ";

%feature("docstring")  Arc::DataPoint::BufNum "virtual int
Arc::DataPoint::BufNum() const =0

Get suggested number of buffers for transfers. ";

%feature("docstring")  Arc::DataPoint::Cache "virtual bool
Arc::DataPoint::Cache() const

Returns true if file is cacheable. ";

%feature("docstring")  Arc::DataPoint::Local "virtual bool
Arc::DataPoint::Local() const =0

Returns true if file is local, e.g.file:// urls. ";

%feature("docstring")  Arc::DataPoint::ReadOnly "virtual bool
Arc::DataPoint::ReadOnly() const =0 ";

%feature("docstring")  Arc::DataPoint::GetTries "virtual int
Arc::DataPoint::GetTries() const

Returns number of retries left. ";

%feature("docstring")  Arc::DataPoint::SetTries "virtual void
Arc::DataPoint::SetTries(const int n)

Set number of retries. ";

%feature("docstring")  Arc::DataPoint::NextTry "virtual void
Arc::DataPoint::NextTry(void)

Decrease number of retries left. ";

%feature("docstring")  Arc::DataPoint::IsIndex "virtual bool
Arc::DataPoint::IsIndex() const =0

Check if URL is an Indexing Service. ";

%feature("docstring")  Arc::DataPoint::IsStageable "virtual bool
Arc::DataPoint::IsStageable() const

If URL should be staged or queried for Transport URL (TURL) ";

%feature("docstring")  Arc::DataPoint::AcceptsMeta "virtual bool
Arc::DataPoint::AcceptsMeta()=0

If endpoint can have any use from meta information. ";

%feature("docstring")  Arc::DataPoint::ProvidesMeta "virtual bool
Arc::DataPoint::ProvidesMeta()=0

If endpoint can provide at least some meta information directly. ";

%feature("docstring")  Arc::DataPoint::SetMeta "virtual void
Arc::DataPoint::SetMeta(const DataPoint &p)

Copy meta information from another object.

Already defined values are not overwritten.

Parameters:
-----------

p:  object from which information is taken. ";

%feature("docstring")  Arc::DataPoint::CompareMeta "virtual bool
Arc::DataPoint::CompareMeta(const DataPoint &p) const

Compare meta information from another object.

Undefined values are not used for comparison.

Parameters:
-----------

p:  object to which to compare. ";

%feature("docstring")  Arc::DataPoint::TransferLocations "virtual
std::vector<URL> Arc::DataPoint::TransferLocations() const

Returns physical file(s) to read/write, if different from
CurrentLocation()

To be used with protocols which re-direct to different URLs such as
Transport URLs (TURLs). The list is initially filled by PrepareReading
and PrepareWriting. If this list is non-empty then real transfer
should use a URL from this list. It is up to the caller to choose the
best URL and instantiate new DataPoint for handling it. For
consistency protocols which do not require redirections return
original URL. For protocols which need redirection calling
StartReading and StartWriting will use first URL in the list. ";

%feature("docstring")  Arc::DataPoint::CurrentLocation "virtual const
URL& Arc::DataPoint::CurrentLocation() const =0

Returns current (resolved) URL. ";

%feature("docstring")  Arc::DataPoint::CurrentLocationMetadata "virtual const std::string& Arc::DataPoint::CurrentLocationMetadata()
const =0

Returns meta information used to create current URL.

Usage differs between different indexing services. ";

%feature("docstring")  Arc::DataPoint::CompareLocationMetadata "virtual DataStatus Arc::DataPoint::CompareLocationMetadata() const =0

Compare metadata of DataPoint and current location.

Returns inconsistency error or error encountered during operation, or
success ";

%feature("docstring")  Arc::DataPoint::NextLocation "virtual bool
Arc::DataPoint::NextLocation()=0

Switch to next location in list of URLs.

At last location switch to first if number of allowed retries is not
exceeded. Returns false if no retries left. ";

%feature("docstring")  Arc::DataPoint::LocationValid "virtual bool
Arc::DataPoint::LocationValid() const =0

Returns false if out of retries. ";

%feature("docstring")  Arc::DataPoint::LastLocation "virtual bool
Arc::DataPoint::LastLocation()=0

Returns true if the current location is the last. ";

%feature("docstring")  Arc::DataPoint::HaveLocations "virtual bool
Arc::DataPoint::HaveLocations() const =0

Returns true if number of resolved URLs is not 0. ";

%feature("docstring")  Arc::DataPoint::AddLocation "virtual
DataStatus Arc::DataPoint::AddLocation(const URL &url, const
std::string &meta)=0

Add URL to list.

Parameters:
-----------

url:  Location URL to add.

meta:  Location meta information. ";

%feature("docstring")  Arc::DataPoint::RemoveLocation "virtual
DataStatus Arc::DataPoint::RemoveLocation()=0

Remove current URL from list. ";

%feature("docstring")  Arc::DataPoint::RemoveLocations "virtual
DataStatus Arc::DataPoint::RemoveLocations(const DataPoint &p)=0

Remove locations present in another DataPoint object. ";

%feature("docstring")  Arc::DataPoint::AddCheckSumObject "virtual int
Arc::DataPoint::AddCheckSumObject(CheckSum *cksum)=0

Add a checksum object which will compute checksum during transmission.

Parameters:
-----------

cksum:  object which will compute checksum. Should not be destroyed
till DataPointer itself.

integer position in the list of checksum objects. ";

%feature("docstring")  Arc::DataPoint::GetCheckSumObject "virtual
const CheckSum* Arc::DataPoint::GetCheckSumObject(int index) const =0
";

%feature("docstring")  Arc::DataPoint::SortLocations "virtual void
Arc::DataPoint::SortLocations(const std::string &pattern, const URLMap
&url_map)=0

Sort locations according to the specified pattern.

Parameters:
-----------

pattern:  a set of strings, separated by |, to match against. ";


// File: classArc_1_1DataPointDirect.xml
%feature("docstring") Arc::DataPointDirect "

This is a kind of generalized file handle.

Differently from file handle it does not support operations read() and
write(). Instead it initiates operation and uses object of class
DataBuffer to pass actual data. It also provides other operations like
querying parameters of remote object. It is used by higher-level
classes DataMove and DataMovePar to provide data transfer service for
application.

C++ includes: DataPointDirect.h ";

%feature("docstring")  Arc::DataPointDirect::DataPointDirect "Arc::DataPointDirect::DataPointDirect(const URL &url, const UserConfig
&usercfg) ";

%feature("docstring")  Arc::DataPointDirect::~DataPointDirect "virtual Arc::DataPointDirect::~DataPointDirect() ";

%feature("docstring")  Arc::DataPointDirect::IsIndex "virtual bool
Arc::DataPointDirect::IsIndex() const

Check if URL is an Indexing Service. ";

%feature("docstring")  Arc::DataPointDirect::IsStageable "virtual
bool Arc::DataPointDirect::IsStageable() const

If URL should be staged or queried for Transport URL (TURL) ";

%feature("docstring")  Arc::DataPointDirect::BufSize "virtual long
long int Arc::DataPointDirect::BufSize() const

Get suggested buffer size for transfers. ";

%feature("docstring")  Arc::DataPointDirect::BufNum "virtual int
Arc::DataPointDirect::BufNum() const

Get suggested number of buffers for transfers. ";

%feature("docstring")  Arc::DataPointDirect::Local "virtual bool
Arc::DataPointDirect::Local() const

Returns true if file is local, e.g.file:// urls. ";

%feature("docstring")  Arc::DataPointDirect::ReadOnly "virtual bool
Arc::DataPointDirect::ReadOnly() const ";

%feature("docstring")  Arc::DataPointDirect::ReadOutOfOrder "virtual
void Arc::DataPointDirect::ReadOutOfOrder(bool v)

Allow/disallow DataPoint to produce scattered data during reading*
operation.

Parameters:
-----------

v:  true if allowed (default is false). ";

%feature("docstring")  Arc::DataPointDirect::WriteOutOfOrder "virtual
bool Arc::DataPointDirect::WriteOutOfOrder()

Returns true if URL can accept scattered data for *writing* operation.
";

%feature("docstring")  Arc::DataPointDirect::SetAdditionalChecks "virtual void Arc::DataPointDirect::SetAdditionalChecks(bool v)

Allow/disallow additional checks.

Check for existence of remote file (and probably other checks too)
before initiating reading and writing operations.

Parameters:
-----------

v:  true if allowed (default is true). ";

%feature("docstring")  Arc::DataPointDirect::GetAdditionalChecks "virtual bool Arc::DataPointDirect::GetAdditionalChecks() const

Check if additional checks before will be performed. ";

%feature("docstring")  Arc::DataPointDirect::SetSecure "virtual void
Arc::DataPointDirect::SetSecure(bool v)

Allow/disallow heavy security during data transfer.

Parameters:
-----------

v:  true if allowed (default depends on protocol). ";

%feature("docstring")  Arc::DataPointDirect::GetSecure "virtual bool
Arc::DataPointDirect::GetSecure() const

Check if heavy security during data transfer is allowed. ";

%feature("docstring")  Arc::DataPointDirect::Passive "virtual void
Arc::DataPointDirect::Passive(bool v)

Request passive transfers for FTP-like protocols.

Parameters:
-----------

true:  to request. ";

%feature("docstring")  Arc::DataPointDirect::Range "virtual void
Arc::DataPointDirect::Range(unsigned long long int start=0, unsigned
long long int end=0)

Set range of bytes to retrieve.

Default values correspond to whole file. ";

%feature("docstring")  Arc::DataPointDirect::AddCheckSumObject "virtual int Arc::DataPointDirect::AddCheckSumObject(CheckSum *cksum)

Add a checksum object which will compute checksum during transmission.

Parameters:
-----------

cksum:  object which will compute checksum. Should not be destroyed
till DataPointer itself.

integer position in the list of checksum objects. ";

%feature("docstring")  Arc::DataPointDirect::GetCheckSumObject "virtual const CheckSum* Arc::DataPointDirect::GetCheckSumObject(int
index) const ";

%feature("docstring")  Arc::DataPointDirect::Resolve "virtual
DataStatus Arc::DataPointDirect::Resolve(bool source)

Resolves index service URL into list of ordinary URLs.

Also obtains meta information about the file.

Parameters:
-----------

source:  true if DataPoint object represents source of information. ";

%feature("docstring")  Arc::DataPointDirect::Registered "virtual bool
Arc::DataPointDirect::Registered() const

Check if file is registered in Indexing Service.

Proper value is obtainable only after Resolve. ";

%feature("docstring")  Arc::DataPointDirect::PreRegister "virtual
DataStatus Arc::DataPointDirect::PreRegister(bool replication, bool
force=false)

Index service preregistration.

This function registers the physical location of a file into an
indexing service. It should be called *before* the actual transfer to
that location happens.

Parameters:
-----------

replication:  if true, the file is being replicated between two
locations registered in the indexing service under same name.

force:  if true, perform registration of a new file even if it already
exists. Should be used to fix failures in Indexing Service. ";

%feature("docstring")  Arc::DataPointDirect::PostRegister "virtual
DataStatus Arc::DataPointDirect::PostRegister(bool replication)

Index Service postregistration.

Used for same purpose as PreRegister. Should be called after actual
transfer of file successfully finished.

Parameters:
-----------

replication:  if true, the file is being replicated between two
locations registered in Indexing Service under same name. ";

%feature("docstring")  Arc::DataPointDirect::PreUnregister "virtual
DataStatus Arc::DataPointDirect::PreUnregister(bool replication)

Index Service preunregistration.

Should be called if file transfer failed. It removes changes made by
PreRegister.

Parameters:
-----------

replication:  if true, the file is being replicated between two
locations registered in Indexing Service under same name. ";

%feature("docstring")  Arc::DataPointDirect::Unregister "virtual
DataStatus Arc::DataPointDirect::Unregister(bool all)

Index Service unregistration.

Remove information about file registered in Indexing Service.

Parameters:
-----------

all:  if true, information about file itself is (LFN) is removed.
Otherwise only particular physical instance is unregistered. ";

%feature("docstring")  Arc::DataPointDirect::AcceptsMeta "virtual
bool Arc::DataPointDirect::AcceptsMeta()

If endpoint can have any use from meta information. ";

%feature("docstring")  Arc::DataPointDirect::ProvidesMeta "virtual
bool Arc::DataPointDirect::ProvidesMeta()

If endpoint can provide at least some meta information directly. ";

%feature("docstring")  Arc::DataPointDirect::CurrentLocation "virtual
const URL& Arc::DataPointDirect::CurrentLocation() const

Returns current (resolved) URL. ";

%feature("docstring")  Arc::DataPointDirect::CurrentLocationMetadata "virtual const std::string&
Arc::DataPointDirect::CurrentLocationMetadata() const

Returns meta information used to create current URL.

Usage differs between different indexing services. ";

%feature("docstring")  Arc::DataPointDirect::CompareLocationMetadata "virtual DataStatus Arc::DataPointDirect::CompareLocationMetadata()
const

Compare metadata of DataPoint and current location.

Returns inconsistency error or error encountered during operation, or
success ";

%feature("docstring")  Arc::DataPointDirect::NextLocation "virtual
bool Arc::DataPointDirect::NextLocation()

Switch to next location in list of URLs.

At last location switch to first if number of allowed retries is not
exceeded. Returns false if no retries left. ";

%feature("docstring")  Arc::DataPointDirect::LocationValid "virtual
bool Arc::DataPointDirect::LocationValid() const

Returns false if out of retries. ";

%feature("docstring")  Arc::DataPointDirect::HaveLocations "virtual
bool Arc::DataPointDirect::HaveLocations() const

Returns true if number of resolved URLs is not 0. ";

%feature("docstring")  Arc::DataPointDirect::LastLocation "virtual
bool Arc::DataPointDirect::LastLocation()

Returns true if the current location is the last. ";

%feature("docstring")  Arc::DataPointDirect::AddLocation "virtual
DataStatus Arc::DataPointDirect::AddLocation(const URL &url, const
std::string &meta)

Add URL to list.

Parameters:
-----------

url:  Location URL to add.

meta:  Location meta information. ";

%feature("docstring")  Arc::DataPointDirect::RemoveLocation "virtual
DataStatus Arc::DataPointDirect::RemoveLocation()

Remove current URL from list. ";

%feature("docstring")  Arc::DataPointDirect::RemoveLocations "virtual
DataStatus Arc::DataPointDirect::RemoveLocations(const DataPoint &p)

Remove locations present in another DataPoint object. ";

%feature("docstring")  Arc::DataPointDirect::SortLocations "virtual
void Arc::DataPointDirect::SortLocations(const std::string &, const
URLMap &)

Sort locations according to the specified pattern.

Parameters:
-----------

pattern:  a set of strings, separated by |, to match against. ";


// File: classArc_1_1DataPointIndex.xml
%feature("docstring") Arc::DataPointIndex "

Complements DataPoint with attributes common for Indexing Service
URLs.

It should never be used directly. Instead inherit from it to provide a
class for specific a Indexing Service.

C++ includes: DataPointIndex.h ";

%feature("docstring")  Arc::DataPointIndex::DataPointIndex "Arc::DataPointIndex::DataPointIndex(const URL &url, const UserConfig
&usercfg) ";

%feature("docstring")  Arc::DataPointIndex::~DataPointIndex "virtual
Arc::DataPointIndex::~DataPointIndex() ";

%feature("docstring")  Arc::DataPointIndex::CurrentLocation "virtual
const URL& Arc::DataPointIndex::CurrentLocation() const

Returns current (resolved) URL. ";

%feature("docstring")  Arc::DataPointIndex::CurrentLocationMetadata "virtual const std::string&
Arc::DataPointIndex::CurrentLocationMetadata() const

Returns meta information used to create current URL.

Usage differs between different indexing services. ";

%feature("docstring")  Arc::DataPointIndex::CompareLocationMetadata "virtual DataStatus Arc::DataPointIndex::CompareLocationMetadata()
const

Compare metadata of DataPoint and current location.

Returns inconsistency error or error encountered during operation, or
success ";

%feature("docstring")  Arc::DataPointIndex::NextLocation "virtual
bool Arc::DataPointIndex::NextLocation()

Switch to next location in list of URLs.

At last location switch to first if number of allowed retries is not
exceeded. Returns false if no retries left. ";

%feature("docstring")  Arc::DataPointIndex::LocationValid "virtual
bool Arc::DataPointIndex::LocationValid() const

Returns false if out of retries. ";

%feature("docstring")  Arc::DataPointIndex::HaveLocations "virtual
bool Arc::DataPointIndex::HaveLocations() const

Returns true if number of resolved URLs is not 0. ";

%feature("docstring")  Arc::DataPointIndex::LastLocation "virtual
bool Arc::DataPointIndex::LastLocation()

Returns true if the current location is the last. ";

%feature("docstring")  Arc::DataPointIndex::RemoveLocation "virtual
DataStatus Arc::DataPointIndex::RemoveLocation()

Remove current URL from list. ";

%feature("docstring")  Arc::DataPointIndex::RemoveLocations "virtual
DataStatus Arc::DataPointIndex::RemoveLocations(const DataPoint &p)

Remove locations present in another DataPoint object. ";

%feature("docstring")  Arc::DataPointIndex::AddLocation "virtual
DataStatus Arc::DataPointIndex::AddLocation(const URL &url, const
std::string &meta)

Add URL to list.

Parameters:
-----------

url:  Location URL to add.

meta:  Location meta information. ";

%feature("docstring")  Arc::DataPointIndex::SortLocations "virtual
void Arc::DataPointIndex::SortLocations(const std::string &pattern,
const URLMap &url_map)

Sort locations according to the specified pattern.

Parameters:
-----------

pattern:  a set of strings, separated by |, to match against. ";

%feature("docstring")  Arc::DataPointIndex::IsIndex "virtual bool
Arc::DataPointIndex::IsIndex() const

Check if URL is an Indexing Service. ";

%feature("docstring")  Arc::DataPointIndex::IsStageable "virtual bool
Arc::DataPointIndex::IsStageable() const

If URL should be staged or queried for Transport URL (TURL) ";

%feature("docstring")  Arc::DataPointIndex::AcceptsMeta "virtual bool
Arc::DataPointIndex::AcceptsMeta()

If endpoint can have any use from meta information. ";

%feature("docstring")  Arc::DataPointIndex::ProvidesMeta "virtual
bool Arc::DataPointIndex::ProvidesMeta()

If endpoint can provide at least some meta information directly. ";

%feature("docstring")  Arc::DataPointIndex::SetMeta "virtual void
Arc::DataPointIndex::SetMeta(const DataPoint &p)

Copy meta information from another object.

Already defined values are not overwritten.

Parameters:
-----------

p:  object from which information is taken. ";

%feature("docstring")  Arc::DataPointIndex::SetCheckSum "virtual void
Arc::DataPointIndex::SetCheckSum(const std::string &val)

Set value of meta-information 'checksum'. ";

%feature("docstring")  Arc::DataPointIndex::SetSize "virtual void
Arc::DataPointIndex::SetSize(const unsigned long long int val)

Set value of meta-information 'size'. ";

%feature("docstring")  Arc::DataPointIndex::Registered "virtual bool
Arc::DataPointIndex::Registered() const

Check if file is registered in Indexing Service.

Proper value is obtainable only after Resolve. ";

%feature("docstring")  Arc::DataPointIndex::SetTries "virtual void
Arc::DataPointIndex::SetTries(const int n)

Set number of retries. ";

%feature("docstring")  Arc::DataPointIndex::BufSize "virtual long
long int Arc::DataPointIndex::BufSize() const

Get suggested buffer size for transfers. ";

%feature("docstring")  Arc::DataPointIndex::BufNum "virtual int
Arc::DataPointIndex::BufNum() const

Get suggested number of buffers for transfers. ";

%feature("docstring")  Arc::DataPointIndex::Local "virtual bool
Arc::DataPointIndex::Local() const

Returns true if file is local, e.g.file:// urls. ";

%feature("docstring")  Arc::DataPointIndex::ReadOnly "virtual bool
Arc::DataPointIndex::ReadOnly() const ";

%feature("docstring")  Arc::DataPointIndex::PrepareReading "virtual
DataStatus Arc::DataPointIndex::PrepareReading(unsigned int timeout,
unsigned int &wait_time)

Prepare DataPoint for reading.

This method should be implemented by protocols which require
preparation or staging of physical files for reading. It can act
synchronously or asynchronously (if protocol supports it). In the
first case the method will block until the file is prepared or the
specified timeout has passed. In the second case the method can return
with a ReadPrepareWait status before the file is prepared. The caller
should then wait some time (a hint from the remote service may be
given in wait_time) and call PrepareReading() again to poll for the
preparation status, until the file is prepared. In this case it is
also up to the caller to decide when the request has taken too long
and if so cancel it by calling FinishReading(). When file preparation
has finished, the physical file(s) to read from can be found from
TransferLocations().

Parameters:
-----------

timeout:  If non-zero, this method will block until either the file
has been prepared successfully or the timeout has passed. A zero value
means that the caller would like to call and poll for status.

wait_time:  If timeout is zero (caller would like asynchronous
operation) and ReadPrepareWait is returned, a hint for how long to
wait before a subsequent call may be given in wait_time. ";

%feature("docstring")  Arc::DataPointIndex::PrepareWriting "virtual
DataStatus Arc::DataPointIndex::PrepareWriting(unsigned int timeout,
unsigned int &wait_time)

Prepare DataPoint for writing.

This method should be implemented by protocols which require
preparation of physical files for writing. It can act synchronously or
asynchronously (if protocol supports it). In the first case the method
will block until the file is prepared or the specified timeout has
passed. In the second case the method can return with a
WritePrepareWait status before the file is prepared. The caller should
then wait some time (a hint from the remote service may be given in
wait_time) and call PrepareWriting() again to poll for the preparation
status, until the file is prepared. In this case it is also up to the
caller to decide when the request has taken too long and if so cancel
or abort it by calling FinishWriting(true). When file preparation has
finished, the physical file(s) to write to can be found from
TransferLocations().

Parameters:
-----------

timeout:  If non-zero, this method will block until either the file
has been prepared successfully or the timeout has passed. A zero value
means that the caller would like to call and poll for status.

wait_time:  If timeout is zero (caller would like asynchronous
operation) and WritePrepareWait is returned, a hint for how long to
wait before a subsequent call may be given in wait_time. ";

%feature("docstring")  Arc::DataPointIndex::StartReading "virtual
DataStatus Arc::DataPointIndex::StartReading(DataBuffer &buffer)

Start reading data from URL.

Separate thread to transfer data will be created. No other operation
can be performed while reading is in progress.

Parameters:
-----------

buffer:  operation will use this buffer to put information into.
Should not be destroyed before StopReading() was called and returned.
";

%feature("docstring")  Arc::DataPointIndex::StartWriting "virtual
DataStatus Arc::DataPointIndex::StartWriting(DataBuffer &buffer,
DataCallback *space_cb=NULL)

Start writing data to URL.

Separate thread to transfer data will be created. No other operation
can be performed while writing is in progress.

Parameters:
-----------

buffer:  operation will use this buffer to get information from.
Should not be destroyed before stop_writing was called and returned.

space_cb:  callback which is called if there is not enough space to
store data. May not implemented for all protocols. ";

%feature("docstring")  Arc::DataPointIndex::StopReading "virtual
DataStatus Arc::DataPointIndex::StopReading()

Stop reading.

Must be called after corresponding start_reading method, either after
all data is transferred or to cancel transfer. Use buffer object to
find out when data is transferred. Must return failure if any happened
during transfer. ";

%feature("docstring")  Arc::DataPointIndex::StopWriting "virtual
DataStatus Arc::DataPointIndex::StopWriting()

Stop writing.

Must be called after corresponding start_writing method, either after
all data is transferred or to cancel transfer. Use buffer object to
find out when data is transferred. Must return failure if any happened
during transfer. ";

%feature("docstring")  Arc::DataPointIndex::FinishReading "virtual
DataStatus Arc::DataPointIndex::FinishReading(bool error=false)

Finish reading from the URL.

Must be called after transfer of physical file has completed and if
PrepareReading() was called, to free resources, release requests that
were made during preparation etc.

Parameters:
-----------

error:  If true then action is taken depending on the error. ";

%feature("docstring")  Arc::DataPointIndex::FinishWriting "virtual
DataStatus Arc::DataPointIndex::FinishWriting(bool error=false)

Finish writing to the URL.

Must be called after transfer of physical file has completed and if
PrepareWriting() was called, to free resources, release requests that
were made during preparation etc.

Parameters:
-----------

error:  If true then action is taken depending on the error. ";

%feature("docstring")  Arc::DataPointIndex::TransferLocations "virtual std::vector<URL> Arc::DataPointIndex::TransferLocations()
const

Returns physical file(s) to read/write, if different from
CurrentLocation()

To be used with protocols which re-direct to different URLs such as
Transport URLs (TURLs). The list is initially filled by PrepareReading
and PrepareWriting. If this list is non-empty then real transfer
should use a URL from this list. It is up to the caller to choose the
best URL and instantiate new DataPoint for handling it. For
consistency protocols which do not require redirections return
original URL. For protocols which need redirection calling
StartReading and StartWriting will use first URL in the list. ";

%feature("docstring")  Arc::DataPointIndex::Check "virtual DataStatus
Arc::DataPointIndex::Check()

Query the DataPoint to check if object is accessible.

If possible this method will also try to provide meta information
about the object. It returns positive response if object's content can
be retrieved. ";

%feature("docstring")  Arc::DataPointIndex::Remove "virtual
DataStatus Arc::DataPointIndex::Remove()

Remove/delete object at URL. ";

%feature("docstring")  Arc::DataPointIndex::ReadOutOfOrder "virtual
void Arc::DataPointIndex::ReadOutOfOrder(bool v)

Allow/disallow DataPoint to produce scattered data during reading*
operation.

Parameters:
-----------

v:  true if allowed (default is false). ";

%feature("docstring")  Arc::DataPointIndex::WriteOutOfOrder "virtual
bool Arc::DataPointIndex::WriteOutOfOrder()

Returns true if URL can accept scattered data for *writing* operation.
";

%feature("docstring")  Arc::DataPointIndex::SetAdditionalChecks "virtual void Arc::DataPointIndex::SetAdditionalChecks(bool v)

Allow/disallow additional checks.

Check for existence of remote file (and probably other checks too)
before initiating reading and writing operations.

Parameters:
-----------

v:  true if allowed (default is true). ";

%feature("docstring")  Arc::DataPointIndex::GetAdditionalChecks "virtual bool Arc::DataPointIndex::GetAdditionalChecks() const

Check if additional checks before will be performed. ";

%feature("docstring")  Arc::DataPointIndex::SetSecure "virtual void
Arc::DataPointIndex::SetSecure(bool v)

Allow/disallow heavy security during data transfer.

Parameters:
-----------

v:  true if allowed (default depends on protocol). ";

%feature("docstring")  Arc::DataPointIndex::GetSecure "virtual bool
Arc::DataPointIndex::GetSecure() const

Check if heavy security during data transfer is allowed. ";

%feature("docstring")  Arc::DataPointIndex::GetAccessLatency "virtual
DataPointAccessLatency Arc::DataPointIndex::GetAccessLatency() const

Get value of meta-information 'access latency'. ";

%feature("docstring")  Arc::DataPointIndex::Passive "virtual void
Arc::DataPointIndex::Passive(bool v)

Request passive transfers for FTP-like protocols.

Parameters:
-----------

true:  to request. ";

%feature("docstring")  Arc::DataPointIndex::Range "virtual void
Arc::DataPointIndex::Range(unsigned long long int start=0, unsigned
long long int end=0)

Set range of bytes to retrieve.

Default values correspond to whole file. ";

%feature("docstring")  Arc::DataPointIndex::AddCheckSumObject "virtual int Arc::DataPointIndex::AddCheckSumObject(CheckSum *cksum)

Add a checksum object which will compute checksum during transmission.

Parameters:
-----------

cksum:  object which will compute checksum. Should not be destroyed
till DataPointer itself.

integer position in the list of checksum objects. ";

%feature("docstring")  Arc::DataPointIndex::GetCheckSumObject "virtual const CheckSum* Arc::DataPointIndex::GetCheckSumObject(int
index) const ";


// File: classArc_1_1DataPointLoader.xml
%feature("docstring") Arc::DataPointLoader "";


// File: classArc_1_1DataPointPluginArgument.xml
%feature("docstring") Arc::DataPointPluginArgument "";

%feature("docstring")
Arc::DataPointPluginArgument::DataPointPluginArgument "Arc::DataPointPluginArgument::DataPointPluginArgument(const URL &url,
const UserConfig &usercfg) ";

%feature("docstring")
Arc::DataPointPluginArgument::~DataPointPluginArgument "Arc::DataPointPluginArgument::~DataPointPluginArgument() ";


// File: classArc_1_1DataSpeed.xml
%feature("docstring") Arc::DataSpeed "

Keeps track of average and instantaneous transfer speed.

Also detects data transfer inactivity and other transfer timeouts.

C++ includes: DataSpeed.h ";

%feature("docstring")  Arc::DataSpeed::DataSpeed "Arc::DataSpeed::DataSpeed(time_t base=DATASPEED_AVERAGING_PERIOD)

Constructor

Parameters:
-----------

base:  time period used to average values (default 1 minute). ";

%feature("docstring")  Arc::DataSpeed::DataSpeed "Arc::DataSpeed::DataSpeed(unsigned long long int min_speed, time_t
min_speed_time, unsigned long long int min_average_speed, time_t
max_inactivity_time, time_t base=DATASPEED_AVERAGING_PERIOD)

Constructor

Parameters:
-----------

base:  time period used to average values (default 1 minute).

min_speed:  minimal allowed speed (Butes per second). If speed drops
and holds below threshold for min_speed_time_ seconds error is
triggered.

min_speed_time:

min_average_speed_:  minimal average speed (Bytes per second) to
trigger error. Averaged over whole current transfer time.

max_inactivity_time:  - if no data is passing for specified amount of
time (seconds), error is triggered. ";

%feature("docstring")  Arc::DataSpeed::~DataSpeed "Arc::DataSpeed::~DataSpeed(void)

Destructor. ";

%feature("docstring")  Arc::DataSpeed::verbose "void
Arc::DataSpeed::verbose(bool val)

Activate printing information about current time speeds, amount of
transferred data. ";

%feature("docstring")  Arc::DataSpeed::verbose "void
Arc::DataSpeed::verbose(const std::string &prefix)

Print information about current speed and amout of data.

Parameters:
-----------

'prefix':  add this string at the beginning of every string. ";

%feature("docstring")  Arc::DataSpeed::verbose "bool
Arc::DataSpeed::verbose(void)

Check if speed information is going to be printed. ";

%feature("docstring")  Arc::DataSpeed::set_min_speed "void
Arc::DataSpeed::set_min_speed(unsigned long long int min_speed, time_t
min_speed_time)

Set minimal allowed speed.

Parameters:
-----------

min_speed:  minimal allowed speed (Butes per second). If speed drops
and holds below threshold for min_speed_time_ seconds error is
triggered.

min_speed_time:  ";

%feature("docstring")  Arc::DataSpeed::set_min_average_speed "void
Arc::DataSpeed::set_min_average_speed(unsigned long long int
min_average_speed)

Set minmal avaerage speed.

Parameters:
-----------

min_average_speed_:  minimal average speed (Bytes per second) to
trigger error. Averaged over whole current transfer time. ";

%feature("docstring")  Arc::DataSpeed::set_max_inactivity_time "void
Arc::DataSpeed::set_max_inactivity_time(time_t max_inactivity_time)

Set inactivity tiemout.

Parameters:
-----------

max_inactivity_time:  - if no data is passing for specified amount of
time (seconds), error is triggered. ";

%feature("docstring")  Arc::DataSpeed::get_max_inactivity_time "time_t Arc::DataSpeed::get_max_inactivity_time()

Get inactivity timeout. ";

%feature("docstring")  Arc::DataSpeed::set_base "void
Arc::DataSpeed::set_base(time_t base_=DATASPEED_AVERAGING_PERIOD)

Set averaging time period.

Parameters:
-----------

base:  time period used to average values (default 1 minute). ";

%feature("docstring")  Arc::DataSpeed::set_max_data "void
Arc::DataSpeed::set_max_data(unsigned long long int max=0)

Set amount of data to be transferred. Used in verbose messages.

Parameters:
-----------

max:  amount of data in bytes. ";

%feature("docstring")  Arc::DataSpeed::set_progress_indicator "void
Arc::DataSpeed::set_progress_indicator(show_progress_t func=NULL)

Specify which external function will print verbose messages. If not
specified internal one is used.

Parameters:
-----------

pointer:  to function which prints information. ";

%feature("docstring")  Arc::DataSpeed::reset "void
Arc::DataSpeed::reset(void)

Reset all counters and triggers. ";

%feature("docstring")  Arc::DataSpeed::transfer "bool
Arc::DataSpeed::transfer(unsigned long long int n=0)

Inform object, about amount of data has been transferred. All errors
are triggered by this method. To make them work application must call
this method periodically even with zero value.

Parameters:
-----------

n:  amount of data transferred (bytes). ";

%feature("docstring")  Arc::DataSpeed::hold "void
Arc::DataSpeed::hold(bool disable)

Turn off speed control.

Parameters:
-----------

disable:  true to turn off. ";

%feature("docstring")  Arc::DataSpeed::min_speed_failure "bool
Arc::DataSpeed::min_speed_failure()

Check if minimal speed error was triggered. ";

%feature("docstring")  Arc::DataSpeed::min_average_speed_failure "bool Arc::DataSpeed::min_average_speed_failure()

Check if minimal average speed error was triggered. ";

%feature("docstring")  Arc::DataSpeed::max_inactivity_time_failure "bool Arc::DataSpeed::max_inactivity_time_failure()

Check if maximal inactivity time error was triggered. ";

%feature("docstring")  Arc::DataSpeed::transferred_size "unsigned
long long int Arc::DataSpeed::transferred_size(void)

Returns amount of data this object knows about. ";


// File: classArc_1_1DataStatus.xml
%feature("docstring") Arc::DataStatus "

A class to be used for return types of all major data handling
methods. It describes the outcome of the method.

C++ includes: DataStatus.h ";

%feature("docstring")  Arc::DataStatus::DataStatus "Arc::DataStatus::DataStatus(const DataStatusType &status, std::string
desc=\"\") ";

%feature("docstring")  Arc::DataStatus::DataStatus "Arc::DataStatus::DataStatus() ";

%feature("docstring")  Arc::DataStatus::~DataStatus "Arc::DataStatus::~DataStatus() ";

%feature("docstring")  Arc::DataStatus::Passed "bool
Arc::DataStatus::Passed(void) ";

%feature("docstring")  Arc::DataStatus::Retryable "bool
Arc::DataStatus::Retryable() ";

%feature("docstring")  Arc::DataStatus::SetDesc "void
Arc::DataStatus::SetDesc(std::string d) ";

%feature("docstring")  Arc::DataStatus::GetDesc "std::string
Arc::DataStatus::GetDesc() ";


// File: classArcSec_1_1DateAttribute.xml
%feature("docstring") ArcSec::DateAttribute "";

%feature("docstring")  ArcSec::DateAttribute::DateAttribute "ArcSec::DateAttribute::DateAttribute() ";

%feature("docstring")  ArcSec::DateAttribute::DateAttribute "ArcSec::DateAttribute::DateAttribute(const std::string &v, const
std::string &i) ";

%feature("docstring")  ArcSec::DateAttribute::~DateAttribute "virtual
ArcSec::DateAttribute::~DateAttribute() ";

%feature("docstring")  ArcSec::DateAttribute::equal "virtual bool
ArcSec::DateAttribute::equal(AttributeValue *other, bool
check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::DateAttribute::lessthan "virtual bool
ArcSec::DateAttribute::lessthan(AttributeValue *other) ";

%feature("docstring")  ArcSec::DateAttribute::encode "virtual
std::string ArcSec::DateAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::DateAttribute::getValue "Arc::Time
ArcSec::DateAttribute::getValue() ";

%feature("docstring")  ArcSec::DateAttribute::getType "virtual
std::string ArcSec::DateAttribute::getType()

Get the DataType of the <Attribute> ";

%feature("docstring")  ArcSec::DateAttribute::getId "virtual
std::string ArcSec::DateAttribute::getId()

Get the AttributeId of the <Attribute> ";


// File: classArcSec_1_1DateTimeAttribute.xml
%feature("docstring") ArcSec::DateTimeAttribute "

Format: YYYYMMDDHHMMSSZ Day Month DD HH:MM:SS YYYY YYYY-MM-DD HH:MM:SS
YYYY-MM-DDTHH:MM:SS+HH:MM YYYY-MM-DDTHH:MM:SSZ

C++ includes: DateTimeAttribute.h ";

%feature("docstring")  ArcSec::DateTimeAttribute::DateTimeAttribute "ArcSec::DateTimeAttribute::DateTimeAttribute() ";

%feature("docstring")  ArcSec::DateTimeAttribute::DateTimeAttribute "ArcSec::DateTimeAttribute::DateTimeAttribute(const std::string &v,
const std::string &i) ";

%feature("docstring")  ArcSec::DateTimeAttribute::~DateTimeAttribute "virtual ArcSec::DateTimeAttribute::~DateTimeAttribute() ";

%feature("docstring")  ArcSec::DateTimeAttribute::equal "virtual bool
ArcSec::DateTimeAttribute::equal(AttributeValue *other, bool
check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::DateTimeAttribute::lessthan "virtual
bool ArcSec::DateTimeAttribute::lessthan(AttributeValue *other) ";

%feature("docstring")  ArcSec::DateTimeAttribute::inrange "virtual
bool ArcSec::DateTimeAttribute::inrange(AttributeValue *other) ";

%feature("docstring")  ArcSec::DateTimeAttribute::encode "virtual
std::string ArcSec::DateTimeAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::DateTimeAttribute::getValue "Arc::Time
ArcSec::DateTimeAttribute::getValue() ";

%feature("docstring")  ArcSec::DateTimeAttribute::getType "virtual
std::string ArcSec::DateTimeAttribute::getType()

Get the DataType of the <Attribute> ";

%feature("docstring")  ArcSec::DateTimeAttribute::getId "virtual
std::string ArcSec::DateTimeAttribute::getId()

Get the AttributeId of the <Attribute> ";


// File: classArc_1_1DBranch.xml
%feature("docstring") Arc::DBranch "";

%feature("docstring")  Arc::DBranch::DBranch "Arc::DBranch::DBranch(void) ";

%feature("docstring")  Arc::DBranch::~DBranch "Arc::DBranch::~DBranch(void) ";

%feature("docstring")  Arc::DBranch::Add "DBranch&
Arc::DBranch::Add(const std::string &, int pos=-1) ";

%feature("docstring")  Arc::DBranch::Size "int
Arc::DBranch::Size(void) ";

%feature("docstring")  Arc::DBranch::Name "const std::string&
Arc::DBranch::Name(void) ";

%feature("docstring")  Arc::DBranch::Item "DItem&
Arc::DBranch::Item(void) ";

%feature("docstring")  Arc::DBranch::Assign "void
Arc::DBranch::Assign(DItem *) ";


// File: classArc_1_1DelegationConsumer.xml
%feature("docstring") Arc::DelegationConsumer "

A consumer of delegated X509 credentials. During delegation procedure
this class acquires delegated credentials aka proxy - certificate,
private key and chain of previous certificates. Delegation procedure
consists of calling Request() method for generating certificate
request followed by call to Acquire() method for making complete
credentials from certificate chain.

C++ includes: DelegationInterface.h ";

%feature("docstring")  Arc::DelegationConsumer::DelegationConsumer "Arc::DelegationConsumer::DelegationConsumer(void)

Creates object with new private key ";

%feature("docstring")  Arc::DelegationConsumer::DelegationConsumer "Arc::DelegationConsumer::DelegationConsumer(const std::string
&content)

Creates object with provided private key ";

%feature("docstring")  Arc::DelegationConsumer::~DelegationConsumer "Arc::DelegationConsumer::~DelegationConsumer(void) ";

%feature("docstring")  Arc::DelegationConsumer::ID "const
std::string& Arc::DelegationConsumer::ID(void)

Return identifier of this object - not implemented ";

%feature("docstring")  Arc::DelegationConsumer::Backup "bool
Arc::DelegationConsumer::Backup(std::string &content)

Stores content of this object into a string ";

%feature("docstring")  Arc::DelegationConsumer::Restore "bool
Arc::DelegationConsumer::Restore(const std::string &content)

Restores content of object from string ";

%feature("docstring")  Arc::DelegationConsumer::Request "bool
Arc::DelegationConsumer::Request(std::string &content)

Make X509 certificate request from internal private key ";

%feature("docstring")  Arc::DelegationConsumer::Acquire "bool
Arc::DelegationConsumer::Acquire(std::string &content)

Ads private key into certificates chain in 'content' On exit content
contains complete delegated credentials. ";

%feature("docstring")  Arc::DelegationConsumer::Acquire "bool
Arc::DelegationConsumer::Acquire(std::string &content, std::string
&identity)

Includes the functionality in Acquire(content); pluse extracting the
credential identity ";


// File: classArc_1_1DelegationConsumerSOAP.xml
%feature("docstring") Arc::DelegationConsumerSOAP "

This class extends DelegationConsumer to support SOAP message
exchange. Implements WS
interfacehttp://www.nordugrid.org/schemas/delegation described in
delegation.wsdl.

C++ includes: DelegationInterface.h ";

%feature("docstring")
Arc::DelegationConsumerSOAP::DelegationConsumerSOAP "Arc::DelegationConsumerSOAP::DelegationConsumerSOAP(void)

Creates object with new private key ";

%feature("docstring")
Arc::DelegationConsumerSOAP::DelegationConsumerSOAP "Arc::DelegationConsumerSOAP::DelegationConsumerSOAP(const std::string
&content)

Creates object with specified private key ";

%feature("docstring")
Arc::DelegationConsumerSOAP::~DelegationConsumerSOAP "Arc::DelegationConsumerSOAP::~DelegationConsumerSOAP(void) ";

%feature("docstring")
Arc::DelegationConsumerSOAP::DelegateCredentialsInit "bool
Arc::DelegationConsumerSOAP::DelegateCredentialsInit(const std::string
&id, const SOAPEnvelope &in, SOAPEnvelope &out)

Process SOAP message which starts delagation. Generated message in
'out' is meant to be sent back to DelagationProviderSOAP. Argument
'id' contains identifier of procedure and is used only to produce SOAP
message. ";

%feature("docstring")  Arc::DelegationConsumerSOAP::UpdateCredentials
"bool Arc::DelegationConsumerSOAP::UpdateCredentials(std::string
&credentials, const SOAPEnvelope &in, SOAPEnvelope &out)

Accepts delegated credentials. Process 'in' SOAP message and stores
full proxy credentials in 'credentials'. 'out' message is generated
for sending to DelagationProviderSOAP. ";

%feature("docstring")  Arc::DelegationConsumerSOAP::UpdateCredentials
"bool Arc::DelegationConsumerSOAP::UpdateCredentials(std::string
&credentials, std::string &identity, const SOAPEnvelope &in,
SOAPEnvelope &out)

Includes the functionality in above UpdateCredentials method; plus
extracting the credential identity ";

%feature("docstring")  Arc::DelegationConsumerSOAP::DelegatedToken "bool Arc::DelegationConsumerSOAP::DelegatedToken(std::string
&credentials, XMLNode token)

Similar to UpdateCredentials but takes only DelegatedToken XML element
";

%feature("docstring")  Arc::DelegationConsumerSOAP::DelegatedToken "bool Arc::DelegationConsumerSOAP::DelegatedToken(std::string
&credentials, std::string &identity, XMLNode token) ";


// File: classArc_1_1DelegationContainerSOAP.xml
%feature("docstring") Arc::DelegationContainerSOAP "

Manages multiple delegated credentials. Delegation consumers are
created automatically with DelegateCredentialsInit method up to
max_size_ and assigned unique identifier. It's methods are similar to
those of DelegationConsumerSOAP with identifier included in SOAP
message used to route execution to one of managed
DelegationConsumerSOAP instances.

C++ includes: DelegationInterface.h ";

%feature("docstring")
Arc::DelegationContainerSOAP::DelegationContainerSOAP "Arc::DelegationContainerSOAP::DelegationContainerSOAP(void) ";

%feature("docstring")
Arc::DelegationContainerSOAP::~DelegationContainerSOAP "Arc::DelegationContainerSOAP::~DelegationContainerSOAP(void) ";

%feature("docstring")
Arc::DelegationContainerSOAP::DelegateCredentialsInit "bool
Arc::DelegationContainerSOAP::DelegateCredentialsInit(const
SOAPEnvelope &in, SOAPEnvelope &out, const std::string &client=\"\")

See DelegationConsumerSOAP::DelegateCredentialsInit If 'client' is not
empty then all subsequent calls involving access to generated
credentials must contain same value in their 'client' arguments. ";

%feature("docstring")  Arc::DelegationContainerSOAP::UpdateCredentials
"bool Arc::DelegationContainerSOAP::UpdateCredentials(std::string
&credentials, const SOAPEnvelope &in, SOAPEnvelope &out, const
std::string &client=\"\")

See DelegationConsumerSOAP::UpdateCredentials ";

%feature("docstring")  Arc::DelegationContainerSOAP::UpdateCredentials
"bool Arc::DelegationContainerSOAP::UpdateCredentials(std::string
&credentials, std::string &identity, const SOAPEnvelope &in,
SOAPEnvelope &out, const std::string &client=\"\") ";

%feature("docstring")  Arc::DelegationContainerSOAP::DelegatedToken "bool Arc::DelegationContainerSOAP::DelegatedToken(std::string
&credentials, XMLNode token, const std::string &client=\"\")

See DelegationConsumerSOAP::DelegatedToken ";

%feature("docstring")  Arc::DelegationContainerSOAP::DelegatedToken "bool Arc::DelegationContainerSOAP::DelegatedToken(std::string
&credentials, std::string &identity, XMLNode token, const std::string
&client=\"\") ";


// File: classArc_1_1DelegationProvider.xml
%feature("docstring") Arc::DelegationProvider "

A provider of delegated credentials. During delegation procedure this
class generates new credential to be used in proxy/delegated
credential.

C++ includes: DelegationInterface.h ";

%feature("docstring")  Arc::DelegationProvider::DelegationProvider "Arc::DelegationProvider::DelegationProvider(const std::string
&credentials)

Creates instance from provided credentials. Credentials are used to
sign delegated credentials. Arguments should contain PEM-encoded
certificate, private key and optionally certificates chain. ";

%feature("docstring")  Arc::DelegationProvider::DelegationProvider "Arc::DelegationProvider::DelegationProvider(const std::string
&cert_file, const std::string &key_file, std::istream *inpwd=NULL)

Creates instance from provided credentials. Credentials are used to
sign delegated credentials. Arguments should contain filesystem path
to PEM-encoded certificate and private key. Optionally cert_file may
contain certificates chain. ";

%feature("docstring")  Arc::DelegationProvider::~DelegationProvider "Arc::DelegationProvider::~DelegationProvider(void) ";

%feature("docstring")  Arc::DelegationProvider::Delegate "std::string
Arc::DelegationProvider::Delegate(const std::string &request, const
DelegationRestrictions &restrictions=DelegationRestrictions())

Perform delegation. Takes X509 certificate request and creates proxy
credentials excluding private key. Result is then to be fed into
DelegationConsumer::Acquire ";


// File: classArc_1_1DelegationProviderSOAP.xml
%feature("docstring") Arc::DelegationProviderSOAP "

Extension of DelegationProvider with SOAP exchange interface. This
class is also a temporary container for intermediate information used
during delegation procedure.

C++ includes: DelegationInterface.h ";

%feature("docstring")
Arc::DelegationProviderSOAP::DelegationProviderSOAP "Arc::DelegationProviderSOAP::DelegationProviderSOAP(const std::string
&credentials)

Creates instance from provided credentials. Credentials are used to
sign delegated credentials. ";

%feature("docstring")
Arc::DelegationProviderSOAP::DelegationProviderSOAP "Arc::DelegationProviderSOAP::DelegationProviderSOAP(const std::string
&cert_file, const std::string &key_file, std::istream *inpwd=NULL)

Creates instance from provided credentials. Credentials are used to
sign delegated credentials. Arguments should contain filesystem path
to PEM-encoded certificate and private key. Optionally cert_file may
contain certificates chain. ";

%feature("docstring")
Arc::DelegationProviderSOAP::~DelegationProviderSOAP "Arc::DelegationProviderSOAP::~DelegationProviderSOAP(void) ";

%feature("docstring")
Arc::DelegationProviderSOAP::DelegateCredentialsInit "bool
Arc::DelegationProviderSOAP::DelegateCredentialsInit(MCCInterface
&mcc_interface, MessageContext *context)

Performs DelegateCredentialsInit SOAP operation. As result request for
delegated credentials is received by this instance and stored
internally. Call to UpdateCredentials should follow. ";

%feature("docstring")
Arc::DelegationProviderSOAP::DelegateCredentialsInit "bool
Arc::DelegationProviderSOAP::DelegateCredentialsInit(MCCInterface
&mcc_interface, MessageAttributes *attributes_in, MessageAttributes
*attributes_out, MessageContext *context)

Extended version of
DelegateCredentialsInit(MCCInterface&,MessageContext*). Additionally
takes attributes for request and response message to make fine control
on message processing possible. ";

%feature("docstring")  Arc::DelegationProviderSOAP::UpdateCredentials
"bool Arc::DelegationProviderSOAP::UpdateCredentials(MCCInterface
&mcc_interface, MessageContext *context, const DelegationRestrictions
&restrictions=DelegationRestrictions())

Performs UpdateCredentials SOAP operation. This concludes delegation
procedure and passes delagated credentials to DelegationConsumerSOAP
instance. ";

%feature("docstring")  Arc::DelegationProviderSOAP::UpdateCredentials
"bool Arc::DelegationProviderSOAP::UpdateCredentials(MCCInterface
&mcc_interface, MessageAttributes *attributes_in, MessageAttributes
*attributes_out, MessageContext *context, const DelegationRestrictions
&restrictions=DelegationRestrictions())

Extended version of UpdateCredentials(MCCInterface&,MessageContext*).
Additionally takes attributes for request and response message to make
fine control on message processing possible. ";

%feature("docstring")  Arc::DelegationProviderSOAP::DelegatedToken "bool Arc::DelegationProviderSOAP::DelegatedToken(XMLNode parent)

Generates DelegatedToken element. Element is created as child of
provided XML element and contains structure described in
delegation.wsdl. ";

%feature("docstring")  Arc::DelegationProviderSOAP::ID "const
std::string& Arc::DelegationProviderSOAP::ID(void)

Returns the identifier by service accepting delegated credentials.
This identifier may then be used to refer to credentials stored at
service. ";


// File: classArcSec_1_1DenyOverridesCombiningAlg.xml
%feature("docstring") ArcSec::DenyOverridesCombiningAlg "

Implement the \"Deny-Overrides\" algorithm.

Deny-Overrides, scans the policy set which is given as the parameters
of \"combine\" method, if gets \"deny\" result from any policy, then
stops scanning and gives \"deny\" as result, otherwise gives
\"permit\".

C++ includes: DenyOverridesAlg.h ";

%feature("docstring")
ArcSec::DenyOverridesCombiningAlg::DenyOverridesCombiningAlg "ArcSec::DenyOverridesCombiningAlg::DenyOverridesCombiningAlg() ";

%feature("docstring")
ArcSec::DenyOverridesCombiningAlg::~DenyOverridesCombiningAlg "virtual
ArcSec::DenyOverridesCombiningAlg::~DenyOverridesCombiningAlg() ";

%feature("docstring")  ArcSec::DenyOverridesCombiningAlg::combine "virtual Result
ArcSec::DenyOverridesCombiningAlg::combine(EvaluationCtx *ctx,
std::list< Policy * > policies)

If there is one policy which return negative evaluation result, then
omit the other policies and return DECISION_DENY

Parameters:
-----------

ctx:  This object contains request information which will be used to
evaluated against policy.

policlies:  This is a container which contains policy objects.

The combined result according to the algorithm. ";

%feature("docstring")  ArcSec::DenyOverridesCombiningAlg::getalgId "virtual const std::string&
ArcSec::DenyOverridesCombiningAlg::getalgId(void) const

Get the identifier ";


// File: classArc_1_1DiskSpaceRequirementType.xml
%feature("docstring") Arc::DiskSpaceRequirementType "";

%feature("docstring")
Arc::DiskSpaceRequirementType::DiskSpaceRequirementType "Arc::DiskSpaceRequirementType::DiskSpaceRequirementType() ";


// File: classArc_1_1DItem.xml
%feature("docstring") Arc::DItem "";

%feature("docstring")  Arc::DItem::DItem "Arc::DItem::DItem(void) ";

%feature("docstring")  Arc::DItem::~DItem "virtual
Arc::DItem::~DItem(void) ";

%feature("docstring")  Arc::DItem::New "virtual DItem*
Arc::DItem::New(void) const ";

%feature("docstring")  Arc::DItem::str "virtual std::string
Arc::DItem::str() const ";


// File: classArc_1_1DItemString.xml
%feature("docstring") Arc::DItemString "";

%feature("docstring")  Arc::DItemString::DItemString "Arc::DItemString::DItemString(void) ";

%feature("docstring")  Arc::DItemString::DItemString "Arc::DItemString::DItemString(const std::string &) ";

%feature("docstring")  Arc::DItemString::DItemString "Arc::DItemString::DItemString(const char *) ";

%feature("docstring")  Arc::DItemString::~DItemString "virtual
Arc::DItemString::~DItemString(void) ";

%feature("docstring")  Arc::DItemString::New "virtual DItem*
Arc::DItemString::New(void) const ";

%feature("docstring")  Arc::DItemString::str "virtual std::string
Arc::DItemString::str() const ";


// File: classArc_1_1DNListHandlerConfig.xml
%feature("docstring") Arc::DNListHandlerConfig "";

%feature("docstring")  Arc::DNListHandlerConfig::DNListHandlerConfig "Arc::DNListHandlerConfig::DNListHandlerConfig(const std::list<
std::string > &dns, const std::string &event=\"incoming\") ";

%feature("docstring")  Arc::DNListHandlerConfig::AddDN "void
Arc::DNListHandlerConfig::AddDN(const std::string &dn) ";


// File: classArcSec_1_1DurationAttribute.xml
%feature("docstring") ArcSec::DurationAttribute "

Formate: P??Y??M??DT??H??M??S

C++ includes: DateTimeAttribute.h ";

%feature("docstring")  ArcSec::DurationAttribute::DurationAttribute "ArcSec::DurationAttribute::DurationAttribute() ";

%feature("docstring")  ArcSec::DurationAttribute::DurationAttribute "ArcSec::DurationAttribute::DurationAttribute(const std::string &v,
const std::string &i) ";

%feature("docstring")  ArcSec::DurationAttribute::~DurationAttribute "virtual ArcSec::DurationAttribute::~DurationAttribute() ";

%feature("docstring")  ArcSec::DurationAttribute::equal "virtual bool
ArcSec::DurationAttribute::equal(AttributeValue *other, bool
check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::DurationAttribute::encode "virtual
std::string ArcSec::DurationAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::DurationAttribute::getValue "Arc::Period ArcSec::DurationAttribute::getValue() ";

%feature("docstring")  ArcSec::DurationAttribute::getType "virtual
std::string ArcSec::DurationAttribute::getType()

Get the DataType of the <Attribute> ";

%feature("docstring")  ArcSec::DurationAttribute::getId "virtual
std::string ArcSec::DurationAttribute::getId()

Get the AttributeId of the <Attribute> ";


// File: classArc_1_1EnvLockWrapper.xml
%feature("docstring") Arc::EnvLockWrapper "";

%feature("docstring")  Arc::EnvLockWrapper::EnvLockWrapper "Arc::EnvLockWrapper::EnvLockWrapper(bool all=false) ";

%feature("docstring")  Arc::EnvLockWrapper::~EnvLockWrapper "Arc::EnvLockWrapper::~EnvLockWrapper(void) ";


// File: classArcSec_1_1EqualFunction.xml
%feature("docstring") ArcSec::EqualFunction "

Evaluate whether the two values are equal.

C++ includes: EqualFunction.h ";

%feature("docstring")  ArcSec::EqualFunction::EqualFunction "ArcSec::EqualFunction::EqualFunction(std::string functionName,
std::string argumentType) ";

%feature("docstring")  ArcSec::EqualFunction::evaluate "virtual
AttributeValue* ArcSec::EqualFunction::evaluate(AttributeValue *arg0,
AttributeValue *arg1, bool check_id=true)

Evaluate two AttributeValue objects, and return one AttributeValue
object ";

%feature("docstring")  ArcSec::EqualFunction::evaluate "virtual
std::list<AttributeValue*> ArcSec::EqualFunction::evaluate(std::list<
AttributeValue * > args, bool check_id=true)

Evaluate a list of AttributeValue objects, and return a list of
Attribute objects ";


// File: structArcSec_1_1EvalResult.xml
%feature("docstring") ArcSec::EvalResult "

Struct to record the xml node and effect, which will be used by
Evaluator to get the information about which rule/policy(in xmlnode)
is satisfied.

C++ includes: Result.h ";


// File: classArcSec_1_1EvaluationCtx.xml
%feature("docstring") ArcSec::EvaluationCtx "

EvaluationCtx, in charge of storing some context information for.

C++ includes: EvaluationCtx.h ";

%feature("docstring")  ArcSec::EvaluationCtx::EvaluationCtx "ArcSec::EvaluationCtx::EvaluationCtx(Request *request)

Construct a new EvaluationCtx based on the given request ";

%feature("docstring")  ArcSec::EvaluationCtx::~EvaluationCtx "virtual
ArcSec::EvaluationCtx::~EvaluationCtx() ";

%feature("docstring")  ArcSec::EvaluationCtx::getRequest "virtual
Request* ArcSec::EvaluationCtx::getRequest() const ";

%feature("docstring")  ArcSec::EvaluationCtx::getSubjectAttributes "virtual std::list<AttributeValue*>
ArcSec::EvaluationCtx::getSubjectAttributes(std::string &, std::string
&, std::string &, std::string &, AttributeFactory *) ";

%feature("docstring")  ArcSec::EvaluationCtx::getResourceAttributes "virtual std::list<AttributeValue*>
ArcSec::EvaluationCtx::getResourceAttributes(std::string &,
std::string &, std::string &, AttributeFactory *) ";

%feature("docstring")  ArcSec::EvaluationCtx::getActionAttributes "virtual std::list<AttributeValue*>
ArcSec::EvaluationCtx::getActionAttributes(std::string &, std::string
&, std::string &, AttributeFactory *) ";

%feature("docstring")  ArcSec::EvaluationCtx::getContextAttributes "virtual std::list<AttributeValue*>
ArcSec::EvaluationCtx::getContextAttributes(std::string &, std::string
&, std::string &, AttributeFactory *) ";

%feature("docstring")  ArcSec::EvaluationCtx::getAttributes "virtual
std::list<AttributeValue*>
ArcSec::EvaluationCtx::getAttributes(std::string &, Arc::XMLNode &,
std::string &, AttributeFactory *) ";


// File: classArcSec_1_1Evaluator.xml
%feature("docstring") ArcSec::Evaluator "

Interface for policy evaluation. Execute the policy evaluation, based
on the request and policy.

C++ includes: Evaluator.h ";

%feature("docstring")  ArcSec::Evaluator::Evaluator "ArcSec::Evaluator::Evaluator(Arc::XMLNode *) ";

%feature("docstring")  ArcSec::Evaluator::Evaluator "ArcSec::Evaluator::Evaluator(const char *) ";

%feature("docstring")  ArcSec::Evaluator::~Evaluator "virtual
ArcSec::Evaluator::~Evaluator() ";

%feature("docstring")  ArcSec::Evaluator::evaluate "virtual Response*
ArcSec::Evaluator::evaluate(Request *request)=0

Evaluates the request by using a Request object. Evaluation is done
till at least one of policies is satisfied. ";

%feature("docstring")  ArcSec::Evaluator::evaluate "virtual Response*
ArcSec::Evaluator::evaluate(const Source &request)=0

Evaluates the request by using a specified source ";

%feature("docstring")  ArcSec::Evaluator::evaluate "virtual Response*
ArcSec::Evaluator::evaluate(Request *request, const Source &policy)=0

Evaluate the specified request against the policy from specified
source. In some implementations all of the existing policies inside
the evaluator may be destroyed by this method. ";

%feature("docstring")  ArcSec::Evaluator::evaluate "virtual Response*
ArcSec::Evaluator::evaluate(const Source &request, const Source
&policy)=0

Evaluate the request from specified source against the policy from
specified source. In some implementations all of the existing policie
inside the evaluator may be destroyed by this method. ";

%feature("docstring")  ArcSec::Evaluator::evaluate "virtual Response*
ArcSec::Evaluator::evaluate(Request *request, Policy *policyobj)=0

Evaluate the specified request against the specified policy. In some
implementations all of the existing policy inside the evaluator may be
destroyed by this method. ";

%feature("docstring")  ArcSec::Evaluator::evaluate "virtual Response*
ArcSec::Evaluator::evaluate(const Source &request, Policy
*policyobj)=0

Evaluate the request from specified source against the specified
policy. In some implementations all of the existing policie inside the
evaluator may be destroyed by this method. ";

%feature("docstring")  ArcSec::Evaluator::getAttrFactory "virtual
AttributeFactory* ArcSec::Evaluator::getAttrFactory()=0

Get the AttributeFactory object ";

%feature("docstring")  ArcSec::Evaluator::getFnFactory "virtual
FnFactory* ArcSec::Evaluator::getFnFactory()=0

Get the FnFactory object ";

%feature("docstring")  ArcSec::Evaluator::getAlgFactory "virtual
AlgFactory* ArcSec::Evaluator::getAlgFactory()=0

Get the AlgFactory object ";

%feature("docstring")  ArcSec::Evaluator::addPolicy "virtual void
ArcSec::Evaluator::addPolicy(const Source &policy, const std::string
&id=\"\")=0

Add policy from specified source to the evaluator. Policy will be
marked with id. ";

%feature("docstring")  ArcSec::Evaluator::addPolicy "virtual void
ArcSec::Evaluator::addPolicy(Policy *policy, const std::string
&id=\"\")=0

Add policy to the evaluator. Policy will be marked with id. The policy
object is taken over by this instance and will be destroyed in
destructor. ";

%feature("docstring")  ArcSec::Evaluator::setCombiningAlg "virtual
void ArcSec::Evaluator::setCombiningAlg(EvaluatorCombiningAlg alg)=0

Specifies one of simple combining algorithms. In case of multiple
policies their results will be combined using this algorithm. ";

%feature("docstring")  ArcSec::Evaluator::setCombiningAlg "virtual
void ArcSec::Evaluator::setCombiningAlg(CombiningAlg *alg=NULL)=0

Specifies loadable combining algorithms. In case of multiple policies
their results will be combined using this algorithm. To switch to
simple algorithm specify NULL argument. ";

%feature("docstring")  ArcSec::Evaluator::getName "virtual const
char* ArcSec::Evaluator::getName(void) const =0

Get the name of this evaluator ";


// File: classArcSec_1_1EvaluatorContext.xml
%feature("docstring") ArcSec::EvaluatorContext "

Context for evaluator. It includes the factories which will be used to
create related objects.

C++ includes: Evaluator.h ";

%feature("docstring")  ArcSec::EvaluatorContext::EvaluatorContext "ArcSec::EvaluatorContext::EvaluatorContext(Evaluator *evaluator) ";

%feature("docstring")  ArcSec::EvaluatorContext::~EvaluatorContext "ArcSec::EvaluatorContext::~EvaluatorContext() ";


// File: classArcSec_1_1EvaluatorLoader.xml
%feature("docstring") ArcSec::EvaluatorLoader "

EvaluatorLoader is implemented as a helper class for loading different
Evaluator objects, like ArcEvaluator.

The object loading is based on the configuration information about
evaluator, including information for factory class, request, policy
and evaluator itself

C++ includes: EvaluatorLoader.h ";

%feature("docstring")  ArcSec::EvaluatorLoader::EvaluatorLoader "ArcSec::EvaluatorLoader::EvaluatorLoader() ";

%feature("docstring")  ArcSec::EvaluatorLoader::getEvaluator "Evaluator* ArcSec::EvaluatorLoader::getEvaluator(const std::string
&classname)

Get evaluator object according to the class name ";

%feature("docstring")  ArcSec::EvaluatorLoader::getEvaluator "Evaluator* ArcSec::EvaluatorLoader::getEvaluator(const Policy *policy)

Get evaluator object suitable for presented policy ";

%feature("docstring")  ArcSec::EvaluatorLoader::getEvaluator "Evaluator* ArcSec::EvaluatorLoader::getEvaluator(const Request
*request)

Get evaluator object suitable for presented request ";

%feature("docstring")  ArcSec::EvaluatorLoader::getRequest "Request*
ArcSec::EvaluatorLoader::getRequest(const std::string &classname,
const Source &requestsource)

Get request object according to the class name, based on the request
source ";

%feature("docstring")  ArcSec::EvaluatorLoader::getRequest "Request*
ArcSec::EvaluatorLoader::getRequest(const Source &requestsource)

Get request object according to the request source ";

%feature("docstring")  ArcSec::EvaluatorLoader::getPolicy "Policy*
ArcSec::EvaluatorLoader::getPolicy(const std::string &classname, const
Source &policysource)

Get policy object according to the class name, based on the policy
source ";

%feature("docstring")  ArcSec::EvaluatorLoader::getPolicy "Policy*
ArcSec::EvaluatorLoader::getPolicy(const Source &policysource)

Get proper policy object according to the policy source ";


// File: classArc_1_1ExecutableType.xml
%feature("docstring") Arc::ExecutableType "";

%feature("docstring")  Arc::ExecutableType::ExecutableType "Arc::ExecutableType::ExecutableType() ";


// File: classArc_1_1ExecutionTarget.xml
%feature("docstring") Arc::ExecutionTarget "

ExecutionTarget.

This class describe a target which accept computing jobs. All of the
members contained in this class, with a few exceptions, are directly
linked to attributes defined in the GLUE Specification v. 2.0
(GFD-R-P.147).

C++ includes: ExecutionTarget.h ";

%feature("docstring")  Arc::ExecutionTarget::ExecutionTarget "Arc::ExecutionTarget::ExecutionTarget()

Create an ExecutionTarget.

Default constructor to create an ExecutionTarget. Takes no arguments.
";

%feature("docstring")  Arc::ExecutionTarget::ExecutionTarget "Arc::ExecutionTarget::ExecutionTarget(const ExecutionTarget &target)

Create an ExecutionTarget.

Copy constructor.

Parameters:
-----------

target:   ExecutionTarget to copy. ";

%feature("docstring")  Arc::ExecutionTarget::ExecutionTarget "Arc::ExecutionTarget::ExecutionTarget(const long int addrptr)

Create an ExecutionTarget.

Copy constructor? Needed from Python?

Parameters:
-----------

addrptr:  ";

%feature("docstring")  Arc::ExecutionTarget::~ExecutionTarget "virtual Arc::ExecutionTarget::~ExecutionTarget() ";

%feature("docstring")  Arc::ExecutionTarget::GetSubmitter "Submitter*
Arc::ExecutionTarget::GetSubmitter(const UserConfig &ucfg) const

Get Submitter to the computing resource represented by the
ExecutionTarget.

Method which returns a specialized Submitter which can be used for
submitting jobs to the computing resource represented by the
ExecutionTarget. In order to return the correct specialized Submitter
the GridFlavour variable must be correctly set.

Parameters:
-----------

ucfg:   UserConfig object with paths to user credentials etc. ";

%feature("docstring")  Arc::ExecutionTarget::GetTestJob "bool
Arc::ExecutionTarget::GetTestJob(const UserConfig &ucfg, const int
&testid, JobDescription &jobdescription) const ";

%feature("docstring")  Arc::ExecutionTarget::Submit "bool
Arc::ExecutionTarget::Submit(const UserConfig &ucfg, const
JobDescription &jobdesc, Job &job) const ";

%feature("docstring")  Arc::ExecutionTarget::Migrate "bool
Arc::ExecutionTarget::Migrate(const UserConfig &ucfg, const URL
&jobid, const JobDescription &jobdesc, bool forcemigration, Job &job)
const ";

%feature("docstring")  Arc::ExecutionTarget::Update "void
Arc::ExecutionTarget::Update(const JobDescription &jobdesc)

Update ExecutionTarget after succesful job submission.

Method to update the ExecutionTarget after a job succesfully has been
submitted to the computing resource it represents. E.g. if a job is
sent to the computing resource and is expected to enter the queue,
then the WaitingJobs attribute is incremented with 1.

Parameters:
-----------

jobdesc:  contains all information about the job submitted. ";

%feature("docstring")  Arc::ExecutionTarget::Print "void
Arc::ExecutionTarget::Print(bool longlist) const

DEPRECATED: Print the ExecutionTarget information to std::cout.

This method is deprecated, use the SaveToStream method instead. Method
to print the ExecutionTarget attributes to std::cout

Parameters:
-----------

longlist:  is true for long list printing.

See:   SaveToStream ";

%feature("docstring")  Arc::ExecutionTarget::SaveToStream "void
Arc::ExecutionTarget::SaveToStream(std::ostream &out, bool longlist)
const

Print the ExecutionTarget information to a std::ostream object.

Method to print the ExecutionTarget attributes to a std::ostream
object.

Parameters:
-----------

out:  is the std::ostream to print the attributes to.

longlist:  should be set to true for printing a long list. ";


// File: classArc_1_1ExpirationReminder.xml
%feature("docstring") Arc::ExpirationReminder "

A class intended for internal use within counters.

This class is used for \"reminder objects\" that are used for
automatic deallocation of self-expiring reservations.

C++ includes: Counter.h ";

%feature("docstring")  Arc::ExpirationReminder::getExpiryTime "Glib::TimeVal Arc::ExpirationReminder::getExpiryTime() const

Returns the expiry time.

This method returns the expiry time of the reservation that this
ExpirationReminder is associated with. The expiry time. ";

%feature("docstring")  Arc::ExpirationReminder::getReservationID "Counter::IDType Arc::ExpirationReminder::getReservationID() const

Returns the identification number of the reservation.

This method returns the identification number of the self-expiring
reservation that this ExpirationReminder is associated with. The
identification number. ";


// File: classArc_1_1FileAccess.xml
%feature("docstring") Arc::FileAccess "

Defines interface for accessing filesystems.

This class accesses local filesystem through proxy executable which
allows to switch user id in multithreaded systems without introducing
conflict with other threads. Its methods are mostly replicas of
corresponding POSIX functions with some convenience tweaking.

C++ includes: FileAccess.h ";

%feature("docstring")  Arc::FileAccess::FileAccess "Arc::FileAccess::FileAccess(void) ";

%feature("docstring")  Arc::FileAccess::~FileAccess "Arc::FileAccess::~FileAccess(void) ";

%feature("docstring")  Arc::FileAccess::ping "bool
Arc::FileAccess::ping(void)

Check if communication with proxy works. ";

%feature("docstring")  Arc::FileAccess::setuid "bool
Arc::FileAccess::setuid(int uid, int gid)

Modify user uid and gid. If any is set to 0 then executable is
switched to original uid/gid. ";

%feature("docstring")  Arc::FileAccess::mkdir "bool
Arc::FileAccess::mkdir(const std::string &path, mode_t mode)

Make a directory and assign it specified mode. ";

%feature("docstring")  Arc::FileAccess::mkdirp "bool
Arc::FileAccess::mkdirp(const std::string &path, mode_t mode)

Make a directory and assign it specified mode. If missing all
intermediate directories are created too. ";

%feature("docstring")  Arc::FileAccess::link "bool
Arc::FileAccess::link(const std::string &oldpath, const std::string
&newpath)

Create hard link. ";

%feature("docstring")  Arc::FileAccess::softlink "bool
Arc::FileAccess::softlink(const std::string &oldpath, const
std::string &newpath)

Create symbolic (aka soft) link. ";

%feature("docstring")  Arc::FileAccess::copy "bool
Arc::FileAccess::copy(const std::string &oldpath, const std::string
&newpath, mode_t mode)

Copy file to new location. If new file is created it is assigned
secified mode. ";

%feature("docstring")  Arc::FileAccess::chmod "bool
Arc::FileAccess::chmod(const std::string &path, mode_t mode)

Change mode of filesystem object. ";

%feature("docstring")  Arc::FileAccess::stat "bool
Arc::FileAccess::stat(const std::string &path, struct stat &st)

stat file. ";

%feature("docstring")  Arc::FileAccess::lstat "bool
Arc::FileAccess::lstat(const std::string &path, struct stat &st)

stat symbolic link or file. ";

%feature("docstring")  Arc::FileAccess::fstat "bool
Arc::FileAccess::fstat(struct stat &st)

stat open file. ";

%feature("docstring")  Arc::FileAccess::ftruncate "bool
Arc::FileAccess::ftruncate(off_t length)

Truncate open file. ";

%feature("docstring")  Arc::FileAccess::fallocate "off_t
Arc::FileAccess::fallocate(off_t length)

Allocate disk space for open file. ";

%feature("docstring")  Arc::FileAccess::readlink "bool
Arc::FileAccess::readlink(const std::string &path, std::string
&linkpath)

Read content of symbolic link. ";

%feature("docstring")  Arc::FileAccess::remove "bool
Arc::FileAccess::remove(const std::string &path)

Remove file system object. ";

%feature("docstring")  Arc::FileAccess::unlink "bool
Arc::FileAccess::unlink(const std::string &path)

Remove file. ";

%feature("docstring")  Arc::FileAccess::rmdir "bool
Arc::FileAccess::rmdir(const std::string &path)

Remove directory (if empty). ";

%feature("docstring")  Arc::FileAccess::rmdirr "bool
Arc::FileAccess::rmdirr(const std::string &path)

Remove directory recursively. ";

%feature("docstring")  Arc::FileAccess::opendir "bool
Arc::FileAccess::opendir(const std::string &path)

Open directory. Only one directory may be open at a time. ";

%feature("docstring")  Arc::FileAccess::closedir "bool
Arc::FileAccess::closedir(void)

Close open directory. ";

%feature("docstring")  Arc::FileAccess::readdir "bool
Arc::FileAccess::readdir(std::string &name)

Read relative name of object in open directory. ";

%feature("docstring")  Arc::FileAccess::open "bool
Arc::FileAccess::open(const std::string &path, int flags, mode_t mode)

Open file. Only one file may be open at a time. ";

%feature("docstring")  Arc::FileAccess::close "bool
Arc::FileAccess::close(void)

Close open file. ";

%feature("docstring")  Arc::FileAccess::lseek "off_t
Arc::FileAccess::lseek(off_t offset, int whence)

Change current position in open file. ";

%feature("docstring")  Arc::FileAccess::read "ssize_t
Arc::FileAccess::read(void *buf, size_t size)

Read from open file. ";

%feature("docstring")  Arc::FileAccess::write "ssize_t
Arc::FileAccess::write(const void *buf, size_t size)

Write to open file. ";

%feature("docstring")  Arc::FileAccess::pread "ssize_t
Arc::FileAccess::pread(void *buf, size_t size, off_t offset)

Read from open file at specified offset. ";

%feature("docstring")  Arc::FileAccess::pwrite "ssize_t
Arc::FileAccess::pwrite(const void *buf, size_t size, off_t offset)

Write to open file at specified offset. ";

%feature("docstring")  Arc::FileAccess::geterrno "int
Arc::FileAccess::geterrno()

Get errno of last operation. Every operation resets errno. ";


// File: classArc_1_1FileCache.xml
%feature("docstring") Arc::FileCache "

FileCache provides an interface to all cache operations to be used by
external classes. An instance should be created per job, and all files
within the job are managed by that instance. When it is decided a file
should be downloaded to the cache, Start() should be called, so that
the cache file can be prepared and locked. When a transfer has
finished successfully, Link() should be called to create a hard link
to a per-job directory in the cache and then soft link, or copy the
file directly to the session directory so it can be accessed from the
user's job. Stop() must then be called to release any locks on the
cache file.

The cache directory(ies) and the optional directory to link to when
the soft-links are made are set in the global configuration file. The
names of cache files are formed from a hash of the URL specified as
input to the job. To ease the load on the file system, the cache files
are split into subdirectories based on the first two characters in the
hash. For example the file with hash 76f11edda169848038efbd9fa3df5693
is stored in 76/f11edda169848038efbd9fa3df5693. A cache filename can
be found by passing the URL to Find(). For more information on the
structure of the cache, see the Grid Manager Administration Guide.

A metadata file with the '.meta' suffix is stored next to each cache
file. This contains the URL corresponding to the cache file and the
expiry time, if it is available. For example
lfc://lfc1.ndgf.org//grid/atlas/test/test1 20081007151045Z

While cache files are downloaded, they are locked using the FileLock
class, which creates a lock file with the '.lock' suffix next to the
cache file. Calling Start() creates this lock and Stop() releases it.
All processes calling Start() must wait until they successfully obtain
the lock before downloading can begin or an existing cache file can be
used. Once a process obtains a lock it must later release it by
calling Stop() or StopAndDelete(). Once a cache file is successfully
linked to the per-job directory in Link(), it is also unlocked, but
Stop() should still be called after.

C++ includes: FileCache.h ";

%feature("docstring")  Arc::FileCache::FileCache "Arc::FileCache::FileCache(std::string cache_path, std::string id,
uid_t job_uid, gid_t job_gid)

Create a new FileCache instance.

Parameters:
-----------

cache_path:  The format is \"cache_dir[ link_path]\". path is the path
to the cache directory and the optional link_path is used to create a
link in case the cache directory is visible under a different name
during actual usage. When linking from the session dir this path is
used instead of cache_path.

id:  the job id. This is used to create the per-job dir which the
job's cache files will be hard linked from

job_uid:  owner of job. The per-job dir will only be readable by this
user

job_gid:  owner group of job ";

%feature("docstring")  Arc::FileCache::FileCache "Arc::FileCache::FileCache(std::vector< std::string > caches,
std::string id, uid_t job_uid, gid_t job_gid)

Create a new FileCache instance with multiple cache dirs

Parameters:
-----------

caches:  a vector of strings describing caches. The format of each
string is \"cache_dir[ link_path]\".

id:  the job id. This is used to create the per-job dir which the
job's cache files will be hard linked from

job_uid:  owner of job. The per-job dir will only be readable by this
user

job_gid:  owner group of job ";

%feature("docstring")  Arc::FileCache::FileCache "Arc::FileCache::FileCache(std::vector< std::string > caches,
std::vector< std::string > remote_caches, std::vector< std::string >
draining_caches, std::string id, uid_t job_uid, gid_t job_gid, int
cache_max=100, int cache_min=100)

Create a new FileCache instance with multiple cache dirs, remote
caches and draining cache directories.

Parameters:
-----------

caches:  a vector of strings describing caches. The format of each
string is \"cache_dir[ link_path]\".

remote_caches:  Same format as caches. These are the paths to caches
which are under the control of other Grid Managers and are read-only
for this process.

draining_caches:  Same format as caches. These are the paths to caches
which are to be drained.

id:  the job id. This is used to create the per-job dir which the
job's cache files will be hard linked from

job_uid:  owner of job. The per-job dir will only be readable by this
user

job_gid:  owner group of job

cache_max:  maximum used space by cache, as percentage of the file
system

cache_min:  minimum used space by cache, as percentage of the file
system ";

%feature("docstring")  Arc::FileCache::FileCache "Arc::FileCache::FileCache()

Default constructor. Invalid cache. ";

%feature("docstring")  Arc::FileCache::Start "bool
Arc::FileCache::Start(std::string url, bool &available, bool
&is_locked, bool use_remote=true)

Prepare cache for downloading file, and lock the cached file. On
success returns true. If there is another process downloading the same
url, false is returned and is_locked is set to true. In this case the
client should wait and retry later. If the lock has expired this
process will take over the lock and the method will return as if no
lock was present, ie available and is_locked are false.

Parameters:
-----------

url:  url that is being downloaded

available:  true on exit if the file is already in cache

is_locked:  true on exit if the file is already locked, ie cannot be
used by this process

remote_caches:  Same format as caches. These are the paths to caches
which are under the control of other Grid Managers and are read-only
for this process. ";

%feature("docstring")  Arc::FileCache::Stop "bool
Arc::FileCache::Stop(std::string url)

This method (or stopAndDelete) must be called after file was
downloaded or download failed, to release the lock on the cache file.
Stop() does not delete the cache file. It returns false if the lock
file does not exist, or another pid was found inside the lock file
(this means another process took over the lock so this process must go
back to Start()), or if it fails to delete the lock file.

Parameters:
-----------

url:  the url of the file that was downloaded ";

%feature("docstring")  Arc::FileCache::StopAndDelete "bool
Arc::FileCache::StopAndDelete(std::string url)

Release the cache file and delete it, because for example a failed
download left an incomplete copy, or it has expired. This method also
deletes the meta file which contains the url corresponding to the
cache file. The logic of the return value is the same as Stop().

Parameters:
-----------

url:  the url corresponding to the cache file that has to be released
and deleted ";

%feature("docstring")  Arc::FileCache::File "std::string
Arc::FileCache::File(std::string url)

Returns the full pathname of the file in the cache which corresponds
to the given url. ";

%feature("docstring")  Arc::FileCache::Link "bool
Arc::FileCache::Link(std::string link_path, std::string url, bool
copy, bool executable)

Create a hard-link to the per-job dir from the cache dir, and then a
soft-link from here to the session directory. This is effectively
'claiming' the file for the job, so even if the original cache file is
deleted, eg by some external process, the hard link still exists until
it is explicitly released by calling Release().

If cache_link_path is set to \".\" then files will be copied directly
to the session directory rather than via the hard link.

The session directory is accessed under the uid and gid passed in the
constructor.

Parameters:
-----------

link_path:  path to the session dir for soft-link or new file

url:  url of file to link to or copy

copy:  If true the file is copied rather than soft-linked to the
session dir

executable:  If true then file is copied and given execute permissions
in the session dir ";

%feature("docstring")  Arc::FileCache::Copy "bool
Arc::FileCache::Copy(std::string dest_path, std::string url, bool
executable=false)

Copy the cache file corresponding to url to the dest_path. The session
directory is accessed under the uid passed in the constructor, and
switching uid involves holding a global lock. Therefore care must be
taken in a multi-threaded environment.

This method is deprecated - Link() should be used instead with copy
set to true. ";

%feature("docstring")  Arc::FileCache::Release "bool
Arc::FileCache::Release()

Release claims on input files for the job specified by id. For each
cache directory the per-job directory with the hard-links will be
deleted. ";

%feature("docstring")  Arc::FileCache::AddDN "bool
Arc::FileCache::AddDN(std::string url, std::string DN, Time
expiry_time)

Add the given DN to the list of cached DNs with the given expiry time

Parameters:
-----------

url:  the url corresponding to the cache file to which we want to add
a cached DN

DN:  the DN of the user

expiry_time:  the expiry time of this DN in the DN cache ";

%feature("docstring")  Arc::FileCache::CheckDN "bool
Arc::FileCache::CheckDN(std::string url, std::string DN)

Check if the given DN is cached for authorisation.

Parameters:
-----------

url:  the url corresponding to the cache file for which we want to
check the cached DN

DN:  the DN of the user ";

%feature("docstring")  Arc::FileCache::CheckCreated "bool
Arc::FileCache::CheckCreated(std::string url)

Check if there is an information about creation time. Returns true if
the file exists in the cache, since the creation time is the creation
time of the cache file.

Parameters:
-----------

url:  the url corresponding to the cache file for which we want to
know if the creation date exists ";

%feature("docstring")  Arc::FileCache::GetCreated "Time
Arc::FileCache::GetCreated(std::string url)

Get the creation time of a cached file. If the cache file does not
exist, 0 is returned.

Parameters:
-----------

url:  the url corresponding to the cache file for which we want to
know the creation date ";

%feature("docstring")  Arc::FileCache::CheckValid "bool
Arc::FileCache::CheckValid(std::string url)

Check if there is an information about expiry time.

Parameters:
-----------

url:  the url corresponding to the cache file for which we want to
know if the expiration time exists ";

%feature("docstring")  Arc::FileCache::GetValid "Time
Arc::FileCache::GetValid(std::string url)

Get expiry time of a cached file. If the time is not available, a time
equivalent to 0 is returned.

Parameters:
-----------

url:  the url corresponding to the cache file for which we want to
know the expiry time ";

%feature("docstring")  Arc::FileCache::SetValid "bool
Arc::FileCache::SetValid(std::string url, Time val)

Set expiry time.

Parameters:
-----------

url:  the url corresponding to the cache file for which we want to set
the expiry time

val:  expiry time ";


// File: classFileCacheHash.xml
%feature("docstring") FileCacheHash "

FileCacheHash provides methods to make hashes from strings. Currently
the md5 hash from the openssl library is used.

C++ includes: FileCacheHash.h ";


// File: classArc_1_1FileInfo.xml
%feature("docstring") Arc::FileInfo "

FileInfo stores information about files (metadata).

C++ includes: FileInfo.h ";

%feature("docstring")  Arc::FileInfo::FileInfo "Arc::FileInfo::FileInfo(const std::string &name=\"\") ";

%feature("docstring")  Arc::FileInfo::~FileInfo "Arc::FileInfo::~FileInfo() ";

%feature("docstring")  Arc::FileInfo::GetName "const std::string&
Arc::FileInfo::GetName() const ";

%feature("docstring")  Arc::FileInfo::GetLastName "std::string
Arc::FileInfo::GetLastName() const ";

%feature("docstring")  Arc::FileInfo::SetName "void
Arc::FileInfo::SetName(const std::string &n) ";

%feature("docstring")  Arc::FileInfo::GetURLs "const std::list<URL>&
Arc::FileInfo::GetURLs() const ";

%feature("docstring")  Arc::FileInfo::AddURL "void
Arc::FileInfo::AddURL(const URL &u) ";

%feature("docstring")  Arc::FileInfo::CheckSize "bool
Arc::FileInfo::CheckSize() const ";

%feature("docstring")  Arc::FileInfo::GetSize "unsigned long long int
Arc::FileInfo::GetSize() const ";

%feature("docstring")  Arc::FileInfo::SetSize "void
Arc::FileInfo::SetSize(const unsigned long long int s) ";

%feature("docstring")  Arc::FileInfo::CheckCheckSum "bool
Arc::FileInfo::CheckCheckSum() const ";

%feature("docstring")  Arc::FileInfo::GetCheckSum "const std::string&
Arc::FileInfo::GetCheckSum() const ";

%feature("docstring")  Arc::FileInfo::SetCheckSum "void
Arc::FileInfo::SetCheckSum(const std::string &c) ";

%feature("docstring")  Arc::FileInfo::CheckCreated "bool
Arc::FileInfo::CheckCreated() const ";

%feature("docstring")  Arc::FileInfo::GetCreated "Time
Arc::FileInfo::GetCreated() const ";

%feature("docstring")  Arc::FileInfo::SetCreated "void
Arc::FileInfo::SetCreated(const Time &t) ";

%feature("docstring")  Arc::FileInfo::CheckValid "bool
Arc::FileInfo::CheckValid() const ";

%feature("docstring")  Arc::FileInfo::GetValid "Time
Arc::FileInfo::GetValid() const ";

%feature("docstring")  Arc::FileInfo::SetValid "void
Arc::FileInfo::SetValid(const Time &t) ";

%feature("docstring")  Arc::FileInfo::CheckType "bool
Arc::FileInfo::CheckType() const ";

%feature("docstring")  Arc::FileInfo::GetType "Type
Arc::FileInfo::GetType() const ";

%feature("docstring")  Arc::FileInfo::SetType "void
Arc::FileInfo::SetType(const Type t) ";

%feature("docstring")  Arc::FileInfo::CheckLatency "bool
Arc::FileInfo::CheckLatency() const ";

%feature("docstring")  Arc::FileInfo::GetLatency "std::string
Arc::FileInfo::GetLatency() const ";

%feature("docstring")  Arc::FileInfo::SetLatency "void
Arc::FileInfo::SetLatency(const std::string l) ";

%feature("docstring")  Arc::FileInfo::GetMetaData "std::map<std::string, std::string> Arc::FileInfo::GetMetaData() const
";

%feature("docstring")  Arc::FileInfo::SetMetaData "void
Arc::FileInfo::SetMetaData(const std::string att, const std::string
val) ";


// File: classArc_1_1FileLock.xml
%feature("docstring") Arc::FileLock "

A general file locking class.

This class can be used when protected access is required to files
which are used by multiple processes or threads. Call acquire() to
obtain a lock and release() to release it when finished. check() can
be used to verify if a lock is valid for the current process. Locks
are independent of FileLock objects - locks are only created and
destroyed through acquire() and release(), not on creation or
destruction of FileLock objects.

Unless use_pid is set false, the process ID and hostname of the
calling process are stored in a file filename.lock in the form pid.
This information is used to determine whether a lock is still valid.
It is also possible to specify a timeout on the lock.

To ensure an atomic locking operation, acquire() first creates a
temporary lock file filename.lock.XXXXXX, then attempts to rename this
file to filename.lock. After a successful rename the lock file is
checked to make sure the correct process ID and hostname are inside.
This eliminates race conditions where multiple processes compete to
obtain the lock.

C++ includes: FileLock.h ";

%feature("docstring")  Arc::FileLock::FileLock "Arc::FileLock::FileLock(const std::string &filename, unsigned int
timeout=DEFAULT_LOCK_TIMEOUT, bool use_pid=true)

Create a new FileLock object.

Parameters:
-----------

filename:  The name of the file to be locked

timeout:  The timeout of the lock

use_pid:  If true, use process id in the lock and to determine lock
validity ";

%feature("docstring")  Arc::FileLock::acquire "bool
Arc::FileLock::acquire(bool &lock_removed)

Acquire the lock.

Returns true if the lock was acquired successfully. Locks are acquired
if no lock file currently exists, or if the current lock file is
invalid. A lock is invalid if the process ID inside the lock no longer
exists on the host inside the lock, or the age of the lock file is
greater than the lock timeout.

Parameters:
-----------

lock_removed:  Set to true if an existing lock was removed due to
being invalid. In this case the caller may decide to check or delete
the file as it is potentially corrupted.

True if lock is successfully acquired ";

%feature("docstring")  Arc::FileLock::acquire "bool
Arc::FileLock::acquire()

Acquire the lock.

Callers can use this version of acquire() if they do not care whether
an invalid lock was removed in the process of obtaining the lock. ";

%feature("docstring")  Arc::FileLock::release "bool
Arc::FileLock::release(bool force=false)

Release the lock.

Parameters:
-----------

force:  Remove the lock without checking ownership or timeout ";

%feature("docstring")  Arc::FileLock::check "bool
Arc::FileLock::check()

Check the lock is valid.

Returns true if the lock is valid for the current process ";


// File: classArc_1_1FileType.xml
%feature("docstring") Arc::FileType "";

%feature("docstring")  Arc::FileType::FileType "Arc::FileType::FileType() ";


// File: classArc_1_1FinderLoader.xml
%feature("docstring") Arc::FinderLoader "";


// File: classArcSec_1_1FnFactory.xml
%feature("docstring") ArcSec::FnFactory "

Interface for function factory class.

FnFactory is in charge of creating Function object according to the
algorithm type given as argument of method createFn. This class can be
inherited for implementing a factory class which can create some
specific Function objects.

C++ includes: FnFactory.h ";

%feature("docstring")  ArcSec::FnFactory::FnFactory "ArcSec::FnFactory::FnFactory() ";

%feature("docstring")  ArcSec::FnFactory::~FnFactory "virtual
ArcSec::FnFactory::~FnFactory() ";

%feature("docstring")  ArcSec::FnFactory::createFn "virtual Function*
ArcSec::FnFactory::createFn(const std::string &type)=0

creat algorithm object based on the type algorithm type

Parameters:
-----------

type:  The type of Function

The object of Function ";


// File: classArcSec_1_1Function.xml
%feature("docstring") ArcSec::Function "

Interface for function, which is in charge of evaluating two
AttributeValue.

C++ includes: Function.h ";

%feature("docstring")  ArcSec::Function::Function "ArcSec::Function::Function(std::string, std::string) ";

%feature("docstring")  ArcSec::Function::~Function "virtual
ArcSec::Function::~Function() ";

%feature("docstring")  ArcSec::Function::evaluate "virtual
AttributeValue* ArcSec::Function::evaluate(AttributeValue *arg0,
AttributeValue *arg1, bool check_id=true)=0

Evaluate two AttributeValue objects, and return one AttributeValue
object ";

%feature("docstring")  ArcSec::Function::evaluate "virtual
std::list<AttributeValue*> ArcSec::Function::evaluate(std::list<
AttributeValue * > args, bool check_id=true)=0

Evaluate a list of AttributeValue objects, and return a list of
Attribute objects ";


// File: classArcSec_1_1GenericAttribute.xml
%feature("docstring") ArcSec::GenericAttribute "";

%feature("docstring")  ArcSec::GenericAttribute::GenericAttribute "ArcSec::GenericAttribute::GenericAttribute() ";

%feature("docstring")  ArcSec::GenericAttribute::GenericAttribute "ArcSec::GenericAttribute::GenericAttribute(const std::string &v, const
std::string &i) ";

%feature("docstring")  ArcSec::GenericAttribute::~GenericAttribute "virtual ArcSec::GenericAttribute::~GenericAttribute() ";

%feature("docstring")  ArcSec::GenericAttribute::equal "virtual bool
ArcSec::GenericAttribute::equal(AttributeValue *other, bool
check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::GenericAttribute::encode "virtual
std::string ArcSec::GenericAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::GenericAttribute::getValue "std::string ArcSec::GenericAttribute::getValue() ";

%feature("docstring")  ArcSec::GenericAttribute::getType "virtual
std::string ArcSec::GenericAttribute::getType()

Get the DataType of the <Attribute> ";

%feature("docstring")  ArcSec::GenericAttribute::getId "virtual
std::string ArcSec::GenericAttribute::getId()

Get the AttributeId of the <Attribute> ";

%feature("docstring")  ArcSec::GenericAttribute::setType "void
ArcSec::GenericAttribute::setType(const std::string &new_type) ";


// File: classArc_1_1GlobusResult.xml
%feature("docstring") Arc::GlobusResult "";

%feature("docstring")  Arc::GlobusResult::GlobusResult "Arc::GlobusResult::GlobusResult() ";

%feature("docstring")  Arc::GlobusResult::GlobusResult "Arc::GlobusResult::GlobusResult(const globus_result_t result) ";

%feature("docstring")  Arc::GlobusResult::str "std::string
Arc::GlobusResult::str() const ";


// File: classArc_1_1GSSCredential.xml
%feature("docstring") Arc::GSSCredential "";

%feature("docstring")  Arc::GSSCredential::GSSCredential "Arc::GSSCredential::GSSCredential(const std::string &proxyPath, const
std::string &certificatePath, const std::string &keyPath) ";

%feature("docstring")  Arc::GSSCredential::GSSCredential "Arc::GSSCredential::GSSCredential() ";

%feature("docstring")  Arc::GSSCredential::~GSSCredential "Arc::GSSCredential::~GSSCredential() ";


// File: classArc_1_1HakaClient.xml
%feature("docstring") Arc::HakaClient "";

%feature("docstring")  Arc::HakaClient::HakaClient "Arc::HakaClient::HakaClient(MCCConfig cfg, URL url, std::list<
std::string > idp_stack) ";

%feature("docstring")  Arc::HakaClient::~HakaClient "virtual
Arc::HakaClient::~HakaClient() ";


// File: structArc_1_1FileAccess_1_1header__t.xml
%feature("docstring") Arc::FileAccess::header_t "";


// File: structArc_1_1HTTPClientInfo.xml
%feature("docstring") Arc::HTTPClientInfo "";


// File: classArc_1_1InfoCache.xml
%feature("docstring") Arc::InfoCache "

Stores XML document in filesystem split into parts.

C++ includes: InfoCache.h ";

%feature("docstring")  Arc::InfoCache::Query "bool
Arc::InfoCache::Query(const char *xml_path, const char *q,
XMLNodeContainer &result) ";

%feature("docstring")  Arc::InfoCache::Query "bool
Arc::InfoCache::Query(const std::string &xml_path, std::string &q,
XMLNodeContainer &result) ";

%feature("docstring")  Arc::InfoCache::Set "bool
Arc::InfoCache::Set(const char *xml_path, XMLNode &value) ";

%feature("docstring")  Arc::InfoCache::Set "bool
Arc::InfoCache::Set(const std::string &xml_path, XMLNode &value) ";

%feature("docstring")  Arc::InfoCache::Get "bool
Arc::InfoCache::Get(const char *xml_path, XMLNodeContainer &result) ";

%feature("docstring")  Arc::InfoCache::Get "bool
Arc::InfoCache::Get(const std::string &xml_path, XMLNodeContainer
&result) ";

%feature("docstring")  Arc::InfoCache::Unset "bool
Arc::InfoCache::Unset(const char *xml_path) ";

%feature("docstring")  Arc::InfoCache::Unset "bool
Arc::InfoCache::Unset(const std::string &xml_path) ";

%feature("docstring")  Arc::InfoCache::InfoCache "Arc::InfoCache::InfoCache(const Config &cfg, const std::string
&service_id)

Creates object according to configuration (see InfoCacheConfig.xsd)

XML configuration is passed in cfg. Argument service_id is used to
distiguish between various documents stored under same path -
corresponding files will be stored in subdirectory with service_id
name. ";

%feature("docstring")  Arc::InfoCache::~InfoCache "Arc::InfoCache::~InfoCache() ";


// File: classArc_1_1InfoCacheInterface.xml
%feature("docstring") Arc::InfoCacheInterface "";

%feature("docstring")  Arc::InfoCacheInterface::InfoCacheInterface "Arc::InfoCacheInterface::InfoCacheInterface(Config &cfg, std::string
&service_id) ";

%feature("docstring")  Arc::InfoCacheInterface::~InfoCacheInterface "virtual Arc::InfoCacheInterface::~InfoCacheInterface(void) ";

%feature("docstring")  Arc::InfoCacheInterface::Cache "InfoCache&
Arc::InfoCacheInterface::Cache(void) ";


// File: classArc_1_1InfoFilter.xml
%feature("docstring") Arc::InfoFilter "

Filters information document according to identity of requestor.

Identity is compared to policies stored inside information document
and external ones. Parts of document which do not pass policy
evaluation are removed.

C++ includes: InfoFilter.h ";

%feature("docstring")  Arc::InfoFilter::InfoFilter "Arc::InfoFilter::InfoFilter(MessageAuth &id)

Creates object and associates identity.

Associated identity is not copied, hence passed argument must not be
destroyed while this method is used. ";

%feature("docstring")  Arc::InfoFilter::Filter "bool
Arc::InfoFilter::Filter(XMLNode doc) const

Filter information document according to internal policies.

In provided document all policies and nodes which have their policies
evaluated to negative result are removed. ";

%feature("docstring")  Arc::InfoFilter::Filter "bool
Arc::InfoFilter::Filter(XMLNode doc, const InfoFilterPolicies
&policies, const NS &ns) const

Filter information document according to internal and external
policies.

In provided document all policies and nodes which have their policies
evaluated to negative result are removed. External policies are
provided in policies argument. First element of every pair is XPath
defining to which XML node policy must be applied. Second element is
policy itself. Argument ns defines XML namespaces for XPath
evaluation. ";


// File: classArc_1_1InfoRegister.xml
%feature("docstring") Arc::InfoRegister "

Registration to ISIS interface.

This class represents service registering to Information Indexing
Service. It does not perform registration itself. It only collects
configuration information. Configuration is as described in
InfoRegisterConfig.xsd for element InfoRegistration.

C++ includes: InfoRegister.h ";

%feature("docstring")  Arc::InfoRegister::InfoRegister "Arc::InfoRegister::InfoRegister(XMLNode &node, Service *service_) ";

%feature("docstring")  Arc::InfoRegister::~InfoRegister "Arc::InfoRegister::~InfoRegister() ";

%feature("docstring")  Arc::InfoRegister::getPeriod "long int
Arc::InfoRegister::getPeriod(void) const ";

%feature("docstring")  Arc::InfoRegister::getServiceID "std::string
Arc::InfoRegister::getServiceID(void) ";

%feature("docstring")  Arc::InfoRegister::getEndpoint "std::string
Arc::InfoRegister::getEndpoint(void) ";

%feature("docstring")  Arc::InfoRegister::getExpiration "std::string
Arc::InfoRegister::getExpiration(void) ";

%feature("docstring")  Arc::InfoRegister::getService "Service*
Arc::InfoRegister::getService(void) ";


// File: classArc_1_1InfoRegisterContainer.xml
%feature("docstring") Arc::InfoRegisterContainer "

Singleton class for scanning configuration and storing refernces to
registration elements.

C++ includes: InfoRegister.h ";

%feature("docstring")
Arc::InfoRegisterContainer::~InfoRegisterContainer "Arc::InfoRegisterContainer::~InfoRegisterContainer(void) ";

%feature("docstring")  Arc::InfoRegisterContainer::addRegistrar "InfoRegistrar* Arc::InfoRegisterContainer::addRegistrar(XMLNode doc)

Adds ISISes to list of handled services.

Supplied configuration document is scanned for InfoRegistrar elements
and those are turned into InfoRegistrar classes for handling
connection to ISIS service each. ";

%feature("docstring")  Arc::InfoRegisterContainer::addService "void
Arc::InfoRegisterContainer::addService(InfoRegister *reg, const
std::list< std::string > &ids, XMLNode cfg=XMLNode())

Adds service to list of handled.

This method must be called first time after last addRegistrar was
called - services will be only associated with ISISes which are
already added. Argument ids contains list of ISIS identifiers to which
service is associated. If ids is empty then service is associated to
all ISISes currently added. If argument cfg is available and no ISISes
are configured then addRegistrars is called with cfg used as
configuration document. ";

%feature("docstring")  Arc::InfoRegisterContainer::removeService "void Arc::InfoRegisterContainer::removeService(InfoRegister *reg)

This method must be called if service being destroyed. ";


// File: classArc_1_1InfoRegisters.xml
%feature("docstring") Arc::InfoRegisters "

Handling multiple registrations to ISISes.

C++ includes: InfoRegister.h ";

%feature("docstring")  Arc::InfoRegisters::InfoRegisters "Arc::InfoRegisters::InfoRegisters(XMLNode &cfg, Service *service_)

Constructor creates InfoRegister objects according to configuration.

Inside cfg elements InfoRegistration are found and for each
corresponding InfoRegister object is created. Those objects are
destroyed in destructor of this class. ";

%feature("docstring")  Arc::InfoRegisters::~InfoRegisters "Arc::InfoRegisters::~InfoRegisters(void) ";


// File: classArc_1_1InfoRegistrar.xml
%feature("docstring") Arc::InfoRegistrar "

Registration process associated with particular ISIS.

Instance of this class starts thread which takes care passing
information about associated services to ISIS service defined in
configuration. Configuration is as described in InfoRegister.xsd for
element InfoRegistrar.

C++ includes: InfoRegister.h ";

%feature("docstring")  Arc::InfoRegistrar::~InfoRegistrar "Arc::InfoRegistrar::~InfoRegistrar(void) ";

%feature("docstring")  Arc::InfoRegistrar::registration "void
Arc::InfoRegistrar::registration(void)

Performs registartion in a loop.

Never exits unless there is a critical error or requested by
destructor. ";

%feature("docstring")  Arc::InfoRegistrar::addService "bool
Arc::InfoRegistrar::addService(InfoRegister *, XMLNode &)

Adds new service to list of handled services.

Service is described by it's InfoRegister object which must be valid
as long as this object is functional. ";

%feature("docstring")  Arc::InfoRegistrar::removeService "bool
Arc::InfoRegistrar::removeService(InfoRegister *)

Removes service from list of handled services. ";

%feature("docstring")  Arc::InfoRegistrar::id "const std::string&
Arc::InfoRegistrar::id(void) ";


// File: classArc_1_1InformationContainer.xml
%feature("docstring") Arc::InformationContainer "

Information System document container and processor.

This class inherits form InformationInterface and offers container for
storing informational XML document.

C++ includes: InformationInterface.h ";

%feature("docstring")  Arc::InformationContainer::InformationContainer
"Arc::InformationContainer::InformationContainer(void) ";

%feature("docstring")  Arc::InformationContainer::InformationContainer
"Arc::InformationContainer::InformationContainer(XMLNode doc, bool
copy=false)

Creates an instance with XML document . If  is true this method makes
a copy of  for internal use. ";

%feature("docstring")
Arc::InformationContainer::~InformationContainer "virtual
Arc::InformationContainer::~InformationContainer(void) ";

%feature("docstring")  Arc::InformationContainer::Acquire "XMLNode
Arc::InformationContainer::Acquire(void)

Get a lock on contained XML document. To be used in multi-threaded
environment. Do not forget to release it with Release() ";

%feature("docstring")  Arc::InformationContainer::Release "void
Arc::InformationContainer::Release(void) ";

%feature("docstring")  Arc::InformationContainer::Assign "void
Arc::InformationContainer::Assign(XMLNode doc, bool copy=false)

Replaces internal XML document with . If  is true this method makes a
copy of  for internal use. ";


// File: classArc_1_1InformationInterface.xml
%feature("docstring") Arc::InformationInterface "

Information System message processor.

This class provides callback for 2 operations of WS-ResourceProperties
and convenient parsing/generation of corresponding SOAP mesages. In a
future it may extend range of supported specifications.

C++ includes: InformationInterface.h ";

%feature("docstring")  Arc::InformationInterface::InformationInterface
"Arc::InformationInterface::InformationInterface(bool safe=true)

Constructor. If 'safe' is true all calls to Get will be locked. ";

%feature("docstring")
Arc::InformationInterface::~InformationInterface "virtual
Arc::InformationInterface::~InformationInterface(void) ";

%feature("docstring")  Arc::InformationInterface::Process "SOAPEnvelope* Arc::InformationInterface::Process(SOAPEnvelope &in) ";

%feature("docstring")  Arc::InformationInterface::Process "SOAPEnvelope* Arc::InformationInterface::Process(SOAPEnvelope &in,
const InfoFilter &filter, const InfoFilterPolicies
&policies=InfoFilterPolicies(), const NS &ns=NS()) ";


// File: classArc_1_1InformationRequest.xml
%feature("docstring") Arc::InformationRequest "

Request for information in InfoSystem.

This is a convenience wrapper creating proper WS-ResourceProperties
request targeted InfoSystem interface of service.

C++ includes: InformationInterface.h ";

%feature("docstring")  Arc::InformationRequest::InformationRequest "Arc::InformationRequest::InformationRequest(void)

Dummy constructor ";

%feature("docstring")  Arc::InformationRequest::InformationRequest "Arc::InformationRequest::InformationRequest(const std::list<
std::string > &path)

Request for attribute specified by elements of path. Currently only
first element is used. ";

%feature("docstring")  Arc::InformationRequest::InformationRequest "Arc::InformationRequest::InformationRequest(const std::list<
std::list< std::string > > &paths)

Request for attribute specified by elements of paths. Currently only
first element of every path is used. ";

%feature("docstring")  Arc::InformationRequest::InformationRequest "Arc::InformationRequest::InformationRequest(XMLNode query)

Request for attributes specified by XPath query. ";

%feature("docstring")  Arc::InformationRequest::~InformationRequest "Arc::InformationRequest::~InformationRequest(void) ";

%feature("docstring")  Arc::InformationRequest::SOAP "SOAPEnvelope*
Arc::InformationRequest::SOAP(void)

Returns generated SOAP message ";


// File: classArc_1_1InformationResponse.xml
%feature("docstring") Arc::InformationResponse "

Informational response from InfoSystem.

This is a convenience wrapper analyzing WS-ResourceProperties response
from InfoSystem interface of service.

C++ includes: InformationInterface.h ";

%feature("docstring")  Arc::InformationResponse::InformationResponse "Arc::InformationResponse::InformationResponse(SOAPEnvelope &soap)

Constructor parses WS-ResourceProperties ressponse. Provided
SOAPEnvelope object must be valid as long as this object is in use. ";

%feature("docstring")  Arc::InformationResponse::~InformationResponse
"Arc::InformationResponse::~InformationResponse(void) ";

%feature("docstring")  Arc::InformationResponse::Result "std::list<XMLNode> Arc::InformationResponse::Result(void)

Returns set of attributes which were in SOAP message passed to
constructor. ";


// File: classArc_1_1IniConfig.xml
%feature("docstring") Arc::IniConfig "";

%feature("docstring")  Arc::IniConfig::IniConfig "Arc::IniConfig::IniConfig() ";

%feature("docstring")  Arc::IniConfig::IniConfig "Arc::IniConfig::IniConfig(const std::string &filename) ";

%feature("docstring")  Arc::IniConfig::~IniConfig "Arc::IniConfig::~IniConfig() ";

%feature("docstring")  Arc::IniConfig::Evaluate "bool
Arc::IniConfig::Evaluate(Config &cfg) ";


// File: classArc_1_1initializeCredentialsType.xml
%feature("docstring") Arc::initializeCredentialsType "";

%feature("docstring")
Arc::initializeCredentialsType::initializeCredentialsType "Arc::initializeCredentialsType::initializeCredentialsType(void) ";

%feature("docstring")
Arc::initializeCredentialsType::initializeCredentialsType "Arc::initializeCredentialsType::initializeCredentialsType(initializeType
v) ";


// File: classArcSec_1_1InRangeFunction.xml
%feature("docstring") ArcSec::InRangeFunction "";

%feature("docstring")  ArcSec::InRangeFunction::InRangeFunction "ArcSec::InRangeFunction::InRangeFunction(std::string functionName,
std::string argumentType) ";

%feature("docstring")  ArcSec::InRangeFunction::evaluate "virtual
AttributeValue* ArcSec::InRangeFunction::evaluate(AttributeValue
*arg0, AttributeValue *arg1, bool check_id=true)

Evaluate two AttributeValue objects, and return one AttributeValue
object ";

%feature("docstring")  ArcSec::InRangeFunction::evaluate "virtual
std::list<AttributeValue*>
ArcSec::InRangeFunction::evaluate(std::list< AttributeValue * > args,
bool check_id=true)

Evaluate a list of AttributeValue objects, and return a list of
Attribute objects ";


// File: classArc_1_1IntraProcessCounter.xml
%feature("docstring") Arc::IntraProcessCounter "

A class for counters used by threads within a single process.

This is a class for shared among different threads within a single
process. See the Counter class for further information about counters
and examples of usage.

C++ includes: IntraProcessCounter.h ";

%feature("docstring")  Arc::IntraProcessCounter::IntraProcessCounter "Arc::IntraProcessCounter::IntraProcessCounter(int limit, int excess)

Creates an IntraProcessCounter with specified limit and excess.

This constructor creates a counter with the specified limit (amount of
resources available for reservation) and excess limit (an extra amount
of resources that may be used for prioritized reservations).

Parameters:
-----------

limit:  The limit of the counter.

excess:  The excess limit of the counter. ";

%feature("docstring")  Arc::IntraProcessCounter::~IntraProcessCounter
"virtual Arc::IntraProcessCounter::~IntraProcessCounter()

Destructor.

This is the destructor of the IntraProcessCounter class. Does not need
to do anything. ";

%feature("docstring")  Arc::IntraProcessCounter::getLimit "virtual
int Arc::IntraProcessCounter::getLimit()

Returns the current limit of the counter.

This method returns the current limit of the counter, i.e. how many
units can be reserved simultaneously by different threads without
claiming high priority. The current limit of the counter. ";

%feature("docstring")  Arc::IntraProcessCounter::setLimit "virtual
int Arc::IntraProcessCounter::setLimit(int newLimit)

Sets the limit of the counter.

This method sets a new limit for the counter.

Parameters:
-----------

newLimit:  The new limit, an absolute number.

The new limit. ";

%feature("docstring")  Arc::IntraProcessCounter::changeLimit "virtual
int Arc::IntraProcessCounter::changeLimit(int amount)

Changes the limit of the counter.

Changes the limit of the counter by adding a certain amount to the
current limit.

Parameters:
-----------

amount:  The amount by which to change the limit.

The new limit. ";

%feature("docstring")  Arc::IntraProcessCounter::getExcess "virtual
int Arc::IntraProcessCounter::getExcess()

Returns the excess limit of the counter.

Returns the excess limit of the counter, i.e. by how much the usual
limit may be exceeded by prioritized reservations. The excess limit.
";

%feature("docstring")  Arc::IntraProcessCounter::setExcess "virtual
int Arc::IntraProcessCounter::setExcess(int newExcess)

Sets the excess limit of the counter.

This method sets a new excess limit for the counter.

Parameters:
-----------

newExcess:  The new excess limit, an absolute number.

The new excess limit. ";

%feature("docstring")  Arc::IntraProcessCounter::changeExcess "virtual int Arc::IntraProcessCounter::changeExcess(int amount)

Changes the excess limit of the counter.

Changes the excess limit of the counter by adding a certain amount to
the current excess limit.

Parameters:
-----------

amount:  The amount by which to change the excess limit.

The new excess limit. ";

%feature("docstring")  Arc::IntraProcessCounter::getValue "virtual
int Arc::IntraProcessCounter::getValue()

Returns the current value of the counter.

Returns the current value of the counter, i.e. the number of
unreserved units. Initially, the value is equal to the limit of the
counter. When a reservation is made, the the value is decreased.
Normally, the value should never be negative, but this may happen if
there are prioritized reservations. It can also happen if the limit is
decreased after some reservations have been made, since reservations
are never revoked. The current value of the counter. ";

%feature("docstring")  Arc::IntraProcessCounter::reserve "virtual
CounterTicket Arc::IntraProcessCounter::reserve(int amount=1,
Glib::TimeVal duration=ETERNAL, bool prioritized=false, Glib::TimeVal
timeOut=ETERNAL)

Makes a reservation from the counter.

This method makes a reservation from the counter. If the current value
of the counter is too low to allow for the reservation, the method
blocks until the reservation is possible or times out.

Parameters:
-----------

amount:  The amount to reserve, default value is 1.

duration:  The duration of a self expiring reservation, default is
that it lasts forever.

prioritized:  Whether this reservation is prioritized and thus allowed
to use the excess limit.

timeOut:  The maximum time to block if the value of the counter is too
low, default is to allow \"eternal\" blocking.

A CounterTicket that can be queried about the status of the
reservation as well as for cancellations and extensions. ";


// File: structArc_1_1ISIS__description.xml
%feature("docstring") Arc::ISIS_description "";


// File: classArc_1_1IString.xml
%feature("docstring") Arc::IString "";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const std::string &m) ";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const std::string &m, const T0 &t0) ";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const std::string &m, const T0 &t0, const T1
&t1) ";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const std::string &m, const T0 &t0, const T1
&t1, const T2 &t2) ";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const std::string &m, const T0 &t0, const T1
&t1, const T2 &t2, const T3 &t3) ";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const std::string &m, const T0 &t0, const T1
&t1, const T2 &t2, const T3 &t3, const T4 &t4) ";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const std::string &m, const T0 &t0, const T1
&t1, const T2 &t2, const T3 &t3, const T4 &t4, const T5 &t5) ";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const std::string &m, const T0 &t0, const T1
&t1, const T2 &t2, const T3 &t3, const T4 &t4, const T5 &t5, const T6
&t6) ";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const std::string &m, const T0 &t0, const T1
&t1, const T2 &t2, const T3 &t3, const T4 &t4, const T5 &t5, const T6
&t6, const T7 &t7) ";

%feature("docstring")  Arc::IString::~IString "Arc::IString::~IString() ";

%feature("docstring")  Arc::IString::IString "Arc::IString::IString(const IString &istr) ";


// File: classArc_1_1JobDescriptionParserLoader_1_1iterator.xml
%feature("docstring") Arc::JobDescriptionParserLoader::iterator "";

%feature("docstring")
Arc::JobDescriptionParserLoader::iterator::~iterator "Arc::JobDescriptionParserLoader::iterator::~iterator() ";


// File: classArc_1_1Job.xml
%feature("docstring") Arc::Job "

Job.

This class describe a Grid job. Most of the members contained in this
class are directly linked to the ComputingActivity defined in the GLUE
Specification v. 2.0 (GFD-R-P.147).

C++ includes: Job.h ";

%feature("docstring")  Arc::Job::Job "Arc::Job::Job()

Create a Job object.

Default constructor. Takes no arguments. ";

%feature("docstring")  Arc::Job::~Job "Arc::Job::~Job() ";

%feature("docstring")  Arc::Job::Job "Arc::Job::Job(const Job &job)
";

%feature("docstring")  Arc::Job::Job "Arc::Job::Job(XMLNode job) ";

%feature("docstring")  Arc::Job::Print "void Arc::Job::Print(bool
longlist) const

DEPRECATED: Print the Job information to std::cout.

This method is DEPRECATED, use the SaveToStream method instead. Method
to print the Job attributes to std::cout

Parameters:
-----------

longlist:  is boolean for long listing (more details).

See:   SaveToStream ";

%feature("docstring")  Arc::Job::SaveToStream "void
Arc::Job::SaveToStream(std::ostream &out, bool longlist) const

Write job information to a std::ostream object.

This method will write job information to the passed std::ostream
object. The longlist boolean specifies whether more (true) or less
(false) information should be printed.

Parameters:
-----------

out:  is the std::ostream object to print the attributes to.

longlist:  is a boolean for switching on long listing (more details).
";

%feature("docstring")  Arc::Job::ToXML "void Arc::Job::ToXML(XMLNode
job) const

Add job information to a XMLNode.

Child nodes of GLUE ComputingActivity type containing job information
of this object will be added to the passed XMLNode.

Parameters:
-----------

job:  is the XMLNode to add job information to in form of GLUE2
ComputingActivity type child nodes.

See:  operator= ";


// File: classArc_1_1JobController.xml
%feature("docstring") Arc::JobController "

Base class for the JobControllers.

The JobController is the base class for middleware specialized derived
classes. The JobController base class is also the implementer of all
public functionality that should be offered by the middleware specific
specializations. In other words all virtual functions of the
JobController are private. The initialization of a (specialized)
JobController object takes two steps. First the JobController
specialization for the required grid flavour must be loaded by the
JobControllerLoader, which sees to that the JobController receives
information about its Grid flavour and the local joblist file
containing information about all active jobs (flavour independent).
The next step is the filling of the JobController job pool (JobStore)
which is the pool of jobs that the JobController can manage. Must be
specialiced for each supported middleware flavour.

C++ includes: JobController.h ";

%feature("docstring")  Arc::JobController::~JobController "virtual
Arc::JobController::~JobController() ";

%feature("docstring")  Arc::JobController::FillJobStore "void
Arc::JobController::FillJobStore(const Job &job)

Fill jobstore. ";

%feature("docstring")  Arc::JobController::Get "bool
Arc::JobController::Get(const std::list< std::string > &status, const
std::string &downloaddir, const bool keep, const bool usejobname,
const bool force=true) ";

%feature("docstring")  Arc::JobController::Kill "bool
Arc::JobController::Kill(const std::list< std::string > &status, const
bool keep) ";

%feature("docstring")  Arc::JobController::Clean "bool
Arc::JobController::Clean(const std::list< std::string > &status,
const bool force) ";

%feature("docstring")  Arc::JobController::Cat "bool
Arc::JobController::Cat(const std::list< std::string > &status, const
std::string &whichfile)

DEPRECATED: Catenate a log-file to standard out.

This method is DEPRECATED, use the Cat(std::ostream&, const
std::list<std::string>&, const std::string&) instead.

This method is not supposed to be overloaded by extending classes.

Parameters:
-----------

status:  a list of strings representing states to be considered.

longlist:  a boolean indicating whether verbose job information should
be printed.

This method always returns true.

See:   Cat(std::ostream&, const std::list<std::string>&, const
std::string&)

GetJobInformation

JobState ";

%feature("docstring")  Arc::JobController::Cat "bool
Arc::JobController::Cat(std::ostream &out, const std::list<
std::string > &status, const std::string &whichfile)

Catenate a output log-file to a std::ostream object.

The method catenates one of the log-files standard out or error, or
the job log file from the CE for each of the jobs contained in this
object. A file can only be catenated if the location relative to the
session directory are set in Job::StdOut, Job::StdErr and Job::LogDir
respectively, and if supported so in the specialised ACC module. If
the status parameter is non-empty only jobs having a job status
specified in this list will considered. The whichfile parameter
specifies what log-file to catenate. Possible values are \"stdout\",
\"stderr\" and \"joblog\" respectively specifying standard out, error
and job log file.

This method is not supposed to be overloaded by extending classes.

Parameters:
-----------

status:  a list of strings representing states to be considered.

longlist:  a boolean indicating whether verbose job information should
be printed.

This method always returns true.

See:   SaveJobStatusToStream

GetJobInformation

JobState ";

%feature("docstring")  Arc::JobController::PrintJobStatus "bool
Arc::JobController::PrintJobStatus(const std::list< std::string >
&status, const bool longlist)

DEPRECATED: Print job status to std::cout.

This method is DEPRECATED, use the SaveJobStatusToStream instead.

This method is not supposed to be overloaded by extending classes.

Parameters:
-----------

status:  a list of strings representing states to be considered.

longlist:  a boolean indicating whether verbose job information should
be printed.

This method always returns true.

See:   SaveJobStatusToStream

GetJobInformation

JobState ";

%feature("docstring")  Arc::JobController::SaveJobStatusToStream "bool Arc::JobController::SaveJobStatusToStream(std::ostream &out,
const std::list< std::string > &status, bool longlist)

Print job status to a std::ostream object.

The job status is printed to a std::ostream object when calling this
method. More specifically the Job::SaveToStream method is called on
each of the Job objects stored in this object, and the boolean
argument longlist is passed directly to the method indicating whether
verbose job status should be printed. The status argument is a list of
strings each representing a job state ( JobState) which is used to
indicate that only jobs with a job state in the list should be
considered. If the list status is empty all jobs will be considered.

This method is not supposed to be overloaded by extending classes.

Parameters:
-----------

out:  a std::ostream object to direct job status information to.

status:  a list of strings representing states to be considered.

longlist:  a boolean indicating whether verbose job information should
be printed.

This method always returns true.

See:  GetJobInformation

Job::SaveToStream

JobState ";

%feature("docstring")  Arc::JobController::Migrate "bool
Arc::JobController::Migrate(TargetGenerator &targetGen, Broker
*broker, const UserConfig &usercfg, const bool forcemigration,
std::list< URL > &migratedJobIDs)

Migrate job from cluster A to Cluster B.

Method to migrate the jobs contained in the jobstore.

Parameters:
-----------

targetGen:   TargetGenerator with targets to migrate the job to.

broker:   Broker to be used when selecting target.

forcemigration:  boolean which specifies whether a migrated job should
persist if the new cluster does not succeed sending a kill/terminate
request for the job. ";

%feature("docstring")  Arc::JobController::Renew "bool
Arc::JobController::Renew(const std::list< std::string > &status) ";

%feature("docstring")  Arc::JobController::Resume "bool
Arc::JobController::Resume(const std::list< std::string > &status) ";

%feature("docstring")  Arc::JobController::GetDownloadFiles "std::list<std::string> Arc::JobController::GetDownloadFiles(const URL
&dir) ";

%feature("docstring")  Arc::JobController::ARCCopyFile "bool
Arc::JobController::ARCCopyFile(const URL &src, const URL &dst) ";

%feature("docstring")  Arc::JobController::GetJobDescriptions "std::list<Job> Arc::JobController::GetJobDescriptions(const std::list<
std::string > &status, const bool getlocal) ";

%feature("docstring")  Arc::JobController::FetchJobs "void
Arc::JobController::FetchJobs(const std::list< std::string > &status,
std::vector< const Job * > &jobs) ";

%feature("docstring")  Arc::JobController::GetJobs "const
std::list<Job>& Arc::JobController::GetJobs() const ";

%feature("docstring")  Arc::JobController::GetJobInformation "virtual
void Arc::JobController::GetJobInformation()=0 ";

%feature("docstring")  Arc::JobController::GetJob "virtual bool
Arc::JobController::GetJob(const Job &job, const std::string
&downloaddir, const bool usejobname, const bool force)=0 ";

%feature("docstring")  Arc::JobController::CleanJob "virtual bool
Arc::JobController::CleanJob(const Job &job)=0 ";

%feature("docstring")  Arc::JobController::CancelJob "virtual bool
Arc::JobController::CancelJob(const Job &job)=0 ";

%feature("docstring")  Arc::JobController::RenewJob "virtual bool
Arc::JobController::RenewJob(const Job &job)=0 ";

%feature("docstring")  Arc::JobController::ResumeJob "virtual bool
Arc::JobController::ResumeJob(const Job &job)=0 ";

%feature("docstring")  Arc::JobController::GetFileUrlForJob "virtual
URL Arc::JobController::GetFileUrlForJob(const Job &job, const
std::string &whichfile)=0 ";

%feature("docstring")  Arc::JobController::GetJobDescription "virtual
bool Arc::JobController::GetJobDescription(const Job &job, std::string
&desc_str)=0 ";

%feature("docstring")  Arc::JobController::CreateURL "virtual URL
Arc::JobController::CreateURL(std::string service, ServiceType st)=0
";


// File: classArc_1_1JobControllerLoader.xml
%feature("docstring") Arc::JobControllerLoader "

Class responsible for loading JobController plugins The JobController
objects returned by a JobControllerLoader must not be used after the
JobControllerLoader goes out of scope.

C++ includes: JobController.h ";

%feature("docstring")  Arc::JobControllerLoader::JobControllerLoader "Arc::JobControllerLoader::JobControllerLoader()

Constructor Creates a new JobControllerLoader. ";

%feature("docstring")  Arc::JobControllerLoader::~JobControllerLoader
"Arc::JobControllerLoader::~JobControllerLoader()

Destructor Calling the destructor destroys all JobControllers loaded
by the JobControllerLoader instance. ";

%feature("docstring")  Arc::JobControllerLoader::load "JobController*
Arc::JobControllerLoader::load(const std::string &name, const
UserConfig &usercfg)

Load a new JobController

Parameters:
-----------

name:  The name of the JobController to load.

usercfg:  The UserConfig object for the new JobController.

A pointer to the new JobController (NULL on error). ";

%feature("docstring")  Arc::JobControllerLoader::GetJobControllers "const std::list<JobController*>&
Arc::JobControllerLoader::GetJobControllers() const

Retrieve the list of loaded JobControllers. A reference to the list of
JobControllers. ";


// File: classArc_1_1JobControllerPluginArgument.xml
%feature("docstring") Arc::JobControllerPluginArgument "";

%feature("docstring")
Arc::JobControllerPluginArgument::JobControllerPluginArgument "Arc::JobControllerPluginArgument::JobControllerPluginArgument(const
UserConfig &usercfg) ";

%feature("docstring")
Arc::JobControllerPluginArgument::~JobControllerPluginArgument "Arc::JobControllerPluginArgument::~JobControllerPluginArgument() ";


// File: classArc_1_1JobDescription.xml
%feature("docstring") Arc::JobDescription "";

%feature("docstring")  Arc::JobDescription::JobDescription "Arc::JobDescription::JobDescription() ";

%feature("docstring")  Arc::JobDescription::JobDescription "Arc::JobDescription::JobDescription(const JobDescription &j, bool
withAlternatives=true) ";

%feature("docstring")  Arc::JobDescription::JobDescription "Arc::JobDescription::JobDescription(const long int &ptraddr) ";

%feature("docstring")  Arc::JobDescription::~JobDescription "Arc::JobDescription::~JobDescription() ";

%feature("docstring")  Arc::JobDescription::AddAlternative "void
Arc::JobDescription::AddAlternative(const JobDescription &j) ";

%feature("docstring")  Arc::JobDescription::HasAlternatives "bool
Arc::JobDescription::HasAlternatives() const ";

%feature("docstring")  Arc::JobDescription::GetAlternatives "const
std::list<JobDescription>& Arc::JobDescription::GetAlternatives()
const ";

%feature("docstring")  Arc::JobDescription::GetAlternatives "std::list<JobDescription>& Arc::JobDescription::GetAlternatives() ";

%feature("docstring")  Arc::JobDescription::GetAlternativesCopy "std::list<JobDescription> Arc::JobDescription::GetAlternativesCopy()
const ";

%feature("docstring")  Arc::JobDescription::UseAlternative "bool
Arc::JobDescription::UseAlternative() ";

%feature("docstring")  Arc::JobDescription::UseOriginal "void
Arc::JobDescription::UseOriginal() ";

%feature("docstring")  Arc::JobDescription::RemoveAlternatives "void
Arc::JobDescription::RemoveAlternatives() ";

%feature("docstring")  Arc::JobDescription::Parse "bool
Arc::JobDescription::Parse(const std::string &source, const
std::string &language=\"\", const std::string &dialect=\"\")

DEPRECATED: Parse source string.

This method is deprecated, use the Parse(const std::string&,
std::list<JobDescription>&, const std::string&, const std::string&)
method instead. ";

%feature("docstring")  Arc::JobDescription::Parse "bool
Arc::JobDescription::Parse(const XMLNode &xmlSource)

DEPRECATED: Parse source string.

This method is deprecated, use the Parse(const std::string&,
std::list<JobDescription>&, const std::string&, const std::string&)
method instead. ";

%feature("docstring")  Arc::JobDescription::UnParse "std::string
Arc::JobDescription::UnParse(const std::string
&language=\"nordugrid:jsdl\") const

DEPRECATED: Output contents in the specified language.

This method is deprecated, use the UnParse(std::string&, std::string,
const std::string&) method instead. ";

%feature("docstring")  Arc::JobDescription::UnParse "bool
Arc::JobDescription::UnParse(std::string &product, std::string
language, const std::string &dialect=\"\") const

Output contents in the specified language.

Parameters:
-----------

product:

language:

dialect:  ";

%feature("docstring")  Arc::JobDescription::GetSourceLanguage "const
std::string& Arc::JobDescription::GetSourceLanguage() const

Get input source language.

If this object was created by a JobDescriptionParser, then this method
returns a string which indicates the job description language of the
parsed source. If not created by a JobDescripionParser the string
returned is empty.

const std::string& source langauge of parsed input source. ";

%feature("docstring")  Arc::JobDescription::Print "void
Arc::JobDescription::Print(bool longlist=false) const

DEPRECATED: Print all values to standard output.

This method is DEPRECATED, use the SaveToStream method instead.

Parameters:
-----------

longlist:

See:   SaveToStream ";

%feature("docstring")  Arc::JobDescription::SaveToStream "bool
Arc::JobDescription::SaveToStream(std::ostream &out, const std::string
&format) const

Print job description to a std::ostream object.

The job description will be written to the passed std::ostream object
out in the format indicated by the format parameter. The format
parameter should specify the format of one of the job description
languages supported by the library. Or by specifying the special
\"user\" or \"userlong\" format the job description will be written as
a attribute/value pair list with respectively less or more attributes.

The mote

true if writing the job description to the out object succeeds,
otherwise false.

Parameters:
-----------

out:  a std::ostream reference specifying the ostream to write the job
description to.

format:  specifies the format the job description should written in.
";


// File: classArc_1_1JobDescriptionParser.xml
%feature("docstring") Arc::JobDescriptionParser "";

%feature("docstring")
Arc::JobDescriptionParser::~JobDescriptionParser "virtual
Arc::JobDescriptionParser::~JobDescriptionParser() ";

%feature("docstring")  Arc::JobDescriptionParser::Parse "virtual bool
Arc::JobDescriptionParser::Parse(const std::string &source, std::list<
JobDescription > &jobdescs, const std::string &language=\"\", const
std::string &dialect=\"\") const =0 ";

%feature("docstring")  Arc::JobDescriptionParser::UnParse "virtual
bool Arc::JobDescriptionParser::UnParse(const JobDescription &job,
std::string &output, const std::string &language, const std::string
&dialect=\"\") const =0 ";

%feature("docstring")
Arc::JobDescriptionParser::GetSupportedLanguages "const
std::list<std::string>&
Arc::JobDescriptionParser::GetSupportedLanguages() const ";

%feature("docstring")  Arc::JobDescriptionParser::IsLanguageSupported
"bool Arc::JobDescriptionParser::IsLanguageSupported(const
std::string &language) const ";


// File: classArc_1_1JobDescriptionParserLoader.xml
%feature("docstring") Arc::JobDescriptionParserLoader "

Class responsible for loading JobDescriptionParser plugins The
JobDescriptionParser objects returned by a JobDescriptionParserLoader
must not be used after the JobDescriptionParserLoader goes out of
scope.

C++ includes: JobDescriptionParser.h ";

%feature("docstring")
Arc::JobDescriptionParserLoader::JobDescriptionParserLoader "Arc::JobDescriptionParserLoader::JobDescriptionParserLoader()

Constructor Creates a new JobDescriptionParserLoader. ";

%feature("docstring")
Arc::JobDescriptionParserLoader::~JobDescriptionParserLoader "Arc::JobDescriptionParserLoader::~JobDescriptionParserLoader()

Destructor Calling the destructor destroys all JobDescriptionParser
object loaded by the JobDescriptionParserLoader instance. ";

%feature("docstring")  Arc::JobDescriptionParserLoader::load "JobDescriptionParser* Arc::JobDescriptionParserLoader::load(const
std::string &name)

Load a new JobDescriptionParser

Parameters:
-----------

name:  The name of the JobDescriptionParser to load.

A pointer to the new JobDescriptionParser (NULL on error). ";

%feature("docstring")
Arc::JobDescriptionParserLoader::GetJobDescriptionParsers "const
std::list<JobDescriptionParser*>&
Arc::JobDescriptionParserLoader::GetJobDescriptionParsers() const

Retrieve the list of loaded JobDescriptionParser objects. A reference
to the list of JobDescriptionParser objects. ";

%feature("docstring")  Arc::JobDescriptionParserLoader::GetIterator "iterator Arc::JobDescriptionParserLoader::GetIterator() ";


// File: classArc_1_1JobIdentificationType.xml
%feature("docstring") Arc::JobIdentificationType "";

%feature("docstring")
Arc::JobIdentificationType::JobIdentificationType "Arc::JobIdentificationType::JobIdentificationType() ";


// File: classArc_1_1JobState.xml
%feature("docstring") Arc::JobState "

ARC general state model. The class comprise the general state model of
the ARC-lib, and are herein used to compare job states from the
different middlewares supported by the plugin structure of the ARC-
lib. Which is why every ACC plugin should contain a class derived from
this class. The derived class should consist of a constructor and a
mapping function (a JobStateMap) which maps a std::string to a
JobState:StateType. An example of a constructor in a plugin could be:
JobStatePlugin::JobStatePluging(const std::string& state) :
JobState(state, &pluginStateMap) {} where &pluginStateMap is a
reference to the JobStateMap defined by the derived class.

C++ includes: JobState.h ";

%feature("docstring")  Arc::JobState::JobState "Arc::JobState::JobState() ";

%feature("docstring")  Arc::JobState::IsFinished "bool
Arc::JobState::IsFinished() const

Check if state is finished.

true is returned if the StateType is equal to FINISHED, KILLED, FAILED
or DELETED, otherwise false is returned. ";

%feature("docstring")  Arc::JobState::GetGeneralState "const
std::string& Arc::JobState::GetGeneralState() const ";


// File: classArc_1_1JobSupervisor.xml
%feature("docstring") Arc::JobSupervisor "

% JobSupervisor class

The JobSupervisor class is tool for loading JobController plugins for
managing Grid jobs.

C++ includes: JobSupervisor.h ";

%feature("docstring")  Arc::JobSupervisor::JobSupervisor "Arc::JobSupervisor::JobSupervisor(const UserConfig &usercfg, const
std::list< std::string > &jobs)

Create a JobSupervisor object.

Default constructor to create a JobSupervisor. Automatically loads
JobController plugins based upon the input jobids.

Parameters:
-----------

usercfg:  Reference to UserConfig object with information about user
credentials and joblistfile.

jobs:  List of jobs(jobid or job name) to be managed. ";

%feature("docstring")  Arc::JobSupervisor::JobSupervisor "Arc::JobSupervisor::JobSupervisor(const UserConfig &usercfg, const
std::list< Job > &jobs)

Create a JobSupervisor.

The list of Job objects passed to the constructor will be managed by
this JobSupervisor, through the JobController class. It is important
that the Flavour member of each Job object is set and correspond to
the JobController plugin which are capable of managing that specific
job. The JobController plugin will be loaded using the
JobControllerLoader class, loading a plugin of type
\"HED:JobController\" and name specified by the Flavour member, and
the a reference to the UserConfig object usercfg will be passed to the
plugin. Additionally a reference to the UserConfig object usercfg will
be stored, thus usercfg must exist throughout the scope of the created
object. If the Flavour member of a Job object is unset, a VERBOSE log
message will be reported and that Job object will be ignored. If the
JobController plugin for a given Flavour cannot be loaded, a WARNING
log message will be reported and any Job object with that Flavour will
be ignored. If loading of a specific plugin failed, that plugin will
not be tried loaded for subsequent Job objects requiring that plugin.
Job objects, for which the corresponding JobController plugin loaded
successfully, will be added to that plugin using the
JobController::FillJobStore(const Job&) method.

Parameters:
-----------

usercfg:   UserConfig object to pass to JobController plugins and to
use in member methods.

jobs:  List of Job objects which will be managed by the created
object. ";

%feature("docstring")  Arc::JobSupervisor::~JobSupervisor "Arc::JobSupervisor::~JobSupervisor() ";

%feature("docstring")  Arc::JobSupervisor::AddJob "bool
Arc::JobSupervisor::AddJob(const Job &job) ";

%feature("docstring")  Arc::JobSupervisor::Resubmit "bool
Arc::JobSupervisor::Resubmit(const std::list< std::string >
&statusfilter, int destination, std::list< Job > &resubmittedJobs,
std::list< URL > &notresubmitted)

Resubmit jobs.

Jobs managed by this JobSupervisor will be resubmitted when invoking
this method, that is the job description of a job will be tried
obtained, and if successful a new job will be submitted.

Before identifying jobs to be resubmitted, the
JobController::GetJobInformation method is called for each loaded
JobController in order to retrieve the most up to date job
information. If an empty status-filter is specified, all jobs managed
by this JobSupervisor will be considered for resubmission, except jobs
in the undefined state (see JobState). If the status-filter is not
empty, then only jobs with a general or specific state (see JobState)
identical to any of the entries in the status-filter will be
considered, except jobs in the undefined state. Jobs for which a job
description cannot be obtained and successfully parsed will not be
considered and an ERROR log message is reported, and the
IDFromEndpoint URL is appended to the notresubmitted list. Job
descriptions will be tried obtained either from Job object itself, or
fetching them remotely. Furthermore if a Job object has the
LocalInputFiles object set, then the checksum of each of the local
input files specified in that object (key) will be calculated and
verified to match the checksum LocalInputFiles object (value). If
checksums are not matching the job will be filtered, and an ERROR log
message is reported and the IDFromEndpoint URL is appended to the
notresubmitted list. If no job have been identified for resubmission,
false will be returned if ERRORs were reported, otherwise true is
returned.

The destination for jobs is partly determined by the destination
parameter. If a value of 1 is specified a job will only be targeted to
the execution service (ES) on which it reside. A value of 2 indicates
that a job should not be targeted to the ES it currently reside.
Specifying any other value will target any ES. The ESs which can be
targeted are those specified in the UserConfig object of this class,
as selected services. Before initiating any job submission, resource
discovery and broker loading is carried out using the TargetGenerator
and Broker classes, initialised by the UserConfig object of this
class. If Broker loading fails, or no ExecutionTargets are found, an
ERROR log message is reported and all IDFromEndpoint URLs for job
considered for resubmission will be appended to the notresubmitted
list and then false will be returned.

When the above checks have been carried out successfully, then the
Broker::Submit method will be invoked for each considered for
resubmission. If it fails the IDFromEndpoint URL for the job is
appended to the notresubmitted list, and an ERROR is reported. If
submission succeeds the new job represented by a Job object will be
appended to the resubmittedJobs list - it will not be added to this
JobSupervisor. The method returns false if ERRORs were reported
otherwise true is returned.

Parameters:
-----------

statusfilter:  list of job status used for filtering jobs.

destination:  specifies how target destination should be determined (1
= same target, 2 = not same, any other = any target).

resubmittedJobs:  list of Job objects which resubmitted jobs will be
appended to.

notresubmitted:  list of URL objects which the IDFromEndpoint URL will
be appended to.

false if any error is encountered, otherwise true. ";

%feature("docstring")  Arc::JobSupervisor::Migrate "bool
Arc::JobSupervisor::Migrate(bool forcemigration, std::list< Job >
&migratedJobs, std::list< URL > &notmigrated)

Migrate jobs.

Jobs managed by this JobSupervisor will be migrated when invoking this
method, that is the job description of a job will be tried obtained,
and if successful a job migration request will be sent, based on that
job description.

Before identifying jobs to be migrated, the
JobController::GetJobInformation method is called for each loaded
JobController in order to retrieve the most up to date job
information. Only jobs for which the State member of the Job object
has the value JobState::QUEUEING, will be considered for migration.
Furthermore the job description must be obtained (either locally or
remote) and successfully parsed in order for a job to be migrated. If
the job description cannot be obtained or parsed an ERROR log message
is reported, and the IDFromEndpoint URL of the Job object is appended
to the notmigrated list. If no jobs have been identified for
migration, false will be returned in case ERRORs were reported,
otherwise true is returned.

The execution services which can be targeted for migration are those
specified in the UserConfig object of this class, as selected
services. Before initiating any job migration request, resource
discovery and broker* loading is carried out using the TargetGenerator
and Broker classes, initialised by the UserConfig object of this
class. If Broker loading fails, or no ExecutionTargets are found, an
ERROR log message is reported and all IDFromEndpoint URLs for job
considered for migration will be appended to the notmigrated list and
then false will be returned.

When the above checks have been carried out successfully, the
following is done for each job considered for migration. The
ActivityOldId member of the Identification member in the job
description will be set to that of the Job object, and the
IDFromEndpoint URL will be appended to ActivityOldId member of the job
description. After that the Broker object will be used to find a
suitable ExecutionTarget object, and if found a migrate request will
tried sent using the ExecutionTarget::Migrate method, passing the
UserConfig object of this class. The passed forcemigration boolean
indicates whether the migration request at the service side should
ignore failures in cancelling the existing queuing job. If the request
succeeds, the corresponding new Job object is appended to the
migratedJobs list. If no suitable ExecutionTarget objects are found an
ERROR log message is reported and the IDFromEndpoint URL of the Job
object is appended to the notmigrated list. When all jobs have been
processed, false is returned if any ERRORs were reported, otherwise
true.

Parameters:
-----------

forcemigration:  indicates whether migration should succeed if service
fails to cancel the existing queuing job.

migratedJobs:  list of Job objects which migrated jobs will be
appended to.

notmigrated:  list of URL objects which the IDFromEndpoint URL will be
appended to.

false if any error is encountered, otherwise true. ";

%feature("docstring")  Arc::JobSupervisor::Cancel "std::list<URL>
Arc::JobSupervisor::Cancel(const std::list< URL > &jobids, std::list<
URL > &notcancelled)

Cancel jobs.

This method will request cancellation of jobs, identified by their
IDFromEndpoint member, for which that URL is equal to any in the
jobids list. Only jobs corresponding to a Job object managed by this
JobSupervisor will be considered for cancellation. Job objects not in
a valid state (see JobState) will not be considered, and the
IDFromEndpoint URLs of those objects will be appended to the
notcancelled URL list. For jobs not in a finished state (see
JobState::IsFinished), the JobController::Cancel method will be
called, passing the corresponding Job object, in order to cancel the
job. If the JobController::Cancel call succeeds or if the job is in a
finished state the IDFromEndpoint URL will be appended to the list to
be returned. If the JobController::Cancel call fails the
IDFromEndpoint URL is appended to the notkilled URL list.

Note: If there is any URL in the jobids list for which there is no
corresponding Job object, then the size of the returned list plus the
size of the notcancelled list will not equal that of the jobids list.

Parameters:
-----------

jobids:  List of Job::IDFromEndpoint URL objects for which a
corresponding job, managed by this JobSupervisor should be cancelled.

notcancelled:  List of Job::IDFromEndpoint URL objects for which the
corresponding job were not cancelled.

The list of Job::IDFromEndpoint URL objects of successfully cancelled
or finished jobs is returned. ";

%feature("docstring")  Arc::JobSupervisor::Clean "std::list<URL>
Arc::JobSupervisor::Clean(const std::list< URL > &jobids, std::list<
URL > &notcleaned)

Clean jobs.

This method will request cleaning of jobs, identified by their
IDFromEndpoint member, for which that URL is equal to any in the
jobids list. Only jobs corresponding to a Job object managed by this
JobSupervisor will be considered for cleaning. Job objects not in a
valid state (see JobState) will not be considered, and the
IDFromEndpoint URLs of those objects will be appended to the
notcleaned URL list, otherwise the JobController::Clean method will be
called, passing the corresponding Job object, in order to clean the
job. If that method fails the IDFromEndpoint URL of the Job object
will be appended to the notcleaned URL list, and if it succeeds the
IDFromEndpoint URL will be appended to the list of URL objects to be
returned.

Note: If there is any URL in the jobids list for which there is no
corresponding Job object, then the size of the returned list plus the
size of the notcleaned list will not equal that of the jobids list.

Parameters:
-----------

jobids:  List of Job::IDFromEndpoint URL objects for which a
corresponding job, managed by this JobSupervisor should be cleaned.

notcleaned:  List of Job::IDFromEndpoint URL objects for which the
corresponding job were not cleaned.

The list of Job::IDFromEndpoint URL objects of successfully cleaned
jobs is returned. ";

%feature("docstring")  Arc::JobSupervisor::GetJobControllers "const
std::list<JobController*>& Arc::JobSupervisor::GetJobControllers()

Get list of JobControllers.

Method to get the list of JobControllers loaded by constructor. ";

%feature("docstring")  Arc::JobSupervisor::JobsFound "bool
Arc::JobSupervisor::JobsFound() const ";


// File: classArc_1_1LoadableModuleDesciption.xml
%feature("docstring") Arc::LoadableModuleDesciption "";

%feature("docstring")
Arc::LoadableModuleDesciption::LoadableModuleDesciption "Arc::LoadableModuleDesciption::LoadableModuleDesciption(void) ";

%feature("docstring")
Arc::LoadableModuleDesciption::LoadableModuleDesciption "Arc::LoadableModuleDesciption::LoadableModuleDesciption(Glib::Module
*m) ";

%feature("docstring")  Arc::LoadableModuleDesciption::load "int
Arc::LoadableModuleDesciption::load(void) ";

%feature("docstring")  Arc::LoadableModuleDesciption::unload "int
Arc::LoadableModuleDesciption::unload(void) ";

%feature("docstring")  Arc::LoadableModuleDesciption::makePersistent "void Arc::LoadableModuleDesciption::makePersistent(void) ";


// File: classArc_1_1Loader.xml
%feature("docstring") Arc::Loader "

Plugins loader.

This class processes XML configration and loads specified plugins.
Accepted configuration is defined by XML schema mcc.xsd. \"Plugins\"
elements are parsed by this class and corresponding libraries are
loaded.

C++ includes: Loader.h ";

%feature("docstring")  Arc::Loader::Loader "Arc::Loader::Loader() ";

%feature("docstring")  Arc::Loader::Loader "Arc::Loader::Loader(XMLNode cfg)

Constructor that takes whole XML configuration and performs common
configuration part ";

%feature("docstring")  Arc::Loader::~Loader "Arc::Loader::~Loader()

Destructor destroys all components created by constructor ";


// File: classArc_1_1LogDestination.xml
%feature("docstring") Arc::LogDestination "

A base class for log destinations.

This class defines an interface for LogDestinations. LogDestination
objects will typically contain synchronization mechanisms and should
therefore never be copied.

C++ includes: Logger.h ";

%feature("docstring")  Arc::LogDestination::log "virtual void
Arc::LogDestination::log(const LogMessage &message)=0

Logs a LogMessage to this LogDestination. ";

%feature("docstring")  Arc::LogDestination::~LogDestination "virtual
Arc::LogDestination::~LogDestination() ";

%feature("docstring")  Arc::LogDestination::setFormat "void
Arc::LogDestination::setFormat(const LogFormat &newformat) ";


// File: classArc_1_1LogFile.xml
%feature("docstring") Arc::LogFile "

A class for logging to files.

This class is used for logging to files. It provides synchronization
in order to prevent different LogMessages to appear mixed with each
other in the stream. It is possible to limit size of created file.
Whenever specified size is exceeded fiel is deleted and new one is
created. Old files may be moved into backup files instead of being
deleted. Those files have names same as initial file with additional
number suffix - similar to those found in /var/log of many Unix-like
systems.

C++ includes: Logger.h ";

%feature("docstring")  Arc::LogFile::LogFile "Arc::LogFile::LogFile(const std::string &path)

Creates a LogFile connected to a file.

Creates a LogFile connected to the file located at specified path. In
order not to break synchronization, it is important not to connect
more than one LogFile object to a certain file. If file does not exist
it will be created.

Parameters:
-----------

path:  The path to file to which to write LogMessages. ";

%feature("docstring")  Arc::LogFile::LogFile "Arc::LogFile::LogFile(const std::string &path, const std::string
&locale)

Creates a LogFile connected to a file.

Creates a LogFile connected to the file located at specified path. The
output will be localised to the specified locale. ";

%feature("docstring")  Arc::LogFile::setMaxSize "void
Arc::LogFile::setMaxSize(int newsize)

Set maximal allowed size of file.

Set maximal allowed size of file. This value is not obeyed exactly.
Spesified size may be exceeded by amount of one LogMessage. To disable
limit specify -1.

Parameters:
-----------

newsize:  Max size of log file. ";

%feature("docstring")  Arc::LogFile::setBackups "void
Arc::LogFile::setBackups(int newbackup)

Set number of backups to store.

Set number of backups to store. When file size exceeds one specified
with setMaxSize() file is closed and moved to one named path.1. If
path.1 exists it is moved to path.2 and so on. Number of path.# files
is one set in newbackup.

Parameters:
-----------

newbackup:  Number of backup files. ";

%feature("docstring")  Arc::LogFile::setReopen "void
Arc::LogFile::setReopen(bool newreopen)

Set file reopen on every write.

Set file reopen on every write. If set to true file is opened before
writing every log record and closed afterward.

Parameters:
-----------

newreopen:  If file to be reopened for every log record. ";

%feature("docstring")  Arc::LogFile::log "virtual void
Arc::LogFile::log(const LogMessage &message)

Writes a LogMessage to the file.

This method writes a LogMessage to the file that is connected to this
LogFile object. If after writitng size of file exceeds one set by
setMaxSize() file is moved to backup and new one is created.

Parameters:
-----------

message:  The LogMessage to write. ";


// File: classArc_1_1Logger.xml
%feature("docstring") Arc::Logger "

A logger class.

This class defines a Logger to which LogMessages can be sent.

Every Logger (except for the rootLogger) has a parent Logger. The
domain of a Logger (a string that indicates the origin of LogMessages)
is composed by adding a subdomain to the domain of its parent Logger.

A Logger also has a threshold. Every LogMessage that have a level that
is greater than or equal to the threshold is forwarded to any
LogDestination connected to this Logger as well as to the parent
Logger.

Typical usage of the Logger class is to declare a global Logger object
for each library/module/component to be used by all classes and
methods there.

C++ includes: Logger.h ";

%feature("docstring")  Arc::Logger::Logger "Arc::Logger::Logger(Logger &parent, const std::string &subdomain)

Creates a logger.

Creates a logger. The threshold is inherited from its parent Logger.

Parameters:
-----------

parent:  The parent Logger of the new Logger.

subdomain:  The subdomain of the new logger. ";

%feature("docstring")  Arc::Logger::Logger "Arc::Logger::Logger(Logger &parent, const std::string &subdomain,
LogLevel threshold)

Creates a logger.

Creates a logger.

Parameters:
-----------

parent:  The parent Logger of the new Logger.

subdomain:  The subdomain of the new logger.

threshold:  The threshold of the new logger. ";

%feature("docstring")  Arc::Logger::~Logger "Arc::Logger::~Logger()

Destroys a logger.

Destructor ";

%feature("docstring")  Arc::Logger::addDestination "void
Arc::Logger::addDestination(LogDestination &destination)

Adds a LogDestination.

Adds a LogDestination to which to forward LogMessages sent to this
logger (if they pass the threshold). Since LogDestinatoins should not
be copied, the new LogDestination is passed by reference and a pointer
to it is kept for later use. It is therefore important that the
LogDestination passed to this Logger exists at least as long as the
Logger iteslf. ";

%feature("docstring")  Arc::Logger::addDestinations "void
Arc::Logger::addDestinations(const std::list< LogDestination * >
&destinations)

Adds LogDestinations.

See addDestination(LogDestination& destination). ";

%feature("docstring")  Arc::Logger::getDestinations "const
std::list<LogDestination*>& Arc::Logger::getDestinations(void) const

Obtains current LogDestinations.

Returns list of pointers to LogDestination objects. Returned result
refers directly to internal member of Logger intance. Hence it should
not be used after this Logger is destroyed. ";

%feature("docstring")  Arc::Logger::removeDestinations "void
Arc::Logger::removeDestinations(void)

Removes all LogDestinations. ";

%feature("docstring")  Arc::Logger::setThreshold "void
Arc::Logger::setThreshold(LogLevel threshold)

Sets the threshold.

This method sets the threshold of the Logger. Any message sent to this
Logger that has a level below this threshold will be discarded.

Parameters:
-----------

The:  threshold ";

%feature("docstring")  Arc::Logger::getThreshold "LogLevel
Arc::Logger::getThreshold() const

Returns the threshold.

Returns the threshold. The threshold of this Logger. ";

%feature("docstring")  Arc::Logger::setThreadContext "void
Arc::Logger::setThreadContext(void)

Creates per-thread context.

Creates new context for this logger which becomes effective for
operations initiated by this thread. All new threads started by this
one will inherit new context. Context stores current threshold and
pointers to destinations. Hence new context is identical to current
one. One can modify new context using setThreshold(),
removeDestinations() and addDestination(). All such operations will
not affect old context. ";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogMessage message)

Sends a LogMessage.

Sends a LogMessage.

Parameters:
-----------

The:   LogMessage to send. ";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogLevel level, const std::string &str)

Logs a message text.

Logs a message text string at the specified LogLevel. This is a
convenience method to save some typing. It simply creates a LogMessage
and sends it to the other msg() method.

Parameters:
-----------

level:  The level of the message.

str:  The message text. ";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogLevel level, const std::string &str, const T0 &t0)
";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogLevel level, const std::string &str, const T0 &t0,
const T1 &t1) ";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogLevel level, const std::string &str, const T0 &t0,
const T1 &t1, const T2 &t2) ";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogLevel level, const std::string &str, const T0 &t0,
const T1 &t1, const T2 &t2, const T3 &t3) ";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogLevel level, const std::string &str, const T0 &t0,
const T1 &t1, const T2 &t2, const T3 &t3, const T4 &t4) ";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogLevel level, const std::string &str, const T0 &t0,
const T1 &t1, const T2 &t2, const T3 &t3, const T4 &t4, const T5 &t5)
";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogLevel level, const std::string &str, const T0 &t0,
const T1 &t1, const T2 &t2, const T3 &t3, const T4 &t4, const T5 &t5,
const T6 &t6) ";

%feature("docstring")  Arc::Logger::msg "void
Arc::Logger::msg(LogLevel level, const std::string &str, const T0 &t0,
const T1 &t1, const T2 &t2, const T3 &t3, const T4 &t4, const T5 &t5,
const T6 &t6, const T7 &t7) ";


// File: classArc_1_1LoggerContext.xml
%feature("docstring") Arc::LoggerContext "

Container for logger configuration.

C++ includes: Logger.h ";


// File: structArc_1_1LoggerFormat.xml
%feature("docstring") Arc::LoggerFormat "";

%feature("docstring")  Arc::LoggerFormat::LoggerFormat "Arc::LoggerFormat::LoggerFormat(LogFormat format) ";


// File: classArc_1_1LogMessage.xml
%feature("docstring") Arc::LogMessage "

A class for log messages.

This class is used to represent log messages internally. It contains
the time the message was created, its level, from which domain it was
sent, an identifier and the message text itself.

C++ includes: Logger.h ";

%feature("docstring")  Arc::LogMessage::LogMessage "Arc::LogMessage::LogMessage(LogLevel level, const IString &message)

Creates a LogMessage with the specified level and message text.

This constructor creates a LogMessage with the specified level and
message text. The time is set automatically, the domain is set by the
Logger to which the LogMessage is sent and the identifier is composed
from the process ID and the address of the Thread object corresponding
to the calling thread.

Parameters:
-----------

level:  The level of the LogMessage.

message:  The message text. ";

%feature("docstring")  Arc::LogMessage::LogMessage "Arc::LogMessage::LogMessage(LogLevel level, const IString &message,
const std::string &identifier)

Creates a LogMessage with the specified attributes.

This constructor creates a LogMessage with the specified level,
message text and identifier. The time is set automatically and the
domain is set by the Logger to which the LogMessage is sent.

Parameters:
-----------

level:  The level of the LogMessage.

message:  The message text.

ident:  The identifier of the LogMessage. ";

%feature("docstring")  Arc::LogMessage::getLevel "LogLevel
Arc::LogMessage::getLevel() const

Returns the level of the LogMessage.

Returns the level of the LogMessage. The level of the LogMessage. ";


// File: classArc_1_1LogStream.xml
%feature("docstring") Arc::LogStream "

A class for logging to ostreams.

This class is used for logging to ostreams (cout, cerr, files). It
provides synchronization in order to prevent different LogMessages to
appear mixed with each other in the stream. In order not to break the
synchronization, LogStreams should never be copied. Therefore the copy
constructor and assignment operator are private. Furthermore, it is
important to keep a LogStream object as long as the Logger to which it
has been registered.

C++ includes: Logger.h ";

%feature("docstring")  Arc::LogStream::LogStream "Arc::LogStream::LogStream(std::ostream &destination)

Creates a LogStream connected to an ostream.

Creates a LogStream connected to the specified ostream. In order not
to break synchronization, it is important not to connect more than one
LogStream object to a certain stream.

Parameters:
-----------

destination:  The ostream to which to erite LogMessages. ";

%feature("docstring")  Arc::LogStream::LogStream "Arc::LogStream::LogStream(std::ostream &destination, const std::string
&locale)

Creates a LogStream connected to an ostream.

Creates a LogStream connected to the specified ostream. The output
will be localised to the specified locale. ";

%feature("docstring")  Arc::LogStream::log "virtual void
Arc::LogStream::log(const LogMessage &message)

Writes a LogMessage to the stream.

This method writes a LogMessage to the ostream that is connected to
this LogStream object. It is synchronized so that not more than one
LogMessage can be written at a time.

Parameters:
-----------

message:  The LogMessage to write. ";


// File: classArc_1_1URLMap_1_1map__entry.xml


// File: classArcSec_1_1MatchFunction.xml
%feature("docstring") ArcSec::MatchFunction "

Evaluate whether arg1 (value in regular expression) matched arg0
(lable in regular expression)

C++ includes: MatchFunction.h ";

%feature("docstring")  ArcSec::MatchFunction::MatchFunction "ArcSec::MatchFunction::MatchFunction(std::string functionName,
std::string argumentType) ";

%feature("docstring")  ArcSec::MatchFunction::evaluate "virtual
AttributeValue* ArcSec::MatchFunction::evaluate(AttributeValue *arg0,
AttributeValue *arg1, bool check_id=true)

Evaluate two AttributeValue objects, and return one AttributeValue
object ";

%feature("docstring")  ArcSec::MatchFunction::evaluate "virtual
std::list<AttributeValue*> ArcSec::MatchFunction::evaluate(std::list<
AttributeValue * > args, bool check_id=true)

Evaluate a list of AttributeValue objects, and return a list of
Attribute objects ";


// File: classArc_1_1MCC.xml
%feature("docstring") Arc::MCC "

Message Chain Component - base class for every MCC plugin.

This is partialy virtual class which defines interface and common
functionality for every MCC plugin needed for managing of component in
a chain.

C++ includes: MCC.h ";

%feature("docstring")  Arc::MCC::MCC "Arc::MCC::MCC(Config *)

Example contructor - MCC takes at least it's configuration subtree ";

%feature("docstring")  Arc::MCC::~MCC "virtual Arc::MCC::~MCC() ";

%feature("docstring")  Arc::MCC::Next "virtual void
Arc::MCC::Next(MCCInterface *next, const std::string &label=\"\")

Add reference to next MCC in chain. This method is called by Loader
for every potentially labeled link to next component which implements
MCCInterface. If next is NULL corresponding link is removed. ";

%feature("docstring")  Arc::MCC::AddSecHandler "virtual void
Arc::MCC::AddSecHandler(Config *cfg, ArcSec::SecHandler *sechandler,
const std::string &label=\"\")

Add security components/handlers to this MCC. Security handlers are
stacked into a few queues with each queue identified by its label. The
queue labelled 'incoming' is executed for every 'request' message
after the message is processed by the MCC on the service side and
before processing on the client side. The queue labelled 'outgoing' is
run for response message before it is processed by MCC algorithms on
the service side and after processing on the client side. Those labels
are just a matter of agreement and some MCCs may implement different
queues executed at various message processing steps. ";

%feature("docstring")  Arc::MCC::Unlink "virtual void
Arc::MCC::Unlink()

Removing all links. Useful for destroying chains. ";

%feature("docstring")  Arc::MCC::process "virtual MCC_Status
Arc::MCC::process(Message &, Message &)

Dummy Message processing method. Just a placeholder. ";


// File: classArc_1_1MCC__Status.xml
%feature("docstring") Arc::MCC_Status "

A class for communication of MCC processing results.

This class is used to communicate result status between MCCs. It
contains a status kind, a string specifying the origin ( MCC) of the
status object and an explanation.

C++ includes: MCC_Status.h ";

%feature("docstring")  Arc::MCC_Status::MCC_Status "Arc::MCC_Status::MCC_Status(StatusKind kind=STATUS_UNDEFINED, const
std::string &origin=\"???\", const std::string &explanation=\"No
explanation.\")

The constructor.

Creates a MCC_Status object.

Parameters:
-----------

kind:  The StatusKind (default: STATUS_UNDEFINED)

origin:  The origin MCC (default: \"???\")

explanation:  An explanation (default: \"No explanation.\") ";

%feature("docstring")  Arc::MCC_Status::isOk "bool
Arc::MCC_Status::isOk() const

Is the status kind ok?

This method returns true if the status kind of this object is
STATUS_OK true if kind==STATUS_OK ";

%feature("docstring")  Arc::MCC_Status::getKind "StatusKind
Arc::MCC_Status::getKind() const

Returns the status kind.

Returns the status kind of this object. The status kind of this
object. ";

%feature("docstring")  Arc::MCC_Status::getOrigin "const std::string&
Arc::MCC_Status::getOrigin() const

Returns the origin.

This method returns a string specifying the origin MCC of this object.
A string specifying the origin MCC of this object. ";

%feature("docstring")  Arc::MCC_Status::getExplanation "const
std::string& Arc::MCC_Status::getExplanation() const

Returns an explanation.

This method returns an explanation of this object. An explanation of
this object. ";


// File: classArc_1_1MCCConfig.xml
%feature("docstring") Arc::MCCConfig "";

%feature("docstring")  Arc::MCCConfig::MCCConfig "Arc::MCCConfig::MCCConfig() ";

%feature("docstring")  Arc::MCCConfig::~MCCConfig "virtual
Arc::MCCConfig::~MCCConfig() ";

%feature("docstring")  Arc::MCCConfig::MakeConfig "virtual XMLNode
Arc::MCCConfig::MakeConfig(XMLNode cfg) const

Adds configuration part corresponding to stored information into
common configuration tree supplied in 'cfg' argument. Returns
reference to XML node representing configuration of ModuleManager ";


// File: classArc_1_1MCCInterface.xml
%feature("docstring") Arc::MCCInterface "

Interface for communication between MCC, Service and Plexer objects.

The Interface consists of the method process() which is called by the
previous MCC in the chain. For memory management policies please read
the description of the Message class.

C++ includes: MCC.h ";

%feature("docstring")  Arc::MCCInterface::process "virtual MCC_Status
Arc::MCCInterface::process(Message &request, Message &response)=0

Method for processing of requests and responses. This method is called
by preceeding MCC in chain when a request needs to be processed. This
method must call similar method of next MCC in chain unless any
failure happens. Result returned by call to next MCC should be
processed and passed back to previous MCC. In case of failure this
method is expected to generate valid error response and return it back
to previous MCC without calling the next one.

Parameters:
-----------

request:  The request that needs to be processed.

response:  A Message object that will contain the response of the
request when the method returns.

An object representing the status of the call. ";

%feature("docstring")  Arc::MCCInterface::~MCCInterface "virtual
Arc::MCCInterface::~MCCInterface() ";


// File: classArc_1_1MCCLoader.xml
%feature("docstring") Arc::MCCLoader "

Creator of Message Component Chains ( MCC).

This class processes XML configration and creates message chains.
Accepted configuration is defined by XML schema mcc.xsd. Supported
components are of types MCC, Service and Plexer. MCC and Service are
loaded from dynamic libraries. For Plexer only internal implementation
is supported. This object is also a container for loaded componets.
All components and chains are destroyed if this object is destroyed.
Chains are created in 2 steps. First all components are loaded and
corresponding objects are created. Constructors are supplied with
corresponding configuration subtrees. During next step components are
linked together by calling their Next() methods. Each call creates
labeled link to next component in a chain. 2 step method has an
advantage over single step because it allows loops in chains and makes
loading procedure more simple. But that also means during short period
of time components are only partly configured. Components in such
state must produce proper error response if Message arrives. Note:
Current implementation requires all components and links to be
labeled. All labels must be unique. Future implementation will be able
to assign labels automatically.

C++ includes: MCCLoader.h ";

%feature("docstring")  Arc::MCCLoader::MCCLoader "Arc::MCCLoader::MCCLoader() ";

%feature("docstring")  Arc::MCCLoader::MCCLoader "Arc::MCCLoader::MCCLoader(Config &cfg)

Constructor that takes whole XML configuration and creates component
chains ";

%feature("docstring")  Arc::MCCLoader::~MCCLoader "Arc::MCCLoader::~MCCLoader()

Destructor destroys all components created by constructor ";

%feature("docstring")  Arc::MCCLoader::ReloadElement "bool
Arc::MCCLoader::ReloadElement(Config &cfg) ";


// File: classArc_1_1MCCPluginArgument.xml
%feature("docstring") Arc::MCCPluginArgument "";

%feature("docstring")  Arc::MCCPluginArgument::MCCPluginArgument "Arc::MCCPluginArgument::MCCPluginArgument(Config *config, ChainContext
*context) ";

%feature("docstring")  Arc::MCCPluginArgument::~MCCPluginArgument "virtual Arc::MCCPluginArgument::~MCCPluginArgument(void) ";


// File: classArc_1_1MD5Sum.xml
%feature("docstring") Arc::MD5Sum "

Implementation of MD5 checksum.

C++ includes: CheckSum.h ";

%feature("docstring")  Arc::MD5Sum::MD5Sum "Arc::MD5Sum::MD5Sum(void)
";

%feature("docstring")  Arc::MD5Sum::start "virtual void
Arc::MD5Sum::start(void) ";

%feature("docstring")  Arc::MD5Sum::add "virtual void
Arc::MD5Sum::add(void *buf, unsigned long long int len) ";

%feature("docstring")  Arc::MD5Sum::end "virtual void
Arc::MD5Sum::end(void) ";

%feature("docstring")  Arc::MD5Sum::result "virtual void
Arc::MD5Sum::result(unsigned char *&res, unsigned int &len) const ";

%feature("docstring")  Arc::MD5Sum::print "virtual int
Arc::MD5Sum::print(char *buf, int len) const ";

%feature("docstring")  Arc::MD5Sum::scan "virtual void
Arc::MD5Sum::scan(const char *buf) ";


// File: classArc_1_1MemoryAllocationException.xml
%feature("docstring") Arc::MemoryAllocationException "";


// File: classArc_1_1Message.xml
%feature("docstring") Arc::Message "

Object being passed through chain of MCCs.

An instance of this class refers to objects with main content (
MessagePayload), authentication/authorization information (
MessageAuth) and common purpose attributes ( MessageAttributes).
Message class does not manage pointers to objects and their content.
It only serves for grouping those objects. Message objects are
supposed to be processed by MCCs and Services implementing
MCCInterface method process(). All objects constituting content of
Message object are subject to following policies:

1. All objects created inside call to process() method using new
command must be explicitely destroyed within same call using delete
command with following exceptions. a) Objects which are assigned to
'response' Message. b) Objects whose management is completely acquired
by objects assigned to 'response' Message.

2. All objects not created inside call to process() method are not
explicitely destroyed within that call with following exception. a)
Objects which are part of 'response' Method returned from call to
next's process() method. Unless those objects are passed further to
calling process(), of course.

3. It is not allowed to make 'response' point to same objects as
'request' does on entry to process() method. That is needed to avoid
double destruction of same object. (Note: if in a future such need
arises it may be solved by storing additional flags in Message
object).

4. It is allowed to change content of pointers of 'request' Message.
Calling process() method must not rely on that object to stay intact.

5. Called process() method should either fill 'response' Message with
pointers to valid objects or to keep them intact. This makes it
possible for calling process() to preload 'response' with valid error
message.

C++ includes: Message.h ";

%feature("docstring")  Arc::Message::Message "Arc::Message::Message(void)

true if auth_ctx_ was created internally Dummy constructor ";

%feature("docstring")  Arc::Message::Message "Arc::Message::Message(Message &msg)

Copy constructor. Ensures shallow copy. ";

%feature("docstring")  Arc::Message::Message "Arc::Message::Message(long msg_ptr_addr)

Copy constructor. Used by language bindigs ";

%feature("docstring")  Arc::Message::~Message "Arc::Message::~Message(void)

Destructor does not affect refered objects except those created
internally ";

%feature("docstring")  Arc::Message::Payload "MessagePayload*
Arc::Message::Payload(void)

Returns pointer to current payload or NULL if no payload assigned. ";

%feature("docstring")  Arc::Message::Payload "MessagePayload*
Arc::Message::Payload(MessagePayload *payload)

Replaces payload with new one. Returns the old one. ";

%feature("docstring")  Arc::Message::Attributes "MessageAttributes*
Arc::Message::Attributes(void)

Returns a pointer to the current attributes object or creates it if no
attributes object has been assigned. ";

%feature("docstring")  Arc::Message::Attributes "void
Arc::Message::Attributes(MessageAttributes *attr) ";

%feature("docstring")  Arc::Message::Auth "MessageAuth*
Arc::Message::Auth(void)

Returns a pointer to the current authentication/authorization object
or creates it if no object has been assigned. ";

%feature("docstring")  Arc::Message::Auth "void
Arc::Message::Auth(MessageAuth *auth) ";

%feature("docstring")  Arc::Message::Context "MessageContext*
Arc::Message::Context(void)

Returns a pointer to the current context object or creates it if no
object has been assigned. Last case should happen only if first MCC in
a chain is connectionless like one implementing UDP protocol. ";

%feature("docstring")  Arc::Message::AuthContext "MessageAuthContext*
Arc::Message::AuthContext(void)

Returns a pointer to the current auth* context object or creates it if
no object has been assigned. ";

%feature("docstring")  Arc::Message::Context "void
Arc::Message::Context(MessageContext *ctx)

Assigns message context object ";

%feature("docstring")  Arc::Message::AuthContext "void
Arc::Message::AuthContext(MessageAuthContext *auth_ctx)

Assigns auth* context object ";


// File: classArc_1_1MessageAttributes.xml
%feature("docstring") Arc::MessageAttributes "

A class for storage of attribute values.

This class is used to store attributes of messages. All attribute keys
and their corresponding values are stored as strings. Any key or value
that is not a string must thus be represented as a string during
storage. Furthermore, an attribute is usually a key-value pair with a
unique key, but there may also be multiple such pairs with equal keys.

The key of an attribute is composed by the name of the Message Chain
Component ( MCC) which produce it and the name of the attribute itself
with a colon (:) in between, i.e. MCC_Name:Attribute_Name. For
example, the key of the \"Content-Length\" attribute of the HTTP MCC
is thus \"HTTP:Content-Length\".

There are also \"global attributes\", which may be produced by
different MCCs depending on the configuration. The keys of such
attributes are NOT prefixed by the name of the producing MCC. Before
any new global attribute is introduced, it must be agreed upon by the
core development team and added below. The global attributes decided
so far are:  Request-URI Identifies the service to which the message
shall be sent. This attribute is produced by e.g. the HTTP MCC and
used by the plexer for routing the message to the appropriate service.

C++ includes: MessageAttributes.h ";

%feature("docstring")  Arc::MessageAttributes::MessageAttributes "Arc::MessageAttributes::MessageAttributes()

The default constructor.

This is the default constructor of the MessageAttributes class. It
constructs an empty object that initially contains no attributes. ";

%feature("docstring")  Arc::MessageAttributes::set "void
Arc::MessageAttributes::set(const std::string &key, const std::string
&value)

Sets a unique value of an attribute.

This method removes any previous value of an attribute and sets the
new value as the only value.

Parameters:
-----------

key:  The key of the attribute.

value:  The (new) value of the attribute. ";

%feature("docstring")  Arc::MessageAttributes::add "void
Arc::MessageAttributes::add(const std::string &key, const std::string
&value)

Adds a value to an attribute.

This method adds a new value to an attribute. Any previous value will
be preserved, i.e. the attribute may become multiple valued.

Parameters:
-----------

key:  The key of the attribute.

value:  The (new) value of the attribute. ";

%feature("docstring")  Arc::MessageAttributes::removeAll "void
Arc::MessageAttributes::removeAll(const std::string &key)

Removes all attributes with a certain key.

This method removes all attributes that match a certain key.

Parameters:
-----------

key:  The key of the attributes to remove. ";

%feature("docstring")  Arc::MessageAttributes::remove "void
Arc::MessageAttributes::remove(const std::string &key, const
std::string &value)

Removes one value of an attribute.

This method removes a certain value from the attribute that matches a
certain key.

Parameters:
-----------

key:  The key of the attribute from which the value shall be removed.

value:  The value to remove. ";

%feature("docstring")  Arc::MessageAttributes::count "int
Arc::MessageAttributes::count(const std::string &key) const

Returns the number of values of an attribute.

Returns the number of values of an attribute that matches a certain
key.

Parameters:
-----------

key:  The key of the attribute for which to count values.

The number of values that corresponds to the key. ";

%feature("docstring")  Arc::MessageAttributes::get "const
std::string& Arc::MessageAttributes::get(const std::string &key) const

Returns the value of a single-valued attribute.

This method returns the value of a single-valued attribute. If the
attribute is not single valued (i.e. there is no such attribute or it
is a multiple-valued attribute) an empty string is returned.

Parameters:
-----------

key:  The key of the attribute for which to return the value.

The value of the attribute. ";

%feature("docstring")  Arc::MessageAttributes::getAll "AttributeIterator Arc::MessageAttributes::getAll(const std::string
&key) const

Access the value(s) of an attribute.

This method returns an AttributeIterator that can be used to access
the values of an attribute.

Parameters:
-----------

key:  The key of the attribute for which to return the values.

An AttributeIterator for access of the values of the attribute. ";

%feature("docstring")  Arc::MessageAttributes::getAll "AttributeIterator Arc::MessageAttributes::getAll(void) const

Access all value and attributes. ";


// File: classArc_1_1MessageAuth.xml
%feature("docstring") Arc::MessageAuth "

Contains authencity information, authorization tokens and decisions.

This class only supports string keys and SecAttr values.

C++ includes: MessageAuth.h ";

%feature("docstring")  Arc::MessageAuth::MessageAuth "Arc::MessageAuth::MessageAuth(void) ";

%feature("docstring")  Arc::MessageAuth::~MessageAuth "Arc::MessageAuth::~MessageAuth(void) ";

%feature("docstring")  Arc::MessageAuth::set "void
Arc::MessageAuth::set(const std::string &key, SecAttr *value)

Adds/overwrites security attribute stored under specified key. ";

%feature("docstring")  Arc::MessageAuth::remove "void
Arc::MessageAuth::remove(const std::string &key)

Deletes security attribute stored under specified key. ";

%feature("docstring")  Arc::MessageAuth::get "SecAttr*
Arc::MessageAuth::get(const std::string &key)

Retrieves reference to security attribute stored under specified key.
";

%feature("docstring")  Arc::MessageAuth::Export "bool
Arc::MessageAuth::Export(SecAttrFormat format, XMLNode &val) const

Returns properly catenated attributes in specified format.

Content of XML node at  is replaced with generated information if XML
tree is empty. If tree at  is not empty then Export() tries to merge
generated information to already existing like everything would be
generated inside same Export() method. If  does not represent valid
node then new XML tree is created. ";

%feature("docstring")  Arc::MessageAuth::Filter "MessageAuth*
Arc::MessageAuth::Filter(const std::list< std::string >
&selected_keys, const std::list< std::string > &rejected_keys)

Creates new instance of MessageAuth with attributes filtered.

In new instance all attributes with keys listed in  are removed. If is
not empty only corresponding attributes are transferred to new
instance. Created instance does not own refered attributes. Hence
parent instance must not be deleted as long as this one is in use. ";


// File: classArc_1_1MessageAuthContext.xml
%feature("docstring") Arc::MessageAuthContext "

Handler for content of message auth* context.

This class is a container for authorization and authentication
information. It gets associated with Message object usually by first
MCC in a chain and is kept as long as connection persists.

C++ includes: Message.h ";

%feature("docstring")  Arc::MessageAuthContext::MessageAuthContext "Arc::MessageAuthContext::MessageAuthContext(void) ";

%feature("docstring")  Arc::MessageAuthContext::~MessageAuthContext "Arc::MessageAuthContext::~MessageAuthContext(void) ";


// File: classArc_1_1MessageContext.xml
%feature("docstring") Arc::MessageContext "

Handler for content of message context.

This class is a container for objects derived from
MessageContextElement. It gets associated with Message object usually
by first MCC in a chain and is kept as long as connection persists.

C++ includes: Message.h ";

%feature("docstring")  Arc::MessageContext::MessageContext "Arc::MessageContext::MessageContext(void) ";

%feature("docstring")  Arc::MessageContext::~MessageContext "Arc::MessageContext::~MessageContext(void) ";

%feature("docstring")  Arc::MessageContext::Add "void
Arc::MessageContext::Add(const std::string &name,
MessageContextElement *element)

Provided element is taken over by this class. It is remembered by it
and destroyed when this class is destroyed. ";


// File: classArc_1_1MessageContextElement.xml
%feature("docstring") Arc::MessageContextElement "

Top class for elements contained in message context.

Objects of classes inherited with this one may be stored in
MessageContext container.

C++ includes: Message.h ";

%feature("docstring")
Arc::MessageContextElement::MessageContextElement "Arc::MessageContextElement::MessageContextElement(void) ";

%feature("docstring")
Arc::MessageContextElement::~MessageContextElement "virtual
Arc::MessageContextElement::~MessageContextElement(void) ";


// File: classArc_1_1MessagePayload.xml
%feature("docstring") Arc::MessagePayload "

Base class for content of message passed through chain.

It's not intended to be used directly. Instead functional classes must
be derived from it.

C++ includes: Message.h ";

%feature("docstring")  Arc::MessagePayload::~MessagePayload "virtual
Arc::MessagePayload::~MessagePayload(void) ";


// File: classArc_1_1ModuleDesc.xml
%feature("docstring") Arc::ModuleDesc "

Description of loadable module.

This class is used for reports

C++ includes: Plugin.h ";


// File: classArc_1_1ModuleManager.xml
%feature("docstring") Arc::ModuleManager "

Manager of shared libraries.

This class loads shared libraries/modules. There supposed to be
created one instance of it per executable. In such circumstances it
would cache handles to loaded modules and not load them multiple
times.

C++ includes: ModuleManager.h ";

%feature("docstring")  Arc::ModuleManager::ModuleManager "Arc::ModuleManager::ModuleManager(XMLNode cfg)

Cache of handles of loaded modules Constructor. It is supposed to
process correponding configuration subtree and tune module loading
parameters accordingly. ";

%feature("docstring")  Arc::ModuleManager::~ModuleManager "Arc::ModuleManager::~ModuleManager() ";

%feature("docstring")  Arc::ModuleManager::load "Glib::Module*
Arc::ModuleManager::load(const std::string &name, bool probe=false)

Finds module 'name' in cache or loads corresponding loadable module ";

%feature("docstring")  Arc::ModuleManager::find "std::string
Arc::ModuleManager::find(const std::string &name)

Finds loadable module by 'name' looking in same places as load() does,
but does not load it. ";

%feature("docstring")  Arc::ModuleManager::reload "Glib::Module*
Arc::ModuleManager::reload(Glib::Module *module)

Reload module previously loaded in probe mode. New module is loaded
with all symbols resolved and old module handler is unloaded. In case
of error old module is not unloaded. ";

%feature("docstring")  Arc::ModuleManager::unload "void
Arc::ModuleManager::unload(Glib::Module *module)

Unload module by its identifier ";

%feature("docstring")  Arc::ModuleManager::unload "void
Arc::ModuleManager::unload(const std::string &name)

Unload module by its name ";

%feature("docstring")  Arc::ModuleManager::findLocation "std::string
Arc::ModuleManager::findLocation(const std::string &name)

Finds shared library corresponding to module 'name' and returns path
to it ";

%feature("docstring")  Arc::ModuleManager::makePersistent "bool
Arc::ModuleManager::makePersistent(Glib::Module *module)

Make sure this module is never unloaded. Even if unload() is called.
";

%feature("docstring")  Arc::ModuleManager::makePersistent "bool
Arc::ModuleManager::makePersistent(const std::string &name)

Make sure this module is never unloaded. Even if unload() is called.
";

%feature("docstring")  Arc::ModuleManager::setCfg "void
Arc::ModuleManager::setCfg(XMLNode cfg)

Input the configuration subtree, and trigger the module loading (do
almost the same as the Constructor); It is function desgined for
ClassLoader to adopt the singleton pattern ";


// File: classArc_1_1MultiSecAttr.xml
%feature("docstring") Arc::MultiSecAttr "

Container of multiple SecAttr attributes.

This class combines multiple attributes. It's export/import methods
catenate results of underlying objects. Primary meaning of this class
is to serve as base for classes implementing multi level hierarchical
tree-like descriptions of user identity. It may also be used for
collecting information of same source or kind. Like all information
extracted from X509 certificate.

C++ includes: SecAttr.h ";

%feature("docstring")  Arc::MultiSecAttr::MultiSecAttr "Arc::MultiSecAttr::MultiSecAttr() ";

%feature("docstring")  Arc::MultiSecAttr::~MultiSecAttr "virtual
Arc::MultiSecAttr::~MultiSecAttr() ";

%feature("docstring")  Arc::MultiSecAttr::Export "virtual bool
Arc::MultiSecAttr::Export(SecAttrFormat format, XMLNode &val) const

Convert internal structure into specified format. Returns false if
format is not supported/suitable for this attribute. XML node
referenced by  is turned into top level element of specified format.
";

%feature("docstring")  Arc::MultiSecAttr::Import "virtual bool
Arc::MultiSecAttr::Import(SecAttrFormat format, XMLNode val) ";


// File: classArc_1_1MySQLDatabase.xml
%feature("docstring") Arc::MySQLDatabase "

Implement the database accessing interface in DBInterface.h by using
mysql client library for accessing mysql database

C++ includes: MysqlWrapper.h ";

%feature("docstring")  Arc::MySQLDatabase::MySQLDatabase "Arc::MySQLDatabase::MySQLDatabase(std::string &server, int port) ";

%feature("docstring")  Arc::MySQLDatabase::MySQLDatabase "Arc::MySQLDatabase::MySQLDatabase(const MySQLDatabase &other) ";

%feature("docstring")  Arc::MySQLDatabase::~MySQLDatabase "virtual
Arc::MySQLDatabase::~MySQLDatabase() ";

%feature("docstring")  Arc::MySQLDatabase::connect "virtual bool
Arc::MySQLDatabase::connect(std::string &dbname, std::string &user,
std::string &password)

Do connection with database server

Parameters:
-----------

dbname:  The database name which will be used.

user:  The username which will be used to access database.

password:  The password which will be used to access database. ";

%feature("docstring")  Arc::MySQLDatabase::isconnected "virtual bool
Arc::MySQLDatabase::isconnected() const

Get the connection status ";

%feature("docstring")  Arc::MySQLDatabase::close "virtual void
Arc::MySQLDatabase::close()

Close the connection with database server ";

%feature("docstring")  Arc::MySQLDatabase::enable_ssl "virtual bool
Arc::MySQLDatabase::enable_ssl(const std::string keyfile=\"\", const
std::string certfile=\"\", const std::string cafile=\"\", const
std::string capath=\"\")

Enable ssl communication for the connection

Parameters:
-----------

keyfile:  The location of key file.

certfile:  The location of certificate file.

cafile:  The location of ca file.

capath:  The location of ca directory ";

%feature("docstring")  Arc::MySQLDatabase::shutdown "virtual bool
Arc::MySQLDatabase::shutdown()

Ask database server to shutdown ";


// File: classArc_1_1MySQLQuery.xml
%feature("docstring") Arc::MySQLQuery "";

%feature("docstring")  Arc::MySQLQuery::MySQLQuery "Arc::MySQLQuery::MySQLQuery(Database *db) ";

%feature("docstring")  Arc::MySQLQuery::~MySQLQuery "virtual
Arc::MySQLQuery::~MySQLQuery() ";

%feature("docstring")  Arc::MySQLQuery::get_num_colums "virtual int
Arc::MySQLQuery::get_num_colums()

Get the colum number in the query result ";

%feature("docstring")  Arc::MySQLQuery::get_num_rows "virtual int
Arc::MySQLQuery::get_num_rows()

Get the row number in the query result ";

%feature("docstring")  Arc::MySQLQuery::execute "virtual bool
Arc::MySQLQuery::execute(const std::string &sqlstr)

Execute the query

Parameters:
-----------

sqlstr:  The sql sentence used to query ";

%feature("docstring")  Arc::MySQLQuery::get_row "virtual
QueryRowResult Arc::MySQLQuery::get_row(int row_number) const

Get the value of one row in the query result

Parameters:
-----------

row_number:  The number of the row

A vector includes all the values in the row ";

%feature("docstring")  Arc::MySQLQuery::get_row "virtual
QueryRowResult Arc::MySQLQuery::get_row() const

Get the value of one row in the query result, the row number will be
automatically increased each time the method is called ";

%feature("docstring")  Arc::MySQLQuery::get_row_field "virtual
std::string Arc::MySQLQuery::get_row_field(int row_number, std::string
&field_name)

Get the value of one specific field in one specific row

Parameters:
-----------

row_number:  The row number inside the query result

field_name:  The field name for the value which will be return

The value of the specified filed in the specified row ";

%feature("docstring")  Arc::MySQLQuery::get_array "virtual bool
Arc::MySQLQuery::get_array(std::string &sqlstr, QueryArrayResult
&result, std::vector< std::string > &arguments)

Query the database by using some parameters into sql sentence e.g.
\"select table.value from table where table.name = ?\"

Parameters:
-----------

sqlstr:  The sql sentence with some parameters marked with \"?\".

result:  The result in an array which includes all of the value in
query result.

arguments:  The argument list which should exactely correspond with
the parametes in sql sentence. ";


// File: classArc_1_1NotificationType.xml
%feature("docstring") Arc::NotificationType "";

%feature("docstring")  Arc::NotificationType::NotificationType "Arc::NotificationType::NotificationType() ";


// File: classArc_1_1NS.xml
%feature("docstring") Arc::NS "";

%feature("docstring")  Arc::NS::NS "Arc::NS::NS(void)

Constructor creates empty namespace. ";

%feature("docstring")  Arc::NS::NS "Arc::NS::NS(const char *prefix,
const char *uri)

Constructor creates namespace with one entry. ";

%feature("docstring")  Arc::NS::NS "Arc::NS::NS(const char
*nslist[][2])

Constructor creates namespace with multiple entries. ";

%feature("docstring")  Arc::NS::NS "Arc::NS::NS(const std::map<
std::string, std::string > &nslist) ";


// File: classArc_1_1OAuthConsumer.xml
%feature("docstring") Arc::OAuthConsumer "

The OAuth functionality depends on the availability of the liboauth
C-bindings library

C++ includes: OAuthConsumer.h ";

%feature("docstring")  Arc::OAuthConsumer::OAuthConsumer "Arc::OAuthConsumer::OAuthConsumer(const MCCConfig cfg, const URL url,
std::list< std::string > idp_stack)

Construct an OAuth consumer with url as service provider. idp_name is
currently ignored, since the idp to which the SAML2 redirect will take
place is presently a hardcoded value on the SAML2 SP side. This is
expected to change in the future. ";

%feature("docstring")  Arc::OAuthConsumer::~OAuthConsumer "virtual
Arc::OAuthConsumer::~OAuthConsumer() ";

%feature("docstring")  Arc::OAuthConsumer::getIdPName "std::string
Arc::OAuthConsumer::getIdPName() ";

%feature("docstring")  Arc::OAuthConsumer::parseDN "MCC_Status
Arc::OAuthConsumer::parseDN(std::string *dn)

Unsupported placeholder function until Confusa supports OAuth. ";

%feature("docstring")  Arc::OAuthConsumer::approveCSR "MCC_Status
Arc::OAuthConsumer::approveCSR(const std::string approve_page)

Unsupported placeholder function until Confusa supports OAuth. ";

%feature("docstring")  Arc::OAuthConsumer::pushCSR "MCC_Status
Arc::OAuthConsumer::pushCSR(const std::string b64_pub_key, const
std::string pub_key_hash, std::string *approve_page)

Unsupported placeholder function until Confusa supports OAuth. ";

%feature("docstring")  Arc::OAuthConsumer::storeCert "MCC_Status
Arc::OAuthConsumer::storeCert(const std::string cert_path, const
std::string auth_token, const std::string b64_dn)

Unsupported placeholder function until Confusa supports OAuth. ";


// File: classArc_1_1OpenIdpClient.xml
%feature("docstring") Arc::OpenIdpClient "";

%feature("docstring")  Arc::OpenIdpClient::OpenIdpClient "Arc::OpenIdpClient::OpenIdpClient(const MCCConfig cfg, const URL url,
std::list< std::string > idp_stack) ";

%feature("docstring")  Arc::OpenIdpClient::~OpenIdpClient "virtual
Arc::OpenIdpClient::~OpenIdpClient() ";


// File: classArc_1_1OptionParser.xml
%feature("docstring") Arc::OptionParser "";

%feature("docstring")  Arc::OptionParser::OptionParser "Arc::OptionParser::OptionParser(const std::string &arguments=\"\",
const std::string &summary=\"\", const std::string &description=\"\")
";

%feature("docstring")  Arc::OptionParser::~OptionParser "Arc::OptionParser::~OptionParser() ";

%feature("docstring")  Arc::OptionParser::AddOption "void
Arc::OptionParser::AddOption(const char shortOpt, const std::string
&longOpt, const std::string &optDesc, bool &val) ";

%feature("docstring")  Arc::OptionParser::AddOption "void
Arc::OptionParser::AddOption(const char shortOpt, const std::string
&longOpt, const std::string &optDesc, const std::string &argDesc, int
&val) ";

%feature("docstring")  Arc::OptionParser::AddOption "void
Arc::OptionParser::AddOption(const char shortOpt, const std::string
&longOpt, const std::string &optDesc, const std::string &argDesc,
std::string &val) ";

%feature("docstring")  Arc::OptionParser::AddOption "void
Arc::OptionParser::AddOption(const char shortOpt, const std::string
&longOpt, const std::string &optDesc, const std::string &argDesc,
std::list< std::string > &val) ";

%feature("docstring")  Arc::OptionParser::Parse "std::list<std::string> Arc::OptionParser::Parse(int argc, char **argv)
";


// File: classArcSec_1_1OrderedCombiningAlg.xml
%feature("docstring") ArcSec::OrderedCombiningAlg "";

%feature("docstring")
ArcSec::OrderedCombiningAlg::OrderedCombiningAlg "ArcSec::OrderedCombiningAlg::OrderedCombiningAlg() ";

%feature("docstring")
ArcSec::OrderedCombiningAlg::~OrderedCombiningAlg "virtual
ArcSec::OrderedCombiningAlg::~OrderedCombiningAlg() ";


// File: structpasswd.xml
%feature("docstring") passwd "";


// File: classArc_1_1PathIterator.xml
%feature("docstring") Arc::PathIterator "

Class to iterate through elements of path.

C++ includes: URL.h ";

%feature("docstring")  Arc::PathIterator::PathIterator "Arc::PathIterator::PathIterator(const std::string &path, bool
end=false)

Constructor accepts path and stores it internally. If end is set to
false iterator is pointing at first element in path. Otherwise
selected element is one before last. ";

%feature("docstring")  Arc::PathIterator::~PathIterator "Arc::PathIterator::~PathIterator() ";

%feature("docstring")  Arc::PathIterator::Rest "std::string
Arc::PathIterator::Rest() const

Returns part of initial path from one after current till end ";


// File: classArc_1_1PayloadRaw.xml
%feature("docstring") Arc::PayloadRaw "

Raw byte multi-buffer.

This is implementation of PayloadRawInterface. Buffers are memory
blocks logically placed one after another.

C++ includes: PayloadRaw.h ";

%feature("docstring")  Arc::PayloadRaw::PayloadRaw "Arc::PayloadRaw::PayloadRaw(void)

List of handled buffers. Constructor. Created object contains no
buffers. ";

%feature("docstring")  Arc::PayloadRaw::~PayloadRaw "virtual
Arc::PayloadRaw::~PayloadRaw(void)

Destructor. Frees allocated buffers. ";

%feature("docstring")  Arc::PayloadRaw::Content "virtual char*
Arc::PayloadRaw::Content(Size_t pos=-1)

Get pointer to buffer content at global position 'pos'. By default to
beginning of main buffer whatever that means. ";

%feature("docstring")  Arc::PayloadRaw::Size "virtual Size_t
Arc::PayloadRaw::Size(void) const

Returns logical size of whole structure. ";

%feature("docstring")  Arc::PayloadRaw::Insert "virtual char*
Arc::PayloadRaw::Insert(Size_t pos=0, Size_t size=0)

Create new buffer at global position 'pos' of size 'size'. ";

%feature("docstring")  Arc::PayloadRaw::Insert "virtual char*
Arc::PayloadRaw::Insert(const char *s, Size_t pos=0, Size_t size=-1)

Create new buffer at global position 'pos' of size 'size'. Created
buffer is filled with content of memory at 's'. If 'size' is negative
content at 's' is expected to be null-terminated. ";

%feature("docstring")  Arc::PayloadRaw::Buffer "virtual char*
Arc::PayloadRaw::Buffer(unsigned int num=0)

Returns pointer to num'th buffer ";

%feature("docstring")  Arc::PayloadRaw::BufferSize "virtual Size_t
Arc::PayloadRaw::BufferSize(unsigned int num=0) const

Returns length of num'th buffer ";

%feature("docstring")  Arc::PayloadRaw::BufferPos "virtual Size_t
Arc::PayloadRaw::BufferPos(unsigned int num=0) const

Returns position of num'th buffer ";

%feature("docstring")  Arc::PayloadRaw::Truncate "virtual bool
Arc::PayloadRaw::Truncate(Size_t size)

Change size of stored information. If size exceeds end of allocated
buffer, buffers are not re-allocated, only logical size is extended.
Buffers with location behind new size are deallocated. ";


// File: structArc_1_1PayloadRawBuf.xml
%feature("docstring") Arc::PayloadRawBuf "";


// File: classArc_1_1PayloadRawInterface.xml
%feature("docstring") Arc::PayloadRawInterface "

Random Access Payload for Message objects.

This class is a virtual interface for managing Message payload with
arbitrarily accessible content. Inheriting classes are supposed to
implement memory-resident or memory-mapped content made of optionally
multiple chunks/buffers. Every buffer has own size and offset. This
class is purely virtual.

C++ includes: PayloadRaw.h ";

%feature("docstring")  Arc::PayloadRawInterface::PayloadRawInterface "Arc::PayloadRawInterface::PayloadRawInterface(void) ";

%feature("docstring")  Arc::PayloadRawInterface::~PayloadRawInterface
"virtual Arc::PayloadRawInterface::~PayloadRawInterface(void) ";

%feature("docstring")  Arc::PayloadRawInterface::Content "virtual
char* Arc::PayloadRawInterface::Content(Size_t pos=-1)=0

Get pointer to buffer content at global position 'pos'. By default to
beginning of main buffer whatever that means. ";

%feature("docstring")  Arc::PayloadRawInterface::Size "virtual Size_t
Arc::PayloadRawInterface::Size(void) const =0

Returns logical size of whole structure. ";

%feature("docstring")  Arc::PayloadRawInterface::Insert "virtual
char* Arc::PayloadRawInterface::Insert(Size_t pos=0, Size_t size=0)=0

Create new buffer at global position 'pos' of size 'size'. ";

%feature("docstring")  Arc::PayloadRawInterface::Insert "virtual
char* Arc::PayloadRawInterface::Insert(const char *s, Size_t pos=0,
Size_t size=-1)=0

Create new buffer at global position 'pos' of size 'size'. Created
buffer is filled with content of memory at 's'. If 'size' is negative
content at 's' is expected to be null-terminated. ";

%feature("docstring")  Arc::PayloadRawInterface::Buffer "virtual
char* Arc::PayloadRawInterface::Buffer(unsigned int num)=0

Returns pointer to num'th buffer ";

%feature("docstring")  Arc::PayloadRawInterface::BufferSize "virtual
Size_t Arc::PayloadRawInterface::BufferSize(unsigned int num) const =0

Returns length of num'th buffer ";

%feature("docstring")  Arc::PayloadRawInterface::BufferPos "virtual
Size_t Arc::PayloadRawInterface::BufferPos(unsigned int num) const =0

Returns position of num'th buffer ";

%feature("docstring")  Arc::PayloadRawInterface::Truncate "virtual
bool Arc::PayloadRawInterface::Truncate(Size_t size)=0

Change size of stored information. If size exceeds end of allocated
buffer, buffers are not re-allocated, only logical size is extended.
Buffers with location behind new size are deallocated. ";


// File: classArc_1_1PayloadSOAP.xml
%feature("docstring") Arc::PayloadSOAP "

Payload of Message with SOAP content.

This class combines MessagePayload with SOAPEnvelope to make it
possible to pass SOAP messages through MCC chain.

C++ includes: PayloadSOAP.h ";

%feature("docstring")  Arc::PayloadSOAP::PayloadSOAP "Arc::PayloadSOAP::PayloadSOAP(const NS &ns, bool fault=false)

Constructor - creates new Message payload ";

%feature("docstring")  Arc::PayloadSOAP::PayloadSOAP "Arc::PayloadSOAP::PayloadSOAP(const SOAPEnvelope &soap)

Constructor - creates Message payload from SOAP document. Provided
SOAP document is copied to new object. ";

%feature("docstring")  Arc::PayloadSOAP::PayloadSOAP "Arc::PayloadSOAP::PayloadSOAP(const MessagePayload &source)

Constructor - creates SOAP message from payload. PayloadRawInterface
and derived classes are supported. ";

%feature("docstring")  Arc::PayloadSOAP::~PayloadSOAP "virtual
Arc::PayloadSOAP::~PayloadSOAP(void) ";


// File: classArc_1_1PayloadStream.xml
%feature("docstring") Arc::PayloadStream "

POSIX handle as Payload.

This is an implemetation of PayloadStreamInterface for generic POSIX
handle.

C++ includes: PayloadStream.h ";

%feature("docstring")  Arc::PayloadStream::PayloadStream "Arc::PayloadStream::PayloadStream(int h=-1)

true if lseek operation is applicable to open handle Constructor.
Attaches to already open handle. Handle is not managed by this class
and must be closed by external code. ";

%feature("docstring")  Arc::PayloadStream::~PayloadStream "virtual
Arc::PayloadStream::~PayloadStream(void)

Destructor. ";

%feature("docstring")  Arc::PayloadStream::Get "virtual bool
Arc::PayloadStream::Get(char *buf, int &size)

Extracts information from stream up to 'size' bytes. 'size' contains
number of read bytes on exit. Returns true in case of success. ";

%feature("docstring")  Arc::PayloadStream::Get "virtual bool
Arc::PayloadStream::Get(std::string &buf)

Read as many as possible (sane amount) of bytes into buf. ";

%feature("docstring")  Arc::PayloadStream::Get "virtual std::string
Arc::PayloadStream::Get(void)

Read as many as possible (sane amount) of bytes. ";

%feature("docstring")  Arc::PayloadStream::Put "virtual bool
Arc::PayloadStream::Put(const char *buf, Size_t size)

Push 'size' bytes from 'buf' into stream. Returns true on success. ";

%feature("docstring")  Arc::PayloadStream::Put "virtual bool
Arc::PayloadStream::Put(const std::string &buf)

Push information from 'buf' into stream. Returns true on success. ";

%feature("docstring")  Arc::PayloadStream::Put "virtual bool
Arc::PayloadStream::Put(const char *buf)

Push null terminated information from 'buf' into stream. Returns true
on success. ";

%feature("docstring")  Arc::PayloadStream::Timeout "virtual int
Arc::PayloadStream::Timeout(void) const

Query current timeout for Get() and Put() operations. ";

%feature("docstring")  Arc::PayloadStream::Timeout "virtual void
Arc::PayloadStream::Timeout(int to)

Set current timeout for Get() and Put() operations. ";

%feature("docstring")  Arc::PayloadStream::Pos "virtual Size_t
Arc::PayloadStream::Pos(void) const

Returns current position in stream if supported. ";

%feature("docstring")  Arc::PayloadStream::Size "virtual Size_t
Arc::PayloadStream::Size(void) const

Returns size of underlying object if supported. ";

%feature("docstring")  Arc::PayloadStream::Limit "virtual Size_t
Arc::PayloadStream::Limit(void) const

Returns position at which stream reading will stop if supported. That
may be not same as Size() if instance is meant to provide access to
only part of underlying obejct. ";


// File: classArc_1_1PayloadStreamInterface.xml
%feature("docstring") Arc::PayloadStreamInterface "

Stream-like Payload for Message object.

This class is a virtual interface for managing stream-like source and
destination. It's supposed to be passed through MCC chain as payload
of Message. It must be treated by MCCs and Services as dynamic
payload. This class is purely virtual.

C++ includes: PayloadStream.h ";

%feature("docstring")
Arc::PayloadStreamInterface::PayloadStreamInterface "Arc::PayloadStreamInterface::PayloadStreamInterface(void) ";

%feature("docstring")
Arc::PayloadStreamInterface::~PayloadStreamInterface "virtual
Arc::PayloadStreamInterface::~PayloadStreamInterface(void) ";

%feature("docstring")  Arc::PayloadStreamInterface::Get "virtual bool
Arc::PayloadStreamInterface::Get(char *buf, int &size)=0

Extracts information from stream up to 'size' bytes. 'size' contains
number of read bytes on exit. Returns true in case of success. ";

%feature("docstring")  Arc::PayloadStreamInterface::Get "virtual bool
Arc::PayloadStreamInterface::Get(std::string &buf)=0

Read as many as possible (sane amount) of bytes into buf. ";

%feature("docstring")  Arc::PayloadStreamInterface::Get "virtual
std::string Arc::PayloadStreamInterface::Get(void)=0

Read as many as possible (sane amount) of bytes. ";

%feature("docstring")  Arc::PayloadStreamInterface::Put "virtual bool
Arc::PayloadStreamInterface::Put(const char *buf, Size_t size)=0

Push 'size' bytes from 'buf' into stream. Returns true on success. ";

%feature("docstring")  Arc::PayloadStreamInterface::Put "virtual bool
Arc::PayloadStreamInterface::Put(const std::string &buf)=0

Push information from 'buf' into stream. Returns true on success. ";

%feature("docstring")  Arc::PayloadStreamInterface::Put "virtual bool
Arc::PayloadStreamInterface::Put(const char *buf)=0

Push null terminated information from 'buf' into stream. Returns true
on success. ";

%feature("docstring")  Arc::PayloadStreamInterface::Timeout "virtual
int Arc::PayloadStreamInterface::Timeout(void) const =0

Query current timeout for Get() and Put() operations. ";

%feature("docstring")  Arc::PayloadStreamInterface::Timeout "virtual
void Arc::PayloadStreamInterface::Timeout(int to)=0

Set current timeout for Get() and Put() operations. ";

%feature("docstring")  Arc::PayloadStreamInterface::Pos "virtual
Size_t Arc::PayloadStreamInterface::Pos(void) const =0

Returns current position in stream if supported. ";

%feature("docstring")  Arc::PayloadStreamInterface::Size "virtual
Size_t Arc::PayloadStreamInterface::Size(void) const =0

Returns size of underlying object if supported. ";

%feature("docstring")  Arc::PayloadStreamInterface::Limit "virtual
Size_t Arc::PayloadStreamInterface::Limit(void) const =0

Returns position at which stream reading will stop if supported. That
may be not same as Size() if instance is meant to provide access to
only part of underlying obejct. ";


// File: classArc_1_1PayloadWSRF.xml
%feature("docstring") Arc::PayloadWSRF "

This class combines MessagePayload with WSRF.

It's intention is to make it possible to pass WSRF messages through
MCC chain as one more Payload type.

C++ includes: PayloadWSRF.h ";

%feature("docstring")  Arc::PayloadWSRF::PayloadWSRF "Arc::PayloadWSRF::PayloadWSRF(const SOAPEnvelope &soap)

Constructor - creates Message payload from SOAP message. Returns
invalid WSRF if SOAP does not represent WS-ResourceProperties ";

%feature("docstring")  Arc::PayloadWSRF::PayloadWSRF "Arc::PayloadWSRF::PayloadWSRF(WSRF &wsrp)

Constructor - creates Message payload with acquired WSRF message. WSRF
message will be destroyed by destructor of this object. ";

%feature("docstring")  Arc::PayloadWSRF::PayloadWSRF "Arc::PayloadWSRF::PayloadWSRF(const MessagePayload &source)

Constructor - creates WSRF message from payload. All classes derived
from SOAPEnvelope are supported. ";

%feature("docstring")  Arc::PayloadWSRF::~PayloadWSRF "virtual
Arc::PayloadWSRF::~PayloadWSRF(void) ";


// File: classArcSec_1_1PDP.xml
%feature("docstring") ArcSec::PDP "

Base class for Policy Decision Point plugins.

This virtual class defines method isPermitted() which processes
security related information/attributes in Message and makes security
decision - permit (true) or deny (false). Configuration of PDP is
consumed during creation of instance through XML subtree fed to
constructor.

C++ includes: PDP.h ";

%feature("docstring")  ArcSec::PDP::PDP "ArcSec::PDP::PDP(Arc::Config
*cfg) ";

%feature("docstring")  ArcSec::PDP::~PDP "virtual ArcSec::PDP::~PDP()
";

%feature("docstring")  ArcSec::PDP::isPermitted "virtual bool
ArcSec::PDP::isPermitted(Arc::Message *msg) const =0 ";

%feature("docstring")  ArcSec::PDP::SetId "void
ArcSec::PDP::SetId(std::string &id) ";

%feature("docstring")  ArcSec::PDP::GetId "std::string
ArcSec::PDP::GetId() ";


// File: classArcSec_1_1PDPConfigContext.xml
%feature("docstring") ArcSec::PDPConfigContext "";

%feature("docstring")  ArcSec::PDPConfigContext::PDPConfigContext "ArcSec::PDPConfigContext::PDPConfigContext() ";

%feature("docstring")  ArcSec::PDPConfigContext::PDPConfigContext "ArcSec::PDPConfigContext::PDPConfigContext(std::list<
ArcSec::AuthzRequest > req, std::string &policy) ";

%feature("docstring")  ArcSec::PDPConfigContext::PDPConfigContext "ArcSec::PDPConfigContext::PDPConfigContext(std::list<
ArcSec::AuthzRequest > req, std::list< std::string > policy) ";

%feature("docstring")  ArcSec::PDPConfigContext::AddRequestItem "void
ArcSec::PDPConfigContext::AddRequestItem(ArcSec::AuthzRequest
requestitem) ";

%feature("docstring")  ArcSec::PDPConfigContext::SetRequestItem "void
ArcSec::PDPConfigContext::SetRequestItem(ArcSec::AuthzRequest
requestitem) ";

%feature("docstring")  ArcSec::PDPConfigContext::SetRequestItem "void
ArcSec::PDPConfigContext::SetRequestItem(std::list<
ArcSec::AuthzRequest > req) ";

%feature("docstring")  ArcSec::PDPConfigContext::RequestItemSize "int
ArcSec::PDPConfigContext::RequestItemSize() ";

%feature("docstring")  ArcSec::PDPConfigContext::GetRequestItem "ArcSec::AuthzRequest& ArcSec::PDPConfigContext::GetRequestItem(int n)
";

%feature("docstring")  ArcSec::PDPConfigContext::AddPolicyLocation "void ArcSec::PDPConfigContext::AddPolicyLocation(std::string &policy)
";

%feature("docstring")  ArcSec::PDPConfigContext::SetPolicyLocation "void ArcSec::PDPConfigContext::SetPolicyLocation(std::list<
std::string > policy) ";

%feature("docstring")  ArcSec::PDPConfigContext::SetPolicyLocation "void ArcSec::PDPConfigContext::SetPolicyLocation(std::string &policy)
";

%feature("docstring")  ArcSec::PDPConfigContext::GetPolicyLocation "std::list<std::string>& ArcSec::PDPConfigContext::GetPolicyLocation()
";

%feature("docstring")  ArcSec::PDPConfigContext::~PDPConfigContext "virtual ArcSec::PDPConfigContext::~PDPConfigContext(void) ";


// File: classArcSec_1_1PDPPluginArgument.xml
%feature("docstring") ArcSec::PDPPluginArgument "";

%feature("docstring")  ArcSec::PDPPluginArgument::PDPPluginArgument "ArcSec::PDPPluginArgument::PDPPluginArgument(Arc::Config *config) ";

%feature("docstring")  ArcSec::PDPPluginArgument::~PDPPluginArgument "virtual ArcSec::PDPPluginArgument::~PDPPluginArgument(void) ";


// File: classArc_1_1Period.xml
%feature("docstring") Arc::Period "";

%feature("docstring")  Arc::Period::Period "Arc::Period::Period()

Default constructor. The period is set to 0 length. ";

%feature("docstring")  Arc::Period::Period "Arc::Period::Period(time_t)

Constructor that takes a time_t variable and stores it. ";

%feature("docstring")  Arc::Period::Period "Arc::Period::Period(time_t seconds, uint32_t nanoseconds)

Constructor that takes seconds and nanoseconds and stores them. ";

%feature("docstring")  Arc::Period::Period "Arc::Period::Period(const
std::string &, PeriodBase base=PeriodSeconds)

Constructor that tries to convert a string. ";

%feature("docstring")  Arc::Period::SetPeriod "void
Arc::Period::SetPeriod(time_t)

sets the period ";

%feature("docstring")  Arc::Period::SetPeriod "void
Arc::Period::SetPeriod(time_t sec, uint32_t nanosec) ";

%feature("docstring")  Arc::Period::GetPeriod "time_t
Arc::Period::GetPeriod() const

gets the period ";

%feature("docstring")  Arc::Period::GetPeriodNanoseconds "time_t
Arc::Period::GetPeriodNanoseconds() const ";

%feature("docstring")  Arc::Period::istr "const sigc::slot<const
char*>* Arc::Period::istr() const

For use with IString ";


// File: classArcSec_1_1PeriodAttribute.xml
%feature("docstring") ArcSec::PeriodAttribute "

Formate: datetime\"/\"duration datetime\"/\"datetime
duration\"/\"datetime

C++ includes: DateTimeAttribute.h ";

%feature("docstring")  ArcSec::PeriodAttribute::PeriodAttribute "ArcSec::PeriodAttribute::PeriodAttribute() ";

%feature("docstring")  ArcSec::PeriodAttribute::PeriodAttribute "ArcSec::PeriodAttribute::PeriodAttribute(const std::string &v, const
std::string &i) ";

%feature("docstring")  ArcSec::PeriodAttribute::~PeriodAttribute "virtual ArcSec::PeriodAttribute::~PeriodAttribute() ";

%feature("docstring")  ArcSec::PeriodAttribute::equal "virtual bool
ArcSec::PeriodAttribute::equal(AttributeValue *other, bool
check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::PeriodAttribute::encode "virtual
std::string ArcSec::PeriodAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::PeriodAttribute::getValue "ArcPeriod
ArcSec::PeriodAttribute::getValue() ";

%feature("docstring")  ArcSec::PeriodAttribute::getType "virtual
std::string ArcSec::PeriodAttribute::getType()

Get the DataType of the <Attribute> ";

%feature("docstring")  ArcSec::PeriodAttribute::getId "virtual
std::string ArcSec::PeriodAttribute::getId()

Get the AttributeId of the <Attribute> ";


// File: classArcSec_1_1PermitOverridesCombiningAlg.xml
%feature("docstring") ArcSec::PermitOverridesCombiningAlg "

Implement the \"Permit-Overrides\" algorithm.

Permit-Overrides, scans the policy set which is given as the
parameters of \"combine\" method, if gets \"permit\" result from any
policy, then stops scanning and gives \"permit\" as result, otherwise
gives \"deny\".

C++ includes: PermitOverridesAlg.h ";

%feature("docstring")
ArcSec::PermitOverridesCombiningAlg::PermitOverridesCombiningAlg "ArcSec::PermitOverridesCombiningAlg::PermitOverridesCombiningAlg() ";

%feature("docstring")
ArcSec::PermitOverridesCombiningAlg::~PermitOverridesCombiningAlg "virtual
ArcSec::PermitOverridesCombiningAlg::~PermitOverridesCombiningAlg() ";

%feature("docstring")  ArcSec::PermitOverridesCombiningAlg::combine "virtual Result
ArcSec::PermitOverridesCombiningAlg::combine(EvaluationCtx *ctx,
std::list< Policy * > policies)

If there is one policy which return positive evaluation result, then
omit the other policies and return DECISION_PERMIT

Parameters:
-----------

ctx:  This object contains request information which will be used to
evaluated against policy.

policlies:  This is a container which contains policy objects.

The combined result according to the algorithm. ";

%feature("docstring")  ArcSec::PermitOverridesCombiningAlg::getalgId "virtual const std::string&
ArcSec::PermitOverridesCombiningAlg::getalgId(void) const

Get the identifier ";


// File: classArc_1_1Plexer.xml
%feature("docstring") Arc::Plexer "

The Plexer class, used for routing messages to services.

This is the Plexer class. Its purpose is to route incoming messages to
appropriate Services and MCC chains.

C++ includes: Plexer.h ";

%feature("docstring")  Arc::Plexer::Plexer "Arc::Plexer::Plexer(Config *cfg)

The constructor.

This is the constructor. Since all member variables are instances of
\"well-behaving\" STL classes, nothing needs to be done. ";

%feature("docstring")  Arc::Plexer::~Plexer "virtual
Arc::Plexer::~Plexer()

The destructor.

This is the destructor. Since all member variables are instances of
\"well-behaving\" STL classes, nothing needs to be done. ";

%feature("docstring")  Arc::Plexer::Next "virtual void
Arc::Plexer::Next(MCCInterface *next, const std::string &label)

Add reference to next MCC in chain.

This method is called by Loader for every potentially labeled link to
next component which implements MCCInterface. If next is set NULL
corresponding link is removed. ";

%feature("docstring")  Arc::Plexer::process "virtual MCC_Status
Arc::Plexer::process(Message &request, Message &response)

Route request messages to appropriate services.

Routes the request message to the appropriate service. Routing is
based on the path part of value of the ENDPOINT attribute. Routed
message is assigned following attributes: PLEXER:PATTERN - matched
pattern, PLEXER:EXTENSION - last unmatched part of ENDPOINT path. ";


// File: classArc_1_1PlexerEntry.xml
%feature("docstring") Arc::PlexerEntry "

A pair of label (regex) and pointer to MCC.

A helper class that stores a label (regex) and a pointer to a service.

C++ includes: Plexer.h ";


// File: classArc_1_1Plugin.xml
%feature("docstring") Arc::Plugin "

Base class for loadable ARC components.

All classes representing loadable ARC components must be either
descendants of this class or be wrapped by its offspring.

C++ includes: Plugin.h ";

%feature("docstring")  Arc::Plugin::~Plugin "virtual
Arc::Plugin::~Plugin(void) ";


// File: classArc_1_1PluginArgument.xml
%feature("docstring") Arc::PluginArgument "

Base class for passing arguments to loadable ARC components.

During its creation constructor function of ARC loadable component
expects instance of class inherited from this one or wrapped in it.
Then dynamic type casting is used for obtaining class of expected
kind.

C++ includes: Plugin.h ";

%feature("docstring")  Arc::PluginArgument::~PluginArgument "virtual
Arc::PluginArgument::~PluginArgument(void) ";

%feature("docstring")  Arc::PluginArgument::get_factory "PluginsFactory* Arc::PluginArgument::get_factory(void)

Returns pointer to factory which instantiated plugin.

Because factory usually destroys/unloads plugins in its destructor it
should be safe to keep this pointer inside plugin for later use. But
one must always check. ";

%feature("docstring")  Arc::PluginArgument::get_module "Glib::Module*
Arc::PluginArgument::get_module(void)

Returns pointer to loadable module/library which contains plugin.

Corresponding factory keeps list of modules till itself is destroyed.
So it should be safe to keep that pointer. But care must be taken if
module contains persistent plugins. Such modules stay in memory after
factory is detroyed. So it is advisable to use obtained pointer only
in constructor function of plugin. ";


// File: classArc_1_1PluginDesc.xml
%feature("docstring") Arc::PluginDesc "

Description of plugin.

This class is used for reports

C++ includes: Plugin.h ";


// File: structArc_1_1PluginDescriptor.xml
%feature("docstring") Arc::PluginDescriptor "

Description of ARC lodable component.

C++ includes: Plugin.h ";


// File: classArc_1_1PluginsFactory.xml
%feature("docstring") Arc::PluginsFactory "

Generic ARC plugins loader.

The instance of this class provides functionality of loading pluggable
ARC components stored in shared libraries. For more information please
check HED documentation. This class is thread-safe - its methods are
proceted from simultatneous use form multiple threads. Current thread
protection implementation is suboptimal and will be revised in future.

C++ includes: Plugin.h ";

%feature("docstring")  Arc::PluginsFactory::PluginsFactory "Arc::PluginsFactory::PluginsFactory(XMLNode cfg)

Constructor - accepts configuration (not yet used) meant to tune
loading of modules. ";

%feature("docstring")  Arc::PluginsFactory::TryLoad "void
Arc::PluginsFactory::TryLoad(bool v=true)

These methods load module named lib'name', locate plugin constructor
functions of specified 'kind' and 'name' (if specified) and call it.
Supplied argument affects way plugin instance is created in plugin-
specific way. If name of plugin is not specified then all plugins of
specified kind are tried with supplied argument till valid instance is
created. All loaded plugins are also registered in internal list of
this instance of PluginsFactory class. If search is set to false then
no attempt is made to find plugins in loadable modules. Only plugins
already loaded with previous calls to get_instance() and load() are
checked. Returns created instance or NULL if failed. Specifies if
loadable module may be loaded while looking for analyzing its content.
If set to false only *.apd files are checked. Modules without
corresponding *.apd will be ignored. Default is true; ";

%feature("docstring")  Arc::PluginsFactory::TryLoad "bool
Arc::PluginsFactory::TryLoad(void) ";

%feature("docstring")  Arc::PluginsFactory::get_instance "Plugin*
Arc::PluginsFactory::get_instance(const std::string &kind,
PluginArgument *arg, bool search=true) ";

%feature("docstring")  Arc::PluginsFactory::get_instance "Plugin*
Arc::PluginsFactory::get_instance(const std::string &kind, int
version, PluginArgument *arg, bool search=true) ";

%feature("docstring")  Arc::PluginsFactory::get_instance "Plugin*
Arc::PluginsFactory::get_instance(const std::string &kind, int
min_version, int max_version, PluginArgument *arg, bool search=true)
";

%feature("docstring")  Arc::PluginsFactory::get_instance "Plugin*
Arc::PluginsFactory::get_instance(const std::string &kind, const
std::string &name, PluginArgument *arg, bool search=true) ";

%feature("docstring")  Arc::PluginsFactory::get_instance "Plugin*
Arc::PluginsFactory::get_instance(const std::string &kind, const
std::string &name, int version, PluginArgument *arg, bool search=true)
";

%feature("docstring")  Arc::PluginsFactory::get_instance "Plugin*
Arc::PluginsFactory::get_instance(const std::string &kind, const
std::string &name, int min_version, int max_version, PluginArgument
*arg, bool search=true) ";

%feature("docstring")  Arc::PluginsFactory::load "bool
Arc::PluginsFactory::load(const std::string &name)

These methods load module named lib'name' and check if it contains ARC
plugin(s) of specified 'kind' and 'name'. If there are no specified
plugins or module does not contain any ARC plugins it is unloaded. All
loaded plugins are also registered in internal list of this instance
of PluginsFactory class. Returns true if any plugin was loaded. ";

%feature("docstring")  Arc::PluginsFactory::load "bool
Arc::PluginsFactory::load(const std::string &name, const std::string
&kind) ";

%feature("docstring")  Arc::PluginsFactory::load "bool
Arc::PluginsFactory::load(const std::string &name, const std::string
&kind, const std::string &pname) ";

%feature("docstring")  Arc::PluginsFactory::load "bool
Arc::PluginsFactory::load(const std::string &name, const std::list<
std::string > &kinds) ";

%feature("docstring")  Arc::PluginsFactory::load "bool
Arc::PluginsFactory::load(const std::list< std::string > &names, const
std::string &kind) ";

%feature("docstring")  Arc::PluginsFactory::load "bool
Arc::PluginsFactory::load(const std::list< std::string > &names, const
std::string &kind, const std::string &pname) ";

%feature("docstring")  Arc::PluginsFactory::load "bool
Arc::PluginsFactory::load(const std::list< std::string > &names, const
std::list< std::string > &kinds) ";

%feature("docstring")  Arc::PluginsFactory::scan "bool
Arc::PluginsFactory::scan(const std::string &name, ModuleDesc &desc)

Collect information about plugins stored in module(s) with specified
names. Returns true if any of specified modules has plugins. ";

%feature("docstring")  Arc::PluginsFactory::scan "bool
Arc::PluginsFactory::scan(const std::list< std::string > &names,
std::list< ModuleDesc > &descs) ";

%feature("docstring")  Arc::PluginsFactory::report "void
Arc::PluginsFactory::report(std::list< ModuleDesc > &descs)

Provides information about currently loaded modules and plugins. ";

%feature("docstring")  Arc::PluginsFactory::GetInstance "P*
Arc::PluginsFactory::GetInstance(const std::string &kind,
PluginArgument *arg, bool search=true) ";

%feature("docstring")  Arc::PluginsFactory::GetInstance "P*
Arc::PluginsFactory::GetInstance(const std::string &kind, const
std::string &name, PluginArgument *arg, bool search=true) ";


// File: classArcSec_1_1Policy.xml
%feature("docstring") ArcSec::Policy "

Interface for containing and processing different types of policy.

Basically, each policy object is a container which includes a few
elements e.g., ArcPolicySet objects includes a few ArcPolicy objects;
ArcPolicy object includes a few ArcRule objects. There is logical
relationship between ArcRules or ArcPolicies, which is called
combining algorithm. According to algorithm, evaluation results from
the elements are combined, and then the combined evaluation result is
returned to the up-level.

C++ includes: Policy.h ";

%feature("docstring")  ArcSec::Policy::Policy "ArcSec::Policy::Policy()

Template constructor - creates empty policy. ";

%feature("docstring")  ArcSec::Policy::Policy "ArcSec::Policy::Policy(const Arc::XMLNode)

Template constructor - creates policy based on XML document.

If XML document is empty then empty policy is created. If it is not
empty then it must be valid policy document - otherwise created object
should be invalid. ";

%feature("docstring")  ArcSec::Policy::Policy "ArcSec::Policy::Policy(const Arc::XMLNode, EvaluatorContext *)

Template constructor - creates policy based on XML document.

If XML document is empty then empty policy is created. If it is not
empty then it must be valid policy document - otherwise created object
should be invalid. This constructor is based on the policy node and i
the EvaluatorContext which includes the factory objects for combining
algorithm and function ";

%feature("docstring")  ArcSec::Policy::~Policy "virtual
ArcSec::Policy::~Policy() ";

%feature("docstring")  ArcSec::Policy::match "virtual MatchResult
ArcSec::Policy::match(EvaluationCtx *)=0

Evaluate whether the two targets to be evaluated match to each other.
";

%feature("docstring")  ArcSec::Policy::eval "virtual Result
ArcSec::Policy::eval(EvaluationCtx *)=0

Evaluate policy For the <Rule> of Arc, only get the \"Effect\" from
rules; For the <Policy> of Arc, combine the evaluation result from
<Rule>; For the <Rule> of XACML, evaluate the <Condition> node by
using information from request, and use the \"Effect\" attribute of
<Rule>; For the <Policy> of XACML, combine the evaluation result from
<Rule> ";

%feature("docstring")  ArcSec::Policy::addPolicy "virtual void
ArcSec::Policy::addPolicy(Policy *pl)

Add a policy element to into \"this\" object ";

%feature("docstring")  ArcSec::Policy::setEvaluatorContext "virtual
void ArcSec::Policy::setEvaluatorContext(EvaluatorContext *)

Set Evaluator Context for the usage in creating low-level policy
object ";

%feature("docstring")  ArcSec::Policy::make_policy "virtual void
ArcSec::Policy::make_policy()

Parse XMLNode, and construct the low-level Rule object ";

%feature("docstring")  ArcSec::Policy::getEffect "virtual std::string
ArcSec::Policy::getEffect() const =0

Get the \"Effect\" attribute ";

%feature("docstring")  ArcSec::Policy::getEvalResult "virtual
EvalResult& ArcSec::Policy::getEvalResult()=0

Get eveluation result ";

%feature("docstring")  ArcSec::Policy::setEvalResult "virtual void
ArcSec::Policy::setEvalResult(EvalResult &res)=0

Set eveluation result ";

%feature("docstring")  ArcSec::Policy::getEvalName "virtual const
char* ArcSec::Policy::getEvalName() const =0

Get the name of Evaluator which can evaluate this policy ";

%feature("docstring")  ArcSec::Policy::getName "virtual const char*
ArcSec::Policy::getName() const =0

Get the name of this policy ";


// File: classArcSec_1_1PolicyStore_1_1PolicyElement.xml
%feature("docstring") ArcSec::PolicyStore::PolicyElement "";

%feature("docstring")
ArcSec::PolicyStore::PolicyElement::PolicyElement "ArcSec::PolicyStore::PolicyElement::PolicyElement(Policy *policy_) ";

%feature("docstring")
ArcSec::PolicyStore::PolicyElement::PolicyElement "ArcSec::PolicyStore::PolicyElement::PolicyElement(Policy *policy_,
const std::string &id_) ";

%feature("docstring")  ArcSec::PolicyStore::PolicyElement::Id "const
std::string& ArcSec::PolicyStore::PolicyElement::Id(void) const ";


// File: classArcSec_1_1PolicyParser.xml
%feature("docstring") ArcSec::PolicyParser "

A interface which will isolate the policy object from actual policy
storage (files, urls, database)

Parse the policy from policy source (e.g. files, urls, database,
etc.).

C++ includes: PolicyParser.h ";

%feature("docstring")  ArcSec::PolicyParser::PolicyParser "ArcSec::PolicyParser::PolicyParser() ";

%feature("docstring")  ArcSec::PolicyParser::parsePolicy "virtual
Policy* ArcSec::PolicyParser::parsePolicy(const Source &source,
std::string policyclassname, EvaluatorContext *ctx)

Parse policy

Parameters:
-----------

source:  location of the policy

policyclassname:  name of the policy for ClassLoader

ctx:   EvaluatorContext which includes the **Factory ";

%feature("docstring")  ArcSec::PolicyParser::~PolicyParser "virtual
ArcSec::PolicyParser::~PolicyParser() ";


// File: classArcSec_1_1PolicyStore.xml
%feature("docstring") ArcSec::PolicyStore "

Storage place for policy objects.

C++ includes: PolicyStore.h ";

%feature("docstring")  ArcSec::PolicyStore::PolicyStore "ArcSec::PolicyStore::PolicyStore() ";

%feature("docstring")  ArcSec::PolicyStore::PolicyStore "ArcSec::PolicyStore::PolicyStore(const std::string &alg, const
std::string &policyclassname, EvaluatorContext *ctx)

Creates policy store with specified combing algorithm (alg - not used
yet), policy name (policyclassname) and context (ctx) ";

%feature("docstring")  ArcSec::PolicyStore::~PolicyStore "virtual
ArcSec::PolicyStore::~PolicyStore() ";

%feature("docstring")  ArcSec::PolicyStore::findPolicy "virtual
std::list<PolicyElement> ArcSec::PolicyStore::findPolicy(EvaluationCtx
*context) ";

%feature("docstring")  ArcSec::PolicyStore::addPolicy "virtual void
ArcSec::PolicyStore::addPolicy(const Source &policy, EvaluatorContext
*ctx, const std::string &id) ";

%feature("docstring")  ArcSec::PolicyStore::addPolicy "virtual void
ArcSec::PolicyStore::addPolicy(Policy *policyobj, EvaluatorContext
*ctx, const std::string &id) ";

%feature("docstring")  ArcSec::PolicyStore::removePolicies "virtual
void ArcSec::PolicyStore::removePolicies() ";

%feature("docstring")  ArcSec::PolicyStore::releasePolicies "virtual
void ArcSec::PolicyStore::releasePolicies() ";


// File: classArc_1_1PrintF.xml
%feature("docstring") Arc::PrintF "";

%feature("docstring")  Arc::PrintF::PrintF "Arc::PrintF< T0, T1, T2,
T3, T4, T5, T6, T7 >::PrintF(const std::string &m, const T0 &tt0=0,
const T1 &tt1=0, const T2 &tt2=0, const T3 &tt3=0, const T4 &tt4=0,
const T5 &tt5=0, const T6 &tt6=0, const T7 &tt7=0) ";

%feature("docstring")  Arc::PrintF::~PrintF "Arc::PrintF< T0, T1, T2,
T3, T4, T5, T6, T7 >::~PrintF() ";

%feature("docstring")  Arc::PrintF::msg "void Arc::PrintF< T0, T1,
T2, T3, T4, T5, T6, T7 >::msg(std::ostream &os) ";


// File: classArc_1_1PrintFBase.xml
%feature("docstring") Arc::PrintFBase "";

%feature("docstring")  Arc::PrintFBase::PrintFBase "Arc::PrintFBase::PrintFBase() ";

%feature("docstring")  Arc::PrintFBase::~PrintFBase "virtual
Arc::PrintFBase::~PrintFBase() ";

%feature("docstring")  Arc::PrintFBase::msg "virtual void
Arc::PrintFBase::msg(std::ostream &os)=0 ";

%feature("docstring")  Arc::PrintFBase::Retain "void
Arc::PrintFBase::Retain() ";

%feature("docstring")  Arc::PrintFBase::Release "bool
Arc::PrintFBase::Release() ";


// File: classArc_1_1Profile.xml
%feature("docstring") Arc::Profile "";

%feature("docstring")  Arc::Profile::Profile "Arc::Profile::Profile(const std::string &filename) ";

%feature("docstring")  Arc::Profile::~Profile "Arc::Profile::~Profile() ";

%feature("docstring")  Arc::Profile::Evaluate "void
Arc::Profile::Evaluate(Config &cfg, IniConfig ini) ";


// File: structArcCredential_1_1PROXYCERTINFO__st.xml
%feature("docstring") ArcCredential::PROXYCERTINFO_st "";


// File: structArcCredential_1_1PROXYPOLICY__st.xml
%feature("docstring") ArcCredential::PROXYPOLICY_st "";


// File: classArc_1_1Query.xml
%feature("docstring") Arc::Query "";

%feature("docstring")  Arc::Query::Query "Arc::Query::Query()

Default constructor ";

%feature("docstring")  Arc::Query::Query "Arc::Query::Query(Database
*db)

Constructor

Parameters:
-----------

db:  The database object which will be used by Query class to get the
database connection ";

%feature("docstring")  Arc::Query::~Query "virtual
Arc::Query::~Query()

Deconstructor ";

%feature("docstring")  Arc::Query::get_num_colums "virtual int
Arc::Query::get_num_colums()=0

Get the colum number in the query result ";

%feature("docstring")  Arc::Query::get_num_rows "virtual int
Arc::Query::get_num_rows()=0

Get the row number in the query result ";

%feature("docstring")  Arc::Query::execute "virtual bool
Arc::Query::execute(const std::string &sqlstr)=0

Execute the query

Parameters:
-----------

sqlstr:  The sql sentence used to query ";

%feature("docstring")  Arc::Query::get_row "virtual QueryRowResult
Arc::Query::get_row(int row_number) const =0

Get the value of one row in the query result

Parameters:
-----------

row_number:  The number of the row

A vector includes all the values in the row ";

%feature("docstring")  Arc::Query::get_row "virtual QueryRowResult
Arc::Query::get_row() const =0

Get the value of one row in the query result, the row number will be
automatically increased each time the method is called ";

%feature("docstring")  Arc::Query::get_row_field "virtual std::string
Arc::Query::get_row_field(int row_number, std::string &field_name)=0

Get the value of one specific field in one specific row

Parameters:
-----------

row_number:  The row number inside the query result

field_name:  The field name for the value which will be return

The value of the specified filed in the specified row ";

%feature("docstring")  Arc::Query::get_array "virtual bool
Arc::Query::get_array(std::string &sqlstr, QueryArrayResult &result,
std::vector< std::string > &arguments)=0

Query the database by using some parameters into sql sentence e.g.
\"select table.value from table where table.name = ?\"

Parameters:
-----------

sqlstr:  The sql sentence with some parameters marked with \"?\".

result:  The result in an array which includes all of the value in
query result.

arguments:  The argument list which should exactely correspond with
the parametes in sql sentence. ";


// File: classArc_1_1Range.xml
%feature("docstring") Arc::Range "";

%feature("docstring")  Arc::Range::Range "Arc::Range< T >::Range() ";

%feature("docstring")  Arc::Range::Range "Arc::Range< T
>::Range(const T &t) ";


// File: structArc_1_1Register__Info__Type.xml
%feature("docstring") Arc::Register_Info_Type "";


// File: classArc_1_1RegisteredService.xml
%feature("docstring") Arc::RegisteredService "

RegisteredService - extension of Service performing self-registration.

C++ includes: RegisteredService.h ";

%feature("docstring")  Arc::RegisteredService::RegisteredService "Arc::RegisteredService::RegisteredService(Config *)

Example contructor - Server takes at least it's configuration subtree
";

%feature("docstring")  Arc::RegisteredService::~RegisteredService "virtual Arc::RegisteredService::~RegisteredService(void) ";


// File: classArc_1_1RegularExpression.xml
%feature("docstring") Arc::RegularExpression "

A regular expression class.

This class is a wrapper around the functions provided in regex.h.

C++ includes: ArcRegex.h ";

%feature("docstring")  Arc::RegularExpression::RegularExpression "Arc::RegularExpression::RegularExpression()

default constructor ";

%feature("docstring")  Arc::RegularExpression::RegularExpression "Arc::RegularExpression::RegularExpression(std::string pattern)

Creates a reges from a pattern string. ";

%feature("docstring")  Arc::RegularExpression::RegularExpression "Arc::RegularExpression::RegularExpression(const RegularExpression
&regex)

Copy constructor. ";

%feature("docstring")  Arc::RegularExpression::~RegularExpression "Arc::RegularExpression::~RegularExpression()

Destructor. ";

%feature("docstring")  Arc::RegularExpression::isOk "bool
Arc::RegularExpression::isOk()

Returns true if the pattern of this regex is ok. ";

%feature("docstring")  Arc::RegularExpression::hasPattern "bool
Arc::RegularExpression::hasPattern(std::string str)

Returns true if this regex has the pattern provided. ";

%feature("docstring")  Arc::RegularExpression::match "bool
Arc::RegularExpression::match(const std::string &str) const

Returns true if this regex matches whole string provided. ";

%feature("docstring")  Arc::RegularExpression::match "bool
Arc::RegularExpression::match(const std::string &str, std::list<
std::string > &unmatched, std::list< std::string > &matched) const

Returns true if this regex matches the string provided.

Unmatched parts of the string are stored in 'unmatched'. Matched parts
of the string are stored in 'matched'. The first entry in matched is
the string that matched the regex, and the following entries are
parenthesised elements of the regex ";

%feature("docstring")  Arc::RegularExpression::getPattern "std::string Arc::RegularExpression::getPattern() const

Returns pattern. ";


// File: classArcSec_1_1Request.xml
%feature("docstring") ArcSec::Request "

Base class/Interface for request, includes a container for
RequestItems and some operations.

A Request object can has a few <subjects, actions, objects> tuples,
i.e. RequestItem The Request class and any customized class which
inherit from it, should be loadable, which means these classes can be
dynamically loaded according to the configuration informtation, see
the example configuration below: <Service name=\"pdp.service\"
id=\"pdp_service\"> <pdp:PDPConfig> <......> <pdp: Request
name=\"arc.request\" /> <......> </pdp:PDPConfig> </Service>

There can be different types of subclass which inherit Request, such
like XACMLRequest, ArcRequest, GACLRequest

C++ includes: Request.h ";

%feature("docstring")  ArcSec::Request::getRequestItems "virtual
ReqItemList ArcSec::Request::getRequestItems() const

Get all the RequestItem inside RequestItem container ";

%feature("docstring")  ArcSec::Request::setRequestItems "virtual void
ArcSec::Request::setRequestItems(ReqItemList)

Set the content of the container ";

%feature("docstring")  ArcSec::Request::addRequestItem "virtual void
ArcSec::Request::addRequestItem(Attrs &, Attrs &, Attrs &, Attrs &)

Add request tuple from non-XMLNode ";

%feature("docstring")  ArcSec::Request::setAttributeFactory "virtual
void ArcSec::Request::setAttributeFactory(AttributeFactory
*attributefactory)=0

Set the attribute factory for the usage of Request ";

%feature("docstring")  ArcSec::Request::make_request "virtual void
ArcSec::Request::make_request()=0

Create the objects included in Request according to the node attached
to the Request object ";

%feature("docstring")  ArcSec::Request::getEvalName "virtual const
char* ArcSec::Request::getEvalName() const =0

Get the name of corresponding evaulator ";

%feature("docstring")  ArcSec::Request::getName "virtual const char*
ArcSec::Request::getName() const =0

Get the name of this request ";

%feature("docstring")  ArcSec::Request::Request "ArcSec::Request::Request()

Default constructor ";

%feature("docstring")  ArcSec::Request::Request "ArcSec::Request::Request(const Source &)

Constructor: Parse request information from a xml stucture in memory
";

%feature("docstring")  ArcSec::Request::getReqNode "virtual
Arc::XMLNode& ArcSec::Request::getReqNode()=0 ";

%feature("docstring")  ArcSec::Request::~Request "virtual
ArcSec::Request::~Request() ";


// File: classArcSec_1_1RequestAttribute.xml
%feature("docstring") ArcSec::RequestAttribute "

Wrapper which includes AttributeValue object which is generated
according to date type of one spefic node in Request.xml.

C++ includes: RequestAttribute.h ";

%feature("docstring")  ArcSec::RequestAttribute::RequestAttribute "ArcSec::RequestAttribute::RequestAttribute(Arc::XMLNode &node,
AttributeFactory *attrfactory)

Constructor - create attribute value object according to the \"Type\"
in the node <Attribute attributeid=\"urn:arc:subject:voms-attribute\"
type=\"string\">urn:mace:shibboleth:examples</Attribute> ";

%feature("docstring")  ArcSec::RequestAttribute::RequestAttribute "ArcSec::RequestAttribute::RequestAttribute() ";

%feature("docstring")  ArcSec::RequestAttribute::~RequestAttribute "virtual ArcSec::RequestAttribute::~RequestAttribute() ";

%feature("docstring")  ArcSec::RequestAttribute::getNode "Arc::XMLNode ArcSec::RequestAttribute::getNode() ";

%feature("docstring")  ArcSec::RequestAttribute::getAttributeId "std::string ArcSec::RequestAttribute::getAttributeId() const ";

%feature("docstring")  ArcSec::RequestAttribute::setAttributeId "void
ArcSec::RequestAttribute::setAttributeId(const std::string
attributeId) ";

%feature("docstring")  ArcSec::RequestAttribute::getDataType "std::string ArcSec::RequestAttribute::getDataType() const ";

%feature("docstring")  ArcSec::RequestAttribute::setDataType "void
ArcSec::RequestAttribute::setDataType(const std::string dataType) ";

%feature("docstring")  ArcSec::RequestAttribute::getIssuer "std::string ArcSec::RequestAttribute::getIssuer() const ";

%feature("docstring")  ArcSec::RequestAttribute::setIssuer "void
ArcSec::RequestAttribute::setIssuer(const std::string issuer) ";

%feature("docstring")  ArcSec::RequestAttribute::getAttributeValue "virtual AttributeValue* ArcSec::RequestAttribute::getAttributeValue()
const ";

%feature("docstring")  ArcSec::RequestAttribute::getAttributeFactory "virtual AttributeFactory*
ArcSec::RequestAttribute::getAttributeFactory() const ";

%feature("docstring")  ArcSec::RequestAttribute::duplicate "RequestAttribute& ArcSec::RequestAttribute::duplicate(RequestAttribute
&)

Duplicate the parameter into \"this\" ";


// File: classArcSec_1_1RequestItem.xml
%feature("docstring") ArcSec::RequestItem "

Interface for request item container, <subjects, actions, objects,
ctxs> tuple.

C++ includes: RequestItem.h ";

%feature("docstring")  ArcSec::RequestItem::RequestItem "ArcSec::RequestItem::RequestItem(Arc::XMLNode &, AttributeFactory *)

Constructor

Parameters:
-----------

node:  The XMLNode structure of the request item

attributefactory:  The AttributeFactory which will be used to generate
RequestAttribute ";

%feature("docstring")  ArcSec::RequestItem::~RequestItem "virtual
ArcSec::RequestItem::~RequestItem() ";

%feature("docstring")  ArcSec::RequestItem::getSubjects "virtual
SubList ArcSec::RequestItem::getSubjects() const =0 ";

%feature("docstring")  ArcSec::RequestItem::setSubjects "virtual void
ArcSec::RequestItem::setSubjects(const SubList &sl)=0 ";

%feature("docstring")  ArcSec::RequestItem::getResources "virtual
ResList ArcSec::RequestItem::getResources() const =0 ";

%feature("docstring")  ArcSec::RequestItem::setResources "virtual
void ArcSec::RequestItem::setResources(const ResList &rl)=0 ";

%feature("docstring")  ArcSec::RequestItem::getActions "virtual
ActList ArcSec::RequestItem::getActions() const =0 ";

%feature("docstring")  ArcSec::RequestItem::setActions "virtual void
ArcSec::RequestItem::setActions(const ActList &al)=0 ";

%feature("docstring")  ArcSec::RequestItem::getContexts "virtual
CtxList ArcSec::RequestItem::getContexts() const =0 ";

%feature("docstring")  ArcSec::RequestItem::setContexts "virtual void
ArcSec::RequestItem::setContexts(const CtxList &ctx)=0 ";


// File: classArcSec_1_1RequestTuple.xml
%feature("docstring") ArcSec::RequestTuple "";

%feature("docstring")  ArcSec::RequestTuple::duplicate "virtual
RequestTuple* ArcSec::RequestTuple::duplicate(const RequestTuple *) ";

%feature("docstring")  ArcSec::RequestTuple::getNode "virtual
Arc::XMLNode& ArcSec::RequestTuple::getNode() ";

%feature("docstring")  ArcSec::RequestTuple::RequestTuple "ArcSec::RequestTuple::RequestTuple() ";

%feature("docstring")  ArcSec::RequestTuple::~RequestTuple "virtual
ArcSec::RequestTuple::~RequestTuple() ";

%feature("docstring")  ArcSec::RequestTuple::erase "virtual void
ArcSec::RequestTuple::erase() ";


// File: classArc_1_1ResourceSlotType.xml
%feature("docstring") Arc::ResourceSlotType "";

%feature("docstring")  Arc::ResourceSlotType::ResourceSlotType "Arc::ResourceSlotType::ResourceSlotType() ";


// File: classArc_1_1ResourcesType.xml
%feature("docstring") Arc::ResourcesType "";

%feature("docstring")  Arc::ResourcesType::ResourcesType "Arc::ResourcesType::ResourcesType() ";


// File: classArcSec_1_1Response.xml
%feature("docstring") ArcSec::Response "

Container for the evaluation results.

C++ includes: Response.h ";

%feature("docstring")  ArcSec::Response::setRequestSize "void
ArcSec::Response::setRequestSize(int size) ";

%feature("docstring")  ArcSec::Response::getRequestSize "int
ArcSec::Response::getRequestSize() ";

%feature("docstring")  ArcSec::Response::getResponseItems "virtual
ResponseList& ArcSec::Response::getResponseItems() ";

%feature("docstring")  ArcSec::Response::setResponseItems "virtual
void ArcSec::Response::setResponseItems(const ResponseList &rl) ";

%feature("docstring")  ArcSec::Response::addResponseItem "virtual
void ArcSec::Response::addResponseItem(ResponseItem *respitem) ";

%feature("docstring")  ArcSec::Response::~Response "virtual
ArcSec::Response::~Response() ";


// File: classArcSec_1_1ResponseItem.xml
%feature("docstring") ArcSec::ResponseItem "

Evaluation result concerning one RequestTuple.

Include the RequestTuple, related XMLNode, the set of policy objects
which give positive evaluation result, and the related XMLNode

C++ includes: Response.h ";

%feature("docstring")  ArcSec::ResponseItem::ResponseItem "ArcSec::ResponseItem::ResponseItem() ";


// File: classArcSec_1_1ResponseList.xml
%feature("docstring") ArcSec::ResponseList "";

%feature("docstring")  ArcSec::ResponseList::addItem "void
ArcSec::ResponseList::addItem(ResponseItem *item) ";

%feature("docstring")  ArcSec::ResponseList::size "int
ArcSec::ResponseList::size() ";

%feature("docstring")  ArcSec::ResponseList::getItem "ResponseItem*
ArcSec::ResponseList::getItem(int n) ";

%feature("docstring")  ArcSec::ResponseList::empty "bool
ArcSec::ResponseList::empty() ";

%feature("docstring")  ArcSec::ResponseList::clear "void
ArcSec::ResponseList::clear() ";


// File: classArc_1_1Run.xml
%feature("docstring") Arc::Run "

This class runs external executable. It is possible to read/write it's
standard handles or to redirect then to std::string elements.

C++ includes: Run.h ";

%feature("docstring")  Arc::Run::Run "Arc::Run::Run(const std::string
&cmdline)

Constructor preapres object to run cmdline ";

%feature("docstring")  Arc::Run::Run "Arc::Run::Run(const std::list<
std::string > &argv)

Constructor preapres object to run executable and arguments specified
in argv ";

%feature("docstring")  Arc::Run::~Run "Arc::Run::~Run(void)

Destructor kills running executable and releases associated resources
";

%feature("docstring")  Arc::Run::Start "bool Arc::Run::Start(void)

Starts running executable. This method may be called only once. ";

%feature("docstring")  Arc::Run::Wait "bool Arc::Run::Wait(int
timeout)

Wait till execution finished or till timeout seconds expires. Returns
true if execution is complete. ";

%feature("docstring")  Arc::Run::Wait "bool Arc::Run::Wait(void)

Wait till execution finished ";

%feature("docstring")  Arc::Run::Result "int Arc::Run::Result(void)

Returns exit code of execution. ";

%feature("docstring")  Arc::Run::Running "bool
Arc::Run::Running(void)

Return true if execution is going on. ";

%feature("docstring")  Arc::Run::ReadStdout "int
Arc::Run::ReadStdout(int timeout, char *buf, int size)

Read from stdout handle of running executable. Parameter timeout
specifies upper limit for which method will block in milliseconds.
Negative means infinite. This method may be used while stdout is
directed to string. But result is unpredictable. Returns number of
read bytes. ";

%feature("docstring")  Arc::Run::ReadStderr "int
Arc::Run::ReadStderr(int timeout, char *buf, int size)

Read from stderr handle of running executable. Parameter timeout
specifies upper limit for which method will block in milliseconds.
Negative means infinite. This method may be used while stderr is
directed to string. But result is unpredictable. Returns number of
read bytes. ";

%feature("docstring")  Arc::Run::WriteStdin "int
Arc::Run::WriteStdin(int timeout, const char *buf, int size)

Write to stdin handle of running executable. Parameter timeout
specifies upper limit for which method will block in milliseconds.
Negative means infinite. This method may be used while stdin is
directed to string. But result is unpredictable. Returns number of
written bytes. ";

%feature("docstring")  Arc::Run::AssignStdout "void
Arc::Run::AssignStdout(std::string &str)

Associate stdout handle of executable with string. This method must be
called before Start(). str object must be valid as long as this object
exists. ";

%feature("docstring")  Arc::Run::AssignStderr "void
Arc::Run::AssignStderr(std::string &str)

Associate stderr handle of executable with string. This method must be
called before Start(). str object must be valid as long as this object
exists. ";

%feature("docstring")  Arc::Run::AssignStdin "void
Arc::Run::AssignStdin(std::string &str)

Associate stdin handle of executable with string. This method must be
called before Start(). str object must be valid as long as this object
exists. ";

%feature("docstring")  Arc::Run::KeepStdout "void
Arc::Run::KeepStdout(bool keep=true)

Keep stdout same as parent's if keep = true ";

%feature("docstring")  Arc::Run::KeepStderr "void
Arc::Run::KeepStderr(bool keep=true)

Keep stderr same as parent's if keep = true ";

%feature("docstring")  Arc::Run::KeepStdin "void
Arc::Run::KeepStdin(bool keep=true)

Keep stdin same as parent's if keep = true ";

%feature("docstring")  Arc::Run::CloseStdout "void
Arc::Run::CloseStdout(void)

Closes pipe associated with stdout handle ";

%feature("docstring")  Arc::Run::CloseStderr "void
Arc::Run::CloseStderr(void)

Closes pipe associated with stderr handle ";

%feature("docstring")  Arc::Run::CloseStdin "void
Arc::Run::CloseStdin(void)

Closes pipe associated with stdin handle ";

%feature("docstring")  Arc::Run::AssignInitializer "void
Arc::Run::AssignInitializer(void(*initializer_func)(void *), void
*initializer_arg) ";

%feature("docstring")  Arc::Run::AssignKicker "void
Arc::Run::AssignKicker(void(*kicker_func)(void *), void *kicker_arg)
";

%feature("docstring")  Arc::Run::AssignWorkingDirectory "void
Arc::Run::AssignWorkingDirectory(std::string &wd)

Assign working direcotry of the running process ";

%feature("docstring")  Arc::Run::AssignUserId "void
Arc::Run::AssignUserId(int uid) ";

%feature("docstring")  Arc::Run::AssignGroupId "void
Arc::Run::AssignGroupId(int gid) ";

%feature("docstring")  Arc::Run::Kill "void Arc::Run::Kill(int
timeout)

Kill running executable. First soft kill signal (SIGTERM) is sent to
executable. If after timeout seconds executable is still running it's
killed completely. Curently this method does not work for Windows OS
";

%feature("docstring")  Arc::Run::Abandon "void
Arc::Run::Abandon(void)

Detach this object from running process. After calling this method
instance is not associated with external process anymore. As result
destructor will not kill process. ";


// File: classArc_1_1SAML2LoginClient.xml
%feature("docstring") Arc::SAML2LoginClient "";

%feature("docstring")  Arc::SAML2LoginClient::SAML2LoginClient "Arc::SAML2LoginClient::SAML2LoginClient(const MCCConfig cfg, const URL
url, std::list< std::string > idp_stack)

list with the idp for nested wayf For example, Confusa can use
betawayf.wayf.dk as an identity provider, which is itself only a wayf
and shares the metadata with concrete service providers or even
further nested wayfs. Since due to mutual authentication with
metadata, we are obliged to follow the SSO redirects from WAYF to
WAYF, the WAYFs are stored in a list. ";

%feature("docstring")  Arc::SAML2LoginClient::~SAML2LoginClient "virtual Arc::SAML2LoginClient::~SAML2LoginClient() ";

%feature("docstring")  Arc::SAML2LoginClient::processLogin "virtual
MCC_Status Arc::SAML2LoginClient::processLogin(const std::string
username=\"\", const std::string password=\"\")=0

Base interface for all login procedures ";

%feature("docstring")  Arc::SAML2LoginClient::parseDN "virtual
MCC_Status Arc::SAML2LoginClient::parseDN(std::string *dn)=0 ";

%feature("docstring")  Arc::SAML2LoginClient::approveCSR "virtual
MCC_Status Arc::SAML2LoginClient::approveCSR(const std::string
approve_page)=0 ";

%feature("docstring")  Arc::SAML2LoginClient::pushCSR "virtual
MCC_Status Arc::SAML2LoginClient::pushCSR(const std::string
b64_pub_key, const std::string pub_key_hash, std::string
*approve_page)=0 ";

%feature("docstring")  Arc::SAML2LoginClient::storeCert "virtual
MCC_Status Arc::SAML2LoginClient::storeCert(const std::string
cert_path, const std::string auth_token, const std::string b64_dn)=0
";

%feature("docstring")  Arc::SAML2LoginClient::printBrowsingHistory "void Arc::SAML2LoginClient::printBrowsingHistory() ";

%feature("docstring")
Arc::SAML2LoginClient::findSimpleSAMLInstallation "MCC_Status
Arc::SAML2LoginClient::findSimpleSAMLInstallation()

find the location of the simplesamlphp installation on the SP side
Will be stored in (*sso_pages)[SimpleSAML] ";


// File: classArc_1_1SAML2SSOHTTPClient.xml
%feature("docstring") Arc::SAML2SSOHTTPClient "";

%feature("docstring")  Arc::SAML2SSOHTTPClient::SAML2SSOHTTPClient "Arc::SAML2SSOHTTPClient::SAML2SSOHTTPClient(const MCCConfig cfg, const
URL url, std::list< std::string > idp_stack) ";

%feature("docstring")  Arc::SAML2SSOHTTPClient::~SAML2SSOHTTPClient "virtual Arc::SAML2SSOHTTPClient::~SAML2SSOHTTPClient() ";

%feature("docstring")  Arc::SAML2SSOHTTPClient::processLogin "MCC_Status Arc::SAML2SSOHTTPClient::processLogin(const std::string
username, const std::string password)

Models complete SAML2 WebSSO authN flow with start -> WAYF -> Login ->
(consent) -> start ";

%feature("docstring")  Arc::SAML2SSOHTTPClient::parseDN "MCC_Status
Arc::SAML2SSOHTTPClient::parseDN(std::string *dn)

Parse the used DN from the Confusa about_you page ";

%feature("docstring")  Arc::SAML2SSOHTTPClient::approveCSR "MCC_Status Arc::SAML2SSOHTTPClient::approveCSR(const std::string
approve_page)

Simulate click on the approve cert signing request link ";

%feature("docstring")  Arc::SAML2SSOHTTPClient::pushCSR "MCC_Status
Arc::SAML2SSOHTTPClient::pushCSR(const std::string b64_pub_key, const
std::string pub_key_hash, std::string *approve_page)

Send the cert signing request to Confusa for signing ";

%feature("docstring")  Arc::SAML2SSOHTTPClient::storeCert "MCC_Status
Arc::SAML2SSOHTTPClient::storeCert(const std::string cert_path, const
std::string auth_token, const std::string b64_dn)

Download the signed certificate from Confusa and store it locally ";


// File: classArc_1_1SAMLToken.xml
%feature("docstring") Arc::SAMLToken "

Class for manipulating SAML Token Profile.

This class is for generating/consuming SAML Token profile. See WS-
Security SAML Token Profile v1.1 (www.oasis-open.org/committees/wss)
Currently this class is used by samltoken handler (will appears in
src/hed/pdc/samltokensh/) It is not a must to directly called this
class. If we need to use SAML Token functionality, we only need to
configure the samltoken handler into service and client. Currently,
only a minor part of the specification has been implemented.

About how to identify and reference security token for signing
message, currently, only the \"SAML Assertion Referenced from
KeyInfo\" (part 3.4.2 of WS-Security SAML Token Profile v1.1
specification) is supported, which means the implementation can only
process SAML assertion \"referenced from KeyInfo\", and also can only
generate SAML Token with SAML assertion \"referenced from KeyInfo\".
More complete support need to implement.

About subject confirmation method, the implementation can process
\"hold-of-key\" (part 3.5.1 of WS-Security SAML Token Profile v1.1
specification) subject subject confirmation method.

About SAML vertion, the implementation can process SAML assertion with
SAML version 1.1 and 2.0; can only generate SAML assertion with SAML
vertion 2.0.

In the SAML Token profile, for the hold-of-key subject confirmation
method, there are three interaction parts: the attesting entity, the
relying party and the issuing authority. In the hold-of-key subject
confirmation method, it is the attesting entity's subject identity
which will be inserted into the SAML assertion.

Firstly the attesting entity authenticates to issuing authority by
using some authentication scheme such as WSS x509 Token profile
(Alterbatively the usename/password authentication scheme or other
different authentication scheme can also be used, unless the issuing
authority can retrive the key from a trusted certificate server after
firmly establishing the subject's identity under the username/password
scheme). So then issuing authority is able to make a definitive
statement (sign a SAML assertion) about an act of authentication that
has already taken place.

The attesting entity gets the SAML assertion and then signs the soap
message together with the assertion by using its private key (the
relevant certificate has been authenticated by issuing authority, and
its relevant public key has been put into SubjectConfirmation element
under saml assertion by issuing authority. Only the actual owner of
the saml assertion can do this, as only the subject possesses the
private key paired with the public key in the assertion. This
establishes an irrefutable connection between the author of the SOAP
message and the assertion describing an authentication event.)

The relying party is supposed to trust the issuing authority. When it
receives a message from the asserting entity, it will check the saml
assertion based on its predetermined trust relationship with the SAML
issuing authority, and check the signature of the soap message based
on the public key in the saml assertion without directly trust
relationship with attesting entity (subject owner).

C++ includes: SAMLToken.h ";

%feature("docstring")  Arc::SAMLToken::SAMLToken "Arc::SAMLToken::SAMLToken(SOAPEnvelope &soap)

Constructor. Parse SAML Token information from SOAP header. SAML Token
related information is extracted from SOAP header and stored in class
variables. And then it the SAMLToken object will be used for
authentication.

Parameters:
-----------

soap:  The SOAP message which contains the SAMLToken in the soap
header ";

%feature("docstring")  Arc::SAMLToken::SAMLToken "Arc::SAMLToken::SAMLToken(SOAPEnvelope &soap, const std::string
&certfile, const std::string &keyfile, SAMLVersion saml_version=SAML2,
XMLNode saml_assertion=XMLNode())

Constructor. Add SAML Token information into the SOAP header.
Generated token contains elements SAML token and signature, and is
meant to be used for authentication on the consuming side. This
constructor is for a specific SAML Token profile usage, in which the
attesting entity signs the SAML assertion for itself (self-sign). This
usage implicitly requires that the relying party trust the attesting
entity. More general (requires issuing authority) usage will be
provided by other constructor. And the under-developing SAML service
will be used as the issuing authority.

Parameters:
-----------

soap:  The SOAP message to which the SAML Token will be inserted.

certfile:  The certificate file.

keyfile:  The key file which will be used to create signature.

samlversion:  The SAML version, only SAML2 is supported currently.

samlassertion:  The SAML assertion got from 3rd party, and used for
protecting the SOAP message; If not present, then self-signed
assertion will be generated. ";

%feature("docstring")  Arc::SAMLToken::~SAMLToken "Arc::SAMLToken::~SAMLToken(void)

Deconstructor. Nothing to be done except finalizing the xmlsec
library. ";

%feature("docstring")  Arc::SAMLToken::Authenticate "bool
Arc::SAMLToken::Authenticate(const std::string &cafile, const
std::string &capath)

Check signature by using the trusted certificates It is used by
relying parting after calling SAMLToken(SOAPEnvelope& soap) This
method will check the SAML assertion based on the trusted certificated
specified as parameter cafile or capath; and also check the signature
to soap message (the signature is generated by attesting entity by
signing soap body together witl SAML assertion) by using the public
key inside SAML assetion.

Parameters:
-----------

cafile:  ca file

capath:  ca directory ";

%feature("docstring")  Arc::SAMLToken::Authenticate "bool
Arc::SAMLToken::Authenticate(void)

Check signature by using the cert information in soap message ";


// File: classArc_1_1ScalableTime.xml
%feature("docstring") Arc::ScalableTime "";

%feature("docstring")  Arc::ScalableTime::ScalableTime "Arc::ScalableTime< T >::ScalableTime() ";

%feature("docstring")  Arc::ScalableTime::ScalableTime "Arc::ScalableTime< T >::ScalableTime(const T &t) ";


// File: classArc_1_1ScalableTime_3_01int_01_4.xml
%feature("docstring") Arc::ScalableTime< int > " ";

%feature("docstring")  Arc::ScalableTime< int >::ScalableTime "
Arc::ScalableTime< int >::ScalableTime() ";

%feature("docstring")  Arc::ScalableTime< int >::ScalableTime "
Arc::ScalableTime< int >::ScalableTime(const int &t) ";

%feature("docstring")  Arc::ScalableTime< int >::scaleMin " int
Arc::ScalableTime< int >::scaleMin(double s) const ";

%feature("docstring")  Arc::ScalableTime< int >::scaleMax " int
Arc::ScalableTime< int >::scaleMax(double s) const ";


// File: classArc_1_1SecAttr.xml
%feature("docstring") Arc::SecAttr "

This is an abstract interface to a security attribute.

This class is meant to be inherited to implement security attributes.
Depending on what data it needs to store inheriting classes may need
to implement constructor and destructor. They must however override
the equality and the boolean operators. The equality is meant to
compare security attributes. The prototype implies that all attributes
are comparable to all others. This behaviour should be modified as
needed by using dynamic_cast operations. The boolean cast operation is
meant to embody \"nullness\" if that is applicable to the particular
type.

C++ includes: SecAttr.h ";

%feature("docstring")  Arc::SecAttr::SecAttr "Arc::SecAttr::SecAttr()

representation for GACL policy ";

%feature("docstring")  Arc::SecAttr::~SecAttr "virtual
Arc::SecAttr::~SecAttr() ";

%feature("docstring")  Arc::SecAttr::Export "virtual bool
Arc::SecAttr::Export(SecAttrFormat format, std::string &val) const

Convert internal structure into specified format. Returns false if
format is not supported/suitable for this attribute. ";

%feature("docstring")  Arc::SecAttr::Export "virtual bool
Arc::SecAttr::Export(SecAttrFormat format, XMLNode &val) const

Convert internal structure into specified format. Returns false if
format is not supported/suitable for this attribute. XML node
referenced by  is turned into top level element of specified format.
";

%feature("docstring")  Arc::SecAttr::Import "virtual bool
Arc::SecAttr::Import(SecAttrFormat format, const std::string &val)

Fills internal structure from external object of specified format.
Returns false if failed to do. The usage pattern for this method is
not defined and it is provided only to make class symmetric. Hence
it's implementation is not required yet. ";

%feature("docstring")  Arc::SecAttr::Import "virtual bool
Arc::SecAttr::Import(SecAttrFormat format, XMLNode val) ";


// File: classArc_1_1SecAttrFormat.xml
%feature("docstring") Arc::SecAttrFormat "

Export/import format.

Format is identified by textual identity string. Class description
includes basic formats only. That list may be extended.

C++ includes: SecAttr.h ";

%feature("docstring")  Arc::SecAttrFormat::SecAttrFormat "Arc::SecAttrFormat::SecAttrFormat(const SecAttrFormat &format) ";

%feature("docstring")  Arc::SecAttrFormat::SecAttrFormat "Arc::SecAttrFormat::SecAttrFormat(const char *format=\"\") ";


// File: classArc_1_1SecAttrValue.xml
%feature("docstring") Arc::SecAttrValue "

This is an abstract interface to a security attribute.

This class is meant to be inherited to implement security attributes.
Depending on what data it needs to store inheriting classes may need
to implement constructor and destructor. They must however override
the equality and the boolean operators. The equality is meant to
compare security attributes. The prototype implies that all attributes
are comparable to all others. This behaviour should be modified as
needed by using dynamic_cast operations. The boolean cast operation is
meant to embody \"nullness\" if that is applicable to the particular
type.

C++ includes: SecAttrValue.h ";

%feature("docstring")  Arc::SecAttrValue::SecAttrValue "Arc::SecAttrValue::SecAttrValue() ";

%feature("docstring")  Arc::SecAttrValue::~SecAttrValue "virtual
Arc::SecAttrValue::~SecAttrValue() ";


// File: classArcSec_1_1SecHandler.xml
%feature("docstring") ArcSec::SecHandler "

Base class for simple security handling plugins.

This virtual class defines method Handle() which processes security
related information/attributes in Message and optionally makes
security decision. Instances of such classes are normally arranged in
chains abd are called on incoming and outgoing messages in various MCC
and Service plugins. Return value of Handle() defines either
processing should continie (true) or stop with error (false).
Configuration of SecHandler is consumed during creation of instance
through XML subtree fed to constructor.

C++ includes: SecHandler.h ";

%feature("docstring")  ArcSec::SecHandler::SecHandler "ArcSec::SecHandler::SecHandler(Arc::Config *) ";

%feature("docstring")  ArcSec::SecHandler::~SecHandler "virtual
ArcSec::SecHandler::~SecHandler() ";

%feature("docstring")  ArcSec::SecHandler::Handle "virtual bool
ArcSec::SecHandler::Handle(Arc::Message *msg) const =0 ";


// File: classArcSec_1_1SecHandlerConfig.xml
%feature("docstring") ArcSec::SecHandlerConfig "

Helper class to create Security Handler configuration

C++ includes: SecHandler.h ";

%feature("docstring")  ArcSec::SecHandlerConfig::SecHandlerConfig "ArcSec::SecHandlerConfig::SecHandlerConfig(const std::string &name,
const std::string &event=\"\", const std::string &id=\"\") ";


// File: classArc_1_1SecHandlerConfig.xml
%feature("docstring") Arc::SecHandlerConfig "";

%feature("docstring")  Arc::SecHandlerConfig::SecHandlerConfig "Arc::SecHandlerConfig::SecHandlerConfig(const std::string &name, const
std::string &event=\"incoming\") ";


// File: classArcSec_1_1SecHandlerPluginArgument.xml
%feature("docstring") ArcSec::SecHandlerPluginArgument "";

%feature("docstring")
ArcSec::SecHandlerPluginArgument::SecHandlerPluginArgument "ArcSec::SecHandlerPluginArgument::SecHandlerPluginArgument(Arc::Config
*config, Arc::ChainContext *context) ";

%feature("docstring")
ArcSec::SecHandlerPluginArgument::~SecHandlerPluginArgument "virtual
ArcSec::SecHandlerPluginArgument::~SecHandlerPluginArgument(void) ";


// File: classArcSec_1_1Security.xml
%feature("docstring") ArcSec::Security "

Common stuff used by security related slasses.

This class is just a place where to put common stuff that is used by
security related slasses. So far it only contains a logger.

C++ includes: Security.h ";


// File: classArc_1_1Service.xml
%feature("docstring") Arc::Service "

Service - last component in a Message Chain.

This class which defines interface and common functionality for every
Service plugin. Interface is made of method process() which is called
by Plexer or MCC class. There is one Service object created for every
service description processed by Loader class objects. Classes derived
from Service class must implement process() method of MCCInterface. It
is up to developer how internal state of service is stored and
communicated to other services and external utilites. Service is free
to expect any type of payload passed to it and generate any payload as
well. Useful types depend on MCCs in chain which leads to that
service. For example if service is expected to by linked to SOAP MCC
it must accept and generate messages with PayloadSOAP payload. Method
process() of class derived from Service class may be called
concurently in multiple threads. Developers must take that into
account and write thread-safe implementation. Simple example of
service is provided in /src/tests/echo/echo.cpp of source tree. The
way to write client couterpart of corresponding service is undefined
yet. For example see /src/tests/echo/test.cpp .

C++ includes: Service.h ";

%feature("docstring")  Arc::Service::Service "Arc::Service::Service(Config *)

Example contructor - Server takes at least it's configuration subtree
";

%feature("docstring")  Arc::Service::~Service "virtual
Arc::Service::~Service(void) ";

%feature("docstring")  Arc::Service::AddSecHandler "virtual void
Arc::Service::AddSecHandler(Config *cfg, ArcSec::SecHandler
*sechandler, const std::string &label=\"\")

Add security components/handlers to this MCC. For more information
please see description of MCC::AddSecHandler ";

%feature("docstring")  Arc::Service::RegistrationCollector "virtual
bool Arc::Service::RegistrationCollector(XMLNode &doc)

Service specific registartion collector, used for generate service
registartions. In implemented service this method should generate
GLUE2 document with part of service description which service wishes
to advertise to Information Services. ";

%feature("docstring")  Arc::Service::getID "virtual std::string
Arc::Service::getID()

Service may implement own service identitifer gathering method. This
method return identifier of service which is used for registering it
Information Services. ";


// File: classArc_1_1ServicePluginArgument.xml
%feature("docstring") Arc::ServicePluginArgument "";

%feature("docstring")
Arc::ServicePluginArgument::ServicePluginArgument "Arc::ServicePluginArgument::ServicePluginArgument(Config *config,
ChainContext *context) ";

%feature("docstring")
Arc::ServicePluginArgument::~ServicePluginArgument "virtual
Arc::ServicePluginArgument::~ServicePluginArgument(void) ";


// File: classArc_1_1SharedMutex.xml
%feature("docstring") Arc::SharedMutex "";

%feature("docstring")  Arc::SharedMutex::SharedMutex "Arc::SharedMutex::SharedMutex(void) ";

%feature("docstring")  Arc::SharedMutex::~SharedMutex "Arc::SharedMutex::~SharedMutex(void) ";

%feature("docstring")  Arc::SharedMutex::lockShared "void
Arc::SharedMutex::lockShared(void) ";

%feature("docstring")  Arc::SharedMutex::unlockShared "void
Arc::SharedMutex::unlockShared(void) ";

%feature("docstring")  Arc::SharedMutex::isLockShared "bool
Arc::SharedMutex::isLockShared(void) ";

%feature("docstring")  Arc::SharedMutex::lockExclusive "void
Arc::SharedMutex::lockExclusive(void) ";

%feature("docstring")  Arc::SharedMutex::unlockExclusive "void
Arc::SharedMutex::unlockExclusive(void) ";

%feature("docstring")  Arc::SharedMutex::isLockExclusive "bool
Arc::SharedMutex::isLockExclusive(void) ";

%feature("docstring")  Arc::SharedMutex::forceReset "void
Arc::SharedMutex::forceReset(void) ";


// File: classArc_1_1SimpleCondition.xml
%feature("docstring") Arc::SimpleCondition "

Simple triggered condition.

Provides condition and semaphor objects in one element.

C++ includes: Thread.h ";

%feature("docstring")  Arc::SimpleCondition::SimpleCondition "Arc::SimpleCondition::SimpleCondition(void) ";

%feature("docstring")  Arc::SimpleCondition::~SimpleCondition "Arc::SimpleCondition::~SimpleCondition(void) ";

%feature("docstring")  Arc::SimpleCondition::lock "void
Arc::SimpleCondition::lock(void)

Acquire semaphor ";

%feature("docstring")  Arc::SimpleCondition::unlock "void
Arc::SimpleCondition::unlock(void)

Release semaphor ";

%feature("docstring")  Arc::SimpleCondition::signal "void
Arc::SimpleCondition::signal(void)

Signal about condition ";

%feature("docstring")  Arc::SimpleCondition::signal_nonblock "void
Arc::SimpleCondition::signal_nonblock(void)

Signal about condition without using semaphor ";

%feature("docstring")  Arc::SimpleCondition::broadcast "void
Arc::SimpleCondition::broadcast(void)

Signal about condition to all waiting threads ";

%feature("docstring")  Arc::SimpleCondition::wait "void
Arc::SimpleCondition::wait(void)

Wait for condition ";

%feature("docstring")  Arc::SimpleCondition::wait_nonblock "void
Arc::SimpleCondition::wait_nonblock(void)

Wait for condition without using semaphor ";

%feature("docstring")  Arc::SimpleCondition::wait "bool
Arc::SimpleCondition::wait(int t)

Wait for condition no longer than t milliseconds ";

%feature("docstring")  Arc::SimpleCondition::reset "void
Arc::SimpleCondition::reset(void)

Reset object to initial state ";

%feature("docstring")  Arc::SimpleCondition::forceReset "void
Arc::SimpleCondition::forceReset(void) ";


// File: classArc_1_1SimpleCounter.xml
%feature("docstring") Arc::SimpleCounter "";

%feature("docstring")  Arc::SimpleCounter::SimpleCounter "Arc::SimpleCounter::SimpleCounter(void) ";

%feature("docstring")  Arc::SimpleCounter::~SimpleCounter "Arc::SimpleCounter::~SimpleCounter(void) ";

%feature("docstring")  Arc::SimpleCounter::inc "int
Arc::SimpleCounter::inc(void) ";

%feature("docstring")  Arc::SimpleCounter::dec "int
Arc::SimpleCounter::dec(void) ";

%feature("docstring")  Arc::SimpleCounter::get "int
Arc::SimpleCounter::get(void) ";

%feature("docstring")  Arc::SimpleCounter::wait "void
Arc::SimpleCounter::wait(void) ";

%feature("docstring")  Arc::SimpleCounter::wait "bool
Arc::SimpleCounter::wait(int t)

Wait for condition no longer than t milliseconds ";

%feature("docstring")  Arc::SimpleCounter::forceReset "void
Arc::SimpleCounter::forceReset(void) ";


// File: classArc_1_1SOAPMessage.xml
%feature("docstring") Arc::SOAPMessage "

Message restricted to SOAP payload.

This is a special Message intended to be used in language bindings for
programming languages which are not flexible enough to support all
kinds of Payloads. It is passed through chain of MCCs and works like
the Message but can carry only SOAP content.

C++ includes: SOAPMessage.h ";

%feature("docstring")  Arc::SOAPMessage::SOAPMessage "Arc::SOAPMessage::SOAPMessage(void)

Dummy constructor ";

%feature("docstring")  Arc::SOAPMessage::SOAPMessage "Arc::SOAPMessage::SOAPMessage(long msg_ptr_addr)

Copy constructor. Used by language bindigs ";

%feature("docstring")  Arc::SOAPMessage::SOAPMessage "Arc::SOAPMessage::SOAPMessage(Message &msg)

Copy constructor. Ensures shallow copy. ";

%feature("docstring")  Arc::SOAPMessage::~SOAPMessage "Arc::SOAPMessage::~SOAPMessage(void)

Destructor does not affect refered objects ";

%feature("docstring")  Arc::SOAPMessage::Payload "SOAPEnvelope*
Arc::SOAPMessage::Payload(void)

Returns pointer to current payload or NULL if no payload assigned. ";

%feature("docstring")  Arc::SOAPMessage::Payload "void
Arc::SOAPMessage::Payload(SOAPEnvelope *new_payload)

Replace payload with a COPY of new one ";

%feature("docstring")  Arc::SOAPMessage::Attributes "MessageAttributes* Arc::SOAPMessage::Attributes(void)

Returns a pointer to the current attributes object or NULL if no
attributes object has been assigned. ";

%feature("docstring")  Arc::SOAPMessage::Attributes "void
Arc::SOAPMessage::Attributes(MessageAttributes *attributes) ";

%feature("docstring")  Arc::SOAPMessage::Auth "MessageAuth*
Arc::SOAPMessage::Auth(void) ";

%feature("docstring")  Arc::SOAPMessage::Auth "void
Arc::SOAPMessage::Auth(MessageAuth *auth) ";

%feature("docstring")  Arc::SOAPMessage::Context "MessageContext*
Arc::SOAPMessage::Context(void) ";

%feature("docstring")  Arc::SOAPMessage::Context "void
Arc::SOAPMessage::Context(MessageContext *context) ";


// File: classArc_1_1Software.xml
%feature("docstring") Arc::Software "

Used to represent software (names and version) and comparison.

The Software class is used to represent the name of a piece of
software internally. Generally software are identified by a name and
possibly a version number. Some software can also be categorized by
type or family (compilers, operating system, etc.). A software object
can be compared to other software objects using the comparison
operators contained in this class. The basic usage of this class is to
test if some specified software requirement ( SoftwareRequirement) are
fulfilled, by using the comparability of the class.

Internally the Software object is represented by a family and name
identifier, and the software version is tokenized at the characters
defined in VERSIONTOKENS, and stored as a list of tokens.

C++ includes: Software.h ";

%feature("docstring")  Arc::Software::Software "Arc::Software::Software()

Dummy constructor.

This constructor creates a empty object. ";

%feature("docstring")  Arc::Software::Software "Arc::Software::Software(const std::string &name_version)

Create a Software object.

Create a Software object from a single string composed of a name and a
version part. The created object will contain a empty family part. The
name and version part of the string will be split at the first
occurence of a dash (-) which is followed by a digit (0-9). If the
string does not contain such a pattern, the passed string will be
taken to be the name and version will be empty.

Parameters:
-----------

name_version:  should be a string composed of the name and version of
the software to represent. ";

%feature("docstring")  Arc::Software::Software "Arc::Software::Software(const std::string &name, const std::string
&version)

Create a Software object.

Create a Software object with the specified name and version. The
family part will be left empty.

Parameters:
-----------

name:  the software name to represent.

version:  the software version to represent. ";

%feature("docstring")  Arc::Software::Software "Arc::Software::Software(const std::string &family, const std::string
&name, const std::string &version)

Create a Software object.

Create a Software object with the specified family, name and version.

Parameters:
-----------

family:  the software family to represent.

name:  the software name to represent.

version:  the software version to represent. ";

%feature("docstring")  Arc::Software::empty "bool
Arc::Software::empty() const

Indicates whether the object is empty.

true if the name of this object is empty, otherwise false. ";

%feature("docstring")  Arc::Software::getFamily "const std::string&
Arc::Software::getFamily() const

Get family.

The family the represented software belongs to is returned. ";

%feature("docstring")  Arc::Software::getName "const std::string&
Arc::Software::getName() const

Get name.

The name of the represented software is returned. ";

%feature("docstring")  Arc::Software::getVersion "const std::string&
Arc::Software::getVersion() const

Get version.

The version of the represented software is returned. ";


// File: classArc_1_1SoftwareRequirement.xml
%feature("docstring") Arc::SoftwareRequirement "

Class used to express and resolve version requirements on software.

A requirement in this class is defined as a pair composed of a
Software object and either a Software::ComparisonOperator method
pointer or equally a Software::ComparisonOperatorEnum enum value. A
SoftwareRequirement object can contain multiple of such requirements,
and then it can specified if all these requirements should be
satisfied, or if it is enough to satisfy only one of them. The
requirements can be satisfied by a single Software object or a list of
either Software or ApplicationEnvironment objects, by using the method
isSatisfied(). This class also contain a number of methods (
selectSoftware()) to select Software objects which are satisfying the
requirements, and in this way resolving requirements.

C++ includes: Software.h ";

%feature("docstring")  Arc::SoftwareRequirement::SoftwareRequirement "Arc::SoftwareRequirement::SoftwareRequirement(bool requiresAll=false)

Create a empty SoftwareRequirement object.

The created SoftwareRequirement object will contain no requirements.

Parameters:
-----------

requiresAll:  indicates whether the all requirements have to be
satisfied ( true) or if only a single one ( false), the default is
that only a single requirement need to be satisfied. ";

%feature("docstring")  Arc::SoftwareRequirement::SoftwareRequirement "Arc::SoftwareRequirement::SoftwareRequirement(const Software &sw,
Software::ComparisonOperator swComOp=&Software::operator==, bool
requiresAll=false)

Create a SoftwareRequirement object.

The created SoftwareRequirement object will contain one requirement
specified by the Software object sw, and the
Software::ComparisonOperator swComOp.

This constructor is not available in language bindings created by
Swig, since method pointers are not supported by Swig, see
SoftwareRequirement(const Software&, Software::ComparisonOperatorEnum,
bool) instead.

Parameters:
-----------

sw:  is the Software object of the requirement to add.

swComOp:  is the Software::ComparisonOperator of the requirement to
add.

requiresAll:  indicates whether the all requirements have to be
satisfied ( true) or if only a single one ( false), the default is
that only a single requirement need to be satisfied. ";

%feature("docstring")  Arc::SoftwareRequirement::SoftwareRequirement "Arc::SoftwareRequirement::SoftwareRequirement(const Software &sw,
Software::ComparisonOperatorEnum co, bool requiresAll=false)

Create a SoftwareRequirement object.

The created SoftwareRequirement object will contain one requirement
specified by the Software object sw, and the
Software::ComparisonOperatorEnum co.

Parameters:
-----------

sw:  is the Software object of the requirement to add.

co:  is the Software::ComparisonOperatorEnum of the requirement to
add.

requiresAll:  indicates whether the all requirements have to be
satisfied ( true) or if only a single one ( false), the default is
that only a single requirement need to be satisfied. ";

%feature("docstring")  Arc::SoftwareRequirement::SoftwareRequirement "Arc::SoftwareRequirement::SoftwareRequirement(const
SoftwareRequirement &sr)

Copy constructor.

Create a SoftwareRequirement object from another SoftwareRequirement
object.

Parameters:
-----------

sr:  is the SoftwareRequirement object to make a copy of. ";

%feature("docstring")  Arc::SoftwareRequirement::add "void
Arc::SoftwareRequirement::add(const Software &sw,
Software::ComparisonOperator swComOp=&Software::operator==)

Add a Software object a corresponding comparion operator to this
object.

Adds software name and version to list of requirements and associates
the comparison operator with it (equality by default).

This method is not available in language bindings created by Swig,
since method pointers are not supported by Swig, see add(const
Software&, Software::ComparisonOperatorEnum) instead.

Parameters:
-----------

sw:  is the Software object to add as part of a requirement.

swComOp:  is the Software::ComparisonOperator method pointer to add as
part of a requirement, the default operator will be
Software::operator==(). ";

%feature("docstring")  Arc::SoftwareRequirement::add "void
Arc::SoftwareRequirement::add(const Software &sw,
Software::ComparisonOperatorEnum co)

Add a Software object a corresponding comparion operator to this
object.

Adds software name and version to list of requirements and associates
the comparison operator with it (equality by default).

Parameters:
-----------

sw:  is the Software object to add as part of a requirement.

co:  is the Software::ComparisonOperatorEnum value to add as part of a
requirement, the default enum will be Software::EQUAL. ";

%feature("docstring")  Arc::SoftwareRequirement::isRequiringAll "bool
Arc::SoftwareRequirement::isRequiringAll() const

Indicates whether all requirments has to be satisfied.

This method returns true if all requirements has to be satisfied. If
only one requirement has to be satisfied, false is returned.

true if all requirements has to be satisfied, otherwise false.

See:   setRequirement. ";

%feature("docstring")  Arc::SoftwareRequirement::setRequirement "void
Arc::SoftwareRequirement::setRequirement(bool all)

Set relation between requirements.

Specifies if all requirements stored need to be satisfied or if it is
enough to satisfy only one of them.

Parameters:
-----------

all:  is a boolean specifying if all requirements has to be satified.

See:   isRequiringAll(). ";

%feature("docstring")  Arc::SoftwareRequirement::isSatisfied "bool
Arc::SoftwareRequirement::isSatisfied(const Software &sw) const

Test if requirements are satisfied.

Returns true if the requirements are satisfied by the specified
Software sw, otherwise false is returned.

Parameters:
-----------

sw:  is the Software which should satisfy the requirements.

true if requirements are satisfied, otherwise false.

See:   isSatisfied(const std::list<Software>&) const,

isSatisfied(const std::list<ApplicationEnvironment>&) const,

selectSoftware(const Software&),

isResolved() const. ";

%feature("docstring")  Arc::SoftwareRequirement::isSatisfied "bool
Arc::SoftwareRequirement::isSatisfied(const std::list< Software >
&swList) const

Test if requirements are satisfied.

Returns true if stored requirements are satisfied by software
specified in swList, otherwise false is returned.

Note that if all requirements must be satisfied and multiple
requirements exist having identical name and family all these
requirements should be satisfied by a single Software object.

Parameters:
-----------

swList:  is the list of Software objects which should be used to try
satisfy the requirements.

true if requirements are satisfied, otherwise false.

See:   isSatisfied(const Software&) const,

isSatisfied(const std::list<ApplicationEnvironment>&) const,

selectSoftware(const std::list<Software>&),

isResolved() const. ";

%feature("docstring")  Arc::SoftwareRequirement::isSatisfied "bool
Arc::SoftwareRequirement::isSatisfied(const std::list<
ApplicationEnvironment > &swList) const

Test if requirements are satisfied.

This method behaves in exactly the same way as the isSatisfied(const
Software&) constmethod does.

Parameters:
-----------

swList:  is the list of ApplicationEnvironment objects which should be
used to try satisfy the requirements.

true if requirements are satisfied, otherwise false.

See:   isSatisfied(const Software&) const,

isSatisfied(const std::list<Software>&) const,

selectSoftware(const std::list<ApplicationEnvironment>&),

isResolved() const. ";

%feature("docstring")  Arc::SoftwareRequirement::selectSoftware "bool
Arc::SoftwareRequirement::selectSoftware(const Software &sw)

Select software.

If the passed Software sw do not satisfy the requirements false is
returned and this object is not modified. If however the Software
object sw do satisfy the requirements true is returned and the
requirements are set to equal the sw Software object.

Parameters:
-----------

sw:  is the Software object used to satisfy requirements.

true if requirements are satisfied, otherwise false.

See:   selectSoftware(const std::list<Software>&),

selectSoftware(const std::list<ApplicationEnvironment>&),

isSatisfied(const Software&) const,

isResolved() const. ";

%feature("docstring")  Arc::SoftwareRequirement::selectSoftware "bool
Arc::SoftwareRequirement::selectSoftware(const std::list< Software >
&swList)

Select software.

If the passed list of Software objects swList do not satisfy the
requirements false is returned and this object is not modified. If
however the list of Software objects swList do satisfy the
requirements true is returned and the Software objects satisfying the
requirements will replace these with the equality operator (
Software::operator==) used as the comparator for the new requirements.

Note that if all requirements must be satisfied and multiple
requirements exist having identical name and family all these
requirements should be satisfied by a single Software object and it
will replace all these requirements.

Parameters:
-----------

swList:  is a list of Software objects used to satisfy requirements.

true if requirements are satisfied, otherwise false.

See:   selectSoftware(const Software&),

selectSoftware(const std::list<ApplicationEnvironment>&),

isSatisfied(const std::list<Software>&) const,

isResolved() const. ";

%feature("docstring")  Arc::SoftwareRequirement::selectSoftware "bool
Arc::SoftwareRequirement::selectSoftware(const std::list<
ApplicationEnvironment > &swList)

Select software.

This method behaves exactly as the selectSoftware(const
std::list<Software>&) method does.

Parameters:
-----------

swList:  is a list of ApplicationEnvironment objects used to satisfy
requirements.

true if requirements are satisfied, otherwise false.

See:   selectSoftware(const Software&),

selectSoftware(const std::list<Software>&),

isSatisfied(const std::list<ApplicationEnvironment>&) const,

isResolved() const. ";

%feature("docstring")  Arc::SoftwareRequirement::isResolved "bool
Arc::SoftwareRequirement::isResolved() const

Indicates whether requirements have been resolved or not.

If specified that only one requirement has to be satisfied, then for
this object to be resolved it can only contain one requirement and it
has use the equal operator ( Software::operator==).

If specified that all requirements has to be satisfied, then for this
object to be resolved each requirement must have a Software object
with a unique family/name composition, i.e. no other requirements have
a Software object with the same family/name composition, and each
requirement must use the equal operator ( Software::operator==).

If this object has been resolved then true is returned when invoking
this method, otherwise false is returned.

true if this object have been resolved, otherwise false. ";

%feature("docstring")  Arc::SoftwareRequirement::empty "bool
Arc::SoftwareRequirement::empty() const

Test if the object is empty.

true if this object do no contain any requirements, otherwise false.
";

%feature("docstring")  Arc::SoftwareRequirement::clear "void
Arc::SoftwareRequirement::clear()

Clear the object.

The requirements in this object will be cleared when invoking this
method. ";

%feature("docstring")  Arc::SoftwareRequirement::getSoftwareList "const std::list<Software>& Arc::SoftwareRequirement::getSoftwareList()
const

Get list of Software objects.

The list of internally stored Software objects is returned.

See:   Software,

getComparisonOperatorList. ";

%feature("docstring")
Arc::SoftwareRequirement::getComparisonOperatorList "const
std::list<Software::ComparisonOperator>&
Arc::SoftwareRequirement::getComparisonOperatorList() const

Get list of comparison operators.

The list of internally stored comparison operators is returned.

See:   Software::ComparisonOperator,

getSoftwareList. ";


// File: classArcSec_1_1Source.xml
%feature("docstring") ArcSec::Source "

Acquires and parses XML document from specified source.

This class is to be used to provide easy way to specify different
sources for XML Authorization Policies and Requests.

C++ includes: Source.h ";

%feature("docstring")  ArcSec::Source::Source "ArcSec::Source::Source(const Source &s)

Copy constructor.

Use this constructor only for temporary objects. Parsed XML document
is still owned by copied source and hence lifetime of create object
should not exceed that of copied one. ";

%feature("docstring")  ArcSec::Source::Source "ArcSec::Source::Source(Arc::XMLNode &xml)

Copy XML tree from XML subtree refered by xml. ";

%feature("docstring")  ArcSec::Source::Source "ArcSec::Source::Source(std::istream &stream)

Read XML document from stream and parse it. ";

%feature("docstring")  ArcSec::Source::Source "ArcSec::Source::Source(Arc::URL &url)

Fetch XML document from specified url and parse it.

This constructor is not implemented yet. ";

%feature("docstring")  ArcSec::Source::Source "ArcSec::Source::Source(const std::string &str)

Read XML document from string. ";

%feature("docstring")  ArcSec::Source::Get "Arc::XMLNode
ArcSec::Source::Get(void) const

Get reference to parsed document. ";


// File: classArcSec_1_1SourceFile.xml
%feature("docstring") ArcSec::SourceFile "

Convenience class for obtaining XML document from file.

C++ includes: Source.h ";

%feature("docstring")  ArcSec::SourceFile::SourceFile "ArcSec::SourceFile::SourceFile(const SourceFile &s)

See corresponding constructor of Source class. ";

%feature("docstring")  ArcSec::SourceFile::SourceFile "ArcSec::SourceFile::SourceFile(const char *name)

Read XML document from file named name and store it. ";

%feature("docstring")  ArcSec::SourceFile::SourceFile "ArcSec::SourceFile::SourceFile(const std::string &name)

Read XML document from file named name and store it. ";

%feature("docstring")  ArcSec::SourceFile::~SourceFile "ArcSec::SourceFile::~SourceFile(void) ";


// File: classArcSec_1_1SourceURL.xml
%feature("docstring") ArcSec::SourceURL "

Convenience class for obtaining XML document from remote URL.

C++ includes: Source.h ";

%feature("docstring")  ArcSec::SourceURL::SourceURL "ArcSec::SourceURL::SourceURL(const SourceURL &s)

See corresponding constructor of Source class. ";

%feature("docstring")  ArcSec::SourceURL::SourceURL "ArcSec::SourceURL::SourceURL(const char *url)

Read XML document from URL url and store it. ";

%feature("docstring")  ArcSec::SourceURL::SourceURL "ArcSec::SourceURL::SourceURL(const std::string &url)

Read XML document from URL url and store it. ";

%feature("docstring")  ArcSec::SourceURL::~SourceURL "ArcSec::SourceURL::~SourceURL(void) ";


// File: classArcSec_1_1StringAttribute.xml
%feature("docstring") ArcSec::StringAttribute "";

%feature("docstring")  ArcSec::StringAttribute::StringAttribute "ArcSec::StringAttribute::StringAttribute() ";

%feature("docstring")  ArcSec::StringAttribute::StringAttribute "ArcSec::StringAttribute::StringAttribute(const std::string &v, const
std::string &i) ";

%feature("docstring")  ArcSec::StringAttribute::~StringAttribute "virtual ArcSec::StringAttribute::~StringAttribute() ";

%feature("docstring")  ArcSec::StringAttribute::equal "virtual bool
ArcSec::StringAttribute::equal(AttributeValue *other, bool
check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::StringAttribute::inrange "virtual bool
ArcSec::StringAttribute::inrange(AttributeValue *other) ";

%feature("docstring")  ArcSec::StringAttribute::encode "virtual
std::string ArcSec::StringAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::StringAttribute::getValue "std::string
ArcSec::StringAttribute::getValue() ";

%feature("docstring")  ArcSec::StringAttribute::getType "virtual
std::string ArcSec::StringAttribute::getType()

Get the DataType of the <Attribute> ";

%feature("docstring")  ArcSec::StringAttribute::getId "virtual
std::string ArcSec::StringAttribute::getId()

Get the AttributeId of the <Attribute> ";


// File: classArc_1_1Submitter.xml
%feature("docstring") Arc::Submitter "

Base class for the Submitters.

Submitter is the base class for Grid middleware specialized Submitter
objects. The class submits job(s) to the computing resource it
represents and uploads (needed by the job) local input files.

C++ includes: Submitter.h ";

%feature("docstring")  Arc::Submitter::~Submitter "virtual
Arc::Submitter::~Submitter() ";

%feature("docstring")  Arc::Submitter::GetTestJob "virtual bool
Arc::Submitter::GetTestJob(const int &testid, JobDescription
&jobdescription)

This virtual method can be ovverriden by plugins which should be
capable of getting test job descriptions for the specified flavour.
This method should return with the JobDescription or NULL if ther is
no test description defined with the requested id. ";

%feature("docstring")  Arc::Submitter::Submit "URL
Arc::Submitter::Submit(const JobDescription &jobdesc, const
ExecutionTarget &et)

This virtual method should be overridden by plugins which should be
capable of submitting jobs, defined in the JobDescription jobdesc, to
the ExecutionTarget et. The protected convenience method AddJob can be
used to save job information. This method should return the URL of the
submitted job. In case submission fails an empty URL should be
returned. ";

%feature("docstring")  Arc::Submitter::Submit "virtual bool
Arc::Submitter::Submit(const JobDescription &jobdesc, const
ExecutionTarget &et, Job &job)=0 ";

%feature("docstring")  Arc::Submitter::Submit "bool
Arc::Submitter::Submit(const JobDescription &jobdesc, Job &job) ";

%feature("docstring")  Arc::Submitter::Migrate "URL
Arc::Submitter::Migrate(const URL &jobid, const JobDescription
&jobdesc, const ExecutionTarget &et, bool forcemigration)

This virtual method should be overridden by plugins which should be
capable of migrating jobs. The active job which should be migrated is
pointed to by the URL jobid, and is represented by the JobDescription
jobdesc. The forcemigration boolean specifies if the migration should
succeed if the active job cannot be terminated. The protected method
AddJob can be used to save job information. This method should return
the URL of the migrated job. In case migration fails an empty URL
should be returned. ";

%feature("docstring")  Arc::Submitter::Migrate "virtual bool
Arc::Submitter::Migrate(const URL &jobid, const JobDescription
&jobdesc, const ExecutionTarget &et, bool forcemigration, Job &job)=0
";

%feature("docstring")  Arc::Submitter::Migrate "bool
Arc::Submitter::Migrate(const URL &jobid, const JobDescription
&jobdesc, bool forcemigration, Job &job) ";

%feature("docstring")  Arc::Submitter::ModifyJobDescription "virtual
bool Arc::Submitter::ModifyJobDescription(JobDescription &jobdesc,
const ExecutionTarget &et) const =0 ";

%feature("docstring")  Arc::Submitter::GetCksum "std::string
Arc::Submitter::GetCksum(const std::string &file) const ";

%feature("docstring")  Arc::Submitter::SetSubmissionTarget "void
Arc::Submitter::SetSubmissionTarget(const ExecutionTarget
&submissiontarget) ";


// File: classArc_1_1SubmitterLoader.xml
%feature("docstring") Arc::SubmitterLoader "

Class responsible for loading Submitter plugins The Submitter objects
returned by a SubmitterLoader must not be used after the
SubmitterLoader goes out of scope.

C++ includes: Submitter.h ";

%feature("docstring")  Arc::SubmitterLoader::SubmitterLoader "Arc::SubmitterLoader::SubmitterLoader()

Constructor Creates a new SubmitterLoader. ";

%feature("docstring")  Arc::SubmitterLoader::~SubmitterLoader "Arc::SubmitterLoader::~SubmitterLoader()

Destructor Calling the destructor destroys all Submitters loaded by
the SubmitterLoader instance. ";

%feature("docstring")  Arc::SubmitterLoader::load "Submitter*
Arc::SubmitterLoader::load(const std::string &name, const UserConfig
&usercfg)

Load a new Submitter

Parameters:
-----------

name:  The name of the Submitter to load.

usercfg:  The UserConfig object for the new Submitter.

A pointer to the new Submitter (NULL on error). ";

%feature("docstring")  Arc::SubmitterLoader::GetSubmitters "const
std::list<Submitter*>& Arc::SubmitterLoader::GetSubmitters() const

Retrieve the list of loaded Submitters. A reference to the list of
Submitters. ";


// File: classArc_1_1SubmitterPluginArgument.xml
%feature("docstring") Arc::SubmitterPluginArgument "";

%feature("docstring")
Arc::SubmitterPluginArgument::SubmitterPluginArgument "Arc::SubmitterPluginArgument::SubmitterPluginArgument(const UserConfig
&usercfg) ";

%feature("docstring")
Arc::SubmitterPluginArgument::~SubmitterPluginArgument "Arc::SubmitterPluginArgument::~SubmitterPluginArgument() ";


// File: classArc_1_1TargetGenerator.xml
%feature("docstring") Arc::TargetGenerator "

Target generation class

The TargetGenerator class is the umbrella class for resource discovery
and information retrieval (index servers and execution services). It
can also be used to discover user Grid jobs and detailed information.
The TargetGenerator loads TargetRetriever plugins (which implements
the actual information retrieval) from URL objects found in the
UserConfig object passed to its constructor using the custom
TargetRetrieverLoader.

C++ includes: TargetGenerator.h ";

%feature("docstring")  Arc::TargetGenerator::TargetGenerator "Arc::TargetGenerator::TargetGenerator(const UserConfig &usercfg,
unsigned int startRetrieval=0)

Create a TargetGenerator object.

Default constructor to create a TargeGenerator. The constructor reads
the computing and index service URL objects from the passed UserConfig
object using the UserConfig:GetSelectedServices method. From each URL
a matching specialized TargetRetriever plugin is loaded using the
TargetRetrieverLoader. If the second parameter, startRetrieval, is
specified, and matches bitwise either a value of 1, 2 or both,
retrieval of execution services, jobs or both will be initiated.

Parameters:
-----------

usercfg:  is a reference to a UserConfig object from which endpoints
to execution and/or index services will be used. The object also hold
information about user credentials.

startRetrival:  specifies whether retrival should be started directly.
It will be parsed bitwise. A value of 1 will start execution service
retrieval (RetrieveExecutionTargets), 2 jobs (RetrieveJobs), and 3
both, while 0 will not start retrieval at all. If not specified,
default is 0. ";

%feature("docstring")  Arc::TargetGenerator::~TargetGenerator "Arc::TargetGenerator::~TargetGenerator() ";

%feature("docstring")  Arc::TargetGenerator::GetTargets "void
Arc::TargetGenerator::GetTargets(int targetType, int detailLevel)

DEPRECATED: Find available targets.

This method is DEPRECATED, use the RetrieveExecutionTargets() or
RetrieveJobs() method instead. Method to prepare a list of chosen
Targets with a specified detail level. Current implementation supports
finding computing elements ( ExecutionTarget) with full detail level
and jobs with limited detail level.

Parameters:
-----------

targetType:  0 = ExecutionTarget, 1 = Grid jobs

detailLevel:

See:  RetrieveExecutionsTargets()

RetrieveJobs() ";

%feature("docstring")  Arc::TargetGenerator::RetrieveExecutionTargets
"void Arc::TargetGenerator::RetrieveExecutionTargets()

Retrieve available execution services.

The endpoints specified in the UserConfig object passed to this object
will be used to retrieve information about execution services (
ExecutionTarget objects). The discovery and information retrieval of
targets is carried out in parallel threads to speed up the process. If
a endpoint is a index service each execution service registered will
be queried.

See:   RetrieveJobs

GetExecutionTargets ";

%feature("docstring")  Arc::TargetGenerator::RetrieveJobs "void
Arc::TargetGenerator::RetrieveJobs()

Retrieve job information from execution services.

The endpoints specified in the UserConfig object passed to this object
will be used to retrieve job information from these endpoints. Only
jobs owned by the user which is identified by the credentials
specified in the passed UserConfig object will be considered
(exception being services which has no user authentification). If a
endpoint is a index service, each execution service registered will be
queried, and searched for job information.

See:   RetrieveExecutionTargets ";

%feature("docstring")  Arc::TargetGenerator::GetExecutionTargets "const std::list<ExecutionTarget>&
Arc::TargetGenerator::GetExecutionTargets() const

Return targets fetched by RetrieveExecutionTargets method.

Method to return a const list of ExecutionTarget objects retrieved by
the RetrieveExecutionTargets method.

See:   RetrieveExecutionTargets

GetExecutionTargets ";

%feature("docstring")  Arc::TargetGenerator::GetExecutionTargets "std::list<ExecutionTarget>&
Arc::TargetGenerator::GetExecutionTargets() ";

%feature("docstring")  Arc::TargetGenerator::ModifyFoundTargets "std::list<ExecutionTarget>& Arc::TargetGenerator::ModifyFoundTargets()

DEPRECATED: Return targets found by GetTargets.

This method is DEPRECATED, use the FoundTargets() instead. Method to
return the list of ExecutionTarget objects (currently only supported
Target type) found by the GetTarget method. ";

%feature("docstring")  Arc::TargetGenerator::FoundTargets "const
std::list<ExecutionTarget>& Arc::TargetGenerator::FoundTargets() const

DEPRECATED: Return targets found by GetTargets.

This method is DEPRECATED, use the FoundTargets() instead. Method to
return the list of ExecutionTarget objects (currently only supported
Target type) found by the GetTarget method. ";

%feature("docstring")  Arc::TargetGenerator::FoundJobs "const
std::list<XMLNode*>& Arc::TargetGenerator::FoundJobs() const

DEPRECATED: Return jobs found by GetTargets.

This method is DEPRECATED, use the GetFoundJobs method instead. Method
to return the list of jobs found by a call to the GetJobs method.

A list of jobs in XML format is returned. ";

%feature("docstring")  Arc::TargetGenerator::GetJobs "const
std::list<Job>& Arc::TargetGenerator::GetJobs() const

Return jobs retrieved by RetrieveJobs method.

Method to return the list of jobs found by a call to the GetJobs
method.

A list of the discovered jobs as Job objects is returned

See:   RetrieveJobs ";

%feature("docstring")  Arc::TargetGenerator::AddService "bool
Arc::TargetGenerator::AddService(const std::string Flavour, const URL
&url)

Add a new computing service to the foundServices list.

Method to add a new service to the list of foundServices in a thread
secure way. Compares the argument URL against the services returned by
UserConfig::GetRejectedServices and only allows to add the service if
not specifically rejected.

Parameters:
-----------

flavour:  The flavour if the the computing service.

url:   URL pointing to the information system of the computing
service. ";

%feature("docstring")  Arc::TargetGenerator::AddIndexServer "bool
Arc::TargetGenerator::AddIndexServer(const std::string Flavour, const
URL &url)

Add a new index server to the foundIndexServers list.

Method to add a new index server to the list of foundIndexServers in a
thread secure way. Compares the argument URL against the servers
returned by UserConfig::GetRejectedServices and only allows to add the
service if not specifically rejected.

Parameters:
-----------

flavour:  The flavour if the the index server.

url:   URL pointing to the index server. ";

%feature("docstring")  Arc::TargetGenerator::AddTarget "void
Arc::TargetGenerator::AddTarget(const ExecutionTarget &target)

Add a new ExecutionTarget to the foundTargets list.

Method to add a new ExecutionTarget (usually discovered by a
TargetRetriever) to the list of foundTargets in a thread secure way.

Parameters:
-----------

target:   ExecutionTarget to be added. ";

%feature("docstring")  Arc::TargetGenerator::AddJob "void
Arc::TargetGenerator::AddJob(const XMLNode &job)

DEPRECATED: Add a new Job to this object.

This method is DEPRECATED, use the AddJob(const Job&) method instead.
Method to add a new Job (usually discovered by a TargetRetriever) to
the internal list of jobs in a thread secure way.

Parameters:
-----------

job:   XMLNode describing the job. ";

%feature("docstring")  Arc::TargetGenerator::AddJob "void
Arc::TargetGenerator::AddJob(const Job &job)

Add a new Job to this object.

Method to add a new Job (usually discovered by a TargetRetriever) to
the internal list of jobs in a thread secure way.

Parameters:
-----------

job:   Job describing the job.

See:   AddJob(const Job&) ";

%feature("docstring")  Arc::TargetGenerator::PrintTargetInfo "void
Arc::TargetGenerator::PrintTargetInfo(bool longlist) const

DEPRECATED: Prints target information.

This method is DEPRECATED, use the SaveTargetInfoToStream method
instead. Method to print information of the found targets to
std::cout.

Parameters:
-----------

longlist:  false for minimal information, true for detailed
information

See:   SaveTargetInfoToStream ";

%feature("docstring")  Arc::TargetGenerator::SaveTargetInfoToStream "void Arc::TargetGenerator::SaveTargetInfoToStream(std::ostream &out,
bool longlist) const

Prints target information.

Method to print information of the found targets to std::cout.

Parameters:
-----------

out:  is a std::ostream object which to direct target informetion to.

longlist:  false for minimal information, true for detailed
information ";

%feature("docstring")  Arc::TargetGenerator::ServiceCounter "SimpleCounter& Arc::TargetGenerator::ServiceCounter(void)

Returns reference to worker counter.

This method returns reference to counter which keeps amount of started
worker threads communicating with services asynchronously. The counter
must be incremented for every thread started and decremented when
thread exits. Main thread will then wait till counters drops to zero.
";


// File: classArc_1_1TargetRetriever.xml
%feature("docstring") Arc::TargetRetriever "

TargetRetriever base class

The TargetRetriever class is a pure virtual base class to be used for
grid flavour specializations. It is designed to work in conjunction
with the TargetGenerator.

C++ includes: TargetRetriever.h ";

%feature("docstring")  Arc::TargetRetriever::~TargetRetriever "virtual Arc::TargetRetriever::~TargetRetriever() ";

%feature("docstring")  Arc::TargetRetriever::GetTargets "virtual void
Arc::TargetRetriever::GetTargets(TargetGenerator &mom, int targetType,
int detailLevel)=0

DEPRECATED: Method for collecting targets.

This method is DEPRECATED, the GetExecutionTargets and GetJobs methods
replaces it.

Pure virtual method for collecting targets. Implementation depends on
the Grid middleware in question and is thus left to the specialized
class.

Parameters:
-----------

mom:  is the reference to the TargetGenerator which has loaded the
TargetRetriever

targetType:  is the identificaion of targets to find (0 =
ExecutionTargets, 1 = Grid Jobs)

detailLevel:  is the required level of details (1 = All details, 2 =
Limited details) ";


// File: classArc_1_1TargetRetrieverLoader.xml
%feature("docstring") Arc::TargetRetrieverLoader "

Class responsible for loading TargetRetriever plugins The
TargetRetriever objects returned by a TargetRetrieverLoader must not
be used after the TargetRetrieverLoader goes out of scope.

C++ includes: TargetRetriever.h ";

%feature("docstring")
Arc::TargetRetrieverLoader::TargetRetrieverLoader "Arc::TargetRetrieverLoader::TargetRetrieverLoader()

Constructor Creates a new TargetRetrieverLoader. ";

%feature("docstring")
Arc::TargetRetrieverLoader::~TargetRetrieverLoader "Arc::TargetRetrieverLoader::~TargetRetrieverLoader()

Destructor Calling the destructor destroys all TargetRetrievers loaded
by the TargetRetrieverLoader instance. ";

%feature("docstring")  Arc::TargetRetrieverLoader::load "TargetRetriever* Arc::TargetRetrieverLoader::load(const std::string
&name, const UserConfig &usercfg, const std::string &service, const
ServiceType &st)

Load a new TargetRetriever

Parameters:
-----------

name:  The name of the TargetRetriever to load.

usercfg:  The UserConfig object for the new TargetRetriever.

service:  The URL used to contact the target.

st:  specifies service type of the target.

A pointer to the new TargetRetriever (NULL on error). ";

%feature("docstring")  Arc::TargetRetrieverLoader::GetTargetRetrievers
"const std::list<TargetRetriever*>&
Arc::TargetRetrieverLoader::GetTargetRetrievers() const

Retrieve the list of loaded TargetRetrievers. A reference to the list
of TargetRetrievers. ";


// File: classArc_1_1TargetRetrieverPluginArgument.xml
%feature("docstring") Arc::TargetRetrieverPluginArgument "";

%feature("docstring")
Arc::TargetRetrieverPluginArgument::TargetRetrieverPluginArgument "Arc::TargetRetrieverPluginArgument::TargetRetrieverPluginArgument(const
UserConfig &usercfg, const std::string &server, const ServiceType &st)
";

%feature("docstring")
Arc::TargetRetrieverPluginArgument::~TargetRetrieverPluginArgument "Arc::TargetRetrieverPluginArgument::~TargetRetrieverPluginArgument()
";


// File: classArc_1_1ThreadDataItem.xml
%feature("docstring") Arc::ThreadDataItem "

Base class for per-thread object.

Classes inherited from this one are attached to current thread under
specified key and destroyed only when thread ends or object is
replaced by another one with same key.

C++ includes: Thread.h ";

%feature("docstring")  Arc::ThreadDataItem::ThreadDataItem "Arc::ThreadDataItem::ThreadDataItem(void)

Dummy constructor which does nothing. To make object usable one of
Attach(...) methods must be used. ";

%feature("docstring")  Arc::ThreadDataItem::ThreadDataItem "Arc::ThreadDataItem::ThreadDataItem(std::string &key)

Creates instance and attaches it to current thread under key. If
supplied key is empty random one is generated and stored in key
variable. ";

%feature("docstring")  Arc::ThreadDataItem::ThreadDataItem "Arc::ThreadDataItem::ThreadDataItem(const std::string &key)

Creates instance and attaches it to current thread under key. ";

%feature("docstring")  Arc::ThreadDataItem::Attach "void
Arc::ThreadDataItem::Attach(std::string &key)

Attaches object to current thread under key. If supplied key is empty
random one is generated and stored in key variable. This method must
be used only if object was created using dummy constructor. ";

%feature("docstring")  Arc::ThreadDataItem::Attach "void
Arc::ThreadDataItem::Attach(const std::string &key)

Attaches object to current thread under key. This method must be used
only if object was created using dummy constructor. ";

%feature("docstring")  Arc::ThreadDataItem::Dup "virtual void
Arc::ThreadDataItem::Dup(void)

Creates copy of object. This method is called when new thread is
created from current thread. It is called in new thread, so new object
- if created - gets attached to new thread. If object is not meant to
be inherited by new threads then this method should do nothing. ";


// File: classArc_1_1ThreadInitializer.xml
%feature("docstring") Arc::ThreadInitializer "";

%feature("docstring")  Arc::ThreadInitializer::ThreadInitializer "Arc::ThreadInitializer::ThreadInitializer(void) ";

%feature("docstring")  Arc::ThreadInitializer::forceReset "void
Arc::ThreadInitializer::forceReset(void) ";


// File: classArc_1_1ThreadRegistry.xml
%feature("docstring") Arc::ThreadRegistry "

This class is a set of conditions, mutexes, etc. conveniently exposed
to monitor running child threads and to wait till they exit. There are
no protections against race conditions. So use it carefully.

C++ includes: Thread.h ";

%feature("docstring")  Arc::ThreadRegistry::ThreadRegistry "Arc::ThreadRegistry::ThreadRegistry(void) ";

%feature("docstring")  Arc::ThreadRegistry::~ThreadRegistry "Arc::ThreadRegistry::~ThreadRegistry(void) ";

%feature("docstring")  Arc::ThreadRegistry::RegisterThread "void
Arc::ThreadRegistry::RegisterThread(void)

Register thread as started/starting into this instance. ";

%feature("docstring")  Arc::ThreadRegistry::UnregisterThread "void
Arc::ThreadRegistry::UnregisterThread(void)

Report thread as exited. ";

%feature("docstring")  Arc::ThreadRegistry::WaitOrCancel "bool
Arc::ThreadRegistry::WaitOrCancel(int timeout)

Wait for timeout milliseconds or cancel request. Returns true if
cancel request received. ";

%feature("docstring")  Arc::ThreadRegistry::WaitForExit "bool
Arc::ThreadRegistry::WaitForExit(int timeout=-1)

Wait for registered threads to exit. Leave after timeout miliseconds
if failed. Returns true if all registered threads reported their exit.
";

%feature("docstring")  Arc::ThreadRegistry::RequestCancel "void
Arc::ThreadRegistry::RequestCancel(void) ";

%feature("docstring")  Arc::ThreadRegistry::forceReset "void
Arc::ThreadRegistry::forceReset(void) ";


// File: classArc_1_1Time.xml
%feature("docstring") Arc::Time "

A class for storing and manipulating times.

C++ includes: DateTime.h ";

%feature("docstring")  Arc::Time::Time "Arc::Time::Time()

Default constructor. The time is put equal the current time. ";

%feature("docstring")  Arc::Time::Time "Arc::Time::Time(time_t)

Constructor that takes a time_t variable and stores it. ";

%feature("docstring")  Arc::Time::Time "Arc::Time::Time(time_t time,
uint32_t nanosec)

Constructor that takes a fine grained time variables and stores them.
";

%feature("docstring")  Arc::Time::Time "Arc::Time::Time(const
std::string &)

Constructor that tries to convert a string into a time_t. ";

%feature("docstring")  Arc::Time::SetTime "void
Arc::Time::SetTime(time_t)

sets the time ";

%feature("docstring")  Arc::Time::SetTime "void
Arc::Time::SetTime(time_t time, uint32_t nanosec)

sets the fine grained time ";

%feature("docstring")  Arc::Time::GetTime "time_t
Arc::Time::GetTime() const

gets the time ";

%feature("docstring")  Arc::Time::GetTimeNanosec "time_t
Arc::Time::GetTimeNanosec() const ";

%feature("docstring")  Arc::Time::str "std::string
Arc::Time::str(const TimeFormat &=time_format) const

Returns a string representation of the time, using the specified
format. ";


// File: classArcSec_1_1TimeAttribute.xml
%feature("docstring") ArcSec::TimeAttribute "

Format: HHMMSSZ HH:MM:SS HH:MM:SS+HH:MM HH:MM:SSZ

C++ includes: DateTimeAttribute.h ";

%feature("docstring")  ArcSec::TimeAttribute::TimeAttribute "ArcSec::TimeAttribute::TimeAttribute() ";

%feature("docstring")  ArcSec::TimeAttribute::TimeAttribute "ArcSec::TimeAttribute::TimeAttribute(const std::string &v, const
std::string &i) ";

%feature("docstring")  ArcSec::TimeAttribute::~TimeAttribute "virtual
ArcSec::TimeAttribute::~TimeAttribute() ";

%feature("docstring")  ArcSec::TimeAttribute::equal "virtual bool
ArcSec::TimeAttribute::equal(AttributeValue *other, bool
check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::TimeAttribute::lessthan "virtual bool
ArcSec::TimeAttribute::lessthan(AttributeValue *other) ";

%feature("docstring")  ArcSec::TimeAttribute::encode "virtual
std::string ArcSec::TimeAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::TimeAttribute::getValue "Arc::Time
ArcSec::TimeAttribute::getValue() ";

%feature("docstring")  ArcSec::TimeAttribute::getType "virtual
std::string ArcSec::TimeAttribute::getType()

Get the DataType of the <Attribute> ";

%feature("docstring")  ArcSec::TimeAttribute::getId "virtual
std::string ArcSec::TimeAttribute::getId()

Get the AttributeId of the <Attribute> ";


// File: classArc_1_1TimedMutex.xml
%feature("docstring") Arc::TimedMutex "";

%feature("docstring")  Arc::TimedMutex::TimedMutex "Arc::TimedMutex::TimedMutex(void) ";

%feature("docstring")  Arc::TimedMutex::~TimedMutex "Arc::TimedMutex::~TimedMutex(void) ";

%feature("docstring")  Arc::TimedMutex::lock "bool
Arc::TimedMutex::lock(int t=-1) ";

%feature("docstring")  Arc::TimedMutex::trylock "bool
Arc::TimedMutex::trylock(void) ";

%feature("docstring")  Arc::TimedMutex::unlock "bool
Arc::TimedMutex::unlock(void) ";

%feature("docstring")  Arc::TimedMutex::forceReset "void
Arc::TimedMutex::forceReset(void) ";


// File: classArc_1_1URL.xml
%feature("docstring") Arc::URL "";

%feature("docstring")  Arc::URL::URL "Arc::URL::URL()

Empty constructor. Necessary when the class is part of another class
and the like. ";

%feature("docstring")  Arc::URL::URL "Arc::URL::URL(const std::string
&url)

Constructs a new URL from a string representation. ";

%feature("docstring")  Arc::URL::~URL "virtual Arc::URL::~URL()

URL Destructor ";

%feature("docstring")  Arc::URL::Protocol "const std::string&
Arc::URL::Protocol() const

Returns the protocol of the URL. ";

%feature("docstring")  Arc::URL::ChangeProtocol "void
Arc::URL::ChangeProtocol(const std::string &newprot)

Changes the protocol of the URL. ";

%feature("docstring")  Arc::URL::IsSecureProtocol "bool
Arc::URL::IsSecureProtocol() const

Indicates whether the protocol is secure or not. ";

%feature("docstring")  Arc::URL::Username "const std::string&
Arc::URL::Username() const

Returns the username of the URL. ";

%feature("docstring")  Arc::URL::Passwd "const std::string&
Arc::URL::Passwd() const

Returns the password of the URL. ";

%feature("docstring")  Arc::URL::Host "const std::string&
Arc::URL::Host() const

Returns the hostname of the URL. ";

%feature("docstring")  Arc::URL::ChangeHost "void
Arc::URL::ChangeHost(const std::string &newhost)

Changes the hostname of the URL. ";

%feature("docstring")  Arc::URL::Port "int Arc::URL::Port() const

Returns the port of the URL. ";

%feature("docstring")  Arc::URL::ChangePort "void
Arc::URL::ChangePort(int newport)

Changes the port of the URL. ";

%feature("docstring")  Arc::URL::Path "const std::string&
Arc::URL::Path() const

Returns the path of the URL. ";

%feature("docstring")  Arc::URL::FullPath "std::string
Arc::URL::FullPath() const

Returns the path of the URL with all options attached. ";

%feature("docstring")  Arc::URL::ChangePath "void
Arc::URL::ChangePath(const std::string &newpath)

Changes the path of the URL. ";

%feature("docstring")  Arc::URL::HTTPOptions "const
std::map<std::string, std::string>& Arc::URL::HTTPOptions() const

Returns HTTP options if any. ";

%feature("docstring")  Arc::URL::HTTPOption "const std::string&
Arc::URL::HTTPOption(const std::string &option, const std::string
&undefined=\"\") const

Returns the value of an HTTP option.

Parameters:
-----------

option:  The option whose value is returned.

undefined:  This value is returned if the HTTP option is not defined.
";

%feature("docstring")  Arc::URL::LDAPAttributes "const
std::list<std::string>& Arc::URL::LDAPAttributes() const

Returns the LDAP attributes if any. ";

%feature("docstring")  Arc::URL::AddLDAPAttribute "void
Arc::URL::AddLDAPAttribute(const std::string &attribute)

Adds an LDAP attribute. ";

%feature("docstring")  Arc::URL::LDAPScope "Scope
Arc::URL::LDAPScope() const

Returns the LDAP scope. ";

%feature("docstring")  Arc::URL::ChangeLDAPScope "void
Arc::URL::ChangeLDAPScope(const Scope newscope)

Changes the LDAP scope. ";

%feature("docstring")  Arc::URL::LDAPFilter "const std::string&
Arc::URL::LDAPFilter() const

Returns the LDAP filter. ";

%feature("docstring")  Arc::URL::ChangeLDAPFilter "void
Arc::URL::ChangeLDAPFilter(const std::string &newfilter)

Changes the LDAP filter. ";

%feature("docstring")  Arc::URL::Options "const std::map<std::string,
std::string>& Arc::URL::Options() const

Returns URL options if any. ";

%feature("docstring")  Arc::URL::Option "const std::string&
Arc::URL::Option(const std::string &option, const std::string
&undefined=\"\") const

Returns the value of a URL option.

Parameters:
-----------

option:  The option whose value is returned.

undefined:  This value is returned if the URL option is not defined.
";

%feature("docstring")  Arc::URL::MetaDataOptions "const
std::map<std::string, std::string>& Arc::URL::MetaDataOptions() const

Returns metadata options if any. ";

%feature("docstring")  Arc::URL::MetaDataOption "const std::string&
Arc::URL::MetaDataOption(const std::string &option, const std::string
&undefined=\"\") const

Returns the value of a metadata option.

Parameters:
-----------

option:  The option whose value is returned.

undefined:  This value is returned if the metadata option is not
defined. ";

%feature("docstring")  Arc::URL::AddOption "bool
Arc::URL::AddOption(const std::string &option, const std::string
&value, bool overwrite=true)

Adds a URL option with the given value. Returns false if overwrite is
false and option already exists, true otherwise. Note that some
compilers may interpret AddOption(\"name\", \"value\") as a call to
AddOption(string, bool) so it is recommended to use explicit string
types when calling this method. ";

%feature("docstring")  Arc::URL::AddOption "bool
Arc::URL::AddOption(const std::string &option, bool overwrite=true)

Adds a URL option where option has the format \"name=value\". Returns
false if overwrite is true and option already exists or if option does
not have the correct format. Returns true otherwise. ";

%feature("docstring")  Arc::URL::AddMetaDataOption "void
Arc::URL::AddMetaDataOption(const std::string &option, const
std::string &value, bool overwrite=true)

Adds a metadata option ";

%feature("docstring")  Arc::URL::AddLocation "void
Arc::URL::AddLocation(const URLLocation &location)

Adds a Location ";

%feature("docstring")  Arc::URL::Locations "const
std::list<URLLocation>& Arc::URL::Locations() const

Returns the locations if any. ";

%feature("docstring")  Arc::URL::CommonLocOptions "const
std::map<std::string, std::string>& Arc::URL::CommonLocOptions() const

Returns the common location options if any. ";

%feature("docstring")  Arc::URL::CommonLocOption "const std::string&
Arc::URL::CommonLocOption(const std::string &option, const std::string
&undefined=\"\") const

Returns the value of a common location option.

Parameters:
-----------

option:  The option whose value is returned.

undefined:  This value is returned if the common location option is
not defined. ";

%feature("docstring")  Arc::URL::str "virtual std::string
Arc::URL::str() const

Returns a string representation of the URL including meta-options. ";

%feature("docstring")  Arc::URL::plainstr "virtual std::string
Arc::URL::plainstr() const

Returns a string representation of the URL without any options ";

%feature("docstring")  Arc::URL::fullstr "virtual std::string
Arc::URL::fullstr() const

Returns a string representation including options and locations ";

%feature("docstring")  Arc::URL::ConnectionURL "virtual std::string
Arc::URL::ConnectionURL() const

Returns a string representation with protocol, host and port only ";

%feature("docstring")  Arc::URL::StringMatches "bool
Arc::URL::StringMatches(const std::string &str) const

Returns true if string matches url. ";

%feature("docstring")  Arc::URL::ParseOptions "std::map<std::string,
std::string> Arc::URL::ParseOptions(const std::string &optstring, char
separator)

Parse a string of options separated by separator into an
attribute->value map ";


// File: classArc_1_1URLLocation.xml
%feature("docstring") Arc::URLLocation "

Class to hold a resolved URL location.

It is specific to file indexing service registrations.

C++ includes: URL.h ";

%feature("docstring")  Arc::URLLocation::URLLocation "Arc::URLLocation::URLLocation(const std::string &url=\"\")

Creates a URLLocation from a string representaion. ";

%feature("docstring")  Arc::URLLocation::URLLocation "Arc::URLLocation::URLLocation(const std::string &url, const
std::string &name)

Creates a URLLocation from a string representaion and a name. ";

%feature("docstring")  Arc::URLLocation::URLLocation "Arc::URLLocation::URLLocation(const URL &url)

Creates a URLLocation from a URL. ";

%feature("docstring")  Arc::URLLocation::URLLocation "Arc::URLLocation::URLLocation(const URL &url, const std::string &name)

Creates a URLLocation from a URL and a name. ";

%feature("docstring")  Arc::URLLocation::URLLocation "Arc::URLLocation::URLLocation(const std::map< std::string, std::string
> &options, const std::string &name)

Creates a URLLocation from options and a name. ";

%feature("docstring")  Arc::URLLocation::~URLLocation "virtual
Arc::URLLocation::~URLLocation()

URLLocation destructor. ";

%feature("docstring")  Arc::URLLocation::Name "const std::string&
Arc::URLLocation::Name() const

Returns the URLLocation name. ";

%feature("docstring")  Arc::URLLocation::str "virtual std::string
Arc::URLLocation::str() const

Returns a string representation of the URLLocation. ";

%feature("docstring")  Arc::URLLocation::fullstr "virtual std::string
Arc::URLLocation::fullstr() const

Returns a string representation including options and locations ";


// File: classArc_1_1URLMap.xml
%feature("docstring") Arc::URLMap "";

%feature("docstring")  Arc::URLMap::URLMap "Arc::URLMap::URLMap() ";

%feature("docstring")  Arc::URLMap::~URLMap "Arc::URLMap::~URLMap()
";

%feature("docstring")  Arc::URLMap::map "bool Arc::URLMap::map(URL
&url) const ";

%feature("docstring")  Arc::URLMap::local "bool
Arc::URLMap::local(const URL &url) const ";

%feature("docstring")  Arc::URLMap::add "void Arc::URLMap::add(const
URL &templ, const URL &repl, const URL &accs=URL()) ";


// File: classArc_1_1User.xml
%feature("docstring") Arc::User "";

%feature("docstring")  Arc::User::User "Arc::User::User() ";

%feature("docstring")  Arc::User::User "Arc::User::User(const
std::string name) ";

%feature("docstring")  Arc::User::User "Arc::User::User(int uid) ";

%feature("docstring")  Arc::User::Name "const std::string&
Arc::User::Name(void) const ";

%feature("docstring")  Arc::User::Home "const std::string&
Arc::User::Home(void) const ";

%feature("docstring")  Arc::User::get_uid "int
Arc::User::get_uid(void) const ";

%feature("docstring")  Arc::User::get_gid "int
Arc::User::get_gid(void) const ";

%feature("docstring")  Arc::User::check_file_access "int
Arc::User::check_file_access(const std::string &path, int flags) const
";

%feature("docstring")  Arc::User::RunAs "bool
Arc::User::RunAs(std::string cmd) ";


// File: classArc_1_1UserConfig.xml
%feature("docstring") Arc::UserConfig "

User configuration class

This class provides a container for a selection of various
attributes/parameters which can be configured to needs of the user,
and can be read by implementing instances or programs. The class can
be used in two ways. One can create a object from a configuration
file, or simply set the desired attributes by using the setter method,
associated with every setable attribute. The list of attributes which
can be configured in this class are: certificatepath /
CertificatePath(const std::string&)

keypath / KeyPath(const std::string&)

proxypath / ProxyPath(const std::string&)

cacertificatesdirectory / CACertificatesDirectory(const std::string&)

cacertificatepath / CACertificatePath(const std::string&)

timeout / Timeout(int)

joblist / JobListFile(const std::string&)

defaultservices / AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType)

rejectservices / AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType)

verbosity / Verbosity(const std::string&)

brokername / Broker(const std::string&) or Broker(const std::string&,
const std::string&)

brokerarguments / Broker(const std::string&) or Broker(const
std::string&, const std::string&)

bartender / Bartender(const std::list<URL>&)

vomsserverpath / VOMSServerPath(const std::string&)

username / UserName(const std::string&)

password / Password(const std::string&)

keypassword / KeyPassword(const std::string&)

keysize / KeySize(int)

certificatelifetime / CertificateLifeTime(const Period&)

slcs / SLCS(const URL&)

storedirectory / StoreDirectory(const std::string&)

jobdownloaddirectory / JobDownloadDirectory(const std::string&)

idpname / IdPName(const std::string&)

where the first term is the name of the attribute used in the
configuration file, and the second term is the associated setter
method (for more information about a given attribute see the
description of the setter method).

The configuration file should have a INI-style format and the
IniConfig class will thus be used to parse the file. The above
mentioned attributes should be placed in the common section. Another
section is also valid in the configuration file, which is the alias
section. Here it is possible to define aliases representing one or
multiple services. These aliases can be used in the AddServices(const
std::list<std::string>&, ServiceType) and AddServices(const
std::list<std::string>&, const std::list<std::string>&, ServiceType)
methods.

The UserConfig class also provides a method InitializeCredentials()
for locating user credentials by searching in different standard
locations. The CredentialsFound() method can be used to test if
locating the credentials succeeded.

C++ includes: UserConfig.h ";

%feature("docstring")  Arc::UserConfig::UserConfig "Arc::UserConfig::UserConfig(initializeCredentialsType
initializeCredentials=initializeCredentialsType())

Create a UserConfig object.

The UserConfig object created by this constructor initializes only
default values, and if specified by the initializeCredentials boolean
credentials will be tried initialized using the
InitializeCredentials() method. The object is only non-valid if
initialization of credentials fails which can be checked with the
operator bool() method.

Parameters:
-----------

initializeCredentials:  is a optional boolean indicating if the
InitializeCredentials() method should be invoked, the default is true.

See:   InitializeCredentials()

operator bool() ";

%feature("docstring")  Arc::UserConfig::UserConfig "Arc::UserConfig::UserConfig(const std::string &conffile,
initializeCredentialsType
initializeCredentials=initializeCredentialsType(), bool
loadSysConfig=true)

Create a UserConfig object.

The UserConfig object created by this constructor will, if specified
by the loadSysConfig boolean, first try to load the system
configuration file by invoking the LoadConfigurationFile() method, and
if this fails a ::WARNING is reported. Then the configuration file
passed will be tried loaded using the before mentioned method, and if
this fails an ::ERROR is reported, and the created object will be non-
valid. Note that if the passed file path is empty the example
configuration will be tried copied to the default configuration file
path specified by DEFAULTCONFIG. If the example file cannot be copied
one or more ::WARNING messages will be reported and no configration
will be loaded. If loading the configurations file succeeded and if
initializeCredentials is true then credentials will be initialized
using the InitializeCredentials() method, and if no valid credentials
are found the created object will be non-valid.

Parameters:
-----------

conffile:  is the path to a INI-configuration file.

initializeCredentials:  is a boolean indicating if credentials should
be initialized, the default is true.

loadSysConfig:  is a boolean indicating if the system configuration
file should be loaded aswell, the default is true.

See:   LoadConfigurationFile(const std::string&, bool)

InitializeCredentials()

operator bool()

SYSCONFIG

EXAMPLECONFIG ";

%feature("docstring")  Arc::UserConfig::UserConfig "Arc::UserConfig::UserConfig(const std::string &conffile, const
std::string &jfile, initializeCredentialsType
initializeCredentials=initializeCredentialsType(), bool
loadSysConfig=true)

Create a UserConfig object.

The UserConfig object created by this constructor does only differ
from the UserConfig(const std::string&, bool, bool) constructor in
that it is possible to pass the path of the job list file directly to
this constructor. If the job list file joblistfile is empty, the
behaviour of this constructor is exactly the same as the before
mentioned, otherwise the job list file will be initilized by invoking
the setter method JobListFile(const std::string&). If it fails the
created object will be non-valid, otherwise the specified
configuration file conffile will be loaded with the ignoreJobListFile
argument set to true.

Parameters:
-----------

conffile:  is the path to a INI-configuration file

jfile:  is the path to a (non-)existing job list file.

initializeCredentials:  is a boolean indicating if credentials should
be initialized, the default is true.

loadSysConfig:  is a boolean indicating if the system configuration
file should be loaded aswell, the default is true.

See:   JobListFile(const std::string&)

LoadConfigurationFile(const std::string&, bool)

InitializeCredentials()

operator bool() ";

%feature("docstring")  Arc::UserConfig::UserConfig "Arc::UserConfig::UserConfig(const long int &ptraddr)

Language binding constructor.

The passed long int should be a pointer address to a UserConfig
object, and this address is then casted into this UserConfig object.

Parameters:
-----------

ptraddr:  is an memory address to a UserConfig object. ";

%feature("docstring")  Arc::UserConfig::~UserConfig "Arc::UserConfig::~UserConfig() ";

%feature("docstring")  Arc::UserConfig::InitializeCredentials "void
Arc::UserConfig::InitializeCredentials()

Initialize user credentials.

The location of the user credentials will be tried located when
calling this method and stored internally when found. The method
searches in different locations. First the user proxy or the user
key/certificate pair is tried located in the following order: Proxy
path specified by the environment variable X509_USER_PROXY

Key/certificate path specified by the environment X509_USER_KEY and
X509_USER_CERT

Proxy path specified in either configuration file passed to the
contructor or explicitly set using the setter method ProxyPath(const
std::string&)

Key/certificate path specified in either configuration file passed to
the constructor or explicitly set using the setter methods
KeyPath(const std::string&) and CertificatePath(const std::string&)

ProxyPath with file name x509up_u concatenated with the user ID
located in the OS temporary directory.

If the proxy or key/certificate pair have been explicitly specified
only the specified path(s) will be tried, and if not found a ::ERROR
is reported. If the proxy or key/certificate have not been specified
and it is not located in the temporary directory a ::WARNING will be
reported and the host key/certificate pair is tried and then the
Globus key/certificate pair and a ::ERROR will be reported if not
found in any of these locations.

Together with the proxy and key/certificate pair, the path to the
directory containing CA certificates is also tried located when
invoking this method. The directory will be tried located in the
following order: Path specified by the X509_CERT_DIR environment
variable.

Path explicitly specified either in a parsed configuration file using
the cacertficatecirectory or by using the setter method
CACertificatesDirectory().

Path created by concatenating the output of User::Home() with
'.globus' and 'certificates' separated by the directory delimeter.

Path created by concatenating the output of Glib::get_home_dir() with
'.globus' and 'certificates' separated by the directory delimeter.

Path created by concatenating the output of ArcLocation::Get(), with
'etc' and 'certificates' separated by the directory delimeter.

Path created by concatenating the output of ArcLocation::Get(), with
'etc', 'grid-security' and 'certificates' separated by the directory
delimeter.

Path created by concatenating the output of ArcLocation::Get(), with
'share' and 'certificates' separated by the directory delimeter.

Path created by concatenating 'etc', 'grid-security' and
'certificates' separated by the directory delimeter.

If the CA certificate directory have explicitly been specified and the
directory does not exist a ::ERROR is reported. If none of the
directories above does not exist a ::ERROR is reported.

See:   CredentialsFound()

ProxyPath(const std::string&)

KeyPath(const std::string&)

CertificatePath(const std::string&)

CACertificatesDirectory(const std::string&) ";

%feature("docstring")  Arc::UserConfig::CredentialsFound "bool
Arc::UserConfig::CredentialsFound() const

Validate credential location.

Valid credentials consists of a combination of a path to existing CA-
certificate directory and either a path to existing proxy or a path to
existing user key/certificate pair. If valid credentials are found
this method returns true, otherwise false is returned.

true if valid credentials are found, otherwise false.

See:   InitializeCredentials() ";

%feature("docstring")  Arc::UserConfig::LoadConfigurationFile "bool
Arc::UserConfig::LoadConfigurationFile(const std::string &conffile,
bool ignoreJobListFile=true)

Load specified configuration file.

The configuration file passed is parsed by this method by using the
IniConfig class. If the parsing is unsuccessful a ::WARNING is
reported.

The format of the configuration file should follow that of INI, and
every attribute present in the file is only allowed once, if otherwise
a ::WARNING will be reported. The file can contain at most two
sections, one named common and the other name alias. If other sections
exist a ::WARNING will be reported. Only the following attributes is
allowed in the common section of the configurationfile:
certificatepath ( CertificatePath(const std::string&))

keypath ( KeyPath(const std::string&))

proxypath ( ProxyPath(const std::string&))

cacertificatesdirectory ( CACertificatesDirectory(const std::string&))

cacertificatepath ( CACertificatePath(const std::string&))

timeout ( Timeout(int))

joblist ( JobListFile(const std::string&))

defaultservices ( AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType))

rejectservices ( AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType))

verbosity ( Verbosity(const std::string&))

brokername ( Broker(const std::string&) or Broker(const std::string&,
const std::string&))

brokerarguments ( Broker(const std::string&) or Broker(const
std::string&, const std::string&))

bartender (Bartender(const std::list<URL>&))

vomsserverpath ( VOMSServerPath(const std::string&))

username ( UserName(const std::string&))

password ( Password(const std::string&))

keypassword ( KeyPassword(const std::string&))

keysize ( KeySize(int))

certificatelifetime ( CertificateLifeTime(const Period&))

slcs ( SLCS(const URL&))

storedirectory ( StoreDirectory(const std::string&))

jobdownloaddirectory ( JobDownloadDirectory(const std::string&))

idpname ( IdPName(const std::string&))

where the method in parentheses is the associated setter method. If
other attributes exist in the common section a ::WARNING will be
reported for each of these attributes. In the alias section aliases
can be defined, and should represent a selection of services. The
alias can then refered to by input to the AddServices(const
std::list<std::string>&, ServiceType) and AddServices(const
std::list<std::string>&, const std::list<std::string>&, ServiceType)
methods. An alias can not contain any of the characters '.', ':', ' '
or '\\\\t' and should be defined as follows: \\\\[
<alias\\\\_name>=<service\\\\_type>:<flavour>:<service\\\\_url>|<alias\\\\_ref>
[...] \\\\] where <alias_name> is the name of the defined alias,
<service_type> is the service type in lower case, <flavour> is the
type of middleware plugin to use, <service_url> is the URL which
should be used to contact the service and <alias_ref> is another
defined alias. The parsed aliases will be stored internally and
resolved when needed. If a alias already exist, and another alias with
the same name is parsed then this other alias will overwrite the
existing alias.

Parameters:
-----------

conffile:  is the path to the configuration file.

ignoreJobListFile:  is a optional boolean which indicates whether the
joblistfile attribute in the configuration file should be ignored.
Default is to ignored it ( true).

If loading the configuration file succeeds true is returned, otherwise
false is returned.

See:   SaveToFile() ";

%feature("docstring")  Arc::UserConfig::SaveToFile "bool
Arc::UserConfig::SaveToFile(const std::string &filename) const

Save to INI file.

This method will save the object data as a INI file. The saved file
can be loaded with the LoadConfigurationFile method.

Parameters:
-----------

filename:  the name of the file which the data will be saved to.

false if unable to get handle on file, otherwise true is returned.

See:   LoadConfigurationFile() ";

%feature("docstring")  Arc::UserConfig::ApplyToConfig "void
Arc::UserConfig::ApplyToConfig(BaseConfig &ccfg) const

Apply credentials to BaseConfig.

This methods sets the BaseConfig credentials to the credentials
contained in this object. It also passes user defined configuration
overlay if any.

See:   InitializeCredentials()

CredentialsFound()

BaseConfig

Parameters:
-----------

ccfg:  a BaseConfig object which will configured with the credentials
of this object. ";

%feature("docstring")  Arc::UserConfig::JobListFile "bool
Arc::UserConfig::JobListFile(const std::string &path)

Set path to job list file.

The method takes a path to a file which will be used as the job list
file for storing and reading job information. If the specified path
path does not exist a empty job list file will be tried created. If
creating the job list file in any way fails false will be returned and
a ::ERROR message will be reported. Otherwise true is returned. If the
directory containing the file does not exist, it will be tried
created. The method will also return false if the file is not a
regular file.

The attribute associated with this setter method is 'joblist'.

Parameters:
-----------

path:  the path to the job list file.

If the job list file is a regular file or if it can be created true is
returned, otherwise false is returned.

See:   JobListFile() const ";

%feature("docstring")  Arc::UserConfig::JobListFile "const
std::string& Arc::UserConfig::JobListFile() const

Get a reference to the path of the job list file.

The job list file is used to store and fetch information about
submitted computing jobs to computing services. This method will
return the path to the specified job list file.

The path to the job list file is returned.

See:   JobListFile(const std::string&) ";

%feature("docstring")  Arc::UserConfig::ResolveAliases "bool
Arc::UserConfig::ResolveAliases(std::list< std::string > &services,
ServiceType st) ";

%feature("docstring")  Arc::UserConfig::AddServices "bool
Arc::UserConfig::AddServices(const std::list< std::string > &services,
ServiceType st)

Add selected and rejected services.

This method adds selected services and adds services to reject from
the specified list services, which contains string objects. The syntax
of a single element in the list must be expressed in the following two
formats: \\\\[ [-]<flavour>:<service\\\\_url>|[-]<alias> \\\\] where
the optional '-' indicate that the service should be added to the
private list of services to reject. In the first format the <flavour>
part indicates the type of ACC plugin to use when contacting the
service, which is specified by the URL <service_url>, and in the
second format the <alias> part specifies a alias defined in a parsed
configuration file, note that the alias must not contain any of the
charaters ':', '.', ' ' or '\\\\t'. If a alias cannot be resolved an
::ERROR will be reported to the logger and the method will return
false. If a element in the list services cannot be parsed an ::ERROR
will be reported, and the element is skipped.

Two attributes are indirectly associated with this setter method
'defaultservices' and 'rejectservices'. The values specified with the
'defaultservices' attribute will be added to the list of selected
services, and like-wise with the 'rejectservices' attribute.

Parameters:
-----------

services:  is a list of services to either select or reject.

st:  indicates the type of the specfied services.

This method returns false in case an alias cannot be resolved. In any
other case true is returned.

See:  AddServices(const std::string&, const std::string&, ServiceType)

GetSelectedServices()

GetRejectedServices()

ClearSelectedServices()

ClearRejectedServices()

LoadConfigurationFile() ";

%feature("docstring")  Arc::UserConfig::AddServices "bool
Arc::UserConfig::AddServices(const std::list< std::string > &selected,
const std::list< std::string > &rejected, ServiceType st)

Add selected and rejected services.

The only diffence in behaviour of this method compared to the
AddServices(const std::list<std::string>&, ServiceType) method is the
input parameters and the format these parameters should follow.
Instead of having an optional '-' in front of the string selected and
rejected services should be specified in the two different arguments.

Two attributes are indirectly associated with this setter method
'defaultservices' and 'rejectservices'. The values specified with the
'defaultservices' attribute will be added to the list of selected
services, and like-wise with the 'rejectservices' attribute.

Parameters:
-----------

selected:  is a list of services which will be added to the selected
services of this object.

rejected:  is a list of services which will be added to the rejected
services of this object.

st:  specifies the ServiceType of the services to add.

This method return false in case an alias cannot be resolved. In any
other case true is returned.

See:   AddServices(const std::list<std::string>&, ServiceType)

GetSelectedServices()

GetRejectedServices()

ClearSelectedServices()

ClearRejectedServices()

LoadConfigurationFile() ";

%feature("docstring")  Arc::UserConfig::GetSelectedServices "const
std::list<std::string>&
Arc::UserConfig::GetSelectedServices(ServiceType st) const

Get selected services.

Get the selected services with the ServiceType specified by st.

Parameters:
-----------

st:  specifies which ServiceType should be returned by the method.

The selected services is returned.

See:   AddServices(const std::list<std::string>&, ServiceType)

AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType)

GetRejectedServices(ServiceType) const

ClearSelectedServices() ";

%feature("docstring")  Arc::UserConfig::GetRejectedServices "const
std::list<std::string>&
Arc::UserConfig::GetRejectedServices(ServiceType st) const

Get rejected services.

Get the rejected services with the ServiceType specified by st.

Parameters:
-----------

st:  specifies which ServiceType should be returned by the method.

The rejected services is returned.

See:   AddServices(const std::list<std::string>&, ServiceType)

AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType)

GetSelectedServices(ServiceType)

ClearRejectedServices() ";

%feature("docstring")  Arc::UserConfig::ClearSelectedServices "void
Arc::UserConfig::ClearSelectedServices()

Clear selected services.

Calling this method will cause the internally stored selected services
to be cleared.

See:   ClearSelectedServices(ServiceType)

ClearRejectedServices()

AddServices(const std::list<std::string>&, ServiceType)

AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType)

GetSelectedServices() ";

%feature("docstring")  Arc::UserConfig::ClearSelectedServices "void
Arc::UserConfig::ClearSelectedServices(ServiceType st)

Clear selected services with specified ServiceType.

Calling this method will cause the internally stored selected services
with the ServiceType st to be cleared.

See:   ClearSelectedServices()

ClearRejectedServices(ServiceType)

AddServices(const std::list<std::string>&, ServiceType)

AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType)

GetSelectedServices() ";

%feature("docstring")  Arc::UserConfig::ClearRejectedServices "void
Arc::UserConfig::ClearRejectedServices()

Clear selected services.

Calling this method will cause the internally stored rejected services
to be cleared.

See:   ClearRejectedServices(ServiceType)

ClearSelectedServices()

AddServices(const std::list<std::string>&, ServiceType)

AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType)

GetRejectedServices() ";

%feature("docstring")  Arc::UserConfig::ClearRejectedServices "void
Arc::UserConfig::ClearRejectedServices(ServiceType st)

Clear rejected services with specified ServiceType.

Calling this method will cause the internally stored rejected services
with the ServiceType st to be cleared.

See:   ClearRejectedServices()

ClearSelectedServices(ServiceType)

AddServices(const std::list<std::string>&, ServiceType)

AddServices(const std::list<std::string>&, const
std::list<std::string>&, ServiceType)

GetRejectedServices() ";

%feature("docstring")  Arc::UserConfig::Timeout "bool
Arc::UserConfig::Timeout(int newTimeout)

Set timeout.

When communicating with a service the timeout specifies how long, in
seconds, the communicating instance should wait for a response. If the
response have not been recieved before this period in time, the
connection is typically dropped, and an error will be reported.

This method will set the timeout to the specified integer. If the
passed integer is less than or equal to 0 then false is returned and
the timeout will not be set, otherwise true is returned and the
timeout will be set to the new value.

The attribute associated with this setter method is 'timeout'.

Parameters:
-----------

newTimeout:  the new timeout value in seconds.

false in case newTimeout <= 0, otherwise true.

See:   Timeout() const

DEFAULT_TIMEOUT ";

%feature("docstring")  Arc::UserConfig::Timeout "int
Arc::UserConfig::Timeout() const

Get timeout.

Returns the timeout in seconds.

timeout in seconds.

See:   Timeout(int)

DEFAULT_TIMEOUT ";

%feature("docstring")  Arc::UserConfig::Verbosity "bool
Arc::UserConfig::Verbosity(const std::string &newVerbosity)

Set verbosity.

The verbosity will be set when invoking this method. If the string
passed cannot be parsed into a corresponding LogLevel, using the
function a ::WARNING is reported and false is returned, otherwise true
is returned.

The attribute associated with this setter method is 'verbosity'.

true in case the verbosity could be set to a allowed LogLevel,
otherwise false.

See:   Verbosity() const ";

%feature("docstring")  Arc::UserConfig::Verbosity "const std::string&
Arc::UserConfig::Verbosity() const

Get the user selected level of verbosity.

The string representation of the verbosity level specified by the user
is returned when calling this method. If the user have not specified
the verbosity level the empty string will be referenced.

the verbosity level, or empty if it has not been set.

See:   Verbosity(const std::string&) ";

%feature("docstring")  Arc::UserConfig::Broker "bool
Arc::UserConfig::Broker(const std::string &name)

Set broker to use in target matching.

The string passed to this method should be in the format:
\\\\[<name>[:<argument>]\\\\] where the <name> is the name of the
broker and cannot contain any ':', and the optional <argument> should
contain arguments which should be passed to the broker.

Two attributes are associated with this setter method 'brokername' and
'brokerarguments'.

Parameters:
-----------

name:  the broker name and argument specified in the format given
above.

This method allways returns true.

See:   Broker

Broker(const std::string&, const std::string&)

Broker() const

DEFAULT_BROKER ";

%feature("docstring")  Arc::UserConfig::Broker "bool
Arc::UserConfig::Broker(const std::string &name, const std::string
&argument)

Set broker to use in target matching.

As opposed to the Broker(const std::string&) method this method sets
broker name and arguments directly from the passed two arguments.

Two attributes are associated with this setter method 'brokername' and
'brokerarguments'.

Parameters:
-----------

name:  is the name of the broker.

argument:  is the arguments of the broker.

This method always returns true.

See:   Broker

Broker(const std::string&)

Broker() const

DEFAULT_BROKER ";

%feature("docstring")  Arc::UserConfig::Broker "const
std::pair<std::string, std::string>& Arc::UserConfig::Broker() const

Get the broker and corresponding arguments.

The returned pair contains the broker name as the first component and
the argument as the second.

See:   Broker(const std::string&)

Broker(const std::string&, const std::string&)

DEFAULT_BROKER ";

%feature("docstring")  Arc::UserConfig::Bartender "bool
Arc::UserConfig::Bartender(const std::vector< URL > &urls)

Set bartenders, used to contact Chelonia.

Takes as input a vector of Bartender URLs.

The attribute associated with this setter method is 'bartender'.

Parameters:
-----------

urls:  is a list of URL object to be set as bartenders.

This method always returns true.

See:   AddBartender(const URL&)

Bartender() const ";

%feature("docstring")  Arc::UserConfig::AddBartender "void
Arc::UserConfig::AddBartender(const URL &url)

Set bartenders, used to contact Chelonia.

Takes as input a Bartender URL and adds this to the list of
bartenders.

Parameters:
-----------

url:  is a URL to be added to the list of bartenders.

See:  Bartender(const std::list<URL>&)

Bartender() const ";

%feature("docstring")  Arc::UserConfig::Bartender "const
std::vector<URL>& Arc::UserConfig::Bartender() const

Get bartenders.

Returns a list of Bartender URLs

The list of bartender URL objects is returned.

See:  Bartender(const std::list<URL>&)

AddBartender(const URL&) ";

%feature("docstring")  Arc::UserConfig::VOMSServerPath "bool
Arc::UserConfig::VOMSServerPath(const std::string &path)

Set path to file containing VOMS configuration.

Set path to file which contians list of VOMS services and associated
configuration parameters needed to contact those services. It is used
by arcproxy.

The attribute associated with this setter method is 'vomsserverpath'.

Parameters:
-----------

path:  the path to VOMS configuration file

This method always return true.

See:   VOMSServerPath() const ";

%feature("docstring")  Arc::UserConfig::VOMSServerPath "const
std::string& Arc::UserConfig::VOMSServerPath() const

Get path to file containing VOMS configuration.

Get path to file which contians list of VOMS services and associated
configuration parameters.

The path to VOMS configuration file is returned.

See:   VOMSServerPath(const std::string&) ";

%feature("docstring")  Arc::UserConfig::UserName "bool
Arc::UserConfig::UserName(const std::string &name)

Set user-name for SLCS.

Set username which is used for requesting credentials from Short Lived
Credentials Service.

The attribute associated with this setter method is 'username'.

Parameters:
-----------

name:  is the name of the user.

This method always return true.

See:   UserName() const ";

%feature("docstring")  Arc::UserConfig::UserName "const std::string&
Arc::UserConfig::UserName() const

Get user-name.

Get username which is used for requesting credentials from Short Lived
Credentials Service.

The username is returned.

See:   UserName(const std::string&) ";

%feature("docstring")  Arc::UserConfig::Password "bool
Arc::UserConfig::Password(const std::string &newPassword)

Set password.

Set password which is used for requesting credentials from Short Lived
Credentials Service.

The attribute associated with this setter method is 'password'.

Parameters:
-----------

newPassword:  is the new password to set.

This method always returns true.

See:   Password() const ";

%feature("docstring")  Arc::UserConfig::Password "const std::string&
Arc::UserConfig::Password() const

Get password.

Get password which is used for requesting credentials from Short Lived
Credentials Service.

The password is returned.

See:   Password(const std::string&) ";

%feature("docstring")  Arc::UserConfig::ProxyPath "bool
Arc::UserConfig::ProxyPath(const std::string &newProxyPath)

Set path to user proxy.

This method will set the path of the user proxy. Note that the
InitializeCredentials() method will also try to set this path, by
searching in different locations.

The attribute associated with this setter method is 'proxypath'

Parameters:
-----------

newProxyPath:  is the path to a user proxy.

This method always returns true.

See:   InitializeCredentials()

CredentialsFound()

ProxyPath() const ";

%feature("docstring")  Arc::UserConfig::ProxyPath "const std::string&
Arc::UserConfig::ProxyPath() const

Get path to user proxy.

Retrieve path to user proxy.

Returns the path to the user proxy.

See:   ProxyPath(const std::string&) ";

%feature("docstring")  Arc::UserConfig::CertificatePath "bool
Arc::UserConfig::CertificatePath(const std::string
&newCertificatePath)

Set path to certificate.

The path to user certificate will be set by this method. The path to
the correcsponding key can be set with the KeyPath(const std::string&)
method. Note that the InitializeCredentials() method will also try to
set this path, by searching in different locations.

The attribute associated with this setter method is 'certificatepath'.

Parameters:
-----------

newCertificatePath:  is the path to the new certificate.

This method always returns true.

See:   InitializeCredentials()

CredentialsFound() const

CertificatePath() const

KeyPath(const std::string&) ";

%feature("docstring")  Arc::UserConfig::CertificatePath "const
std::string& Arc::UserConfig::CertificatePath() const

Get path to certificate.

The path to the cerficate is returned when invoking this method. The
certificate path is returned.

See:   InitializeCredentials()

CredentialsFound() const

CertificatePath(const std::string&)

KeyPath() const ";

%feature("docstring")  Arc::UserConfig::KeyPath "bool
Arc::UserConfig::KeyPath(const std::string &newKeyPath)

Set path to key.

The path to user key will be set by this method. The path to the
corresponding certificate can be set with the CertificatePath(const
std::string&) method. Note that the InitializeCredentials() method
will also try to set this path, by searching in different locations.

The attribute associated with this setter method is 'keypath'.

Parameters:
-----------

newKeyPath:  is the path to the new key.

This method always returns true.

See:   InitializeCredentials()

CredentialsFound() const

KeyPath() const

CertificatePath(const std::string&)

KeyPassword(const std::string&)

KeySize(int) ";

%feature("docstring")  Arc::UserConfig::KeyPath "const std::string&
Arc::UserConfig::KeyPath() const

Get path to key.

The path to the key is returned when invoking this method.

The path to the user key is returned.

See:   InitializeCredentials()

CredentialsFound() const

KeyPath(const std::string&)

CertificatePath() const

KeyPassword() const

KeySize() const ";

%feature("docstring")  Arc::UserConfig::KeyPassword "bool
Arc::UserConfig::KeyPassword(const std::string &newKeyPassword)

Set password for generated key.

Set password to be used to encode private key of credentials obtained
from Short Lived Credentials Service.

The attribute associated with this setter method is 'keypassword'.

Parameters:
-----------

newKeyPassword:  is the new password to the key.

This method always returns true.

See:   KeyPassword() const

KeyPath(const std::string&)

KeySize(int) ";

%feature("docstring")  Arc::UserConfig::KeyPassword "const
std::string& Arc::UserConfig::KeyPassword() const

Get password for generated key.

Get password to be used to encode private key of credentials obtained
from Short Lived Credentials Service.

The key password is returned.

See:   KeyPassword(const std::string&)

KeyPath() const

KeySize() const ";

%feature("docstring")  Arc::UserConfig::KeySize "bool
Arc::UserConfig::KeySize(int newKeySize)

Set key size.

Set size/strengt of private key of credentials obtained from Short
Lived Credentials Service.

The attribute associated with this setter method is 'keysize'.

Parameters:
-----------

newKeySize:  is the size, an an integer, of the key.

This method always returns true.

See:   KeySize() const

KeyPath(const std::string&)

KeyPassword(const std::string&) ";

%feature("docstring")  Arc::UserConfig::KeySize "int
Arc::UserConfig::KeySize() const

Get key size.

Get size/strengt of private key of credentials obtained from Short
Lived Credentials Service.

The key size, as an integer, is returned.

See:   KeySize(int)

KeyPath() const

KeyPassword() const ";

%feature("docstring")  Arc::UserConfig::CACertificatePath "bool
Arc::UserConfig::CACertificatePath(const std::string
&newCACertificatePath)

Set CA-certificate path.

The path to the file containing CA-certificate will be set when
calling this method. This configuration parameter is deprecated - use
CACertificatesDirectory instead. Only arcslcs uses it.

The attribute associated with this setter method is
'cacertificatepath'.

Parameters:
-----------

newCACertificatePath:  is the path to the CA-certificate.

This method always returns true.

See:   CACertificatePath() const ";

%feature("docstring")  Arc::UserConfig::CACertificatePath "const
std::string& Arc::UserConfig::CACertificatePath() const

Get path to CA-certificate.

Retrieve the path to the file containing CA-certificate. This
configuration parameter is deprecated.

The path to the CA-certificate is returned.

See:   CACertificatePath(const std::string&) ";

%feature("docstring")  Arc::UserConfig::CACertificatesDirectory "bool
Arc::UserConfig::CACertificatesDirectory(const std::string
&newCACertificatesDirectory)

Set path to CA-certificate directory.

The path to the directory containing CA-certificates will be set when
calling this method. Note that the InitializeCredentials() method will
also try to set this path, by searching in different locations.

The attribute associated with this setter method is
'cacertificatesdirectory'.

Parameters:
-----------

newCACertificatesDirectory:  is the path to the CA-certificate
directory.

This method always returns true.

See:   InitializeCredentials()

CredentialsFound() const

CACertificatesDirectory() const ";

%feature("docstring")  Arc::UserConfig::CACertificatesDirectory "const std::string& Arc::UserConfig::CACertificatesDirectory() const

Get path to CA-certificate directory.

Retrieve the path to the CA-certificate directory.

The path to the CA-certificate directory is returned.

See:   InitializeCredentials()

CredentialsFound() const

CACertificatesDirectory(const std::string&) ";

%feature("docstring")  Arc::UserConfig::CertificateLifeTime "bool
Arc::UserConfig::CertificateLifeTime(const Period
&newCertificateLifeTime)

Set certificate life time.

Sets lifetime of user certificate which will be obtained from Short
Lived Credentials Service.

The attribute associated with this setter method is
'certificatelifetime'.

Parameters:
-----------

newCertificateLifeTime:  is the life time of a certificate, as a
Period object.

This method always returns true.

See:   CertificateLifeTime() const ";

%feature("docstring")  Arc::UserConfig::CertificateLifeTime "const
Period& Arc::UserConfig::CertificateLifeTime() const

Get certificate life time.

Gets lifetime of user certificate which will be obtained from Short
Lived Credentials Service.

The certificate life time is returned as a Period object.

See:   CertificateLifeTime(const Period&) ";

%feature("docstring")  Arc::UserConfig::SLCS "bool
Arc::UserConfig::SLCS(const URL &newSLCS)

Set the URL to the Short Lived Certificate Service (SLCS).

The attribute associated with this setter method is 'slcs'.

Parameters:
-----------

newSLCS:  is the URL to the SLCS

This method always returns true.

See:   SLCS() const ";

%feature("docstring")  Arc::UserConfig::SLCS "const URL&
Arc::UserConfig::SLCS() const

Get the URL to the Short Lived Certificate Service (SLCS).

The SLCS is returned.

See:   SLCS(const URL&) ";

%feature("docstring")  Arc::UserConfig::StoreDirectory "bool
Arc::UserConfig::StoreDirectory(const std::string &newStoreDirectory)

Set store directory.

Sets directory which will be used to store credentials obtained from
Short Lived Credential Servide.

The attribute associated with this setter method is 'storedirectory'.

Parameters:
-----------

newStoreDirectory:  is the path to the store directory.

This method always returns true.

See:  ";

%feature("docstring")  Arc::UserConfig::StoreDirectory "const
std::string& Arc::UserConfig::StoreDirectory() const

Get store diretory.

Sets directory which is used to store credentials obtained from Short
Lived Credential Servide.

The path to the store directory is returned.

See:   StoreDirectory(const std::string&) ";

%feature("docstring")  Arc::UserConfig::JobDownloadDirectory "bool
Arc::UserConfig::JobDownloadDirectory(const std::string
&newDownloadDirectory)

Set download directory.

Sets directory which will be used to download the job directory using
arcget command.

The attribute associated with this setter method is
'jobdownloaddirectory'.

Parameters:
-----------

newDownloadDirectory:  is the path to the download directory.

This method always returns true.

See:  ";

%feature("docstring")  Arc::UserConfig::JobDownloadDirectory "const
std::string& Arc::UserConfig::JobDownloadDirectory() const

Get download directory.

returns directory which will be used to download the job directory
using arcget command.

The attribute associated with the method is 'jobdownloaddirectory'.
This method returns the job download directory.

See:  ";

%feature("docstring")  Arc::UserConfig::IdPName "bool
Arc::UserConfig::IdPName(const std::string &name)

Set IdP name.

Sets Identity Provider name (Shibboleth) to which user belongs. It is
used for contacting Short Lived Certificate Service.

The attribute associated with this setter method is 'idpname'.

Parameters:
-----------

name:  is the new IdP name.

This method always returns true.

See:  ";

%feature("docstring")  Arc::UserConfig::IdPName "const std::string&
Arc::UserConfig::IdPName() const

Get IdP name.

Gets Identity Provider name (Shibboleth) to which user belongs.

The IdP name

See:   IdPName(const std::string&) ";

%feature("docstring")  Arc::UserConfig::OverlayFile "bool
Arc::UserConfig::OverlayFile(const std::string &path)

Set path to configuration overlay file.

Content of specified file is a backdoor to configuration XML generated
from information stored in this class. The content of file is passed
to BaseConfig class in ApplyToConfig(BaseConfig&) then merged with
internal configuration XML representation. This feature is meant for
quick prototyping/testing/tuning of functionality without rewriting
code. It is meant for developers and most users won't need it.

The attribute associated with this setter method is 'overlayfile'.

Parameters:
-----------

path:  is the new overlay file path.

This method always returns true.

See:  ";

%feature("docstring")  Arc::UserConfig::OverlayFile "const
std::string& Arc::UserConfig::OverlayFile() const

Get path to configuration overlay file.

The overlay file path

See:   OverlayFile(const std::string&) ";

%feature("docstring")  Arc::UserConfig::UtilsDirPath "bool
Arc::UserConfig::UtilsDirPath(const std::string &dir)

Set path to directory storing utility files for DataPoints.

Some DataPoints can store information on remote services in local
files. This method sets the path to the directory containing these
files. For example arc* tools set it to ARCUSERDIRECTORY and A-REX
sets it to the control directory. The directory is created if it does
not exist.

Parameters:
-----------

path:  is the new utils dir path.

This method always returns true. ";

%feature("docstring")  Arc::UserConfig::UtilsDirPath "const
std::string& Arc::UserConfig::UtilsDirPath() const

Get path to directory storing utility files for DataPoints.

The utils dir path

See:   UtilsDirPath(const std::string&) ";

%feature("docstring")  Arc::UserConfig::SetUser "void
Arc::UserConfig::SetUser(const User &u)

Set User for filesystem access.

Sometimes it is desirable to use the identity of another user when
accessing the filesystem. This user can be specified through this
method. By default this user is the same as the user running the
process.

Parameters:
-----------

u:   User identity to use ";

%feature("docstring")  Arc::UserConfig::GetUser "const User&
Arc::UserConfig::GetUser() const

Get User for filesystem access.

The user identity to use for file system access

See:   SetUser(const User&) ";


// File: classArc_1_1UsernameToken.xml
%feature("docstring") Arc::UsernameToken "

Interface for manipulation of WS-Security according to Username Token
Profile.

C++ includes: UsernameToken.h ";

%feature("docstring")  Arc::UsernameToken::UsernameToken "Arc::UsernameToken::UsernameToken(SOAPEnvelope &soap)

Link to existing SOAP header and parse Username Token information.
Username Token related information is extracted from SOAP header and
stored in class variables. ";

%feature("docstring")  Arc::UsernameToken::UsernameToken "Arc::UsernameToken::UsernameToken(SOAPEnvelope &soap, const
std::string &username, const std::string &password, const std::string
&uid, PasswordType pwdtype)

Add Username Token information into the SOAP header. Generated token
contains elements Username and Password and is meant to be used for
authentication.

Parameters:
-----------

soap:  the SOAP message

username:  <wsse:Username>...</wsse:Username> - if empty it is entered
interactively from stdin

password:  <wsse:Password Type=\"...\">...</wsse:Password> - if empty
it is entered interactively from stdin

uid:  <wsse: UsernameToken wsu:ID=\"...\">

pwdtype:  <wsse:Password Type=\"...\">...</wsse:Password> ";

%feature("docstring")  Arc::UsernameToken::UsernameToken "Arc::UsernameToken::UsernameToken(SOAPEnvelope &soap, const
std::string &username, const std::string &id, bool mac, int iteration)

Add Username Token information into the SOAP header. Generated token
contains elements Username and Salt and is meant to be used for
deriving Key Derivation.

Parameters:
-----------

soap:  the SOAP message

username:  <wsse:Username>...</wsse:Username>

mac:  if derived key is meant to be used for Message Authentication
Code

iteration:  <wsse11:Iteration>...</wsse11:Iteration> ";

%feature("docstring")  Arc::UsernameToken::Username "std::string
Arc::UsernameToken::Username(void)

Returns username associated with this instance ";

%feature("docstring")  Arc::UsernameToken::Authenticate "bool
Arc::UsernameToken::Authenticate(const std::string &password,
std::string &derived_key)

Checks parsed/generated token against specified password. If token is
meant to be used for deriving a key then key is returned in
derived_key. In that case authentication is performed outside of
UsernameToken class using obtained derived_key. ";

%feature("docstring")  Arc::UsernameToken::Authenticate "bool
Arc::UsernameToken::Authenticate(std::istream &password, std::string
&derived_key)

Checks parsed token against password stored in specified stream. If
token is meant to be used for deriving a key then key is returned in
derived_key ";


// File: classArc_1_1UserSwitch.xml
%feature("docstring") Arc::UserSwitch "

If this class is created user identity is switched to provided uid and
gid. Due to internal lock there will be only one valid instance of
this class. Any attempt to create another instance will block till
first one is destroyed. If uid and gid are set to 0 then user identity
is not switched. But lock is applied anyway. The lock has dual
purpose. First and most important is to protect communication with
underlying operating system which may depend on user identity. For
that it is advisable for code which talks to operating system to
acquire valid instance of this class. Care must be taken for not to
hold that instance too long cause that may block other code in
multithreaded envoronment. Other purpose of this lock is to provide
workaround for glibc bug in __nptl_setxid. That bug causes lockup of
seteuid() function if racing with fork. To avoid this problem the lock
mentioned above is used by Run class while spawning new process.

C++ includes: User.h ";

%feature("docstring")  Arc::UserSwitch::UserSwitch "Arc::UserSwitch::UserSwitch(int uid, int gid) ";

%feature("docstring")  Arc::UserSwitch::~UserSwitch "Arc::UserSwitch::~UserSwitch(void) ";


// File: classArc_1_1VOMSACInfo.xml
%feature("docstring") Arc::VOMSACInfo "";


// File: classArc_1_1VOMSTrustList.xml
%feature("docstring") Arc::VOMSTrustList "

Stores definitions for making decision if VOMS server is trusted

C++ includes: VOMSUtil.h ";

%feature("docstring")  Arc::VOMSTrustList::VOMSTrustList "Arc::VOMSTrustList::VOMSTrustList(void) ";

%feature("docstring")  Arc::VOMSTrustList::VOMSTrustList "Arc::VOMSTrustList::VOMSTrustList(const std::vector< std::string >
&encoded_list)

Creates chain lists and regexps from plain list. List is made of
chunks delimited by elements containing pattern \"NEXT CHAIN\". Each
chunk with more than one element is converted into one instance of
VOMSTrustChain. Chunks with single element are converted to
VOMSTrustChain if element does not have special symbols. Otherwise it
is treated as regular expression. Those symbols are '^','$' and '*'.
Trusted chains can be congicured in two ways: one way is:
<tls:VOMSCertTrustDNChain>
<tls:VOMSCertTrustDN>/O=Grid/O=NorduGrid/CN=host/arthur.hep.lu.se</tls:VOMSCertTrustDN>
<tls:VOMSCertTrustDN>/O=Grid/O=NorduGrid/CN=NorduGrid Certification
Authority</tls:VOMSCertTrustDN> <tls:VOMSCertTrustDN>----NEXT
CHAIN---</tls:VOMSCertTrustDN>
<tls:VOMSCertTrustDN>/DC=ch/DC=cern/OU=computers/CN=voms.cern.ch</tls:VOMSCertTrustDN>
<tls:VOMSCertTrustDN>/DC=ch/DC=cern/CN=CERN Trusted Certification
Authority</tls:VOMSCertTrustDN> </tls:VOMSCertTrustDNChain> the other
way is: <tls:VOMSCertTrustDNChain>
<tls:VOMSCertTrustDN>/O=Grid/O=NorduGrid/CN=host/arthur.hep.lu.se</tls:VOMSCertTrustDN>
<tls:VOMSCertTrustDN>/O=Grid/O=NorduGrid/CN=NorduGrid Certification
Authority</tls:VOMSCertTrustDN> </tls:VOMSCertTrustDNChain>
<tls:VOMSCertTrustDNChain>
<tls:VOMSCertTrustDN>/DC=ch/DC=cern/OU=computers/CN=voms.cern.ch</tls:VOMSCertTrustDN>
<tls:VOMSCertTrustDN>/DC=ch/DC=cern/CN=CERN Trusted Certification
Authority</tls:VOMSCertTrustDN> </tls:VOMSCertTrustDNChain> each chunk
is supposed to contain a suit of DN of trusted certificate chain, in
which the first DN is the DN of the certificate (cert0) which is used
to sign the Attribute Certificate (AC), the second DN is the DN of the
issuer certificate(cert1) which is used to sign cert0. So if there are
one or more intermediate issuers, then there should be 3 or more than
3 DNs in this chunk (considering cert0 and the root certificate, plus
the intermediate certificate) . ";

%feature("docstring")  Arc::VOMSTrustList::VOMSTrustList "Arc::VOMSTrustList::VOMSTrustList(const std::vector< VOMSTrustChain >
&chains, const std::vector< VOMSTrustRegex > &regexs)

Creates chain lists and regexps from those specified in arguments. See
AddChain() and AddRegex() for more information. ";

%feature("docstring")  Arc::VOMSTrustList::~VOMSTrustList "Arc::VOMSTrustList::~VOMSTrustList(void) ";

%feature("docstring")  Arc::VOMSTrustList::AddChain "VOMSTrustChain&
Arc::VOMSTrustList::AddChain(const VOMSTrustChain &chain)

Adds chain of trusted DNs to list. During verification each signature
of AC is checked against all stored chains. DNs of chain of
certificate used for signing AC are compared against DNs stored in
these chains one by one. If needed DN of issuer of last certificate is
checked too. Comparison succeeds if DNs in at least one stored chain
are same as those in certificate chain. Comparison stops when all DNs
in stored chain are compared. If there are more DNs in stored chain
than in certificate chain then comparison fails. Empty stored list
matches any certificate chain. Taking into account that certificate
chains are verified down to trusted CA anyway, having more than one DN
in stored chain seems to be useless. But such feature may be found
useful by some very strict sysadmins. ??? IMO,DN list here is not only
for authentication, it is also kind of ACL, which means the AC
consumer only trusts those DNs which issues AC. ";

%feature("docstring")  Arc::VOMSTrustList::AddChain "VOMSTrustChain&
Arc::VOMSTrustList::AddChain(void)

Adds empty chain of trusted DNs to list. ";

%feature("docstring")  Arc::VOMSTrustList::AddRegex "RegularExpression& Arc::VOMSTrustList::AddRegex(const VOMSTrustRegex
&reg)

Adds regular expression to list. During verification each signature of
AC is checked against all stored regular expressions. DN of signing
certificate must match at least one of stored regular expressions. ";

%feature("docstring")  Arc::VOMSTrustList::SizeChains "int
Arc::VOMSTrustList::SizeChains(void) const ";

%feature("docstring")  Arc::VOMSTrustList::SizeRegexs "int
Arc::VOMSTrustList::SizeRegexs(void) const ";

%feature("docstring")  Arc::VOMSTrustList::GetChain "const
VOMSTrustChain& Arc::VOMSTrustList::GetChain(int num) const ";

%feature("docstring")  Arc::VOMSTrustList::GetRegex "const
RegularExpression& Arc::VOMSTrustList::GetRegex(int num) const ";


// File: classArc_1_1WSAEndpointReference.xml
%feature("docstring") Arc::WSAEndpointReference "

Interface for manipulation of WS-Adressing Endpoint Reference.

It works on Endpoint Reference stored in XML tree. No information is
stored in this object except reference to corresponding XML subtree.

C++ includes: WSA.h ";

%feature("docstring")  Arc::WSAEndpointReference::WSAEndpointReference
"Arc::WSAEndpointReference::WSAEndpointReference(XMLNode epr)

Link to top level EPR XML node Linking to existing EPR in XML tree ";

%feature("docstring")  Arc::WSAEndpointReference::WSAEndpointReference
"Arc::WSAEndpointReference::WSAEndpointReference(const
WSAEndpointReference &wsa)

Copy constructor ";

%feature("docstring")  Arc::WSAEndpointReference::WSAEndpointReference
"Arc::WSAEndpointReference::WSAEndpointReference(const std::string
&address)

Creating independent EPR - not implemented ";

%feature("docstring")  Arc::WSAEndpointReference::WSAEndpointReference
"Arc::WSAEndpointReference::WSAEndpointReference(void)

Dummy constructor - creates invalid instance ";

%feature("docstring")
Arc::WSAEndpointReference::~WSAEndpointReference "Arc::WSAEndpointReference::~WSAEndpointReference(void)

Destructor. All empty elements of EPR XML are destroyed here too ";

%feature("docstring")  Arc::WSAEndpointReference::Address "std::string Arc::WSAEndpointReference::Address(void) const

Returns Address ( URL) encoded in EPR ";

%feature("docstring")  Arc::WSAEndpointReference::Address "void
Arc::WSAEndpointReference::Address(const std::string &uri)

Assigns new Address value. If EPR had no Address element it is
created. ";

%feature("docstring")  Arc::WSAEndpointReference::ReferenceParameters
"XMLNode Arc::WSAEndpointReference::ReferenceParameters(void)

Access to ReferenceParameters element of EPR. Obtained XML element
should be manipulated directly in application-dependent way. If EPR
had no ReferenceParameters element it is created. ";

%feature("docstring")  Arc::WSAEndpointReference::MetaData "XMLNode
Arc::WSAEndpointReference::MetaData(void)

Access to MetaData element of EPR. Obtained XML element should be
manipulated directly in application-dependent way. If EPR had no
MetaData element it is created. ";


// File: classArc_1_1WSAHeader.xml
%feature("docstring") Arc::WSAHeader "

Interface for manipulation WS-Addressing information in SOAP header.

It works on Endpoint Reference stored in XML tree. No information is
stored in this object except reference to corresponding XML subtree.

C++ includes: WSA.h ";

%feature("docstring")  Arc::WSAHeader::WSAHeader "Arc::WSAHeader::WSAHeader(SOAPEnvelope &soap)

Linking to a header of existing SOAP message ";

%feature("docstring")  Arc::WSAHeader::WSAHeader "Arc::WSAHeader::WSAHeader(const std::string &action)

Creating independent SOAP header - not implemented ";

%feature("docstring")  Arc::WSAHeader::~WSAHeader "Arc::WSAHeader::~WSAHeader(void) ";

%feature("docstring")  Arc::WSAHeader::To "std::string
Arc::WSAHeader::To(void) const

Returns content of To element of SOAP Header. ";

%feature("docstring")  Arc::WSAHeader::To "void
Arc::WSAHeader::To(const std::string &uri)

Set content of To element of SOAP Header. If such element does not
exist it's created. ";

%feature("docstring")  Arc::WSAHeader::From "WSAEndpointReference
Arc::WSAHeader::From(void)

Returns From element of SOAP Header. If such element does not exist
it's created. Obtained element may be manipulted. ";

%feature("docstring")  Arc::WSAHeader::ReplyTo "WSAEndpointReference
Arc::WSAHeader::ReplyTo(void)

Returns ReplyTo element of SOAP Header. If such element does not exist
it's created. Obtained element may be manipulted. ";

%feature("docstring")  Arc::WSAHeader::FaultTo "WSAEndpointReference
Arc::WSAHeader::FaultTo(void)

Returns FaultTo element of SOAP Header. If such element does not exist
it's created. Obtained element may be manipulted. ";

%feature("docstring")  Arc::WSAHeader::Action "std::string
Arc::WSAHeader::Action(void) const

Returns content of Action element of SOAP Header. ";

%feature("docstring")  Arc::WSAHeader::Action "void
Arc::WSAHeader::Action(const std::string &uri)

Set content of Action element of SOAP Header. If such element does not
exist it's created. ";

%feature("docstring")  Arc::WSAHeader::MessageID "std::string
Arc::WSAHeader::MessageID(void) const

Returns content of MessageID element of SOAP Header. ";

%feature("docstring")  Arc::WSAHeader::MessageID "void
Arc::WSAHeader::MessageID(const std::string &uri)

Set content of MessageID element of SOAP Header. If such element does
not exist it's created. ";

%feature("docstring")  Arc::WSAHeader::RelatesTo "std::string
Arc::WSAHeader::RelatesTo(void) const

Returns content of RelatesTo element of SOAP Header. ";

%feature("docstring")  Arc::WSAHeader::RelatesTo "void
Arc::WSAHeader::RelatesTo(const std::string &uri)

Set content of RelatesTo element of SOAP Header. If such element does
not exist it's created. ";

%feature("docstring")  Arc::WSAHeader::RelationshipType "std::string
Arc::WSAHeader::RelationshipType(void) const

Returns content of RelationshipType element of SOAP Header. ";

%feature("docstring")  Arc::WSAHeader::RelationshipType "void
Arc::WSAHeader::RelationshipType(const std::string &uri)

Set content of RelationshipType element of SOAP Header. If such
element does not exist it's created. ";

%feature("docstring")  Arc::WSAHeader::ReferenceParameter "XMLNode
Arc::WSAHeader::ReferenceParameter(int n)

Return n-th ReferenceParameter element ";

%feature("docstring")  Arc::WSAHeader::ReferenceParameter "XMLNode
Arc::WSAHeader::ReferenceParameter(const std::string &name)

Returns first ReferenceParameter element with specified name ";

%feature("docstring")  Arc::WSAHeader::NewReferenceParameter "XMLNode
Arc::WSAHeader::NewReferenceParameter(const std::string &name)

Creates new ReferenceParameter element with specified name. Returns
reference to created element. ";


// File: classArc_1_1WSRF.xml
%feature("docstring") Arc::WSRF "

Base class for every WSRF message.

This class is not intended to be used directly. Use it like reference
while passing through unknown WSRF message or use classes derived from
it.

C++ includes: WSRF.h ";

%feature("docstring")  Arc::WSRF::WSRF "Arc::WSRF::WSRF(SOAPEnvelope
&soap, const std::string &action=\"\")

Constructor - creates object out of supplied SOAP tree. ";

%feature("docstring")  Arc::WSRF::WSRF "Arc::WSRF::WSRF(bool
fault=false, const std::string &action=\"\")

Constructor - creates new WSRF object ";

%feature("docstring")  Arc::WSRF::~WSRF "virtual
Arc::WSRF::~WSRF(void) ";

%feature("docstring")  Arc::WSRF::SOAP "virtual SOAPEnvelope&
Arc::WSRF::SOAP(void)

Direct access to underlying SOAP element ";


// File: classArc_1_1WSRFBaseFault.xml
%feature("docstring") Arc::WSRFBaseFault "

Base class for WSRF fault messages.

Use classes inherited from it for specific faults.

C++ includes: WSRFBaseFault.h ";

%feature("docstring")  Arc::WSRFBaseFault::WSRFBaseFault "Arc::WSRFBaseFault::WSRFBaseFault(SOAPEnvelope &soap)

Constructor - creates object out of supplied SOAP tree. ";

%feature("docstring")  Arc::WSRFBaseFault::WSRFBaseFault "Arc::WSRFBaseFault::WSRFBaseFault(const std::string &type)

Constructor - creates new WSRF fault ";

%feature("docstring")  Arc::WSRFBaseFault::~WSRFBaseFault "virtual
Arc::WSRFBaseFault::~WSRFBaseFault(void) ";

%feature("docstring")  Arc::WSRFBaseFault::Type "std::string
Arc::WSRFBaseFault::Type(void) ";

%feature("docstring")  Arc::WSRFBaseFault::Timestamp "Time
Arc::WSRFBaseFault::Timestamp(void) ";

%feature("docstring")  Arc::WSRFBaseFault::Timestamp "void
Arc::WSRFBaseFault::Timestamp(Time) ";

%feature("docstring")  Arc::WSRFBaseFault::Originator "WSAEndpointReference Arc::WSRFBaseFault::Originator(void) ";

%feature("docstring")  Arc::WSRFBaseFault::ErrorCode "void
Arc::WSRFBaseFault::ErrorCode(const std::string &dialect, const
XMLNode &error) ";

%feature("docstring")  Arc::WSRFBaseFault::ErrorCode "XMLNode
Arc::WSRFBaseFault::ErrorCode(void) ";

%feature("docstring")  Arc::WSRFBaseFault::ErrorCodeDialect "std::string Arc::WSRFBaseFault::ErrorCodeDialect(void) ";

%feature("docstring")  Arc::WSRFBaseFault::Description "void
Arc::WSRFBaseFault::Description(int pos, const std::string &desc,
const std::string &lang) ";

%feature("docstring")  Arc::WSRFBaseFault::Description "std::string
Arc::WSRFBaseFault::Description(int pos) ";

%feature("docstring")  Arc::WSRFBaseFault::DescriptionLang "std::string Arc::WSRFBaseFault::DescriptionLang(int pos) ";

%feature("docstring")  Arc::WSRFBaseFault::FaultCause "void
Arc::WSRFBaseFault::FaultCause(int pos, const XMLNode &cause) ";

%feature("docstring")  Arc::WSRFBaseFault::FaultCause "XMLNode
Arc::WSRFBaseFault::FaultCause(int pos) ";


// File: classArc_1_1WSRFResourceUnavailableFault.xml
%feature("docstring") Arc::WSRFResourceUnavailableFault "";

%feature("docstring")
Arc::WSRFResourceUnavailableFault::WSRFResourceUnavailableFault "Arc::WSRFResourceUnavailableFault::WSRFResourceUnavailableFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRFResourceUnavailableFault::WSRFResourceUnavailableFault "Arc::WSRFResourceUnavailableFault::WSRFResourceUnavailableFault(void)
";

%feature("docstring")
Arc::WSRFResourceUnavailableFault::~WSRFResourceUnavailableFault "virtual
Arc::WSRFResourceUnavailableFault::~WSRFResourceUnavailableFault(void)
";


// File: classArc_1_1WSRFResourceUnknownFault.xml
%feature("docstring") Arc::WSRFResourceUnknownFault "";

%feature("docstring")
Arc::WSRFResourceUnknownFault::WSRFResourceUnknownFault "Arc::WSRFResourceUnknownFault::WSRFResourceUnknownFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRFResourceUnknownFault::WSRFResourceUnknownFault "Arc::WSRFResourceUnknownFault::WSRFResourceUnknownFault(void) ";

%feature("docstring")
Arc::WSRFResourceUnknownFault::~WSRFResourceUnknownFault "virtual
Arc::WSRFResourceUnknownFault::~WSRFResourceUnknownFault(void) ";


// File: classArc_1_1WSRP.xml
%feature("docstring") Arc::WSRP "

Base class for WS-ResourceProperties structures.

Inheriting classes implement specific WS-ResourceProperties messages
and their properties/elements. Refer to WS-ResourceProperties
specifications for things specific to every message.

C++ includes: WSResourceProperties.h ";

%feature("docstring")  Arc::WSRP::WSRP "Arc::WSRP::WSRP(bool
fault=false, const std::string &action=\"\")

Constructor - prepares object for creation of new WSRP
request/response/fault ";

%feature("docstring")  Arc::WSRP::WSRP "Arc::WSRP::WSRP(SOAPEnvelope
&soap, const std::string &action=\"\")

Constructor - creates object out of supplied SOAP tree. It does not
check if 'soap' represents valid WS-ResourceProperties structure.
Actual check for validity of structure has to be done by derived
class. ";

%feature("docstring")  Arc::WSRP::~WSRP "Arc::WSRP::~WSRP(void) ";


// File: classArc_1_1WSRPDeleteResourceProperties.xml
%feature("docstring") Arc::WSRPDeleteResourceProperties "";

%feature("docstring")
Arc::WSRPDeleteResourceProperties::WSRPDeleteResourceProperties "Arc::WSRPDeleteResourceProperties::WSRPDeleteResourceProperties(XMLNode
node, bool create) ";

%feature("docstring")
Arc::WSRPDeleteResourceProperties::WSRPDeleteResourceProperties "Arc::WSRPDeleteResourceProperties::WSRPDeleteResourceProperties(void)
";

%feature("docstring")
Arc::WSRPDeleteResourceProperties::~WSRPDeleteResourceProperties "virtual
Arc::WSRPDeleteResourceProperties::~WSRPDeleteResourceProperties(void)
";

%feature("docstring")  Arc::WSRPDeleteResourceProperties::Property "std::string Arc::WSRPDeleteResourceProperties::Property(void) ";

%feature("docstring")  Arc::WSRPDeleteResourceProperties::Property "void Arc::WSRPDeleteResourceProperties::Property(const std::string
&name) ";


// File: classArc_1_1WSRPDeleteResourcePropertiesRequest.xml
%feature("docstring") Arc::WSRPDeleteResourcePropertiesRequest "";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesRequest::WSRPDeleteResourcePropertiesRequest
"Arc::WSRPDeleteResourcePropertiesRequest::WSRPDeleteResourcePropertiesRequest(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesRequest::WSRPDeleteResourcePropertiesRequest
"Arc::WSRPDeleteResourcePropertiesRequest::WSRPDeleteResourcePropertiesRequest(const
std::string &name) ";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesRequest::WSRPDeleteResourcePropertiesRequest
"Arc::WSRPDeleteResourcePropertiesRequest::WSRPDeleteResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesRequest::~WSRPDeleteResourcePropertiesRequest
"Arc::WSRPDeleteResourcePropertiesRequest::~WSRPDeleteResourcePropertiesRequest(void)
";

%feature("docstring")  Arc::WSRPDeleteResourcePropertiesRequest::Name
"std::string Arc::WSRPDeleteResourcePropertiesRequest::Name(void) ";

%feature("docstring")  Arc::WSRPDeleteResourcePropertiesRequest::Name
"void Arc::WSRPDeleteResourcePropertiesRequest::Name(const
std::string &name) ";


// File: classArc_1_1WSRPDeleteResourcePropertiesRequestFailedFault.xml
%feature("docstring")
Arc::WSRPDeleteResourcePropertiesRequestFailedFault "";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesRequestFailedFault::WSRPDeleteResourcePropertiesRequestFailedFault
"Arc::WSRPDeleteResourcePropertiesRequestFailedFault::WSRPDeleteResourcePropertiesRequestFailedFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesRequestFailedFault::WSRPDeleteResourcePropertiesRequestFailedFault
"Arc::WSRPDeleteResourcePropertiesRequestFailedFault::WSRPDeleteResourcePropertiesRequestFailedFault(void)
";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesRequestFailedFault::~WSRPDeleteResourcePropertiesRequestFailedFault
"virtual
Arc::WSRPDeleteResourcePropertiesRequestFailedFault::~WSRPDeleteResourcePropertiesRequestFailedFault(void)
";


// File: classArc_1_1WSRPDeleteResourcePropertiesResponse.xml
%feature("docstring") Arc::WSRPDeleteResourcePropertiesResponse "";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesResponse::WSRPDeleteResourcePropertiesResponse
"Arc::WSRPDeleteResourcePropertiesResponse::WSRPDeleteResourcePropertiesResponse(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesResponse::WSRPDeleteResourcePropertiesResponse
"Arc::WSRPDeleteResourcePropertiesResponse::WSRPDeleteResourcePropertiesResponse(void)
";

%feature("docstring")
Arc::WSRPDeleteResourcePropertiesResponse::~WSRPDeleteResourcePropertiesResponse
"Arc::WSRPDeleteResourcePropertiesResponse::~WSRPDeleteResourcePropertiesResponse(void)
";


// File: classArc_1_1WSRPFault.xml
%feature("docstring") Arc::WSRPFault "

Base class for WS-ResourceProperties faults.

C++ includes: WSResourceProperties.h ";

%feature("docstring")  Arc::WSRPFault::WSRPFault "Arc::WSRPFault::WSRPFault(SOAPEnvelope &soap)

Constructor - creates object out of supplied SOAP tree. ";

%feature("docstring")  Arc::WSRPFault::WSRPFault "Arc::WSRPFault::WSRPFault(const std::string &type)

Constructor - creates new WSRP fault ";

%feature("docstring")  Arc::WSRPFault::~WSRPFault "virtual
Arc::WSRPFault::~WSRPFault(void) ";


// File: classArc_1_1WSRPGetMultipleResourcePropertiesRequest.xml
%feature("docstring") Arc::WSRPGetMultipleResourcePropertiesRequest "";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesRequest::WSRPGetMultipleResourcePropertiesRequest
"Arc::WSRPGetMultipleResourcePropertiesRequest::WSRPGetMultipleResourcePropertiesRequest(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesRequest::WSRPGetMultipleResourcePropertiesRequest
"Arc::WSRPGetMultipleResourcePropertiesRequest::WSRPGetMultipleResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesRequest::WSRPGetMultipleResourcePropertiesRequest
"Arc::WSRPGetMultipleResourcePropertiesRequest::WSRPGetMultipleResourcePropertiesRequest(const
std::vector< std::string > &names) ";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesRequest::~WSRPGetMultipleResourcePropertiesRequest
"Arc::WSRPGetMultipleResourcePropertiesRequest::~WSRPGetMultipleResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesRequest::Names "std::vector<std::string>
Arc::WSRPGetMultipleResourcePropertiesRequest::Names(void) ";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesRequest::Names "void
Arc::WSRPGetMultipleResourcePropertiesRequest::Names(const
std::vector< std::string > &names) ";


// File: classArc_1_1WSRPGetMultipleResourcePropertiesResponse.xml
%feature("docstring") Arc::WSRPGetMultipleResourcePropertiesResponse "";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesResponse::WSRPGetMultipleResourcePropertiesResponse
"Arc::WSRPGetMultipleResourcePropertiesResponse::WSRPGetMultipleResourcePropertiesResponse(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesResponse::WSRPGetMultipleResourcePropertiesResponse
"Arc::WSRPGetMultipleResourcePropertiesResponse::WSRPGetMultipleResourcePropertiesResponse(void)
";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesResponse::~WSRPGetMultipleResourcePropertiesResponse
"Arc::WSRPGetMultipleResourcePropertiesResponse::~WSRPGetMultipleResourcePropertiesResponse(void)
";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesResponse::Size "int
Arc::WSRPGetMultipleResourcePropertiesResponse::Size(void) ";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesResponse::Property "void
Arc::WSRPGetMultipleResourcePropertiesResponse::Property(const XMLNode
&prop, int pos=-1) ";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesResponse::Property "XMLNode
Arc::WSRPGetMultipleResourcePropertiesResponse::Property(int pos) ";

%feature("docstring")
Arc::WSRPGetMultipleResourcePropertiesResponse::Properties "XMLNode
Arc::WSRPGetMultipleResourcePropertiesResponse::Properties(void) ";


// File: classArc_1_1WSRPGetResourcePropertyDocumentRequest.xml
%feature("docstring") Arc::WSRPGetResourcePropertyDocumentRequest "";

%feature("docstring")
Arc::WSRPGetResourcePropertyDocumentRequest::WSRPGetResourcePropertyDocumentRequest
"Arc::WSRPGetResourcePropertyDocumentRequest::WSRPGetResourcePropertyDocumentRequest(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPGetResourcePropertyDocumentRequest::WSRPGetResourcePropertyDocumentRequest
"Arc::WSRPGetResourcePropertyDocumentRequest::WSRPGetResourcePropertyDocumentRequest(void)
";

%feature("docstring")
Arc::WSRPGetResourcePropertyDocumentRequest::~WSRPGetResourcePropertyDocumentRequest
"Arc::WSRPGetResourcePropertyDocumentRequest::~WSRPGetResourcePropertyDocumentRequest(void)
";


// File: classArc_1_1WSRPGetResourcePropertyDocumentResponse.xml
%feature("docstring") Arc::WSRPGetResourcePropertyDocumentResponse "";

%feature("docstring")
Arc::WSRPGetResourcePropertyDocumentResponse::WSRPGetResourcePropertyDocumentResponse
"Arc::WSRPGetResourcePropertyDocumentResponse::WSRPGetResourcePropertyDocumentResponse(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPGetResourcePropertyDocumentResponse::WSRPGetResourcePropertyDocumentResponse
"Arc::WSRPGetResourcePropertyDocumentResponse::WSRPGetResourcePropertyDocumentResponse(const
XMLNode &prop_doc=XMLNode()) ";

%feature("docstring")
Arc::WSRPGetResourcePropertyDocumentResponse::~WSRPGetResourcePropertyDocumentResponse
"Arc::WSRPGetResourcePropertyDocumentResponse::~WSRPGetResourcePropertyDocumentResponse(void)
";

%feature("docstring")
Arc::WSRPGetResourcePropertyDocumentResponse::Document "void
Arc::WSRPGetResourcePropertyDocumentResponse::Document(const XMLNode
&prop_doc) ";

%feature("docstring")
Arc::WSRPGetResourcePropertyDocumentResponse::Document "XMLNode
Arc::WSRPGetResourcePropertyDocumentResponse::Document(void) ";


// File: classArc_1_1WSRPGetResourcePropertyRequest.xml
%feature("docstring") Arc::WSRPGetResourcePropertyRequest "";

%feature("docstring")
Arc::WSRPGetResourcePropertyRequest::WSRPGetResourcePropertyRequest "Arc::WSRPGetResourcePropertyRequest::WSRPGetResourcePropertyRequest(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPGetResourcePropertyRequest::WSRPGetResourcePropertyRequest "Arc::WSRPGetResourcePropertyRequest::WSRPGetResourcePropertyRequest(const
std::string &name) ";

%feature("docstring")
Arc::WSRPGetResourcePropertyRequest::~WSRPGetResourcePropertyRequest "Arc::WSRPGetResourcePropertyRequest::~WSRPGetResourcePropertyRequest(void)
";

%feature("docstring")  Arc::WSRPGetResourcePropertyRequest::Name "std::string Arc::WSRPGetResourcePropertyRequest::Name(void) ";

%feature("docstring")  Arc::WSRPGetResourcePropertyRequest::Name "void Arc::WSRPGetResourcePropertyRequest::Name(const std::string
&name) ";


// File: classArc_1_1WSRPGetResourcePropertyResponse.xml
%feature("docstring") Arc::WSRPGetResourcePropertyResponse "";

%feature("docstring")
Arc::WSRPGetResourcePropertyResponse::WSRPGetResourcePropertyResponse
"Arc::WSRPGetResourcePropertyResponse::WSRPGetResourcePropertyResponse(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPGetResourcePropertyResponse::WSRPGetResourcePropertyResponse
"Arc::WSRPGetResourcePropertyResponse::WSRPGetResourcePropertyResponse(void)
";

%feature("docstring")
Arc::WSRPGetResourcePropertyResponse::~WSRPGetResourcePropertyResponse
"Arc::WSRPGetResourcePropertyResponse::~WSRPGetResourcePropertyResponse(void)
";

%feature("docstring")  Arc::WSRPGetResourcePropertyResponse::Size "int Arc::WSRPGetResourcePropertyResponse::Size(void) ";

%feature("docstring")  Arc::WSRPGetResourcePropertyResponse::Property
"void Arc::WSRPGetResourcePropertyResponse::Property(const XMLNode
&prop, int pos=-1) ";

%feature("docstring")  Arc::WSRPGetResourcePropertyResponse::Property
"XMLNode Arc::WSRPGetResourcePropertyResponse::Property(int pos) ";

%feature("docstring")
Arc::WSRPGetResourcePropertyResponse::Properties "XMLNode
Arc::WSRPGetResourcePropertyResponse::Properties(void) ";


// File: classArc_1_1WSRPInsertResourceProperties.xml
%feature("docstring") Arc::WSRPInsertResourceProperties "";

%feature("docstring")
Arc::WSRPInsertResourceProperties::WSRPInsertResourceProperties "Arc::WSRPInsertResourceProperties::WSRPInsertResourceProperties(XMLNode
node, bool create) ";

%feature("docstring")
Arc::WSRPInsertResourceProperties::WSRPInsertResourceProperties "Arc::WSRPInsertResourceProperties::WSRPInsertResourceProperties(void)
";

%feature("docstring")
Arc::WSRPInsertResourceProperties::~WSRPInsertResourceProperties "virtual
Arc::WSRPInsertResourceProperties::~WSRPInsertResourceProperties(void)
";

%feature("docstring")  Arc::WSRPInsertResourceProperties::Properties "XMLNode Arc::WSRPInsertResourceProperties::Properties(void) ";


// File: classArc_1_1WSRPInsertResourcePropertiesRequest.xml
%feature("docstring") Arc::WSRPInsertResourcePropertiesRequest "";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesRequest::WSRPInsertResourcePropertiesRequest
"Arc::WSRPInsertResourcePropertiesRequest::WSRPInsertResourcePropertiesRequest(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesRequest::WSRPInsertResourcePropertiesRequest
"Arc::WSRPInsertResourcePropertiesRequest::WSRPInsertResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesRequest::~WSRPInsertResourcePropertiesRequest
"Arc::WSRPInsertResourcePropertiesRequest::~WSRPInsertResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesRequest::Property "WSRPInsertResourceProperties
Arc::WSRPInsertResourcePropertiesRequest::Property(void) ";


// File: classArc_1_1WSRPInsertResourcePropertiesRequestFailedFault.xml
%feature("docstring")
Arc::WSRPInsertResourcePropertiesRequestFailedFault "";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesRequestFailedFault::WSRPInsertResourcePropertiesRequestFailedFault
"Arc::WSRPInsertResourcePropertiesRequestFailedFault::WSRPInsertResourcePropertiesRequestFailedFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesRequestFailedFault::WSRPInsertResourcePropertiesRequestFailedFault
"Arc::WSRPInsertResourcePropertiesRequestFailedFault::WSRPInsertResourcePropertiesRequestFailedFault(void)
";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesRequestFailedFault::~WSRPInsertResourcePropertiesRequestFailedFault
"virtual
Arc::WSRPInsertResourcePropertiesRequestFailedFault::~WSRPInsertResourcePropertiesRequestFailedFault(void)
";


// File: classArc_1_1WSRPInsertResourcePropertiesResponse.xml
%feature("docstring") Arc::WSRPInsertResourcePropertiesResponse "";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesResponse::WSRPInsertResourcePropertiesResponse
"Arc::WSRPInsertResourcePropertiesResponse::WSRPInsertResourcePropertiesResponse(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesResponse::WSRPInsertResourcePropertiesResponse
"Arc::WSRPInsertResourcePropertiesResponse::WSRPInsertResourcePropertiesResponse(void)
";

%feature("docstring")
Arc::WSRPInsertResourcePropertiesResponse::~WSRPInsertResourcePropertiesResponse
"Arc::WSRPInsertResourcePropertiesResponse::~WSRPInsertResourcePropertiesResponse(void)
";


// File: classArc_1_1WSRPInvalidModificationFault.xml
%feature("docstring") Arc::WSRPInvalidModificationFault "";

%feature("docstring")
Arc::WSRPInvalidModificationFault::WSRPInvalidModificationFault "Arc::WSRPInvalidModificationFault::WSRPInvalidModificationFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPInvalidModificationFault::WSRPInvalidModificationFault "Arc::WSRPInvalidModificationFault::WSRPInvalidModificationFault(void)
";

%feature("docstring")
Arc::WSRPInvalidModificationFault::~WSRPInvalidModificationFault "virtual
Arc::WSRPInvalidModificationFault::~WSRPInvalidModificationFault(void)
";


// File: classArc_1_1WSRPInvalidResourcePropertyQNameFault.xml
%feature("docstring") Arc::WSRPInvalidResourcePropertyQNameFault "";

%feature("docstring")
Arc::WSRPInvalidResourcePropertyQNameFault::WSRPInvalidResourcePropertyQNameFault
"Arc::WSRPInvalidResourcePropertyQNameFault::WSRPInvalidResourcePropertyQNameFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPInvalidResourcePropertyQNameFault::WSRPInvalidResourcePropertyQNameFault
"Arc::WSRPInvalidResourcePropertyQNameFault::WSRPInvalidResourcePropertyQNameFault(void)
";

%feature("docstring")
Arc::WSRPInvalidResourcePropertyQNameFault::~WSRPInvalidResourcePropertyQNameFault
"virtual
Arc::WSRPInvalidResourcePropertyQNameFault::~WSRPInvalidResourcePropertyQNameFault(void)
";


// File: classArc_1_1WSRPModifyResourceProperties.xml
%feature("docstring") Arc::WSRPModifyResourceProperties "";

%feature("docstring")
Arc::WSRPModifyResourceProperties::WSRPModifyResourceProperties "Arc::WSRPModifyResourceProperties::WSRPModifyResourceProperties(XMLNode
&node, bool create, const std::string &name=\"\") ";

%feature("docstring")
Arc::WSRPModifyResourceProperties::WSRPModifyResourceProperties "Arc::WSRPModifyResourceProperties::WSRPModifyResourceProperties(void)
";

%feature("docstring")
Arc::WSRPModifyResourceProperties::~WSRPModifyResourceProperties "virtual
Arc::WSRPModifyResourceProperties::~WSRPModifyResourceProperties(void)
";


// File: classArc_1_1WSRPPutResourcePropertyDocumentRequest.xml
%feature("docstring") Arc::WSRPPutResourcePropertyDocumentRequest "";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentRequest::WSRPPutResourcePropertyDocumentRequest
"Arc::WSRPPutResourcePropertyDocumentRequest::WSRPPutResourcePropertyDocumentRequest(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentRequest::WSRPPutResourcePropertyDocumentRequest
"Arc::WSRPPutResourcePropertyDocumentRequest::WSRPPutResourcePropertyDocumentRequest(const
XMLNode &prop_doc=XMLNode()) ";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentRequest::~WSRPPutResourcePropertyDocumentRequest
"Arc::WSRPPutResourcePropertyDocumentRequest::~WSRPPutResourcePropertyDocumentRequest(void)
";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentRequest::Document "void
Arc::WSRPPutResourcePropertyDocumentRequest::Document(const XMLNode
&prop_doc) ";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentRequest::Document "XMLNode
Arc::WSRPPutResourcePropertyDocumentRequest::Document(void) ";


// File: classArc_1_1WSRPPutResourcePropertyDocumentResponse.xml
%feature("docstring") Arc::WSRPPutResourcePropertyDocumentResponse "";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentResponse::WSRPPutResourcePropertyDocumentResponse
"Arc::WSRPPutResourcePropertyDocumentResponse::WSRPPutResourcePropertyDocumentResponse(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentResponse::WSRPPutResourcePropertyDocumentResponse
"Arc::WSRPPutResourcePropertyDocumentResponse::WSRPPutResourcePropertyDocumentResponse(const
XMLNode &prop_doc=XMLNode()) ";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentResponse::~WSRPPutResourcePropertyDocumentResponse
"Arc::WSRPPutResourcePropertyDocumentResponse::~WSRPPutResourcePropertyDocumentResponse(void)
";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentResponse::Document "void
Arc::WSRPPutResourcePropertyDocumentResponse::Document(const XMLNode
&prop_doc) ";

%feature("docstring")
Arc::WSRPPutResourcePropertyDocumentResponse::Document "XMLNode
Arc::WSRPPutResourcePropertyDocumentResponse::Document(void) ";


// File: classArc_1_1WSRPQueryResourcePropertiesRequest.xml
%feature("docstring") Arc::WSRPQueryResourcePropertiesRequest "";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesRequest::WSRPQueryResourcePropertiesRequest
"Arc::WSRPQueryResourcePropertiesRequest::WSRPQueryResourcePropertiesRequest(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesRequest::WSRPQueryResourcePropertiesRequest
"Arc::WSRPQueryResourcePropertiesRequest::WSRPQueryResourcePropertiesRequest(const
std::string &dialect) ";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesRequest::WSRPQueryResourcePropertiesRequest
"Arc::WSRPQueryResourcePropertiesRequest::WSRPQueryResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesRequest::~WSRPQueryResourcePropertiesRequest
"Arc::WSRPQueryResourcePropertiesRequest::~WSRPQueryResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesRequest::Dialect "std::string
Arc::WSRPQueryResourcePropertiesRequest::Dialect(void) ";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesRequest::Dialect "void
Arc::WSRPQueryResourcePropertiesRequest::Dialect(const std::string
&dialect) ";

%feature("docstring")  Arc::WSRPQueryResourcePropertiesRequest::Query
"XMLNode Arc::WSRPQueryResourcePropertiesRequest::Query(void) ";


// File: classArc_1_1WSRPQueryResourcePropertiesResponse.xml
%feature("docstring") Arc::WSRPQueryResourcePropertiesResponse "";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesResponse::WSRPQueryResourcePropertiesResponse
"Arc::WSRPQueryResourcePropertiesResponse::WSRPQueryResourcePropertiesResponse(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesResponse::WSRPQueryResourcePropertiesResponse
"Arc::WSRPQueryResourcePropertiesResponse::WSRPQueryResourcePropertiesResponse(void)
";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesResponse::~WSRPQueryResourcePropertiesResponse
"Arc::WSRPQueryResourcePropertiesResponse::~WSRPQueryResourcePropertiesResponse(void)
";

%feature("docstring")
Arc::WSRPQueryResourcePropertiesResponse::Properties "XMLNode
Arc::WSRPQueryResourcePropertiesResponse::Properties(void) ";


// File: classArc_1_1WSRPResourcePropertyChangeFailure.xml
%feature("docstring") Arc::WSRPResourcePropertyChangeFailure "

Base class for WS-ResourceProperties faults which contain
ResourcePropertyChangeFailure

C++ includes: WSResourceProperties.h ";

%feature("docstring")
Arc::WSRPResourcePropertyChangeFailure::WSRPResourcePropertyChangeFailure
"Arc::WSRPResourcePropertyChangeFailure::WSRPResourcePropertyChangeFailure(SOAPEnvelope
&soap)

Constructor - creates object out of supplied SOAP tree. ";

%feature("docstring")
Arc::WSRPResourcePropertyChangeFailure::WSRPResourcePropertyChangeFailure
"Arc::WSRPResourcePropertyChangeFailure::WSRPResourcePropertyChangeFailure(const
std::string &type)

Constructor - creates new WSRP fault ";

%feature("docstring")
Arc::WSRPResourcePropertyChangeFailure::~WSRPResourcePropertyChangeFailure
"virtual
Arc::WSRPResourcePropertyChangeFailure::~WSRPResourcePropertyChangeFailure(void)
";

%feature("docstring")
Arc::WSRPResourcePropertyChangeFailure::CurrentProperties "XMLNode
Arc::WSRPResourcePropertyChangeFailure::CurrentProperties(bool
create=false) ";

%feature("docstring")
Arc::WSRPResourcePropertyChangeFailure::RequestedProperties "XMLNode
Arc::WSRPResourcePropertyChangeFailure::RequestedProperties(bool
create=false) ";


// File: classArc_1_1WSRPSetResourcePropertiesRequest.xml
%feature("docstring") Arc::WSRPSetResourcePropertiesRequest "";

%feature("docstring")
Arc::WSRPSetResourcePropertiesRequest::WSRPSetResourcePropertiesRequest
"Arc::WSRPSetResourcePropertiesRequest::WSRPSetResourcePropertiesRequest(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPSetResourcePropertiesRequest::WSRPSetResourcePropertiesRequest
"Arc::WSRPSetResourcePropertiesRequest::WSRPSetResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPSetResourcePropertiesRequest::~WSRPSetResourcePropertiesRequest
"Arc::WSRPSetResourcePropertiesRequest::~WSRPSetResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPSetResourcePropertiesRequest::Properties "XMLNode
Arc::WSRPSetResourcePropertiesRequest::Properties(void) ";


// File: classArc_1_1WSRPSetResourcePropertiesResponse.xml
%feature("docstring") Arc::WSRPSetResourcePropertiesResponse "";

%feature("docstring")
Arc::WSRPSetResourcePropertiesResponse::WSRPSetResourcePropertiesResponse
"Arc::WSRPSetResourcePropertiesResponse::WSRPSetResourcePropertiesResponse(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPSetResourcePropertiesResponse::WSRPSetResourcePropertiesResponse
"Arc::WSRPSetResourcePropertiesResponse::WSRPSetResourcePropertiesResponse(void)
";

%feature("docstring")
Arc::WSRPSetResourcePropertiesResponse::~WSRPSetResourcePropertiesResponse
"Arc::WSRPSetResourcePropertiesResponse::~WSRPSetResourcePropertiesResponse(void)
";


// File: classArc_1_1WSRPSetResourcePropertyRequestFailedFault.xml
%feature("docstring") Arc::WSRPSetResourcePropertyRequestFailedFault "";

%feature("docstring")
Arc::WSRPSetResourcePropertyRequestFailedFault::WSRPSetResourcePropertyRequestFailedFault
"Arc::WSRPSetResourcePropertyRequestFailedFault::WSRPSetResourcePropertyRequestFailedFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPSetResourcePropertyRequestFailedFault::WSRPSetResourcePropertyRequestFailedFault
"Arc::WSRPSetResourcePropertyRequestFailedFault::WSRPSetResourcePropertyRequestFailedFault(void)
";

%feature("docstring")
Arc::WSRPSetResourcePropertyRequestFailedFault::~WSRPSetResourcePropertyRequestFailedFault
"virtual
Arc::WSRPSetResourcePropertyRequestFailedFault::~WSRPSetResourcePropertyRequestFailedFault(void)
";


// File: classArc_1_1WSRPUnableToModifyResourcePropertyFault.xml
%feature("docstring") Arc::WSRPUnableToModifyResourcePropertyFault "";

%feature("docstring")
Arc::WSRPUnableToModifyResourcePropertyFault::WSRPUnableToModifyResourcePropertyFault
"Arc::WSRPUnableToModifyResourcePropertyFault::WSRPUnableToModifyResourcePropertyFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPUnableToModifyResourcePropertyFault::WSRPUnableToModifyResourcePropertyFault
"Arc::WSRPUnableToModifyResourcePropertyFault::WSRPUnableToModifyResourcePropertyFault(void)
";

%feature("docstring")
Arc::WSRPUnableToModifyResourcePropertyFault::~WSRPUnableToModifyResourcePropertyFault
"virtual
Arc::WSRPUnableToModifyResourcePropertyFault::~WSRPUnableToModifyResourcePropertyFault(void)
";


// File: classArc_1_1WSRPUnableToPutResourcePropertyDocumentFault.xml
%feature("docstring")
Arc::WSRPUnableToPutResourcePropertyDocumentFault "";

%feature("docstring")
Arc::WSRPUnableToPutResourcePropertyDocumentFault::WSRPUnableToPutResourcePropertyDocumentFault
"Arc::WSRPUnableToPutResourcePropertyDocumentFault::WSRPUnableToPutResourcePropertyDocumentFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPUnableToPutResourcePropertyDocumentFault::WSRPUnableToPutResourcePropertyDocumentFault
"Arc::WSRPUnableToPutResourcePropertyDocumentFault::WSRPUnableToPutResourcePropertyDocumentFault(void)
";

%feature("docstring")
Arc::WSRPUnableToPutResourcePropertyDocumentFault::~WSRPUnableToPutResourcePropertyDocumentFault
"virtual
Arc::WSRPUnableToPutResourcePropertyDocumentFault::~WSRPUnableToPutResourcePropertyDocumentFault(void)
";


// File: classArc_1_1WSRPUpdateResourceProperties.xml
%feature("docstring") Arc::WSRPUpdateResourceProperties "";

%feature("docstring")
Arc::WSRPUpdateResourceProperties::WSRPUpdateResourceProperties "Arc::WSRPUpdateResourceProperties::WSRPUpdateResourceProperties(XMLNode
node, bool create) ";

%feature("docstring")
Arc::WSRPUpdateResourceProperties::WSRPUpdateResourceProperties "Arc::WSRPUpdateResourceProperties::WSRPUpdateResourceProperties(void)
";

%feature("docstring")
Arc::WSRPUpdateResourceProperties::~WSRPUpdateResourceProperties "virtual
Arc::WSRPUpdateResourceProperties::~WSRPUpdateResourceProperties(void)
";

%feature("docstring")  Arc::WSRPUpdateResourceProperties::Properties "XMLNode Arc::WSRPUpdateResourceProperties::Properties(void) ";


// File: classArc_1_1WSRPUpdateResourcePropertiesRequest.xml
%feature("docstring") Arc::WSRPUpdateResourcePropertiesRequest "";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesRequest::WSRPUpdateResourcePropertiesRequest
"Arc::WSRPUpdateResourcePropertiesRequest::WSRPUpdateResourcePropertiesRequest(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesRequest::WSRPUpdateResourcePropertiesRequest
"Arc::WSRPUpdateResourcePropertiesRequest::WSRPUpdateResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesRequest::~WSRPUpdateResourcePropertiesRequest
"Arc::WSRPUpdateResourcePropertiesRequest::~WSRPUpdateResourcePropertiesRequest(void)
";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesRequest::Property "WSRPUpdateResourceProperties
Arc::WSRPUpdateResourcePropertiesRequest::Property(void) ";


// File: classArc_1_1WSRPUpdateResourcePropertiesRequestFailedFault.xml
%feature("docstring")
Arc::WSRPUpdateResourcePropertiesRequestFailedFault "";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesRequestFailedFault::WSRPUpdateResourcePropertiesRequestFailedFault
"Arc::WSRPUpdateResourcePropertiesRequestFailedFault::WSRPUpdateResourcePropertiesRequestFailedFault(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesRequestFailedFault::WSRPUpdateResourcePropertiesRequestFailedFault
"Arc::WSRPUpdateResourcePropertiesRequestFailedFault::WSRPUpdateResourcePropertiesRequestFailedFault(void)
";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesRequestFailedFault::~WSRPUpdateResourcePropertiesRequestFailedFault
"virtual
Arc::WSRPUpdateResourcePropertiesRequestFailedFault::~WSRPUpdateResourcePropertiesRequestFailedFault(void)
";


// File: classArc_1_1WSRPUpdateResourcePropertiesResponse.xml
%feature("docstring") Arc::WSRPUpdateResourcePropertiesResponse "";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesResponse::WSRPUpdateResourcePropertiesResponse
"Arc::WSRPUpdateResourcePropertiesResponse::WSRPUpdateResourcePropertiesResponse(SOAPEnvelope
&soap) ";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesResponse::WSRPUpdateResourcePropertiesResponse
"Arc::WSRPUpdateResourcePropertiesResponse::WSRPUpdateResourcePropertiesResponse(void)
";

%feature("docstring")
Arc::WSRPUpdateResourcePropertiesResponse::~WSRPUpdateResourcePropertiesResponse
"Arc::WSRPUpdateResourcePropertiesResponse::~WSRPUpdateResourcePropertiesResponse(void)
";


// File: classArcSec_1_1X500NameAttribute.xml
%feature("docstring") ArcSec::X500NameAttribute "";

%feature("docstring")  ArcSec::X500NameAttribute::X500NameAttribute "ArcSec::X500NameAttribute::X500NameAttribute() ";

%feature("docstring")  ArcSec::X500NameAttribute::X500NameAttribute "ArcSec::X500NameAttribute::X500NameAttribute(std::string v,
std::string i) ";

%feature("docstring")  ArcSec::X500NameAttribute::~X500NameAttribute "virtual ArcSec::X500NameAttribute::~X500NameAttribute() ";

%feature("docstring")  ArcSec::X500NameAttribute::equal "virtual bool
ArcSec::X500NameAttribute::equal(AttributeValue *other, bool
check_id=true)

Evluate whether \"this\" equale to the parameter value ";

%feature("docstring")  ArcSec::X500NameAttribute::encode "virtual
std::string ArcSec::X500NameAttribute::encode()

encode the value in a string format ";

%feature("docstring")  ArcSec::X500NameAttribute::getValue "std::string ArcSec::X500NameAttribute::getValue() ";

%feature("docstring")  ArcSec::X500NameAttribute::getType "virtual
std::string ArcSec::X500NameAttribute::getType()

Get the DataType of the <Attribute> ";

%feature("docstring")  ArcSec::X500NameAttribute::getId "virtual
std::string ArcSec::X500NameAttribute::getId()

Get the AttributeId of the <Attribute> ";


// File: classArc_1_1X509Token.xml
%feature("docstring") Arc::X509Token "

Class for manipulating X.509 Token Profile.

This class is for generating/consuming X.509 Token profile. Currently
it is used by x509token handler (src/hed/pdc/x509tokensh/) It is not
necessary to directly called this class. If we need to use X.509 Token
functionality, we only need to configure the x509token handler into
service and client.

C++ includes: X509Token.h ";

%feature("docstring")  Arc::X509Token::X509Token "Arc::X509Token::X509Token(SOAPEnvelope &soap, const std::string
&keyfile=\"\")

Constructor.Parse X509 Token information from SOAP header. X509 Token
related information is extracted from SOAP header and stored in class
variables. And then it the X509Token object will be used for
authentication if the tokentype is Signature; otherwise if the
tokentype is Encryption, the encrypted soap body will be decrypted and
replaced by decrypted message. keyfile is only needed when the
X509Token is encryption token ";

%feature("docstring")  Arc::X509Token::X509Token "Arc::X509Token::X509Token(SOAPEnvelope &soap, const std::string
&certfile, const std::string &keyfile, X509TokenType
token_type=Signature)

Constructor. Add X509 Token information into the SOAP header.
Generated token contains elements X509 token and signature, and is
meant to be used for authentication on the consuming side.

Parameters:
-----------

soap:  The SOAP message to which the X509 Token will be inserted

certfile:  The certificate file which will be used to encrypt the SOAP
body (if parameter tokentype is Encryption), or be used as
<wsse:BinarySecurityToken/> (if parameter tokentype is Signature).

keyfile:  The key file which will be used to create signature. Not
needed when create encryption.

tokentype:  Token type: Signature or Encryption. ";

%feature("docstring")  Arc::X509Token::~X509Token "Arc::X509Token::~X509Token(void)

Deconstructor. Nothing to be done except finalizing the xmlsec
library. ";

%feature("docstring")  Arc::X509Token::Authenticate "bool
Arc::X509Token::Authenticate(const std::string &cafile, const
std::string &capath)

Check signature by using the certificare information in X509Token
which is parsed by the constructor, and the trusted certificates
specified as one of the two parameters. Not only the signature (in the
X509Token) itself is checked, but also the certificate which is
supposed to check the signature needs to be trused (which means the
certificate is issued by the ca certificate from CA file or CA
directory). At least one the the two parameters should be set.

Parameters:
-----------

cafile:  The CA file

capath:  The CA directory

true if authentication passes; otherwise false ";

%feature("docstring")  Arc::X509Token::Authenticate "bool
Arc::X509Token::Authenticate(void)

Check signature by using the cert information in soap message. Only
the signature itself is checked, and it is not guranteed that the
certificate which is supposed to check the signature is trusted. ";


// File: classArc_1_1XmlContainer.xml
%feature("docstring") Arc::XmlContainer "";

%feature("docstring")  Arc::XmlContainer::XmlContainer "Arc::XmlContainer::XmlContainer(const std::string &db_path, const
std::string &db_name) ";

%feature("docstring")  Arc::XmlContainer::~XmlContainer "Arc::XmlContainer::~XmlContainer() ";

%feature("docstring")  Arc::XmlContainer::put "bool
Arc::XmlContainer::put(const std::string &name, const std::string
&content) ";

%feature("docstring")  Arc::XmlContainer::get "std::string
Arc::XmlContainer::get(const std::string &name) ";

%feature("docstring")  Arc::XmlContainer::del "void
Arc::XmlContainer::del(const std::string &name) ";

%feature("docstring")  Arc::XmlContainer::get_doc_names "std::vector<std::string> Arc::XmlContainer::get_doc_names() ";

%feature("docstring")  Arc::XmlContainer::start_update "void
Arc::XmlContainer::start_update() ";

%feature("docstring")  Arc::XmlContainer::end_update "void
Arc::XmlContainer::end_update() ";

%feature("docstring")  Arc::XmlContainer::checkpoint "void
Arc::XmlContainer::checkpoint() ";


// File: classArc_1_1XmlDatabase.xml
%feature("docstring") Arc::XmlDatabase "";

%feature("docstring")  Arc::XmlDatabase::XmlDatabase "Arc::XmlDatabase::XmlDatabase() ";

%feature("docstring")  Arc::XmlDatabase::XmlDatabase "Arc::XmlDatabase::XmlDatabase(const std::string &db_path, const
std::string &db_name) ";

%feature("docstring")  Arc::XmlDatabase::~XmlDatabase "Arc::XmlDatabase::~XmlDatabase() ";

%feature("docstring")  Arc::XmlDatabase::put "void
Arc::XmlDatabase::put(const std::string &name, const std::string
&content) ";

%feature("docstring")  Arc::XmlDatabase::put "void
Arc::XmlDatabase::put(const std::string &name, Arc::XMLNode &doc) ";

%feature("docstring")  Arc::XmlDatabase::get "void
Arc::XmlDatabase::get(const std::string &name, Arc::XMLNode &doc) ";

%feature("docstring")  Arc::XmlDatabase::del "void
Arc::XmlDatabase::del(const std::string &name) ";

%feature("docstring")  Arc::XmlDatabase::query "Arc::XMLNodeList
Arc::XmlDatabase::query(const std::string &name, const std::string &q)
";

%feature("docstring")  Arc::XmlDatabase::queryAll "void
Arc::XmlDatabase::queryAll(const std::string &q, std::map<
std::string, Arc::XMLNodeList > &result) ";

%feature("docstring")  Arc::XmlDatabase::update "void
Arc::XmlDatabase::update(const std::string &name, const std::string
&query, Arc::XMLNode &new_value) ";

%feature("docstring")  Arc::XmlDatabase::checkpoint "void
Arc::XmlDatabase::checkpoint() ";


// File: classArc_1_1XMLNode.xml
%feature("docstring") Arc::XMLNode "

Wrapper for LibXML library Tree interface.

This class wraps XML Node, Document and Property/Attribute structures.
Each instance serves as pointer to actual LibXML element and provides
convenient (for chosen purpose) methods for manipulating it. This
class has no special ties to LibXML library and may be easily
rewritten for any XML parser which provides interface similar to
LibXML Tree. It implements only small subset of XML capabilities,
which is probably enough for performing most of useful actions. This
class also filters out (usually) useless textual nodes which are often
used to make XML documents human-readable.

C++ includes: XMLNode.h ";

%feature("docstring")  Arc::XMLNode::XMLNode "Arc::XMLNode::XMLNode(void)

Constructor of invalid node Created instance does not point to XML
element. All methods are still allowed for such instance but produce
no results. ";

%feature("docstring")  Arc::XMLNode::XMLNode "Arc::XMLNode::XMLNode(const XMLNode &node)

Copies existing instance. Underlying XML element is NOT copied.
Ownership is NOT inherited. Strictly speaking it shuld be no const
here - but that conflicts with C++. ";

%feature("docstring")  Arc::XMLNode::XMLNode "Arc::XMLNode::XMLNode(const std::string &xml)

Creates XML document structure from textual representation of XML
document. Created structure is pointed and owned by constructed
instance ";

%feature("docstring")  Arc::XMLNode::XMLNode "Arc::XMLNode::XMLNode(const char *xml, int len=-1)

Same as previous ";

%feature("docstring")  Arc::XMLNode::XMLNode "Arc::XMLNode::XMLNode(long ptr_addr)

Copy constructor. Used by language bindigs ";

%feature("docstring")  Arc::XMLNode::XMLNode "Arc::XMLNode::XMLNode(const NS &ns, const char *name)

Creates empty XML document structure with specified namespaces.
Created XML contains only root element named 'name'. Created structure
is pointed and owned by constructed instance ";

%feature("docstring")  Arc::XMLNode::~XMLNode "Arc::XMLNode::~XMLNode(void)

Destructor Also destroys underlying XML document if owned by this
instance ";

%feature("docstring")  Arc::XMLNode::New "void
Arc::XMLNode::New(XMLNode &node) const

Creates a copy of XML (sub)tree. If object does not represent whole
document - top level document is created. 'new_node' becomes a pointer
owning new XML document. ";

%feature("docstring")  Arc::XMLNode::Exchange "void
Arc::XMLNode::Exchange(XMLNode &node)

Exchanges XML (sub)trees. Following conbinations are possible If
either this ir node are refering owned XML tree (top level node) then
references are simply excanged. This opearationis fast. If both this
and node are refering to XML (sub)tree of different documents then
(sub)trees are exchahed between documments. If both this and node are
refering to XML (sub)tree of same document then (sub)trees are moved
inside document. The main reason for this method is to provide
effective way to insert one XML document inside another. One should
take into account that if any of exchanged nodes is top level it must
be also owner of document. Otherwise method will fail. If both nodes
are top level owners and/or invlaid nodes then this method is
identical to Swap(). ";

%feature("docstring")  Arc::XMLNode::Move "void
Arc::XMLNode::Move(XMLNode &node)

Moves content of this XML (sub)tree to node This opeartion is similar
to New except that XML (sub)tree to refered by this is destroyed. This
method is more effective than combination of New() and Destroy()
because internally it is optimized not to copy data if not needed. The
main purpose of this is to effectively extract part of XML document.
";

%feature("docstring")  Arc::XMLNode::Swap "void
Arc::XMLNode::Swap(XMLNode &node)

Swaps XML (sub)trees to this this and node refer. For XML subtrees
this method is not anyhow different then using combinaiion XMLNode
tmp=*this; *this=node; node=tmp; But in case of either this or node
owning XML document ownership is swapped too. And this is a main
purpose of Swap() method. ";

%feature("docstring")  Arc::XMLNode::Same "bool
Arc::XMLNode::Same(const XMLNode &node)

Returns true if 'node' represents same XML element - for bindings ";

%feature("docstring")  Arc::XMLNode::Child "XMLNode
Arc::XMLNode::Child(int n=0)

Returns XMLNode instance representing n-th child of XML element. If
such does not exist invalid XMLNode instance is returned ";

%feature("docstring")  Arc::XMLNode::Size "int
Arc::XMLNode::Size(void) const

Returns number of children nodes ";

%feature("docstring")  Arc::XMLNode::Get "XMLNode
Arc::XMLNode::Get(const std::string &name) const

Same as operator[] ";

%feature("docstring")  Arc::XMLNode::Name "std::string
Arc::XMLNode::Name(void) const

Returns name of XML node ";

%feature("docstring")  Arc::XMLNode::Prefix "std::string
Arc::XMLNode::Prefix(void) const

Returns namespace prefix of XML node ";

%feature("docstring")  Arc::XMLNode::FullName "std::string
Arc::XMLNode::FullName(void) const

Returns prefix:name of XML node ";

%feature("docstring")  Arc::XMLNode::Namespace "std::string
Arc::XMLNode::Namespace(void) const

Returns namespace URI of XML node ";

%feature("docstring")  Arc::XMLNode::Name "void
Arc::XMLNode::Name(const char *name)

Assigns new name to XML node ";

%feature("docstring")  Arc::XMLNode::Name "void
Arc::XMLNode::Name(const std::string &name)

Assigns new name to XML node ";

%feature("docstring")  Arc::XMLNode::GetXML "void
Arc::XMLNode::GetXML(std::string &out_xml_str, bool
user_friendly=false) const

Fills argument with this instance XML subtree textual representation
";

%feature("docstring")  Arc::XMLNode::GetXML "void
Arc::XMLNode::GetXML(std::string &out_xml_str, const std::string
&encoding, bool user_friendly=false) const

Fills argument with this instance XML subtree textual representation
if the XML subtree is corresponding to the encoding format specified
in the argument, e.g. utf-8 ";

%feature("docstring")  Arc::XMLNode::GetDoc "void
Arc::XMLNode::GetDoc(std::string &out_xml_str, bool
user_friendly=false) const

Fills argument with whole XML document textual representation ";

%feature("docstring")  Arc::XMLNode::Set "void
Arc::XMLNode::Set(const std::string &content)

Same as operator=. Used for bindings. ";

%feature("docstring")  Arc::XMLNode::Attribute "XMLNode
Arc::XMLNode::Attribute(int n=0)

Returns list of all attributes of node.

Returns XMLNode instance reresenting n-th attribute of node. ";

%feature("docstring")  Arc::XMLNode::Attribute "XMLNode
Arc::XMLNode::Attribute(const char *name)

Returns XMLNode instance representing first attribute of node with
specified by name ";

%feature("docstring")  Arc::XMLNode::Attribute "XMLNode
Arc::XMLNode::Attribute(const std::string &name)

Returns XMLNode instance representing first attribute of node with
specified by name ";

%feature("docstring")  Arc::XMLNode::NewAttribute "XMLNode
Arc::XMLNode::NewAttribute(const char *name)

Creates new attribute with specified name. ";

%feature("docstring")  Arc::XMLNode::NewAttribute "XMLNode
Arc::XMLNode::NewAttribute(const std::string &name)

Creates new attribute with specified name. ";

%feature("docstring")  Arc::XMLNode::AttributesSize "int
Arc::XMLNode::AttributesSize(void) const

Returns number of attributes of node ";

%feature("docstring")  Arc::XMLNode::Namespaces "void
Arc::XMLNode::Namespaces(const NS &namespaces, bool keep=false, int
recursion=-1)

Assigns namespaces of XML document at point specified by this
instance. If namespace already exists it gets new prefix. New
namespaces are added. It is useful to apply this method to XML being
processed in order to refer to it's elements by known prefix. If keep
is set to false existing namespace definition residing at this
instance and below are removed (default beavior). If recursion is set
to positive number then depth of prefix replacement is limited by this
number (0 limits it to this node only). For unlimted recursion use -1.
If recursion is limited then value of keep is ignored and existing
namespaces are always kept. ";

%feature("docstring")  Arc::XMLNode::Namespaces "NS
Arc::XMLNode::Namespaces(void)

Returns namespaces known at this node ";

%feature("docstring")  Arc::XMLNode::NamespacePrefix "std::string
Arc::XMLNode::NamespacePrefix(const char *urn)

Returns prefix of specified namespace. Empty string if no such
namespace. ";

%feature("docstring")  Arc::XMLNode::NewChild "XMLNode
Arc::XMLNode::NewChild(const char *name, int n=-1, bool
global_order=false)

Creates new child XML element at specified position with specified
name. Default is to put it at end of list. If global order is true
position applies to whole set of children, otherwise only to children
of same name. Returns created node. ";

%feature("docstring")  Arc::XMLNode::NewChild "XMLNode
Arc::XMLNode::NewChild(const std::string &name, int n=-1, bool
global_order=false)

Same as NewChild(const char*,int,bool) ";

%feature("docstring")  Arc::XMLNode::NewChild "XMLNode
Arc::XMLNode::NewChild(const char *name, const NS &namespaces, int
n=-1, bool global_order=false)

Creates new child XML element at specified position with specified
name and namespaces. For more information look at NewChild(const
char*,int,bool) ";

%feature("docstring")  Arc::XMLNode::NewChild "XMLNode
Arc::XMLNode::NewChild(const std::string &name, const NS &namespaces,
int n=-1, bool global_order=false)

Same as NewChild(const char*,const NS&,int,bool) ";

%feature("docstring")  Arc::XMLNode::NewChild "XMLNode
Arc::XMLNode::NewChild(const XMLNode &node, int n=-1, bool
global_order=false)

Link a copy of supplied XML node as child. Returns instance refering
to new child. XML element is a copy of supplied one but not owned by
returned instance ";

%feature("docstring")  Arc::XMLNode::Replace "void
Arc::XMLNode::Replace(const XMLNode &node)

Makes a copy of supplied XML node and makes this instance refere to it
";

%feature("docstring")  Arc::XMLNode::Destroy "void
Arc::XMLNode::Destroy(void)

Destroys underlying XML element. XML element is unlinked from XML tree
and destroyed. After this operation XMLNode instance becomes invalid
";

%feature("docstring")  Arc::XMLNode::Path "XMLNodeList
Arc::XMLNode::Path(const std::string &path)

Collects nodes corresponding to specified path. This is a convenience
function to cover common use of XPath but without performance hit.
Path is made of node_name[/node_name[...]] and is relative to current
node. node_names are treated in same way as in operator[]. Returns all
nodes which are represented by path. ";

%feature("docstring")  Arc::XMLNode::XPathLookup "XMLNodeList
Arc::XMLNode::XPathLookup(const std::string &xpathExpr, const NS
&nsList)

Uses xPath to look up the whole xml structure, Returns a list of
XMLNode points. The xpathExpr should be like \"//xx:child1/\" which
indicates the namespace and node that you would like to find; The
nsList is the namespace the result should belong to (e.g.
xx=\"uri:test\"). Query is run on whole XML document but only the
elements belonging to this XML subtree are returned. ";

%feature("docstring")  Arc::XMLNode::GetRoot "XMLNode
Arc::XMLNode::GetRoot(void)

Get the root node from any child node of the tree ";

%feature("docstring")  Arc::XMLNode::Parent "XMLNode
Arc::XMLNode::Parent(void)

Get the parent node from any child node of the tree ";

%feature("docstring")  Arc::XMLNode::SaveToFile "bool
Arc::XMLNode::SaveToFile(const std::string &file_name) const

Save string representation of node to file ";

%feature("docstring")  Arc::XMLNode::SaveToStream "bool
Arc::XMLNode::SaveToStream(std::ostream &out) const

Save string representation of node to stream ";

%feature("docstring")  Arc::XMLNode::ReadFromFile "bool
Arc::XMLNode::ReadFromFile(const std::string &file_name)

Read XML document from file and associate it with this node ";

%feature("docstring")  Arc::XMLNode::ReadFromStream "bool
Arc::XMLNode::ReadFromStream(std::istream &in)

Read XML document from stream and associate it with this node ";

%feature("docstring")  Arc::XMLNode::Validate "bool
Arc::XMLNode::Validate(const std::string &schema_file, std::string
&err_msg)

Remove all eye-candy information leaving only informational parts *
void Purify(void); XML schema validation against the schema file
defined as argument ";


// File: classArc_1_1XMLNodeContainer.xml
%feature("docstring") Arc::XMLNodeContainer "

Container for multiple XMLNode elements

C++ includes: XMLNode.h ";

%feature("docstring")  Arc::XMLNodeContainer::XMLNodeContainer "Arc::XMLNodeContainer::XMLNodeContainer(void)

Default constructor ";

%feature("docstring")  Arc::XMLNodeContainer::XMLNodeContainer "Arc::XMLNodeContainer::XMLNodeContainer(const XMLNodeContainer &)

Copy constructor. Add nodes from argument. Nodes owning XML document
are copied using AddNew(). Not owning nodes are linked using Add()
method. ";

%feature("docstring")  Arc::XMLNodeContainer::~XMLNodeContainer "Arc::XMLNodeContainer::~XMLNodeContainer(void) ";

%feature("docstring")  Arc::XMLNodeContainer::Add "void
Arc::XMLNodeContainer::Add(const XMLNode &)

Link XML subtree refered by node to container. XML tree must be
available as long as this object is used. ";

%feature("docstring")  Arc::XMLNodeContainer::Add "void
Arc::XMLNodeContainer::Add(const std::list< XMLNode > &)

Link multiple XML subtrees to container. ";

%feature("docstring")  Arc::XMLNodeContainer::AddNew "void
Arc::XMLNodeContainer::AddNew(const XMLNode &)

Copy XML subtree referenced by node to container. After this operation
container refers to independent XML document. This document is deleted
when container is destroyed. ";

%feature("docstring")  Arc::XMLNodeContainer::AddNew "void
Arc::XMLNodeContainer::AddNew(const std::list< XMLNode > &)

Copy multiple XML subtrees to container. ";

%feature("docstring")  Arc::XMLNodeContainer::Size "int
Arc::XMLNodeContainer::Size(void) const

Return number of refered/stored nodes. ";

%feature("docstring")  Arc::XMLNodeContainer::Nodes "std::list<XMLNode> Arc::XMLNodeContainer::Nodes(void)

Returns all stored nodes. ";


// File: classArc_1_1XMLSecNode.xml
%feature("docstring") Arc::XMLSecNode "

Extends XMLNode class to support XML security operation.

All XMLNode methods are exposed by inheriting from XMLNode. XMLSecNode
itself does not own node, instead it uses the node from the base class
XMLNode.

C++ includes: XMLSecNode.h ";

%feature("docstring")  Arc::XMLSecNode::XMLSecNode "Arc::XMLSecNode::XMLSecNode(XMLNode &node)

Create a object based on an XMLNode instance. ";

%feature("docstring")  Arc::XMLSecNode::~XMLSecNode "Arc::XMLSecNode::~XMLSecNode(void) ";

%feature("docstring")  Arc::XMLSecNode::AddSignatureTemplate "void
Arc::XMLSecNode::AddSignatureTemplate(const std::string &id_name,
const SignatureMethod sign_method, const std::string
&incl_namespaces=\"\")

Add the signature template for later signing.

Parameters:
-----------

id_name:  The identifier name under this node which will be used for
the <Signature> to refer to.

sign_method:  The sign method for signing. Two options now, RSA_SHA1,
DSA_SHA1 ";

%feature("docstring")  Arc::XMLSecNode::SignNode "bool
Arc::XMLSecNode::SignNode(const std::string &privkey_file, const
std::string &cert_file)

Sign this node (identified by id_name).

Parameters:
-----------

privkey_file:  The private key file. The private key is used for
signing

cert_file:  The certificate file. The certificate is used as the
<KeyInfo> part of the <Signature>; <KeyInfo> will be used for the
other end to verify this <Signature>

incl_namespaces:  InclusiveNamespaces for Tranform in Signature ";

%feature("docstring")  Arc::XMLSecNode::VerifyNode "bool
Arc::XMLSecNode::VerifyNode(const std::string &id_name, const
std::string &ca_file, const std::string &ca_path, bool
verify_trusted=true)

Verify the signature under this node

Parameters:
-----------

id_name:  The id of this node, which is used for identifying the node

ca_file:  The CA file which used as trused certificate when verify the
certificate in the <KeyInfo> part of <Signature>

ca_path:  The CA directory; either ca_file or ca_path should be set.
";

%feature("docstring")  Arc::XMLSecNode::EncryptNode "bool
Arc::XMLSecNode::EncryptNode(const std::string &cert_file, const
SymEncryptionType encrpt_type)

Encrypt this node, after encryption, this node will be replaced by the
encrypted node

Parameters:
-----------

cert_file:  The certificate file, the public key parsed from this
certificate is used to encrypted the symmetric key, and then the
symmetric key is used to encrypted the node

encrpt_type:  The encryption type when encrypting the node, four
option in SymEncryptionType

verify_trusted:  Verify trusted certificates or not. If set to false,
then only the signature will be checked (by using the public key from
KeyInfo). ";

%feature("docstring")  Arc::XMLSecNode::DecryptNode "bool
Arc::XMLSecNode::DecryptNode(const std::string &privkey_file, XMLNode
&decrypted_node)

Decrypt the <xenc:EncryptedData/> under this node, the decrypted node
will be output in the second argument of DecryptNode method. And the
<xenc:EncryptedData/> under this node will be removed after
decryption.

Parameters:
-----------

privkey_file:  The private key file, which is used for decrypting

decrypted_node:  Output the decrypted node ";


// File: namespaceArc.xml
%feature("docstring")  Arc::TimeStamp "std::string
Arc::TimeStamp(const TimeFormat &=Time::GetFormat())

Returns a time-stamp of the current time in some format. ";

%feature("docstring")  Arc::TimeStamp "std::string
Arc::TimeStamp(Time, const TimeFormat &=Time::GetFormat())

Returns a time-stamp of some specified time in some format. ";

%feature("docstring")  Arc::FileCopy "bool Arc::FileCopy(const
std::string &source_path, const std::string &destination_path, uid_t
uid, gid_t gid)

Utility functions for handling files and directories. Those functions
offer posibility to access files and directories under user and group
ids different from those of current user. Id switching is done in way
safe for muti-threaded application. If any of specified ids is 0 then
such id is not switched and current id is used instead. Copy file
source_path to file destination_path. Specified uid and gid are used
for accessing filesystem. ";

%feature("docstring")  Arc::FileCopy "bool Arc::FileCopy(const
std::string &source_path, const std::string &destination_path)

Copy file source_path to file destination_path. ";

%feature("docstring")  Arc::FileCopy "bool Arc::FileCopy(const
std::string &source_path, int destination_handle)

Copy file source_path to file handle destination_handle. ";

%feature("docstring")  Arc::FileCopy "bool Arc::FileCopy(int
source_handle, const std::string &destination_path)

Copy from file handle source_handle to file destination_path. ";

%feature("docstring")  Arc::FileCopy "bool Arc::FileCopy(int
source_handle, int destination_handle)

Copy from file handle source_handle to file handle destination_handle.
";

%feature("docstring")  Arc::FileRead "bool Arc::FileRead(const
std::string &filename, std::list< std::string > &data, uid_t uid=0,
gid_t gid=0)

Simple method to read file content from filename. Specified uid and
gid are used for accessing filesystem. The content is split into lines
with the new line character removed, and the lines are returned in the
data list. If protected access is required, FileLock should be used in
addition to FileRead. ";

%feature("docstring")  Arc::FileCreate "bool Arc::FileCreate(const
std::string &filename, const std::string &data, uid_t uid=0, gid_t
gid=0)

Simple method to create a new file containing given data. Specified
uid and gid are used for accessing filesystem. An existing file is
overwritten with the new data. Permissions of the created file are
determined using the current umask. For more complex file handling or
large files, FileOpen() should be used. If protected access is
required, FileLock should be used in addition to FileRead. If uid/gid
are zero then no real switch of uid/gid is done. ";

%feature("docstring")  Arc::FileStat "bool Arc::FileStat(const
std::string &path, struct stat *st, bool follow_symlinks)

Stat a file and put info into the st struct. ";

%feature("docstring")  Arc::FileStat "bool Arc::FileStat(const
std::string &path, struct stat *st, uid_t uid, gid_t gid, bool
follow_symlinks)

Stat a file using the specified uid and gid and put info into the st
struct Specified uid and gid are used for accessing filesystem. ";

%feature("docstring")  Arc::FileLink "bool Arc::FileLink(const
std::string &oldpath, const std::string &newpath, bool symbolic)

Make symbolic or hard link of file. ";

%feature("docstring")  Arc::FileLink "bool Arc::FileLink(const
std::string &oldpath, const std::string &newpath, uid_t uid, gid_t
gid, bool symbolic)

Make symbolic or hard link of file using the specified uid and gid
Specified uid and gid are used for accessing filesystem. ";

%feature("docstring")  Arc::FileReadLink "std::string
Arc::FileReadLink(const std::string &path)

Returns path at which symbolic link is pointing. ";

%feature("docstring")  Arc::FileReadLink "std::string
Arc::FileReadLink(const std::string &path, uid_t uid, gid_t gid)

Returns path at which symbolic link is pointing using the specified
uid and gid Specified uid and gid are used for accessing filesystem.
";

%feature("docstring")  Arc::FileDelete "bool Arc::FileDelete(const
std::string &path)

Deletes file at path. ";

%feature("docstring")  Arc::FileDelete "bool Arc::FileDelete(const
std::string &path, uid_t uid, gid_t gid)

Deletes file at path using the specified uid and gid Specified uid and
gid are used for accessing filesystem. ";

%feature("docstring")  Arc::DirCreate "bool Arc::DirCreate(const
std::string &path, mode_t mode, bool with_parents=false)

Create a new directory. ";

%feature("docstring")  Arc::DirCreate "bool Arc::DirCreate(const
std::string &path, uid_t uid, gid_t gid, mode_t mode, bool
with_parents=false)

Create a new directory using the specified uid and gid Specified uid
and gid are used for accessing filesystem. ";

%feature("docstring")  Arc::DirDelete "bool Arc::DirDelete(const
std::string &path)

Delete a directory and its content. ";

%feature("docstring")  Arc::DirDelete "bool Arc::DirDelete(const
std::string &path, uid_t uid, gid_t gid)

Delete a directory using the specified uid and gid Specified uid and
gid are used for accessing filesystem. ";

%feature("docstring")  Arc::TmpDirCreate "bool
Arc::TmpDirCreate(std::string &path)

Create a temporary directory under the system defined temp location,
and return its path.

Uses mkdtemp if available, and a combination of random parameters if
not. This latter method is not as safe as mkdtemp. ";

%feature("docstring")  Arc::GUID "void Arc::GUID(std::string &guid)

Utilities for generating unique identifiers in the form 12345678-90ab-
cdef-1234-567890abcdef.

Generates a unique identifier using information such as IP address,
current time etc. ";

%feature("docstring")  Arc::UUID "std::string Arc::UUID(void)

Generates a unique identifier using the system uuid libraries. ";

%feature("docstring")  Arc::FindTrans "const char*
Arc::FindTrans(const char *p) ";

%feature("docstring")  Arc::FindNTrans "const char*
Arc::FindNTrans(const char *s, const char *p, unsigned long n) ";

%feature("docstring")  Arc::string_to_level "LogLevel
Arc::string_to_level(const std::string &str)

Convert string to a LogLevel. ";

%feature("docstring")  Arc::istring_to_level "bool
Arc::istring_to_level(const std::string &llStr, LogLevel &ll)

Case-insensitive parsing of a string to a LogLevel with error
response.

The method will try to parse (case-insensitive) the argument string to
a corresponding LogLevel. If the method suceeds, true will be returned
and the argument ll will be set to the parsed LogLevel. If the parsing
fails false will be returned. The parsing succeeds if llStr match
(case-insensitively) one of the names of the LogLevel members.

Parameters:
-----------

llStr:  a string which should be parsed to a Arc::LogLevel.

ll:  a Arc::LogLevel reference which will be set to the matching
Arc::LogLevel upon successful parsing.

true in case of successful parsing, otherwise false.

See:   LogLevel ";

%feature("docstring")  Arc::string_to_level "bool
Arc::string_to_level(const std::string &str, LogLevel &ll)

Same as istring_to_level except it is case-sensitive. ";

%feature("docstring")  Arc::level_to_string "std::string
Arc::level_to_string(const LogLevel &level)

Convert LogLevel to a string. ";

%feature("docstring")  Arc::old_level_to_level "LogLevel
Arc::old_level_to_level(unsigned int old_level)

Convert an old-style log level (int from 0 to 5) to a LogLevel. ";

%feature("docstring")  Arc::stringto "T Arc::stringto(const
std::string &s)

This method converts a string to any type. ";

%feature("docstring")  Arc::stringto "bool Arc::stringto(const
std::string &s, T &t)

This method converts a string to any type but lets calling function
process errors. ";

%feature("docstring")  Arc::tostring "std::string Arc::tostring(T t,
const int width=0, const int precision=0)

This method converts any type to a string of the width given. ";

%feature("docstring")  Arc::lower "std::string Arc::lower(const
std::string &s)

This method converts to lower case of the string. ";

%feature("docstring")  Arc::upper "std::string Arc::upper(const
std::string &s)

This method converts to upper case of the string. ";

%feature("docstring")  Arc::tokenize "void Arc::tokenize(const
std::string &str, std::vector< std::string > &tokens, const
std::string &delimiters=\" \", const std::string &start_quotes=\"\",
const std::string &end_quotes=\"\")

This method tokenizes string. ";

%feature("docstring")  Arc::tokenize "void Arc::tokenize(const
std::string &str, std::list< std::string > &tokens, const std::string
&delimiters=\" \", const std::string &start_quotes=\"\", const
std::string &end_quotes=\"\") ";

%feature("docstring")  Arc::trim "std::string Arc::trim(const
std::string &str, const char *sep=NULL)

This method removes given separators from the beginning and the end of
the string. ";

%feature("docstring")  Arc::strip "std::string Arc::strip(const
std::string &str)

This method removes blank lines from the passed text string. Lines
with only space on them are considered blank. ";

%feature("docstring")  Arc::uri_unescape "std::string
Arc::uri_unescape(const std::string &str)

This method unescape the URI encoded string. ";

%feature("docstring")  Arc::convert_to_rdn "std::string
Arc::convert_to_rdn(const std::string &dn)

Convert dn to rdn: /O=Grid/OU=Knowarc/CN=abc --->
CN=abc,OU=Knowarc,O=Grid. ";

%feature("docstring")  Arc::CreateThreadFunction "bool
Arc::CreateThreadFunction(void(*func)(void *), void *arg,
SimpleCounter *count=NULL)

This macro behaves like function which makes thread of class' method.

It accepts class instance and full name of method - like
class::method. 'method' should not be static member of the class.
Result is true if creation of thread succeeded. Specified instance
must be valid during whole lifetime of thread. So probably it is safer
to destroy 'instance' in 'method' just before exiting. Helper function
to create simple thread. It takes care of all pecularities of
Glib::Thread API. As result it runs function 'func' with argument
'arg' in a separate thread. If count parameter not NULL then
corresponding object will be incremented before function returns and
then decremented then thread finished. Returns true on success. ";

%feature("docstring")  Arc::GlibThreadInitialize "void
Arc::GlibThreadInitialize(void) ";

%feature("docstring")  Arc::ReadURLList "std::list<URL>
Arc::ReadURLList(const URL &urllist)

Reads a list of URLs from a file. ";

%feature("docstring")  Arc::tostring "std::string Arc::tostring(const
ServiceType st) ";

%feature("docstring")  Arc::GetEnv "std::string Arc::GetEnv(const
std::string &var)

Portable function for getting environment variables. ";

%feature("docstring")  Arc::GetEnv "std::string Arc::GetEnv(const
std::string &var, bool &found)

Portable function for getting environment variables. ";

%feature("docstring")  Arc::SetEnv "bool Arc::SetEnv(const
std::string &var, const std::string &value, bool overwrite=true)

Portable function for setting environment variables. ";

%feature("docstring")  Arc::UnsetEnv "void Arc::UnsetEnv(const
std::string &var)

Portable function for unsetting environment variables. ";

%feature("docstring")  Arc::EnvLockAcquire "void
Arc::EnvLockAcquire(void) ";

%feature("docstring")  Arc::EnvLockRelease "void
Arc::EnvLockRelease(void) ";

%feature("docstring")  Arc::EnvLockWrap "void Arc::EnvLockWrap(bool
all=false)

Start code which is using setenv/getenv. Use all=true for setenv and
all=false for getenv. Must always have corresponding EnvLockUnwrap. ";

%feature("docstring")  Arc::EnvLockUnwrap "void
Arc::EnvLockUnwrap(bool all=false)

End code which is using setenv/getenv. Value of all must be same as in
corresponding EnvLockWrap. ";

%feature("docstring")  Arc::EnvLockUnwrapComplete "void
Arc::EnvLockUnwrapComplete(void)

Use after fork() to reset all internal variables and release all
locks. ";

%feature("docstring")  Arc::StrError "std::string Arc::StrError(int
errnum=errno)

Portable function for obtaining description of last system error. ";

%feature("docstring")  Arc::PersistentLibraryInit "bool
Arc::PersistentLibraryInit(const std::string &name) ";

%feature("docstring")  Arc::MatchXMLName "bool
Arc::MatchXMLName(const XMLNode &node1, const XMLNode &node2)

Returns true if underlying XML elements have same names ";

%feature("docstring")  Arc::MatchXMLName "bool
Arc::MatchXMLName(const XMLNode &node, const char *name)

Returns true if 'name' matches name of 'node'. If name contains prefix
it's checked too ";

%feature("docstring")  Arc::MatchXMLName "bool
Arc::MatchXMLName(const XMLNode &node, const std::string &name)

Returns true if 'name' matches name of 'node'. If name contains prefix
it's checked too ";

%feature("docstring")  Arc::MatchXMLNamespace "bool
Arc::MatchXMLNamespace(const XMLNode &node1, const XMLNode &node2)

Returns true if underlying XML elements belong to same namespaces ";

%feature("docstring")  Arc::MatchXMLNamespace "bool
Arc::MatchXMLNamespace(const XMLNode &node, const char *uri)

Returns true if 'namespace' matches 'node's namespace. ";

%feature("docstring")  Arc::MatchXMLNamespace "bool
Arc::MatchXMLNamespace(const XMLNode &node, const std::string &uri)

Returns true if 'namespace' matches 'node's namespace. ";

%feature("docstring")  Arc::InitVOMSAttribute "void
Arc::InitVOMSAttribute(void) ";

%feature("docstring")  Arc::createVOMSAC "int Arc::createVOMSAC(X509
*issuer, STACK_OF(X509)*issuerstack, X509 *holder, EVP_PKEY *pkey,
BIGNUM *serialnum, std::vector< std::string > &fqan, std::vector<
std::string > &targets, std::vector< std::string > &attributes,
ArcCredential::AC **ac, std::string voname, std::string uri, int
lifetime) ";

%feature("docstring")  Arc::createVOMSAC "bool
Arc::createVOMSAC(std::string &codedac, Credential &issuer_cred,
Credential &holder_cred, std::vector< std::string > &fqan,
std::vector< std::string > &targets, std::vector< std::string >
&attributes, std::string &voname, std::string &uri, int lifetime)

Create AC(Attribute Certificate) with voms specific format.

Parameters:
-----------

codedac:  The coded AC as output of this method

issuer_cred:  The issuer credential which is used to sign the AC

holder_cred:  The holder credential, the holder certificate is the one
which carries AC The rest arguments are the same as the above method
";

%feature("docstring")  Arc::addVOMSAC "bool
Arc::addVOMSAC(ArcCredential::AC **&aclist, std::string &acorder,
std::string &decodedac)

Add decoded AC string into a list of AC objects

Parameters:
-----------

aclist:  The list of AC objects (output)

acorder:  The order of AC objects (output)

decodedac:  The AC string that is decoded from the string returned
from voms server (input) ";

%feature("docstring")  Arc::parseVOMSAC "bool Arc::parseVOMSAC(X509
*holder, const std::string &ca_cert_dir, const std::string
&ca_cert_file, const VOMSTrustList &vomscert_trust_dn, std::vector<
VOMSACInfo > &output, bool verify=true)

Parse the certificate, and output the attributes.

Parameters:
-----------

holder:  The proxy certificate which includes the voms specific
formated AC.

ca_cert_dir:  The trusted certificates which are used to verify the
certificate which is used to sign the AC

ca_cert_file:  The same as ca_cert_dir except it is a file instead of
a directory. Only one of them need to be set

vomsdir:  The directory which include *.lsc file for each vo. For
instance, a vo called \"knowarc.eu\" should have file
$prefix/vomsdir/knowarc/voms.knowarc.eu.lsc which contains on the
first line the DN of the VOMS server, and on the second line the
corresponding CA DN: /O=Grid/O=NorduGrid/OU=KnowARC/CN=voms.knowarc.eu
/O=Grid/O=NorduGrid/CN=NorduGrid Certification Authority See more in
:https://twiki.cern.ch/twiki/bin/view/LCG/VomsFAQforServiceManagers

output:  The parsed attributes (Role and Generic Attribute) . Each
attribute is stored in element of a vector as a string. It is up to
the consumer to understand the meaning of the attribute. There are two
types of attributes stored in VOMS AC: AC_IETFATTR,
AC_FULL_ATTRIBUTES. The AC_IETFATTR will be like
/Role=Employee/Group=Tester/Capability=NULL The AC_FULL_ATTRIBUTES
will be like knowarc:Degree=PhD (qualifier::name=value) In order to
make the output attribute values be identical, the voms server
information is added as prefix of the original attributes in AC. for
AC_FULL_ATTRIBUTES, the voname + hostname is added:
/voname=knowarc.eu/hostname=arthur.hep.lu.se:15001//knowarc.eu/coredev:attribute1=1
for AC_IETFATTR, the 'VO' (voname) is added:
/VO=knowarc.eu/Group=coredev/Role=NULL/Capability=NULL
/VO=knowarc.eu/Group=testers/Role=NULL/Capability=NULL

some other redundant attributes is provided:
voname=knowarc.eu/hostname=arthur.hep.lu.se:15001

Parameters:
-----------

verify:  true: Verify the voms certificate is trusted based on the
ca_cert_dir/ca_cert_file which specifies the CA certificates, and the
vomscert_trust_dn which specifies the trusted DN chain from voms
server certificate to CA certificate.

false: Not verify, which means the issuer of AC (voms server
certificate is supposed to be trusted by default). In this case the
parameters 'ca_cert_dir', 'ca_cert_file' and 'vomscert_trust_dn' will
not effect, and should be set as empty. This case is specifically used
by 'arcproxy --info' to list all of the attributes in AC, and not to
need to verify if the AC's issuer is trusted. ";

%feature("docstring")  Arc::parseVOMSAC "bool Arc::parseVOMSAC(const
Credential &holder_cred, const std::string &ca_cert_dir, const
std::string &ca_cert_file, const VOMSTrustList &vomscert_trust_dn,
std::vector< VOMSACInfo > &output, bool verify=true)

Parse the certificate. Similar to above one, but collects information
From all certificates in a chain. ";

%feature("docstring")  Arc::VOMSDecode "char* Arc::VOMSDecode(const
char *data, int size, int *j)

Decode the data which is encoded by voms server. Since voms code uses
some specific coding method (not base64 encoding), we simply copy the
method from voms code to here ";

%feature("docstring")  Arc::get_property "const std::string
Arc::get_property(const Arc::Credential &u, const std::string
property)

Extract the needed field from the certificate ";

%feature("docstring")  Arc::OpenSSLInit "bool Arc::OpenSSLInit(void)

This module contains various convenience utilities for using OpenSSL.

Application may be linked to this module instead of OpenSSL libraries
directly. This function initializes OpenSSL library. It may be called
multiple times and makes sure everything is done properly and OpenSSL
may be used in multi-threaded environment. Because this function makes
use of ArcLocation it is advisable to call it after
ArcLocation::Init(). ";

%feature("docstring")  Arc::HandleOpenSSLError "void
Arc::HandleOpenSSLError(void)

Prints chain of accumulaed OpenSSL errors if any available. ";

%feature("docstring")  Arc::HandleOpenSSLError "void
Arc::HandleOpenSSLError(int code)

Prints chain of accumulaed OpenSSL errors if any available. ";

%feature("docstring")  Arc::OpenSSLAppDataIndex "int
Arc::OpenSSLAppDataIndex(const std::string &id) ";

%feature("docstring")  Arc::globus_object_to_string "std::string
Arc::globus_object_to_string(globus_object_t *err) ";

%feature("docstring")  Arc::GlobusRecoverProxyOpenSSL "bool
Arc::GlobusRecoverProxyOpenSSL(void) ";

%feature("docstring")  Arc::GlobusPrepareGSSAPI "bool
Arc::GlobusPrepareGSSAPI(void) ";

%feature("docstring")  Arc::GlobusModuleActivate "bool
Arc::GlobusModuleActivate(globus_module_descriptor_t *module) ";

%feature("docstring")  Arc::PluginCast "P*
Arc::PluginCast(PluginArgument *p) ";

%feature("docstring")  Arc::PluginCast "P* Arc::PluginCast(Plugin *p)
";

%feature("docstring")  Arc::string "std::string
Arc::string(StatusKind kind)

Conversion to string.

Conversion from StatusKind to string.

Parameters:
-----------

kind:  The StatusKind to convert. ";

%feature("docstring")  Arc::ContentFromPayload "const char*
Arc::ContentFromPayload(const MessagePayload &payload)

Returns pointer to main memory chunk of Message payload.

If no buffer is present or if payload is not of PayloadRawInterface
type NULL is returned. ";

%feature("docstring")  Arc::WSAFaultAssign "void
Arc::WSAFaultAssign(SOAPEnvelope &mesage, WSAFault fid)

Makes WS-Addressing fault.

It fills SOAP Fault message with WS-Addressing fault related
information. ";

%feature("docstring")  Arc::WSAFaultExtract "WSAFault
Arc::WSAFaultExtract(SOAPEnvelope &message)

Gets WS-addressing fault.

Analyzes SOAP Fault message and returns WS-Addressing fault it
represents. ";

%feature("docstring")  Arc::CreateWSRP "WSRF&
Arc::CreateWSRP(SOAPEnvelope &soap) ";

%feature("docstring")  Arc::CreateWSRFBaseFault "WSRF&
Arc::CreateWSRFBaseFault(SOAPEnvelope &soap) ";

%feature("docstring")  Arc::DeflateData "std::string
Arc::DeflateData(const std::string &data) ";

%feature("docstring")  Arc::InflateData "std::string
Arc::InflateData(const std::string &data) ";

%feature("docstring")  Arc::URIEscape "std::string
Arc::URIEscape(const std::string &data) ";

%feature("docstring")  Arc::URIUnEscape "std::string
Arc::URIUnEscape(const std::string &data) ";

%feature("docstring")  Arc::Base64Encode "std::string
Arc::Base64Encode(const std::string &data) ";

%feature("docstring")  Arc::Base64Decode "std::string
Arc::Base64Decode(const std::string &data) ";

%feature("docstring")  Arc::SignQuery "std::string
Arc::SignQuery(std::string query, SignatureMethod sign_method,
std::string &privkey_file) ";

%feature("docstring")  Arc::VerifyQuery "bool Arc::VerifyQuery(const
std::string query, const std::string &sender_cert_str) ";

%feature("docstring")  Arc::BuildDeflatedQuery "std::string
Arc::BuildDeflatedQuery(const XMLNode &node) ";

%feature("docstring")  Arc::BuildNodefromMsg "bool
Arc::BuildNodefromMsg(const std::string msg, XMLNode &node) ";

%feature("docstring")  Arc::passphrase_callback "int
Arc::passphrase_callback(char *buf, int size, int rwflag, void *)

callback method for inputing passphrase of key file ";

%feature("docstring")  Arc::init_xmlsec "bool Arc::init_xmlsec(void)

Initialize the xml security library, it should be called before the
xml security functionality is used. ";

%feature("docstring")  Arc::final_xmlsec "bool
Arc::final_xmlsec(void)

Finalize the xml security library ";

%feature("docstring")  Arc::get_cert_str "std::string
Arc::get_cert_str(const char *certfile)

Get certificate in string format from certificate file ";

%feature("docstring")  Arc::get_key_from_keystr "xmlSecKey*
Arc::get_key_from_keystr(const std::string &value)

Get key in xmlSecKey structure from key in string format ";

%feature("docstring")  Arc::get_key_from_keyfile "xmlSecKey*
Arc::get_key_from_keyfile(const char *keyfile)

Get key in xmlSecKey structure from key file ";

%feature("docstring")  Arc::get_key_from_certfile "std::string
Arc::get_key_from_certfile(const char *certfile)

Get public key in string format from certificate file ";

%feature("docstring")  Arc::get_key_from_certstr "xmlSecKey*
Arc::get_key_from_certstr(const std::string &value)

Get public key in xmlSecKey structure from certificate string (the
string under \"-----BEGIN CERTIFICATE-----\" and \"-----END
CERTIFICATE-----\") ";

%feature("docstring")  Arc::load_key_from_keyfile "xmlSecKeysMngrPtr
Arc::load_key_from_keyfile(xmlSecKeysMngrPtr *keys_manager, const char
*keyfile)

Load private or public key from a key file into key manager ";

%feature("docstring")  Arc::load_key_from_certfile "xmlSecKeysMngrPtr
Arc::load_key_from_certfile(xmlSecKeysMngrPtr *keys_manager, const
char *certfile)

Load public key from a certificate file into key manager ";

%feature("docstring")  Arc::load_key_from_certstr "xmlSecKeysMngrPtr
Arc::load_key_from_certstr(xmlSecKeysMngrPtr *keys_manager, const
std::string &certstr)

Load public key from a certificate string into key manager ";

%feature("docstring")  Arc::load_trusted_cert_file "xmlSecKeysMngrPtr
Arc::load_trusted_cert_file(xmlSecKeysMngrPtr *keys_manager, const
char *cert_file)

Load trusted certificate from certificate file into key manager ";

%feature("docstring")  Arc::load_trusted_cert_str "xmlSecKeysMngrPtr
Arc::load_trusted_cert_str(xmlSecKeysMngrPtr *keys_manager, const
std::string &cert_str)

Load trusted certificate from cetrtificate string into key manager ";

%feature("docstring")  Arc::load_trusted_certs "xmlSecKeysMngrPtr
Arc::load_trusted_certs(xmlSecKeysMngrPtr *keys_manager, const char
*cafile, const char *capath)

Load trusted cetificates from a file or directory into key manager ";

%feature("docstring")  Arc::get_node "XMLNode Arc::get_node(XMLNode
&parent, const char *name)

Generate a new child XMLNode with specified name ";


// File: namespaceArcCredential.xml
%feature("docstring")  ArcCredential::verify_cert_chain "int
ArcCredential::verify_cert_chain(X509 *cert,
STACK_OF(X509)**certchain, cert_verify_context *vctx) ";

%feature("docstring")  ArcCredential::check_cert_type "bool
ArcCredential::check_cert_type(X509 *cert, certType &type) ";

%feature("docstring")  ArcCredential::certTypeToString "const char*
ArcCredential::certTypeToString(certType type) ";

%feature("docstring")  ArcCredential::PROXYPOLICY_new "PROXYPOLICY*
ArcCredential::PROXYPOLICY_new() ";

%feature("docstring")  ArcCredential::PROXYPOLICY_free "void
ArcCredential::PROXYPOLICY_free(PROXYPOLICY *proxypolicy) ";

%feature("docstring")  ArcCredential::PROXYPOLICY_dup "PROXYPOLICY*
ArcCredential::PROXYPOLICY_dup(PROXYPOLICY *policy) ";

%feature("docstring")  ArcCredential::PROXYPOLICY_set_policy_language
"int ArcCredential::PROXYPOLICY_set_policy_language(PROXYPOLICY
*policy, ASN1_OBJECT *policy_language) ";

%feature("docstring")  ArcCredential::PROXYPOLICY_get_policy_language
"ASN1_OBJECT*
ArcCredential::PROXYPOLICY_get_policy_language(PROXYPOLICY *policy) ";

%feature("docstring")  ArcCredential::PROXYPOLICY_set_policy "int
ArcCredential::PROXYPOLICY_set_policy(PROXYPOLICY *proxypolicy,
unsigned char *policy, int length) ";

%feature("docstring")  ArcCredential::PROXYPOLICY_get_policy "unsigned char* ArcCredential::PROXYPOLICY_get_policy(PROXYPOLICY
*policy, int *length) ";

%feature("docstring")  ArcCredential::i2d_PROXYPOLICY "int
ArcCredential::i2d_PROXYPOLICY(PROXYPOLICY *policy, unsigned char
**pp) ";

%feature("docstring")  ArcCredential::d2i_PROXYPOLICY "PROXYPOLICY*
ArcCredential::d2i_PROXYPOLICY(PROXYPOLICY **policy, unsigned char
**pp, long length) ";

%feature("docstring")  ArcCredential::PROXYPOLICY_x509v3_ext_meth "X509V3_EXT_METHOD* ArcCredential::PROXYPOLICY_x509v3_ext_meth() ";

%feature("docstring")  ArcCredential::STACK_OF "PROXYCERTINFO
ArcCredential::STACK_OF(CONF_VALUE)*i2v_PROXYPOLICY(struct
v3_ext_method *method ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_new "PROXYCERTINFO* ArcCredential::PROXYCERTINFO_new() ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_free "void
ArcCredential::PROXYCERTINFO_free(PROXYCERTINFO *proxycertinfo) ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_dup "PROXYCERTINFO* ArcCredential::PROXYCERTINFO_dup(PROXYCERTINFO
*proxycertinfo) ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_print_fp "int
ArcCredential::PROXYCERTINFO_print_fp(FILE *fp, PROXYCERTINFO
*cert_info) ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_set_path_length "int ArcCredential::PROXYCERTINFO_set_path_length(PROXYCERTINFO
*proxycertinfo, long path_length) ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_get_path_length "long ArcCredential::PROXYCERTINFO_get_path_length(PROXYCERTINFO
*proxycertinfo) ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_set_proxypolicy "int ArcCredential::PROXYCERTINFO_set_proxypolicy(PROXYCERTINFO
*proxycertinfo, PROXYPOLICY *proxypolicy) ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_get_proxypolicy "PROXYPOLICY*
ArcCredential::PROXYCERTINFO_get_proxypolicy(PROXYCERTINFO
*proxycertinfo) ";

%feature("docstring")  ArcCredential::i2d_PROXYCERTINFO "int
ArcCredential::i2d_PROXYCERTINFO(PROXYCERTINFO *proxycertinfo,
unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_PROXYCERTINFO "PROXYCERTINFO* ArcCredential::d2i_PROXYCERTINFO(PROXYCERTINFO
**cert_info, unsigned char **a, long length) ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_set_version "int
ArcCredential::PROXYCERTINFO_set_version(PROXYCERTINFO *cert_info, int
version) ";

%feature("docstring")  ArcCredential::i2r_PROXYCERTINFO "int
ArcCredential::i2r_PROXYCERTINFO(X509V3_EXT_METHOD *method,
PROXYCERTINFO *ext, BIO *out, int indent) ";

%feature("docstring")  ArcCredential::r2i_PROXYCERTINFO "PROXYCERTINFO* ArcCredential::r2i_PROXYCERTINFO(X509V3_EXT_METHOD
*method, X509V3_CTX *ctx, char *value) ";

%feature("docstring")  ArcCredential::PROXYCERTINFO_v3_x509v3_ext_meth
"X509V3_EXT_METHOD* ArcCredential::PROXYCERTINFO_v3_x509v3_ext_meth()
";

%feature("docstring")  ArcCredential::PROXYCERTINFO_v4_x509v3_ext_meth
"X509V3_EXT_METHOD* ArcCredential::PROXYCERTINFO_v4_x509v3_ext_meth()
";

%feature("docstring")  ArcCredential::i2d_AC_ATTR "int
ArcCredential::i2d_AC_ATTR(AC_ATTR *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_ATTR "AC_ATTR*
ArcCredential::d2i_AC_ATTR(AC_ATTR **a, SSLCONST unsigned char **p,
long length) ";

%feature("docstring")  ArcCredential::AC_ATTR_new "AC_ATTR*
ArcCredential::AC_ATTR_new() ";

%feature("docstring")  ArcCredential::AC_ATTR_free "void
ArcCredential::AC_ATTR_free(AC_ATTR *a) ";

%feature("docstring")  ArcCredential::i2d_AC_IETFATTR "int
ArcCredential::i2d_AC_IETFATTR(AC_IETFATTR *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_IETFATTR "AC_IETFATTR*
ArcCredential::d2i_AC_IETFATTR(AC_IETFATTR **a, SSLCONST unsigned char
**p, long length) ";

%feature("docstring")  ArcCredential::AC_IETFATTR_new "AC_IETFATTR*
ArcCredential::AC_IETFATTR_new() ";

%feature("docstring")  ArcCredential::AC_IETFATTR_free "void
ArcCredential::AC_IETFATTR_free(AC_IETFATTR *a) ";

%feature("docstring")  ArcCredential::i2d_AC_IETFATTRVAL "int
ArcCredential::i2d_AC_IETFATTRVAL(AC_IETFATTRVAL *a, unsigned char
**pp) ";

%feature("docstring")  ArcCredential::d2i_AC_IETFATTRVAL "AC_IETFATTRVAL* ArcCredential::d2i_AC_IETFATTRVAL(AC_IETFATTRVAL **a,
SSLCONST unsigned char **pp, long length) ";

%feature("docstring")  ArcCredential::AC_IETFATTRVAL_new "AC_IETFATTRVAL* ArcCredential::AC_IETFATTRVAL_new() ";

%feature("docstring")  ArcCredential::AC_IETFATTRVAL_free "void
ArcCredential::AC_IETFATTRVAL_free(AC_IETFATTRVAL *a) ";

%feature("docstring")  ArcCredential::i2d_AC_DIGEST "int
ArcCredential::i2d_AC_DIGEST(AC_DIGEST *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_DIGEST "AC_DIGEST*
ArcCredential::d2i_AC_DIGEST(AC_DIGEST **a, SSLCONST unsigned char
**pp, long length) ";

%feature("docstring")  ArcCredential::AC_DIGEST_new "AC_DIGEST*
ArcCredential::AC_DIGEST_new(void) ";

%feature("docstring")  ArcCredential::AC_DIGEST_free "void
ArcCredential::AC_DIGEST_free(AC_DIGEST *a) ";

%feature("docstring")  ArcCredential::i2d_AC_IS "int
ArcCredential::i2d_AC_IS(AC_IS *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_IS "AC_IS*
ArcCredential::d2i_AC_IS(AC_IS **a, SSLCONST unsigned char **pp, long
length) ";

%feature("docstring")  ArcCredential::AC_IS_new "AC_IS*
ArcCredential::AC_IS_new(void) ";

%feature("docstring")  ArcCredential::AC_IS_free "void
ArcCredential::AC_IS_free(AC_IS *a) ";

%feature("docstring")  ArcCredential::i2d_AC_FORM "int
ArcCredential::i2d_AC_FORM(AC_FORM *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_FORM "AC_FORM*
ArcCredential::d2i_AC_FORM(AC_FORM **a, SSLCONST unsigned char **pp,
long length) ";

%feature("docstring")  ArcCredential::AC_FORM_new "AC_FORM*
ArcCredential::AC_FORM_new(void) ";

%feature("docstring")  ArcCredential::AC_FORM_free "void
ArcCredential::AC_FORM_free(AC_FORM *a) ";

%feature("docstring")  ArcCredential::i2d_AC_ACI "int
ArcCredential::i2d_AC_ACI(AC_ACI *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_ACI "AC_ACI*
ArcCredential::d2i_AC_ACI(AC_ACI **a, SSLCONST unsigned char **pp,
long length) ";

%feature("docstring")  ArcCredential::AC_ACI_new "AC_ACI*
ArcCredential::AC_ACI_new(void) ";

%feature("docstring")  ArcCredential::AC_ACI_free "void
ArcCredential::AC_ACI_free(AC_ACI *a) ";

%feature("docstring")  ArcCredential::i2d_AC_HOLDER "int
ArcCredential::i2d_AC_HOLDER(AC_HOLDER *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_HOLDER "AC_HOLDER*
ArcCredential::d2i_AC_HOLDER(AC_HOLDER **a, SSLCONST unsigned char
**pp, long length) ";

%feature("docstring")  ArcCredential::AC_HOLDER_new "AC_HOLDER*
ArcCredential::AC_HOLDER_new(void) ";

%feature("docstring")  ArcCredential::AC_HOLDER_free "void
ArcCredential::AC_HOLDER_free(AC_HOLDER *a) ";

%feature("docstring")  ArcCredential::i2d_AC_VAL "int
ArcCredential::i2d_AC_VAL(AC_VAL *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_VAL "AC_VAL*
ArcCredential::d2i_AC_VAL(AC_VAL **a, SSLCONST unsigned char **pp,
long length) ";

%feature("docstring")  ArcCredential::AC_VAL_new "AC_VAL*
ArcCredential::AC_VAL_new(void) ";

%feature("docstring")  ArcCredential::AC_VAL_free "void
ArcCredential::AC_VAL_free(AC_VAL *a) ";

%feature("docstring")  ArcCredential::i2d_AC_INFO "int
ArcCredential::i2d_AC_INFO(AC_INFO *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_INFO "AC_INFO*
ArcCredential::d2i_AC_INFO(AC_INFO **a, SSLCONST unsigned char **p,
long length) ";

%feature("docstring")  ArcCredential::AC_INFO_new "AC_INFO*
ArcCredential::AC_INFO_new(void) ";

%feature("docstring")  ArcCredential::AC_INFO_free "void
ArcCredential::AC_INFO_free(AC_INFO *a) ";

%feature("docstring")  ArcCredential::i2d_AC "int
ArcCredential::i2d_AC(AC *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC "AC*
ArcCredential::d2i_AC(AC **a, SSLCONST unsigned char **pp, long
length) ";

%feature("docstring")  ArcCredential::AC_new "AC*
ArcCredential::AC_new(void) ";

%feature("docstring")  ArcCredential::AC_free "void
ArcCredential::AC_free(AC *a) ";

%feature("docstring")  ArcCredential::i2d_AC_TARGETS "int
ArcCredential::i2d_AC_TARGETS(AC_TARGETS *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_TARGETS "AC_TARGETS*
ArcCredential::d2i_AC_TARGETS(AC_TARGETS **a, SSLCONST unsigned char
**pp, long length) ";

%feature("docstring")  ArcCredential::AC_TARGETS_new "AC_TARGETS*
ArcCredential::AC_TARGETS_new(void) ";

%feature("docstring")  ArcCredential::AC_TARGETS_free "void
ArcCredential::AC_TARGETS_free(AC_TARGETS *a) ";

%feature("docstring")  ArcCredential::i2d_AC_TARGET "int
ArcCredential::i2d_AC_TARGET(AC_TARGET *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_TARGET "AC_TARGET*
ArcCredential::d2i_AC_TARGET(AC_TARGET **a, SSLCONST unsigned char
**pp, long length) ";

%feature("docstring")  ArcCredential::AC_TARGET_new "AC_TARGET*
ArcCredential::AC_TARGET_new(void) ";

%feature("docstring")  ArcCredential::AC_TARGET_free "void
ArcCredential::AC_TARGET_free(AC_TARGET *a) ";

%feature("docstring")  ArcCredential::i2d_AC_SEQ "int
ArcCredential::i2d_AC_SEQ(AC_SEQ *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_SEQ "AC_SEQ*
ArcCredential::d2i_AC_SEQ(AC_SEQ **a, SSLCONST unsigned char **pp,
long length) ";

%feature("docstring")  ArcCredential::AC_SEQ_new "AC_SEQ*
ArcCredential::AC_SEQ_new(void) ";

%feature("docstring")  ArcCredential::AC_SEQ_free "void
ArcCredential::AC_SEQ_free(AC_SEQ *a) ";

%feature("docstring")  ArcCredential::i2d_AC_CERTS "int
ArcCredential::i2d_AC_CERTS(AC_CERTS *a, unsigned char **pp) ";

%feature("docstring")  ArcCredential::d2i_AC_CERTS "AC_CERTS*
ArcCredential::d2i_AC_CERTS(AC_CERTS **a, SSLCONST unsigned char **pp,
long length) ";

%feature("docstring")  ArcCredential::AC_CERTS_new "AC_CERTS*
ArcCredential::AC_CERTS_new(void) ";

%feature("docstring")  ArcCredential::AC_CERTS_free "void
ArcCredential::AC_CERTS_free(AC_CERTS *a) ";

%feature("docstring")  ArcCredential::i2d_AC_ATTRIBUTE "int
ArcCredential::i2d_AC_ATTRIBUTE(AC_ATTRIBUTE *, unsigned char **) ";

%feature("docstring")  ArcCredential::d2i_AC_ATTRIBUTE "AC_ATTRIBUTE*
ArcCredential::d2i_AC_ATTRIBUTE(AC_ATTRIBUTE **, SSLCONST unsigned
char **, long) ";

%feature("docstring")  ArcCredential::AC_ATTRIBUTE_new "AC_ATTRIBUTE*
ArcCredential::AC_ATTRIBUTE_new() ";

%feature("docstring")  ArcCredential::AC_ATTRIBUTE_free "void
ArcCredential::AC_ATTRIBUTE_free(AC_ATTRIBUTE *) ";

%feature("docstring")  ArcCredential::i2d_AC_ATT_HOLDER "int
ArcCredential::i2d_AC_ATT_HOLDER(AC_ATT_HOLDER *, unsigned char **) ";

%feature("docstring")  ArcCredential::d2i_AC_ATT_HOLDER "AC_ATT_HOLDER* ArcCredential::d2i_AC_ATT_HOLDER(AC_ATT_HOLDER **,
SSLCONST unsigned char **, long) ";

%feature("docstring")  ArcCredential::AC_ATT_HOLDER_new "AC_ATT_HOLDER* ArcCredential::AC_ATT_HOLDER_new() ";

%feature("docstring")  ArcCredential::AC_ATT_HOLDER_free "void
ArcCredential::AC_ATT_HOLDER_free(AC_ATT_HOLDER *) ";

%feature("docstring")  ArcCredential::i2d_AC_FULL_ATTRIBUTES "int
ArcCredential::i2d_AC_FULL_ATTRIBUTES(AC_FULL_ATTRIBUTES *, unsigned
char **) ";

%feature("docstring")  ArcCredential::d2i_AC_FULL_ATTRIBUTES "AC_FULL_ATTRIBUTES*
ArcCredential::d2i_AC_FULL_ATTRIBUTES(AC_FULL_ATTRIBUTES **, SSLCONST
unsigned char **, long) ";

%feature("docstring")  ArcCredential::AC_FULL_ATTRIBUTES_new "AC_FULL_ATTRIBUTES* ArcCredential::AC_FULL_ATTRIBUTES_new() ";

%feature("docstring")  ArcCredential::AC_FULL_ATTRIBUTES_free "void
ArcCredential::AC_FULL_ATTRIBUTES_free(AC_FULL_ATTRIBUTES *) ";

%feature("docstring")
ArcCredential::VOMSAttribute_auth_x509v3_ext_meth "X509V3_EXT_METHOD*
ArcCredential::VOMSAttribute_auth_x509v3_ext_meth() ";

%feature("docstring")
ArcCredential::VOMSAttribute_avail_x509v3_ext_meth "X509V3_EXT_METHOD*
ArcCredential::VOMSAttribute_avail_x509v3_ext_meth() ";

%feature("docstring")
ArcCredential::VOMSAttribute_targets_x509v3_ext_meth "X509V3_EXT_METHOD*
ArcCredential::VOMSAttribute_targets_x509v3_ext_meth() ";

%feature("docstring")
ArcCredential::VOMSAttribute_acseq_x509v3_ext_meth "X509V3_EXT_METHOD*
ArcCredential::VOMSAttribute_acseq_x509v3_ext_meth() ";

%feature("docstring")
ArcCredential::VOMSAttribute_certseq_x509v3_ext_meth "X509V3_EXT_METHOD*
ArcCredential::VOMSAttribute_certseq_x509v3_ext_meth() ";

%feature("docstring")
ArcCredential::VOMSAttribute_attribs_x509v3_ext_meth "X509V3_EXT_METHOD*
ArcCredential::VOMSAttribute_attribs_x509v3_ext_meth() ";


// File: namespaceArcSec.xml
%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(PermitDenyIndeterminateNotApplicableCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(PermitDenyNotApplicableIndeterminateCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(PermitIndeterminateDenyNotApplicableCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(PermitIndeterminateNotApplicableDenyCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(PermitNotApplicableDenyIndeterminateCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(PermitNotApplicableIndeterminateDenyCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(DenyPermitIndeterminateNotApplicableCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(DenyPermitNotApplicableIndeterminateCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(DenyIndeterminatePermitNotApplicableCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(DenyIndeterminateNotApplicablePermitCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(DenyNotApplicablePermitIndeterminateCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(DenyNotApplicableIndeterminatePermitCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(IndeterminatePermitDenyNotApplicableCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(IndeterminatePermitNotApplicableDenyCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(IndeterminateDenyPermitNotApplicableCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(IndeterminateDenyNotApplicablePermitCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(IndeterminateNotApplicablePermitDenyCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(IndeterminateNotApplicableDenyPermitCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(NotApplicablePermitDenyIndeterminateCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(NotApplicablePermitIndeterminateDenyCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(NotApplicableDenyPermitIndeterminateCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(NotApplicableDenyIndeterminatePermitCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(NotApplicableIndeterminatePermitDenyCombiningAlg)
";

%feature("docstring")  ArcSec::ORDERED_ALG_CLASS "ArcSec::ORDERED_ALG_CLASS(NotApplicableIndeterminateDenyPermitCombiningAlg)
";


// File: AlgFactory_8h.xml


// File: AnyURIAttribute_8h.xml


// File: ArcConfig_8h.xml


// File: ArcLocation_8h.xml


// File: ArcRegex_8h.xml


// File: AttributeFactory_8h.xml


// File: AttributeProxy_8h.xml


// File: AttributeValue_8h.xml


// File: Base64_8h.xml


// File: BooleanAttribute_8h.xml


// File: Broker_8h.xml


// File: ByteArray_8h.xml


// File: CertUtil_8h.xml


// File: CheckSum_8h.xml


// File: CIStringValue_8h.xml


// File: ClassLoader_8h.xml


// File: ClientInterface_8h.xml


// File: ClientSAML2SSO_8h.xml


// File: ClientX509Delegation_8h.xml


// File: CombiningAlg_8h.xml


// File: ConfusaCertHandler_8h.xml


// File: ConfusaParserUtils_8h.xml


// File: Counter_8h.xml


// File: Credential_8h.xml


// File: CredentialStore_8h.xml


// File: DataBuffer_8h.xml


// File: DataCallback_8h.xml


// File: DataHandle_8h.xml


// File: DataMover_8h.xml


// File: DataPoint_8h.xml


// File: DataPointDirect_8h.xml


// File: DataPointIndex_8h.xml


// File: DataSpeed_8h.xml


// File: DataStatus_8h.xml


// File: DateTime_8h.xml


// File: DateTimeAttribute_8h.xml


// File: DBInterface_8h.xml


// File: DBranch_8h.xml


// File: DelegationInterface_8h.xml


// File: DenyOverridesAlg_8h.xml


// File: EqualFunction_8h.xml


// File: EvaluationCtx_8h.xml


// File: Evaluator_8h.xml


// File: EvaluatorLoader_8h.xml


// File: ExecutionTarget_8h.xml


// File: file__access_8h.xml


// File: FileAccess_8h.xml


// File: FileCache_8h.xml


// File: FileCacheHash_8h.xml


// File: FileInfo_8h.xml


// File: FileLock_8h.xml


// File: FileUtils_8h.xml


// File: FinderLoader_8h.xml


// File: FnFactory_8h.xml


// File: Function_8h.xml


// File: GenericAttribute_8h.xml


// File: GlobusErrorUtils_8h.xml


// File: GlobusWorkarounds_8h.xml


// File: GSSCredential_8h.xml


// File: GUID_8h.xml


// File: HakaClient_8h.xml


// File: InfoCache_8h.xml


// File: InfoFilter_8h.xml


// File: InfoRegister_8h.xml


// File: InformationInterface_8h.xml


// File: IniConfig_8h.xml


// File: InRangeFunction_8h.xml


// File: IntraProcessCounter_8h.xml


// File: IString_8h.xml


// File: Job_8h.xml


// File: JobController_8h.xml


// File: JobDescription_8h.xml


// File: JobDescriptionParser_8h.xml


// File: JobState_8h.xml


// File: JobSupervisor_8h.xml


// File: listfunc_8h.xml
%feature("docstring")  listjoin "char** listjoin(char **base, char
**addon, int size) ";

%feature("docstring")  listadd "char** listadd(char **vect, char
*data, int size) ";

%feature("docstring")  listfree "void listfree(char **vect, freefn f)
";


// File: Loader_8h.xml


// File: Logger_8h.xml


// File: MatchFunction_8h.xml


// File: MCC_8h.xml


// File: MCC__Status_8h.xml


// File: MCCLoader_8h.xml


// File: Message_8h.xml


// File: MessageAttributes_8h.xml


// File: MessageAuth_8h.xml


// File: ModuleManager_8h.xml


// File: MysqlWrapper_8h.xml


// File: OAuthConsumer_8h.xml


// File: OpenIdpClient_8h.xml


// File: OpenSSL_8h.xml


// File: OptionParser_8h.xml


// File: OrderedAlg_8h.xml


// File: PayloadRaw_8h.xml


// File: PayloadSOAP_8h.xml


// File: PayloadStream_8h.xml


// File: PayloadWSRF_8h.xml


// File: PDP_8h.xml


// File: PermitOverridesAlg_8h.xml


// File: Plexer_8h.xml


// File: Plugin_8h.xml


// File: Policy_8h.xml


// File: PolicyParser_8h.xml


// File: PolicyStore_8h.xml


// File: Profile_8h.xml


// File: Proxycertinfo_8h.xml


// File: RegisteredService_8h.xml


// File: Request_8h.xml


// File: RequestAttribute_8h.xml


// File: RequestItem_8h.xml


// File: Response_8h.xml


// File: Result_8h.xml


// File: Run_8h.xml


// File: SAML2LoginClient_8h.xml


// File: saml__util_8h.xml


// File: SAMLToken_8h.xml


// File: SecAttr_8h.xml


// File: SecAttrValue_8h.xml


// File: SecHandler_8h.xml


// File: Security_8h.xml


// File: Service_8h.xml


// File: SOAPEnvelope_8h.xml


// File: SOAPMessage_8h.xml


// File: Software_8h.xml


// File: Source_8h.xml


// File: StringAttribute_8h.xml


// File: StringConv_8h.xml


// File: Submitter_8h.xml


// File: TargetGenerator_8h.xml


// File: TargetRetriever_8h.xml


// File: Thread_8h.xml


// File: URL_8h.xml


// File: URLMap_8h.xml


// File: User_8h.xml


// File: UserConfig_8h.xml


// File: UsernameToken_8h.xml


// File: Utils_8h.xml


// File: VOMSAttribute_8h.xml


// File: VOMSUtil_8h.xml


// File: win32_8h.xml
%feature("docstring")  readlink "ssize_t readlink(const char *path,
char *buf, size_t bufsiz) ";

%feature("docstring")  mkdir "int mkdir(const char *pathname, mode_t
mode) ";

%feature("docstring")  link "int link(const char *oldpath, const char
*newpath) ";

%feature("docstring")  lstat "int lstat(const char *path, struct stat
*buf) ";

%feature("docstring")  GetOsErrorMessage "std::string
GetOsErrorMessage(void) ";


// File: WSA_8h.xml


// File: WSResourceProperties_8h.xml


// File: WSRF_8h.xml


// File: WSRFBaseFault_8h.xml


// File: X500NameAttribute_8h.xml


// File: X509Token_8h.xml


// File: XmlContainer_8h.xml


// File: XmlDatabase_8h.xml


// File: XMLNode_8h.xml


// File: XMLSecNode_8h.xml


// File: XmlSecUtils_8h.xml


// File: dir_67e50d7332df85903103db4dbf8caa68.xml


// File: dir_f0253c6719721b8d574d924518c8d61f.xml


// File: dir_692f72c1c0d412bdd9a8c76ea8358826.xml


// File: dir_6cf44e8c635dbdffe7693d232daf8055.xml


// File: dir_7eea884da56cc169f3e48703cb14c46f.xml


// File: dir_719c6f78603520a8380782f4b2588843.xml


// File: dir_096e79371e217c8e28bb04bbc1863341.xml


// File: dir_020155580c93a7b5cb52efaf90b2ba1e.xml


// File: dir_9cd3f82e4c22427652796d3839f7eb0f.xml


// File: dir_6a7a4c0bf5901d3dc394018db1b96120.xml


// File: dir_9ac7a5ba0c1a41d9646b9c51950ff5d2.xml


// File: dir_6fa7dd6cf445e9f0f57e027c0515a72c.xml


// File: dir_7ed6ea0ec1691280ec8756c1de26c84e.xml


// File: dir_fc6ecfe2d120e3436e0c2f45227c4853.xml


// File: dir_e4521bdabbebd500e9696a8f0915d53b.xml


// File: dir_7bcd90e157f7913ce119de2bc28640d4.xml


// File: dir_564080859a04bd794196aa17e198251c.xml


// File: dir_f6ca9067b2d9fac28074df29e853717c.xml


// File: dir_6aec4f404e9b6512f22d7b83c2fc24db.xml


// File: dir_262b0464ac38aa433cceb5ea6dc0bb44.xml


// File: dir_197051bc23b8e0b908f31e871448aa20.xml


// File: dir_4485b7dc64242d089f2044db966ba22b.xml


// File: dir_47631b3032d8a853201a2214453720ee.xml


// File: dir_e68f7c762699a62b3a7d41e8fb1f9c8c.xml


// File: dir_7612dbcec3c827a6ebc03c6b135ae4c7.xml


// File: dir_13b8e51da478a7dde2beccf685f118c1.xml


// File: dir_f064b0baab145255f02dd1f299c8d01c.xml


// File: dir_9e0692c0dd4d30485a91f33b6b9cf1ad.xml

