#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <utmp.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "lib.h"

#define S(a,b)		str_copy(a,b)
#define SN(a,b,c)	str_copynz(a,b,c)
#define N(a,b,c,d)	fmt_nmb_(a,b,c,d)

int main(int argc, char **argv) {
  struct utmp ut;
  struct tm *tm;
  struct in_addr in;
  time_t tmp_time;
  char buf[1024];
  char *addr,*p;
  int fd=0;

  if (argc>1) {
    fd = open(argv[1], O_RDONLY);
    if (fd == -1) { write(1,buf,S(buf,"error open()\n")); _exit(1); }
  }
  write(1,buf,S(buf,"type  pid     id    user line host ip date "
		"[term exit]\n"));

  while(utmp_io(fd, &ut, F_RDLCK)) {
    tmp_time = ut.ut_tv.tv_sec;
    tmp_time += get_tz(tmp_time);
    tm=nv_gmtime(&tmp_time);
    in.s_addr = ut.ut_addr;
    addr = inet_ntoa(in);

    p = buf;
    *p++ = '[';
    p += N(p, ut.ut_type, 1,0);         p +=S(p,"] [");
    p += N(p, ut.ut_pid,  5,0);         p +=S(p,"] [");
    p += fmt_str_(p,ut.ut_id,4);        p +=S(p,"] [");
    p += SN(p, ut.ut_user,UT_NAMESIZE); p +=S(p,"] [");
    p += SN(p, ut.ut_line,UT_LINESIZE); p +=S(p,"] [");
    p += SN(p, ut.ut_host,UT_HOSTSIZE); p +=S(p,"] [");
    p += SN(p, addr,20);                p +=S(p,"] [");

    p += fmt_ulong(p, (1900 +tm->tm_year) % 100);   *p++ = '-';
    p += N(p, 1+tm->tm_mon,2,1);      *p++ = '-';
    p += N(p, tm->tm_mday, 2,1);      *p++ = ' ';
    p += N(p, tm->tm_hour, 2,1);      *p++ = ':';
    p += N(p, tm->tm_min,  2,1);      *p++ = ':';
    p += N(p, tm->tm_sec,  2,1);      

    if (argc>2) {
      p +=S(p,"] [");
      p += fmt_ulong(p,ut.ut_exit.e_termination); *p++ = ' ';
      p += fmt_ulong(p,ut.ut_exit.e_exit);
    }

    p +=S(p,"]\n");
    write(1,buf, p-buf);
  }
  close(fd);
  return 0;
}
