/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgServerAdmin.h: interface for the DlgServerAdmin class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGSERVERADMIN_H
#define DLGSERVERADMIN_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include <wx/dialog.h>
#include <wx/treectrl.h>


#include <PkiClient.h>
#include "DlgGUI.h"


class DlgServerAdminItemData : public wxTreeItemData
{
	public:
		DlgServerAdminItemData(EntityEntryInfo & info):m_info(info)
		{
		}
		EntityEntryInfo & GetInfo()
		{
			return m_info;
		}
	private:
		EntityEntryInfo & m_info;
};



class DlgServerAdminTreeCtrl: public wxTreeCtrl
{
public:
	DlgServerAdminTreeCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos, const wxSize& size, long style);
	void OnTreeItemRightClick(wxTreeEvent& event);
private:
    DECLARE_EVENT_TABLE()
};




class DlgServerAdmin: public DlgGUI
{
public:
	void OnChangePassword(wxCommandEvent &event);
	void OnInitEntity(wxCommandEvent& event);
	DlgServerAdmin(wxWindow * wParent, char * EntityName, char * UserName, char * Password, PkiClient * ClientPki);
	virtual ~DlgServerAdmin();
	
	void OnShowEntityCert(wxCommandEvent& event);
	void OnManageUsers(wxCommandEvent& event);
	void OnAddPkiEntity(wxCommandEvent& event);
	void OnAddCaEntity(wxCommandEvent& event);
	void OnAddEEEntity(wxCommandEvent& event);
	void OnAddRaEntity(wxCommandEvent& event);
	void OnAddRepositoryEntity(wxCommandEvent& event);
	void OnAddKeyStoreEntity(wxCommandEvent& event);
	void OnAddPublicationEntity(wxCommandEvent& event);
	void OnTreeItemRightClick(wxTreeEvent& event);
	void OnDelEntity(wxCommandEvent& event);
	void OnLoadEntity(wxCommandEvent& event);
	void OnUnloadEntity(wxCommandEvent& event);
	void OnReload(wxCommandEvent& event);

private:
	bool ReloadConf();
	int ServerIconId;
	int UnknownIconId;
	int PkiIconId;
	int CaIconId;
	int RaIconId;
	int RepositoryIconId;
	int KeyIconId;
	int PublicationIconId;
	int EEIconId;
	int UnloadedIconId;
	
	bool LoadEntitiesList();
	wxTreeCtrl * m_treeCtrl;
	wxImageList * m_imageListSmall;
	mVector<EntityEntryInfo> entities;

	DECLARE_EVENT_TABLE()
};

#endif
