// This file is generated by kconfig_compiler from 802-1x.kcfg.
// All changes you do to this file will be lost.

#include "802-1x.h"

using namespace Knm;

Security8021xSetting::Security8021xSetting() : Setting(Setting::Security8021x),
    mPhase1peapver(0), mPhase2auth(0), mPhase2autheap(0), mEnabled(false), mPasswordflags(Setting::AgentOwned), mPrivatekeypasswordflags(Setting::AgentOwned), mPhase2privatekeypasswordflags(Setting::AgentOwned)
{
}

Security8021xSetting::Security8021xSetting(Security8021xSetting *setting) : Setting(setting)
{
    setEap(setting->eap());
    setIdentity(setting->identity());
    setAnonymousidentity(setting->anonymousidentity());
    setCacert(setting->cacert());
    setCapath(setting->capath());
    setSubjectmatch(setting->subjectmatch());
    setAltsubjectmatches(setting->altsubjectmatches());
    setClientcert(setting->clientcert());
    setClientcertpath(setting->clientcertpath());
    setPhase1peapver(setting->phase1peapver());
    setPhase1peaplabel(setting->phase1peaplabel());
    setPhase1fastprovisioning(setting->phase1fastprovisioning());
    setPhase2auth(setting->phase2auth());
    setPhase2autheap(setting->phase2autheap());
    setPhase2cacert(setting->phase2cacert());
    setPhase2capath(setting->phase2capath());
    setPhase2subjectmatch(setting->phase2subjectmatch());
    setPhase2altsubjectmatches(setting->phase2altsubjectmatches());
    setPhase2clientcert(setting->phase2clientcert());
    setPhase2clientcertpath(setting->phase2clientcertpath());
    setPassword(setting->password());
    setPasswordflags(setting->passwordflags());
    setPrivatekey(setting->privatekey());
    setPrivatekeypath(setting->privatekeypath());
    setPrivatekeypassword(setting->privatekeypassword());
    setPrivatekeypasswordflags(setting->privatekeypasswordflags());
    setPhase2privatekey(setting->phase2privatekey());
    setPhase2privatekeypath(setting->phase2privatekeypath());
    setPhase2privatekeypassword(setting->phase2privatekeypassword());
    setPhase2privatekeypasswordflags(setting->phase2privatekeypasswordflags());
    setUseSystemCaCerts(setting->useSystemCaCerts());
    setEnabled(setting->enabled());
}

Security8021xSetting::~Security8021xSetting()
{
}

QString Security8021xSetting::name() const
{
    return QLatin1String("802-1x");
}

QByteArray Security8021xSetting::getBytes(const QString & fileName)
{
    QByteArray bytes;
    QFile file(fileName);

    if (file.open(QIODevice::ReadOnly)) {
        bytes = file.readAll();
    }
    return bytes;
}

QMap<QString,QString> Security8021xSetting::secretsToMap() const
{
    QMap<QString,QString> map;
    if (passwordflags().testFlag(Setting::AgentOwned)) {
        map.insert(QLatin1String("password"), password());
    }
    if (privatekeypasswordflags().testFlag(Setting::AgentOwned)) {
        map.insert(QLatin1String("private-key-password"), privatekeypassword());
    }
    if (phase2privatekeypasswordflags().testFlag(Setting::AgentOwned)) {
        map.insert(QLatin1String("phase2-private-key-password"), phase2privatekeypassword());
    }
    return map;
}

void Security8021xSetting::secretsFromMap(QMap<QString,QString> secrets)
{
    setPassword(secrets.value("password"));
    setPrivatekeypassword(secrets.value("private-key-password"));
    setPhase2privatekeypassword(secrets.value("phase2-private-key-password"));
}

QStringList Security8021xSetting::needSecrets() const
{
    QStringList list;
    if (enabled()) {
        Security8021xSetting::EapMethods eap = eapFlags();
        if (eap.testFlag(Security8021xSetting::tls) && privatekeypassword().isEmpty() && !privatekeypasswordflags().testFlag(Setting::NotRequired)) {
            list.append("private-key-password");
        } else if ((eap.testFlag(Security8021xSetting::peap) || eap.testFlag(Security8021xSetting::ttls) || eap.testFlag(Security8021xSetting::leap))
            && password().isEmpty() && !passwordflags().testFlag(Setting::NotRequired)) {
            list.append("password");
        }
        if ((phase2auth() == EnumPhase2auth::tls || phase2autheap() == EnumPhase2autheap::tls) && phase2privatekeypassword().isEmpty()
            && !phase2privatekeypasswordflags().testFlag(Setting::NotRequired)) {
            list.append("phase2-private-key-password");
        }
    }
    return list;
}

bool Security8021xSetting::hasPersistentSecrets() const
{
    if (enabled()) {
        Security8021xSetting::EapMethods eap = eapFlags();
        if (eap.testFlag(Security8021xSetting::tls) && (privatekeypasswordflags().testFlag(Setting::None) || privatekeypasswordflags().testFlag(Setting::AgentOwned))) {
            return true;
        } else if ((eap.testFlag(Security8021xSetting::peap) || eap.testFlag(Security8021xSetting::ttls) || eap.testFlag(Security8021xSetting::leap))
            && (passwordflags().testFlag(Setting::None) || passwordflags().testFlag(Setting::AgentOwned))) {
            return true;
        }
        if ((phase2auth() == EnumPhase2auth::tls || phase2autheap() == EnumPhase2autheap::tls)
            && (phase2privatekeypasswordflags().testFlag(Setting::None) || phase2privatekeypasswordflags().testFlag(Setting::AgentOwned))) {
            return true;
        }
    }
    return false;
}
