/* Copyright (C) 2004 Per Johansson
	
	This file is part of netGo.

    netGo is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    netGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with netGo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <qobject.h>
#include <qregexp.h>
#include <qprocess.h>
#include <qpopupmenu.h>
#include <qsettings.h>
#include <qevent.h>

#include "netgodialogbase.h"
#include "process.h"
#include "trayicon.h"

#ifndef NETGODIALOG_H
#define NETGODIALOG_H

// Subclassing netGoDialogBase
class netGoDialog : public netGoDialogBase
{
	Q_OBJECT
			
	public:
		// Constructor for the GUI.
		netGoDialog(QWidget *parent, const char *name);
		
		// Constructor for the commandline mode.
		netGoDialog(QString profile);

	public slots:
		void mainPage();
		void addProfilePage();
		void morePage();		
		void runProfilePage();
		void editProfilePage();
		void editMorePage();
		void deleteProfilePage();
		
		void enableMainGoBut();
		void enableEditProfileBut();
		void enableDeleteProfileBut();
		void onDhcp(const QString &text);
		void onDhcpEdit(const QString &text);
		void onAsciiCheck();
		void onHexCheck();
		void onOffCheck();
		void onEditAsciiCheck();
		void onEditHexCheck();
		void onEditOffCheck();
		void openScript();	
		void editOpenScript();	

		void addProfile();
		void deleteProfile(const QString &profile);
		void editProfile();
		
		void fillEditProfilePage();
		void clearAddProfile();
		void updateProfiles();
		void cancelRunProfile();
		
		void cmdlineExecution(const char *profile);
		void exitCmdline();
		void updateIfaces();
		
		void runFromTray(int id);
		void updateTrayProfiles();
		void updateTray();
		void initTray();
		void showOrHide();
		
		void closeEvent(QCloseEvent *ce);
	
	private:
		// The process object that executes the network settings.
		Process *networkProc;
		QProcess *fetchIfaces;
		
		// QSettings object used for storing profiles and paths.
		QSettings *settings;
		
		// Variables used for the systray.
		QPopupMenu *trayMenu, *profileMenu;
		TrayIcon *tray;
		
		// Regular expressions.
		QRegExp common;
		QRegExp ip;
		QRegExp ipOrDhcp;
		QRegExp proxy;
		QRegExp ifacesDown;

		// Stringlist containing all the interfaces on the system.
		QStringList ifaces;
};

#endif
