/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __nd_sll_h
#define __nd_sll_h

#include <netdude/nd.h>
#include <netdude/nd_types.h>

struct sll_header
{
  guint16   sll_pkttype;
  guint16   sll_hatype;
  guint16   sll_halen;
  guint8    sll_addr[8];
  guint16   sll_protocol;
};

#define SLL_HEADER_LEN 16

/* These are the implementations of ND_Protocol's callbacks: */
GtkWidget *nd_sll_create_gui(ND_Trace *trace, ND_ProtoInfo *pinf);
void       nd_sll_set_gui(const ND_Packet *packet, ND_ProtoInfo *pinf);
void       nd_sll_init_packet(ND_Packet *packet, guchar *data, guchar *data_end);
gboolean   nd_sll_header_complete(const ND_Packet *packet, guint nesting);

/* Generic accessor function for the protocol implementation: */
ND_Protocol *nd_sll_get(void);

/* Helper functions to set a trace's GUI table to a packet's content: */
void       nd_sll_set_gui_pkttype(ND_ProtoInfo *pinf, struct sll_header *sllhdr);
void       nd_sll_set_gui_hatype(ND_ProtoInfo *pinf, struct sll_header *sllhdr);
void       nd_sll_set_gui_halen(ND_ProtoInfo *pinf, struct sll_header *sllhdr);
void       nd_sll_set_gui_addr(ND_ProtoInfo *pinf, struct sll_header *sllhdr);
void       nd_sll_set_gui_protocol(ND_ProtoInfo *pinf, struct sll_header *sllhdr);

#endif
