/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: config.h,v 1.41 2009-08-01 09:23:55 anton Exp $ */

// Global includes from standard libraries
#ifndef  NA_CONFIG_H
#define  NA_CONFIG_H

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <time.h>
#include <math.h>
#include <sys/resource.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include <net/if_arp.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
#include <errno.h>
#include <netdb.h>
#include <fcntl.h>
#include <signal.h>
#include <sched.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <pthread.h>
#include <limits.h>
#include <poll.h>
#include <syslog.h>
#include <regex.h>

#ifndef WIPE_OPENSSL
#include <openssl/lhash.h>
#else
#include <glib/ghash.h>
#endif

#define __FAVOR_BSD 	1	//this is dirty hack -D_BSD_SOURCE should work but do not

#include <netinet/tcp.h>
#include <netinet/udp.h>

#include <net/if.h>
#include <netinet/if_ether.h>

#ifdef LINUX
#include <netinet/ether.h>
#include <sys/statvfs.h>
#define statvfs_name_local statvfs
#endif

#ifdef SOLARIS

#include <sys/loadavg.h>
#include <sys/statvfs.h>

#define statvfs_name_local statvfs

typedef void (*sig_t)(int);

typedef unsigned char           u_int8_t;
typedef unsigned short          u_int16_t;
typedef unsigned int            u_int32_t;
typedef unsigned long long      u_int64_t;

#define TIMEVAL_TO_TIMESPEC(tv, ts)                                     \
        do {                                                            \
                (ts)->tv_sec = (tv)->tv_sec;                            \
                (ts)->tv_nsec = (tv)->tv_usec * 1000;                   \
        } while (0)
#define IP_OFFMASK		0x1fff
#define ETHER_ADDR_LEN		6
#define ETHER_TYPE_LEN		2
#define ETHER_HDR_LEN		(ETHER_ADDR_LEN*2+ETHER_TYPE_LEN)

#ifdef USE_TICKS
//Solaris needs this defines for cycle.h
#define HAVE_GETHRTIME
#define HAVE_HRTIME_T
#endif

#ifndef timeradd
#define timeradd(tvp, uvp, vvp)                                         \
        do {                                                            \
                (vvp)->tv_sec = (tvp)->tv_sec + (uvp)->tv_sec;          \
                (vvp)->tv_usec = (tvp)->tv_usec + (uvp)->tv_usec;       \
                if ((vvp)->tv_usec >= 1000000) {                        \
                        (vvp)->tv_sec++;                                \
                        (vvp)->tv_usec -= 1000000;                      \
                }                                                       \
        } while (0)
#define timersub(tvp, uvp, vvp)                                         \
        do {                                                            \
                (vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;          \
                (vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;       \
                if ((vvp)->tv_usec < 0) {                               \
                        (vvp)->tv_sec--;                                \
                        (vvp)->tv_usec += 1000000;                      \
                }                                                       \
        } while (0)
#endif /* timeradd */

#endif /* solaris */

#if defined(FREEBSD) || defined(OPENBSD) || defined(NETBSD)
	#include <sys/param.h>
	#include <sys/event.h>
	#include <sys/sysctl.h>
	#include <net/if_dl.h>
	#include <net/if_types.h>
	#include <net/route.h>
	#include <sys/mount.h>
	#include <rpc/rpc.h>
#define statvfs_name_local statfs
#endif

//since OpenBSD have broken libpcap
#if defined(OPENBSD)
#define PCAP_NEED_POLL
#endif

#if __GNUC__ == 2
#define OLD_GCC
#endif

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#endif
