/********************************************************************************
 *                              Nepenthes
 *                        - finest collection -
 *
 *
 *
 * Copyright (C) 2005  Paul Baecher & Markus Koetter
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact nepenthesdev@users.sourceforge.net  
 *
 *******************************************************************************/

 /* $Id: vuln-realvnc.hpp 561 2006-06-02 10:41:21Z common $ */

#include "DialogueFactory.hpp"
#include "Module.hpp"
#include "ModuleManager.hpp"
#include "SocketManager.hpp"
#include "Nepenthes.hpp"
#include "Dialogue.hpp"
#include "Socket.hpp"

using namespace std;

namespace nepenthes
{

	class Buffer;

	class VulnRealVNC : public Module , public DialogueFactory
	{
	public:
		VulnRealVNC(Nepenthes *);
		~VulnRealVNC();
		Dialogue *createDialogue(Socket *socket);
		bool Init();
		bool Exit();
	};

	typedef enum
	{
		VNC_HANDSHAKE,
		VNC_AUTH,
		VNC_SHARED_DESKTOP,
		VNC_ONLINE

	} realvnc_state;

	class RealVNCDialogue : public Dialogue
	{
	public:
		RealVNCDialogue(Socket *socket);
		~RealVNCDialogue();
		ConsumeLevel incomingData(Message *msg);
		ConsumeLevel outgoingData(Message *msg);
		ConsumeLevel handleTimeout(Message *msg);
		ConsumeLevel connectionLost(Message *msg);
		ConsumeLevel connectionShutdown(Message *msg);

	protected:
		Buffer *m_Buffer;
		realvnc_state m_State;

		bool m_sendimage;

		string m_TypedChars;

	};

}
extern nepenthes::Nepenthes *g_Nepenthes;

unsigned char vnc_image[] = {
0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x0c, 0x00, 0x15, 0xff, 0xff, 0xff, 0x11, 
0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 
0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 
0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 
0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 
0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 
0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3f, 0x3f, 0x3f, 0x00, 0x3f, 0x3f, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 
0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 
0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x00, 
0xe0, 0x00, 0xf0, 0x00, 0xf8, 0x00, 0xfc, 0x00, 
0xfe, 0x00, 0xff, 0x00, 0xff, 0x80, 0xff, 0xc0, 
0xff, 0xe0, 0xff, 0xf0, 0xff, 0x00, 0xff, 0x00, 
0xe7, 0x80, 0xc7, 0x80, 0x83, 0xc0, 0x03, 0xc0, 
0x01, 0xe0, 0x01, 0xe0, 0x00, 0xc0, 0x00, 0x00, 
0x00, 0x00, 0x04, 0x3a, 0x02, 0xff, 0x00, 0x00, 
0x00, 0x10, 0x00, 0x00, 0x17, 0xb2,
0x78, 0x9c, 0x7c, 0x92, 0xeb, 0x6e, 0xd3, 0x40, 
0x10, 0x85, 0x77, 0x67, 0xf6, 0xe2, 0x4d, 0xfc, 
0x2b, 0xb4, 0x06, 0xa9, 0x3f, 0x10, 0x02, 0x41, 
0xd2, 0x14, 0x45, 0x48, 0x15, 0xa4, 0x01, 0xb5, 
0xbc, 0x0a, 0x6f, 0x32, 0x8d, 0x1c, 0xb7, 0xe1, 
0xf6, 0x98, 0xbc, 0x86, 0x3b, 0x67, 0xd7, 0xee, 
0x25, 0x20, 0x64, 0x7b, 0xe7, 0xec, 0x77, 0xce, 
0xec, 0xae, 0x2d, 0xff, 0x6e, 0x4e, 0x97, 0xab, 
0xab, 0xf9, 0xe5, 0xe2, 0xe4, 0x65, 0x9c, 0x6d, 
0x8e, 0xa4, 0x5f, 0x5b, 0x92, 0x2f, 0x96, 0x99, 
0x64, 0x63, 0xd9, 0x39, 0xad, 0x1f, 0x76, 0xc1, 
0x72, 0x0b, 0xb2, 0xf2, 0x9d, 0x8b, 0xa0, 0x55, 
0xc5, 0x70, 0xde, 0xfb, 0x10, 0x6e, 0xc8, 0x67, 
0xc2, 0x6c, 0x72, 0xfa, 0xcc, 0x3f, 0x42, 0x29, 
0x99, 0x1c, 0x5c, 0xfa, 0x10, 0xe3, 0x00, 0x53, 
0xda, 0x12, 0xa2, 0x19, 0x2a, 0x6b, 0xe9, 0xd6, 
0x4f, 0x9c, 0x76, 0x03, 0x20, 0xc3, 0xda, 0x63, 
0x6e, 0x35, 0xc3, 0x86, 0x90, 0xd2, 0x1d, 0x89, 
0xa6, 0x5b, 0x9e, 0x56, 0x53, 0xad, 0x7a, 0xcb, 
0x62, 0x77, 0x2c, 0x73, 0xdf, 0x62, 0x70, 0x5d, 
0x55, 0x87, 0x50, 0xe3, 0xea, 0xa8, 0xce, 0x60, 
0x56, 0x87, 0x5c, 0x09, 0x44, 0xbd, 0x8e, 0xb3, 
0x99, 0x59, 0x2c, 0xe1, 0x2e, 0xc8, 0x42, 0x67, 
0xd9, 0xa8, 0xd0, 0x8c, 0xa9, 0x6a, 0x0f, 0x8d, 
0xc0, 0xc8, 0x4a, 0xc4, 0x8d, 0x38, 0x23, 0x2a, 
0x2b, 0x86, 0x92, 0x52, 0x78, 0x8a, 0xde, 0x30, 
0x66, 0xb0, 0xa9, 0x3a, 0xa0, 0x58, 0xef, 0x20, 
0x58, 0x0f, 0xc7, 0xaa, 0xc7, 0x7d, 0xee, 0xbb, 
0x07, 0x54, 0xc2, 0x35, 0x3e, 0x46, 0x78, 0x00, 
0xc3, 0x3b, 0x2a, 0xfd, 0x39, 0x93, 0xe5, 0xee, 
0x99, 0x9c, 0xfd, 0x9a, 0x49, 0xdf, 0x37, 0xad, 
0xd3, 0xef, 0x76, 0xd2, 0xb2, 0xbc, 0x70, 0xf2, 
0xca, 0x09, 0x39, 0x79, 0xee, 0xc4, 0x39, 0x63, 
0x5a, 0xd6, 0x87, 0x50, 0x85, 0x5a, 0x52, 0x24, 
0xec, 0xa4, 0x01, 0x45, 0x07, 0x1d, 0x0e, 0x70, 
0x11, 0xc8, 0xcd, 0x99, 0xb6, 0xf7, 0xf5, 0x6f, 
0x0f, 0xaa, 0xd4, 0x08, 0x4b, 0xeb, 0xd1, 0x63, 
0xf3, 0x70, 0x61, 0x95, 0x88, 0x60, 0xc5, 0x87, 
0x83, 0x15, 0x8c, 0xa3, 0xe9, 0x11, 0xdf, 0x38, 
0xf9, 0xac, 0xb2, 0xef, 0xfb, 0x6f, 0x3f, 0x9a, 
0xf9, 0x72, 0xe1, 0x57, 0x57, 0x97, 0x06, 0x7f, 
0x63, 0xbf, 0xbd, 0x66, 0xd9, 0x90, 0x61, 0xb6, 
0x4e, 0x2e, 0xfc, 0x20, 0xd6, 0x01, 0x0a, 0x82, 
0x48, 0x15, 0x84, 0xb5, 0x50, 0xb0, 0x22, 0x54, 
0x25, 0xeb, 0x18, 0xb9, 0xa8, 0x4f, 0x31, 0x29, 
0xcb, 0xf2, 0x63, 0x8a, 0xd1, 0x6e, 0x07, 0xa6, 
0xb6, 0xc6, 0x6e, 0x28, 0xd9, 0x6a, 0x22, 0xeb, 
0x14, 0x53, 0xb2, 0x13, 0x15, 0xea, 0x24, 0x1e, 
0x45, 0x9a, 0x14, 0x2b, 0x66, 0x11, 0xf7, 0x6c, 
0xc7, 0x79, 0x16, 0xa5, 0x09, 0x64, 0x4f, 0xa8, 
0x7b, 0x87, 0xf1, 0xda, 0xeb, 0xf0, 0xdd, 0xeb, 
0xe9, 0xbf, 0x06, 0xa9, 0x82, 0x9c, 0x07, 0xb9, 
0xe8, 0xf4, 0x95, 0xc7, 0x27, 0x0c, 0x92, 0xe5, 
0x5d, 0x30, 0x41, 0x08, 0xb7, 0x29, 0xaa, 0x4c, 
0x5f, 0x77, 0x0c, 0xd1, 0x39, 0xa5, 0x18, 0xc0, 
0xde, 0x0e, 0x9e, 0x43, 0x75, 0x4f, 0xd0, 0x3f, 
0xba, 0x4d, 0x08, 0x4f, 0xf6, 0xca, 0x86, 0x7e, 
0xde, 0x3f, 0xb6, 0xf9, 0xdf, 0x75, 0x07, 0x00, 
0x00, 0xff, 0xff, 0x94, 0x55, 0x51, 0x6f, 0xd3, 
0x40, 0x0c, 0xf6, 0xf9, 0xce, 0x69, 0x7a, 0x4d, 
0x2e, 0xc9, 0xd8, 0xf6, 0x30, 0x86, 0x78, 0x1a, 
0x6c, 0xab, 0xb6, 0x89, 0x07, 0x58, 0xb5, 0x49, 
0x43, 0xe2, 0xff, 0xf0, 0x1b, 0xf0, 0x5a, 0x2a, 
0x94, 0xed, 0xa5, 0xe2, 0x57, 0xf2, 0x27, 0x50, 
0xf9, 0x7c, 0x4d, 0x59, 0x87, 0x04, 0x12, 0x72, 
0x62, 0xdf, 0x7d, 0xf6, 0xd9, 0x4e, 0xee, 0xce, 
0xfe, 0x7e, 0x78, 0x70, 0x3e, 0xbd, 0xfb, 0xb8, 
0xe7, 0x8e, 0x5e, 0xbe, 0xbe, 0x3a, 0x8d, 0xfb, 
0x27, 0x74, 0x66, 0xab, 0x3e, 0xbb, 0xf9, 0x0b, 
0x3d, 0xc3, 0xd5, 0x5c, 0x88, 0xf8, 0x1d, 0x32, 
0xec, 0xeb, 0x44, 0xc2, 0x86, 0x6c, 0x66, 0x15, 
0x03, 0x27, 0xae, 0xf8, 0x16, 0x31, 0xe3, 0x05, 
0xb6, 0xb8, 0x1c, 0x7b, 0x1f, 0x8d, 0x7a, 0x33, 
0x67, 0x86, 0x09, 0x8d, 0x1f, 0xf8, 0x11, 0x50, 
0x6f, 0x4b, 0xe6, 0x6c, 0x40, 0x7c, 0x0c, 0x0f, 
0xec, 0x7b, 0x3f, 0x00, 0xa5, 0x01, 0x31, 0x5a, 
0x01, 0x29, 0xc7, 0x7f, 0x35, 0xf2, 0xf1, 0xd1, 
0x03, 0xd8, 0x35, 0x2a, 0xe1, 0x7a, 0x02, 0x2c, 
0x66, 0xdf, 0x15, 0x67, 0x33, 0xff, 0x10, 0xb6, 
0xd1, 0xb8, 0x02, 0x82, 0x5d, 0xdd, 0xa4, 0xe4, 
0x73, 0x4e, 0x15, 0x57, 0x3e, 0xf4, 0xe6, 0x07, 
0xd4, 0x17, 0x5b, 0xab, 0x3e, 0xd5, 0x39, 0xe1, 
0x8a, 0x43, 0x2f, 0xe5, 0xb8, 0xec, 0x43, 0x6d, 
0x51, 0x68, 0xce, 0x88, 0xa2, 0xb3, 0x44, 0xcc, 
0xc1, 0x4f, 0xc2, 0x33, 0xd2, 0x69, 0xa2, 0x8a, 
0x17, 0xa3, 0xf9, 0x48, 0x4f, 0x9d, 0x6f, 0xd2, 
0x6a, 0x0f, 0x92, 0xbd, 0xa3, 0x36, 0xb5, 0xd4, 
0x24, 0xb7, 0x1a, 0x25, 0xe7, 0x00, 0xa1, 0xb0, 
0x35, 0xe4, 0xda, 0x36, 0x35, 0xd4, 0x75, 0xde, 
0xfe, 0x9e, 0xef, 0x1a, 0x4b, 0x85, 0x18, 0x7f, 
0xd8, 0xe3, 0x48, 0xaf, 0x38, 0x25, 0xe8, 0x57, 
0xde, 0xac, 0x2b, 0x12, 0x94, 0xc5, 0x81, 0xcc, 
0x5a, 0x70, 0x59, 0x4e, 0x1d, 0x14, 0x16, 0x43, 
0xee, 0x3d, 0x39, 0x23, 0x3d, 0x6b, 0x1d, 0x85, 
0xb6, 0x43, 0xdd, 0x6c, 0x1c, 0x23, 0x2e, 0x3e, 
0xdf, 0x79, 0xd7, 0xe9, 0x79, 0xeb, 0x7c, 0x4b, 
0xb0, 0x0a, 0x8d, 0x70, 0xc3, 0xe2, 0x33, 0xae, 
0x53, 0x04, 0x61, 0xa6, 0x86, 0x06, 0x5b, 0x24, 
0x85, 0x9a, 0xde, 0x12, 0x74, 0x02, 0x43, 0x61, 
0x2f, 0x06, 0x3a, 0xbd, 0x6c, 0x5d, 0xe7, 0x3b, 
0xb8, 0xec, 0x78, 0x20, 0xbd, 0x6a, 0x6d, 0xb3, 
0xad, 0x2d, 0x58, 0x81, 0xef, 0x74, 0xfd, 0x43, 
0xf4, 0xbd, 0x88, 0x16, 0xa2, 0x51, 0x48, 0xf4, 
0xed, 0x66, 0x5c, 0x89, 0xbe, 0x11, 0xa2, 0xfc, 
0x08, 0x2d, 0x71, 0x34, 0x96, 0x6c, 0x63, 0xe3, 
0x78, 0x45, 0x5f, 0x0d, 0x5a, 0x7b, 0x95, 0x65, 
0x60, 0x59, 0xa8, 0x7f, 0x52, 0xdb, 0x14, 0x8a, 
0x65, 0x18, 0x74, 0x19, 0x38, 0x5e, 0xca, 0x6f, 
0x8d, 0x68, 0xd8, 0x30, 0xe3, 0xc7, 0xb6, 0x76, 
0x47, 0x35, 0xb8, 0x7c, 0xae, 0x7b, 0x4a, 0xc6, 
0xa2, 0xe7, 0x91, 0xde, 0xe5, 0xe7, 0xcb, 0xea, 
0xf0, 0xfc, 0x60, 0x8a, 0x0a, 0xe4, 0x70, 0x0b, 
0xe2, 0xd1, 0xc9, 0x7e, 0xbe, 0x04, 0x9f, 0xee, 
0x99, 0xf5, 0x16, 0x5f, 0x8b, 0x06, 0x79, 0x93, 
0xb7, 0x0c, 0xd7, 0x7a, 0x34, 0x42, 0x45, 0x82, 
0x2c, 0x89, 0xca, 0x2c, 0x4b, 0x1a, 0xff, 0x21, 
0xe3, 0xae, 0x9c, 0x4c, 0xfe, 0x6f, 0x5e, 0x6e, 
0xe6, 0xb7, 0x55, 0x74, 0x98, 0x49, 0x14, 0x6f, 
0xb2, 0x9e, 0x73, 0x82, 0x28, 0x0a, 0xf0, 0xdb, 
0x3a, 0x15, 0x84, 0x8c, 0x8a, 0xa2, 0x2e, 0x6a, 
0xbd, 0x49, 0xd4, 0x78, 0x09, 0x49, 0x67, 0x0b, 
0x6c, 0xb3, 0xc9, 0x9a, 0xb8, 0x26, 0x2c, 0x9a, 
0x31, 0xd5, 0x8c, 0x43, 0xa5, 0x33, 0xcf, 0x4d, 
0xed, 0x18, 0x03, 0x76, 0x35, 0xac, 0x0d, 0x99, 
0x73, 0xdd, 0x48, 0xd2, 0xeb, 0xda, 0x41, 0x63, 
0x47, 0xe3, 0x9a, 0x71, 0x2a, 0x14, 0x1f, 0xbc, 
0xfe, 0x19, 0xf4, 0x2e, 0x68, 0x11, 0xf4, 0x43, 
0xe6, 0xef, 0x72, 0xed, 0x1e, 0x7a, 0x0b, 0x5b,
0x7b, 0xb9, 0xd8, 0xf4, 0x03, 0x30, 0x94, 0x80, 
0x8b, 0x6d, 0x8d, 0xcf, 0x2d, 0xe2, 0x32, 0x3c, 
0x75, 0x1b, 0xf4, 0x81, 0xab, 0xb0, 0xdb, 0x7c, 
0xf4, 0x62, 0xeb, 0xca, 0x9a, 0x52, 0x30, 0x57, 
0xeb, 0xe9, 0xbf, 0xcb, 0xd3, 0x2f, 0x00, 0x00, 
0x00, 0xff, 0xff, 0x7c, 0x56, 0x4d, 0x53, 0xdb, 
0x30, 0x10, 0x95, 0xd6, 0x92, 0xbd, 0x92, 0xf1, 
0xb7, 0x1c, 0x0a, 0x21, 0xe5, 0x44, 0x27, 0x84, 
0x42, 0xe0, 0x50, 0x72, 0x6a, 0xb8, 0xf7, 0x57, 
0x09, 0x86, 0x74, 0x0a, 0x33, 0xb8, 0x0c, 0x70, 
0xe0, 0xd4, 0x7f, 0xd1, 0xdf, 0xd7, 0xbe, 0x35, 
0x69, 0x6f, 0x6d, 0x94, 0x89, 0x76, 0x9e, 0x9f, 
0xd7, 0xde, 0xcd, 0xee, 0x5b, 0xfd, 0x98, 0xec, 
0x5d, 0x9d, 0xcd, 0xde, 0xed, 0xbe, 0x0f, 0xfd, 
0x62, 0xff, 0x43, 0x3e, 0x3d, 0x59, 0xf2, 0xe1, 
0x5a, 0x19, 0x94, 0xbd, 0xcd, 0xd2, 0xf9, 0x91, 
0xfc, 0x4b, 0xf8, 0x5c, 0x5e, 0x67, 0xf1, 0x93, 
0x1e, 0xd5, 0x47, 0x6f, 0x20, 0x7b, 0x17, 0xb0, 
0x93, 0xcc, 0x68, 0xbd, 0x49, 0xa0, 0x2b, 0x37, 
0x38, 0x52, 0x68, 0x51, 0x21, 0x6d, 0x2d, 0x33, 
0xbe, 0x29, 0xa4, 0x9d, 0x72, 0x0c, 0x67, 0x41, 
0x35, 0x50, 0x57, 0x94, 0x8c, 0x6c, 0x3a, 0x5f, 
0x91, 0xaa, 0xe3, 0xa2, 0x62, 0x63, 0xde, 0xd0, 
0xb2, 0x28, 0x9b, 0x42, 0xd8, 0x80, 0x8f, 0x2b, 
0x4a, 0x18, 0x7d, 0xb2, 0x85, 0x75, 0x33, 0xd2, 
0x5b, 0xc1, 0xeb, 0x9a, 0x13, 0xde, 0xc2, 0xcc, 
0x23, 0xbf, 0x8c, 0x73, 0xc1, 0xdb, 0x96, 0x8b, 
0x81, 0x1a, 0x2e, 0x1a, 0x3c, 0x55, 0xa1, 0xd9, 
0x16, 0x40, 0xdb, 0x76, 0x48, 0x40, 0xe5, 0xa2, 
0xf8, 0x4a, 0x8e, 0x2b, 0xea, 0xc0, 0xad, 0x6b, 
0xad, 0x73, 0xf1, 0x80, 0x55, 0x34, 0x69, 0x73, 
0x47, 0x2f, 0x24, 0x30, 0x7a, 0xae, 0xef, 0xb7, 
0x68, 0xd2, 0x58, 0xe7, 0x26, 0xde, 0xed, 0xe2, 
0xc2, 0x18, 0x50, 0x0f, 0xfc, 0x81, 0x9a, 0x6b, 
0x72, 0x90, 0x4a, 0xdf, 0x8d, 0xca, 0x93, 0x65, 
0x06, 0xfc, 0x87, 0x24, 0x65, 0x09, 0x41, 0x85, 
0xc0, 0x22, 0x4c, 0xd9, 0x7d, 0x3e, 0x51, 0xb6, 
0x09, 0x01, 0x43, 0x6d, 0xae, 0x8d, 0xbb, 0x49, 
0x9e, 0xed, 0x0d, 0x55, 0xae, 0xe1, 0x26, 0x88, 
0x70, 0x3b, 0xbc, 0x85, 0x57, 0xaf, 0xe9, 0x5e, 
0xed, 0xb8, 0x61, 0x0e, 0x23, 0x24, 0xe1, 0x3d, 
0xd2, 0x90, 0xec, 0xb7, 0xe0, 0x71, 0x1f, 0xe2, 
0x62, 0x0c, 0xf9, 0x91, 0xda, 0x7a, 0x40, 0x46, 
0x5c, 0xdf, 0x83, 0x78, 0xe2, 0x2a, 0x24, 0xb3, 
0x95, 0x50, 0xf1, 0xfa, 0x40, 0xa7, 0xd3, 0x5e, 
0x50, 0x30, 0xf3, 0xa7, 0xa4, 0xfe, 0x83, 0x85, 
0xf8, 0x71, 0xcc, 0x7a, 0x29, 0xd1, 0xa3, 0x3e, 
0xc9, 0x85, 0x10, 0x4f, 0x85, 0x35, 0xd8, 0x07, 
0xda, 0x27, 0x17, 0x97, 0xcc, 0xbe, 0x2b, 0x23, 
0x53, 0x88, 0xe7, 0x30, 0x2b, 0x7a, 0x4e, 0xc9, 
0x07, 0xe5, 0x4b, 0x5f, 0xc6, 0x05, 0xfb, 0x97, 
0x9d, 0x48, 0xaf, 0xc8, 0x1f, 0x1f, 0x74, 0xfe, 
0x0e, 0x43, 0xc0, 0x05, 0x19, 0xd0, 0x4b, 0x56,
0x07, 0xbe, 0xab, 0x3a, 0xa2, 0x8e, 0xb0, 0x55, 
0xf0, 0x73, 0x86, 0xce, 0x84, 0x73, 0x37, 0xae, 
0x99, 0x9a, 0x79, 0xb8, 0x0e, 0x2a, 0x78, 0x18, 
0x44, 0xde, 0x3b, 0x18, 0x3e, 0x9e, 0x23, 0x13, 
0xe4, 0xee, 0xcd, 0x64, 0x06, 0x2f, 0x2e, 0x5e, 
0x84, 0xea, 0xde, 0x3a, 0xaf, 0xbc, 0x72, 0xf1, 
0xd7, 0x4f, 0x8a, 0x13, 0x1a, 0x5b, 0x21, 0xa5, 
0xb8, 0x47, 0x71, 0xe7, 0xfb, 0xe4, 0x6a, 0x7d, 
0xa2, 0xfa, 0xe5, 0xe1, 0x34, 0x3d, 0x5e, 0x84, 
0x23, 0xbd, 0xad, 0xba, 0xcd, 0xb5, 0xc1, 0xd0, 
0x88, 0xab, 0x8d, 0x45, 0x97, 0xac, 0xd2, 0x34, 
0x43, 0x0b, 0x67, 0x62, 0x65, 0x29, 0xac, 0x11, 
0xcb, 0xb2, 0xad, 0xf5, 0xcd, 0x38, 0x2d, 0x1b, 
0x0a, 0x5f, 0x76, 0xd1, 0x6a, 0x3d, 0xde, 0x7c, 
0x8b, 0x3e, 0x35, 0x1b, 0x32, 0xc6, 0x5b, 0xb4, 
0x20, 0x86, 0x4f, 0x8e, 0x3a, 0xb0, 0xf1, 0x72, 
0x93, 0xec, 0xd8, 0xc2, 0xc0, 0xb0, 0x79, 0x9e, 
0xe4, 0xde, 0x0a, 0x96, 0x6b, 0xac, 0x5c, 0x89, 
0x79, 0x8b, 0x73, 0x0c, 0xe7, 0xf1, 0x73, 0x59, 
0xfe, 0xfd, 0x5d, 0xe1, 0xb4, 0xfc, 0xb6, 0xe2, 
0xa5, 0x00, 0x03, 0x8e, 0x46, 0xff, 0xb8, 0x3c, 
0xb0, 0x84, 0xf0, 0x45, 0xc7, 0xb5, 0x8e, 0xa7, 
0xff, 0x6f, 0xc0, 0xdf, 0x00, 0x00, 0x00, 0xff, 
0xff, 0x7c, 0x57, 0xdb, 0x4a, 0x24, 0x31, 0x10, 
0xed, 0x54, 0x3a, 0x49, 0x5f, 0x46, 0x14, 0x41, 
0x07, 0x2f, 0x0b, 0xbe, 0xb8, 0xa0, 0x8e, 0x0a, 
0xfa, 0xa2, 0xe2, 0xe5, 0xd3, 0xac, 0x64, 0xc0, 
0x85, 0x11, 0xfc, 0x44, 0x7f, 0x65, 0xf7, 0x54, 
0x25, 0xdd, 0xd3, 0xb3, 0xc8, 0xc0, 0x4c, 0x77, 
0xce, 0xa9, 0x93, 0x4b, 0xd3, 0xa7, 0x53, 0x95, 
0xaf, 0xc3, 0xb7, 0xcb, 0x83, 0xdf, 0xd5, 0xf9, 
0xeb, 0xc5, 0xd5, 0xc9, 0xfc, 0x76, 0x97, 0x5b, 
0x64, 0x33, 0x32, 0xec, 0x0d, 0x1f, 0x19, 0x3e, 
0x94, 0x24, 0x24, 0xbf, 0x48, 0xfa, 0xd7, 0xb4, 
0x34, 0xa1, 0x34, 0x47, 0xe9, 0x0d, 0x7d, 0xc0, 
0xa0, 0xf7, 0x04, 0x1b, 0x76, 0x66, 0xd4, 0x67, 
0x26, 0x37, 0xab, 0x21, 0xde, 0x17, 0x1c, 0x6b, 
0x80, 0xda, 0x0c, 0x03, 0x16, 0x82, 0xf2, 0x52, 
0x36, 0x94, 0x22, 0x63, 0x9b, 0xc9, 0x35, 0x41, 
0x9b, 0x83, 0x4a, 0xcf, 0x01, 0xd1, 0x20, 0x58, 
0x13, 0x93, 0x05, 0x16, 0xad, 0x2c, 0x5d, 0xee, 
0xd1, 0x66, 0x19, 0x93, 0x3e, 0x5d, 0x99, 0x5d, 
0x9e, 0xba, 0x58, 0xe2, 0xef, 0x7b, 0x6a, 0xf8, 
0x2e, 0xd9, 0xa5, 0xe3, 0x7b, 0xa2, 0x65, 0x8d, 
0x0c, 0x8c, 0xd4, 0x5c, 0x13, 0xdf, 0x20, 0xd9, 
0xba, 0xa5, 0x22, 0x8f, 0xfd, 0xe8, 0x3a, 0x00, 
0x49, 0x94, 0x9a, 0x84, 0x53, 0x90, 0x2d, 0xd0, 
0x03, 0x3a, 0x5e, 0x04, 0x0b, 0x48, 0x25, 0x8a, 
0x4d, 0x79, 0x11, 0x7c, 0xe9, 0xaa, 0xa4, 0x31, 
0x81, 0x17, 0x14, 0xc8, 0xab, 0x06, 0x69, 0x1c, 
0x44, 0x82, 0x4a, 0x1a, 0x7f, 0x74, 0x80, 0xb4, 
0x0b, 0xab, 0x0b, 0xd1, 0x52, 0x6c, 0xa9, 0xeb, 
0x7b, 0xbe, 0x4e, 0x14, 0x1b, 0x42, 0x39, 0xa5, 
0x6c, 0x0c, 0x68, 0x8a, 0x8e, 0x62, 0xc0, 0x47, 
0x49, 0x21, 0xb4, 0x7d, 0x0e, 0xe0, 0x93, 0x93, 
0xe1, 0x50, 0xe5, 0x6a, 0x14, 0xd0, 0x98, 0x99, 
0x99, 0x84, 0xa3, 0x05, 0xe8, 0x35, 0xe8, 0x66, 
0x5d, 0x89, 0xe6, 0xb9, 0xa2, 0x6b, 0x95, 0x19, 
0x7b, 0xbb, 0x6e, 0xb6, 0xd3, 0x75, 0xfd, 0x44, 
0x00, 0x02, 0xd5, 0x5a, 0xbf, 0x8e, 0x03, 0x6d, 
0x84, 0x57, 0xb6, 0x9f, 0xf4, 0x0e, 0x2b, 0xfb, 
0x39, 0xc6, 0x3a, 0x03, 0x38, 0x4c, 0xdd, 0x05, 
0xcc, 0x43, 0x1f, 0x34, 0x44, 0x43, 0xac, 0x31, 
0x0c, 0xad, 0xc4, 0xad, 0xaf, 0xf3, 0xab, 0x7d, 
0x7f, 0xce, 0x7b, 0xa8, 0x62, 0xc4, 0x21, 0xf2, 
0xd2, 0xd4, 0x9f, 0xe5, 0xe5, 0xa1, 0x21, 0x24, 
0xcf, 0xa7, 0x2f, 0xfa, 0xe7, 0xcb, 0x54, 0x53, 
0x2c, 0xb7, 0x45, 0x31, 0x5a, 0x6d, 0x8b, 0x62, 
0xeb, 0x3c, 0xd5, 0x7a, 0xa9, 0xba, 0xec, 0x6c, 
0x46, 0x80, 0x33, 0xc3, 0xa7, 0x86, 0x7f, 0xc1, 
0x85, 0xc7, 0x91, 0x8a, 0xd5, 0xbe, 0xe1, 0x28, 
0x7e, 0x49, 0xa8, 0xbd, 0x1f, 0x93, 0xb3, 0xfc, 
0x80, 0x23, 0x36, 0xaa, 0x53, 0x39, 0x1f, 0x69, 
0x71, 0xc7, 0x8f, 0x64, 0x6a, 0xf8, 0x03, 0xe7, 
0xa4, 0x5a, 0x44, 0x0f, 0xa9, 0x56, 0x95, 0x5c, 
0x60, 0x41, 0x92, 0xbb, 0x27, 0xf8, 0x46, 0x71, 
0x20, 0x25, 0x9a, 0x4c, 0xa0, 0x16, 0xc9, 0xd8, 
0x55, 0x8d, 0x0a, 0xdc, 0x7f, 0xc4, 0x28, 0xf0, 
0x49, 0xa7, 0xf4, 0x03, 0xa4, 0xac, 0x27, 0x1a, 
0x88, 0xaa, 0xcd, 0x03, 0xb8, 0x3c, 0xa3, 0xd3, 
0xf5, 0xc2, 0xc7, 0x20, 0x9f, 0x70, 0xe5, 0x67, 
0xc2, 0x1e, 0xb4, 0x75, 0x03, 0xfa, 0x07, 0x00, 
0x00, 0xff, 0xff, 0x7c, 0x57, 0xdb, 0x4e, 0xc2, 
0x40, 0x10, 0x6d, 0x87, 0xed, 0x4e, 0x2f, 0xc0, 
0x9b, 0x60, 0xe4, 0x01, 0x5f, 0xa9, 0x48, 0x81, 
0xc4, 0x92, 0x68, 0x02, 0x7f, 0xe0, 0x37, 0x0d, 
0xa4, 0x69, 0x30, 0x31, 0xfa, 0x53, 0xfe, 0x97, 
0x9e, 0x19, 0xb6, 0x08, 0x3e, 0x98, 0x6e, 0xbb, 
0x73, 0xd9, 0x9d, 0xb6, 0xbb, 0x73, 0xd9, 0xf3, 
0x39, 0x2a, 0x77, 0xd5, 0x98, 0xfd, 0x5d, 0xb1, 
0x9d, 0xd0, 0xec, 0xf9, 0x46, 0xe6, 0x7b, 0x3a, 
0xe4, 0x3d, 0xac, 0x03, 0x76, 0xf7, 0x90, 0xa1, 
0x5f, 0xef, 0x91, 0xb4, 0xbf, 0x48, 0xee, 0x11, 
0x58, 0x03, 0x92, 0x1c, 0x94, 0x65, 0xef, 0xdb, 
0x40, 0x44, 0x38, 0xc0, 0xe3, 0xc6, 0xda, 0x06, 
0x92, 0xf4, 0x0a, 0x83, 0x1c, 0xd9, 0xa9, 0x27, 
0xea, 0x3a, 0x55, 0x9b, 0x25, 0xc2, 0x84, 0xa0, 
0xb1, 0x20, 0x24, 0x0c, 0x9e, 0xea, 0x78, 0x93, 
0x75, 0x53, 0x8c, 0x55, 0x53, 0x7f, 0xe4, 0x81, 
0x56, 0x0d, 0xfe, 0xf9, 0xea, 0xe5, 0x62, 0x4e, 
0x2b, 0xdb, 0x6e, 0x23, 0xbf, 0x01, 0xe4, 0x5f, 
0x0c, 0x4d, 0x3d, 0xb5, 0x89, 0x63, 0xef, 0x65, 
0xdd, 0x52, 0xe3, 0x38, 0x45, 0xed, 0x90, 0x55, 
0x8b, 0xd2, 0xc0, 0xda, 0xf8, 0x48, 0xb2, 0x04, 
0xc7, 0x31, 0x37, 0xc4, 0xc7, 0x9e, 0x54, 0x40, 
0x79, 0x71, 0xc6, 0xaa, 0x4a, 0x55, 0x59, 0xa1, 
0x02, 0x65, 0x59, 0xa4, 0x7c, 0x92, 0x1f, 0x29, 
0x97, 0xc7, 0xc2, 0xfb, 0x18, 0x19, 0xd7, 0xe5, 
0x06, 0x1e, 0x53, 0x94, 0xbd, 0xf9, 0x59, 0x64, 
0x90, 0x32, 0x35, 0x89, 0x09, 0x14, 0x73, 0x26, 
0xde, 0xa7, 0xf2, 0x50, 0x44, 0xfd, 0x41, 0x1f, 
0x27, 0x3d, 0x2f, 0x5c, 0x78, 0xc0, 0x9b, 0x77, 
0x3d, 0xf3, 0x9d, 0x98, 0xb2, 0x18, 0x22, 0xde, 
0xc1, 0xb6, 0xb9, 0x94, 0xaa, 0x70, 0xce, 0x37, 
0x9e, 0x73, 0x7d, 0x7d, 0x39, 0x1c, 0xf6, 0xcd, 
0x4c, 0x93, 0x70, 0xf8, 0xf8, 0xd9, 0x87, 0x62, 
0x17, 0xaf, 0x43, 0x4c, 0xf2, 0x36, 0xda, 0x8d, 
0x7d, 0x31, 0xe1, 0x69, 0x85, 0x5f, 0x7f, 0xb5, 
0xea, 0x83, 0xb6, 0xbe, 0x28, 0x16, 0xf0, 0xf5, 
0xc5, 0x39, 0x15, 0x07, 0x42, 0x96, 0xbf, 0x71, 
0x42, 0x5a, 0xaf, 0x2e, 0x52, 0xb5, 0xb6, 0x45, 
0x7c, 0xcd, 0x57, 0x71, 0x14, 0xb2, 0x33, 0xac, 
0x85, 0x25, 0xae, 0xcd, 0x4f, 0x7b, 0x24, 0x00, 
0x2f, 0xb2, 0xb5, 0x5b, 0x6a, 0x74, 0xf0, 0xc9, 
0xda, 0xf0, 0x2b, 0x5a, 0xdd, 0x28, 0x8e, 0x45, 
0xaf, 0x7b, 0xe1, 0xb0, 0x61, 0x4a, 0x02, 0x76, 
0x79, 0x10, 0x1b, 0x4e, 0x58, 0x85, 0xf0, 0x60, 
0x94, 0xf4, 0x13, 0x81, 0xa0, 0xe0, 0x4e, 0x92,
0x18, 0x81, 0x85, 0x67, 0xd5, 0x6d, 0x14, 0xae, 
0xc1, 0xd8, 0xa6, 0x71, 0xaa, 0x40, 0x8d, 0xef, 
0x1e, 0xff, 0xbb, 0xfa, 0x0f, 0x00, 0x00, 0x00, 
0xff, 0xff, 0x7c, 0x58, 0xdb, 0x4e, 0xc3, 0x30, 
0x0c, 0x4d, 0x93, 0xac, 0x49, 0xd6, 0x21, 0x40, 
0xb0, 0x0d, 0x89, 0x07, 0x2e, 0x0f, 0x48, 0xec, 
0x11, 0x09, 0x8d, 0x8b, 0x60, 0xbf, 0xc5, 0xa3, 
0xbd, 0xee, 0xa1, 0x15, 0x82, 0x3f, 0xe2, 0x0f, 
0xf8, 0x05, 0xbe, 0x65, 0x1c, 0x3b, 0xdd, 0x98, 
0x56, 0x09, 0xa9, 0x8d, 0x8f, 0x1d, 0x37, 0x75, 
0xa3, 0xc4, 0xf5, 0xc9, 0xe7, 0x64, 0x3c, 0xc5, 
0x9e, 0x2c, 0xcc, 0x60, 0x31, 0x03, 0x0f, 0xa1, 
0x5b, 0xf0, 0x8f, 0x2e, 0xc5, 0xaf, 0x50, 0xb6, 
0xb1, 0x2c, 0x4f, 0x68, 0x42, 0xdc, 0xb0, 0xe8, 
0x85, 0xad, 0x21, 0x5e, 0x97, 0x15, 0xe1, 0xbd, 
0xa6, 0x16, 0x41, 0xc1, 0x29, 0x53, 0x94, 0x02, 
0x51, 0xfb, 0xad, 0x7c, 0xa7, 0xb2, 0x47, 0xc0, 
0x52, 0x3e, 0xcd, 0xa1, 0xfc, 0xaf, 0xfd, 0x72, 
0x63, 0x2b, 0xe4, 0xb8, 0x47, 0x1c, 0x6b, 0x2c, 
0xfa, 0xce, 0x66, 0x82, 0x93, 0xff, 0x13, 0x2c, 
0x41, 0x2d, 0x78, 0x55, 0x90, 0xa3, 0x9f, 0xda, 
0x2d, 0x95, 0x55, 0x3b, 0xf2, 0xd0, 0xf1, 0x07, 
0x32, 0x35, 0x1e, 0x14, 0x96, 0xec, 0x08, 0xe5, 
0x8e, 0xf7, 0x75, 0x10, 0x05, 0x1a, 0xa6, 0xb5, 
0xd0, 0xc9, 0x92, 0x22, 0xcd, 0xd4, 0xde, 0x6b, 
0x19, 0xe4, 0x69, 0xfd, 0xd3, 0xa2, 0xb2, 0x4a, 
0x74, 0x96, 0x68, 0x00, 0x86, 0x7e, 0x94, 0x28, 
0x64, 0x25, 0xd1, 0x69, 0x32, 0xa6, 0xc5, 0xcc, 
0xb7, 0x36, 0xdf, 0x28, 0x6b, 0xa1, 0x93, 0xcd, 
0x3a, 0xb9, 0xec, 0x91, 0x48, 0xea, 0x5d, 0x34, 
0x2a, 0x77, 0x0d, 0x46, 0x86, 0x74, 0x74, 0xbc, 
0x63, 0x6b, 0xfd, 0xd6, 0x55, 0xe1, 0x60, 0x7f, 
0x0c, 0xbf, 0x1d, 0x49, 0x60, 0xaf, 0x7b, 0x4f, 
0xe6, 0x11, 0x4e, 0x10, 0x90, 0x6a, 0xfa, 0x7a, 
0x8d, 0xb4, 0xf3, 0x91, 0x30, 0x6d, 0x4a, 0x24, 
0x67, 0x0f, 0xdd, 0xda, 0x7b, 0xe1, 0x48, 0xf7, 
0xc3, 0x56, 0x9a, 0xb4, 0x0a, 0xd2, 0xfa, 0x77, 
0x8b, 0x2d, 0x76, 0xa0, 0xb0, 0xaa, 0x04, 0x8e, 
0x32, 0x56, 0x58, 0x29, 0xce, 0xb0, 0xfa, 0xb0, 
0x93, 0x29, 0x52, 0xdf, 0xf0, 0x7c, 0x31, 0x9e, 
0x99, 0x43, 0x0a, 0xfc, 0x86, 0x0c, 0xce, 0x73, 
0x8b, 0x6d, 0x85, 0x7c, 0x2e, 0x08, 0xc9, 0xbb, 
0xb4, 0x8e, 0x91, 0xdf, 0x5d, 0x6e, 0xf9, 0x11, 
0x49, 0x96, 0x9f, 0xe4, 0xdc, 0x85, 0x9f, 0x71, 
0xaf, 0xd7, 0xdf, 0x91, 0x5f, 0xf5, 0xba, 0x8b, 
0x6c, 0x63, 0xd1, 0x80, 0xf3, 0xc4, 0xa2, 0x68, 
0xac, 0x88, 0x3f, 0xc0, 0x17, 0xaa, 0xa9, 0x4b, 
0xec, 0xc4, 0x56, 0x8f, 0x7c, 0x25, 0x60, 0xb7, 
0x8f, 0x6d, 0xe3, 0xd1, 0x5e, 0xf7, 0xed, 0x91, 
0xbd, 0xf8, 0xf7, 0x46, 0xdb, 0x38, 0xf2, 0x65, 
0x2f, 0x0e, 0x76, 0x59, 0xdc, 0x68, 0x9c, 0x79, 
0xe2, 0xbe, 0xda, 0x92, 0x1f, 0x1a, 0x8f, 0x0a, 
0x82, 0xe7, 0xe4, 0xa2, 0xca, 0x11, 0xe8, 0x77,
0x46, 0x21, 0x94, 0x1b, 0x54, 0x6e, 0x10, 0x32, 
0x62, 0x06, 0xff, 0xef, 0xb3, 0x5f, 0x00, 0x00, 
0x00, 0xff, 0xff, 0x7c, 0x58, 0xcd, 0x4e, 0xc3, 
0x30, 0x0c, 0x4e, 0x9d, 0xa6, 0x49, 0xda, 0xae, 
0x93, 0x80, 0x31, 0xc1, 0x1d, 0x89, 0xed, 0x80, 
0x38, 0xb1, 0x0b, 0x3f, 0x6f, 0xc2, 0xb3, 0xb4, 
0xdd, 0x8c, 0x98, 0xa6, 0x9d, 0x78, 0x12, 0x9e, 
0x70, 0x7c, 0x76, 0xd7, 0xb5, 0x13, 0xd2, 0xb4, 
0x36, 0x89, 0xed, 0xaf, 0x99, 0xd3, 0x24, 0xf6, 
0x97, 0x4a, 0x4a, 0x21, 0xb0, 0xf9, 0xdc, 0xcc, 
0xa6, 0xf7, 0xef, 0x8b, 0x27, 0x9c, 0x1d, 0x49, 
0x3f, 0xc9, 0x20, 0x82, 0xd6, 0xcf, 0x70, 0x1e, 
0x5c, 0x4d, 0x05, 0x8f, 0x60, 0xd2, 0xda, 0xa0, 
0x56, 0xf9, 0xee, 0x8d, 0x58, 0xb3, 0xb5, 0x41, 
0xe4, 0x1c, 0x22, 0x68, 0x9c, 0x88, 0x18, 0x03, 
0x61, 0xd1, 0x3f, 0x36, 0x59, 0x8c, 0x32, 0xe2, 
0x04, 0x14, 0x70, 0x91, 0xb4, 0x69, 0xd4, 0xf1, 
0xc6, 0x7a, 0xb9, 0x4d, 0x65, 0x78, 0x88, 0x98, 
0xf2, 0x5a, 0xac, 0xaa, 0xa4, 0x57, 0x34, 0x09, 
0x21, 0x2a, 0x0a, 0x55, 0xeb, 0x15, 0x31, 0x16, 
0xe5, 0x9e, 0x92, 0x78, 0x82, 0x44, 0x2c, 0x95, 
0x3d, 0xd8, 0xe6, 0x51, 0xa6, 0xb8, 0xb3, 0x65, 
0x39, 0x99, 0x8c, 0x15, 0x58, 0x2a, 0x08, 0x74, 
0x2a, 0x26, 0x49, 0xa4, 0x6a, 0x97, 0x4e, 0x1a, 
0xed, 0x52, 0xce, 0x18, 0xaa, 0xa2, 0xaa, 0x2a, 
0x0a, 0x99, 0x4b, 0x55, 0x8b, 0x5e, 0xd4, 0xf0, 
0xc6, 0x18, 0xb8, 0x90, 0x8c, 0xa0, 0x9d, 0xae, 
0x39, 0x83, 0x21, 0xce, 0xb5, 0xe7, 0xa0, 0xcc, 
0x57, 0xed, 0x08, 0x12, 0xf0, 0x18, 0xe6, 0xa5, 
0xaa, 0x86, 0x3f, 0x0d, 0x46, 0x74, 0x85, 0x28, 
0x7b, 0x5c, 0xc0, 0xbe, 0x68, 0x6c, 0x59, 0x89, 
0xb2, 0x5e, 0x7e, 0x3b, 0xec, 0x36, 0x9c, 0x25, 
0x44, 0xc6, 0x68, 0x57, 0x5b, 0x57, 0x83, 0xd1, 
0xd4, 0x60, 0x82, 0x20, 0x0c, 0xf5, 0x03, 0x1c, 
0x0d, 0x7a, 0x4b, 0xb2, 0x9c, 0x68, 0x3a, 0xd5, 
0x94, 0x8c, 0x6c, 0x2a, 0x89, 0x15, 0xb0, 0xb2, 
0xcf, 0xbd, 0x76, 0x94, 0x78, 0x6b, 0xaf, 0x09, 
0x16, 0xe6, 0x42, 0x0e, 0x6f, 0xa6, 0x83, 0x9b, 
0xde, 0x8a, 0xa8, 0x87, 0x5c, 0x2e, 0xbd, 0x82, 
0x23, 0x48, 0x67, 0xd4, 0xa1, 0x4e, 0x80, 0xbc, 
0xf3, 0x40, 0x2f, 0xaf, 0xe6, 0x91, 0x3a, 0x48, 
0x69, 0xf4, 0x50, 0x48, 0x3d, 0xad, 0x10, 0x54, 
0x90, 0x0a, 0xdd, 0x76, 0xee, 0x7c, 0x82, 0x7f, 
0xbb, 0xd6, 0x75, 0x9b, 0xff, 0x67, 0x9b, 0xd3, 
0xc7, 0xd2, 0xdc, 0xce, 0x67, 0x4f, 0x35, 0xe9, 
0x89, 0x9d, 0x57, 0xc6, 0x64, 0x7d, 0x2b, 0xeb, 
0x5b, 0x5f, 0xbd, 0xb1, 0xb1, 0x5d, 0x2d, 0x9b, 
0x19, 0xd5, 0x3a, 0x43, 0x81, 0xc4, 0x91, 0xf2, 
0xcb, 0xda, 0xa3, 0x68, 0x87, 0xa6, 0xdf, 0xd8, 
0x35, 0xa1, 0xb6, 0x1e, 0x91, 0x95, 0x57, 0xe4, 
0x37, 0x29, 0x83, 0x77, 0x79, 0x7e, 0xb5, 0xf6, 
0x7f, 0xa1, 0x06, 0xdc, 0x6f, 0x01, 0xb7, 0xe7, 
0xc3, 0xa1, 0x6d, 0x89, 0x11, 0xb7, 0x79, 0x4a, 
0x0c, 0xca, 0xc7, 0x78, 0x19, 0x7c, 0x8d, 0x8a, 
0x9c, 0x23, 0xbe, 0xd3, 0x86, 0x14, 0x7c, 0x75, 
0x6c, 0xe6, 0x62, 0x90, 0x8b, 0xc0, 0x66, 0x18, 
0x8a, 0x14, 0x78, 0x50, 0x3a, 0x91, 0xfc, 0x60, 
0xd3, 0x67, 0x90, 0x83, 0xd4, 0x3c, 0xf4, 0x92, 
0x91, 0x3b, 0xfd, 0xb8, 0xb3, 0xa2, 0xbc, 0xb9, 
0x04, 0x10, 0x3f, 0x66, 0x03, 0xc0, 0x1f, 0x7d, 
0x73, 0x27, 0x15, 0x8a, 0xf9, 0xd1, 0xf1, 0x70, 
0x66, 0x74, 0xea, 0x56, 0xca, 0x98, 0x08, 0xd6, 
0x49, 0xf8, 0xbd, 0x1c, 0x0c, 0xfe, 0x00, 0x00, 
0x00, 0xff, 0xff, 0x94, 0x59, 0xdb, 0x4a, 0xc3, 
0x40, 0x10, 0xdd, 0x6c, 0xf6, 0x96, 0xa4, 0xbe, 
0xb6, 0xd4, 0x3e, 0x89, 0x0f, 0xda, 0x16, 0xea, 
0x93, 0x79, 0x10, 0x8a, 0xe0, 0xef, 0xf8, 0x13, 
0xed, 0x90, 0x60, 0x05, 0xf1, 0xff, 0xfc, 0x9a, 
0x78, 0x66, 0xf6, 0xd2, 0x22, 0x28, 0xf8, 0xb0, 
0x6d, 0xce, 0x99, 0x99, 0xce, 0x92, 0xcd, 0xce, 
0x9e, 0x49, 0x3f, 0xe7, 0xea, 0xf9, 0xe9, 0x71, 
0x19, 0x36, 0xfd, 0x6e, 0xe1, 0xb7, 0xab, 0xc3, 
0xb4, 0x3e, 0xce, 0xb1, 0x99, 0x31, 0x28, 0x0d, 
0x8d, 0x33, 0xaf, 0xc5, 0xc0, 0x71, 0xa9, 0x71, 
0xac, 0x53, 0xa8, 0x07, 0x7e, 0x79, 0x6a, 0x01, 
0xf9, 0x8a, 0xc2, 0xc0, 0xc8, 0x01, 0xc2, 0x4c, 
0xbe, 0x06, 0x64, 0x15, 0x27, 0xb0, 0xc6, 0x92, 
0xb1, 0xb7, 0x8d, 0x84, 0xf8, 0x3b, 0xf6, 0x77, 
0x0e, 0xf1, 0xc4, 0x01, 0x16, 0x64, 0x28, 0x44, 
0x60, 0x0f, 0x13, 0x33, 0x24, 0x4a, 0x82, 0x0c, 
0x3c, 0x13, 0x81, 0x04, 0xa8, 0xf0, 0x03, 0x6b, 
0xed, 0x44, 0x48, 0x50, 0xf4, 0xcb, 0x54, 0x04, 
0xec, 0x89, 0xe6, 0x0e, 0x84, 0xe1, 0xa4, 0x31, 
0x3d, 0x23, 0x49, 0x20, 0xd0, 0xb6, 0x05, 0xf3, 
0x64, 0xda, 0x0e, 0x90, 0xd5, 0x8b, 0x24, 0xc5, 
0x09, 0xc4, 0xb0, 0xc6, 0x33, 0x48, 0x86, 0xfb, 
0xc8, 0xfb, 0xb7, 0xa6, 0x1a, 0x34, 0xd9, 0xae, 
0x43, 0x98, 0xa7, 0x50, 0x41, 0x4e, 0x14, 0x84, 
0x6a, 0x86, 0x72, 0x62, 0x0c, 0x39, 0x71, 0xf5, 
0x54, 0xb3, 0x2e, 0x11, 0x62, 0x16, 0x89, 0xe4, 
0x81, 0xbb, 0xc4, 0x79, 0xd0, 0x75, 0xc0, 0xa1, 
0x62, 0x86, 0x9a, 0x2b, 0xc1, 0x90, 0xf4, 0xa6, 
0xa2, 0x68, 0xab, 0xc8, 0xc6, 0x4b, 0x94, 0x9f, 
0xcc, 0x52, 0x38, 0xce, 0x64, 0x75, 0xa6, 0xaf, 
0xa4, 0xd7, 0x65, 0x33, 0xa2, 0x38, 0xe4, 0x3a, 
0x70, 0x73, 0xe6, 0x95, 0xca, 0xdb, 0xf8, 0x36, 
0x0b, 0x73, 0x11, 0xff, 0xb1, 0xae, 0x9c, 0x05, 
0xf9, 0x75, 0x36, 0x44, 0x6b, 0x53, 0xae, 0xe4, 
0x07, 0xb3, 0x35, 0xb5, 0x0d, 0xd9, 0x2a, 0x4d, 
0xc1, 0x2f, 0x36, 0xa9, 0x4d, 0xab, 0x54, 0x27, 
0x72, 0x49, 0xca, 0x55, 0x4a, 0xc2, 0x92, 0x49, 
0x66, 0x6e, 0x4b, 0x35, 0xd1, 0xd2, 0x13, 0xbc, 
0x7c, 0xe0, 0x91, 0xdc, 0x6d, 0xc2, 0xf2, 0x61, 
0xeb, 0x17, 0x78, 0x20, 0x15, 0x04, 0x44, 0xcf, 
0x83, 0xd2, 0xc0, 0x71, 0xc4, 0x2a, 0xac, 0x1f, 
0x0d, 0x6b, 0xb8, 0x7e, 0xb4, 0xdc, 0x49, 0xf5, 
0xce, 0xd4, 0x6e, 0xc4, 0x2a, 0x42, 0xd8, 0x12, 
0xf4, 0x01, 0x48, 0x78, 0xff, 0xfb, 0x5b, 0xfe, 
0xbc, 0xed, 0xfd, 0x89, 0xd1, 0xbb, 0x6b, 0xcb, 
0x67, 0x7b, 0xb2, 0x9e, 0x0d, 0x90, 0x83, 0x65, 
0x1e, 0x02, 0x9a, 0xee, 0x64, 0x7f, 0xf8, 0x6a, 
0x89, 0xce, 0x5e, 0x69, 0xf6, 0xd3, 0x84, 0xf3, 
0x61, 0xcf, 0x52, 0x51, 0x5f, 0x36, 0x62, 0xb1, 
0x01, 0x5b, 0x5f, 0xdc, 0x70, 0xa1, 0x14, 0x6f, 
0x36, 0x55, 0x9a, 0x2f, 0x6c, 0xe8, 0xc3, 0x9d, 
0x56, 0xa5, 0xe7, 0xc2, 0x02, 0x6e, 0xcf, 0x65, 
0x5b, 0x10, 0x17, 0x74, 0x15, 0x01, 0xee, 0xe1, 
0xeb, 0xdf, 0x9b, 0xfe, 0x1b, 0x00, 0x00, 0xff, 
0xff, 0xc2, 0xc8, 0xf4, 0xff, 0xff, 0xbf, 0x1e, 
0xcd, 0xf6, 0x78, 0xb2, 0x3d, 0x98, 0x03, 0xcd, 
0xe8, 0x40, 0x9f, 0xb0, 0x32, 0xc3, 0xd9, 0xcc, 
0x2d, 0xb0, 0xfc, 0xde, 0xc4, 0xde, 0x02, 0xcb, 
0xe9, 0x40, 0x26, 0x33, 0x34, 0x93, 0x83, 0x42, 
0x86, 0x09, 0x9c, 0xbd, 0x81, 0x21, 0xc8, 0x0c, 
0xca, 0xc4, 0xb0, 0x00, 0x86, 0x06, 0xf8, 0xff, 
0x1f, 0x4c, 0x0d, 0xe9, 0x48, 0x55, 0x3c, 0x03, 
0x22, 0x73, 0x36, 0x28, 0x21, 0x57, 0xee, 0xcc, 
0x48, 0xbd, 0x6b, 0xa0, 0x0c, 0x52, 0xbd, 0xcd,
0x02, 0xcf, 0x93, 0xd8, 0xc5, 0x99, 0x80, 0x89, 
0x07, 0x5e, 0x9b, 0xb3, 0x22, 0x7a, 0xe7, 0xca, 
0xc8, 0x55, 0x39, 0x82, 0xd5, 0x88, 0x96, 0x01, 
0xff, 0xff, 0x3f, 0x34, 0x4c, 0xb2, 0x60, 0x05, 
0xac, 0xb4, 0x82, 0x67, 0x3f, 0x3d, 0x78, 0xf9, 
0x05, 0xcd, 0x7c, 0xfa, 0xd0, 0x6c, 0x06, 0xc9, 
0x78, 0x06, 0x30, 0x1e, 0x38, 0xdb, 0x19, 0xc2, 
0x0a, 0x30, 0x70, 0x00, 0x1a, 0x42, 0xcb, 0x5e, 
0xb0, 0xc8, 0x06, 0xfc, 0x19, 0x0e, 0x00, 0x00, 
0x00, 0xff, 0xff, 0x7c, 0x9a, 0xc1, 0x4e, 0xc4, 
0x20, 0x18, 0x84, 0x17, 0x90, 0x86, 0xbf, 0x9a, 
0x7a, 0xda, 0xf5, 0xe0, 0x13, 0xe8, 0xc1, 0x78, 
0xf3, 0x64, 0xe2, 0xa3, 0x55, 0xd0, 0x64, 0x37, 
0x1e, 0x7c, 0x21, 0x1f, 0xce, 0x99, 0xf9, 0x61, 
0x77, 0xd5, 0xc4, 0x43, 0x9b, 0x61, 0xa0, 0x50, 
0x9a, 0x36, 0xf9, 0x06, 0xfa, 0xb9, 0xdb, 0x82, 
0xb9, 0xb9, 0xb9, 0xb6, 0x71, 0xe4, 0x76, 0xc4, 
0xff, 0x62, 0x36, 0x8a, 0x8d, 0xa7, 0xc4, 0x6c, 
0x84, 0xc7, 0xfa, 0xce, 0x40, 0xe3, 0x12, 0x0f, 
0x04, 0x72, 0x72, 0x2d, 0x99, 0xa5, 0x5d, 0xba, 
0x76, 0x59, 0xd6, 0x47, 0x00, 0xb7, 0x6a, 0x98, 
0xcb, 0x31, 0x89, 0x96, 0x4c, 0xb5, 0x39, 0xef, 
0x39, 0x49, 0x71, 0x76, 0xba, 0x98, 0x51, 0x04, 
0xb6, 0xb3, 0x18, 0x4d, 0x43, 0xe2, 0x0d, 0x16, 
0x22, 0x1b, 0xef, 0xe2, 0x0e, 0xa9, 0x38, 0x00, 
0x40, 0xad, 0x1a, 0x69, 0xdd, 0x6a, 0x3a, 0x00, 
0xdb, 0x2b, 0x85, 0x2c, 0xf6, 0x0a, 0x89, 0xd7, 
0x18, 0xd1, 0x05, 0x01, 0x7f, 0x18, 0x21, 0x10, 
0xdb, 0xb9, 0x1e, 0xdd, 0x9d, 0x20, 0x6c, 0x27, 
0x24, 0xab, 0x1c, 0x83, 0x63, 0xfb, 0xb9, 0x01, 
0x6c, 0xaf, 0xbd, 0x07, 0x5c, 0x99, 0x88, 0xed, 
0x5c, 0x2a, 0xbb, 0xe7, 0x07, 0x1a, 0x65, 0x25, 
0x62, 0x3b, 0xe3, 0x81, 0x46, 0xa2, 0x4f, 0x1b, 
0x77, 0x83, 0xb8, 0xc9, 0x7f, 0x73, 0x4e, 0x4d, 
0xdd, 0x53, 0xef, 0xc7, 0x66, 0xd9, 0xac, 0xc5, 
0x1f, 0x8d, 0xa6, 0xb2, 0xb4, 0xb3, 0x26, 0x86, 
0xcb, 0xae, 0x4a, 0x59, 0x96, 0xd3, 0xa0, 0xb6, 
0xa1, 0x77, 0x49, 0x73, 0xb4, 0x43, 0xaa, 0x45, 
0xb2, 0x00, 0xa6, 0xc3, 0x44, 0x94, 0x01, 0xb6, 
0x33, 0x46, 0xb0, 0x8c, 0xd9, 0x3e, 0xbd, 0x02, 
0x74, 0xeb, 0xc7, 0x6e, 0x0b, 0xc8, 0x8d, 0xd7, 
0xb7, 0xf3, 0xcd, 0xc3, 0x71, 0x6b, 0x64, 0x5a, 
0x95, 0x48, 0xb9, 0x3d, 0x22, 0xa6, 0xd5, 0x66, 
0x48, 0x76, 0xc5, 0x05, 0x93, 0xae, 0xca, 0x50, 
0xfb, 0xf8, 0x5b, 0x94, 0x62, 0x43, 0xd9, 0x50, 
0x87, 0x51, 0x39, 0x3a, 0xed, 0x63, 0xb4, 0x49, 
0x5b, 0x29, 0x90, 0xa4, 0xe3, 0x55, 0xa0, 0xdc, 
0x65, 0x10, 0x28, 0xe3, 0x8b, 0x0c, 0x8d, 0x2b, 
0x10, 0x31, 0xbc, 0xe9, 0x27, 0x92, 0xb0, 0x82, 
0x8c, 0xff, 0x9e, 0x54, 0x81, 0xe3, 0x79, 0xc6, 
0xc1, 0x55, 0xfd, 0x97, 0xff, 0xdf, 0xeb, 0x6f, 
0x00, 0x00, 0x00, 0xff, 0xff, 0x6a, 0x12, 0xb3, 
0x07, 0x76, 0x70, 0x1a, 0xb4, 0x81, 0x3d, 0x30,
0x3e, 0xf8, 0x24, 0x06, 0x64, 0x86, 0x00, 0x34, 
0xc2, 0x0c, 0x62, 0xf1, 0x22, 0x8b, 0x83, 0xc6, 
0xa5, 0xa4, 0x61, 0x53, 0x08, 0xd0, 0x69, 0x04, 
0x06, 0xf8, 0x74, 0x05, 0x98, 0x2d, 0x83, 0x98, 
0x8e, 0x00, 0xcd, 0x79, 0xc0, 0xa7, 0x44, 0xe0, 
0xf2, 0xe0, 0xd1, 0x61, 0x16, 0x06, 0xf8, 0x6c, 
0x0b, 0x7c, 0x0a, 0x05, 0xac, 0x19, 0xae, 0x13, 
0x36, 0xeb, 0x81, 0x26, 0x8f, 0x36, 0xd7, 0x01, 
0x1b, 0x35, 0x63, 0x62, 0x84, 0xb9, 0x8d, 0x19, 
0x3a, 0xdf, 0x01, 0x1d, 0x80, 0x86, 0x4a, 0x22, 
0x8f, 0xa6, 0x41, 0xc0, 0x19, 0x90, 0xdf, 0x9d, 
0x19, 0x1b, 0xd8, 0x19, 0x1b, 0x38, 0x40, 0xdd, 
0x43, 0xd0, 0xa4, 0x10, 0x88, 0xc7, 0x08, 0x1a, 
0xff, 0x81, 0x09, 0x6b, 0x80, 0x4d, 0x85, 0xb2, 
0x1b, 0x59, 0x40, 0xf3, 0x46, 0x40, 0x96, 0x36, 
0x4c, 0x48, 0x1b, 0x6c, 0x3c, 0x33, 0x0c, 0x69, 
0x23, 0x42, 0x06, 0x42, 0xa1, 0x58, 0xf8, 0x19, 
0x7f, 0x54, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 
0xcc, 0x5a, 0xdb, 0x8e, 0xdc, 0x44, 0x10, 0xb5, 
0xab, 0x2f, 0xbe, 0x8d, 0xc7, 0x33, 0x9e, 0x9d, 
0x0d, 0x10, 0xa1, 0x6c, 0x50, 0xa4, 0x4d, 0x82, 
0x20, 0x41, 0xda, 0x85, 0xdc, 0xc8, 0xc2, 0xf7, 
0xe4, 0x99, 0xe7, 0x4d, 0xcd, 0xcc, 0xb2, 0x59, 
0xa2, 0xac, 0x56, 0x2b, 0x21, 0x3e, 0x01, 0x09, 
0x89, 0x07, 0xbe, 0x80, 0x47, 0x7e, 0x88, 0xf7, 
0xe5, 0x9c, 0x6e, 0x7b, 0xae, 0x89, 0x94, 0x47, 
0x34, 0x76, 0xdb, 0xee, 0x3a, 0x5d, 0x5d, 0x5d, 
0xd5, 0xae, 0xaa, 0xee, 0xf1, 0x05, 0x56, 0xf5, 
0xd3, 0xe4, 0xf1, 0xc0, 0xbc, 0x58, 0x36, 0xfb, 
0x47, 0x4f, 0x66, 0x27, 0xaa, 0xb3, 0x63, 0x83, 
0xbc, 0x93, 0xc7, 0xd1, 0x87, 0x6f, 0xaa, 0x85, 
0xd1, 0x7b, 0xfd, 0x43, 0xb1, 0xc8, 0xf4, 0x8b, 
0xfe, 0x41, 0xac, 0xda, 0x85, 0x38, 0xee, 0x75, 
0x8a, 0xde, 0x5d, 0xd5, 0xa6, 0x16, 0x73, 0xcb, 
0xb1, 0xde, 0x5b, 0xab, 0xb2, 0x40, 0x85, 0xd5, 
0x21, 0x4e, 0xd7, 0x63, 0xec, 0xc2, 0xf5, 0xf4, 
0x94, 0x44, 0xbb, 0x0d, 0x10, 0xc7, 0x3a, 0xc4, 
0xdd, 0x25, 0x62, 0x01, 0xcf, 0xc2, 0xd3, 0x46, 
0xf6, 0x6a, 0x56, 0xd0, 0x14, 0x3f, 0xb7, 0x80, 
0xb3, 0x59, 0x44, 0x2c, 0xdb, 0x00, 0xba, 0xd1, 
0xe1, 0x19, 0x82, 0x6d, 0x66, 0x2d, 0x32, 0x83, 
0x5e, 0x20, 0x13, 0x2f, 0xb2, 0xd1, 0x6d, 0xc6, 
0x6e, 0xb9, 0x5b, 0x97, 0xe7, 0xac, 0xb7, 0x3d, 
0x24, 0xf6, 0xbb, 0x83, 0x4e, 0xf1, 0xcb, 0x3e, 
0xbe, 0x81, 0x3d, 0x37, 0x00, 0x2f, 0x0c, 0xff, 
0x46, 0x87, 0xb0, 0x90, 0x44, 0x82, 0xd0, 0x41, 
0x1a, 0x59, 0x1b, 0x12, 0xc7, 0x5b, 0x6c, 0xab, 
0x34, 0x82, 0xee, 0xae, 0x74, 0x68, 0x35, 0xb3, 
0xab, 0xe7, 0x0f, 0x9a, 0x70, 0xfe, 0x2d, 0x2f, 
0xfa, 0x1b, 0xa6, 0xc1, 0xf1, 0x3d, 0x7f, 0xfb, 
0xfe, 0xb3, 0x83, 0x3b, 0xe5, 0x93, 0xe4, 0xd6, 
0x67, 0x55, 0xfb, 0x72, 0xfa, 0x48, 0x1e, 0x6c, 
0x4d, 0x8a, 0x1b, 0xc4, 0x3a, 0xfd, 0x5e, 0x74, 
0xcf, 0x58, 0x9d, 0x9c, 0x19, 0xad, 0xbd, 0x17, 
0x9d, 0x64, 0x79, 0xa1, 0xc3, 0x33, 0x47, 0xbb, 
0x54, 0x1e, 0x81, 0x54, 0xf3, 0xb7, 0x06, 0x26, 
0xca, 0x06, 0xb6, 0x4e, 0x6b, 0x45, 0xf4, 0xb8, 
0x34, 0xcd, 0xc8, 0xa5, 0xe9, 0x50, 0xf3, 0x71, 
0x3a, 0xf4, 0xe5, 0x10, 0x88, 0xca, 0x57, 0x0e, 
0x2e, 0xb1, 0x95, 0xac, 0xb5, 0x75, 0xe5, 0x6a, 
0x2d, 0x12, 0xd7, 0xc0, 0x52, 0xcd, 0x08, 0x50, 
0xcd, 0x27, 0x93, 0xf1, 0xb8, 0xf2, 0xe3, 0x09, 
0x91, 0x11, 0xd8, 0x92, 0x5d, 0xe2, 0x81, 0xcc, 
0x93, 0x84, 0xc8, 0x24, 0x71, 0xa3, 0x12, 0xd8, 
0x6c, 0x22, 0xe3, 0xaa, 0x1a, 0xb7, 0x2d, 0xb1, 
0x80, 0x6a, 0x60, 0x99, 0xb6, 0x49, 0x80, 0x36, 
0xed, 0xd0, 0xa1, 0xeb, 0xa4, 0xd9, 0x2b, 0x23, 
0x74, 0x58, 0x4d, 0x03, 0x94, 0x4c, 0x53, 0x09, 
0x32, 0xb6, 0xa0, 0xd7, 0x9a, 0x25, 0xfb, 0xf0, 
0xe0, 0xfc, 0x48, 0xa8, 0x1c, 0x81, 0xad, 0x9f, 
0xc8, 0xaf, 0xb6, 0xe5, 0x3f, 0x81, 0xd2, 0xa6, 
0xb2, 0x6f, 0xeb, 0xba, 0x25, 0x10, 0xb8, 0x09, 
0xde, 0x4e, 0x8c, 0xa8, 0xb9, 0x32, 0x44, 0xcd, 
0xe4, 0x9a, 0x53, 0x1f, 0x02, 0xa6, 0x52, 0x4b, 
0x0b, 0x6e, 0x2a, 0x35, 0xea, 0xd3, 0xfd, 0x24, 
0x19, 0x9e, 0x15, 0xe4, 0x23, 0xd7, 0x16, 0x88, 
0x6b, 0x84, 0x04, 0xd0, 0x5b, 0x35, 0x24, 0xef, 
0x0f, 0x41, 0x76, 0xda, 0x6c, 0x51, 0xd5, 0x06, 
0xe2, 0x6b, 0x71, 0x43, 0x08, 0x72, 0x29, 0x41, 
0x8e, 0x6b, 0xc7, 0xa1, 0x01, 0x71, 0x8d, 0xa6, 
0x26, 0x21, 0x22, 0x71, 0x53, 0xb6, 0x87, 0xe0, 
0x97, 0x41, 0x8a, 0x6b, 0x1f, 0x34, 0xd5, 0xb6, 
0xef, 0x1c, 0xbd, 0x63, 0x80, 0xa4, 0x93, 0xd7, 
0x32, 0x74, 0x97, 0x96, 0xe3, 0x7e, 0xe7, 0xa3, 
0xce, 0x21, 0x65, 0xab, 0xfc, 0x5c, 0x2e, 0x22, 
0xd2, 0xba, 0x66, 0x57, 0x50, 0x91, 0xd6, 0x63, 
0x0f, 0xdd, 0xe5, 0x67, 0x52, 0x21, 0x0a, 0x19, 
0xaa, 0x03, 0xdc, 0x5d, 0x3d, 0xe5, 0x57, 0x3f, 
0xda, 0x0c, 0xc7, 0x34, 0xda, 0xbb, 0x06, 0x99, 
0x87, 0xe8, 0xad, 0xf1, 0x54, 0x6f, 0x7e, 0xe0, 
0x94, 0xb9, 0x93, 0xdc, 0x6a, 0x6f, 0x3f, 0x3b, 
0xfe, 0xfa, 0xd3, 0xcf, 0xcd, 0x34, 0x7f, 0xf9, 
0xcd, 0xc1, 0x97, 0x92, 0x3d, 0xda, 0x9a, 0x32, 
0xbf, 0xa3, 0xdd, 0xac, 0xd6, 0x43, 0xfe, 0x93, 
0xaa, 0x47, 0xc2, 0x38, 0xa8, 0x18, 0xf0, 0x00, 
0xf3, 0x79, 0xb0, 0x00, 0x3f, 0xd6, 0x28, 0x06, 
0x38, 0x40, 0xae, 0xa2, 0xd5, 0x6c, 0xad, 0xc6, 
0x2c, 0xf2, 0x34, 0xf3, 0x5a, 0xe5, 0x45, 0xce, 
0x7d, 0x41, 0x29, 0xab, 0x81, 0xc8, 0x8a, 0xec, 
0xde, 0x49, 0x8a, 0xf9, 0x75, 0xe9, 0xf1, 0x4e, 
0x4b, 0x81, 0xf4, 0x01, 0xb8, 0xaa, 0xa9, 0x9a, 
0x46, 0x36, 0x58, 0x5c, 0x2d, 0xe9, 0x48, 0x0a, 
0x1a, 0x70, 0x68, 0xca, 0x35, 0xba, 0xb5, 0x5c, 
0x78, 0xc8, 0x95, 0x19, 0xb7, 0x23, 0xe2, 0xd8, 
0x97, 0x10, 0x58, 0x6e, 0x03, 0xf1, 0xae, 0x0a, 
0x7f, 0x57, 0xa6, 0x8d, 0x50, 0xc2, 0x88, 0x7f, 
0x1f, 0x76, 0xe1, 0x63, 0xb7, 0x01, 0xc3, 0xb3, 
0x2a, 0x79, 0xbe, 0x87, 0x9f, 0xed, 0x80, 0x64, 
0xc4, 0x2f, 0x7e, 0x11, 0xee, 0xdd, 0x64, 0x5b, 
0x40, 0x3b, 0x42, 0x82, 0xbc, 0xc7, 0x5e, 0x29, 
0x1c, 0xa1, 0x92, 0x4d, 0xcf, 0x65, 0x7f, 0x63, 
0xa0, 0xa3, 0x91, 0x37, 0xa6, 0x03, 0x5d, 0x20, 
0x93, 0x9e, 0x72, 0x27, 0xe1, 0x43, 0x80, 0xfc, 
0x42, 0x76, 0x11, 0x85, 0xcf, 0xcc, 0xde, 0x1e, 
0x7d, 0x24, 0x95, 0x05, 0x45, 0xb0, 0x93, 0x35, 
0x61, 0x06, 0xe1, 0xe3, 0xe4, 0x3d, 0xd8, 0xd3, 
0xe4, 0x30, 0xc9, 0x64, 0x93, 0x08, 0xda, 0xa6, 
0xfd, 0x06, 0xde, 0x6d, 0x9a, 0xf8, 0xa8, 0x9b, 
0x03, 0x7d, 0x79, 0x59, 0xeb, 0xe9, 0xcf, 0x98, 
0x45, 0x89, 0x99, 0x6e, 0x4d, 0x9a, 0x53, 0x9c, 
0x7f, 0xcf, 0xad, 0x3e, 0x87, 0x4f, 0x7b, 0x8e, 
0x6b, 0x1d, 0xa2, 0x8c, 0xc3, 0x9d, 0x9d, 0x1b, 
0xb5, 0x46, 0xa5, 0x3b, 0xd2, 0x39, 0x53, 0x3e, 
0xde, 0xc4, 0x12, 0x99, 0x68, 0xc4, 0xe1, 0x31, 
0x5f, 0x83, 0xa5, 0x21, 0xf5, 0x5c, 0xe2, 0xba, 
0xc3, 0x21, 0x8f, 0xe4, 0xd5, 0x77, 0x98, 0x75, 
0x70, 0x5f, 0xf4, 0xf5, 0xa1, 0x9d, 0x59, 0x6f, 
0x10, 0xb8, 0xf1, 0xd7, 0xb5, 0xd9, 0x69, 0x10,
0x19, 0xc9, 0x5c, 0xf8, 0x58, 0xee, 0xe0, 0x97, 
0xe8, 0x35, 0x3c, 0x2b, 0x3e, 0x1a, 0x0f, 0xef, 
0xed, 0x78, 0x71, 0x2b, 0x01, 0x23, 0x17, 0x4a, 
0x1a, 0xcb, 0x8e, 0x60, 0xa3, 0xe6, 0x48, 0x5a, 
0x8d, 0x9f, 0xaa, 0xdb, 0x44, 0xda, 0xd0, 0xf9, 
0x5e, 0x50, 0xf6, 0x27, 0xa1, 0xbc, 0xb1, 0x67, 
0xb0, 0xc6, 0x19, 0x8d, 0xf4, 0x3e, 0x1b, 0xdd, 
0xbc, 0x32, 0x7a, 0x60, 0x74, 0x4c, 0x91, 0xc1, 
0x2e, 0x0d, 0x4f, 0xa3, 0x28, 0x79, 0x2c, 0x26, 
0xbd, 0xfc, 0x20, 0x13, 0xd1, 0x9d, 0x51, 0x6a, 
0x1b, 0x85, 0x8d, 0x24, 0x63, 0x7a, 0x1e, 0xa1, 
0xa1, 0x59, 0xa9, 0xb8, 0x57, 0x69, 0x67, 0xf9, 
0x38, 0x8a, 0x5e, 0x23, 0xe0, 0xb3, 0x34, 0xae, 
0x72, 0x25, 0xd2, 0xe3, 0xed, 0x9a, 0x3e, 0xd6, 
0xe0, 0x9d, 0xad, 0x50, 0xd5, 0xe9, 0xd1, 0xae, 
0x1a, 0xac, 0xca, 0x8d, 0x06, 0x61, 0xaa, 0x2c, 
0x6f, 0xd3, 0x0d, 0x5e, 0x81, 0xb2, 0xd9, 0xc0, 
0x87, 0x81, 0x04, 0xcd, 0x86, 0xe1, 0xf6, 0x94, 
0x38, 0x76, 0xdb, 0x6b, 0x63, 0xad, 0x9a, 0x8c, 
0xef, 0x1b, 0x2a, 0x1e, 0xe5, 0x4d, 0xbb, 0xe8, 
0x54, 0x3e, 0x4d, 0x76, 0x54, 0x0e, 0xdd, 0xbe, 
0xdc, 0x3c, 0xbe, 0xb2, 0xda, 0x7c, 0x6c, 0x89, 
0xbc, 0x83, 0xe9, 0x03, 0x33, 0x88, 0x9d, 0xc7, 
0x97, 0xbb, 0x9c, 0xe7, 0x63, 0xfd, 0xf3, 0xf5, 
0xfe, 0x52, 0x84, 0x87, 0x27, 0x27, 0x27, 0x0f, 
0xbb, 0x95, 0xca, 0xff, 0xbe, 0xfa, 0x0d, 0xf4, 
0x57, 0xca, 0xfd, 0x17, 0xdb, 0x2a, 0xbc, 0x79, 
0x35, 0xcf, 0xf5, 0xd8, 0x60, 0x5d, 0x07, 0x4b, 
0x1d, 0x71, 0x5b, 0xc7, 0xa2, 0xd0, 0xc2, 0xe9, 
0x03, 0x23, 0x78, 0x4d, 0x2c, 0x4d, 0xe7, 0x9d, 
0x0f, 0x8f, 0x1d, 0x0c, 0xcb, 0x68, 0x81, 0x65, 
0x58, 0xc1, 0x6d, 0xa0, 0x70, 0x41, 0xb2, 0x83, 
0x5a, 0xaf, 0x87, 0xc0, 0x64, 0xfc, 0xa2, 0x8d, 
0x56, 0x75, 0xc8, 0x28, 0x00, 0x3d, 0xe4, 0xba, 
0x90, 0xee, 0x1d, 0x65, 0x4f, 0xf1, 0x69, 0x44, 
0x4b, 0x74, 0xfc, 0x96, 0xcb, 0xc4, 0x9e, 0xd2, 
0xb5, 0xb1, 0xa1, 0xb7, 0x50, 0x09, 0x37, 0xdb, 
0xc3, 0x4d, 0x0c, 0x15, 0x73, 0xb2, 0x52, 0x86, 
0x87, 0x0e, 0x3c, 0xe7, 0x7f, 0xd7, 0x12, 0x76, 
0xa6, 0x90, 0x6a, 0x39, 0xdf, 0x55, 0x46, 0x89, 
0x1d, 0x7c, 0xf1, 0x61, 0x37, 0x38, 0xcc, 0xb8, 
0x2c, 0x0b, 0x72, 0x92, 0x72, 0x8c, 0xe1, 0xff, 
0x35, 0xbb, 0xad, 0xa7, 0x97, 0x7c, 0xa7, 0xe5, 
0xe0, 0xfe, 0xe3, 0x17, 0xf9, 0xc0, 0x34, 0xe5, 
0xb6, 0x9a, 0x7e, 0xa4, 0x03, 0x85, 0xf3, 0xb6, 
0x88, 0xfe, 0x83, 0x79, 0xc3, 0xa6, 0x7c, 0x34, 
0x8e, 0x01, 0x4a, 0xcb, 0x59, 0x03, 0xef, 0x5a, 
0x84, 0x8a, 0x73, 0x71, 0x17, 0x74, 0x89, 0x25, 
0x96, 0xc6, 0x26, 0x2d, 0x52, 0x79, 0x2b, 0x61, 
0x87, 0x5a, 0x33, 0x90, 0xc5, 0x9d, 0x1b, 0xf7, 
0x0b, 0xc9, 0xc2, 0x4f, 0x4a, 0x11, 0x0a, 0x2b, 
0x7e, 0x8d, 0x87, 0x31, 0x12, 0x60, 0x67, 0xdc, 
0xe5, 0xb2, 0x21, 0xed, 0x96, 0x0c, 0xb8, 0x02 };
char peer1_14[] = {
0x79, 0xa5, 0x8b, 0xc1, 0xba, 0x94, 0x6a, 0x26, 
0x4b, 0xa0, 0x50, 0xed, 0x8c, 0xab, 0x98, 0xad, 
0x55, 0x05, 0x83, 0x94, 0xa5, 0x19, 0x54, 0x98, 
0xb8, 0x82, 0x6e, 0x91, 0xc8, 0xa1, 0x88, 0x70, 
0xd3, 0xc1, 0xa9, 0xe8, 0x05, 0x96, 0x56, 0xf6, 
0xad, 0xf1, 0xb9, 0xf7, 0xa6, 0x1a, 0x14, 0x96, 
0xdb, 0xe8, 0xe0, 0x1b, 0x03, 0x72, 0x64, 0x6e, 
0x96, 0x68, 0xee, 0x14, 0xf2, 0x5d, 0xac, 0xfc, 
0x1b, 0x01, 0xeb, 0xb2, 0x83, 0x17, 0xb1, 0x09, 
0x92, 0xb3, 0x74, 0x03, 0x4e, 0x51, 0xac, 0x21, 
0x16, 0x9c, 0xcb, 0x22, 0xee, 0xd9, 0x63, 0x95, 
0x01, 0x25, 0xc8, 0xb9, 0xd9, 0x96, 0x03, 0x0b, 
0x07, 0x13, 0x85, 0x28, 0x0b, 0xc4, 0x32, 0xc4, 
0x5e, 0xdc, 0x84, 0x68, 0xaf, 0xb2, 0x3b, 0x44, 
0x6b, 0x6b, 0x7e, 0xac, 0x0f, 0x19, 0xca, 0x08, 
0xbe, 0x90, 0x12, 0xd8, 0x99, 0xdd, 0xd6, 0x9a, 
0xb5, 0x55, 0x7d, 0x21, 0x75, 0x55, 0x56, 0x36, 
0xe0, 0x52, 0x6a, 0x2e, 0xa3, 0x19, 0xd2, 0x4e, 
0xff, 0xce, 0x56, 0xb6, 0x08, 0xdf, 0xdc, 0xc3, 
0x45, 0x51, 0xff, 0xa0, 0x41, 0x3c, 0x1f, 0x8d, 
0xe7, 0x4c, 0xd5, 0x7d, 0x90, 0x1f, 0xa8, 0x98, 
0x21, 0x14, 0xc7, 0x47, 0x53, 0x23, 0x59, 0x08, 
0xed, 0x30, 0xbd, 0x66, 0x4d, 0xda, 0x4d, 0x87, 
0x1c, 0xf1, 0xcf, 0xcf, 0x9b, 0xe0, 0xfc, 0x4f, 
0x17, 0x9c, 0x42, 0xfd, 0xc4, 0xf9, 0x57, 0x9f, 
0xce, 0x9e, 0xea, 0x1f, 0xa2, 0x4f, 0xde, 0x77, 
0x8c, 0x3b, 0xdf, 0x97, 0x99, 0x70, 0x19, 0xc8, 
0x32, 0x4a, 0x94, 0xd1, 0x43, 0x8f, 0x56, 0x35, 
0x6e, 0xe9, 0x65, 0x57, 0xb5, 0xf3, 0xb5, 0x20, 
0xc8, 0x87, 0xba, 0x23, 0xd0, 0x73, 0x85, 0xe0, 
0x66, 0x96, 0x3c, 0x79, 0x9f, 0x05, 0x2e, 0x6b, 
0xbd, 0xc8, 0x9a, 0x6f, 0x97, 0x40, 0xe9, 0x62, 
0x56, 0xd7, 0x80, 0x77, 0xf5, 0xb6, 0xd4, 0x69, 
0x3a, 0xfb, 0x4e, 0x7f, 0xfa, 0x0f, 0x00, 0x00, 
0xff, 0xff,
0x04, 0x26, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x15, 
0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x40, 
0x14, 0xc2, 0xb1, 0x0d, 0x80, 0x30, 0x0c, 0x45, 
0xc1, 0x48, 0xc8, 0x23, 0x98, 0x3e, 0x9d, 0xf5, 
0x97, 0xa0, 0x4f, 0x89, 0x78, 0x23, 0x79, 0x10, 
0x77, 0x91, 0xa7, 0x04, 0x4e, 0x77, 0x8c, 0xf3, 
0x72, 0x30, 0x98, 0x10, 0x20, 0x47, 0x89, 0x0a, 
0x6d, 0xd4, 0xae, 0x4e, 0x75, 0x69, 0x0f, 0x05, 
0x11, 0xcc, 0xe5, 0xb6, 0xdc, 0xef, 0xe4, 0xfb, 
0xd4, 0x1f, 0x7b, 0x01, 0x00, 0x00, 0xff, 0xff,
0x00, 0x00, 0x00, 0x01, 0x03, 0xe4, 0x02, 0xe7, 
0x00, 0x20, 0x00, 0x16, 0x00, 0x00, 0x00, 0x10, 
0x00, 0x00, 0x00, 0xbf, 0x54, 0x5b, 0x41, 0x0a, 
0x02, 0x31, 0x0c, 0xb4, 0x4d, 0x1a, 0xd7, 0x2a, 
0xec, 0x13, 0xf4, 0x28, 0x9e, 0x7c, 0x80, 0xe0, 
0xc1, 0xe7, 0xf8, 0x89, 0x2c, 0xb2, 0x17, 0xd1, 
0x3f, 0x3b, 0x93, 0xa0, 0xac, 0x87, 0xd2, 0x32, 
0x69, 0xd3, 0x42, 0x29, 0x49, 0x86, 0xe9, 0xfb, 
0xb4, 0x3a, 0x0c, 0xb2, 0xab, 0xc7, 0xf1, 0x72, 
0xee, 0x57, 0xbf, 0x4f, 0x23, 0x69, 0xd9, 0x1e, 
0xdd, 0x83, 0xba, 0xd0, 0x08, 0x6d, 0xac, 0x61, 
0xc9, 0x19, 0x48, 0x9d, 0x43, 0x2b, 0x2a, 0x19, 
0xa4, 0x50, 0x09, 0x2b, 0xe5, 0x99, 0x73, 0xa5, 
0xa6, 0xbd, 0xfd, 0x60, 0x16, 0x7e, 0x2e, 0x78, 
0x8d, 0x65, 0x50, 0x73, 0xcd, 0x08, 0x28, 0xe5, 
0x6b, 0xe0, 0x0f, 0x1e, 0xa5, 0xd6, 0x3e, 0xd3, 
0x8a, 0xb2, 0x34, 0x6d, 0xb0, 0xa4, 0xfd, 0x9b, 
0x70, 0xf3, 0x96, 0x26, 0x2c, 0x6a, 0xa1, 0x05, 
0x8d, 0x6c, 0x04, 0x9b, 0x3d, 0x49, 0x33, 0xac, 
0x13, 0xdf, 0x06, 0xc3, 0xc0, 0xdb, 0xe8, 0x7d, 
0x12, 0xe7, 0x04, 0x78, 0x6a, 0x0b, 0x78, 0xa2, 
0xdc, 0xa5, 0xe2, 0x89, 0xaa, 0x25, 0x88, 0xcc, 
0x32, 0x40, 0x43, 0xb9, 0x6e, 0x04, 0xe3, 0xfc, 
0x70, 0xcb, 0xa3, 0x68, 0x60, 0x1c, 0x21, 0x77, 
0x0c, 0x52, 0x23, 0xe6, 0x14, 0x47, 0xc4, 0x42, 
0x13, 0x37, 0xf4, 0xb7, 0xd7, 0xfe, 0x03, 0x00, 
0x00, 0xff, 0xff };
