--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Strings.Unbounded;

package Narval_Aws_Interface is
   --  strings with AWS should be included in a record, AWS limitation
   type String_Capsule is record
      String_Value : Ada.Strings.Unbounded.Unbounded_String;
   end record;
   type String_Array is array (Positive range <>) of String_Capsule;
   function Send_Command (Command : String) return String;
   function Send_Command_With_Arguments (Command : String;
                                         Arguments : String_Array)
     return String;
end Narval_Aws_Interface;
