--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
package body Narval.Actors.Actives.Producers is

   procedure On_Suspend (Object : access Producer_Type) is
   begin
      Object.Pause.Pause;
   end On_Suspend;

   procedure On_Resume (Object : access Producer_Type) is
   begin
      Object.Pause.Resume;
   end On_Resume;

   ------------------------------------
   -- procedure distribution_travail --
   ------------------------------------

   procedure Distribute_Work (Object : access Producer_Type) is
   begin
      select
         Object.Pause.Set_Pause_Off;
         Buffer_Handling (Active_Actor_Class_Access (Object));
      or
         delay Object.Waiting_Delay;
      end select;
   exception
      when E : others =>
         Log4ada.Loggers.Fatal_Out (Object.Logger'Access,
                                    "Distribution_Travail", E);
         raise;
   end Distribute_Work;

end Narval.Actors.Actives.Producers;
