--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
package Narval is
   pragma Pure;

   type Acquisition_State_Type is (Error, Initial, Configured, Loaded, Stopped,
                                   Running, Paused);

   subtype Actor_State_Type is Acquisition_State_Type range Loaded .. Paused;

   type Action is (Full_Reset, Partial_Reset,
                   Configure, Unconfigure,
                   Load, Unload,
                   Configure_Load, Unload_Unconfigure,
                   Initialise, Reset_Com,
                   Start, Stop,
                   Pause, Resume);
   type Action_Array is array (Positive range <>) of Action;

   Invalid_Order : exception;
   Illegal_Action : exception;
   Unknown_Parameter : exception;
   Unknown_Actor : exception;
   Unknown_Sub_System : exception;
   Actor_Not_Registred : exception;
   No_Active_Actors : exception;
   No_Configuration_File : exception;
   Read_Only_Parameter : exception;
   Write_Only_Parameter : exception;
   Shell_Problem : exception;
   Bad_Format : exception;
   Deprecated_Code : exception;

   type Mode_Type is (No_Access, Read_Only, Write_Only, Read_Write);

   Max_Name_Length : constant := 40;
   Max_Process_Name_Length : constant := 200;
   subtype Name_Index_Type is Integer range 1 .. Max_Name_Length;
   subtype Process_Name_Index_Type is Integer range
     1 .. Max_Process_Name_Length;
   Default_Name : constant String :=
     "*  nom non affecte *********************";
   Name_Too_Long : exception;
   Process_Name_Too_Long : exception;

   type Buffer_Enumeration_Type is (First, Second, Third);
   for Buffer_Enumeration_Type'Size use 8;
   for Buffer_Enumeration_Type use
      (First => 16#01#,
       Second => 16#02#,
       Third => 16#03#);
   Next : constant array (Buffer_Enumeration_Type) of
     Buffer_Enumeration_Type := (Second, Third, First);

   Max_Buffer_Number : constant := 3;
   type Buffer_Numbering_Type is range 0 .. Max_Buffer_Number;

   Max_Actor_Number : constant := 2000;
   type Actor_ID_Type is range 1 .. Max_Actor_Number;
   type Actor_Numbering_Type is range 0 .. Max_Actor_Number;
   type Rank_Type is range -1 .. Max_Actor_Number;
   type Actor_Kind_Type is (A_Stand_Alone_Actor,
                            A_Producer,
                            A_Consumer,
                            An_Intermediary);

   type Monitor_Kind is (Never, Request, Always);

   Kilo_Bytes : constant := 1024;
   Mega_Bytes : constant := Kilo_Bytes * Kilo_Bytes;
   Buffer_Maximal_Size : constant := 128 * Mega_Bytes;
   type Bytes_Buffer_Size_Type  is range 0 .. Buffer_Maximal_Size;

   --  type Type_Memoire is (Memoire_Standard, Memoire_Partagee);

   Unsupported_Feature : exception;

   Default_Waiting_Duration : constant Duration := 0.1;

   type Port_Familly_Type is (Fifo, Network);

   type Integer_Array is array (Positive range <>) of Integer;

   type Socket_Link_Type is record
      Address : String (1 .. 15);
      Port_Number : Positive;
      Data_Available : Boolean := False;
      Size : Bytes_Buffer_Size_Type := 1;
   end record;
   type Socket_Link_Array is array (Positive range <>) of Socket_Link_Type;

   type Link_Descriptor_Type (Port_For_Link : Port_Familly_Type;
                              Number_Of_Connection : Positive)
   is record
      case Port_For_Link is
         when Fifo =>
            Queue : Integer_Array (1 .. Number_Of_Connection);
         when Network =>
            Link : Socket_Link_Type;
      end case;
   end record;

   Configuration_Failed : exception;
   Unauthorized_Action : exception;
end Narval;
