/*
 * Decompiled with CFR 0.152.
 */
package org.helios.jmx.client.jboss;

import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.helios.jmx.client.AbstractHeliosJMXClient;
import org.helios.jmx.client.ConnectionException;
import org.helios.jmx.client.ConstructionException;

public class JBossRMIMBeanServerClient
extends AbstractHeliosJMXClient {
    protected Context ctx = null;
    protected MBeanServerConnection rmiAdaptor = null;
    protected String rmiAdaptorName = null;
    protected boolean basicOpsSupported = false;
    protected boolean notificationOpsSupported = false;
    public static final String JNDI_FACTORY = "org.jnp.interfaces.NamingContextFactory";
    public static final String JNDI_URL_PKG = "org.jboss.naming:org.jnp.interfaces";
    public static final String RMI_ADAPTOR_NAME = "org.jboss.rmiadaptor";
    public static final String RMI_ADAPTOR_NAME_DEFAULT = "jmx/invoker/RMIAdator";

    public JBossRMIMBeanServerClient() {
        throw new UnsupportedOperationException();
    }

    public JBossRMIMBeanServerClient(Properties env) throws ConnectionException, ConstructionException {
        super(env);
        this.rmiAdaptorName = env.getProperty(RMI_ADAPTOR_NAME, RMI_ADAPTOR_NAME_DEFAULT);
        if (this.clientPrincipal.equals("HeliosClient")) {
            this.clientPrincipal = null;
        }
        if (this.clientCredentials.equals("HeliosClientCredentials")) {
            this.clientCredentials = null;
        }
        this.initJNDI();
        this.initAdaptor();
    }

    protected void initJNDI() throws ConnectionException {
        try {
            Properties p = new Properties();
            p.put("java.naming.factory.url.pkgs", JNDI_URL_PKG);
            p.put("java.naming.factory.initial", JNDI_FACTORY);
            p.put("java.naming.provider.url", this.serverURL);
            if (this.clientPrincipal != null) {
                p.put("java.naming.security.principal", this.clientPrincipal);
            }
            if (this.clientCredentials != null) {
                p.put("java.naming.security.credentials", this.clientCredentials);
            }
            if (this.securityLevel != null) {
                p.put("java.naming.security.authentication", this.securityLevel);
            }
            if (this.securityProtocol != null) {
                p.put("java.naming.security.protocol", this.securityProtocol);
            }
            this.ctx = new InitialContext(p);
        }
        catch (Exception e) {
            throw new ConnectionException("Failed to acquire JNDI Context to JBoss Server at [" + this.serverURL + "]", e);
        }
    }

    protected void initAdaptor() throws ConnectionException {
        try {
            this.mBeanServerConnection = (MBeanServerConnection)this.ctx.lookup(this.rmiAdaptorName);
            this.basicOpsSupported = true;
            try {
                this.rmiAdaptor = this.mBeanServerConnection;
                this.notificationOpsSupported = true;
            }
            catch (Exception e) {
                this.notificationOpsSupported = false;
            }
        }
        catch (Exception e) {
            throw new ConnectionException("Failed to acquire JNDI Context to JBoss Server at [" + this.serverURL + "]", e);
        }
    }

    public boolean isLocal() {
        return false;
    }
}

