#!/usr/bin/perl -w

# rrd2-system.cgi - Abstractionlayer for imageprocessing
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller, Marius Hein
# $Id: rrd2-system.cgi 1275 2006-06-14 15:05:15Z mhein $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# includes
use strict;
use File::Basename;
use CGI qw(:standard);
use IO::Handle;
use Image::Magick;
use URI::Escape;
use Time::HiRes qw(gettimeofday tv_interval);
use NagiosGrapher;

# setting up the environment
my $q = new CGI;
my $graph_script = dirname($0). '/rrd2-graph.cgi';
my %params = $q->Vars;
my @param_arr = ();
my $ng = NagiosGrapher::getInstance();
my $font_file = $ng->get_ngraphercfg_value('fontfile');
my $time_start = [ gettimeofday ];

# preparing the contenttype and file type ext
my ($image_format, $content_type, $file_ext, $only_graph);

$only_graph = $params{'only-graph'} || 0;

$image_format = uc($params{'imageformat'});
if ($image_format =~ m/^(PNG|SVG|EPS|PDF)$/) {
	$image_format = $1;
}
else {
	$image_format = 'PNG';
}

if ($image_format eq 'PNG') {
	$content_type = 'image/png';
	$file_ext = 'png';
}
elsif ($image_format eq 'PDF') {
	$content_type = 'application/pdf';
	$file_ext = 'pdf';
}
elsif ($image_format eq 'EPS') {
	$content_type = 'application/postscript';
	$file_ext = 'eps';
}
elsif ($image_format eq 'SVG') {
	$content_type = 'image/svg+xml';
	$file_ext = 'svg';
}

# preparing the filename
my $filename = lc($params{'host'}. '_'. $params{'service'}. '_'. $params{'title'});
$filename =~ s/[\*\,\. \;]//g;
$filename .= '.'. $file_ext;

# preparing the call arguments
while (my($key, $val) = each(%params)) {
	push @param_arr, $key. '='. uri_escape($val);
}

my @caller = ($graph_script, join(';', @param_arr));

# get the image
my $perl = `which perl`;
chomp($perl);
my $image_bin;
open (IMG, "-|") || exec $perl,@caller;
while(<IMG>) {
  	$image_bin.=$_;
}
close(IMG);
my $code = 0;

if ($image_bin =~ m/^\[RETURN:([0-9]+)\]/) {
	$code = $1;
	$image_bin =~ s/^(\[.*?\])//;
}

if ($image_format eq 'PNG' && $code == 0 && !$only_graph) {
	$ng->time_need(type => 'start');
	# Adding brand
	my  $image = Image::Magick->new(magick => 'png');
	    $image->BlobToImage($image_bin);
		$image->[0]->Annotate(
			font=> $font_file,
			pointsize=>9,
			fill=>'lightgrey',
			y=>280,
			x=>7,
			antialias => 'true',
			gravity => 'NorthEast',
			rotate=>90,
			text=>'/ NagiosGrapher by NETWAYS GMBH'
		);

		# Adding Time Debug Output
		$image->[0]->Annotate(
			font => $font_file,
			pointsize=>9,
			y=>12,
			x=>2,
			fill=>'lightgrey',
			text=> '('. tv_interval($time_start, [ gettimeofday ]). 's)',
		);

		my @blobs = $image->ImageToBlob();
		$image_bin = $blobs[0];
	$ng->time_need(type => 'stop', msg => 'Adding PerlMagick');
}

# no buffered operations
STDOUT->autoflush(1);

# the http response headers
print STDOUT "Content-type: $content_type\n";
print STDOUT "Content-length: ". length($image_bin). "\n";
print STDOUT 'Content-disposition: filename='. $filename. "\n";
print STDOUT "\n";

# push the image
binmode STDOUT;
print $image_bin;

# default exit
exit (0);
1;

# [EOF]
