/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "tut_stdafx.h"

#include "grt/grt_structs_tree.h"

using namespace grt;
using namespace bec;

#include "grt_values_test_data.h"


BEGIN_TEST_DATA_CLASS(be_inspector_structs)
public:
  GRT grt;

  StructsTreeBE tree;

TEST_DATA_CONSTRUCTOR(be_inspector_structs)
  : tree(&grt)
{
}

END_TEST_DATA_CLASS;


TEST_MODULE(be_inspector_structs, "grt struct list inspector backends");



// Tests the Structs List
// ----------------------
TEST_FUNCTION(1)
{
  // Load test meta classes.
  grt.load_metaclasses("data/structs.test.xml");

  // Consolidate the loaded classes.
  grt.end_loading_metaclasses();
}


TEST_FUNCTION(2)
{
  // name listing

  int c;
  bool flag;
  NodeId node;

  tree.set_display_mode(StructsTreeBE::ByName);

  c= tree.count();
  ensure_equals("top node count", c, 6);

  IconId icon;
  std::string name;
  std::string caption;
  std::string type;
  std::string description;

  // 0
  
  node= tree.get_child(tree.get_root(), 0);
  ensure_equals("node", node.depth(), 1);
  ensure("get 1st child", node == tree.get_node(0));
  ensure("node", node.index!=0);
  flag= tree.get_row(node,
                     icon,
                     name,
                     caption,
                     type
                     );
  ensure("get node", flag);

  ensure_equals("name", name, "test.Author");
  ensure_equals("caption", caption, "");
  ensure_equals("type", type, "");
  ensure_equals("description", description, "");

  c= tree.count_children(node);
  ensure_equals("author children", c, 1);

  {
    NodeId parent= node;

    node= tree.get_child(parent, 0);
    flag= tree.get_row(node,
                       icon,
                       name,
                       caption,
                       type
                       );
    ensure("get author member", flag);

    ensure_equals("name", name, "name");
    ensure_equals("caption", caption, "");
    ensure_equals("type", type, "string");
    description= tree.get_field_description(node, StructsTreeBE::Name);
    ensure_equals("description", description, "name of the author");
  }
  
  // 1
  
  node= tree.get_child(tree.get_root(), 1);
  /*
  flag= tree.get_row(node,
                     ntype,
                     name,
                     caption,
                     type,
                     description
                     );
   */
  flag= tree.get_field(node, StructsTreeBE::Name, name);
  ensure("get node field", flag);
  flag= tree.get_field(node, StructsTreeBE::Caption, caption);
  ensure("get node field", flag);
  flag= tree.get_field(node, StructsTreeBE::Type, type);
  ensure("get node field", flag);

  ensure_equals("name", name, "test.Base");
  ensure_equals("caption", caption, "");
  ensure_equals("type", type, "");
  description= tree.get_field_description(node, StructsTreeBE::Name);
  ensure_equals("description", description, "");

  c= tree.count_children(node);
  ensure_equals("base children", c, 0);

  // 2

  node= tree.get_child(tree.get_root(), 2);
  flag= tree.get_row(node,
                     icon,
                     name,
                     caption,
                     type
                     );
  ensure("get node", flag);

  ensure_equals("name", name, "test.Book");
  ensure_equals("caption", caption, "Book");
  ensure_equals("type", type, "");
  description= tree.get_field_description(node, StructsTreeBE::Name);
  ensure_equals("description", description, "");

  c= tree.count_children(node);
  ensure_equals("book children", c, 5);

  {
    NodeId parent= node;

    node= tree.get_child(parent, 0);

    flag= tree.get_field(node, StructsTreeBE::Name, name);
    ensure("get field", flag);
    flag= tree.get_field(node, StructsTreeBE::Caption, caption);
    ensure("get field", flag);
    flag= tree.get_field(node, StructsTreeBE::Type, type);
    ensure("get field", flag);

    ensure_equals("name", name, "authors");
    ensure_equals("caption", caption, "Authors");
    ensure_equals("type", type, "list<test.Author>");
    description= tree.get_field_description(node, StructsTreeBE::Name);
    ensure_equals("description", description, "the list of authors");



    node= tree.get_child(parent, 4);
    flag= tree.get_row(node,
                       icon,
                       name,
                       caption,
                       type
                       );
    ensure("get book member", flag);

    ensure_equals("name", name, "publisher");
    ensure_equals("caption", caption, "Publisher");
    ensure_equals("type", type, "test.Publisher");
    description= tree.get_field_description(node, StructsTreeBE::Name);
    ensure_equals("description", description, "the book publisher");
  }
}


TEST_FUNCTION(3)
{
  // hierarchical listing

  int c;
  bool flag;
  NodeId node;
  
  tree.set_display_mode(StructsTreeBE::ByHierarchy);

  c= tree.count_children(tree.get_root());
  ensure_equals("top node count", c, 2);

  IconId icon;
  std::string name;
  std::string caption;
  std::string type;
  std::string description;

  // 0

  node= tree.get_child(tree.get_root(), 0);
  flag= tree.get_row(node,
                     icon,
                     name,
                     caption,
                     type
                     );
  ensure("get node", flag);

  ensure_equals("name", name, "test.Base");
  ensure_equals("caption", caption, "");
  ensure_equals("type", type, "");
  description= tree.get_field_description(node, StructsTreeBE::Name);
  ensure_equals("description", description, "");

  c= tree.count_children(node);
  ensure_equals("base children", c, 3);

  {
    NodeId parent= node;
    // 0.1

    node= tree.get_child(parent, 1);
    flag= tree.get_row(node,
                       icon,
                       name,
                       caption,
                       type
                       );
    ensure("get node", flag);
    
    ensure_equals("name", name, "test.Publication");
    ensure_equals("caption", caption, "Publication");
    ensure_equals("type", type, "");
    description= tree.get_field_description(node, StructsTreeBE::Name);
    ensure_equals("description", description, "");

    c= tree.count_children(node);
    ensure_equals("Publication children", c, 2);

    {
      NodeId pubnode= node;
      // 0.1.0

      node= tree.get_child(pubnode, 0);
      flag= tree.get_row(node,
                         icon,
                         name,
                         caption,
                         type
                         );
      ensure("get node", flag);
    
      ensure_equals("name", name, "test.Book");
      ensure_equals("caption", caption, "Book");
      ensure_equals("type", type, "");
      description= tree.get_field_description(node, StructsTreeBE::Name);
      ensure_equals("description", description, "");

      c= tree.count_children(node);
      ensure_equals("book children", c, 5);

      {
        // 0.1.0.0

        NodeId parent2= node;
        
        node= tree.get_child(parent2, 0);
        flag= tree.get_row(node,
                           icon,
                           name,
                           caption,
                           type
                           );
        ensure("get book member", flag);
        
        ensure_equals("name", name, "authors");
        ensure_equals("caption", caption, "Authors");
        ensure_equals("type", type, "list<test.Author>");
        description= tree.get_field_description(node, StructsTreeBE::Name);
        ensure_equals("description", description, "the list of authors");

        node= tree.get_child(parent2, 4);
        flag= tree.get_row(node,
                           icon,
                           name,
                           caption,
                           type
                           );
        ensure("get book member", flag);
        
        ensure_equals("name", name, "publisher");
        ensure_equals("caption", caption, "Publisher");
        ensure_equals("type", type, "test.Publisher");
        description= tree.get_field_description(node, StructsTreeBE::Name);
        ensure_equals("description", description, "the book publisher");
      }
    }
  }

  // 1

}


TEST_FUNCTION(4)
{
  // package listing

  int c;
  bool flag;
  NodeId node;
  
  tree.set_display_mode(StructsTreeBE::ByPackage);

  c= tree.count_children(tree.get_root());
  ensure_equals("top node count", c, 1);

  IconId icon;
  std::string name;
  std::string caption;
  std::string type;
  std::string description;

  // 0
  node= tree.get_child(tree.get_root(), 0);
  flag= tree.get_row(node,
                     icon,
                     name,
                     caption,
                     type
                     );
  ensure("get node", flag);
  
  ensure_equals("name", name, "test");
  ensure_equals("caption", caption, "");
  ensure_equals("type", type, "");
  description= tree.get_field_description(node, StructsTreeBE::Name);
  ensure_equals("description", description, "");
  
  c= tree.count_children(node);
  ensure_equals("base children", c, 6);

  {
    NodeId pkg= node;
    
    node= tree.get_child(pkg, 0);
    flag= tree.get_row(node,
                       icon,
                       name,
                       caption,
                       type
                       );
    ensure("get node", flag);
    
    ensure_equals("name", name, "test.Author");
    ensure_equals("caption", caption, "");
    ensure_equals("type", type, "");
    description= tree.get_field_description(node, StructsTreeBE::Name);
    ensure_equals("description", description, "");


    // 0.2
    // 
    node= tree.get_child(pkg, 2);
    flag= tree.get_row(node,
                       icon,
                       name,
                       caption,
                       type
                       );
    ensure("get node", flag);
    
    ensure_equals("name", name, "test.Book");
    ensure_equals("caption", caption, "Book");
    ensure_equals("type", type, "");
    description= tree.get_field_description(node, StructsTreeBE::Name);
    ensure_equals("description", description, "");
    
    c= tree.count_children(node);
    ensure_equals("book children", c, 5);
    
    {
      // 0.1.0
      // 
      NodeId parent2= node;
      
      node= tree.get_child(parent2, 0);
      flag= tree.get_row(node,
                         icon,
                         name,
                         caption,
                         type
                         );
      ensure("get book member", flag);
      
      ensure_equals("name", name, "authors");
      ensure_equals("caption", caption, "Authors");
      ensure_equals("type", type, "list<test.Author>");
      description= tree.get_field_description(node, StructsTreeBE::Name);
      ensure_equals("description", description, "the list of authors");
      
      
      
      node= tree.get_child(parent2, 4);
      flag= tree.get_row(node,
                         icon,
                         name,
                         caption,
                         type
                         );
      ensure("get book member", flag);

      ensure_equals("name", name, "publisher");
      ensure_equals("caption", caption, "Publisher");
      ensure_equals("type", type, "test.Publisher");
      description= tree.get_field_description(node, StructsTreeBE::Name);
      ensure_equals("description", description, "the book publisher");
    }
  }
  
  // 1
}



END_TESTS
