<? include("header.phpi") ?>

  <h2>Documentation</h2>

  <h3>Version History</h3>

  <h4>mod_bt 0.0.19</h4>
  
  <p><em>August 10th, 2006</em></p>

  <UL>
   <LI>
    Fixed an occasional segmentation fault that would happen when certain
    BitTorrent clients sent an /announce request.
   </LI>
   <LI>
    Fixed a bug that was causing specific /scrape requests to return nothing.
   </LI>
   <LI>
    Several fixes to get mod_bt to compile on 64-bit platforms and
    big-endian systems. mod_bt is now known to build successfully under
    Debian GNU/Linux on the following platforms:
    <UL>
     <LI>ARM</LI>
     <LI>m68k</LI>
     <LI>DEC Alpha</LI>
     <LI>AMD64</LI>
     <LI>HPPA</LI>
     <LI>i386</LI>
     <LI>Intel 64</LI>
     <LI>MIPS</LI>
     <LI>MIPSEL</LI>
     <LI>PowerPC</LI>
     <LI>S/390</LI>
     <LI>Sun Sparc</LI>
    </UL>
    <B>Many</B> thanks to
    <A HREF="http://www.debian.org/">the Debian project</A> for their
    automated builds and relentless bug reports!
   </LI>
   <LI>
    The <A HREF="http://www.debian.org/">Debian</A> build of mod_bt now
    adds an <CODE>Alias</CODE> directive to
    <A HREF="httpd.conf.txt">httpd.conf</A> to point to the tracker's
    CSS file.
   </LI>
   <LI>
    The build process for htdocs/ now dynamically generates the version
    number and "last updated" date. This means that when you compile your
    own mod_bt, your documentation directory will say that mod_bt was
    "Last Updated" on the day that you built it. CHANGES.html (this file)
    will still contain the official release date of each version. :-)
   </LI>
   <LI>
    Replaced the SHA1 implementation in <CODE>libbtutil</CODE> with a
    public-domain version to keep licensing issues simple.
   </LI>
   <LI>
    Added <A HREF="http://use.perl.org/~nik/journal/22137">libtap</A> to the
    tests/ directory. Using the
    <A HREF="http://search.cpan.org/~petdance/Test-Harness-2.62/lib/Test/Harness/TAP.pod">
     Test Anything Protocol
    </A>
    to build unit tests will not only make writing unit tests quicker, easier,
    and more fun... but it will also make it so that we can create fancy graphs
    of our results using QA tools like
    <A HREF="http://sourceforge.net/projects/smolder">Smolder</A>.
    If you want to see how easy writing unit tests under libtap is, check out
    the "single_torrent_test" function in
    <A HREF="http://p4.yi.org/@md=d&cd=//depot/main/apps/mod_bt/dev/src/tests/&cdf=//depot/main/apps/mod_bt/dev/src/tests/btp_torrent.c&sr=1068&c=nCU@//depot/main/apps/mod_bt/dev/src/tests/btp_torrent.c">
     btp_torrent.c
    </A>.
   </LI>
  </UL>

  <h4>mod_bt 0.0.18</h4>
  
  <p><em>June 27th, 2006</em></p>
  
  <UL>
   <LI>
    All code is licensed under the Apache License 2.x
    (<A HREF="http://bts.yi.org/cgi/bugreport.cgi?bug=24">Bug #24</A>).
    Previously:
    <UL>
     <LI>Perl components were "under the same terms as perl itself"</LI>
     <LI>PHP component was licensed under the PHP license</LI>
    </UL>
    Having everything under the same license makes it easier for this software
    to be bundled / distributed.
   </LI>
  </UL>

  <h4>mod_bt 0.0.17</h4>
  
  <p><em>June 17th, 2006</em></p>

  <UL>
   <LI>
    Fixes and updates to debian packageing;
    <UL>
     <LI>mod_bt debian packages now build for both php4 and php5.</LI>
     <LI>
      The <CODE>debian/rules</CODE> file dynamically figures out it's own version number,
      instead of having to be updated every single time a new version comes out.
     </LI>
     <LI>
      The <CODE>debian/rules</CODE> file also figures out what version of
      <CODE>libdb</CODE>
      we've compiled against, and the <CODE>debian/control</CODE> file uses
      this information to recommend the appropriate
      <CODE>db<B>x.xx</B>-util</CODE>
      package to use for database recovery.
     </LI>
    </UL>
   </LI>
   <LI>
    Fixed website template; everything that isn't part of the source
    tarball now links to
    <A HREF="http://www.crackerjack.net/mod_bt/">http://www.crackerjack.net/mod_bt/</A>,
    and download.php is automatically generated with the latest mod_bt version number.
   </LI>
   <LI>
    Cleaned up database connection and transaction handling; there aren't any
    more "dirty reads" to the database, which should improve transaction
    stability.
   </LI>
   <LI>
    When a master mod_bt process starts up now, it clears the 'peers'
    database. This means that if you do an 'apache2ctl restart', all of your
    peers will disappear until they reannounce. This is both a good thing
    and a bad thing;
    <UL>
     <LI>
      It's a good thing because it means that mod_bt doesn't have to spend
      time thinking about peers that have gone away after it's been down for
      awhile.
     </LI>
     <LI>
      It's a good thing because it makes it easier to clear your peerlist when,
      for instance, you've changed your apache security settings.
     </LI>
     <LI>
      It's a bad thing because these peers won't be known until they reannounce
      themselves, but under most configurations, this happens in under 10
      minutes.
     </LI>
    </UL>
   </LI>
   <LI>
    Changed iterators to announce, scrape, etc. data.
    They now allocate more memory at a time, and allocate the memory 
    outside of APR pools. The connection functions that call them are expected
    to allocate and free the buffer themselves instead of relying on APR.
    Since these could thread over hundreds (or thousands) of peers and we don't
    always know the string length in advance, it's a huge waste of memory
    to have all those reallocations happen in pools.
   </LI>
   <LI>
    Fixed a possible segfault in the <CODE>/announce</CODE> handler.
    (<A HREF="http://bts.yi.org/cgi/bugreport.cgi?bug=22">Bug #22</A>)
   </LI>
   <LI>
    Fixed a problem with the perl modules not compiling correctly on some
    platforms.
   </LI>
   <LI>
    mod_bt will now build against Berkeley DB 4.4 if it is available.
   </LI>
  </UL>

  <h4>mod_bt 0.0.16</h4>

  <p><em>May 25th, 2006</em></p>
  
  <UL>
   <LI>
    A new tool, <CODE>bt_showmetainfo</CODE> has been written. This tool
    should produce output that looks the same as the python-based official
    <CODE>btshowmetainfo</CODE> script.
   </LI>
   <LI>
    A new tool, <CODE>btt_infohash</CODE> has been written. This tool allows
    you do add/delete/edit/view infohash records in the mod_bt tracker
    database, and should be especially useful for registering torrents on
    a tracker that requires registration.
   </LI>
   <LI>
    <CODE>bt_db2xml</CODE> and <CODE>bt_xml2db</CODE> have been renamed to
    <CODE>btt_db2xml</CODE> and <CODE>btt_xml2db</CODE>.
   </LI>
   <LI>
    Changed database connection and transaction code a bit.
   </LI>
   <LI>
    bencode/metainfo parsing has been added to <CODE>libbtutil</CODE>,
    most of the logic borrowed from the
    <A HREF="http://transmission.m0k.org/">Transmission</A> project.
   </LI>
   <LI>Major changes to the code layout:
    <UL>
     <LI><CODE>libbtt</CODE> is now known as <CODE>libbttracker</CODE>.</LI>
     <LI>
      <CODE>Net::BitTorrent::LibBTT</CODE> is now known as
      <CODE>Net::BitTorrent::LibBT::Tracker</CODE>
     </LI>
     <LI>
      Functionality that would be useful to more than just trackers has
      been forked into a new library, <CODE>libbtutil</CODE>.
     </LI>
     <LI>
      Namespaces:
      <OL>
       <LI>
        Every exported symbol name in <CODE>libbttracker</CODE> now begins
        with "btt_".
       </LI>
       <LI>
        Every exported symbol name in <CODE>libbtutil</CODE> begins with
        "bt_".
       </LI>
       <LI>
        When <CODE>libbtpeer</CODE> is realized, every symbol name in that
        library will begin with "btp_".
       </LI>
      </OL>
     </LI>
     <LI>
      Most header files have been moved up one level, because that just
      makes more sense; eg <CODE>&lt;libbtt/cxn/cxn.h&gt;</CODE> is now
      <CODE>&lt;libbttracker/cxn.h&gt;</CODE>,
      <CODE>&lt;libbtt/libbtt.h&gt;</CODE> is now just
      <CODE>&lt;libbttracker.h&gt;</CODE>, etc.
     </LI>
     <LI>
      As a convienence,
      <CODE>&lt;libbttracker.h&gt;</CODE> and <CODE>&lt;libbtutil.h&gt;</CODE>
      now <CODE>#include</CODE> every other header file from their libraries,
      so you only need to include the top-level header to make use of the
      entire library.
     </LI>
    </UL>
   </LI>
  </UL>

  <h4>mod_bt 0.0.15</h4>

  <p><em>May 10th, 2006</em></p>

  <UL>
   <LI>
    New mod_bt website designed by <A HREF="http://www.arwen.org/"></A>Donna M.
    Jaggard</A>, at the <A HREF="no_apache_logo.txt">request</A> of the
    <A HREF="http://www.apache.org/foundation/">Apache Software Foundation</A>.
   </LI>
   <LI>
    Reworked shared memory management; now, if apache / the system crashes, mod_bt should be able
    to restart even if the shared memory segment/file still exists.
    (<A HREF="http://bts.yi.org/cgi/bugreport.cgi?bug=13">Bug #13</A>)
   </LI>
   <LI>
    Restored compatibility with libdb-4.2.
    (<A HREF="http://bts.yi.org/cgi/bugreport.cgi?bug=15">Bug #15</A>)
   </LI>
   <LI>
    New "Tracker" httpd.conf option; must be set to "On" for the tracker to operate.
    This both makes it easier to bundle mod_bt in a server without having to start it up,
    and solves an issue with mod_bt-enabled httpd's breaking test results from
    <A HREF="http://search.cpan.org/dist/Apache-Test/">Apache::Test</A>.
   </LI>
   <LI>
    mod_bt is now <A HREF="http://www.crackerjack.net/mod_bt/download.html">available</A>
    as a <A HREF="http://www.debian.org/">Debian</A> package.
   </LI>
   <LI>
    <CODE>bt_xml2db</CODE> script to recover your tracker's database from
    <CODE>bt_db2xml</CODE>'s output.
   </LI>
   <LI>
    The mod_bt source repository is now open to the public:
    <A HREF="http://p4.yi.org/depot/main/apps/mod_bt/dev/">http://p4.yi.org/depot/main/apps/mod_bt/dev/</A>
   </LI>
   <LI>
    Numerous build system fixes, including, but not limited to:
    <UL>
     <LI>Fixed "make install" for the PHP module</LI>
     <LI>Made it easier to compile without mod_perl, apache, etc.</LI>
    </UL>
   </LI>
   <LI>
    Infohash XML generation now uses <A HREF="http://www.xmlsoft.org/">LibXML2</A>.
   </LI>
   <LI>
    Small tweaks to make mod_bt behave nicely under both apr-0 (apache 2.0.x) and apr-1 (apache 2.1.x)
   </LI>
   <LI>Documentation updates</LI>
   <LI>
    Cuddled some elses.
   </LI>
  </UL>

  <h4>mod_bt 0.0.14</h4>
  
  <P><EM>April 20th, 2006</EM></P>

  <P>This has primarily been a "refactor the build system" release;</P>

  <UL>
   <LI>Moved Apache::ModBT to Apache2::ModBT to fit in with the mod_perl2 API</LI>
   <LI>
       Reworked source tree to use automake and libtool, as a result:
       <UL>
         <LI>"make install" now installs documentation in $(prefix)/share/doc/mod_bt</LI>
         <LI>libbtt is now dynamically linked in instead of static</LI>
       </UL>
   </LI>
   <LI>
       Fixed up perl modules' Makefile.PL's;
       with an installed libbtt.so it should now be possible to install perl
       modules directly from CPAN
   </LI>
   <LI>Another small change to libdb-4.2 detection</LI>
   <LI>
    Applied three pathes from Kenneth Porter for Fedora Core compatibility:
    <UL>
     <LI>Suppress incompatible apache regex symbols</LI>
     <LI>
      Include apr's include path in APXS's <TT>CFLAGS</TT>
      (odd this is neccessary, since even apxs needs apr to function...)
     </LI>
     <LI>
      Use <TT>$(MAKE)</TT> in all makefiles instead of <TT>make</TT>
     </LI>     
    </UL>
   </LI>
   <LI>mod_bt now has a <A HREF="http://adserton.crackerjack.net/cgi-bin/bugzilla/index.cgi">bugzilla database</A>.</LI>
  </UL>
  
  <h4>mod_bt 0.0.13</h4>
  
  <P><EM>January 9th, 2005</EM></P>

  <UL>
   <LI>Fixed some build problems (db-4.2, bad cflags, etc)</LI>
   <LI>Added --with-modperl-src configure directive</LI>
   <LI>Fixed a bug with "register", "details" handlers and PHP module that was only permitting
       32-bit filesizes (up to 4GB).
   </LI>
  </UL>

  <h4>mod_bt 0.0.12</h4>
  
  <P><EM>July 15th, 2004</EM></P>
  
  <UL>
   <LI>Moved HTML documentation generation from "make" to "make dist"</LI>
  
   <LI>Fixed a bug that caused a peer's "last serve" time to be re-set on each /announce request</LI>
   
   <LI>Fixed a bug that limited the "filesize" that could be registered on hashes to 2GB.</LI>
  
   <LI>Removed threaded operation support; it's going to require a major code overhaul...</LI>
   
   <LI>mod_bt website design by <A HREF="http://www.arwen.org/">Donna M. Jaggard</A>.</A></LI>
  </UL>
  
  
  <h4>mod_bt 0.0.11</h4>
  
  <P><EM>July 4th, 2004</EM></P>
  
  <UL>
   <LI>Reduced the maximum number of transactions, locks, and lockers in the Berekeley DB to reduce the database's base size. (I don't imagine a million locks ever being held at once anyway...)</LI>
   
   <LI>Added mutexes and database configs to support threaded operation.</LI>
   
   <LI>Improved autoconf tests for PHP/Perl support.</LI>
   
   <LI>mod_bt website logo by <A HREF="http://www.arwen.org/">Donna M. Jaggard</A>.</LI>
  </UL>
  
  <h4>mod_bt 0.0.10</h4>
  
  <P><EM>June 24th, 2004</EM></P>
  
  <UL>
   <LI>Improved documentation</LI>
   
   <LI>Details handler &amp; config value; <A HREF="configuration.html#modbt-details"><CODE>modbt-details</CODE></A> &amp; <A HREF="configuration.html#TrackerDetailURL"><CODE>TrackerDetailURL</CODE></A>.</LI>
   
   <LI>Support for SSI on root html info page; <A HREF="configuration.html#TrackerRootInclude"><CODE>TrackerRootInclude</CODE></A></LI>
   
   <LI>Added connection actions to <A HREF="Net_BitTorrent_LibBTT.html">Net::BitTorrent::LibBTT</A> perl module.</LI>
   
   <LI>Added <A HREF="bttrack.html">bttrack.pl</A> example perl tracker script.</LI>
  </UL>
  
  <h4>mod_bt 0.0.9</h4>
  
  <P><EM>June 22nd, 2004</EM></P>
  
  <UL>
   <LI>"written in haste" bugfix release: announce requests work again. (this broke when I added "same peer on multiple hashes" in 0.0.8 and I didn't test it enough.. *sigh*)</LI>
   
   <LI>"make install" now installs libraries and tools to --prefix (you may need to run "ldconfig" the first time)</LI>
   
   <LI>Fixed versioning number conventions in the perl modules</LI>
   
   <LI>Added a little bit of documentation</LI>
  </UL>
  
  <h4>mod_bt 0.0.8</h4>

  <P><EM>June 20th, 2004</EM></P>

  <UL>
   <LI>"make install" now properly installs the php_mod_bt module.</LI>
   
   <LI>The same peer-id is now usable on multiple infohashes.</LI>
   
   <LI>Put a "Crash Recovery" section into the documentation.</LI>
   
   <LI>Started preparing the source tree for using <CODE>libbt-1.01</CODE> to achieve passive peering (planned for 0.1.0).</LI>
   
   <LI>Filled out documentation for every method in Net::BitTorrent::LibBTT</LI>
   
   <LI>Created a mailing list for mod_bt announcements/discussion; subscribe at <A HREF="http://adserton.crackerjack.net/cgi-bin/mailman/listinfo/mod_bt">http://adserton.crackerjack.net/cgi-bin/mailman/listinfo/mod_bt</A>.</LI>
  </UL>
  
  <h4>mod_bt 0.0.7</h4>
  
  <P><EM>June 13th, 2004</EM></P>
  
  <UL>
   <LI>Fixed a bug that caused floating point exceptions when the only peer on a torrent sent a "stopped" request with "num_want=0".</LI>

   <LI>
    Fixed a bug with byte-ordering in "compact" responses. (I wish someone would have pointed that out to me when I
    <A HREF="http://groups.yahoo.com/group/BitTorrent/message/5516">posted</A> about this!)
   </LI>
   
   <LI>Changed the minimum required perl version from 5.8.4 to 5.6.0.</LI>
  </UL>
  
  <h4>mod_bt 0.0.6</h4>
  
  <P><EM>June 1st, 2004</EM></P>
  
  <UL>
   <LI>Fixed two bugs with the PHP build process that made it impossible to change which "php-config" program to use.</LI>
   
   <LI>Changed distribution so that it doesnt include .tgz's of every old version anymore.. that was a bit of a waste :)</LI>
   
   <LI>Debugging symbols are now stripped from libbtt.a/libbtt.so unless "--with-debug" is specified.</LI>
   
   <LI>Fixed a bug that appeared in 0.0.4 that caused some types of clients to never get served any peers.</LI>
   
   <LI>Fixed a horrid bug, that I don't know when it appeared, that set some peoples' IP's to "0.0.0.0".</LI>
  </UL>
  
  <h4>mod_bt 0.0.5</h4>
  
  <P><EM>May 30th, 2004</EM></P>
  
  <UL>
   <LI>Fixed a bug where scrapes with the "verbose=1" flag set would not return the correct number of seeds.</LI>
   
   <LI>mod_bt configuration is now handled by GNU autoconf.</LI>
   
   <LI>Added PHP language bindings; php_mod_bt (requires both mod_bt extension and apache2handler PHP SAPI)</LI>
   
   <LI>Fixed a bug with the scrape url's bencoding</LI>
  </UL>
  
  <h4>mod_bt 0.0.4</h4>

  <P><EM>May 25th, 2004</EM></P>
  
  <UL>
   <LI>Fixed bencoding bug in scrape URL</LI>
 
   <LI>Fixed the "apachectl restart" bug</LI>
 
   <LI>Fixed a bug that was causing peers' flags to be cleared after every request.</LI>
 
   <LI>Perl (and mod_perl) scripts can now communicate directly with the tracker; <A HREF="Net_BitTorrent_LibBTT.html">Net::BitTorrent::LibBTT</A> &amp; <A HREF="Apache_ModBT.html">Apache::ModBT</A></LI>
   
   <LI>Added "Shunned" peer flag; "Shunned" peers never get any peers returned to them and are never served to others.</LI>
 
   <LI>Made "Shunned" and "Shield" flags preserved on a peer across requests. (peer->flags = in_peer->flags | (peer->flags & BT_PEER_KEEP_FLAGS))</LI>
   
   <LI>Made a top-level Makefile and "config.mk" file in order to prepare for using autoconf.</LI>
  </UL>

  <h4>mod_bt 0.0.3</h4>
  
  <P><EM>May 20th, 2004</EM></P>
  
  <P>initial public release</P>

  <h4>mod_bt 0.0.2</h4>

  <P><EM>March, 2004</EM></P>
  
  <P>first version to use a disk-based database</P>

  <h4>mod_bt 0.0.1</h4>

  <P><EM>February, 2004</EM></P>
 
  <P>initial prototype version, ran 100% in shared memory with static limits on the number of peers and hashes.</P>

<? include("footer.phpi") ?>
