package com.mockobjects;

/*
 * TYPE TO PROVIDE VERY BASIC HASHSET IMPLEMENTATION TO BRIDGE GAP BETWEEN
 * JDK1.1.7 and JDK 1.2
 */


class HashSet extends java.util.Vector {

    /**
     * ArrayList constructor comment.
     */
    public HashSet() {
        super();
    }

    /**
     * ArrayList constructor comment.
     * @param initialCapacity int
     */
    public HashSet(int initialCapacity) {
        super(initialCapacity);
    }

    /**
     * ArrayList constructor comment.
     * @param initialCapacity int
     * @param capacityIncrement int
     */
    public HashSet(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public void add(Object item) {
        if(!this.contains(item))
            super.addElement(item);
    }

    public void clear() {
        super.removeAllElements();
    }

    public boolean equals(HashSet list) {
        for (int i = 0; i < list.size(); i++) {
            if (!this.contains(list.elementAt(i)))
                return false;
        }

        for (int i = 0; i < size(); i++) {
            if (!list.contains(this.elementAt(i)))
                return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if(obj instanceof HashSet)
            return equals((HashSet)obj);
        else
            return false;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Object[] toArray(Object[] result) {
        for(int i=0;i<this.size();i++) {
            result[i] = this.elementAt(i);
        }

        return result;
    }
}
