// Author(s): Wieger Wesselink
// Copyright: see the accompanying file COPYING or copy at
// https://svn.win.tue.nl/trac/MCRL2/browser/trunk/COPYING
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
/// \file mcrl2/basic/detail/soundness_checks.h
/// \brief Add your file description here.

#ifndef MCRL2_BASIC_DETAIL_SOUNDNESS_CHECKS_H
#define MCRL2_BASIC_DETAIL_SOUNDNESS_CHECKS_H

// This file contains soundness checks for LPS terms.
// N.B. This file is automatically generated!

#include <iostream>
#include "libstruct.h"
#include "libstruct_core.h"
#include "mcrl2/atermpp/aterm.h"
#include "mcrl2/atermpp/aterm_list.h"
#include "mcrl2/atermpp/aterm_appl.h"
#include "mcrl2/atermpp/aterm_traits.h"


namespace lps
{

namespace detail
{

using atermpp::aterm;
using atermpp::aterm_list;
using atermpp::aterm_appl;
using atermpp::aterm_traits;

// checks
// 1) if term t satisfies the predicate f
template <typename Term, typename CheckFunction>
bool check_term_argument(Term t, CheckFunction f)
{
  return f(t);
}

// checks
// 1) if term t is a list,
// 2) if the list has the proper minimum size
// 3) if all elements of the list satisfy the predicate f
template <typename Term, typename CheckFunction>
bool check_list_argument(Term t, CheckFunction f, unsigned int minimum_size)
{
  aterm term(aterm_traits<Term>::term(t));
  if (t.type() != AT_LIST)
  {
    return false;
  }
  aterm_list l(term);
  if (l.size() < minimum_size)
  {
    return false;
  }
  for (aterm_list::iterator i = l.begin(); i != l.end(); ++i)
  {
    if (!f(*i))
    {
      return false;
    }
  }
  return true;
}

template <typename Term>
bool check_rule_String(Term t)
{
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (a.size() > 0)
  {
    return false;
  }
  return true;
}

template <typename Term>
bool check_rule_NumberString(Term t)
{
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (a.size() > 0)
  {
    return false;
  }
  return true;
}

//--- begin generated code
template <typename Term> bool check_rule_SpecChi(Term t);
template <typename Term> bool check_rule_ModelDef(Term t);
template <typename Term> bool check_rule_ModelBody(Term t);
template <typename Term> bool check_rule_ProcDef(Term t);
template <typename Term> bool check_rule_ProcDecl(Term t);
template <typename Term> bool check_rule_Decl(Term t);
template <typename Term> bool check_rule_ProcBody(Term t);
template <typename Term> bool check_rule_VarSpec(Term t);
template <typename Term> bool check_rule_VarExpID(Term t);
template <typename Term> bool check_rule_VarID(Term t);
template <typename Term> bool check_rule_TypeExp(Term t);
template <typename Term> bool check_rule_TypeID(Term t);
template <typename Term> bool check_rule_ChannelTypedID(Term t);
template <typename Term> bool check_rule_ChannelID(Term t);
template <typename Term> bool check_rule_ComTyp(Term t);
template <typename Term> bool check_rule_Expr(Term t);
template <typename Term> bool check_rule_Statement(Term t);
template <typename Term> bool check_rule_OptGuard(Term t);
template <typename Term> bool check_rule_OptChannel(Term t);
template <typename Term> bool check_term_Instantiation(Term t);
template <typename Term> bool check_term_ChiSpec(Term t);
template <typename Term> bool check_term_ChanSpec(Term t);
template <typename Term> bool check_term_ChannelID(Term t);
template <typename Term> bool check_term_DeltaStat(Term t);
template <typename Term> bool check_term_Send(Term t);
template <typename Term> bool check_term_DataVarExprID(Term t);
template <typename Term> bool check_term_BinarySetExpression(Term t);
template <typename Term> bool check_term_Type(Term t);
template <typename Term> bool check_term_SepStat(Term t);
template <typename Term> bool check_term_OptGuard(Term t);
template <typename Term> bool check_term_Function(Term t);
template <typename Term> bool check_term_ModelDef(Term t);
template <typename Term> bool check_term_Nil(Term t);
template <typename Term> bool check_term_TupleDot(Term t);
template <typename Term> bool check_term_AltStat(Term t);
template <typename Term> bool check_term_DataVarID(Term t);
template <typename Term> bool check_term_AssignmentGGStat(Term t);
template <typename Term> bool check_term_ParStat(Term t);
template <typename Term> bool check_term_ListLiteral(Term t);
template <typename Term> bool check_term_AssignmentStat(Term t);
template <typename Term> bool check_term_Recv(Term t);
template <typename Term> bool check_term_SetType(Term t);
template <typename Term> bool check_term_Function2(Term t);
template <typename Term> bool check_term_ProcDecl(Term t);
template <typename Term> bool check_term_RecvStat(Term t);
template <typename Term> bool check_term_Delta(Term t);
template <typename Term> bool check_term_ParenthesisedStat(Term t);
template <typename Term> bool check_term_ChannelTypedID(Term t);
template <typename Term> bool check_term_TupleLiteral(Term t);
template <typename Term> bool check_term_ChanDecl(Term t);
template <typename Term> bool check_term_StarStat(Term t);
template <typename Term> bool check_term_SkipStat(Term t);
template <typename Term> bool check_term_ListType(Term t);
template <typename Term> bool check_term_BinaryExpression(Term t);
template <typename Term> bool check_term_OptChannel(Term t);
template <typename Term> bool check_term_TupleType(Term t);
template <typename Term> bool check_term_Expression(Term t);
template <typename Term> bool check_term_ProcDef(Term t);
template <typename Term> bool check_term_UnaryExpression(Term t);
template <typename Term> bool check_term_BinaryListExpression(Term t);
template <typename Term> bool check_term_ModelSpec(Term t);
template <typename Term> bool check_term_VarDecl(Term t);
template <typename Term> bool check_term_VarSpec(Term t);
template <typename Term> bool check_term_SendStat(Term t);
template <typename Term> bool check_term_Skip(Term t);
template <typename Term> bool check_term_ProcSpec(Term t);
template <typename Term> bool check_term_SetLiteral(Term t);
template <typename Term> bool check_term_GuardedStarStat(Term t);

template <typename Term>
bool check_rule_SpecChi(Term t)
{
  return    check_term_ChiSpec(t);
}

template <typename Term>
bool check_rule_ModelDef(Term t)
{
  return    check_term_ModelDef(t);
}

template <typename Term>
bool check_rule_ModelBody(Term t)
{
  return    check_term_ModelSpec(t);
}

template <typename Term>
bool check_rule_ProcDef(Term t)
{
  return    check_term_ProcDef(t);
}

template <typename Term>
bool check_rule_ProcDecl(Term t)
{
  return    check_term_ProcDecl(t);
}

template <typename Term>
bool check_rule_Decl(Term t)
{
  return    check_term_VarDecl(t)
            || check_term_ChanDecl(t);
}

template <typename Term>
bool check_rule_ProcBody(Term t)
{
  return    check_term_ProcSpec(t);
}

template <typename Term>
bool check_rule_VarSpec(Term t)
{
  return    check_term_VarSpec(t)
            || check_term_ChanSpec(t);
}

template <typename Term>
bool check_rule_VarExpID(Term t)
{
  return    check_term_DataVarExprID(t)
            || check_rule_VarID(t);
}

template <typename Term>
bool check_rule_VarID(Term t)
{
  return    check_term_DataVarID(t);
}

template <typename Term>
bool check_rule_TypeExp(Term t)
{
  return    check_rule_TypeID(t)
            || check_term_SetType(t)
            || check_term_ListType(t)
            || check_term_TupleType(t);
}

template <typename Term>
bool check_rule_TypeID(Term t)
{
  return    check_term_Type(t);
}

template <typename Term>
bool check_rule_ChannelTypedID(Term t)
{
  return    check_term_ChannelTypedID(t);
}

template <typename Term>
bool check_rule_ChannelID(Term t)
{
  return    check_term_ChannelID(t);
}

template <typename Term>
bool check_rule_ComTyp(Term t)
{
  return    check_term_Nil(t)
            || check_term_Send(t)
            || check_term_Recv(t);
}

template <typename Term>
bool check_rule_Expr(Term t)
{
  return    check_term_Expression(t)
            || check_term_UnaryExpression(t)
            || check_term_BinaryExpression(t)
            || check_term_ListLiteral(t)
            || check_term_SetLiteral(t)
            || check_term_TupleLiteral(t)
            || check_term_BinaryListExpression(t)
            || check_term_BinarySetExpression(t)
            || check_term_Function(t)
            || check_term_Function2(t)
            || check_term_TupleDot(t);
}

template <typename Term>
bool check_rule_Statement(Term t)
{
  return    check_term_SkipStat(t)
            || check_term_AssignmentStat(t)
            || check_term_AssignmentGGStat(t)
            || check_term_ParenthesisedStat(t)
            || check_term_SepStat(t)
            || check_term_AltStat(t)
            || check_term_ParStat(t)
            || check_term_StarStat(t)
            || check_term_GuardedStarStat(t)
            || check_term_DeltaStat(t)
            || check_term_Instantiation(t)
            || check_term_SendStat(t)
            || check_term_RecvStat(t);
}

template <typename Term>
bool check_rule_OptGuard(Term t)
{
  return    check_rule_Expr(t)
            || check_term_Nil(t);
}

template <typename Term>
bool check_rule_OptChannel(Term t)
{
  return    check_term_Nil(t);
}

// Instantiation(String, Expr*)
template <typename Term>
bool check_term_Instantiation(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsInstantiation(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_list_argument(a(1), check_rule_Expr<aterm>, 0))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ChiSpec(ModelDef, ProcDef+)
template <typename Term>
bool check_term_ChiSpec(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsChiSpec(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_ModelDef<aterm>))
  {
    std::cerr << "check_rule_ModelDef" << std::endl;
    return false;
  }
  if (!check_list_argument(a(1), check_rule_ProcDef<aterm>, 1))
  {
    std::cerr << "check_rule_ProcDef" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ChanSpec(ChanID+)
template <typename Term>
bool check_term_ChanSpec(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsChanSpec(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_ChanID<aterm>, 1))
  {
    std::cerr << "check_rule_ChanID" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ChannelID(VarID, ComType)
template <typename Term>
bool check_term_ChannelID(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsChannelID(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_VarID<aterm>))
  {
    std::cerr << "check_rule_VarID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_ComType<aterm>))
  {
    std::cerr << "check_rule_ComType" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// DeltaStat(OptGuard, Delta)
template <typename Term>
bool check_term_DeltaStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsDeltaStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_term_OptGuard<aterm>))
  {
    std::cerr << "check_term_OptGuard" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_term_Delta<aterm>))
  {
    std::cerr << "check_term_Delta" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// Send()
template <typename Term>
bool check_term_Send(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsSend(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 0)
  {
    return false;
  }

  return true;
}

// DataVarExprID(VarID, Expr)
template <typename Term>
bool check_term_DataVarExprID(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsDataVarExprID(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_VarID<aterm>))
  {
    std::cerr << "check_rule_VarID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// BinarySetExpression(String, TypeID, Expr, Expr)
template <typename Term>
bool check_term_BinarySetExpression(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsBinarySetExpression(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 4)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(3), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// Type(String)
template <typename Term>
bool check_term_Type(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsType(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// SepStat(Statement, Statement)
template <typename Term>
bool check_term_SepStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsSepStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// OptGuard()
template <typename Term>
bool check_term_OptGuard(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsOptGuard(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 0)
  {
    return false;
  }

  return true;
}

// Function(String, TypeID, Expr)
template <typename Term>
bool check_term_Function(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsFunction(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 3)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ModelDef(String, ModelBody)
template <typename Term>
bool check_term_ModelDef(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsModelDef(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_ModelBody<aterm>))
  {
    std::cerr << "check_rule_ModelBody" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// Nil()
template <typename Term>
bool check_term_Nil(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsNil(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 0)
  {
    return false;
  }

  return true;
}

// TupleDot(Expr, TypeID, String)
template <typename Term>
bool check_term_TupleDot(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsTupleDot(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 3)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// AltStat(Statement, Statement)
template <typename Term>
bool check_term_AltStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsAltStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// DataVarID(String, TypeExp)
template <typename Term>
bool check_term_DataVarID(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsDataVarID(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeExp<aterm>))
  {
    std::cerr << "check_rule_TypeExp" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// AssignmentGGStat(OptGuard, OptChannel, Expr+, Expr+)
template <typename Term>
bool check_term_AssignmentGGStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsAssignmentGGStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 4)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_term_OptGuard<aterm>))
  {
    std::cerr << "check_term_OptGuard" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_term_OptChannel<aterm>))
  {
    std::cerr << "check_term_OptChannel" << std::endl;
    return false;
  }
  if (!check_list_argument(a(2), check_rule_Expr<aterm>, 1))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_list_argument(a(3), check_rule_Expr<aterm>, 1))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ParStat(Statement, Statement)
template <typename Term>
bool check_term_ParStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsParStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ListLiteral(Expr*, TypeID)
template <typename Term>
bool check_term_ListLiteral(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsListLiteral(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_Expr<aterm>, 0))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// AssignmentStat(OptGuard, OptChannel, Expr+, Expr+)
template <typename Term>
bool check_term_AssignmentStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsAssignmentStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 4)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_term_OptGuard<aterm>))
  {
    std::cerr << "check_term_OptGuard" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_term_OptChannel<aterm>))
  {
    std::cerr << "check_term_OptChannel" << std::endl;
    return false;
  }
  if (!check_list_argument(a(2), check_rule_Expr<aterm>, 1))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_list_argument(a(3), check_rule_Expr<aterm>, 1))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// Recv()
template <typename Term>
bool check_term_Recv(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsRecv(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 0)
  {
    return false;
  }

  return true;
}

// SetType(TypeExpr)
template <typename Term>
bool check_term_SetType(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsSetType(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_TypeExpr<aterm>))
  {
    std::cerr << "check_rule_TypeExpr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// Function2(String, TypeID, Expr, Expr)
template <typename Term>
bool check_term_Function2(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsFunction2(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 4)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(3), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ProcDecl(Decl*)
template <typename Term>
bool check_term_ProcDecl(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsProcDecl(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_Decl<aterm>, 0))
  {
    std::cerr << "check_rule_Decl" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// RecvStat(OptGuard, Expr, Expr, Expr+)
template <typename Term>
bool check_term_RecvStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsRecvStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 4)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_term_OptGuard<aterm>))
  {
    std::cerr << "check_term_OptGuard" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_list_argument(a(3), check_rule_Expr<aterm>, 1))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// Delta()
template <typename Term>
bool check_term_Delta(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsDelta(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 0)
  {
    return false;
  }

  return true;
}

// ParenthesisedStat(Statement)
template <typename Term>
bool check_term_ParenthesisedStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsParenthesisedStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ChannelTypedID(ChannelID, TypeID, Expr)
template <typename Term>
bool check_term_ChannelTypedID(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsChannelTypedID(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 3)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_ChannelID<aterm>))
  {
    std::cerr << "check_rule_ChannelID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// TupleLiteral(Expr*, TypeID)
template <typename Term>
bool check_term_TupleLiteral(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsTupleLiteral(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_Expr<aterm>, 0))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ChanDecl(TypedChannels+)
template <typename Term>
bool check_term_ChanDecl(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsChanDecl(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_TypedChannels<aterm>, 1))
  {
    std::cerr << "check_rule_TypedChannels" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// StarStat(Statement)
template <typename Term>
bool check_term_StarStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsStarStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// SkipStat(OptGuard, OptChannel, Skip)
template <typename Term>
bool check_term_SkipStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsSkipStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 3)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_term_OptGuard<aterm>))
  {
    std::cerr << "check_term_OptGuard" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_term_OptChannel<aterm>))
  {
    std::cerr << "check_term_OptChannel" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_term_Skip<aterm>))
  {
    std::cerr << "check_term_Skip" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ListType(TypeExpr)
template <typename Term>
bool check_term_ListType(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsListType(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_TypeExpr<aterm>))
  {
    std::cerr << "check_rule_TypeExpr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// BinaryExpression(String, TypeID, Expr, Expr)
template <typename Term>
bool check_term_BinaryExpression(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsBinaryExpression(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 4)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(3), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// OptChannel()
template <typename Term>
bool check_term_OptChannel(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsOptChannel(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 0)
  {
    return false;
  }

  return true;
}

// TupleType(TypeExpr+)
template <typename Term>
bool check_term_TupleType(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsTupleType(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_TypeExpr<aterm>, 1))
  {
    std::cerr << "check_rule_TypeExpr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// Expression(String, TypeID)
template <typename Term>
bool check_term_Expression(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsExpression(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ProcDef(String, ProcDecl, ProcBody)
template <typename Term>
bool check_term_ProcDef(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsProcDef(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 3)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_ProcDecl<aterm>))
  {
    std::cerr << "check_rule_ProcDecl" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_ProcBody<aterm>))
  {
    std::cerr << "check_rule_ProcBody" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// UnaryExpression(String, TypeID, Expr)
template <typename Term>
bool check_term_UnaryExpression(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsUnaryExpression(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 3)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// BinaryListExpression(String, TypeID, Expr, Expr)
template <typename Term>
bool check_term_BinaryListExpression(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsBinaryListExpression(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 4)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_String<aterm>))
  {
    std::cerr << "check_rule_String" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(3), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// ModelSpec(VarSpec*, Statement)
template <typename Term>
bool check_term_ModelSpec(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsModelSpec(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_VarSpec<aterm>, 0))
  {
    std::cerr << "check_rule_VarSpec" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// VarDecl(VarID+)
template <typename Term>
bool check_term_VarDecl(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsVarDecl(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_VarID<aterm>, 1))
  {
    std::cerr << "check_rule_VarID" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// VarSpec(VarExpID+)
template <typename Term>
bool check_term_VarSpec(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsVarSpec(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 1)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_VarExpID<aterm>, 1))
  {
    std::cerr << "check_rule_VarExpID" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// SendStat(OptGuard, Expr, Expr, Expr+)
template <typename Term>
bool check_term_SendStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsSendStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 4)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_term_OptGuard<aterm>))
  {
    std::cerr << "check_term_OptGuard" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(2), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_list_argument(a(3), check_rule_Expr<aterm>, 1))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// Skip()
template <typename Term>
bool check_term_Skip(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsSkip(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 0)
  {
    return false;
  }

  return true;
}

// ProcSpec(VarSpec*, Statement)
template <typename Term>
bool check_term_ProcSpec(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsProcSpec(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_VarSpec<aterm>, 0))
  {
    std::cerr << "check_rule_VarSpec" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// SetLiteral(Expr*, TypeID)
template <typename Term>
bool check_term_SetLiteral(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsSetLiteral(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_list_argument(a(0), check_rule_Expr<aterm>, 0))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_TypeID<aterm>))
  {
    std::cerr << "check_rule_TypeID" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}

// GuardedStarStat(Expr, Statement)
template <typename Term>
bool check_term_GuardedStarStat(Term t)
{
  // check the type of the term
  aterm term(aterm_traits<Term>::term(t));
  if (term.type() != AT_APPL)
  {
    return false;
  }
  aterm_appl a(term);
  if (!gsIsGuardedStarStat(a))
  {
    return false;
  }

  // check the children
  if (a.size() != 2)
  {
    return false;
  }
#ifndef LPS_NO_RECURSIVE_SOUNDNESS_CHECKS
  if (!check_term_argument(a(0), check_rule_Expr<aterm>))
  {
    std::cerr << "check_rule_Expr" << std::endl;
    return false;
  }
  if (!check_term_argument(a(1), check_rule_Statement<aterm>))
  {
    std::cerr << "check_rule_Statement" << std::endl;
    return false;
  }
#endif // LPS_NO_RECURSIVE_SOUNDNESS_CHECKS

  return true;
}
//--- end generated code

} // namespace detail

} // namespace lps

#endif // MCRL2_BASIC_DETAIL_SOUNDNESS_CHECKS_H
