# Function to convert simple ETS project names and versions to a requirements
# spec that works for both development builds and stable builds.  Allows
# a caller to specify a max version, which is intended to work along with
# Enthought's standard versioning scheme -- see the following write up:
#    https://svn.enthought.com/enthought/wiki/EnthoughtVersionNumbers
def etsdep(p, min, max=None, literal=False):
    require = '%s >=%s.dev' % (p, min)
    if max is not None:
        if literal is False:
            require = '%s, <%sa' % (require, max)
        else:
            require = '%s, <%s' % (require, max)
    return require


# Declare our ETS project dependencies.
ENVISAGE = etsdep('enthought.envisage', '2.0.4', '3.0')
PYFACE_TVTK = etsdep('enthought.pyface[tvtk]', '2.0.4', '3.1')
TRAITS_UI = etsdep('enthought.traits[ui]', '2.0.5', '3.1')
TRAITSUIWX = etsdep('enthought.traits.ui.wx', '2.0.5', '3.1')


# A dictionary of the setup data information.
INFO = {
    'extras_require': {
        'plugin': [
            ENVISAGE,
            ],
        'wx': [
            TRAITSUIWX,
            ],

        # All non-ets dependencies should be in this extra to ensure users can
        # decide whether to require them or not.
        'nonets': [
            # 'VTK',  # fixme: VTK is not available as an egg on all platforms.
            'numpy >= 1.0.3',
            ],
        },
    'install_requires': [
        PYFACE_TVTK,
        TRAITS_UI,
        ],
    'name': 'enthought.tvtk',
    'version': '2.1.0',
    }

