/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailbox.h"

#include "mn-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 56 "src/mn-mailbox.gob"

#include <glib/gi18n.h>
#include <libgnomevfs/gnome-vfs.h>
#if WITH_MBOX || WITH_MOZILLA || WITH_MH || WITH_MAILDIR || WITH_SYLPHEED
#include "mn-system-vfs-mailbox.h"
#include "mn-custom-vfs-mailbox.h"
#endif
#if WITH_POP3
#include "mn-pop3-mailbox.h"
#endif
#if WITH_IMAP
#include "mn-imap-mailbox.h"
#endif
#if WITH_GMAIL
#include "mn-gmail-mailbox.h"
#endif
#if WITH_YAHOO
#include "mn-yahoo-mailbox.h"
#endif
#if WITH_HOTMAIL
#include "mn-hotmail-mailbox.h"
#endif
#if WITH_EVOLUTION
#include "mn-evolution-mailbox.h"
#endif
#include "mn-util.h"
#include "mn-message.h"
#include "mn-conf.h"
#include "mn-locked-callback.h"
#include "mn-shell.h"

struct _MNMailboxConfiguration
{
  GType		type;
  unsigned int	n_parameters;
  GParameter	*parameters;
};

GType mn_mailbox_types[MN_MAILBOX_MAX_TYPES + 1];

typedef struct
{
  MNMailbox	*self;
  GHashTable	*messages;
  GHashTable	*messages_considered_as_read;
  gboolean	display_seen_mail;
} FilterMessagesInfo;

typedef struct
{
  GHashTable	*other;
  gboolean	changed;
} CompareMessagesInfo;

static unsigned int cleanup_messages_considered_as_read_idle_id = 0;

#line 83 "mn-mailbox.c"
/* self casting macros */
#define SELF(x) MN_MAILBOX(x)
#define SELF_CONST(x) MN_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOX(x)
#define TYPE_SELF MN_TYPE_MAILBOX
#define SELF_CLASS(x) MN_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNMailbox Self;
typedef MNMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/mn-mailbox.gob"
static void mn_mailbox_class_init (MNMailboxClass * c);
#line 102 "mn-mailbox.c"
#line 141 "src/mn-mailbox.gob"
static void mn_mailbox_set_active (MNMailbox * self, gboolean value);
#line 105 "mn-mailbox.c"
static void ___real_mn_mailbox_added (MNMailbox * self);
static void ___real_mn_mailbox_removed (MNMailbox * self);
#line 259 "src/mn-mailbox.gob"
static void mn_mailbox_update_check_timeout (MNMailbox * self);
#line 110 "mn-mailbox.c"
#line 330 "src/mn-mailbox.gob"
static void mn_mailbox_filter_messages (MNMailbox * self);
#line 113 "mn-mailbox.c"
#line 366 "src/mn-mailbox.gob"
static void mn_mailbox_filter_messages_cb (const char * id, MNMessage * message, FilterMessagesInfo * info);
#line 116 "mn-mailbox.c"
#line 395 "src/mn-mailbox.gob"
static gboolean mn_mailbox_compare_messages (GHashTable * messages1, GHashTable * messages2);
#line 119 "mn-mailbox.c"
#line 407 "src/mn-mailbox.gob"
static void mn_mailbox_compare_messages_cb (const char * id, MNMessage * message, CompareMessagesInfo * info);
#line 122 "mn-mailbox.c"
#line 416 "src/mn-mailbox.gob"
static void mn_mailbox_queue_cleanup_messages_considered_as_read (void);
#line 125 "mn-mailbox.c"
#line 423 "src/mn-mailbox.gob"
static gboolean mn_mailbox_cleanup_messages_considered_as_read_cb (gpointer data);
#line 128 "mn-mailbox.c"
#line 444 "src/mn-mailbox.gob"
static void mn_mailbox_cleanup_messages_considered_as_read (void);
#line 131 "mn-mailbox.c"
#line 472 "src/mn-mailbox.gob"
static gboolean mn_mailbox_cleanup_messages_considered_as_read_remove_cb (const char * id, gpointer value, gpointer user_data);
#line 134 "mn-mailbox.c"
#line 503 "src/mn-mailbox.gob"
static void mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new);
#line 137 "mn-mailbox.c"
#line 596 "src/mn-mailbox.gob"
static void mn_mailbox_init (MNMailbox * self);
#line 140 "mn-mailbox.c"
#line 604 "src/mn-mailbox.gob"
static void mn_mailbox_finalize (MNMailbox * self);
#line 143 "mn-mailbox.c"
#line 615 "src/mn-mailbox.gob"
static void mn_mailbox_notify_display_seen_messages_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data);
#line 146 "mn-mailbox.c"
#line 626 "src/mn-mailbox.gob"
static void mn_mailbox_notify_messages_considered_as_read_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data);
#line 149 "mn-mailbox.c"
#line 811 "src/mn-mailbox.gob"
static MNMailbox * mn_mailbox_parse_obsolete_uri (const char * uri);
#line 152 "mn-mailbox.c"
#line 1035 "src/mn-mailbox.gob"
static gboolean mn_mailbox_check_timeout_cb (gpointer data);
#line 155 "mn-mailbox.c"
#line 1045 "src/mn-mailbox.gob"
static gboolean mn_mailbox_validate (MNMailbox * self, GError ** err);
#line 158 "mn-mailbox.c"
static void ___real_mn_mailbox_seal (MNMailbox * self);
#line 1109 "src/mn-mailbox.gob"
static MNMailbox * mn_mailbox_parse_uri (MNMailbox * self, const char * uri) G_GNUC_UNUSED;
#line 162 "mn-mailbox.c"
static void ___real_mn_mailbox_check (MNMailbox * self);

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__added(object,func,data)	mn_mailbox_connect__added((object),(func),(data))
#define self_connect_after__added(object,func,data)	mn_mailbox_connect_after__added((object),(func),(data))
#define self_connect_data__added(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__added((object),(func),(data),(destroy_data),(flags))
#define self_connect__removed(object,func,data)	mn_mailbox_connect__removed((object),(func),(data))
#define self_connect_after__removed(object,func,data)	mn_mailbox_connect_after__removed((object),(func),(data))
#define self_connect_data__removed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__removed((object),(func),(data),(destroy_data),(flags))
#define self_connect__messages_changed(object,func,data)	mn_mailbox_connect__messages_changed((object),(func),(data))
#define self_connect_after__messages_changed(object,func,data)	mn_mailbox_connect_after__messages_changed((object),(func),(data))
#define self_connect_data__messages_changed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__messages_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (MNMailbox *, gboolean , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailbox *)data1,
		(gboolean ) g_value_get_boolean (param_values + 1),
		data2);
}


enum {
	ADDED_SIGNAL,
	REMOVED_SIGNAL,
	MESSAGES_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_NAME,
	PROP_OPEN_COMMAND,
	PROP_MARK_AS_READ_COMMAND,
	PROP_MARK_AS_SPAM_COMMAND,
	PROP_DELETE_COMMAND,
	PROP_STOCK_ID,
	PROP_FORMAT,
	PROP_CHECK_DELAY,
	PROP_POLL,
	PROP_MANUALLY_CHECKABLE,
	PROP_MESSAGES,
	PROP_ERROR
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_active mn_mailbox_get_active
#define self_set_active mn_mailbox_set_active
#define self_added mn_mailbox_added
#define self_removed mn_mailbox_removed
#define self_get_stock_id mn_mailbox_get_stock_id
#define self_set_stock_id mn_mailbox_set_stock_id
#define self_get_format mn_mailbox_get_format
#define self_set_format mn_mailbox_set_format
#define self_get_poll mn_mailbox_get_poll
#define self_set_poll mn_mailbox_set_poll
#define self_get_manually_checkable mn_mailbox_get_manually_checkable
#define self_update_check_timeout mn_mailbox_update_check_timeout
#define self_set_messages mn_mailbox_set_messages
#define self_filter_messages mn_mailbox_filter_messages
#define self_filter_messages_cb mn_mailbox_filter_messages_cb
#define self_compare_messages mn_mailbox_compare_messages
#define self_compare_messages_cb mn_mailbox_compare_messages_cb
#define self_queue_cleanup_messages_considered_as_read mn_mailbox_queue_cleanup_messages_considered_as_read
#define self_cleanup_messages_considered_as_read_cb mn_mailbox_cleanup_messages_considered_as_read_cb
#define self_cleanup_messages_considered_as_read mn_mailbox_cleanup_messages_considered_as_read
#define self_cleanup_messages_considered_as_read_remove_cb mn_mailbox_cleanup_messages_considered_as_read_remove_cb
#define self_messages_changed mn_mailbox_messages_changed
#define self_set_error mn_mailbox_set_error
#define self_init_types mn_mailbox_init_types
#define self_get_class_from_name mn_mailbox_get_class_from_name
#define self_get_type_from_name mn_mailbox_get_type_from_name
#define self_notify_display_seen_messages_cb mn_mailbox_notify_display_seen_messages_cb
#define self_notify_messages_considered_as_read_cb mn_mailbox_notify_messages_considered_as_read_cb
#define self_new mn_mailbox_new
#define self_new_from_xml_node mn_mailbox_new_from_xml_node
#define self_xml_node_new mn_mailbox_xml_node_new
#define self_new_from_uri mn_mailbox_new_from_uri
#define self_new_from_configuration mn_mailbox_new_from_configuration
#define self_get_configuration mn_mailbox_get_configuration
#define self_configuration_free mn_mailbox_configuration_free
#define self_new_from_obsolete_uri mn_mailbox_new_from_obsolete_uri
#define self_parse_obsolete_uri mn_mailbox_parse_obsolete_uri
#define self_check_timeout_cb mn_mailbox_check_timeout_cb
#define self_validate mn_mailbox_validate
#define self_seal mn_mailbox_seal
#define self_parse_uri mn_mailbox_parse_uri
#define self_check mn_mailbox_check
#define self_enable_checking mn_mailbox_enable_checking
#define self_notice mn_mailbox_notice
#define self_warning mn_mailbox_warning
#define self_get_message_from_mid mn_mailbox_get_message_from_mid
#define self_get_command mn_mailbox_get_command
#define self_has_command mn_mailbox_has_command
GType
mn_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailbox_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMailbox", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailbox *)g_object_new(mn_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailbox *)g_object_new_valist (mn_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
	MNMailbox *self G_GNUC_UNUSED = MN_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 604 "src/mn-mailbox.gob"
	mn_mailbox_finalize (self);
#line 338 "mn-mailbox.c"
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 192 "src/mn-mailbox.gob"
	if(self->runtime_name) { g_free ((gpointer) self->runtime_name); self->runtime_name = NULL; }
#line 343 "mn-mailbox.c"
#line 194 "src/mn-mailbox.gob"
	if(self->name) { g_free ((gpointer) self->name); self->name = NULL; }
#line 346 "mn-mailbox.c"
#line 197 "src/mn-mailbox.gob"
	if(self->open_command) { g_free ((gpointer) self->open_command); self->open_command = NULL; }
#line 349 "mn-mailbox.c"
#line 200 "src/mn-mailbox.gob"
	if(self->mark_as_read_command) { g_free ((gpointer) self->mark_as_read_command); self->mark_as_read_command = NULL; }
#line 352 "mn-mailbox.c"
#line 203 "src/mn-mailbox.gob"
	if(self->mark_as_spam_command) { g_free ((gpointer) self->mark_as_spam_command); self->mark_as_spam_command = NULL; }
#line 355 "mn-mailbox.c"
#line 206 "src/mn-mailbox.gob"
	if(self->delete_command) { g_free ((gpointer) self->delete_command); self->delete_command = NULL; }
#line 358 "mn-mailbox.c"
#line 209 "src/mn-mailbox.gob"
	if(self->stock_id) { g_free ((gpointer) self->stock_id); self->stock_id = NULL; }
#line 361 "mn-mailbox.c"
#line 212 "src/mn-mailbox.gob"
	if(self->format) { g_free ((gpointer) self->format); self->format = NULL; }
#line 364 "mn-mailbox.c"
#line 274 "src/mn-mailbox.gob"
	if(self->_priv->all_messages) { g_hash_table_destroy ((gpointer) self->_priv->all_messages); self->_priv->all_messages = NULL; }
#line 367 "mn-mailbox.c"
#line 277 "src/mn-mailbox.gob"
	if(self->_priv->all_messages_by_mid) { g_hash_table_destroy ((gpointer) self->_priv->all_messages_by_mid); self->_priv->all_messages_by_mid = NULL; }
#line 370 "mn-mailbox.c"
#line 280 "src/mn-mailbox.gob"
	if(self->messages) { g_hash_table_destroy ((gpointer) self->messages); self->messages = NULL; }
#line 373 "mn-mailbox.c"
#line 506 "src/mn-mailbox.gob"
	if(self->error) { g_free ((gpointer) self->error); self->error = NULL; }
#line 376 "mn-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_mailbox_class_init (MNMailboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMailboxPrivate));
#line 56 "src/mn-mailbox.gob"
	c->default_check_delay = -1;
#line 389 "mn-mailbox.c"
#line 56 "src/mn-mailbox.gob"
	c->enable_checking_when_added = TRUE;
#line 392 "mn-mailbox.c"

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[ADDED_SIGNAL] =
		g_signal_new ("added",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxClass, added),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[REMOVED_SIGNAL] =
		g_signal_new ("removed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxClass, removed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[MESSAGES_CHANGED_SIGNAL] =
		g_signal_new ("messages_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (MNMailboxClass, messages_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_BOOLEAN);
	if ___GOB_UNLIKELY(sizeof(gboolean ) != sizeof(gboolean ) || parent_class == NULL /* avoid warning */) {
		g_error("src/mn-mailbox.gob line 503: Type mismatch of \"messages_changed\" signal signature");
	}

#line 154 "src/mn-mailbox.gob"
	c->added = ___real_mn_mailbox_added;
#line 170 "src/mn-mailbox.gob"
	c->removed = ___real_mn_mailbox_removed;
#line 429 "mn-mailbox.c"
	c->messages_changed = NULL;
#line 1094 "src/mn-mailbox.gob"
	c->seal = ___real_mn_mailbox_seal;
#line 433 "mn-mailbox.c"
	c->parse_uri = NULL;
#line 1112 "src/mn-mailbox.gob"
	c->check = ___real_mn_mailbox_check;
#line 437 "mn-mailbox.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("name" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_NAME,
		param_spec);
	param_spec = g_param_spec_string
		("open_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_OPEN_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("mark_as_read_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_MARK_AS_READ_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("mark_as_spam_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_MARK_AS_SPAM_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("delete_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_DELETE_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("stock_id" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_STOCK_ID,
		param_spec);
	param_spec = g_param_spec_string
		("format" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_FORMAT,
		param_spec);
	param_spec = g_param_spec_int
		("check_delay" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 -1 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_CHECK_DELAY,
		param_spec);
	param_spec = g_param_spec_boolean
		("poll" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_POLL,
		param_spec);
	param_spec = g_param_spec_boolean
		("manually_checkable" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_MANUALLY_CHECKABLE,
		param_spec);
	param_spec = g_param_spec_pointer
		("messages" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGES,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 596 "src/mn-mailbox.gob"
static void 
mn_mailbox_init (MNMailbox * self G_GNUC_UNUSED)
{
#line 560 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_MAILBOX,MNMailboxPrivate);
#line 172 "src/mn-mailbox.gob"
	self->_priv->poll = TRUE;
#line 565 "mn-mailbox.c"
#line 274 "src/mn-mailbox.gob"
	self->_priv->all_messages = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_object_unref);
#line 568 "mn-mailbox.c"
#line 277 "src/mn-mailbox.gob"
	self->_priv->all_messages_by_mid = g_hash_table_new(g_str_hash, g_str_equal);
#line 571 "mn-mailbox.c"
#line 280 "src/mn-mailbox.gob"
	self->messages = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_object_unref);
#line 574 "mn-mailbox.c"
 {
#line 597 "src/mn-mailbox.gob"

    mn_g_object_gconf_notifications_add_gdk_locked(self,
						   MN_CONF_DISPLAY_SEEN_MAIL, self_notify_display_seen_messages_cb, self,
						   MN_CONF_MESSAGES_CONSIDERED_AS_READ, self_notify_messages_considered_as_read_cb, self,
						   NULL);
  
#line 583 "mn-mailbox.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::set_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 195 "src/mn-mailbox.gob"
{ char *old = self->name; self->name = g_value_dup_string (VAL); g_free (old); }
#line 604 "mn-mailbox.c"
		}
		break;
	case PROP_OPEN_COMMAND:
		{
#line 198 "src/mn-mailbox.gob"
{ char *old = self->open_command; self->open_command = g_value_dup_string (VAL); g_free (old); }
#line 611 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_READ_COMMAND:
		{
#line 201 "src/mn-mailbox.gob"
{ char *old = self->mark_as_read_command; self->mark_as_read_command = g_value_dup_string (VAL); g_free (old); }
#line 618 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_SPAM_COMMAND:
		{
#line 204 "src/mn-mailbox.gob"
{ char *old = self->mark_as_spam_command; self->mark_as_spam_command = g_value_dup_string (VAL); g_free (old); }
#line 625 "mn-mailbox.c"
		}
		break;
	case PROP_DELETE_COMMAND:
		{
#line 207 "src/mn-mailbox.gob"
{ char *old = self->delete_command; self->delete_command = g_value_dup_string (VAL); g_free (old); }
#line 632 "mn-mailbox.c"
		}
		break;
	case PROP_STOCK_ID:
		{
#line 210 "src/mn-mailbox.gob"
{ char *old = self->stock_id; self->stock_id = g_value_dup_string (VAL); g_free (old); }
#line 639 "mn-mailbox.c"
		}
		break;
	case PROP_FORMAT:
		{
#line 213 "src/mn-mailbox.gob"
{ char *old = self->format; self->format = g_value_dup_string (VAL); g_free (old); }
#line 646 "mn-mailbox.c"
		}
		break;
	case PROP_CHECK_DELAY:
		{
#line 220 "src/mn-mailbox.gob"
self->check_delay = g_value_get_int (VAL);
#line 653 "mn-mailbox.c"
		}
		break;
	case PROP_POLL:
		{
#line 227 "src/mn-mailbox.gob"

      gboolean new_poll = g_value_get_boolean(VAL);

      /*
       * We do nothing unless the property has changed, because we do
       * not want to reset an already existing check timeout.
       */
      if (new_poll != selfp->poll)
	{
	  selfp->poll = new_poll;
	  if (self_get_active(self) && selfp->checking_enabled)
	    self_update_check_timeout(self);

	  g_object_notify(G_OBJECT(self), "manually-checkable");
	}
    
#line 675 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 507 "src/mn-mailbox.gob"
{ char *old = self->error; self->error = g_value_dup_string (VAL); g_free (old); }
#line 682 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::get_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 195 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->name);
#line 713 "mn-mailbox.c"
		}
		break;
	case PROP_OPEN_COMMAND:
		{
#line 198 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->open_command);
#line 720 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_READ_COMMAND:
		{
#line 201 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->mark_as_read_command);
#line 727 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_SPAM_COMMAND:
		{
#line 204 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->mark_as_spam_command);
#line 734 "mn-mailbox.c"
		}
		break;
	case PROP_DELETE_COMMAND:
		{
#line 207 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->delete_command);
#line 741 "mn-mailbox.c"
		}
		break;
	case PROP_STOCK_ID:
		{
#line 210 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->stock_id);
#line 748 "mn-mailbox.c"
		}
		break;
	case PROP_FORMAT:
		{
#line 213 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->format);
#line 755 "mn-mailbox.c"
		}
		break;
	case PROP_CHECK_DELAY:
		{
#line 220 "src/mn-mailbox.gob"
g_value_set_int (VAL, self->check_delay);
#line 762 "mn-mailbox.c"
		}
		break;
	case PROP_POLL:
		{
#line 244 "src/mn-mailbox.gob"

      g_value_set_boolean(VAL, selfp->poll);
    
#line 771 "mn-mailbox.c"
		}
		break;
	case PROP_MANUALLY_CHECKABLE:
		{
#line 255 "src/mn-mailbox.gob"

      g_value_set_boolean(VAL, selfp->checking_enabled && selfp->poll);
    
#line 780 "mn-mailbox.c"
		}
		break;
	case PROP_MESSAGES:
		{
#line 287 "src/mn-mailbox.gob"

      g_value_set_pointer(VAL, self->messages);
    
#line 789 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 507 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->error);
#line 796 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 135 "src/mn-mailbox.gob"
gboolean 
mn_mailbox_get_active (MNMailbox * self)
{
#line 816 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_active"
#line 135 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 135 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 822 "mn-mailbox.c"
{
#line 137 "src/mn-mailbox.gob"
	
    return g_atomic_int_get(&selfp->_active);
  }}
#line 828 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 141 "src/mn-mailbox.gob"
static void 
mn_mailbox_set_active (MNMailbox * self, gboolean value)
{
#line 835 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_active"
#line 141 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 141 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 841 "mn-mailbox.c"
{
#line 143 "src/mn-mailbox.gob"
	
    g_atomic_int_set(&selfp->_active, value);
  }}
#line 847 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_added:
 * @self: the object which received the signal
 *
 * This signal gets emitted after the mailbox is added to the
 * mailboxes list.
 **/
#line 154 "src/mn-mailbox.gob"
void 
mn_mailbox_added (MNMailbox * self)
{
#line 861 "mn-mailbox.c"
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 154 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 154 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 872 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ADDED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 154 "src/mn-mailbox.gob"
static void 
___real_mn_mailbox_added (MNMailbox * self)
{
#line 889 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::added"
{
#line 156 "src/mn-mailbox.gob"
	
    self_set_active(self, TRUE);

    if (SELF_GET_CLASS(self)->enable_checking_when_added)
      self_enable_checking(self);
  }}
#line 899 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_removed:
 * @self: the object which received the signal
 *
 * This signal gets emitted after the mailbox is removed from the
 * mailboxes list.
 **/
#line 170 "src/mn-mailbox.gob"
void 
mn_mailbox_removed (MNMailbox * self)
{
#line 913 "mn-mailbox.c"
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 170 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 170 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 924 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[REMOVED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 170 "src/mn-mailbox.gob"
static void 
___real_mn_mailbox_removed (MNMailbox * self)
{
#line 941 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::removed"
{
#line 172 "src/mn-mailbox.gob"
	
    self_set_active(self, FALSE);

    mn_source_clear(&selfp->check_timeout_id);

    /*
     * Do not queue a cleanup of the messages-considered-as-read GConf
     * setting: it should not be done if the mailbox is only being
     * replaced (eg. from mn_mailbox_properties_dialog_apply()).
     *
     * If however the mailbox is being permanently removed, its
     * messages considered as read will be cleaned up the next time
     * another mailbox is checked, which is good enough.
     *
     * Note that we could queue a cleanup from here by adding and
     * testing a "gboolean replacing" signal parameter, but it is not
     * worth the effort.
     */
  }}
#line 964 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 210 "src/mn-mailbox.gob"
gchar * 
mn_mailbox_get_stock_id (MNMailbox * self)
{
#line 971 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_stock_id"
{
#line 210 "src/mn-mailbox.gob"
		gchar* val; g_object_get (G_OBJECT (self), "stock_id", &val, NULL); return val;
}}
#line 977 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 210 "src/mn-mailbox.gob"
void 
mn_mailbox_set_stock_id (MNMailbox * self, gchar * val)
{
#line 984 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_stock_id"
{
#line 210 "src/mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "stock_id", val, NULL);
}}
#line 990 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 213 "src/mn-mailbox.gob"
gchar * 
mn_mailbox_get_format (MNMailbox * self)
{
#line 997 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_format"
{
#line 213 "src/mn-mailbox.gob"
		gchar* val; g_object_get (G_OBJECT (self), "format", &val, NULL); return val;
}}
#line 1003 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 213 "src/mn-mailbox.gob"
void 
mn_mailbox_set_format (MNMailbox * self, gchar * val)
{
#line 1010 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_format"
{
#line 213 "src/mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "format", val, NULL);
}}
#line 1016 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 244 "src/mn-mailbox.gob"
gboolean 
mn_mailbox_get_poll (MNMailbox * self)
{
#line 1023 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_poll"
{
#line 225 "src/mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "poll", &val, NULL); return val;
}}
#line 1029 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 227 "src/mn-mailbox.gob"
void 
mn_mailbox_set_poll (MNMailbox * self, gboolean val)
{
#line 1036 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_poll"
{
#line 225 "src/mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "poll", val, NULL);
}}
#line 1042 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 255 "src/mn-mailbox.gob"
gboolean 
mn_mailbox_get_manually_checkable (MNMailbox * self)
{
#line 1049 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_manually_checkable"
{
#line 253 "src/mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "manually_checkable", &val, NULL); return val;
}}
#line 1055 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 259 "src/mn-mailbox.gob"
static void 
mn_mailbox_update_check_timeout (MNMailbox * self)
{
#line 1062 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::update_check_timeout"
#line 259 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 259 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1068 "mn-mailbox.c"
{
#line 261 "src/mn-mailbox.gob"
	
    g_assert(self_get_active(self) == TRUE);
    g_assert(selfp->checking_enabled == TRUE);

    mn_source_clear(&selfp->check_timeout_id);
    if (selfp->poll && self->runtime_check_delay > 0)
      selfp->check_timeout_id = gdk_threads_add_timeout(self->runtime_check_delay * 1000, self_check_timeout_cb, self);
  }}
#line 1079 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 291 "src/mn-mailbox.gob"
void 
mn_mailbox_set_messages (MNMailbox * self, GSList * messages)
{
#line 1086 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_messages"
#line 291 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 291 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1092 "mn-mailbox.c"
{
#line 293 "src/mn-mailbox.gob"
	
    GSList *l;

    selfp->all_messages_set = TRUE;

    g_hash_table_remove_all(selfp->all_messages);
    g_hash_table_remove_all(selfp->all_messages_by_mid);

    MN_LIST_FOREACH(l, messages)
      {
	MNMessage *message = l->data;

	g_hash_table_replace(selfp->all_messages, message->id, g_object_ref(message));

	if (message->mid)
	  /* do not ref message, it is owned by all_messages */
	  g_hash_table_replace(selfp->all_messages_by_mid, message->mid, message);
      }

    /*
     * Some messages might be gone, queue a cleanup of the
     * considered-as-read GConf setting.
     */
    self_queue_cleanup_messages_considered_as_read();

    self_filter_messages(self);
  }}
#line 1122 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_filter_messages:
 * @self: the mailbox to act upon
 *
 * Filters @self->all_messages with the "seen mail" filter and the
 * considered-as-read GConf list, and stores the resulting set in
 * @self->messages. Additionally, if @self->messages has changed,
 * emits the "messages-changed" signal.
 **/
#line 330 "src/mn-mailbox.gob"
static void 
mn_mailbox_filter_messages (MNMailbox * self)
{
#line 1138 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::filter_messages"
#line 330 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 330 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1144 "mn-mailbox.c"
{
#line 332 "src/mn-mailbox.gob"
	
    FilterMessagesInfo info;
    gboolean changed = FALSE;
    gboolean has_new = FALSE;

    /* filter messages */

    self->timestamp = 0;

    info.self = self;
    info.messages = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_object_unref);
    info.messages_considered_as_read = mn_conf_get_string_hash_set(MN_CONF_MESSAGES_CONSIDERED_AS_READ);
    info.display_seen_mail = mn_conf_get_bool(MN_CONF_DISPLAY_SEEN_MAIL);

    g_hash_table_foreach(selfp->all_messages, (GHFunc) self_filter_messages_cb, &info);

    g_hash_table_destroy(info.messages_considered_as_read);

    /* detect changes */

    if (self_compare_messages(self->messages, info.messages))
      changed = TRUE;
    if (self_compare_messages(info.messages, self->messages))
      changed = has_new = TRUE;

    g_hash_table_destroy(self->messages);
    self->messages = info.messages;

    g_object_notify(G_OBJECT(self), "messages");

    if (changed)
      self_messages_changed(self, has_new);
  }}
#line 1180 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 366 "src/mn-mailbox.gob"
static void 
mn_mailbox_filter_messages_cb (const char * id, MNMessage * message, FilterMessagesInfo * info)
{
#line 1187 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::filter_messages_cb"
{
#line 370 "src/mn-mailbox.gob"
	
    Self *self = info->self;

    if (! info->display_seen_mail && (message->flags & MN_MESSAGE_NEW) == 0)
      return;

    if (g_hash_table_lookup(info->messages_considered_as_read, message->id))
      return;

    if (message->sent_time > self->timestamp)
      self->timestamp = message->sent_time;

    g_hash_table_replace(info->messages, message->id, g_object_ref(message));
  }}
#line 1205 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_compare_messages:
 * @messages1: a %GHashTable containing %MNMessage objects
 * @messages2: another %GHashTable containing %MNMessage objects
 *
 * Compares @messages1 and @messages2.
 *
 * Return value: %TRUE if @messages1 contains messages not present
 * in @messages2, %FALSE otherwise.
 **/
#line 395 "src/mn-mailbox.gob"
static gboolean 
mn_mailbox_compare_messages (GHashTable * messages1, GHashTable * messages2)
{
#line 1222 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::compare_messages"
{
#line 397 "src/mn-mailbox.gob"
	
    CompareMessagesInfo info;

    info.other = messages2;
    info.changed = FALSE;
    g_hash_table_foreach(messages1, (GHFunc) self_compare_messages_cb, &info);

    return info.changed;
  }}
#line 1235 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 407 "src/mn-mailbox.gob"
static void 
mn_mailbox_compare_messages_cb (const char * id, MNMessage * message, CompareMessagesInfo * info)
{
#line 1242 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::compare_messages_cb"
{
#line 411 "src/mn-mailbox.gob"
	
    if (! info->changed && ! g_hash_table_lookup(info->other, id))
      info->changed = TRUE;
  }}
#line 1250 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 416 "src/mn-mailbox.gob"
static void 
mn_mailbox_queue_cleanup_messages_considered_as_read (void)
{
#line 1257 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::queue_cleanup_messages_considered_as_read"
{
#line 418 "src/mn-mailbox.gob"
	
    if (! cleanup_messages_considered_as_read_idle_id)
      cleanup_messages_considered_as_read_idle_id = gdk_threads_add_idle(self_cleanup_messages_considered_as_read_cb, NULL);
  }}
#line 1265 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 423 "src/mn-mailbox.gob"
static gboolean 
mn_mailbox_cleanup_messages_considered_as_read_cb (gpointer data)
{
#line 1272 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::cleanup_messages_considered_as_read_cb"
{
#line 425 "src/mn-mailbox.gob"
	
    self_cleanup_messages_considered_as_read();

    cleanup_messages_considered_as_read_idle_id = 0;
    return FALSE;		/* remove source */
  }}
#line 1282 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 444 "src/mn-mailbox.gob"
static void 
mn_mailbox_cleanup_messages_considered_as_read (void)
{
#line 1289 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::cleanup_messages_considered_as_read"
{
#line 446 "src/mn-mailbox.gob"
	
    GList *l;
    GHashTable *set;

    /*
     * If there is a mailbox which has not been successfully checked
     * yet, abort. Otherwise, the messages of that mailbox could be
     * mistakenly cleaned up.
     */
    MN_LIST_FOREACH(l, mn_shell->mailboxes->list)
      {
	MNMailbox *mailbox = l->data;

	if (! mailbox->_priv->all_messages_set)
	  return;
      }

    set = mn_conf_get_string_hash_set(MN_CONF_MESSAGES_CONSIDERED_AS_READ);

    if (g_hash_table_foreach_remove(set, (GHRFunc) self_cleanup_messages_considered_as_read_remove_cb, NULL))
      /* one or more messages were removed, reflect the changes */
      mn_conf_set_string_hash_set(MN_CONF_MESSAGES_CONSIDERED_AS_READ, set);

    g_hash_table_destroy(set);
  }}
#line 1318 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 472 "src/mn-mailbox.gob"
static gboolean 
mn_mailbox_cleanup_messages_considered_as_read_remove_cb (const char * id, gpointer value, gpointer user_data)
{
#line 1325 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::cleanup_messages_considered_as_read_remove_cb"
{
#line 476 "src/mn-mailbox.gob"
	
    GList *l;

    MN_LIST_FOREACH(l, mn_shell->mailboxes->list)
      {
	MNMailbox *mailbox = l->data;

	if (g_hash_table_lookup(mailbox->_priv->all_messages, id))
	  return FALSE;		/* message still exists, do not remove it */
      }

    return TRUE;		/* message no longer exists, remove it */
  }}
#line 1342 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 503 "src/mn-mailbox.gob"
static void 
mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new)
{
#line 1349 "mn-mailbox.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 503 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 503 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1360 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_BOOLEAN);
	g_value_set_boolean (&___param_values[1], (gboolean ) has_new);

	g_signal_emitv (___param_values,
		object_signals[MESSAGES_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

#line 510 "src/mn-mailbox.gob"
void 
mn_mailbox_set_error (MNMailbox * self, const char * format, ...)
{
#line 1383 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_error"
#line 510 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 510 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1389 "mn-mailbox.c"
{
#line 512 "src/mn-mailbox.gob"
	
    char *error = NULL;

    if (format)
      MN_STRDUP_VPRINTF(error, format);

    g_object_set(G_OBJECT(self), MN_MAILBOX_PROP_ERROR(error), NULL);
    g_free(error);
  }}
#line 1401 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 522 "src/mn-mailbox.gob"
void 
mn_mailbox_init_types (void)
{
#line 1408 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::init_types"
{
#line 524 "src/mn-mailbox.gob"
	
    int i = 0;

#if WITH_MBOX || WITH_MOZILLA || WITH_MH || WITH_MAILDIR || WITH_SYLPHEED
    /*
     * MNSystemVFSMailbox must be registered before
     * MNCustomVFSMailbox, because the latter's parse_uri() method
     * will accept any URI.
     */
    mn_mailbox_types[i++] = MN_TYPE_SYSTEM_VFS_MAILBOX;
    mn_mailbox_types[i++] = MN_TYPE_CUSTOM_VFS_MAILBOX;
#endif
#if WITH_POP3
    mn_mailbox_types[i++] = MN_TYPE_POP3_MAILBOX;
#endif
#if WITH_IMAP
    mn_mailbox_types[i++] = MN_TYPE_IMAP_MAILBOX;
#endif
#if WITH_GMAIL
    mn_mailbox_types[i++] = MN_TYPE_GMAIL_MAILBOX;
#endif
#if WITH_YAHOO
    mn_mailbox_types[i++] = MN_TYPE_YAHOO_MAILBOX;
#endif
#if WITH_HOTMAIL
    mn_mailbox_types[i++] = MN_TYPE_HOTMAIL_MAILBOX;
#endif
#if WITH_EVOLUTION
    mn_mailbox_types[i++] = MN_TYPE_EVOLUTION_MAILBOX;
#endif
    mn_mailbox_types[i] = 0;
  }}
#line 1444 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 558 "src/mn-mailbox.gob"
MNMailboxClass * 
mn_mailbox_get_class_from_name (const char * type)
{
#line 1451 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_class_from_name"
#line 558 "src/mn-mailbox.gob"
	g_return_val_if_fail (type != NULL, (MNMailboxClass * )0);
#line 1455 "mn-mailbox.c"
{
#line 560 "src/mn-mailbox.gob"
	
    int i;

    for (i = 0; mn_mailbox_types[i]; i++)
      {
	SelfClass *class;

	class = g_type_class_ref(mn_mailbox_types[i]);
	if (! strcmp(class->type, type))
	  return class;

	g_type_class_unref(class);
      }

    return NULL;
  }}
#line 1474 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 577 "src/mn-mailbox.gob"
GType 
mn_mailbox_get_type_from_name (const char * type)
{
#line 1481 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_type_from_name"
#line 577 "src/mn-mailbox.gob"
	g_return_val_if_fail (type != NULL, (GType )0);
#line 1485 "mn-mailbox.c"
{
#line 579 "src/mn-mailbox.gob"
	
    SelfClass *class;

    class = self_get_class_from_name(type);
    if (class)
      {
	GType gtype;

	gtype = G_OBJECT_CLASS_TYPE(class);
	g_type_class_unref(class);

	return gtype;
      }

    return 0;
  }}
#line 1504 "mn-mailbox.c"
#undef __GOB_FUNCTION__


#line 604 "src/mn-mailbox.gob"
static void 
mn_mailbox_finalize (MNMailbox * self)
{
#line 1512 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
{
#line 605 "src/mn-mailbox.gob"
	
    /*
     * Even though we clear the source in removed(), it might have
     * been reinstalled afterwards (by a mn_mailbox_set_poll() call
     * from a check thread, etc).
     */
    if (selfp->check_timeout_id)
      g_source_remove(selfp->check_timeout_id);
  }}
#line 1525 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 615 "src/mn-mailbox.gob"
static void 
mn_mailbox_notify_display_seen_messages_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
{
#line 1532 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::notify_display_seen_messages_cb"
{
#line 620 "src/mn-mailbox.gob"
	
    Self *self = user_data;

    self_filter_messages(self);
  }}
#line 1541 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 626 "src/mn-mailbox.gob"
static void 
mn_mailbox_notify_messages_considered_as_read_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
{
#line 1548 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::notify_messages_considered_as_read_cb"
{
#line 631 "src/mn-mailbox.gob"
	
    Self *self = user_data;

    self_filter_messages(self);
  }}
#line 1557 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 638 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new (const char * type, ...)
{
#line 1564 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new"
#line 638 "src/mn-mailbox.gob"
	g_return_val_if_fail (type != NULL, (MNMailbox * )0);
#line 1568 "mn-mailbox.c"
{
#line 640 "src/mn-mailbox.gob"
	
    va_list args;
    GType type_id;
    const char *first_property_name;
    GObject *object;

    type_id = self_get_type_from_name(type);
    if (! type_id)
      return NULL;

    va_start(args, type);
    first_property_name = va_arg(args, const char *);
    object = g_object_new_valist(type_id, first_property_name, args);
    va_end(args);

    return SELF(object);
  }}
#line 1588 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 658 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_xml_node (xmlNode * node, GError ** err)
{
#line 1595 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_xml_node"
#line 658 "src/mn-mailbox.gob"
	g_return_val_if_fail (node != NULL, (MNMailbox * )0);
#line 1599 "mn-mailbox.c"
{
#line 660 "src/mn-mailbox.gob"
	
    char *type;
    Self *self = NULL;

    type = xmlGetProp(node, "type");
    if (! type)
      {
	g_set_error(err, 0, 0, _("\"type\" attribute missing"));
	return NULL;
      }

    self = self_new(type, NULL);
    if (! self)
      {
	g_set_error(err, 0, 0, _("unknown mailbox type \"%s\""), type);
	goto end;
      }

    mn_xml_import_properties(G_OBJECT(self), node);

    if (! self_validate(self, err))
      {
	g_object_unref(self);
	self = NULL;
      }

  end:
    g_free(type);
    return self;
  }}
#line 1632 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 691 "src/mn-mailbox.gob"
xmlNode * 
mn_mailbox_xml_node_new (MNMailbox * self)
{
#line 1639 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::xml_node_new"
#line 691 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (xmlNode * )0);
#line 691 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (xmlNode * )0);
#line 1645 "mn-mailbox.c"
{
#line 693 "src/mn-mailbox.gob"
	
    xmlNode *node;

    node = xmlNewNode(NULL, "mailbox");
    xmlSetProp(node, "type", SELF_GET_CLASS(self)->type);
    mn_xml_export_properties(G_OBJECT(self), node);

    return node;
  }}
#line 1657 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 703 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_uri (const char * uri)
{
#line 1664 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_uri"
#line 703 "src/mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1668 "mn-mailbox.c"
{
#line 705 "src/mn-mailbox.gob"
	
    int i;

    for (i = 0; mn_mailbox_types[i]; i++)
      {
	MNMailboxClass *class;
	MNMailbox *mailbox;

	class = g_type_class_ref(mn_mailbox_types[i]);
	mailbox = class->parse_uri ? class->parse_uri(NULL, uri) : NULL;
	g_type_class_unref(class);

	if (mailbox)
	  return mailbox;
      }

    return NULL;
  }}
#line 1689 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 724 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_configuration (MNMailboxConfiguration * config)
{
#line 1696 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_configuration"
#line 724 "src/mn-mailbox.gob"
	g_return_val_if_fail (config != NULL, (MNMailbox * )0);
#line 1700 "mn-mailbox.c"
{
#line 726 "src/mn-mailbox.gob"
	
    return g_object_newv(config->type, config->n_parameters, config->parameters);
  }}
#line 1706 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 730 "src/mn-mailbox.gob"
MNMailboxConfiguration * 
mn_mailbox_get_configuration (MNMailbox * self)
{
#line 1713 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_configuration"
#line 730 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxConfiguration * )0);
#line 730 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMailboxConfiguration * )0);
#line 1719 "mn-mailbox.c"
{
#line 732 "src/mn-mailbox.gob"
	
    GObject *object = G_OBJECT(self);
    GArray *parameters;
    GParamSpec **properties;
    unsigned int n_properties;
    int i;
    MNMailboxConfiguration *config;

    parameters = g_array_new(FALSE, FALSE, sizeof(GParameter));

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_SAVE) != 0)
	{
	  GParameter parameter = { NULL, { 0, } };

	  parameter.name = g_param_spec_get_name(properties[i]);

	  g_value_init(&parameter.value, G_PARAM_SPEC_VALUE_TYPE(properties[i]));
	  g_object_get_property(object, parameter.name, &parameter.value);

	  g_array_append_val(parameters, parameter);
	}
    g_free(properties);

    config = g_new0(MNMailboxConfiguration, 1);
    config->type = G_OBJECT_TYPE(self);
    config->n_parameters = parameters->len;
    config->parameters = (GParameter *) g_array_free(parameters, FALSE);

    return config;
  }}
#line 1754 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 765 "src/mn-mailbox.gob"
void 
mn_mailbox_configuration_free (MNMailboxConfiguration * config)
{
#line 1761 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::configuration_free"
#line 765 "src/mn-mailbox.gob"
	g_return_if_fail (config != NULL);
#line 1765 "mn-mailbox.c"
{
#line 767 "src/mn-mailbox.gob"
	
    int i;

    for (i = 0; i < config->n_parameters; i++)
      g_value_unset(&config->parameters[i].value);

    g_free(config->parameters);
    g_free(config);
  }}
#line 1777 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 777 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_obsolete_uri (const char * uri)
{
#line 1784 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_obsolete_uri"
#line 777 "src/mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1788 "mn-mailbox.c"
{
#line 779 "src/mn-mailbox.gob"
	
    char *real_uri;
    char *scheme;
    gboolean obsolete = FALSE;
    Self *self = NULL;

    real_uri = g_str_has_prefix(uri, "pop3:") /* also handle very old pop3 locators */
      ? g_strconcat("pop://", uri + 5, NULL)
      : g_strdup(uri);

    scheme = gnome_vfs_get_uri_scheme(real_uri);
    if (scheme)
      {
	if (! strcmp(scheme, "pop") || ! strcmp(scheme, "pops")
	    || ! strcmp(scheme, "imap") || ! strcmp(scheme, "imaps")
	    || ! strcmp(scheme, "gmail"))
	  obsolete = TRUE;
	g_free(scheme);
      }

    self = obsolete ? self_parse_obsolete_uri(real_uri) : self_new_from_uri(real_uri);
    g_free(real_uri);

    if (self && ! self_validate(self, NULL))
      {
	g_object_unref(self);
	self = NULL;
      }

    return self;
  }}
#line 1822 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 811 "src/mn-mailbox.gob"
static MNMailbox * 
mn_mailbox_parse_obsolete_uri (const char * uri)
{
#line 1829 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::parse_obsolete_uri"
#line 811 "src/mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1833 "mn-mailbox.c"
{
#line 813 "src/mn-mailbox.gob"
	
    int len;
    int buflen;
    char *scheme;
    char *username;
    char *password;
    char *authmech;
    char *hostname;
    int port;
    char *path;
    char **queries;
    Self *self = NULL;

    len = strlen(uri);
    buflen = len + 1;

    {
      char *pat;
      char scheme_buf[buflen];
      char auth_buf[buflen];
      char location_buf[buflen];
      char username_buf[buflen];
      char password_buf[buflen];
      char authmech_buf[buflen];
      char hostname_buf[buflen];
      int _port;
      char path_buf[buflen];
      char queries_buf[buflen];
      gboolean has_location = FALSE;
      gboolean has_password = FALSE;
      gboolean has_authmech = FALSE;
      gboolean has_port = FALSE;
      gboolean has_path = FALSE;
      gboolean has_queries = FALSE;
      int n;

      /* split URI in 3 parts: scheme, auth and location */

      pat = g_strdup_printf("%%%i[^:]://%%%i[^@]@%%%is", len, len, len);
      n = sscanf(uri, pat, scheme_buf, auth_buf, location_buf);
      g_free(pat);

      if (n >= 2)
	{
	  if (n == 3)
	    has_location = TRUE;
	}
      else
	return NULL;		/* unparsable */

      /* split auth part in 3 subparts: username, password and authmech */

      /*
       * For backward compatibility with previous versions of Mail
       * Notification, we also support ;auth= (in lowercase).
       */

      pat = g_strdup_printf("%%%i[^:]:%%%i[^;];%%*1[aA]%%*1[uU]%%*1[tT]%%*1[hH]=%%%is", len, len, len);
      n = sscanf(auth_buf, pat, username_buf, password_buf, authmech_buf);
      g_free(pat);

      if (n >= 2)
	{
	  has_password = TRUE;
	  if (n == 3)
	    has_authmech = TRUE;
	}
      else
	{
	  pat = g_strdup_printf("%%%i[^;];%%*1[aA]%%*1[uU]%%*1[tT]%%*1[hH]=%%%is", len, len);
	  n = sscanf(auth_buf, pat, username_buf, authmech_buf);
	  g_free(pat);

	  if (n >= 1)
	    {
	      if (n == 2)
		has_authmech = TRUE;
	    }
	  else
	    return NULL;	/* unparsable */
	}

      if (has_location)
	{
	  char hostport_buf[buflen];

	  /* split location part in 3 subparts: hostport, path and queries */

	  pat = g_strdup_printf("%%%i[^/]/%%%i[^?]?%%%is", len, len, len);
	  n = sscanf(location_buf, pat, hostport_buf, path_buf, queries_buf);
	  g_free(pat);

	  if (n >= 2)
	    {
	      has_path = TRUE;
	      if (n == 3)
		has_queries = TRUE;
	    }
	  else
	    {
	      pat = g_strdup_printf("%%%i[^?]?%%%is", len, len);
	      n = sscanf(location_buf, pat, hostport_buf, queries_buf);
	      g_free(pat);

	      if (n == 2)
		has_queries = TRUE;
	    }

	  /* split hostport in 2 subparts: host and port */

	  pat = g_strdup_printf("[%%%i[^]]]:%%u", len);
	  n = sscanf(hostport_buf, pat, hostname_buf, &_port);
	  g_free(pat);

	  if (n < 1)
	    {
	      pat = g_strdup_printf("%%%i[^:]:%%u", len);
	      n = sscanf(hostport_buf, pat, hostname_buf, &_port);
	      g_free(pat);
	    }

	  if (n == 2)
	    has_port = TRUE;
	}

      scheme = gnome_vfs_unescape_string(scheme_buf, NULL);
      username = gnome_vfs_unescape_string(username_buf, NULL);
      password = has_password ? gnome_vfs_unescape_string(password_buf, NULL) : NULL;
      authmech = has_authmech ? gnome_vfs_unescape_string(authmech_buf, NULL) : NULL;
      hostname = has_location ? gnome_vfs_unescape_string(hostname_buf, NULL) : NULL;
      port = has_port ? _port : 0;
      path = has_path ? gnome_vfs_unescape_string(path_buf, NULL) : NULL;
      if (has_queries)
	{
	  int i;

	  queries = g_strsplit(queries_buf, "&", 0);
	  for (i = 0; queries[i]; i++)
	    {
	      char *unescaped;

	      unescaped = gnome_vfs_unescape_string(queries[i], NULL);

	      g_free(queries[i]);
	      queries[i] = unescaped;
	    }
	}
      else
	queries = NULL;
    }

    if (! strcmp(scheme, "pop") || ! strcmp(scheme, "pops"))
      {
#if WITH_POP3
	MNPIMailboxConnectionType connection_type;

	if (queries && mn_strv_find(queries, "STLS") != -1)
	  connection_type = MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL;
	else
	  connection_type = ! strcmp(scheme, "pops")
	    ? MN_PI_MAILBOX_CONNECTION_TYPE_SSL
	    : MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL;

	self = self_new("pop3",
			"connection-type", connection_type,
			"username", username,
			"password", password,
			"authmech", authmech,
			"hostname", hostname,
			"port", port,
			NULL);
#endif
      }
    else if (! strcmp(scheme, "imap") || ! strcmp(scheme, "imaps"))
      {
#if WITH_IMAP
	MNPIMailboxConnectionType connection_type;

	if (queries && mn_strv_find(queries, "STARTTLS") != -1)
	  connection_type = MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL;
	else
	  connection_type = ! strcmp(scheme, "imaps")
	    ? MN_PI_MAILBOX_CONNECTION_TYPE_SSL
	    : MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL;

	self = self_new("imap",
			"connection-type", connection_type,
			"username", username,
			"password", password,
			"authmech", authmech,
			"hostname", hostname,
			"port", port,
			NULL);

	if (path)
	  g_object_set(self, MN_IMAP_MAILBOX_PROP_MAILBOX(path), NULL);

	if (queries && mn_strv_find(queries, "noidle") != -1)
	  g_object_set(G_OBJECT(self), MN_IMAP_MAILBOX_PROP_USE_IDLE_EXTENSION(MN_IMAP_MAILBOX_USE_IDLE_NEVER), NULL);
#endif
      }
    else if (! strcmp(scheme, "gmail"))
      {
#if WITH_GMAIL
	self = self_new("gmail",
			"username", username,
			"password", password,
			NULL);
#endif
      }

    g_free(scheme);
    g_free(username);
    g_free(password);
    g_free(authmech);
    g_free(hostname);
    g_free(path);
    g_strfreev(queries);

    return self;
  }}
#line 2057 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1035 "src/mn-mailbox.gob"
static gboolean 
mn_mailbox_check_timeout_cb (gpointer data)
{
#line 2064 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::check_timeout_cb"
{
#line 1037 "src/mn-mailbox.gob"
	
    Self *self = data;

    self_check(self);

    return TRUE;		/* continue */
  }}
#line 2075 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1045 "src/mn-mailbox.gob"
static gboolean 
mn_mailbox_validate (MNMailbox * self, GError ** err)
{
#line 2082 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::validate"
#line 1045 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 1045 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 2088 "mn-mailbox.c"
{
#line 1047 "src/mn-mailbox.gob"
	
    GParamSpec **properties;
    unsigned int n_properties;
    int i;
    gboolean status = TRUE;

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_REQUIRED) != 0)
	{
	  GValue value = { 0, };
	  const char *str;
	  gboolean is_empty;

	  g_assert(G_IS_PARAM_SPEC_STRING(properties[i]));

	  g_value_init(&value, G_TYPE_STRING);
	  g_object_get_property(G_OBJECT(self), g_param_spec_get_name(properties[i]), &value);

	  str = g_value_get_string(&value);
	  is_empty = ! str || ! *str;

	  g_value_unset(&value);

	  if (is_empty)
	    {
	      g_set_error(err, 0, 0, _("property \"%s\" has no value"), g_param_spec_get_name(properties[i]));
	      status = FALSE;
	      break;
	    }
	}
    g_free(properties);

    return status;
  }}
#line 2126 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_seal:
 * @self: a mailbox
 *
 * Seals the mailbox before it is made operational by being added to
 * the mailboxes list. The point of this function is to allow
 * subclasses to perform initialization which needs to consult the
 * value of properties loaded from mailboxes.xml or set by the
 * properties dialog. That would not be possible from init(), since
 * these properties are only set after the mailbox is constructed.
 **/
#line 1094 "src/mn-mailbox.gob"
void 
mn_mailbox_seal (MNMailbox * self)
{
#line 2144 "mn-mailbox.c"
	MNMailboxClass *klass;
#line 1094 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1094 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 2150 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->seal)
		(*klass->seal)(self);
}
#line 1094 "src/mn-mailbox.gob"
static void 
___real_mn_mailbox_seal (MNMailbox * self G_GNUC_UNUSED)
{
#line 2160 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::seal"
{
#line 1096 "src/mn-mailbox.gob"
	
    if (self->name)
      {
	g_free(self->runtime_name);
	self->runtime_name = g_strdup(self->name);
      }

    self->runtime_check_delay = self->check_delay != -1
      ? self->check_delay
      : SELF_GET_CLASS(self)->default_check_delay;
  }}
#line 2175 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1109 "src/mn-mailbox.gob"
static MNMailbox * 
mn_mailbox_parse_uri (MNMailbox * self, const char * uri)
{
#line 2182 "mn-mailbox.c"
	MNMailboxClass *klass;
#line 1109 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMailbox * )0);
#line 1109 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMailbox * )0);
#line 1109 "src/mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 2190 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->parse_uri)
		return (*klass->parse_uri)(self,uri);
	else
		return (MNMailbox * )(0);
}

#line 1112 "src/mn-mailbox.gob"
void 
mn_mailbox_check (MNMailbox * self)
{
#line 2203 "mn-mailbox.c"
	MNMailboxClass *klass;
#line 1112 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1112 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 2209 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->check)
		(*klass->check)(self);
}
#line 1112 "src/mn-mailbox.gob"
static void 
___real_mn_mailbox_check (MNMailbox * self G_GNUC_UNUSED)
{
#line 2219 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::check"
{
#line 1114 "src/mn-mailbox.gob"
	
    g_assert(self_get_active(self) == TRUE);
    g_assert(selfp->checking_enabled == TRUE);
  }}
#line 2227 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1128 "src/mn-mailbox.gob"
void 
mn_mailbox_enable_checking (MNMailbox * self)
{
#line 2234 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::enable_checking"
#line 1128 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1128 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 2240 "mn-mailbox.c"
{
#line 1130 "src/mn-mailbox.gob"
	
    selfp->checking_enabled = TRUE;
    g_object_notify(G_OBJECT(self), "manually-checkable");

    self_update_check_timeout(self);
    self_check(self);
  }}
#line 2250 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1139 "src/mn-mailbox.gob"
void 
mn_mailbox_notice (MNMailbox * self, const char * format, ...)
{
#line 2257 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::notice"
#line 1139 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1139 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1139 "src/mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 2265 "mn-mailbox.c"
{
#line 1141 "src/mn-mailbox.gob"
	
    char *message;

    /*
     * Disregard messages sent by a threaded check still in progress
     * after the mailbox has been removed.
     */
    if (! self_get_active(self))
      return;

    MN_STRDUP_VPRINTF(message, format);
    mn_info(_("%s: %s"), self->runtime_name, message);
    g_free(message);
  }}
#line 2282 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1157 "src/mn-mailbox.gob"
void 
mn_mailbox_warning (MNMailbox * self, const char * format, ...)
{
#line 2289 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::warning"
#line 1157 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1157 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1157 "src/mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 2297 "mn-mailbox.c"
{
#line 1159 "src/mn-mailbox.gob"
	
    char *message;

    /*
     * Disregard messages sent by a threaded check still in progress
     * after the mailbox has been removed.
     */
    if (! self_get_active(self))
      return;

    MN_STRDUP_VPRINTF(message, format);
    g_warning(_("%s: %s"), self->runtime_name, message);
    g_free(message);
  }}
#line 2314 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1174 "src/mn-mailbox.gob"
MNMessage * 
mn_mailbox_get_message_from_mid (MNMailbox * self, const char * mid)
{
#line 2321 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_message_from_mid"
#line 1174 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMessage * )0);
#line 1174 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMessage * )0);
#line 1174 "src/mn-mailbox.gob"
	g_return_val_if_fail (mid != NULL, (MNMessage * )0);
#line 2329 "mn-mailbox.c"
{
#line 1176 "src/mn-mailbox.gob"
	
    return g_hash_table_lookup(selfp->all_messages_by_mid, mid);
  }}
#line 2335 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1180 "src/mn-mailbox.gob"
char * 
mn_mailbox_get_command (MNMailbox * self, const char * id)
{
#line 2342 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_command"
#line 1180 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 1180 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (char * )0);
#line 1180 "src/mn-mailbox.gob"
	g_return_val_if_fail (id != NULL, (char * )0);
#line 2350 "mn-mailbox.c"
{
#line 1182 "src/mn-mailbox.gob"
	
    char *prop;
    char *command;

    prop = g_strconcat(id, "-command", NULL);
    g_object_get(self, prop, &command, NULL);
    g_free(prop);

    if (command && ! *command)
      {
	g_free(command);
	return NULL;
      }

    return command;
  }}
#line 2369 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1199 "src/mn-mailbox.gob"
gboolean 
mn_mailbox_has_command (MNMailbox * self, const char * id)
{
#line 2376 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::has_command"
#line 1199 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 1199 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 1199 "src/mn-mailbox.gob"
	g_return_val_if_fail (id != NULL, (gboolean )0);
#line 2384 "mn-mailbox.c"
{
#line 1201 "src/mn-mailbox.gob"
	
    char *command;
    gboolean has;

    command = self_get_command(self, id);
    has = command != NULL;
    g_free(command);

    return has;
  }}
#line 2397 "mn-mailbox.c"
#undef __GOB_FUNCTION__
