# -*- coding: utf-8 -*-

import ldtp
import ldtputils

from time import time, gmtime, strftime, sleep
from os.path import join as path_join

from mago.test_suite.deskex import NotifyOSDTestSuite
from mago.check import ScreenshotCompare, FAIL

class NotifyOSDTest(NotifyOSDTestSuite):
    def layoutTest(self, oracle=None, summary=None, body=None, icon=None):
        oracle = path_join(self.get_test_dir(), oracle)
        self.application.notify(summary, body, icon)
        elapsed, screeny = self.application.grab_image_and_wait(summary)

        checker = ScreenshotCompare(oracle, screeny)

        try:
            passed = checker.perform_test()
        except Exception, e:
            checker.calibrate()
            raise e

        if passed == FAIL:
            raise AssertionError('screenshots differ', screeny)

    def queueTest(self, oracle=None, summary=None, body=None, icon=None):
        oracles = [path_join(self.get_test_dir(), o) \
                       for o in oracle.split('|')]
        summaries = summary.split('|')
        bodies = body.split('|')
        icons = icon.split('|')

        bubbles = []

        for oracle, summary, body, icons in \
                zip(oracles, summaries, bodies, icons):
            bubbles.append(_Bubble(oracle, summary, body, icons))

        for b in bubbles:
            self.application.notify(b.summary, b.body, b.icon)

        for b in bubbles:
            b.elapsed, b.screeny = \
                self.application.grab_image_and_wait(b.summary)
            
        for b in bubbles:
            testcheck = ScreenshotCompare(b.oracle, b.screeny)

            try:
                # Allow a 2% change due to new blur chache
                check = testcheck.perform_test(max_diff=2.0)
            except Exception, e:
                testcheck.calibrate()
                raise e

            if check == FAIL:
                raise AssertionError("screenshots differ", b.screeny)

    def synchronousTest(self, summary1=None, body1=None, icon1=None,
                        summary2=None, body2=None, icon2=None, value2=None):
        ALLOWED_OVERLAP = 14

        self.application.notify(summary1, body1, icon1)
        sleep(1)
        self.application.notify_synchronous(summary2, body2, icon2, int(value2))

        x2, y2, w2, h2 = self.application.get_extents(summary2, True)
        x1, y1, w1, h1 = self.application.get_extents(summary1)

        if w1 == -1:
            # First bubble does not exist anymore, this could mean 
            # that the second bubble did not appear synchronously.
            raise AssertionError("not synchronous")
        elif (y2 + h2) - y1 > ALLOWED_OVERLAP:
            raise AssertionError("bad overlap")

class _Bubble:
    def __init__(self, oracle, summary, body, icon):
        self.oracle = oracle
        self.summary = summary
        self.body = body
        self.icon = icon
        self.elapsed = None
        self.screeny = None
