import os
from mago.test_suite.gnome import GnomeScreenshotTestSuite

class TakeScreenshot(GnomeScreenshotTestSuite):
    def grab_desktop(self, delay=5, filename='baz.png'):
        self.application.open()
        self.application.take_whole_desktop_screenshot(delay)

        self.application.save_to_file(filename)

        file_path = os.getenv('HOME') + '/' + filename
        
        if os.access(file_path, os.F_OK):
            os.remove(file_path) 
        else:
            raise AssertionError('Screenshot ' + file_path + ' was not created')

    def grab_window(self, delay=5, filename='baz.png'):
        self.application.open()

        self.application.take_current_window_screenshot(delay)

        self.application.save_to_file(filename)

        file_path = os.getenv('HOME') + '/' + filename
        
        if os.access(file_path, os.F_OK):
            os.remove(file_path) 
        else:
            raise AssertionError('Screenshot ' + file_path + ' was not created')

    def grab_area(self, delay=5, filename='baz.png'):
        self.application.open()

        self.application.grab_selected_area(delay)

        self.application.save_to_file(filename)

        file_path = os.getenv('HOME') + '/' + filename
        
        if os.access(file_path, os.F_OK):
            os.remove(file_path) 
        else:
            raise AssertionError('Screenshot ' + file_path + ' was not created')

if __name__ == "__main__":
    test = TakeScreenshot()
    test.run()
