/* AttributedCommandManager.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.commands;

import org.pietschy.command.CommandManager;

/**
 * Extension of {@link CommandManager} that uses an {@link AttributedContext} as context.
 * This class also provides helper methods for retrieving and setting attributes in this context.<p>
 * <b>Note:</b> Currently a face builder of type {@link FaceBuilder} is automatically registered
 * with every newly created object of this type. This functionality will be removed from this
 * package as soon as it is integrated in a new version of the GUI commands framework.<p>
 *
 * <b>Important note:</b> work on this part of the Swirl library will be 
 * discontinued because unfortunately newer versions
 * of the <i>GUI commands</i> framework will no longer be available as <i>open source</i>.
 * In due course this class will become deprecated and will eventually be
 * removed from the library.
 */
public class AttributedCommandManager extends CommandManager{
    
    /** Create a command manager of this type with given parent and context.
     */
    public AttributedCommandManager(AttributedCommandManager parent, AttributedContext context) {
	super (parent, context);
	FaceBuilder.register(this);
    }
    
    /**
     * Create a command manager of this type with given parent and a newly 
     * created context of type {@link AttributedContext}.
     */
    public AttributedCommandManager (AttributedCommandManager parent) {
	this (parent, new AttributedContext ());
    }
    
    /**
     * Create  a command manager of this type without parent and with the given
     * context.
     */
    public AttributedCommandManager(AttributedContext context) {
	this (null, context);
    }
    
    /**
     * Create a command manager of this type without parent and with a newly 
     * created context of type {@link AttributedContext}.
     */
    public AttributedCommandManager () {
	this (null, new AttributedContext ());
    }

    /**
     * Returns the parent of this command manager. (Overridden to return the
     * correct type.)
     */
    public AttributedCommandManager getParent() {
	return (AttributedCommandManager)super.getParent();
    }
    
    /**
     * Returns the context of this command manager. (Overridden to return the
     * correct type.)
     */
    public AttributedContext getContext () {
	return (AttributedContext)super.getContext();
    }
    
    /**
     * Sets a new value for a given attribute. Convenience method which simply 
     * delegates to the context.
     */
    public void setAttribute (String key, Object value) {
	getContext ().setAttribute(key, value);
    }
    
    /**
     * Retrieve a value for a given attribute. Looks for the attribute first
     * in the current context and then in the context of each ancestor in turn.
     * Returns the firstvaue found or {@code null} when the attribute does not exist
     * in any of these contexts.
     */
    public Object getAttribute (String key) {
	Object value = getContext().getAttribute(key);
	AttributedCommandManager cm = getParent ();
	while (value == null && cm != null) {
	    value = cm.getContext().getAttribute(key);
	    cm = cm.getParent ();
	}
	return value;
    }
    
}
