/* ToolBarToggleButton.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.actions;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JToggleButton;

/**
 * Button for use on a tool bar. Has the same functionality as
 * {@link JToggleButton} but with a slightly different look and feel. See 
 * the documentation of {@link #ToolBarToggleButton} for details.
 */
public class ToolBarToggleButton extends JToggleButton {
    
    /**
     * Create a tool bar toggle button from the given action. The following
     * action properties are used:
     * <ul>
     * <li>The text of the button is set to {@code null} - and not to
     * {@code Action.NAME} as might be expected.</li>
     * <li>The tool tip text is set to {@code Action.SHORT_DESCRIPTION}
     * if it is non null, and otherwise to {@code Action.NAME}.</li>
     * <li>The icon is taken from {@code SimpleAction.MEDIUM_ICON}, unless
     * this is {@code null} in which case {@code Action.SMALL_ICON} is used.</li>
     * <li>The icon for the disabled button is taken from 
     * {@code SimpleAction.MEDIUM_DISABLED_ICON} if it is non-null.</li>
     * </ul>
     * Note that no accelerator key or mnemonic is installed.
     */
    public ToolBarToggleButton(Action action) {
       super (action); 
       setFocusable (false);
    }

    // overrides AbstractButton
    protected void configurePropertiesFromAction(Action a) {
        ToolBarButtonSupport.configurePropertiesFromAction (this, a);
    }
    
    // overrides AbstractButton
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return ToolBarButtonSupport.createActionPropertyChangeListener(this);
    }
}
