//
// Footnote module v.1.1
//
// (c) Karl Stevens <karl@maxim.ca>
// suggestions and improvements by GPL (Gilles.Perez-Lambert@univ-montp3.fr)
//
//
// This file may be distributed freely under the provisions of the
// GNU Public License (GPL).
//
// This module adds footnotes (which are embedded in the RXML document) to
// the bottom of the page.
//
// Usage: <footnote> ... </footnote>
//    .... <footnotes>
//
// The <footnote> container defines the footnote, this is removed from the
// document, and replaced with a link to the appropriate anchor.
// The <footnotes> tag inserts all footnotes and anchors
//


#include <module.h>
#include <process.h>
inherit "module";
inherit "roxenlib";

array register_module()
{
  return ({ MODULE_PARSER,
                      "Footnotes tags",
                      "Allows the insertion of footnotes to the body of a document. "
                      "Adds the container &lt;footnote&gt; and the tag &lt;footnotes&gt.<br>"
                      "&ltfootnote&gt; adds a footnote to a document,"
                      "&lt;footnotes&gt; displays all footnotes.", ({}), 1
                      });
}

void create()
{
 defvar("tagtext", "footnote", "Default text to add to the footnote link text",
              TYPE_STRING,
              "This will be added to the names of the links Footnote creates."
              "&nbsp;This can be overridden by the page author by using the "
              "argument NAME inside the &lt;footnote&gt; tag.");
 defvar("linebreak", "<BR>", "HTML inserted after each footnote",
	      TYPE_STRING|VAR_MORE,
	      "You should make this something that will cause a line break");
 defvar("linkpre","<SUP>", "Footnote link pre-HTML",
              TYPE_STRING|VAR_MORE,
              "This is the HTML that will be inserted before the footnote link, "
              "to change the style.  This should really be a single HTML tag, "
              "additional style info should be changed with a Style Sheet.");
 defvar("linkpost","</SUP>", "Footnote link post-HTML",
              TYPE_STRING|VAR_MORE,
              "This is the HTML that will be inserted after the footnote link, "
              "to change the style.  This should really be a single HTML tag, "
              "additional style info should be changed with a Style Sheet.");

// GPL - Two more variables added to control footnote appearance.
 defvar("linkprel","&nbsp;", "Footnote reference pre-HTML",
              TYPE_STRING|VAR_MORE,
              "This is the HTML that will be inserted before the footnote reference.");
 defvar("linkpostl",". ", "Footnote reference post-HTML",
              TYPE_STRING|VAR_MORE,
              "This is the HTML that will be inserted after the footnote reference.");
}

string container_footnote(string tag, mapping m, string q, object request_id )
{
  string footnotes;
  int fncount=request_id->misc->KS_FNMod_footnotecount;
  if (fncount > 0)
        footnotes=request_id->misc->KS_FNMod_footnotes;
  else footnotes="";

  fncount++;

  string t;
  if (m->name)
    t=(string)m->name;
  else
    t=QUERY(tagtext)+fncount;

// GPL - added reverse anchor and pre/post HTML for link
  footnotes=footnotes+QUERY(linkprel)+"<a name=\""+t+"\" href=\"#r"+t+"\">"+fncount+"</a>"+QUERY(linkpostl)+q+QUERY(linebreak)+"\n";

  request_id->misc->KS_FNMod_footnotecount=fncount;
  request_id->misc->KS_FNMod_footnotes=footnotes;

// GPL - added name to be able to be referencef by the footnote itself
  return QUERY(linkpre)+"<a href=\"#"+t+"\" name=\"r"+t+"\">"+fncount+"</a>"+QUERY(linkpost);

}

string tag_footnotes( string tag, mapping m, object request_id, object f,mapping d )
{
  return request_id->misc->KS_FNMod_footnotes;
}

mapping query_container_callers()
        { return (["footnote":container_footnote,]); }
mapping query_tag_callers()
        { return (["footnotes":tag_footnotes,]); }

