/**
 * ================================================
 * LibLoader : a free Java resource loading library
 * ================================================
 *
 * Project Info:  http://reporting.pentaho.org/libloader/
 *
 * (C) Copyright 2006, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: PropertiesResourceFactory.java 3515 2007-10-16 09:22:24Z tmorgner $
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */

package org.jfree.resourceloader.factory.property;

import java.util.Properties;
import java.io.IOException;
import java.io.InputStream;

import org.jfree.resourceloader.ResourceFactory;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceCreationException;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.SimpleResource;

public class PropertiesResourceFactory
  implements ResourceFactory
{
  public PropertiesResourceFactory ()
  {
  }

  public Resource create (final ResourceManager manager,
                          final ResourceData data,
                          final ResourceKey context)
          throws ResourceCreationException, ResourceLoadingException
  {
    try
    {
      final Properties properties = new Properties();
      final InputStream stream = data.getResourceAsStream(manager);
      try
      {
        properties.load(stream);
      }
      finally
      {
        stream.close();
      }
      return new SimpleResource (data.getKey(), properties, data.getVersion(manager));
    }
    catch (IOException e)
    {
      throw new ResourceLoadingException("Failed to load the properties file.",e);
    }
  }

  public Class getFactoryType ()
  {
    return Properties.class;
  }

  public void initializeDefaults ()
  {
    // none required ...
  }
}
