/*******************************************************************************************************************************************
 cvseparator.c
*******************************************************************************************************************************************/

#include "cvseparator.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CVSeparator);

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CVSeparator::CVSeparator (CContainer *inOwner, const CWidgetListener *inListener)
	    :CSeparator	 (inOwner, inListener)
{
	// widget instanciation requested
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CVSeparator::~CVSeparator ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//------------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CVSeparator::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_vseparator_new ();
}
