/*******************************************************************************************************************************************
 ccontrol.h
 
 CClass
 |--CSerialized
    |--CMetaModule
       |--CObject
  	  |--CComponent
	     |--CControl

 Basics of an application visual control definition. A control is not always responsible of its gui drawing. It can be derived to a widget 
 control or used as a part of it. A control handles logical d&d properties, size and position but only attributes affectation are resolved 
 at this level, there is no special gtk handling and most of the ccontrol functions should be overwritten to do so.
*******************************************************************************************************************************************/

#ifndef __CCONTROL_H__
#define __CCONTROL_H__

#include "ccomponent.h"
#include "cgraphics.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// ccontrol xml serialization constants
//------------------------------------------------------------------------------------------------------------------------------------------
// <ccontrol [draggable="bool" dropsite="bool"] [x="SInt32" y="SInt32" w="SInt32" h="SInt32"]>
//    ...
// </ccontrol>
//------------------------------------------------------------------------------------------------------------------------------------------
static CString XML_CONTROL_ELEMENT		("ccontrol");
static CString XML_CONTROL_ATTRIBUTE_DRAGGABLE	("draggable");
static CString XML_CONTROL_ATTRIBUTE_DROPSITE	("dropsite");
static CString XML_CONTROL_ATTRIBUTE_X		("x");
static CString XML_CONTROL_ATTRIBUTE_Y		("y");
static CString XML_CONTROL_ATTRIBUTE_W		("w");
static CString XML_CONTROL_ATTRIBUTE_H		("h");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CControl class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CControl : public CComponent
{
	// instanciation section
	public :

		CControl			(CComponent *inOwner, const CObjectListener *inListener=NULL);
		virtual ~CControl		();

	// control logical bounds
	public :

		// control owner's relative size and position
		virtual void			SetBounds		(const TBounds &inBounds);
		virtual TBounds			GetBounds		() const;

	// drag and drop control properties introduction
	public :

		// control draggable properties
		virtual void			SetDraggable		(const Bool inDraggable);
		Bool				GetDraggable		() const;

		// control drop site properties
		virtual void			SetDropSite		(const Bool inDropSite);
		Bool				GetDropSite		() const;
		
		// function that should return a representation of the control (used to handle drag & drop user friendly behaviour)
		virtual CPixbuf *		GetControlPixbuf	() const =0;
		
	// serialization redefinition
	public :

		// ccontrol xml serialization
		virtual void			Serialize		(CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE;

	// protected attributes
	protected :

		// control's owner relative position and size
		TBounds				m_Bounds;

		// control drag and drop properties
		Bool				m_Draggable;
		Bool				m_DropSite;

	// protected serialization behaviour definition
	protected :

		// the control defaults to no serialization handling about the bounds it is concerned about, modify this attribute in the
		// derived definitions if you want your widgets/control to serialize and hold this attribute
		Bool				m_SerializeBounds;

		// the control defaults to handling serialization about drag & drop capabilities; modify this attribute in the derived 
		// definitions if you want your widget/control not to serialize those parameters
		Bool				m_SerializeDnD;

		// ccontrol metaclass association
		SECTION_GENERIC_METACLASS;
};

// class tag and metaclass definition
DECLARE_GENERIC_METACLASS ('ctrl', CControl, CComponent);

#endif
