/***************************************************************************
 *   Copyright (C)                                                         *
 *   2004 Kraschinski Arnold <arnold.kra67@gmx.de>                         *
 *   2005 Michael Goettsche <michael.goettsche@kdemail.net>                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ***************************************************************************/

#ifndef KCLOCK_H
#define KCLOCK_H

#include <qwidget.h>

#include <qpixmap.h>
#include <qsize.h>

#define TIMER_WIDTH          130
#define TIMER_HEIGHT         200

class QTimer;

/** The class belongs to the set of classes which give a feedback to the
    learning person. The timer can be used in two modes. First it can count
    the time the person is learning. That means it is counting upwards. Or
    it can start at with some time and count the remaining time downwards. At
    the end the class emits a signal that the time has expired.
    
    If the time is running the Clock has a QTimer in the member m_timer.
    If the time isn't running the member m_timer is 0
  
    @author Arnold Kraschinski
  */


class KClock : public QWidget
{
Q_OBJECT
public:
    KClock(QWidget *parent = 0, const char *name = 0);

    ~KClock();
    virtual QSize sizeHint() {return QSize(TIMER_WIDTH, TIMER_HEIGHT); };
    
    /** Set the remaining time for the timer. If seconds is 0, the
        timer will count upwards.
      * @param seconds The remaining time.
      */
    void setTimeLeft(int seconds);
    
    /** Returns the number of the seconds until the timeout.
      */
    int timeLeft() { return m_seconds; };
    
    /** Returns if the timer is running
      */
    bool isRunning() { return m_running; };
    
public slots:
    /** Starts the timer.
     */
    void start();
    
    /** Stops the timer.
    */
    void stop();
    
    /** Pauses the timer.
        @param paused Timer is paused if true, else it continues.
    */
    void setPaused(bool paused);
    
protected:
    /** A clock is painted and the time that has elapsed is
      * shown as a segment of a circle
      */
    virtual void paintEvent(QPaintEvent* e);

private slots:
    void slotTimeout();

signals:
    /** The signal will be emitted when the timer starts. This signal
      * can be connected to all the objects that need to know when the 
      * timer starts
      */
    void timerStarted();
    
    /** The signal will be emitted when the timer stops. This signal
      * can be connected to all the objects that need to know when the
      * timer stops
      */    
    void timerStopped();
    
    /** The signal indicates that the timer has counted downwards until 0.
      */
    void timeout();

private:
    QTimer* m_timer;
    bool m_up;
    bool m_running;
    int m_seconds;
    QPixmap m_clockPic;
};

#endif
