/***************************************************************************
           dcobject.cpp  -  Various data objects used in dclib
                             -------------------
    begin                : Thu Aug 21 2008
    copyright            : (C) 2002-2004 by Mathias Küster
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * @author Edward Sheldrake
 *
 * 1. Some functions are way too big to be "inline".
 * 2. Everything with a list or pointer should have a proper copy constructor.
 *
 * So some "inline" code was moved out of dcobject.h to here.
 */

#include "dcobject.h"

/** eveything is set to false */
CMessageSupports::CMessageSupports() : CDCMessage( DC_MESSAGE_SUPPORTS )
{
	m_bBZList    = false;
	m_bSSL       = false;
	m_bChunk     = false;
	m_bMiniSlots = false;
	m_bXMLBZList = false;
	m_bZBlock    = false;
	m_bADCGet    = false;
	m_bTTHL      = false;
	m_bTTHF      = false;
	m_bZLIG      = false;
}

/** */
CMessageSupports::~CMessageSupports()
{
	// nothing
}

/** */
CMessageSupports & CMessageSupports::operator = ( const CMessageSupports & rhs )
{
	m_sContent   = rhs.m_sContent;
	m_bBZList    = rhs.m_bBZList;
	m_bSSL       = rhs.m_bSSL;
	m_bChunk     = rhs.m_bChunk;
	m_bMiniSlots = rhs.m_bMiniSlots;
	m_bXMLBZList = rhs.m_bXMLBZList;
	m_bZBlock    = rhs.m_bZBlock;
	m_bADCGet    = rhs.m_bADCGet;
	m_bTTHL      = rhs.m_bTTHL;
	m_bTTHF      = rhs.m_bTTHF;
	m_bZLIG      = rhs.m_bZLIG;
	return *this;
}

/** */
CMessageNickList::CMessageNickList() : CDCMessage( DC_MESSAGE_NICKLIST )
{
	// nothing
}

/** */
CMessageNickList::CMessageNickList( const CMessageNickList & rhs ) : CDCMessage( DC_MESSAGE_NICKLIST )
{
	CString * it = 0;
	
	/* FIXME remove casting away the const once CList is fixed / removed */
	while ( (it = ((CMessageNickList&)rhs).m_NickList.Next(it)) != 0 )
	{
		m_NickList.Add( new CString(*it) );
	}
}

/** */
CMessageNickList::~CMessageNickList()
{
	// nothing
}

/** */
CMessageNickList & CMessageNickList::operator = (const CMessageNickList & rhs)
{
	m_NickList.Clear();
	
	CString * it = 0;
	
	/* FIXME remove casting away the const once CList is fixed / removed */
	while ( (it = ((CMessageNickList&)rhs).m_NickList.Next(it)) != 0 )
	{
		m_NickList.Add( new CString(*it) );
	}
	
	return *this;
}

/** */
CMessageOpList::CMessageOpList() : CDCMessage( DC_MESSAGE_OPLIST )
{
	// nothing
}

/** */
CMessageOpList::CMessageOpList( const CMessageOpList & rhs ) : CDCMessage( DC_MESSAGE_OPLIST )
{
	CString * it = 0;
	
	/* FIXME remove casting away the const once CList is fixed / removed */
	while ( (it = ((CMessageOpList&)rhs).m_NickList.Next(it)) != 0 )
	{
		m_NickList.Add( new CString(*it) );
	}
}

/** */
CMessageOpList::~CMessageOpList()
{
	// nothing
}

/** */
CMessageOpList & CMessageOpList::operator = (const CMessageOpList & rhs)
{
	m_NickList.Clear();
	
	CString * it = 0;
	
	/* FIXME remove casting away the const once CList is fixed / removed */
	while ( (it = ((CMessageOpList&)rhs).m_NickList.Next(it)) != 0 )
	{
		m_NickList.Add( new CString(*it) );
	}
	
	return *this;
}

/** */
CMessageMyInfo::CMessageMyInfo() : CDCMessage( DC_MESSAGE_MYINFO )
{
	m_nShared        = 0;
	m_eUserSpeed     = eusUNKNOWN;
	m_eAwayMode      = euamNONE;
	m_eClientVersion = eucvNONE;
	m_eClientMode    = ecmNONE;
	m_bValid         = false;
	m_bOperator      = false;
	m_bServerFlag    = false;
	m_bFireballFlag  = false;
	m_bTLSFlag       = false;
}

/** */
CMessageMyInfo::CMessageMyInfo( eDCMessage type ) : CDCMessage( type )
{
	m_nShared        = 0;
	m_eUserSpeed     = eusUNKNOWN;
	m_eAwayMode      = euamNONE;
	m_eClientVersion = eucvNONE;
	m_eClientMode    = ecmNONE;
	m_bValid         = false;
	m_bOperator      = false;
	m_bServerFlag    = false;
	m_bFireballFlag  = false;
	m_bTLSFlag       = false;
}

/** */
CMessageMyInfo::~CMessageMyInfo()
{
	// nothing
}

/** */
CMessageMyInfo & CMessageMyInfo::operator = (const CMessageMyInfo & rhs )
{
	m_MessageLock     = rhs.m_MessageLock;
	m_MessageSupports = rhs.m_MessageSupports;
	
	m_sNick           = rhs.m_sNick;
	m_sComment        = rhs.m_sComment;
	m_sUnknown        = rhs.m_sUnknown;
	m_sUserSpeed      = rhs.m_sUserSpeed;
	m_sEMail          = rhs.m_sEMail;
	m_sVerComment     = rhs.m_sVerComment;
	m_sTransferHost   = rhs.m_sTransferHost;
	
	m_nShared         = rhs.m_nShared;
	
	m_eUserSpeed      = rhs.m_eUserSpeed;
	m_eAwayMode       = rhs.m_eAwayMode;
	m_eClientVersion  = rhs.m_eClientVersion;
	m_eClientMode     = rhs.m_eClientMode;
	
	m_bValid          = rhs.m_bValid;
	m_bOperator       = rhs.m_bOperator;
	m_bServerFlag     = rhs.m_bServerFlag;
	m_bFireballFlag   = rhs.m_bFireballFlag;
	m_bTLSFlag        = rhs.m_bTLSFlag;
	
	return *this;
}

/** */
CMessageDMFileObject::CMessageDMFileObject() : CDCMessage( DC_MESSAGE_FILE_OBJECT )
{
	m_tTimeout           = 0;
	m_eTransferWaitState = etwsWAIT;
	m_nConnections       = 0;
	m_eTransferFileState = etfsNONE;
	m_nSize              = 0;
	m_nStartPosition     = 0;
	m_nCurrentPosition   = 0;
	m_nEndPosition       = 0;
	m_bMulti             = false;
	m_bRemoveFile        = false;
	m_nPriority          = 0;
	m_pDirList           = 0;
}

/** */
CMessageDMFileObject::CMessageDMFileObject( const CMessageDMFileObject & rhs ) : CDCMessage( DC_MESSAGE_FILE_OBJECT )
{
	m_sNick              = rhs.m_sNick;
	m_sHubName           = rhs.m_sHubName;
	m_sHubHost           = rhs.m_sHubHost;
	m_sRemoteFile        = rhs.m_sRemoteFile;
	m_sLocalFile         = rhs.m_sLocalFile;
	m_sTTH               = rhs.m_sTTH;
	m_tTimeout           = rhs.m_tTimeout;
	m_eTransferWaitState = rhs.m_eTransferWaitState;
	m_nConnections       = rhs.m_nConnections;
	m_eTransferFileState = rhs.m_eTransferFileState;
	m_nSize              = rhs.m_nSize;
	m_nStartPosition     = rhs.m_nStartPosition;
	m_nCurrentPosition   = rhs.m_nCurrentPosition;
	m_nEndPosition       = rhs.m_nEndPosition;
	m_nPriority          = rhs.m_nPriority;
	m_bMulti             = rhs.m_bMulti;
	m_bRemoveFile        = rhs.m_bRemoveFile;
	
	if ( rhs.m_pDirList )
	{
		m_pDirList = new std::list<CString>();
		*m_pDirList = *(rhs.m_pDirList);
	}
	else
	{
		m_pDirList = 0;
	}
}

/** */
CMessageDMFileObject::~CMessageDMFileObject()
{
	delete m_pDirList;
	m_pDirList = 0;
}

/** */
CMessageDMFileObject & CMessageDMFileObject::operator = (const CMessageDMFileObject & rhs)
{
	m_sNick              = rhs.m_sNick;
	m_sHubName           = rhs.m_sHubName;
	m_sHubHost           = rhs.m_sHubHost;
	m_sRemoteFile        = rhs.m_sRemoteFile;
	m_sLocalFile         = rhs.m_sLocalFile;
	m_sTTH               = rhs.m_sTTH;
	m_tTimeout           = rhs.m_tTimeout;
	m_eTransferWaitState = rhs.m_eTransferWaitState;
	m_nConnections       = rhs.m_nConnections;
	m_eTransferFileState = rhs.m_eTransferFileState;
	m_nSize              = rhs.m_nSize;
	m_nStartPosition     = rhs.m_nStartPosition;
	m_nCurrentPosition   = rhs.m_nCurrentPosition;
	m_nEndPosition       = rhs.m_nEndPosition;
	m_nPriority          = rhs.m_nPriority;
	m_bMulti             = rhs.m_bMulti;
	m_bRemoveFile        = rhs.m_bRemoveFile;
	
	if ( m_pDirList )
	{
		if ( rhs.m_pDirList )
		{
			*m_pDirList = *(rhs.m_pDirList);
		}
		else
		{
			delete m_pDirList;
			m_pDirList = 0;
		}
	}
	else if ( rhs.m_pDirList )
	{
		m_pDirList = new std::list<CString>();
		*m_pDirList = *(rhs.m_pDirList);
	}

	return *this;
}

/** */
CMessageDMTransferObject::CMessageDMTransferObject() : CDCMessage( DC_MESSAGE_TRANSFER_OBJECT )
{
	m_nTransferID    = 0;
	eState           = estNONE;
	lSize            = 0;
	lSizeDone        = 0;
	lRate            = 0;
	m_nMultiRate     = 0;
	lStartPosition   = 0;
	lTransfered      = 0;
	lEndPosition     = 0;
	bRemoveTransfer  = false;
	m_bEncrypted     = false;
}

/** */
CMessageDMTransferObject::~CMessageDMTransferObject()
{
	// nothing
}

/** */
CMessageDMTransferObject & CMessageDMTransferObject::operator = (const CMessageDMTransferObject & rhs)
{
	m_nTransferID   = rhs.m_nTransferID;
	m_sSrcNick      = rhs.m_sSrcNick;
	m_sDstNick      = rhs.m_sDstNick;
	sHost           = rhs.sHost;
	m_sHubHost      = rhs.m_sHubHost;
	sHubName        = rhs.sHubName;
	m_sDstFile      = rhs.m_sDstFile;
	m_sSrcFile      = rhs.m_sSrcFile;
	m_sTTH          = rhs.m_sTTH;
	eState          = rhs.eState;
	lSize           = rhs.lSize;
	lSizeDone       = rhs.lSizeDone;
	lRate           = rhs.lRate;
	m_nMultiRate    = rhs.m_nMultiRate;
	lStartPosition  = rhs.lStartPosition;
	lTransfered     = rhs.lTransfered;
	lEndPosition    = rhs.lEndPosition;
	bRemoveTransfer = rhs.bRemoveTransfer;
	m_bEncrypted    = rhs.m_bEncrypted;

	return *this;
}

/** */
CMessageDMFileListObject::CMessageDMFileListObject() : CDCMessage( DC_MESSAGE_FILELIST_OBJECT )
{
	m_pDirList = 0;
}

/** */
CMessageDMFileListObject::CMessageDMFileListObject( const CMessageDMFileListObject & rhs ) : CDCMessage( DC_MESSAGE_FILELIST_OBJECT )
{
	sNick      = rhs.sNick;
	sHubName   = rhs.sHubName;
	sHubHost   = rhs.sHubHost;
	sLocalFile = rhs.sLocalFile;
	sJumpTo    = rhs.sJumpTo;
	
	if ( rhs.m_pDirList )
	{
		m_pDirList = new std::list<CString>();
		*m_pDirList = *(rhs.m_pDirList);
	}
	else
	{
		m_pDirList = 0;
	}
}

/** */
CMessageDMFileListObject::~CMessageDMFileListObject()
{
	delete m_pDirList;
	m_pDirList = 0;
}

/** */
CMessageDMFileListObject & CMessageDMFileListObject::operator = (const CMessageDMFileListObject & rhs)
{
	sNick      = rhs.sNick;
	sHubName   = rhs.sHubName;
	sHubHost   = rhs.sHubHost;
	sLocalFile = rhs.sLocalFile;
	sJumpTo    = rhs.sJumpTo;
	
	if ( m_pDirList )
	{
		if ( rhs.m_pDirList )
		{
			*m_pDirList = *(rhs.m_pDirList);
		}
		else
		{
			delete m_pDirList;
			m_pDirList = 0;
		}
	}
	else if ( rhs.m_pDirList )
	{
		m_pDirList = new std::list<CString>();
		*m_pDirList = *(rhs.m_pDirList);
	}
	
	return *this;
}

/** */
CMessageSearchFile::CMessageSearchFile() : CDCMessage( DC_MESSAGE_SEARCH_FILE )
{
	m_nPort       = 0;
	m_eSizeType   = esstATLEAST;
	m_nSize       = 0;
	m_eFileType   = eftUNKNOWN;
	m_bSizeLimit  = false;
	m_bLocal      = false;
	m_bExtended   = false;
	m_bMulti      = false;
}

/** */
CMessageSearchFile::~CMessageSearchFile()
{
	// nothing
}

CMessageSearchFile & CMessageSearchFile::operator = (const CMessageSearchFile & rhs)
{
	m_sString     = rhs.m_sString;
	m_sSource     = rhs.m_sSource;
	m_nPort       = rhs.m_nPort;
	m_eSizeType   = rhs.m_eSizeType;
	m_nSize       = rhs.m_nSize;
	m_eFileType   = rhs.m_eFileType;
	m_bSizeLimit  = rhs.m_bSizeLimit;
	m_bLocal      = rhs.m_bLocal;
	m_bExtended   = rhs.m_bExtended;
	m_bMulti      = rhs.m_bMulti;
	
	return *this;
}
