class MainPage < CKComponent
	attr_accessor :session, :key_for_fetch, :key_for_store, :value_for_store, \
		:key_for_remove, :fetched, :session_item, :item_key, :item_value, \
		:timeout

	def init
		if application.session_id then
			@session = application.session
		end
	end

	def session?
		if @session then
			unless @session.clear? then
				return true
			end
		end
		false
	end

	def session_list
		@session.session if session?
	end

	def create_new_session
		if application.manage_session then
			application.session    = application.create_session
			@session               = application.session
			application.session_id = @session.session_id
			application.save_session @session
		else
			@session               = application.create_session
			application.session_id = @session.session_id
			application.save_session @session
			response.set_redirect application.url
		end
	end

	def clear_session
		if session? then
			if application.manage_session then
				@session.clear
			else
				application.clear_session @session
			end
		end
	end

	def fetch
		if session? then
			@fetched = @session[key_for_fetch]
		end
	end

	def store
		if session? then
			@session[key_for_store] = value_for_store
			application.save_session @session
		end
	end

	def remove
		if session? then
			@session.remove @key_for_remove
			application.save_session @session
		end
	end

	def session_id
		if session? then
			application.session_id
		end
	end

	def session_key
		application.session_key
	end


	def creation_time
		@session.creation_time if session?
	end

	def last_accessed_time
		@session.last_accessed_time if session?
	end

	def timeout
		if session? then
			"#{@session.last_accessed_time + application.timeout}"
		end
	end

	def timeout_second
		application.timeout
	end

	def user_agent
		@session.user_agent if session?
	end

	def remote_addr
		@session.remote_addr if session?
	end

	def session_item=( item )
		@session_item = item
		@item_key     = item[0]
		@item_value   = item[1]
	end

	def keys_values
		if session? then
			str = '{ '
			@session.each { | key, value |
				str << "'#{key}' => '#{value}', "
			}
			str.chop!.chop!
			str << ' }'
			str
		end
	end
end
