// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Xml;
using System.Collections.Generic;

using Anculus.Core;

namespace Anculus.UnitTests
{
	public class EmployeeWageComparer : IPropertyComparer<Employee, double>, IComparer<Employee>
	{
		public int Compare (Employee t, double u)
		{
			return t.Wage.CompareTo (u);
		}
		
		public int Compare (Employee t, Employee u)
		{
			return t.Wage.CompareTo (u.Wage);
		}
	}
	
	public class EmployeeNameComparer : IPropertyComparer<Employee, string>, IComparer<Employee>
	{
		public int Compare (Employee t, string u)
		{
			return t.Name.CompareTo (u);
		}
		
		public int Compare (Employee t, Employee u)
		{
			return t.Name.CompareTo (u.Name);
		}
	}
	
	[Serializable]
	public class Employee
	{
		private string _name;
		internal int _index;
		internal double _wage;
		
		public Employee (int index, string name, double wage)
		{
			Index = index;
			Name = name;
			Wage = wage;
		}
		
		public Employee ()
		{
		}
		
		public string Name
		{
			get { return _name; }
			set { _name = value; }
		}
		
		public int Index
		{
			get { return _index; }
			set { _index = value; }
		}

		public double Wage
		{
			get { return _wage; }
			set { _wage = value; }
		}
	}
}
