// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

using Anculus.Core;

namespace Anculus.Gui
{
	public static class Dispatch
	{
		private static bool _isInitialized;
		private static IDispatcher _guiDispatcher;

		public static void Initialize (IDispatcher guiDispatcher)
		{
			if (guiDispatcher == null)
				throw new ArgumentNullException ("guiDispatcher");
			
			if (_isInitialized) {
				Log.Warn ("Dispatch Utility is already initialized.");
				return;
			}
				
			guiDispatcher.Initialize ();
			Dispatch._guiDispatcher = guiDispatcher;
			_isInitialized = true;
		}

		public static void GuiDispatch (VoidDispatchHandler callback)
		{
			_guiDispatcher.Dispatch (callback);
		}

		public static void GuiDispatch (ObjectDispatchHandler callback, object obj)
		{
			_guiDispatcher.Dispatch (callback, obj);
		}

		public static void GuiSyncDispatch (VoidDispatchHandler callback)
		{
			_guiDispatcher.SyncDispatch (callback);
		}

		public static void GuiSyncDispatch (ObjectDispatchHandler callback, object obj)
		{
			_guiDispatcher.SyncDispatch (callback, obj);
		}
	}
}
