// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

namespace Anculus.Core
{
	public abstract class AbstractSearchAlgorithm : ISearchAlgorithm
	{
		public virtual int[] SearchAll (string text, string keyword)
		{
			return SearchAll (text, 0, int.MaxValue, keyword);
		}

		public virtual int[] SearchAll (string text, int start, string keyword)
		{
			return SearchAll (text, start, int.MaxValue, keyword);
		}

		public abstract int[] SearchAll (string text, int start, int count, string keyword);

		public virtual int SearchFirst (string text, string keyword)
		{
			return SearchFirst (text, 0, keyword);
		}

		public abstract int SearchFirst (string text, int start, string keyword);

		public virtual bool Contains (string text, string keyword)
		{
			return Contains (text, 0, keyword);
		}

		public virtual bool Contains (string text, int start, string keyword)
		{
			return SearchFirst (text, start, keyword) >= 0;
		}
		
		[System.Diagnostics.DebuggerHidden]
		protected static void CheckArguments (string text, string keyword)
		{
			if (text == null)
				throw new ArgumentNullException ("text");
			if (text.Length == 0)
				throw new ArgumentException ("text");
			if (keyword == null)
				throw new ArgumentNullException ("keyword");
			if (keyword.Length == 0)
				throw new ArgumentException ("keyword");
		}
		
		[System.Diagnostics.DebuggerHidden]
		protected static void CheckArguments (string text, int start, int count, string keyword)
		{
			CheckArguments (text, keyword);
			
			if (start < 0)
				throw new ArgumentOutOfRangeException ("start");
			if (start >= text.Length)
				throw new ArgumentOutOfRangeException ("start");
			
			if (count <= 0)
				throw new ArgumentOutOfRangeException ("count");
		}
	}
}