// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

namespace Anculus.Core
{
	public class ConsoleLogBackend : ILogBackend, IEquatable<ConsoleLogBackend>
	{
		private object _sync = new object ();
		
		public void Log (string timestamp, LogLevel level, string logger, object message, Exception ex)
		{
			lock (_sync) {
				Console.Write (timestamp);
				
				switch (level)
				{
					case LogLevel.Debug:
						Console.Write (" [DEBUG] ");
						break;
					case LogLevel.Info:
						Console.Write (" [INFO] ");
						break;
					case LogLevel.Warning:
						Console.Write (" [WARNING] ");
						break;
					case LogLevel.Error:
						Console.Write (" [ERROR] ");
						break;
					case LogLevel.Fatal:
						Console.Write (" [FATAL] ");
						break;
				}
				
				if (logger != null) {
					Console.Write ("[");
					Console.Write (logger);
					Console.Write ("] ");
				}
	
				if (message != null)
					Console.WriteLine (message.ToString ());
				else
					Console.WriteLine ();
	
				if (ex != null)
				{
					Console.WriteLine (ex.Message);
					Console.WriteLine (ex.StackTrace);
	
					if (ex.InnerException != null) {
						Console.WriteLine (ex.InnerException.Message);
						Console.WriteLine (ex.InnerException.StackTrace);
					}
				}
			}
		}
		
		public override bool Equals (object obj)
		{
			if (obj == null)
				return false;
			
			return obj is ConsoleLogBackend;
		}
		
		public bool Equals (ConsoleLogBackend other)
		{
			return true;
		}
		
		public override int GetHashCode ()
		{
			return typeof (ConsoleLogBackend).GetHashCode ();
		}
	}
}