/*
 * dstore.c - SCO global storage for lsof
 *
 * V. Abell
 * Purdue University Computing Center
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.6 99/11/10 15:01:14 abe Exp $";
#endif


#include "lslk.h"


/*
 * Local global variables
 */

int Kd = -1;				/* the kvm descriptor */
int nxdevmaps = -1;			/* maximum kernel xdevmap[] index */

struct nlist Nl[] = {			/* kernel name list entries */
	{ "hinode",		0, 0, 0, 0, 0 },

#if	defined(HAS_NFS)
# if	OSRV<500
	{ "lockd_server",	0, 0, 0, 0, 0 },
# else	/* OSRV>=500 */
	{ "lock_srvq",		0, 0, 0, 0, 0 },
# endif	/* OSRV<500 */
#endif	/* defined(HAS_NFS) */

	{ "nxdevmaps",		0, 0, 0, 0, 0 },
	{ "proc",		0, 0, 0, 0, 0 },
	{ "v",			0, 0, 0, 0, 0 },
	{ "xdevmap",		0, 0, 0, 0, 0 },

#if	OSRV>=500
	{ "scoutsname",		0, 0, 0, 0, 0 },	/* *MUST* be last */
#endif	/* OSRV>=500 */
	{ "" 		}
};

struct XDEVMAP *Xdevmap;		/* dynamically allocated xdevmap[] */
