/*
 * dmnt.c -- SCO mount functions for lslk
 *
 * V. Abell
 * Purdue University Computing Center
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.2 99/11/10 15:01:11 abe Exp $";
#endif


#include "lslk.h"


/*
 * readmnt() - read mount table
 */

int
readmnt()

{
	int br, fd, na;
	int bx = sizeof(struct mnttab);
	char *cp;
	struct mnttab m;
	char mntp[MAXPATHLEN], sp[MAXPATHLEN];
 	MALLOC_S mntpnml, spnml;
	int err = 0;
	MALLOC_S len;
	char *ln = (char *)NULL;
	struct stat sb;
/*
 * Open access to the mount table.
 */
	if ((fd = open(MNTTAB, O_RDONLY, 0)) < 0) {
	    (void) fprintf(stderr, "%s: can't open %s\n", Pn, MNTTAB);
	    return(1);
	}
/*
 * Read the first mount table entry.
 */
	br = read(fd, (char *)&m, bx);
	na = mntpnml = spnml = 0;
/*
 * Process the next complete mount table entry.
 */
	while (br == bx) {
	    if (mntpnml == 0) {

	    /*
	     * Start the device and file system name assemblies.
	     */
		mntpnml = strlen(m.mt_dev);
		if (mntpnml >= MAXPATHLEN)
		    mntpnml = MAXPATHLEN - 1;
		(void) strncpy(mntp, m.mt_dev, mntpnml);
		mntp[mntpnml] = '\0';
		spnml = strlen(m.mt_filsys);
		if (spnml >= MAXPATHLEN)
		    spnml = MAXPATHLEN - 1;
		(void) strncpy(sp, m.mt_filsys, spnml);
		sp[spnml] = '\0';
	    }
	    while ((br = read(fd, (char *)&m, bx)) == bx
	    &&      strcmp(m.mt_filsys, "nothing") == 0
	    &&	    strcmp(m.mt_dev,    "nowhere") == 0) {

	    /*
	     * Add the "nothing/nowhere" extensions to the assemblies.
	     */
		len = strlen(&m.mt_dev[8]);
		if (len >= (MAXPATHLEN - mntpnml))
		    len = MAXPATHLEN - mntpnml - 1;
		if (len) {
		    (void) strncpy(&mntp[mntpnml], &m.mt_dev[8], len);
		    mntpnml += len;
		    mntp[mntpnml] = '\0';
		}
		len = strlen(&m.mt_filsys[8]);
		if (len >= (MAXPATHLEN - spnml))
		    len = MAXPATHLEN - spnml - 1;
		if (len) {
		    (void) strncpy(&sp[spnml], &m.mt_filsys[8], len);
		    spnml += len;
		    sp[spnml] = '\0';
		}
	    }
	/*
	 * Skip automount place markers.
	 */
	    if (mntp[0] != '/'
	    ||  ((cp = strrchr(mntp, ':')) != (char *)NULL
	    &&    strncmp(cp, ":(pid", 5) == 0))
	    {
		mntpnml = spnml = 0;
		continue;
	    }
	/*
	 * Interpolate a possible symbolic directory link.
	 */
	    if (ln) {
		(void) free((MALLOC_P *)ln);
		ln = (char *)NULL;
	    }
	    if ((ln = Readlink(sp)) == (char *)NULL) {
		if (Owarn){
		    (void) fprintf(stderr,
			"      Output information may be incomplete.\n");
		}
		err = 2;
		mntpnml = spnml = 0;
		continue;
	    }
	    if (ln == sp) {

	    /*
	     * Allocate space for a copy of the file system name.
	     */
		if ((ln = (char *)malloc(spnml + 1)) == NULL) {
		    err = 1;
		    break;
		}
		(void) strcpy(ln, sp);
	    }
	/*
	 * Stat() the directory.
	 */
	    if (statsafely(ln, &sb)) {
		if (Owarn) {
		    (void) fprintf(stderr,
			"%s: WARNING: can't stat() file system %s\n", Pn, sp);
		    (void) fprintf(stderr,
			"      Output information may be incomplete.\n");
		}
		err = 2;
		mntpnml = spnml = 0;
		continue;
	    }
	/*
	 * See if there's room in the local mount table for another entry.
	 */
	    if (NMnt >= na) {

	    /*
	     * Increase the space allocated to the local mount table and
	     * reserve space for the increase.
	     */
		na += 10;
		len = (MALLOC_S)(na * sizeof(struct mounts));
		if (Mnt)
		    Mnt = (struct mounts *)realloc((MALLOC_P *)Mnt, len);
		else
		    Mnt = (struct mounts *)malloc(len);
		if (!Mnt) {
		    (void) fprintf(stderr,
			"%s: no space for %d mount structures at %s: %s\n",
			Pn, na, mntp, sp);
		    (void) close(fd);
		    Exit(1);
		}
	    }
	/*
	 * Allocate space for what's been mounted (sp) and where it's been
	 * mounted (mntp).
	 */
	    if ((Mnt[NMnt].mntp = (char *)malloc(mntpnml + 1)) == (char *)NULL)
	    {
		err = 1;
		break;
	    }
	    Mnt[NMnt].dev = sb.st_dev;
	    (void) strcpy(Mnt[NMnt].mntp, mntp);
	    Mnt[NMnt].sp = ln;
	    ln = (char *)NULL;
	    Mnt[NMnt++].priv = (char *)NULL;
	    mntpnml = spnml = 0;
	}
	(void) close(fd);
	if (ln) {
	    (void) free((MALLOC_P *)ln);
	    ln = (char *)NULL;
	}
/*
 * Handle errors.
 */
	switch (err) {
	case 1:
	    (void) fprintf(stderr, "%s: no space for mount at %s (%s)\n",
		Pn, sp, mntp);
	    return(1);
	case 2:
	    return(0);
	}
	return(0);
}
