###
### $Rev: 51 $
### $Release: 0.6.1 $
### copyright(c) 2005 kuwata-lab all rights reserved.
###

require File.dirname(__FILE__) + '/test.rb'


class Hash

   def inspect
      buf = [ '{' ]
      self.keys.sort_by { |k| k.to_s }.each_with_index do |key, i|
         buf << ', ' if i > 0
         buf << key.inspect << '=>' << self[key].inspect
      end
      buf << '}'
      return buf.join
   end

end


class YamlParserTest < Test::Unit::TestCase

   filename = __FILE__.sub(/\.rb$/, '.yaml')
   load_yaml_testdata(filename, :lang=>'ruby')

   def _test()
      @error_class = Kwalify.const_get(@exception) if @exception
      parser = Kwalify::YamlParser.new(@input)
      if @error_class
         assert_raise(@error_class) do
            doc = parser.parse()
         end
      else
         doc = parser.parse()
         if @recursive || @pp
            s = StringWriter.new
            PP.pp(doc, s)
            actual = s
         else
            actual = doc.inspect + "\n"
         end
         if $log
            File.open("#{@name}.expected", 'w') { |f| f.write(@expected) }
            File.open("#{@name}.actual", 'w') { |f| f.write(actual) }
         end
         if $print
            print actual
         else
            assert_text_equal(@expected, actual)
         end
      end
   end

end
