/***************************************************************************
                          filterlist.cpp  -  description
                             -------------------
    begin                : Wed Sep 25 2003
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include "filterlist.h"

FilterList::FilterList()
{
	setAutoDelete (true);
}

FilterList::~FilterList()
{
}

void FilterList::setCombo (QComboBox* combo, int nIndex)
{
	combo->clear ();
	for (FilterElem* pElem = first(); pElem; pElem = next())
	{
		combo->insertItem (pElem->toString());
	}
	if (nIndex >= 0)
	{
		at (nIndex);
		combo->setCurrentItem (nIndex);
	}
}

FilterList& FilterList::operator = (FilterList& list)
{
	clear ();
	int nIndex = list.at ();
	for (FilterElem* item = list.first (); item; item = list.next ())
	{
		inSort (new FilterElem (*item));
	}
	at (nIndex);
	return *this;
}

QCollection::Item FilterList::newItem (QCollection::Item d)
{
	return new FilterElem (*(FilterElem*)d);
}

int FilterList::compareItems (QCollection::Item item1, QCollection::Item item2 )
{
	FilterElem* entry1 = (FilterElem*) item1;
	FilterElem* entry2 = (FilterElem*) item2;

  // we sort the high counters first !
  if (entry1->getCounter() < entry2->getCounter())
    return 1;
  else if (entry1->getCounter() == entry2->getCounter())
  {
    // for equal counters, we sort alphabetical
    if (entry1->toString() > entry2->toString())
		  return 1;
	  else if (entry1->toString() == entry2->toString())
		  return 0;
    else
      return -1;
  }
	else return -1;
}

void FilterList::readOptions (KConfig* config)
{
	bool goon = true;
	int i = 0;
	while (goon)
	{
  	config->setGroup (QString("filter%1").arg(i));
		QString name (config->readEntry ("name"));
		if (!name.isEmpty ())
		{
      unsigned int counter = config->readNumEntry ("counter");
      FilterRecord::filterType type = (FilterRecord::filterType)config->readNumEntry ("type1");
			FilterRecord::expressionType expr = (FilterRecord::expressionType)config->readNumEntry ("expression1");
      QString match = config->readEntry ("match1");
      bool caseSensitive = (bool)config->readNumEntry ("casesensitive1", 0);
      bool regExp = (bool)config->readNumEntry ("regexp1", 0);

      FilterElem* filter = new FilterElem (FilterRecord(type, expr, match, caseSensitive, regExp));
      filter->setCounter( counter );

      FilterElem::secondCondition secondCondition = (FilterElem::secondCondition)config->readNumEntry ("secondcondition");
      type = (FilterRecord::filterType)config->readNumEntry ("type2");
			expr = (FilterRecord::expressionType)config->readNumEntry ("expression2");
      match = config->readEntry ("match2");
      caseSensitive = (bool)config->readNumEntry ("casesensitive2", 0);
      regExp = (bool)config->readNumEntry ("regexp2", 0);

      filter->setSecondCondition(secondCondition, FilterRecord (type, expr, match, caseSensitive, regExp));

      inSort (filter);
			i++;
		}
		else
			goon = false;
	}
	if (i > 0)
		at (0);
  sort ();
}

void FilterList::saveOptions (KConfig* config)
{
  //at first we remove all filter setups from the config
  int filterNumber = 0;     //number of deleted filter
  bool ready = false;       //TRUE - all filters are deleted

  while( !ready ) //loop until the last filter setup was removed (ready == true)
  {
    //do we have a setup with the current number (filterNumber) ?
    if( config->hasGroup( QString( CONFIG_GROUP_FILTER ) + QString( "%1" ).arg( filterNumber ) ) )
    {
      //remove group
      config->deleteGroup( QString( CONFIG_GROUP_FILTER ) + QString( "%1" ).arg( filterNumber ) );

      //process next filter
      filterNumber++;
    }
    else
      ready = true;
  }

  //now we write the configured filters into the config
	kdDebug () << "FilterList::saveOptions" << endl;
	for (unsigned int i = 0; i < count (); i++)
	{
  	config->setGroup (QString ("filter%1").arg(i));
		config->writeEntry ("name", at(i)->toString());
    config->writeEntry ("counter", at(i)->getCounter() );

    config->writeEntry ("type1", at(i)->_filter1._type);
		config->writeEntry ("expression1", at(i)->_filter1._expression);
		config->writeEntry ("match1", at(i)->_filter1._match);
    config->writeEntry ("casesensitive1", at(i)->_filter1._CaseSensitive);
    config->writeEntry ("regexp1", at(i)->_filter1._RegExp);

    config->writeEntry ("secondcondition", at(i)->_secondCondition);

    config->writeEntry ("type2", at(i)->_filter2._type);
		config->writeEntry ("expression2", at(i)->_filter2._expression);
		config->writeEntry ("match2", at(i)->_filter2._match);
    config->writeEntry ("casesensitive2", at(i)->_filter2._CaseSensitive);
    config->writeEntry ("regexp2", at(i)->_filter2._RegExp);
	}
}
