/***************************************************************************
                          filterentrydialog.cpp  -  description
                             -------------------
    begin                : Mit Sep 24 2003
    copyright            : (C) 2003 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qvalidator.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qspinbox.h>
#include <qpushbutton.h>

#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kregexpeditorinterface.h>
#include <kparts/part.h>
#include <kparts/componentfactory.h>

#include "filterelem.h"
#include "filterentrydialog.h"

FilterEntryDialog::FilterEntryDialog(QWidget *parent, const char *name, FilterElem* elem ) :
FilterEntryDlg(parent,name), _elem (elem)
{
  _editName->setText (elem->toString());

  _comboItem1->setCurrentItem (elem->_filter1._type);
  _comboExpression1->setCurrentItem (elem->_filter1._expression);
  _editMatch1->setText (elem->_filter1._match);
  _checkCaseSensitive1->setChecked (elem->_filter1._CaseSensitive);
  _checkRegExp1->setChecked (elem->_filter1._RegExp);

  _comboSecondCondition->setCurrentItem (elem->_secondCondition);

  _comboItem2->setCurrentItem (elem->_filter2._type);
  _comboExpression2->setCurrentItem (elem->_filter2._expression);
  _editMatch2->setText (elem->_filter2._match);
  _checkCaseSensitive2->setChecked (elem->_filter2._CaseSensitive);
  _checkRegExp2->setChecked (elem->_filter2._RegExp);
  _spinCounter->setValue (elem->getCounter() );

  slotItem1Selected (elem->_filter1._type);
  slotItem2Selected (elem->_filter2._type);
  slotSecondCondition (_elem->_secondCondition);

  if (KTrader::self()->query("KRegExpEditor/KRegExpEditor").isEmpty())
  {
    _buttonEditRegExp1->hide();
    _buttonEditRegExp2->hide();
  }
  else
  {
    _buttonEditRegExp1->setEnabled (elem->_filter1._RegExp);
    _buttonEditRegExp2->setEnabled (elem->_filter2._RegExp);
  }
}

FilterEntryDialog::~FilterEntryDialog()
{
}

void FilterEntryDialog::slotOk ()
{
  if (_editMatch1->text().isEmpty() ||
     (((FilterElem::secondCondition)_comboSecondCondition->currentItem() != FilterElem::noSecondCondition) &&
      _editMatch2->text().isEmpty()))
  {
    KMessageBox::sorry (this, i18n("Your conditions contain empty match strings.\n"
                                   "This will not work."));
    return;
  }

  if (_elem->_filter1._RegExp)
  {
    QRegExp exp (_elem->_filter1._match);
    if (!exp.isValid())
    {
      KMessageBox::sorry (this, i18n ("Condition") + ":\n" + exp.errorString());
      return;
    }
  }
  if (_elem->_secondCondition && _elem->_filter2._RegExp)
  {
    QRegExp exp (_elem->_filter2._match);
    if (!exp.isValid())
    {
      KMessageBox::sorry (this, i18n ("second Condition") + ":\n" + exp.errorString());
      return;
    }
  }

  _elem->_filter1._CaseSensitive = _checkCaseSensitive1->isChecked();
  _elem->_filter2._CaseSensitive = _checkCaseSensitive2->isChecked();
  _elem->_filter1._RegExp = _checkRegExp1->isChecked();
  _elem->_filter2._RegExp = _checkRegExp2->isChecked();

  accept ();
}

void FilterEntryDialog::slotItem1Selected (int type)
{
  if (type == FilterRecord::size)
  {
    int dummy;
    QString match (_editMatch1->text());
    QIntValidator* validator = new QIntValidator (_editMatch1);
    if (validator->validate (match, dummy) == QValidator::Invalid)
      _editMatch1->clear();
    _editMatch1->setValidator (validator);
    _checkCaseSensitive1->setEnabled (false);
  }
  else
  {
    _editMatch1->setValidator (NULL);
    _checkCaseSensitive1->setEnabled (true);
  }

  _elem->_filter1._type = (FilterRecord::filterType)type;
  _editName->setText (_elem->toString());
}

void FilterEntryDialog::slotItem2Selected (int type)
{
  if (type == FilterRecord::size)
  {
    int dummy;
    QString match (_editMatch2->text());
    QIntValidator* validator = new QIntValidator (_editMatch2);
    if (validator->validate (match, dummy) == QValidator::Invalid)
      _editMatch2->clear();
    _editMatch2->setValidator (validator);
    _checkCaseSensitive2->setEnabled (false);
  }
  else
  {
    _editMatch2->setValidator (NULL);
    _checkCaseSensitive2->setEnabled (true);
  }

  _elem->_filter2._type = (FilterRecord::filterType)type;
  _editName->setText (_elem->toString());
}

void FilterEntryDialog::slotSecondCondition (int condition)
{
  if (condition == FilterElem::noSecondCondition)
    _groupBox2->setEnabled(false);
  else
    _groupBox2->setEnabled(true);

  _elem->_secondCondition = (FilterElem::secondCondition)condition;
  _editName->setText (_elem->toString());
}

void FilterEntryDialog::slotCondition1Selected(int cond)
{
  _elem->_filter1._expression = (FilterRecord::expressionType)cond;
  _editName->setText (_elem->toString());
}

void FilterEntryDialog::slotCondition2Selected(int cond)
{
  _elem->_filter2._expression = (FilterRecord::expressionType)cond;
  _editName->setText (_elem->toString());
}

void FilterEntryDialog::slotMatch1Changed(const QString& match)
{
  _elem->_filter1._match = match;
  _editName->setText (_elem->toString());
}

void FilterEntryDialog::slotMatch2Changed(const QString& match)
{
  _elem->_filter2._match = match;
  _editName->setText (_elem->toString());
}

void FilterEntryDialog::slotResetCounter()
{
  _spinCounter->setValue(0);
}

void FilterEntryDialog::slotCounterChanged (int val)
{
  _elem->setCounter( val );
  _editName->setText (_elem->toString());
}

void FilterEntryDialog::slotEditRegExp1()
{
  QDialog *editorDialog = KParts::ComponentFactory::createInstanceFromQuery<QDialog>( "KRegExpEditor/KRegExpEditor" );
  if ( editorDialog )
  {
    // kdeutils was installed, so the dialog was found fetch the editor interface
    KRegExpEditorInterface *editor = static_cast<KRegExpEditorInterface *>( editorDialog->qt_cast( "KRegExpEditorInterface" ) );
    Q_ASSERT( editor ); // This should not fail!

    // now use the editor.
    editor->setRegExp(_editMatch1->text());

    // Finally exec the dialog
    if (editorDialog->exec() == QDialog::Accepted)
      _editMatch1->setText (editor->regExp());
  }
}

void FilterEntryDialog::slotEditRegExp2()
{
  QDialog *editorDialog = KParts::ComponentFactory::createInstanceFromQuery<QDialog>( "KRegExpEditor/KRegExpEditor" );
  if ( editorDialog )
  {
    // kdeutils was installed, so the dialog was found fetch the editor interface
    KRegExpEditorInterface *editor = static_cast<KRegExpEditorInterface *>( editorDialog->qt_cast( "KRegExpEditorInterface" ) );
    Q_ASSERT( editor ); // This should not fail!

    // now use the editor.
    editor->setRegExp(_editMatch2->text());

    // Finally exec the dialog
    if (editorDialog->exec() == QDialog::Accepted)
      _editMatch2->setText (editor->regExp());
  }
}

void FilterEntryDialog::slotToggleRegExp1 (bool on)
{
  _buttonEditRegExp1->setEnabled (on);
}

void FilterEntryDialog::slotToggleRegExp2 (bool on)
{
  _buttonEditRegExp2->setEnabled (on);
}


