/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "streamripper_base.h"
#include "settings_general.h"

streamripper_base::streamripper_base(QObject *parent) : console_reader(parent)
{
  internal_index = 0;
}

streamripper_base::streamripper_base(QObject *parent, const qlonglong index)
  : console_reader(parent)
{
  setIndex(index);  // better than setting internal_index directly.
                    // And we don't have to worry about signals
                    // that are emitted because this is the constructur - so there
                    // won't be any slot connected
                    // to them.
}

streamripper_base::~streamripper_base()
{
}

qlonglong streamripper_base::index() const
{
  return internal_index;
}

void streamripper_base::setIndex(const qlonglong index)
{
  if (internal_index != index) {
    internal_index=index;
    emit indexChanged(index);
  };
}

void streamripper_base::startStreamripper()
{
  QStringList command_line;
  command_line.append(streamripperCommand());
  command_line += parameterList();
  m_process.setProgram(command_line); //prepare KProcess
  m_process.clearEnvironment();       // (almost) all environment variables are cleard. We
  // don't want that strange, undefined things will happen with streamripper...
  m_process.start();                  //call streamripper
}

void streamripper_base::abortStreamripper()
{
  m_process.kill();              // sends the SIGKILL signal
  m_process.waitForFinished(-1);   // we have to wait until the process really is finished
}
